﻿using Serilog;
using Serilog.Core;
using Serilog.Exceptions;
using Wino.Core.Domain.Interfaces;

namespace Wino.Services
{
    public class LogInitializer : ILogInitializer
    {
        private readonly LoggingLevelSwitch _levelSwitch = new LoggingLevelSwitch();
        private readonly IPreferencesService _preferencesService;

        public LogInitializer(IPreferencesService preferencesService)
        {
            _preferencesService = preferencesService;

            RefreshLoggingLevel();
        }

        public void RefreshLoggingLevel()
        {
#if DEBUG
            _levelSwitch.MinimumLevel = Serilog.Events.LogEventLevel.Debug;
#else
            _levelSwitch.MinimumLevel = _preferencesService.IsLoggingEnabled ? Serilog.Events.LogEventLevel.Information : Serilog.Events.LogEventLevel.Fatal;
#endif
        }

        public void SetupLogger(string fullLogFilePath)
        {
            Log.Logger = new LoggerConfiguration()
                        .MinimumLevel.ControlledBy(_levelSwitch)
                        .WriteTo.File(fullLogFilePath, retainedFileCountLimit: 3, rollOnFileSizeLimit: true, rollingInterval: RollingInterval.Day)
                        .WriteTo.Debug()
                        .Enrich.FromLogContext()
                        .Enrich.WithExceptionDetails()
                        .CreateLogger();
        }
    }
}
