﻿using System.Collections.Generic;
using Wino.Core.Domain;
using Wino.Core.Domain.Enums;
using Wino.Core.Domain.Interfaces;
using Wino.Core.Domain.Models.Settings;

namespace Wino.Services
{
    public class SettingsBuilderService : ISettingsBuilderService
    {
        public List<SettingOption> GetSettingItems()
            => new List<SettingOption>()
            {
                new SettingOption(Translator.SettingsManageAccountSettings_Title, Translator.SettingsManageAccountSettings_Description, WinoPage.AccountManagementPage,"F1 M 3.75 5 L 3.75 4.902344 C 3.75 4.225262 3.885091 3.588867 4.155273 2.993164 C 4.425456 2.397461 4.790039 1.878256 5.249023 1.435547 C 5.708008 0.99284 6.238606 0.642904 6.84082 0.385742 C 7.443034 0.128582 8.079427 0 8.75 0 C 9.420572 0 10.056966 0.128582 10.65918 0.385742 C 11.261393 0.642904 11.791992 0.99284 12.250977 1.435547 C 12.709961 1.878256 13.074544 2.397461 13.344727 2.993164 C 13.614908 3.588867 13.75 4.225262 13.75 4.902344 C 13.75 5.397137 13.689778 5.87077 13.569336 6.323242 C 13.448893 6.775717 13.258463 7.213542 12.998047 7.636719 C 12.229817 7.799479 11.510416 8.079428 10.839844 8.476562 C 10.169271 8.873698 9.583333 9.378256 9.082031 9.990234 C 9.042969 9.996745 9.005533 10 8.969727 10 C 8.933919 10 8.899739 10 8.867188 10 L 8.652344 10 C 7.97526 10 7.338867 9.864909 6.743164 9.594727 C 6.147461 9.324545 5.628255 8.959961 5.185547 8.500977 C 4.742838 8.041993 4.392903 7.511395 4.135742 6.90918 C 3.878581 6.306967 3.75 5.670573 3.75 5 Z M 12.5 5 L 12.5 4.921875 C 12.5 4.414062 12.399088 3.937176 12.197266 3.491211 C 11.995442 3.045248 11.722005 2.65625 11.376953 2.324219 C 11.0319 1.992188 10.633138 1.730145 10.180664 1.538086 C 9.728189 1.346029 9.251302 1.25 8.75 1.25 C 8.229166 1.25 7.740885 1.347656 7.285156 1.542969 C 6.829427 1.738281 6.432292 2.005209 6.09375 2.34375 C 5.755208 2.682293 5.488281 3.079428 5.292969 3.535156 C 5.097656 3.990887 5 4.479167 5 5 C 5 5.520834 5.097656 6.009115 5.292969 6.464844 C 5.488281 6.920573 5.755208 7.317709 6.09375 7.65625 C 6.432292 7.994792 6.829427 8.261719 7.285156 8.457031 C 7.740885 8.652344 8.229166 8.75 8.75 8.75 C 9.270833 8.75 9.759114 8.652344 10.214844 8.457031 C 10.670572 8.261719 11.067708 7.994792 11.40625 7.65625 C 11.744791 7.317709 12.011719 6.920573 12.207031 6.464844 C 12.402344 6.009115 12.5 5.520834 12.5 5 Z M 12.148438 19.365234 C 11.777344 19.208984 11.41276 19.010416 11.054688 18.769531 C 11.113281 18.561197 11.170247 18.357748 11.225586 18.15918 C 11.280924 17.960611 11.308594 17.753906 11.308594 17.539062 C 11.308594 17.252604 11.259766 16.977539 11.162109 16.713867 C 11.064453 16.450195 10.930989 16.210938 10.761719 15.996094 C 10.592447 15.78125 10.390625 15.597331 10.15625 15.444336 C 9.921875 15.291342 9.664713 15.182292 9.384766 15.117188 L 8.779297 14.980469 C 8.759766 14.778646 8.75 14.576823 8.75 14.375 C 8.75 14.179688 8.759766 13.977865 8.779297 13.769531 L 9.384766 13.632812 C 9.664713 13.567709 9.921875 13.458659 10.15625 13.305664 C 10.390625 13.15267 10.592447 12.96875 10.761719 12.753906 C 10.930989 12.539062 11.064453 12.299805 11.162109 12.036133 C 11.259766 11.772461 11.308594 11.497396 11.308594 11.210938 C 11.308594 10.996094 11.280924 10.789389 11.225586 10.59082 C 11.170247 10.392253 11.113281 10.188803 11.054688 9.980469 C 11.41276 9.739584 11.777344 9.541016 12.148438 9.384766 C 12.324219 9.560547 12.488606 9.720053 12.641602 9.863281 C 12.794596 10.006511 12.957356 10.131836 13.129883 10.239258 C 13.302408 10.34668 13.487955 10.429688 13.686523 10.488281 C 13.885091 10.546875 14.114583 10.576172 14.375 10.576172 C 14.635416 10.576172 14.866535 10.546875 15.068359 10.488281 C 15.270182 10.429688 15.455729 10.34668 15.625 10.239258 C 15.79427 10.131836 15.955402 10.006511 16.108398 9.863281 C 16.261393 9.720053 16.425781 9.560547 16.601562 9.384766 C 16.972656 9.541016 17.337238 9.739584 17.695312 9.980469 C 17.636719 10.188803 17.579752 10.392253 17.524414 10.59082 C 17.469074 10.789389 17.441406 10.996094 17.441406 11.210938 C 17.441406 11.497396 17.488605 11.772461 17.583008 12.036133 C 17.677408 12.299805 17.810871 12.539062 17.983398 12.753906 C 18.155924 12.96875 18.359375 13.15267 18.59375 13.305664 C 18.828125 13.458659 19.085285 13.567709 19.365234 13.632812 L 19.970703 13.769531 C 19.990234 13.977865 20 14.179688 20 14.375 C 20 14.576823 19.990234 14.778646 19.970703 14.980469 L 19.365234 15.117188 C 19.085285 15.182292 18.828125 15.291342 18.59375 15.444336 C 18.359375 15.597331 18.155924 15.78125 17.983398 15.996094 C 17.810871 16.210938 17.677408 16.450195 17.583008 16.713867 C 17.488605 16.977539 17.441406 17.252604 17.441406 17.539062 C 17.441406 17.753906 17.469074 17.960611 17.524414 18.15918 C 17.579752 18.357748 17.636719 18.561197 17.695312 18.769531 C 17.337238 19.010416 16.972656 19.208984 16.601562 19.365234 C 16.425781 19.189453 16.261393 19.029947 16.108398 18.886719 C 15.955402 18.74349 15.79427 18.618164 15.625 18.510742 C 15.455729 18.40332 15.270182 18.320312 15.068359 18.261719 C 14.866535 18.203125 14.635416 18.173828 14.375 18.173828 C 14.108072 18.173828 13.875324 18.203125 13.676758 18.261719 C 13.478189 18.320312 13.294271 18.40332 13.125 18.510742 C 12.955729 18.618164 12.794596 18.74349 12.641602 18.886719 C 12.488606 19.029947 12.324219 19.189453 12.148438 19.365234 Z M 0 13.75 C 0 13.404948 0.065104 13.081055 0.195312 12.77832 C 0.325521 12.475586 0.504557 12.210287 0.732422 11.982422 C 0.960286 11.754558 1.225586 11.575521 1.52832 11.445312 C 1.831055 11.315104 2.154948 11.25 2.5 11.25 L 8.251953 11.25 C 8.043619 11.660156 7.880859 12.076823 7.763672 12.5 L 2.5 12.5 C 2.324219 12.5 2.159831 12.532553 2.006836 12.597656 C 1.853841 12.662761 1.722005 12.750651 1.611328 12.861328 C 1.500651 12.972006 1.41276 13.103842 1.347656 13.256836 C 1.282552 13.409831 1.25 13.574219 1.25 13.75 C 1.25 14.420573 1.360677 15.008139 1.582031 15.512695 C 1.803385 16.017252 2.102865 16.455078 2.480469 16.826172 C 2.858073 17.197266 3.297526 17.50651 3.798828 17.753906 C 4.30013 18.001303 4.827474 18.198242 5.380859 18.344727 C 5.934244 18.491211 6.50065 18.595377 7.080078 18.657227 C 7.659505 18.719076 8.216146 18.75 8.75 18.75 L 9.072266 18.75 C 9.449869 19.199219 9.866536 19.5931 10.322266 19.931641 C 10.061849 19.964193 9.801432 19.983725 9.541016 19.990234 C 9.280599 19.996744 9.016927 20 8.75 20 C 8.190104 20 7.618814 19.973959 7.036133 19.921875 C 6.45345 19.869791 5.878906 19.775391 5.3125 19.638672 C 4.746094 19.501953 4.197591 19.319662 3.666992 19.091797 C 3.136393 18.863932 2.646484 18.574219 2.197266 18.222656 C 1.474609 17.66276 0.927734 17.005209 0.556641 16.25 C 0.185547 15.494792 0 14.661458 0 13.75 Z M 15.625 14.375 C 15.625 14.205729 15.592447 14.044597 15.527344 13.891602 C 15.462239 13.738607 15.372721 13.605144 15.258789 13.491211 C 15.144855 13.377279 15.011393 13.287761 14.858398 13.222656 C 14.705403 13.157553 14.544271 13.125 14.375 13.125 C 14.199219 13.125 14.036458 13.157553 13.886719 13.222656 C 13.736979 13.287761 13.605143 13.377279 13.491211 13.491211 C 13.377278 13.605144 13.28776 13.736979 13.222656 13.886719 C 13.157551 14.036459 13.124999 14.199219 13.125 14.375 C 13.124999 14.550781 13.157551 14.71517 13.222656 14.868164 C 13.28776 15.021159 13.37565 15.152995 13.486328 15.263672 C 13.597004 15.37435 13.72884 15.46224 13.881836 15.527344 C 14.03483 15.592448 14.199219 15.625 14.375 15.625 C 14.550781 15.625 14.713541 15.592448 14.863281 15.527344 C 15.01302 15.46224 15.144855 15.372722 15.258789 15.258789 C 15.372721 15.144857 15.462239 15.013021 15.527344 14.863281 C 15.592447 14.713542 15.625 14.550781 15.625 14.375 Z "),
                new SettingOption(Translator.SettingsAppPreferences_Title, Translator.SettingsAppPreferences_Description, WinoPage.AppPreferencesPage,"F1 M 15.078125 1.25 C 15.566406 1.25 16.033527 1.349285 16.479492 1.547852 C 16.925455 1.74642 17.31608 2.013348 17.651367 2.348633 C 17.986652 2.68392 18.25358 3.074545 18.452148 3.520508 C 18.650715 3.966473 18.75 4.433594 18.75 4.921875 L 18.75 15.078125 C 18.75 15.566406 18.650715 16.033529 18.452148 16.479492 C 18.25358 16.925455 17.986652 17.31608 17.651367 17.651367 C 17.31608 17.986654 16.925455 18.25358 16.479492 18.452148 C 16.033527 18.650717 15.566406 18.75 15.078125 18.75 L 4.921875 18.75 C 4.433594 18.75 3.966471 18.650717 3.520508 18.452148 C 3.074544 18.25358 2.683919 17.986654 2.348633 17.651367 C 2.013346 17.31608 1.746419 16.925455 1.547852 16.479492 C 1.349284 16.033529 1.25 15.566406 1.25 15.078125 L 1.25 4.921875 C 1.25 4.433594 1.349284 3.966473 1.547852 3.520508 C 1.746419 3.074545 2.013346 2.68392 2.348633 2.348633 C 2.683919 2.013348 3.074544 1.74642 3.520508 1.547852 C 3.966471 1.349285 4.433594 1.25 4.921875 1.25 Z M 4.951172 2.5 C 4.625651 2.5 4.314778 2.566732 4.018555 2.700195 C 3.722331 2.83366 3.461914 3.012695 3.237305 3.237305 C 3.012695 3.461914 2.833659 3.722332 2.700195 4.018555 C 2.566732 4.314779 2.5 4.625651 2.5 4.951172 L 2.5 5 L 17.5 5 L 17.5 4.951172 C 17.5 4.625651 17.433268 4.314779 17.299805 4.018555 C 17.16634 3.722332 16.987305 3.461914 16.762695 3.237305 C 16.538086 3.012695 16.277668 2.83366 15.981445 2.700195 C 15.685221 2.566732 15.374349 2.5 15.048828 2.5 Z M 15.048828 17.5 C 15.374349 17.5 15.685221 17.433268 15.981445 17.299805 C 16.277668 17.166342 16.538086 16.987305 16.762695 16.762695 C 16.987305 16.538086 17.16634 16.27767 17.299805 15.981445 C 17.433268 15.685222 17.5 15.37435 17.5 15.048828 L 17.5 6.25 L 2.5 6.25 L 2.5 15.048828 C 2.5 15.37435 2.566732 15.685222 2.700195 15.981445 C 2.833659 16.27767 3.012695 16.538086 3.237305 16.762695 C 3.461914 16.987305 3.722331 17.166342 4.018555 17.299805 C 4.314778 17.433268 4.625651 17.5 4.951172 17.5 Z M 12.724609 8.935547 C 12.724609 9.195964 12.762044 9.446615 12.836914 9.6875 C 12.911783 9.928386 13.020832 10.151367 13.164062 10.356445 C 13.307291 10.561523 13.476562 10.742188 13.671875 10.898438 C 13.867188 11.054688 14.088541 11.178386 14.335938 11.269531 C 14.348957 11.367188 14.358723 11.466472 14.365234 11.567383 C 14.371744 11.668295 14.375 11.770834 14.375 11.875 C 14.375 11.979167 14.371744 12.081706 14.365234 12.182617 C 14.358723 12.283529 14.348957 12.382812 14.335938 12.480469 C 14.088541 12.571615 13.867188 12.695312 13.671875 12.851562 C 13.476562 13.007812 13.307291 13.188477 13.164062 13.393555 C 13.020832 13.598633 12.911783 13.821615 12.836914 14.0625 C 12.762044 14.303386 12.724609 14.554037 12.724609 14.814453 C 12.724609 14.886068 12.727864 14.960938 12.734375 15.039062 C 12.740885 15.117188 12.75065 15.192058 12.763672 15.263672 C 12.470703 15.511068 12.145182 15.712891 11.787109 15.869141 C 11.546224 15.621745 11.274414 15.43457 10.97168 15.307617 C 10.668945 15.180664 10.345052 15.117188 10 15.117188 C 9.654947 15.117188 9.331055 15.180664 9.02832 15.307617 C 8.725586 15.43457 8.453775 15.621745 8.212891 15.869141 C 7.854817 15.712891 7.529296 15.511068 7.236328 15.263672 C 7.249349 15.192058 7.259114 15.117188 7.265625 15.039062 C 7.272135 14.960938 7.275391 14.886068 7.275391 14.814453 C 7.275391 14.554037 7.237956 14.303386 7.163086 14.0625 C 7.088216 13.821615 6.979167 13.598633 6.835938 13.393555 C 6.692708 13.188477 6.52181 13.007812 6.323242 12.851562 C 6.124674 12.695312 5.904948 12.571615 5.664062 12.480469 C 5.651042 12.382812 5.641276 12.283529 5.634766 12.182617 C 5.628255 12.081706 5.625 11.979167 5.625 11.875 C 5.625 11.770834 5.628255 11.668295 5.634766 11.567383 C 5.641276 11.466472 5.651042 11.367188 5.664062 11.269531 C 5.904948 11.178386 6.124674 11.054688 6.323242 10.898438 C 6.52181 10.742188 6.692708 10.561523 6.835938 10.356445 C 6.979167 10.151367 7.088216 9.928386 7.163086 9.6875 C 7.237956 9.446615 7.275391 9.195964 7.275391 8.935547 C 7.275391 8.863933 7.272135 8.789062 7.265625 8.710938 C 7.259114 8.632812 7.249349 8.557943 7.236328 8.486328 C 7.529296 8.238933 7.854817 8.037109 8.212891 7.880859 C 8.440755 8.121745 8.712564 8.307292 9.02832 8.4375 C 9.344075 8.567709 9.667969 8.632812 10 8.632812 C 10.332031 8.632812 10.655924 8.567709 10.97168 8.4375 C 11.287435 8.307292 11.559244 8.121745 11.787109 7.880859 C 12.145182 8.037109 12.470703 8.238933 12.763672 8.486328 C 12.75065 8.557943 12.740885 8.632812 12.734375 8.710938 C 12.727864 8.789062 12.724609 8.863933 12.724609 8.935547 Z M 10.9375 11.875 C 10.9375 11.614584 10.846354 11.393229 10.664062 11.210938 C 10.481771 11.028646 10.260416 10.9375 10 10.9375 C 9.739583 10.9375 9.518229 11.028646 9.335938 11.210938 C 9.153646 11.393229 9.0625 11.614584 9.0625 11.875 C 9.0625 12.135417 9.153646 12.356771 9.335938 12.539062 C 9.518229 12.721354 9.739583 12.8125 10 12.8125 C 10.260416 12.8125 10.481771 12.721354 10.664062 12.539062 C 10.846354 12.356771 10.9375 12.135417 10.9375 11.875 Z "),
                new SettingOption(Translator.SettingsLanguageTime_Title, Translator.SettingsLanguageTime_Description, WinoPage.LanguageTimePage,"F1 M 4.765625 12.324219 C 4.088542 12.167969 3.458659 11.899414 2.875977 11.518555 C 2.293294 11.137695 1.788737 10.680339 1.362305 10.146484 C 0.935872 9.612631 0.602214 9.020183 0.361328 8.369141 C 0.120443 7.7181 0 7.044271 0 6.347656 C 0 5.468751 0.159505 4.645184 0.478516 3.876953 C 0.797526 3.108725 1.236979 2.436523 1.796875 1.860352 C 2.356771 1.28418 3.017578 0.830078 3.779297 0.498047 C 4.541016 0.166016 5.364583 0 6.25 0 C 7.115885 0 7.92806 0.162762 8.686523 0.488281 C 9.444986 0.813803 10.107422 1.259766 10.673828 1.826172 C 11.240234 2.392578 11.686197 3.055014 12.011719 3.813477 C 12.337239 4.57194 12.5 5.384115 12.5 6.25 L 11.25 6.25 L 11.25 6.152344 C 11.25 5.475261 11.114908 4.838867 10.844727 4.243164 C 10.574544 3.647461 10.209961 3.128256 9.750977 2.685547 C 9.291992 2.24284 8.761393 1.892904 8.15918 1.635742 C 7.556966 1.378582 6.920573 1.25 6.25 1.25 C 5.579427 1.25 4.943034 1.378582 4.34082 1.635742 C 3.738607 1.892904 3.208008 2.24284 2.749023 2.685547 C 2.290039 3.128256 1.925456 3.647461 1.655273 4.243164 C 1.385091 4.838867 1.25 5.475261 1.25 6.152344 L 1.25 6.328125 C 1.25 6.901042 1.352539 7.454428 1.557617 7.988281 C 1.762695 8.522136 2.045898 9.005534 2.407227 9.438477 C 2.768555 9.87142 3.191732 10.239258 3.676758 10.541992 C 4.161784 10.844727 4.6875 11.048178 5.253906 11.152344 Z M 5.625 7.5 C 5.455729 7.5 5.309245 7.438151 5.185547 7.314453 C 5.061849 7.190756 5 7.044271 5 6.875 L 5 3.125 C 5 2.95573 5.061849 2.809246 5.185547 2.685547 C 5.309245 2.56185 5.455729 2.5 5.625 2.5 C 5.794271 2.5 5.940755 2.56185 6.064453 2.685547 C 6.188151 2.809246 6.25 2.95573 6.25 3.125 L 6.25 6.25 L 8.125 6.25 C 8.294271 6.25 8.440755 6.31185 8.564453 6.435547 C 8.68815 6.559245 8.75 6.705729 8.75 6.875 C 8.75 7.044271 8.68815 7.190756 8.564453 7.314453 C 8.440755 7.438151 8.294271 7.5 8.125 7.5 Z M 10 10 L 10 8.125 C 10 7.95573 10.061849 7.809246 10.185547 7.685547 C 10.309244 7.56185 10.455729 7.5 10.625 7.5 L 14.375 7.5 C 14.375 7.447917 14.373372 7.394206 14.370117 7.338867 C 14.366861 7.283529 14.365234 7.226563 14.365234 7.167969 C 14.365234 7.057292 14.371744 6.948242 14.384766 6.84082 C 14.397786 6.733398 14.425455 6.635742 14.467773 6.547852 C 14.51009 6.459961 14.573566 6.388347 14.658203 6.333008 C 14.742838 6.27767 14.856771 6.25 15 6.25 C 15.143229 6.25 15.255533 6.27767 15.336914 6.333008 C 15.418294 6.388347 15.480143 6.459961 15.522461 6.547852 C 15.564777 6.635742 15.592447 6.733398 15.605469 6.84082 C 15.618489 6.948242 15.625 7.057292 15.625 7.167969 L 15.625 7.5 L 19.375 7.5 C 19.54427 7.5 19.690754 7.56185 19.814453 7.685547 C 19.93815 7.809246 20 7.95573 20 8.125 L 20 10 C 20 10.169271 19.93815 10.315756 19.814453 10.439453 C 19.690754 10.563151 19.54427 10.625 19.375 10.625 C 19.205729 10.625 19.059244 10.563151 18.935547 10.439453 C 18.811848 10.315756 18.75 10.169271 18.75 10 L 18.75 8.75 L 11.25 8.75 L 11.25 10 C 11.25 10.169271 11.18815 10.315756 11.064453 10.439453 C 10.940755 10.563151 10.794271 10.625 10.625 10.625 C 10.455729 10.625 10.309244 10.563151 10.185547 10.439453 C 10.061849 10.315756 10 10.169271 10 10 Z M 14.375 17.5 C 14.205729 17.5 14.059244 17.43815 13.935547 17.314453 C 13.811849 17.190756 13.75 17.044271 13.75 16.875 C 13.75 16.731771 13.777669 16.619467 13.833008 16.538086 C 13.888346 16.456705 13.95996 16.394857 14.047852 16.352539 C 14.135741 16.310221 14.233397 16.282553 14.34082 16.269531 C 14.448241 16.256512 14.557291 16.25 14.667969 16.25 L 15 16.25 L 15 13.75 L 11.875 13.75 C 11.705729 13.75 11.559244 13.688151 11.435547 13.564453 C 11.311849 13.440756 11.25 13.294271 11.25 13.125 C 11.25 12.955729 11.311849 12.809245 11.435547 12.685547 C 11.559244 12.56185 11.705729 12.5 11.875 12.5 L 15 12.5 C 14.999999 12.376303 15.035807 12.259115 15.107422 12.148438 L 15.703125 11.25 L 13.125 11.25 C 12.955729 11.25 12.809244 11.188151 12.685547 11.064453 C 12.561849 10.940756 12.5 10.794271 12.5 10.625 C 12.5 10.455729 12.561849 10.309245 12.685547 10.185547 C 12.809244 10.06185 12.955729 10 13.125 10 L 16.875 10 C 17.04427 10 17.190754 10.06185 17.314453 10.185547 C 17.43815 10.309245 17.5 10.455729 17.5 10.625 C 17.5 10.748698 17.464191 10.862631 17.392578 10.966797 L 16.376953 12.5 L 19.375 12.5 C 19.54427 12.5 19.690754 12.56185 19.814453 12.685547 C 19.93815 12.809245 20 12.955729 20 13.125 C 20 13.294271 19.93815 13.440756 19.814453 13.564453 C 19.690754 13.688151 19.54427 13.75 19.375 13.75 L 16.25 13.75 L 16.25 16.25 C 16.25 16.425781 16.217447 16.588543 16.152344 16.738281 C 16.087238 16.888021 15.997721 17.019857 15.883789 17.133789 C 15.769856 17.247721 15.638021 17.33724 15.488281 17.402344 C 15.338541 17.467447 15.17578 17.5 15 17.5 Z M 4.0625 18.125 C 4.0625 18.046875 4.075521 17.972006 4.101562 17.900391 C 4.257812 17.477213 4.41569 17.05892 4.575195 16.645508 C 4.7347 16.232096 4.892578 15.813803 5.048828 15.390625 L 6.914062 10.400391 C 6.959635 10.276693 7.036133 10.185547 7.143555 10.126953 C 7.250977 10.068359 7.369792 10.039062 7.5 10.039062 C 7.630208 10.039062 7.749023 10.068359 7.856445 10.126953 C 7.963867 10.185547 8.040364 10.276693 8.085938 10.400391 L 9.951172 15.390625 C 10.107422 15.813803 10.265299 16.232096 10.424805 16.645508 C 10.58431 17.05892 10.742188 17.477213 10.898438 17.900391 C 10.924479 17.972006 10.9375 18.046875 10.9375 18.125 C 10.9375 18.300781 10.877278 18.448893 10.756836 18.569336 C 10.636393 18.689779 10.488281 18.75 10.3125 18.75 C 10.175781 18.75 10.056966 18.714193 9.956055 18.642578 C 9.855143 18.570963 9.778646 18.470053 9.726562 18.339844 L 8.945312 16.25 L 6.054688 16.25 L 5.273438 18.339844 C 5.227864 18.463541 5.151367 18.562826 5.043945 18.637695 C 4.936523 18.712564 4.817708 18.75 4.6875 18.75 C 4.511719 18.75 4.363606 18.689779 4.243164 18.569336 C 4.122721 18.448893 4.0625 18.300781 4.0625 18.125 Z M 7.5 12.402344 L 6.523438 15 L 8.476562 15 Z "),
                new SettingOption(Translator.SettingsPersonalization_Title, Translator.SettingsPersonalization_Description, WinoPage.PersonalizationPage,"F1 M 10 17.5 L 10 18.75 L 12.5 18.75 L 12.5 20 L 6.25 20 L 6.25 18.75 L 8.75 18.75 L 8.75 17.5 L 0 17.5 L 0 6.25 L 10 6.25 L 8.740234 7.5 L 1.25 7.5 L 1.25 16.25 L 17.5 16.25 L 17.5 8.75 L 18.75 7.5 L 18.75 17.5 Z M 5 13.75 C 5.175781 13.75 5.338542 13.717448 5.488281 13.652344 C 5.638021 13.58724 5.769856 13.497722 5.883789 13.383789 C 5.997721 13.269857 6.087239 13.138021 6.152344 12.988281 C 6.217448 12.838542 6.25 12.675781 6.25 12.5 C 6.25 12.18099 6.306966 11.878256 6.420898 11.591797 C 6.53483 11.305339 6.69108 11.051433 6.889648 10.830078 C 7.088216 10.608725 7.322591 10.424805 7.592773 10.27832 C 7.862955 10.131836 8.157552 10.042318 8.476562 10.009766 L 15.419922 3.066406 C 15.602213 2.884115 15.813802 2.744141 16.054688 2.646484 C 16.295572 2.548828 16.542969 2.5 16.796875 2.5 C 17.063801 2.5 17.31608 2.550457 17.553711 2.651367 C 17.79134 2.752279 17.998047 2.890625 18.173828 3.066406 C 18.349609 3.242188 18.487955 3.448895 18.588867 3.686523 C 18.689777 3.924154 18.740234 4.179688 18.740234 4.453125 C 18.740234 4.707031 18.691406 4.954428 18.59375 5.195312 C 18.496094 5.436199 18.356119 5.647787 18.173828 5.830078 L 11.230469 12.773438 C 11.197916 13.085938 11.110025 13.378906 10.966797 13.652344 C 10.823567 13.925781 10.639648 14.161784 10.415039 14.360352 C 10.19043 14.55892 9.936523 14.71517 9.65332 14.829102 C 9.370117 14.943034 9.06901 15 8.75 15 L 2.5 15 L 2.5 13.75 Z M 16.796875 3.75 C 16.608072 3.75 16.445312 3.818359 16.308594 3.955078 L 11.962891 8.300781 C 12.333984 8.58724 12.66276 8.916016 12.949219 9.287109 L 17.294922 4.941406 C 17.431641 4.804688 17.5 4.641928 17.5 4.453125 C 17.5 4.257812 17.430012 4.091797 17.290039 3.955078 C 17.150064 3.818359 16.985676 3.75 16.796875 3.75 Z M 10.175781 10.087891 C 10.572916 10.348308 10.901692 10.677084 11.162109 11.074219 L 12.060547 10.185547 C 11.787109 9.794922 11.455078 9.462891 11.064453 9.189453 Z M 10 12.5 C 10 12.324219 9.967447 12.161459 9.902344 12.011719 C 9.837239 11.861979 9.747721 11.730144 9.633789 11.616211 C 9.519856 11.502279 9.388021 11.412761 9.238281 11.347656 C 9.088541 11.282553 8.925781 11.25 8.75 11.25 C 8.574219 11.25 8.411458 11.282553 8.261719 11.347656 C 8.111979 11.412761 7.980143 11.502279 7.866211 11.616211 C 7.752278 11.730144 7.66276 11.861979 7.597656 12.011719 C 7.532552 12.161459 7.5 12.324219 7.5 12.5 C 7.5 12.942709 7.389322 13.359375 7.167969 13.75 L 8.75 13.75 C 8.919271 13.75 9.080403 13.717448 9.233398 13.652344 C 9.386393 13.58724 9.519856 13.497722 9.633789 13.383789 C 9.747721 13.269857 9.837239 13.136394 9.902344 12.983398 C 9.967447 12.830404 10 12.669271 10 12.5 Z "),
                new SettingOption(Translator.SettingsMessageList_Title, Translator.SettingsMessageList_Description, WinoPage.MessageListPage,"F1 M 20 1.25 L 20 12.5 L 18.75 12.5 L 18.75 2.5 L 1.25 2.5 L 1.25 13.75 L 3.75 13.75 L 3.75 16.611328 L 6.611328 13.75 L 13.75 13.75 L 13.75 15 L 7.138672 15 L 2.5 19.638672 L 2.5 15 L 0 15 L 0 1.25 Z M 16.875 13.75 L 20 16.875 L 16.875 20 L 15.986328 19.111328 L 17.607422 17.5 L 11.25 17.5 L 11.25 16.25 L 17.607422 16.25 L 15.986328 14.638672 Z "),
                new SettingOption(Translator.SettingsReadComposePane_Title, Translator.SettingsReadComposePane_Description, WinoPage.ReadComposePanePage,"F1 M 20 2.5 L 20 3.75 L 8.75 3.75 L 8.75 2.5 Z M 17.5 15 L 0 15 L 0 13.75 L 17.5 13.75 Z M 2.5 10 L 20 10 L 20 11.25 L 2.5 11.25 Z M 2.5 17.5 L 20 17.5 L 20 18.75 L 2.5 18.75 Z M 3.125 7.5 C 2.695312 7.5 2.291667 7.416992 1.914062 7.250977 C 1.536458 7.084961 1.206055 6.860352 0.922852 6.577148 C 0.639648 6.293945 0.415039 5.963542 0.249023 5.585938 C 0.083008 5.208334 0 4.804688 0 4.375 C 0 3.945312 0.083008 3.541668 0.249023 3.164062 C 0.415039 2.786459 0.639648 2.456055 0.922852 2.172852 C 1.206055 1.889648 1.536458 1.665039 1.914062 1.499023 C 2.291667 1.333008 2.695312 1.25 3.125 1.25 C 3.554688 1.25 3.958333 1.333008 4.335938 1.499023 C 4.713542 1.665039 5.043945 1.889648 5.327148 2.172852 C 5.610352 2.456055 5.834961 2.786459 6.000977 3.164062 C 6.166992 3.541668 6.25 3.945312 6.25 4.375 L 5 4.375 C 5 4.114584 4.951172 3.870443 4.853516 3.642578 C 4.755859 3.414715 4.622396 3.216146 4.453125 3.046875 C 4.283854 2.877605 4.085286 2.744141 3.857422 2.646484 C 3.629557 2.548828 3.385417 2.5 3.125 2.5 C 2.864583 2.5 2.620443 2.548828 2.392578 2.646484 C 2.164713 2.744141 1.966146 2.877605 1.796875 3.046875 C 1.627604 3.216146 1.494141 3.414715 1.396484 3.642578 C 1.298828 3.870443 1.25 4.114584 1.25 4.375 C 1.25 4.635418 1.298828 4.879559 1.396484 5.107422 C 1.494141 5.335287 1.627604 5.533854 1.796875 5.703125 C 1.966146 5.872396 2.164713 6.005859 2.392578 6.103516 C 2.620443 6.201172 2.864583 6.25 3.125 6.25 L 17.5 6.25 L 17.5 7.5 Z "),
                new SettingOption(Translator.SettingsAbout_Title, Translator.SettingsAbout_Description, WinoPage.AboutPage,"F1 M 9.375 18.75 C 8.509114 18.75 7.677409 18.639322 6.879883 18.417969 C 6.082356 18.196615 5.335286 17.882486 4.638672 17.475586 C 3.942057 17.068686 3.308919 16.580404 2.739258 16.010742 C 2.169596 15.441081 1.681315 14.807943 1.274414 14.111328 C 0.867513 13.414714 0.553385 12.667644 0.332031 11.870117 C 0.110677 11.072592 0 10.240886 0 9.375 C 0 8.509115 0.110677 7.677409 0.332031 6.879883 C 0.553385 6.082357 0.867513 5.335287 1.274414 4.638672 C 1.681315 3.942059 2.169596 3.30892 2.739258 2.739258 C 3.308919 2.169598 3.942057 1.681316 4.638672 1.274414 C 5.335286 0.867514 6.082356 0.553387 6.879883 0.332031 C 7.677409 0.110678 8.509114 0 9.375 0 C 10.240885 0 11.072591 0.110678 11.870117 0.332031 C 12.667643 0.553387 13.414713 0.867514 14.111328 1.274414 C 14.807942 1.681316 15.44108 2.169598 16.010742 2.739258 C 16.580402 3.30892 17.068684 3.942059 17.475586 4.638672 C 17.882486 5.335287 18.196613 6.082357 18.417969 6.879883 C 18.639322 7.677409 18.75 8.509115 18.75 9.375 C 18.75 10.240886 18.639322 11.072592 18.417969 11.870117 C 18.196613 12.667644 17.882486 13.414714 17.475586 14.111328 C 17.068684 14.807943 16.580402 15.441081 16.010742 16.010742 C 15.44108 16.580404 14.807942 17.068686 14.111328 17.475586 C 13.414713 17.882486 12.667643 18.196615 11.870117 18.417969 C 11.072591 18.639322 10.240885 18.75 9.375 18.75 Z M 9.375 1.25 C 8.626302 1.25 7.906901 1.347656 7.216797 1.542969 C 6.526692 1.738281 5.880533 2.011719 5.27832 2.363281 C 4.676106 2.714844 4.127604 3.138021 3.632812 3.632812 C 3.138021 4.127604 2.714844 4.676107 2.363281 5.27832 C 2.011719 5.880534 1.738281 6.52832 1.542969 7.22168 C 1.347656 7.915039 1.25 8.632812 1.25 9.375 C 1.25 10.117188 1.347656 10.834961 1.542969 11.52832 C 1.738281 12.22168 2.011719 12.869467 2.363281 13.47168 C 2.714844 14.073894 3.138021 14.622396 3.632812 15.117188 C 4.127604 15.611979 4.676106 16.035156 5.27832 16.386719 C 5.880533 16.738281 6.526692 17.011719 7.216797 17.207031 C 7.906901 17.402344 8.626302 17.5 9.375 17.5 C 10.117188 17.5 10.834961 17.402344 11.52832 17.207031 C 12.221679 17.011719 12.869465 16.738281 13.47168 16.386719 C 14.073893 16.035156 14.622396 15.611979 15.117188 15.117188 C 15.611979 14.622396 16.035156 14.073894 16.386719 13.47168 C 16.738281 12.869467 17.011719 12.223308 17.207031 11.533203 C 17.402344 10.8431 17.5 10.123698 17.5 9.375 C 17.5 8.632812 17.402344 7.915039 17.207031 7.22168 C 17.011719 6.52832 16.738281 5.880534 16.386719 5.27832 C 16.035156 4.676107 15.611979 4.127604 15.117188 3.632812 C 14.622396 3.138021 14.073893 2.714844 13.47168 2.363281 C 12.869465 2.011719 12.221679 1.738281 11.52832 1.542969 C 10.834961 1.347656 10.117188 1.25 9.375 1.25 Z M 8.75 7.5 L 10 7.5 L 10 13.75 L 8.75 13.75 Z M 8.75 5 L 10 5 L 10 6.25 L 8.75 6.25 Z "),
            };
    }
}
