<?php
/**
 * System generated by SysGen (System Generator with Formdin Framework) 
 * Download SysGen: https://github.com/bjverde/sysgen
 * Download Formdin Framework: https://github.com/bjverde/formDin
 * 
 * SysGen  Version: 1.9.0-alpha
 * FormDin Version: 4.7.5-alpha
 * 
 * System appev2 created in: 2019-09-01 16:03:51
 */

defined('APLICATIVO') or die();
require_once 'modulos/includes/acesso_view_allowed.php';

$primaryKey = 'IDPESSOA';
$frm = new TForm('Pessoa Física',800,950);
$frm->setShowCloseButton(false);
$frm->setFlat(true);
$frm->setMaximize(true);
$frm->setHelpOnLine('Ajuda',600,980,'ajuda/ajuda_tela.php',null);


$frm->addHiddenField( 'BUSCAR' ); //Campo oculto para buscas
$frm->addHiddenField( 'IDPESSOA_FISICA');
$frm->addHiddenField( 'TIPO', Pessoa::PF);
$frm->addHiddenField( 'SIT_ATIVO', 'S');
$frm->addHiddenField( $primaryKey );   // coluna chave da tabela

$frm->addGroupField('gpx1','');
    $frm->addTextField('NOME', 'Nome',200,true,80);
    $frm->addCpfField('CPF', 'CPF',true);
$frm->closeGroup();

$frm->addGroupField('gpx2','');
    $frm->addDateField('DAT_NASCIMENTO', 'Data Nascimento',false);

    $controllerUf = new Uf();
    $listUf = $controllerUf->selectAll('NOM_UF');
    $frm->addSelectField('COD_UF', 'UF',false,$listUf,null,null,null,null,null,null,' ',null);

    $controllerMunicipio = new Municipio();
    $listMunicipio = $controllerMunicipio->selectAll();
    $frm->addSelectField('COD_MUNICIPIO_NASCIMENTO', 'Município Nascimento',false,$listMunicipio,null,null,null,null,null,null,' ',null);

    $frm->combinarSelects('COD_UF', 'COD_MUNICIPIO_NASCIMENTO', 'vw_regiao_municipio', 'COD_UF', 'COD_MUNICIPIO', 'NOM_MUNICIPIO', null, null, 'Nenhum', null, null, true);
$frm->closeGroup();


$frm->addButton('Buscar', null, 'btnBuscar', 'buscar()', null, true, false);
$frm->addButton('Salvar', null, 'Salvar', null, null, false, false);
$frm->addButton('Limpar', null, 'Limpar', null, null, false, false);


$acao = isset($acao) ? $acao : null;
switch( $acao ) {
    //--------------------------------------------------------------------------------
    case 'Limpar':
        $frm->clearFields();
    break;
    //--------------------------------------------------------------------------------
    case 'Salvar':
        try{
            if ( $frm->validate() ) {
                $vo = new Vw_pessoaVO();
                $frm->setVo( $vo );
                $controller = new Vw_pessoa();
                $resultado = $controller->save( $vo );
                if( is_int($resultado) && $resultado!=0 ) {
                    $frm->setMessage(Message::GENERIC_SAVE);
                    $frm->clearFields();
                }else{
                    $frm->setMessage($resultado);
                }
            }
        }
        catch (DomainException $e) {
            $frm->addMessage( $e->getMessage() ); //addMessage evita o problema do setMessage
        }
        catch (Exception $e) {
            MessageHelper::logRecord($e);
            $frm->addMessage( $e->getMessage() ); //addMessage evita o problema do setMessage
        }
    break;
    //--------------------------------------------------------------------------------
    case 'gd_excluir':
        try{
            $id = $frm->get( $primaryKey ) ;
            $controller = new Vw_pessoa();
            $resultado = $controller->delete( $id );
            if($resultado==1) {
                $frm->setMessage(Message::GENERIC_DELETE);
                $frm->clearFields();
            }else{
                $frm->setMessage($resultado);
            }
        }
        catch (DomainException $e) {
            $frm->addMessage( $e->getMessage() ); //addMessage evita o problema do setMessage
        }
        catch (Exception $e) {
            MessageHelper::logRecord($e);
            $frm->addMessage( $e->getMessage() ); //addMessage evita o problema do setMessage
        }
    break;
}


function getWhereGridParameters(&$frm)
{
    $retorno = null;
    if($frm->get('BUSCAR') == 1 ){
        $retorno = array(
                 'IDPESSOA_FISICA'=>$frm->get('IDPESSOA_FISICA')
                ,'IDPESSOA'=>$frm->get('IDPESSOA')
                ,'TIPO'=>$frm->get('TIPO')
                ,'NOME'=>$frm->get('NOME')
                ,'CPF'=>$frm->get('CPF')
                ,'DAT_NASCIMENTO'=>$frm->get('DAT_NASCIMENTO')
                ,'COD_UF'=>$frm->get('COD_UF')
                ,'COD_MUNICIPIO_NASCIMENTO'=>$frm->get('COD_MUNICIPIO_NASCIMENTO')
        );
    }else{
        $retorno = array(
             'TIPO'=>$frm->get('TIPO')
            ,'SIT_ATIVO'=>$frm->get('SIT_ATIVO')
        );
    }
    return $retorno;
}

if( isset( $_REQUEST['ajax'] )  && $_REQUEST['ajax'] ) {
    $maxRows = ROWS_PER_PAGE;
    $whereGrid = getWhereGridParameters($frm);
    $controller = new Vw_pessoa_fisica();
    $page = PostHelper::get('page');
    $dados = $controller->selectAllPagination( $primaryKey, $whereGrid, $page,  $maxRows);
    $realTotalRowsSqlPaginator = $controller->selectCount( $whereGrid );
    $mixUpdateFields = $primaryKey.'|'.$primaryKey
                    .',NOME|NOME'
                    .',TIPO|TIPO'
                    .',CPF|CPF'
                    .',IDPESSOA_FISICA|IDPESSOA_FISICA'
                    .',DAT_NASCIMENTO|DAT_NASCIMENTO'
                    .',COD_UF|COD_UF'
                    .',COD_MUNICIPIO_NASCIMENTO|COD_MUNICIPIO_NASCIMENTO'
                    ;
    $gride = new TGrid( 'gd'                        // id do gride
    				   ,'Lista de Pessoas Físicas. Qtd: '.$realTotalRowsSqlPaginator // titulo do gride
    				   );
    $gride->addKeyField( $primaryKey ); // chave primaria
    $gride->setData( $dados ); // array de dados
    $gride->setRealTotalRowsSqlPaginator( $realTotalRowsSqlPaginator );
    $gride->setMaxRows( $maxRows );
    $gride->setUpdateFields($mixUpdateFields);
    $gride->setUrl( 'pessoa_fisica.php' );

    $gride->addColumn($primaryKey,'id');
	$gride->addColumn('NOME','Nome');
    //$gride->addColumn('TIPO','Tipo de Pessoa',null,'center');
    $gride->addColumn('CPF','CPF',null,'center');    
    $gride->addColumn('DAT_NASCIMENTO','Data Nascimento',null,'center');
    $gride->addColumn('SIG_UF','UF',null,'center');
    $gride->addColumn('NOM_MUNICIPIO','Município',null,'center');
    //$gride->addColumn('DAT_INCLUSAO','Data da Inclusão',null,'center');
    //$gride->addColumn('DAT_INCLUSAO','Data da Inclusão',null,'center');
    $gride->show();
    die();
}

$frm->addHtmlField('gride');
$frm->addJavascript('init()');
$frm->show();

?>
<script>
function init() {
    var Parameters = {"BUSCAR":""
                    ,"IDPESSOA_FISICA":""
                    ,"IDPESSOA":""
                    ,"NOME":""
                    ,"CPF":""
                    ,"DAT_NASCIMENTO":""
                    ,"COD_UF":""
                    ,"COD_MUNICIPIO_NASCIMENTO":""                    
                    ,"DAT_ALTERACAO":""
                    };
    fwGetGrid('pessoa_fisica.php','gride',Parameters,true);
}
function buscar() {
    jQuery("#BUSCAR").val(1);
    init();
}
</script>