<?php
/**
 * System generated by SysGen (System Generator with Formdin Framework) 
 * Download SysGen: https://github.com/bjverde/sysgen
 * Download Formdin Framework: https://github.com/bjverde/formDin
 * 
 * SysGen  Version: 1.9.0-alpha
 * FormDin Version: 4.7.5-alpha
 * 
 * System appev2 created in: 2019-09-01 16:03:51
 */

defined('APLICATIVO') or die();
require_once 'modulos/includes/acesso_view_allowed.php';

$primaryKey = 'IDPESSOA';
$frm = new TForm('Cadastro de Pessoa',800,950);
$frm->setShowCloseButton(false);
$frm->setFlat(true);
$frm->setMaximize(true);
$frm->setHelpOnLine('Ajuda',600,980,'ajuda/ajuda_tela.php',null);


$frm->addHiddenField( 'BUSCAR' ); //Campo oculto para buscas
$frm->addHiddenField( 'IDPESSOA_FISICA' );
$frm->addHiddenField( 'IDNATUREZA_JURIDICA' );
$frm->addHiddenField( $primaryKey );   // coluna chave da tabela
$frm->addTextField('NOME', 'Nome',200,true,80);
$frm->addSelectField('TIPO' ,'Tipo Pessoa:', null, 'PF=Pessoa física,PJ=Pessoa jurídica', false)->addEvent('onChange', 'select_change(this)');
$frm->getLabel('TIPO')->setToolTip('Valor permitidos PF ou PJ');
$frm->addSelectField('SIT_ATIVO', 'Ativo:', true, 'S=Sim,N=Não', true);
//$frm->addDateField('DAT_INCLUSAO', 'DAT_INCLUSAO',TRUE);

$pc = $frm->addPageControl('pc', 100, null, null, null);

$pc->addPage('Pessoa Física', false, true, 'pessoaFisica', true, true);
    $frm->addCpfField('CPF', 'CPF:', false);
    $frm->addDateField('DAT_NASCIMENTO', 'Data Nascimento',false);

    $controllerUf = new Uf();
    $listUf = $controllerUf->selectAll('NOM_UF');
    $frm->addSelectField('COD_UF', 'UF',false,$listUf,null,null,null,null,null,null,' ',null);
    
    $controllerMunicipio = new Municipio();
    $listMunicipio = $controllerMunicipio->selectAll();
    $frm->addSelectField('COD_MUNICIPIO_NASCIMENTO', 'Município Nascimento',false,$listMunicipio,null,null,null,null,null,null,' ',null);
    
    $frm->combinarSelects('COD_UF', 'COD_MUNICIPIO_NASCIMENTO', 'vw_regiao_municipio', 'COD_UF', 'COD_MUNICIPIO', 'NOM_MUNICIPIO', null, null, 'Nenhum', null, null, true);


$pc->addPage('Pessoa Jurídica', false, true, 'pessoaJuridica', true, true);
    $frm->addCnpjField('CNPJ', 'CNPJ:', false);

$frm->closeGroup();

$frm->addButton('Buscar', null, 'btnBuscar', 'buscar()', null, true, false);
$frm->addButton('Salvar', null, 'Salvar', null, null, false, false);
$frm->addButton('Limpar', null, 'Limpar', null, null, false, false);


$acao = isset($acao) ? $acao : null;
switch( $acao ) {
    //--------------------------------------------------------------------------------
    case 'Limpar':
        $frm->clearFields();
    break;
    //--------------------------------------------------------------------------------
    case 'Salvar':
        try{
            if ( $frm->validate() ) {
                $vo = new Vw_pessoaVO();
                $frm->setVo( $vo );
                $controller = new Vw_pessoa();
                $resultado = $controller->save( $vo );
                if($resultado==1) {
                    $frm->setMessage('Registro gravado com sucesso!!!');
                    $frm->clearFields();
                }else{
                    $frm->setMessage($resultado);
                }
            }
        }
        catch (DomainException $e) {
            $frm->setMessage( $e->getMessage() );
        }
        catch (Exception $e) {
            MessageHelper::logRecord($e);
            $frm->setMessage( $e->getMessage() );
        }
    break;
    //--------------------------------------------------------------------------------
    case 'gd_excluir':
        try{
            $id = $frm->get( $primaryKey ) ;
            $controller = new Pessoa();
            $resultado = $controller->delete( $id );
            if($resultado==1) {
                $frm->setMessage('Registro excluido com sucesso!!!');
                $frm->clearFields();
            }else{
                $frm->setMessage($resultado);
            }
        }
        catch (DomainException $e) {
            $frm->setMessage( $e->getMessage() );
        }
        catch (Exception $e) {
            MessageHelper::logRecord($e);
            $frm->setMessage( $e->getMessage() );
        }
    break;
}


function getWhereGridParameters(&$frm)
{
    $retorno = null;
    if($frm->get('BUSCAR') == 1 ){
        $retorno = array(
                'IDPESSOA'=>$frm->get('IDPESSOA')
                ,'NOME'=>$frm->get('NOME')
                ,'TIPO'=>$frm->get('TIPO')
                ,'SIT_ATIVO'=>$frm->get('SIT_ATIVO')
                ,'DAT_INCLUSAO'=>$frm->get('DAT_INCLUSAO')
        );
    }
    return $retorno;
}

if( isset( $_REQUEST['ajax'] )  && $_REQUEST['ajax'] ) {
    $maxRows = ROWS_PER_PAGE;
    $whereGrid = getWhereGridParameters($frm);
    $controller = new Vw_pessoa();
    $page = PostHelper::get('page');
    $dados = $controller->selectAllPagination( $primaryKey, $whereGrid, $page,  $maxRows);
    $realTotalRowsSqlPaginator = $controller->selectCount( $whereGrid );
    $mixUpdateFields = $primaryKey.'|'.$primaryKey
                    .',NOME|NOME'
                    .',TIPO|TIPO'
                    .',CPF|CPF'
                    .',IDPESSOA_FISICA|IDPESSOA_FISICA'
                    .',CNPJ|CNPJ'
                    .',IDNATUREZA_JURIDICA|IDNATUREZA_JURIDICA'
                    .',SIT_ATIVO|SIT_ATIVO'
                    .',DAT_INCLUSAO|DAT_INCLUSAO'
                    ;
    $gride = new TGrid( 'gd'                        // id do gride
    				   ,'Lista de Pessoas. Qtd: '.$realTotalRowsSqlPaginator // titulo do gride
    				   );
    $gride->addKeyField( $primaryKey ); // chave primaria
    $gride->setData( $dados ); // array de dados
    $gride->setRealTotalRowsSqlPaginator( $realTotalRowsSqlPaginator );
    $gride->setMaxRows( $maxRows );
    $gride->setUpdateFields($mixUpdateFields);
    $gride->setUrl( 'pessoa.php' );

    $gride->addColumn($primaryKey,'id');
	$gride->addColumn('NOME','Nome');
    $gride->addColumn('TIPO','Tipo de Pessoa',null,'center');
    $gride->addColumn('CPFCNPJ','CPF/CNPJ');
	$gride->addColumn('SIT_ATIVO','Ativo',null,'center');
    $gride->addColumn('DAT_INCLUSAO','Data da Inclusão',null,'center');
    $gride->addColumn('DAT_ALTERACAO','Data da Alteração',null,'center');


    $gride->show();
    die();
}

$frm->addHtmlField('gride');
$frm->addJavascript('init()');
$frm->show();

?>
<script>
function init() {
    var Parameters = {"BUSCAR":""
                    ,"IDPESSOA":""
                    ,"NOME":""
                    ,"TIPO":""
                    ,"SIT_ATIVO":""
                    ,"DAT_INCLUSAO":""
                    };
    fwGetGrid('pessoa.php','gride',Parameters,true);
}
function buscar() {
    jQuery("#BUSCAR").val(1);
    init();
}
function select_change(e) {
    if( e.id == 'TIPO'){
        var valor = jQuery("#"+e.id).find(":selected").val();
        //var fwg = fwGetFields("#TPPESSOA",null,null);
        //console.log ( fwg );        
        jQuery( "#TIPO *").each(  function() {
                var type    = this.type;
                var tag     = this.tagName.toLowerCase();
                var id      = ''
                var value   = '';
                console.log ( this );
            }
        );                    
        if (valor=='PF'){
            fwSetRequired('CPF');
            fwHabilitarAba('pessoaFisica','pc');
            fwSelecionarAba('pessoaFisica');
            fwDesabilitarAba('pessoaJuridica');
        }else{
            fwSetRequired('NMCNPJ');
            fwHabilitarAba('pessoaJuridica','pc');
            fwSelecionarAba('pessoaJuridica');
            fwDesabilitarAba('pessoaFisica');
        }
    }
}
</script>