<?php
/**
 * System generated by SysGen (System Generator with Formdin Framework) 
 * Download SysGen: https://github.com/bjverde/sysgen
 * Download Formdin Framework: https://github.com/bjverde/formDin
 * 
 * SysGen  Version: 1.12.0
 * FormDin Version: 4.19.0
 * 
 * System appev2 created in: 2022-09-28 00:42:12
 */
class Autoridade
{


    private $dao = null;

    public function __construct($tpdo = null)
    {
        $this->dao = new AutoridadeDAO($tpdo);
    }
    public function getDao()
    {
        return $this->dao;
    }
    public function setDao($dao)
    {
        $this->dao = $dao;
    }
    //--------------------------------------------------------------------------------
    public function selectById( $id )
    {
        $result = $this->dao->selectById( $id );
        return $result;
    }
    //--------------------------------------------------------------------------------
    public function selectCount( $where=null )
    {
        $result = $this->dao->selectCount( $where );
        return $result;
    }
    //--------------------------------------------------------------------------------
    public function selectAllPagination( $orderBy=null, $where=null, $page=null,  $rowsPerPage= null)
    {
        $result = $this->dao->selectAllPagination( $orderBy, $where, $page,  $rowsPerPage );
        return $result;
    }
    //--------------------------------------------------------------------------------
    public function selectAll( $orderBy=null, $where=null )
    {
        $result = $this->dao->selectAll( $orderBy, $where );
        return $result;
    }
    //--------------------------------------------------------------------------------
    public function validar( AutoridadeVO $objVo) {
        //Invertendo a string de data pois vem da tela dd-mm-yyyy
        // e o mysql só entende yyyy-mm-dd
        $dat_evento = implode("-", array_reverse(explode("/", $objVo->getDat_evento())));
        
        $ordem = $objVo->getOrdem();
        $where = 'ordem ='.$ordem.' and dat_evento = \''.$dat_evento.'\'';
        $resultado = $this->dao->selectAll(null, $where);
        
        if (is_array($resultado) && count($resultado)>0) {
            $msg = "No evento do mesmo dia só pode ter uma autoridade da mesma ordem";
            throw new DomainException($msg);
        }
    }    
    //--------------------------------------------------------------------------------
    private function validatePkNotExist( $id )
    {
        $where=array('IDAUTORIDADE'=>$id);
        $qtd = $this->selectCount($where);
        if( empty($qtd) ){
            throw new DomainException(Message::GENERIC_ID_NOT_EXIST);
        }
    }
    //--------------------------------------------------------------------------------
    public function save( AutoridadeVO $objVo )
    {
        $result = null;
        $this->validar($objVo);
        if( $objVo->getIdautoridade() ) {
            $this->validatePkNotExist( $objVo->getIdautoridade() );
            $result = $this->dao->update( $objVo );
        } else {
            $result = $this->dao->insert( $objVo );
        }
        return $result;
    }
    //--------------------------------------------------------------------------------
    public function delete( $id )
    {
        $this->validatePkNotExist( $id );
        $result = $this->dao->delete( $id );
        return $result;
    }
    //--------------------------------------------------------------------------------
    public function getVoById( $id )
    {
        $result = $this->dao->getVoById( $id );
        return $result;
    }

}
?>