<?php
/**
 * System generated by SysGen (System Generator with Formdin Framework) 
 * Download SysGen: https://github.com/bjverde/sysgen
 * Download Formdin Framework: https://github.com/bjverde/formDin
 * 
 * SysGen  Version: 1.9.0-alpha
 * FormDin Version: 4.7.5-alpha
 * 
 * System appev2 created in: 2019-09-01 16:03:51
 */

defined('APLICATIVO') or die();
require_once 'modulos/includes/acesso_view_allowed.php';

$primaryKey = 'IDTELEFONE';
$frm = new TForm('telefone',800,950);
$frm->setShowCloseButton(false);
$frm->setFlat(true);
$frm->setMaximize(true);
$frm->setHelpOnLine('Ajuda',600,980,'ajuda/ajuda_tela.php',null);


$frm->addHiddenField( 'BUSCAR' ); //Campo oculto para buscas
$frm->addHiddenField( $primaryKey );   // coluna chave da tabela


$frm->addGroupField('gpx1', 'Pessoa');
    $frm->addTextField('IDPESSOA', 'id Pessoa', 6,true,6);
    $frm->addTextField('NOME', 'Nome',200,true,80,null,false);

    $frm->setAutoComplete('NOME'
                        , 'vw_pessoa'            // 2: tabela alvo da pesquisa
                        , 'NOME'           // 3: campo de pesquisa
                        , 'NOME|NOME,IDPESSOA|IDPESSOA'  // 4: campos do form origem que serão atualizados ao selecionar o item desejado. Separados por virgulas seguindo o padrão <campo_tabela> | <campo_formulario> , <campo_tabela> | <campo_formulario>
                        , true
                        , null                      // 6: campo do formulário que será adicionado como filtro
                        , null
                        , 3
                        , 1000                       // Default 1000, tempo após a digitação para disparar a consulta
                        , 50                         // máximo de registros que deverá ser retornado
                        , null
                        , null
                        , null                       // url da função de callbacks, se ficar em branco será tratado por callbacks/autocomplete.php
                        , null                       // Mesagem caso não encontre nenhum registro
                        , null
                        , null
                        , null
                        , true);                       // $boolSearchAnyPosition busca o texto em qualquer posição igual Like %texto%    
$frm->closeGroup();


$controllerTipo = new Tipo();
$listTipo = $controllerTipo->selectAllAtivoByMeta(Meta_tipo::TELEFONE);
$frm->addSelectField('IDTIPO_TELEFONE', 'Tipo Telefone',true,$listTipo,null,null,null,null,null,null,' ',null);

$frm->addFoneField('NUMERO', 'Num Telefone',true);

$controllerEndereco = new Endereco();
$listEndereco = $controllerEndereco->selectAll();
$frm->addSelectField('IDENDERECO', 'IDENDERECO',false,$listEndereco,null,null,null,null,null,null,' ',null);

$listSimNao = array('S'=>'Sim','N'=>'Nao');
$frm->addRadioField('SIT_FIXO', 'É fixo ?', false, $listSimNao,null,null,null,4);
$frm->addRadioField('WHASTAPP', 'Tem WhastApp?', false, $listSimNao,null,null,null,4);
$frm->addRadioField('TELEGRAM', 'Tem Telegram?', false, $listSimNao,null,null,null,4);

$frm->addButton('Buscar', null, 'btnBuscar', 'buscar()', null, true, false);
$frm->addButton('Salvar', null, 'Salvar', null, null, false, false);
$frm->addButton('Limpar', null, 'Limpar', null, null, false, false);


$acao = isset($acao) ? $acao : null;
switch( $acao ) {
    //--------------------------------------------------------------------------------
    case 'Limpar':
        $frm->clearFields();
    break;
    //--------------------------------------------------------------------------------
    case 'Salvar':
        try{
            if ( $frm->validate() ) {
                $vo = new TelefoneVO();
                $frm->setVo( $vo );
                $controller = new Telefone();
                $resultado = $controller->save( $vo );
                if($resultado==1) {
                    $frm->setMessage('Registro gravado com sucesso!!!');
                    $frm->clearFields();
                }else{
                    $frm->setMessage($resultado);
                }
            }
        }
        catch (DomainException $e) {
            $frm->setMessage( $e->getMessage() );
        }
        catch (Exception $e) {
            MessageHelper::logRecord($e);
            $frm->setMessage( $e->getMessage() );
        }
    break;
    //--------------------------------------------------------------------------------
    case 'gd_excluir':
        try{
            $id = $frm->get( $primaryKey ) ;
            $controller = new Telefone();
            $resultado = $controller->delete( $id );
            if($resultado==1) {
                $frm->setMessage('Registro excluido com sucesso!!!');
                $frm->clearFields();
            }else{
                $frm->setMessage($resultado);
            }
        }
        catch (DomainException $e) {
            $frm->setMessage( $e->getMessage() );
        }
        catch (Exception $e) {
            MessageHelper::logRecord($e);
            $frm->setMessage( $e->getMessage() );
        }
    break;
}


function getWhereGridParameters(&$frm)
{
    $retorno = null;
    if($frm->get('BUSCAR') == 1 ){
        $retorno = array(
                'IDTELEFONE'=>$frm->get('IDTELEFONE')
                ,'NUMERO'=>$frm->get('NUMERO')
                ,'IDPESSOA'=>$frm->get('IDPESSOA')
                ,'IDTIPO_TELEFONE'=>$frm->get('IDTIPO_TELEFONE')
                ,'IDENDERECO'=>$frm->get('IDENDERECO')
                ,'SIT_FIXO'=>$frm->get('SIT_FIXO')
                ,'WHASTAPP'=>$frm->get('WHASTAPP')
                ,'TELEGRAM'=>$frm->get('TELEGRAM')
        );
    }
    return $retorno;
}

if( isset( $_REQUEST['ajax'] )  && $_REQUEST['ajax'] ) {
    $maxRows = ROWS_PER_PAGE;
    $whereGrid = getWhereGridParameters($frm);
    $controller = new Telefone();
    $page = PostHelper::get('page');
    $dados = $controller->selectAllPagination( $primaryKey, $whereGrid, $page,  $maxRows);
    $realTotalRowsSqlPaginator = $controller->selectCount( $whereGrid );
    $mixUpdateFields = $primaryKey.'|'.$primaryKey
                    .',NUMERO|NUMERO'
                    .',IDPESSOA|IDPESSOA'
                    .',IDTIPO_TELEFONE|IDTIPO_TELEFONE'
                    .',IDENDERECO|IDENDERECO'
                    .',SIT_FIXO|SIT_FIXO'
                    .',WHASTAPP|WHASTAPP'
                    .',TELEGRAM|TELEGRAM'
                    ;
    $gride = new TGrid( 'gd'                        // id do gride
    				   ,'Gride with SQL Pagination. Qtd: '.$realTotalRowsSqlPaginator // titulo do gride
    				   );
    $gride->addKeyField( $primaryKey ); // chave primaria
    $gride->setData( $dados ); // array de dados
    $gride->setRealTotalRowsSqlPaginator( $realTotalRowsSqlPaginator );
    $gride->setMaxRows( $maxRows );
    $gride->setUpdateFields($mixUpdateFields);
    $gride->setUrl( 'telefone.php' );

    $gride->addColumn($primaryKey,'id');
    $gride->addColumn('IDPESSOA','id Pessoa');
    $gride->addColumn('IDTIPO_TELEFONE','id Tipo_telefone');
    $gride->addColumn('NUMERO','Número');        
    $gride->addColumn('IDENDERECO','id Endereco');
    $gride->addColumn('SIT_FIXO','Fixo',null,'center');
    $gride->addColumn('WHASTAPP','WhastApp',null,'center');
    $gride->addColumn('TELEGRAM','Telegram',null,'center');
    $gride->addColumn('DAT_INCLUSAO','Data da Inclusão',null,'center');
    $gride->addColumn('DAT_ALTERACAO','Data da Alteração',null,'center');


    $gride->show();
    die();
}

$frm->addHtmlField('gride');
$frm->addJavascript('init()');
$frm->show();

?>
<script>
function init() {
    var Parameters = {"BUSCAR":""
                    ,"IDTELEFONE":""
                    ,"NUMERO":""
                    ,"IDPESSOA":""
                    ,"IDTIPO_TELEFONE":""
                    ,"IDENDERECO":""
                    ,"SIT_FIXO":""
                    ,"WHASTAPP":""
                    ,"TELEGRAM":""
                    };
    fwGetGrid('telefone.php','gride',Parameters,true);
}
function buscar() {
    jQuery("#BUSCAR").val(1);
    init();
}
</script>