<?php
/**
 * System generated by SysGen (System Generator with Formdin Framework) 
 * Download SysGen: https://github.com/bjverde/sysgen
 * Download Formdin Framework: https://github.com/bjverde/formDin
 * 
 * SysGen  Version: 1.9.0-alpha
 * FormDin Version: 4.7.5-alpha
 * 
 * System appev2 created in: 2019-09-01 16:03:51
 */

defined('APLICATIVO') or die();
require_once 'modulos/includes/acesso_view_allowed.php';

$primaryKey = 'IDPESSOA';
$frm = new TForm('Cadastro Simples Pessoa Jurídica',800,950);
$frm->setShowCloseButton(false);
$frm->setFlat(true);
$frm->setMaximize(true);
$frm->setHelpOnLine('Ajuda',600,980,'ajuda/ajuda_tela.php',null);


$frm->addHiddenField( 'BUSCAR' ); //Campo oculto para buscas
$frm->addHiddenField( 'IDPESSOA_JURIDICA');
$frm->addHiddenField( 'TIPO', Pessoa::PJ);
$frm->addHiddenField( 'SIT_ATIVO', 'S');
$frm->addHiddenField( $primaryKey );   // coluna chave da tabela


$frm->addGroupField('gpx1','');
    $frm->addTextField('NOME', 'Nome',200,true,80);
    $frm->addCnpjField('CNPJ', 'CNPJ',true);
$frm->closeGroup();

$frm->addGroupField('gpx2','');
    $frm->addNumberField('CNAE', 'CNAE',10,false,0);
    $frm->getLabel('CNAE')->setToolTip('códigos de atividades econômicas em todo o país');
    $controllerNatureza_juridica = new Natureza_juridica();
    $listNatureza_juridica = $controllerNatureza_juridica->selectAll();
    $frm->addSelectField('IDNATUREZA_JURIDICA', 'IDNATUREZA_JURIDICA',false,$listNatureza_juridica,null,null,null,null,null,null,' ',null);
$frm->closeGroup();

$frm->addButton('Buscar', null, 'btnBuscar', 'buscar()', null, true, false);
$frm->addButton('Salvar', null, 'Salvar', null, null, false, false);
$frm->addButton('Limpar', null, 'Limpar', null, null, false, false);


$acao = isset($acao) ? $acao : null;
switch( $acao ) {
    //--------------------------------------------------------------------------------
    case 'Limpar':
        $frm->clearFields();
    break;
    //--------------------------------------------------------------------------------
    case 'Salvar':
        try{
            if ( $frm->validate() ) {
                $vo = new Vw_pessoaVO();
                $frm->setVo( $vo );
                $controller = new Vw_pessoa();
                $resultado = $controller->save( $vo );
                if( is_int($resultado) && $resultado!=0 ) {
                    $frm->setMessage('Registro gravado com sucesso!!!');
                    $frm->clearFields();
                }else{
                    $frm->setMessage($resultado);
                }
            }
        }
        catch (DomainException $e) {
            $frm->addMessage( $e->getMessage() ); //addMessage evita o problema do setMessage
        }
        catch (Exception $e) {
            MessageHelper::logRecord($e);
            $frm->addMessage( $e->getMessage() ); //addMessage evita o problema do setMessage
        }
    break;
    //--------------------------------------------------------------------------------
    case 'gd_excluir':
        try{
            $id = $frm->get( $primaryKey ) ;
            $controller = new Vw_pessoa();
            $resultado = $controller->delete( $id );
            if($resultado==1) {
                $frm->setMessage('Registro excluido com sucesso!!!');
                $frm->clearFields();
            }else{
                $frm->setMessage($resultado);
            }
        }
        catch (DomainException $e) {
            $frm->addMessage( $e->getMessage() ); //addMessage evita o problema do setMessage
        }
        catch (Exception $e) {
            MessageHelper::logRecord($e);
            $frm->addMessage( $e->getMessage() ); //addMessage evita o problema do setMessage
        }
    break;
}


function getWhereGridParameters(&$frm)
{
    $retorno = null;
    if($frm->get('BUSCAR') == 1 ){
        $retorno = array(
                'IDPESSOA_JURIDICA'=>$frm->get('IDPESSOA_JURIDICA')
                ,'CNPJ'=>$frm->get('CNPJ')
                ,'NOME'=>$frm->get('NOME')
                ,'IDPESSOA'=>$frm->get('IDPESSOA')
                ,'CNAE'=>$frm->get('CNAE')
                ,'IDNATUREZA_JURIDICA'=>$frm->get('IDNATUREZA_JURIDICA')
        );
    }else{
        $retorno = array(
             'TIPO'=>$frm->get('TIPO')
            ,'SIT_ATIVO'=>$frm->get('SIT_ATIVO')
        );
    }
    return $retorno;
}

if( isset( $_REQUEST['ajax'] )  && $_REQUEST['ajax'] ) {
    $maxRows = ROWS_PER_PAGE;
    $whereGrid = getWhereGridParameters($frm);
    $controller = new Vw_pessoa();
    $page = PostHelper::get('page');
    $dados = $controller->selectAllPagination( $primaryKey, $whereGrid, $page,  $maxRows);
    $realTotalRowsSqlPaginator = $controller->selectCount( $whereGrid );
    $mixUpdateFields = $primaryKey.'|'.$primaryKey
                    .',CNPJ|CNPJ'
                    .',NOME|NOME'
                    .',IDPESSOA|IDPESSOA'
                    .',CNAE|CNAE'
                    .',IDNATUREZA_JURIDICA|IDNATUREZA_JURIDICA'
                    ;
    $gride = new TGrid( 'gd'                        // id do gride
    				   ,'Lista de PJ. Qtd: '.$realTotalRowsSqlPaginator // titulo do gride
    				   );
    $gride->addKeyField( $primaryKey ); // chave primaria
    $gride->setData( $dados ); // array de dados
    $gride->setRealTotalRowsSqlPaginator( $realTotalRowsSqlPaginator );
    $gride->setMaxRows( $maxRows );
    $gride->setUpdateFields($mixUpdateFields);
    $gride->setUrl( 'pessoa_juridica.php' );

    $gride->addColumn($primaryKey,'id');
    $gride->addColumn('NOME','Nome');
    $gride->addColumn('CNPJ','CNPJ');   
    $gride->addColumn('CNAE','CNAE');
    $gride->addColumn('IDNATUREZA_JURIDICA','id Natureza_juridica');


    $gride->show();
    die();
}

$frm->addHtmlField('gride');
$frm->addJavascript('init()');
$frm->show();

?>
<script>
function init() {
    var Parameters = {"BUSCAR":""
                    ,"IDPESSOA":""
                    ,"IDPESSOA_JURIDICA":""
                    ,"CNPJ":""
                    ,"NOME":""
                    ,"CNAE":""
                    ,"IDNATUREZA_JURIDICA":""
                    };
    fwGetGrid('pessoa_juridica.php','gride',Parameters,true);
}
function buscar() {
    jQuery("#BUSCAR").val(1);
    init();
}
</script>