<?php
/**
 * System generated by SysGen (System Generator with Formdin Framework) 
 * Download SysGen: https://github.com/bjverde/sysgen
 * Download Formdin Framework: https://github.com/bjverde/formDin
 * 
 * SysGen  Version: 1.9.0-alpha
 * FormDin Version: 4.7.5-alpha
 * 
 * System appev2 created in: 2019-09-01 16:03:51
 */

defined('APLICATIVO') or die();
require_once 'modulos/includes/acesso_view_allowed.php';

$primaryKey = 'IDENDERECO';
$frm = new TForm('Endereço',800,950);
$frm->setShowCloseButton(false);
$frm->setFlat(true);
$frm->setMaximize(true);
$frm->setHelpOnLine('Ajuda',600,980,'ajuda/ajuda_tela.php',null);


$frm->addHiddenField( 'BUSCAR' ); //Campo oculto para buscas
$frm->addHiddenField( $primaryKey );   // coluna chave da tabela


$frm->addGroupField('gpx1', 'Pessoa');
    $frm->addTextField('IDPESSOA', 'id Pessoa', 6,true,6);
    $frm->addTextField('NOME', 'Nome',200,true,80,null,false);

    $frm->setAutoComplete('NOME'
                        , 'vw_pessoa'            // 2: tabela alvo da pesquisa
                        , 'NOME'           // 3: campo de pesquisa
                        , 'NOME|NOME,IDPESSOA|IDPESSOA'  // 4: campos do form origem que serão atualizados ao selecionar o item desejado. Separados por virgulas seguindo o padrão <campo_tabela> | <campo_formulario> , <campo_tabela> | <campo_formulario>
                        , true
                        , null                      // 6: campo do formulário que será adicionado como filtro
                        , null
                        , 3
                        , 1000                       // Default 1000, tempo após a digitação para disparar a consulta
                        , 50                         // máximo de registros que deverá ser retornado
                        , null
                        , null
                        , null                       // url da função de callbacks, se ficar em branco será tratado por callbacks/autocomplete.php
                        , null                       // Mesagem caso não encontre nenhum registro
                        , null
                        , null
                        , null
                        , true);                       // $boolSearchAnyPosition busca o texto em qualquer posição igual Like %texto%    
$frm->closeGroup();



$controllerTipo = new Tipo();
$listTipo = $controllerTipo->selectAllAtivoByMeta(Meta_tipo::ENDERECO);
$frm->addSelectField('IDTIPO_ENDERECO', 'Tipo Endereço',true,$listTipo,null,null,null,null,null,null,' ',null);

$frm->addCepField('CEP' //id do campo
        , 'Cep:'        //Label do campo
        , true          //
        , null
        , null          // Nova linha
        , 'ENDERECO'    // id do Campo endereço
        , 'BAIRRO'      // id do Campo bairro
        , 'CIDADE'      // id do Campo cidade
        , null          // id do Campo cod uf
        , 'cod_uf'      // id do Campo sig uf
        , null          // id do Campo logradouro
        , null          // id do Campo complemento
        , 'cod_municipio' // id do Cod municipio. DEVE TERMINAL COM "_temp" SE for no combinar select
        , null          // Label sobre o campo
        , null
        , null           //JavaScript Callback
        , null
        ); 


$frm->addMemoField('ENDERECO', 'ENDERECO',300,true,80,3);
$frm->addTextField('NUMERO', 'NUMERO',5,false,5);
$frm->addMemoField('COMPLEMENTO', 'COMPLEMENTO',300,false,80,3);
$frm->addMemoField('BAIRRO', 'BAIRRO',300,false,80,3);
$frm->addMemoField('CIDADE', 'CIDADE',300,false,80,3);

$controllerMunicipio = new Municipio();
$listMunicipio = $controllerMunicipio->selectAll();
$frm->addSelectField('COD_MUNICIPIO', 'COD_MUNICIPIO',true,$listMunicipio,null,null,null,null,null,null,' ',null);

$frm->addButton('Buscar', null, 'btnBuscar', 'buscar()', null, true, false);
$frm->addButton('Salvar', null, 'Salvar', null, null, false, false);
$frm->addButton('Limpar', null, 'Limpar', null, null, false, false);


$acao = isset($acao) ? $acao : null;
switch( $acao ) {
    //--------------------------------------------------------------------------------
    case 'Limpar':
        $frm->clearFields();
    break;
    //--------------------------------------------------------------------------------
    case 'Salvar':
        try{
            if ( $frm->validate() ) {
                $vo = new EnderecoVO();
                $frm->setVo( $vo );
                $controller = new Endereco();
                $resultado = $controller->save( $vo );
                if($resultado==1) {
                    $frm->setMessage('Registro gravado com sucesso!!!');
                    $frm->clearFields();
                }else{
                    $frm->setMessage($resultado);
                }
            }
        }
        catch (DomainException $e) {
            $frm->setMessage( $e->getMessage() );
        }
        catch (Exception $e) {
            MessageHelper::logRecord($e);
            $frm->setMessage( $e->getMessage() );
        }
    break;
    //--------------------------------------------------------------------------------
    case 'gd_excluir':
        try{
            $id = $frm->get( $primaryKey ) ;
            $controller = new Endereco();
            $resultado = $controller->delete( $id );
            if($resultado==1) {
                $frm->setMessage('Registro excluido com sucesso!!!');
                $frm->clearFields();
            }else{
                $frm->setMessage($resultado);
            }
        }
        catch (DomainException $e) {
            $frm->setMessage( $e->getMessage() );
        }
        catch (Exception $e) {
            MessageHelper::logRecord($e);
            $frm->setMessage( $e->getMessage() );
        }
    break;
}


function getWhereGridParameters(&$frm)
{
    $retorno = null;
    if($frm->get('BUSCAR') == 1 ){
        $retorno = array(
                'IDENDERECO'=>$frm->get('IDENDERECO')
                ,'ENDERECO'=>$frm->get('ENDERECO')
                ,'IDPESSOA'=>$frm->get('IDPESSOA')
                ,'IDTIPO_ENDERECO'=>$frm->get('IDTIPO_ENDERECO')
                ,'COD_MUNICIPIO'=>$frm->get('COD_MUNICIPIO')
                ,'CEP'=>$frm->get('CEP')
                ,'NUMERO'=>$frm->get('NUMERO')
                ,'COMPLEMENTO'=>$frm->get('COMPLEMENTO')
                ,'BAIRRO'=>$frm->get('BAIRRO')
                ,'CIDADE'=>$frm->get('CIDADE')
        );
    }
    return $retorno;
}

if( isset( $_REQUEST['ajax'] )  && $_REQUEST['ajax'] ) {
    $maxRows = ROWS_PER_PAGE;
    $whereGrid = getWhereGridParameters($frm);
    $controller = new Endereco();
    $page = PostHelper::get('page');
    $dados = $controller->selectAllPagination( $primaryKey, $whereGrid, $page,  $maxRows);
    $realTotalRowsSqlPaginator = $controller->selectCount( $whereGrid );
    $mixUpdateFields = $primaryKey.'|'.$primaryKey
                    .',ENDERECO|ENDERECO'
                    .',IDPESSOA|IDPESSOA'
                    .',IDTIPO_ENDERECO|IDTIPO_ENDERECO'
                    .',COD_MUNICIPIO|COD_MUNICIPIO'
                    .',CEP|CEP'
                    .',NUMERO|NUMERO'
                    .',COMPLEMENTO|COMPLEMENTO'
                    .',BAIRRO|BAIRRO'
                    .',CIDADE|CIDADE'
                    ;
    $gride = new TGrid( 'gd'                        // id do gride
    				   ,'Gride with SQL Pagination. Qtd: '.$realTotalRowsSqlPaginator // titulo do gride
    				   );
    $gride->addKeyField( $primaryKey ); // chave primaria
    $gride->setData( $dados ); // array de dados
    $gride->setRealTotalRowsSqlPaginator( $realTotalRowsSqlPaginator );
    $gride->setMaxRows( $maxRows );
    $gride->setUpdateFields($mixUpdateFields);
    $gride->setUrl( 'endereco.php' );

    $gride->addColumn($primaryKey,'id');
    $gride->addColumn('ENDERECO','ENDERECO');
    $gride->addColumn('IDPESSOA','id Pessoa');
    $gride->addColumn('IDTIPO_ENDERECO','id Tipo_endereco');
    $gride->addColumn('COD_MUNICIPIO','COD_MUNICIPIO');
    $gride->addColumn('CEP','CEP');
    $gride->addColumn('NUMERO','NUMERO');
    $gride->addColumn('COMPLEMENTO','COMPLEMENTO');
    $gride->addColumn('BAIRRO','BAIRRO');
    $gride->addColumn('CIDADE','CIDADE');
    $gride->addColumn('DAT_INCLUSAO','Data da Inclusão',null,'center');
    $gride->addColumn('DAT_ALTERACAO','Data da Alteração',null,'center');


    $gride->show();
    die();
}

$frm->addHtmlField('gride');
$frm->addJavascript('init()');
$frm->show();

?>
<script>
function init() {
    var Parameters = {"BUSCAR":""
                    ,"IDENDERECO":""
                    ,"ENDERECO":""
                    ,"IDPESSOA":""
                    ,"IDTIPO_ENDERECO":""
                    ,"COD_MUNICIPIO":""
                    ,"CEP":""
                    ,"NUMERO":""
                    ,"COMPLEMENTO":""
                    ,"BAIRRO":""
                    ,"CIDADE":""
                    };
    fwGetGrid('endereco.php','gride',Parameters,true);
}
function buscar() {
    jQuery("#BUSCAR").val(1);
    init();
}
</script>