<?php
/**
 * System generated by SysGen (System Generator with Formdin Framework) 
 * Download SysGen: https://github.com/bjverde/sysgen
 * Download Formdin Framework: https://github.com/bjverde/formDin
 * 
 * SysGen  Version: 1.10.1-alpha
 * FormDin Version: 4.7.9-alpha
 * 
 * System appev2 created in: 2019-11-01 22:23:15
 */
class ProdutoDAO 
{

    private static $sqlBasicSelect = 'select
                                      idproduto
                                     ,nom_produto
                                     ,modelo
                                     ,versao
                                     ,idpessoa
                                     ,nom_pessoa
                                     ,idmarca
                                     ,nom_marca
                                     ,idtipo_produto
                                     ,nom_tipo
									 from (select
    									  p.idproduto
    									 ,p.nom_produto
    									 ,p.modelo
    									 ,p.versao
                                         ,vwpmp.idpessoa
                                         ,vwpmp.nome as nom_pessoa
    									 ,p.idmarca
                                         ,vwpmp.nom_marca
    									 ,p.idtipo_produto
                                         ,t.descricao as nom_tipo
    									 from form_exemplo.produto as p
                                             ,form_exemplo.vw_pessoa_marca_produto as vwpmp
                                             ,form_exemplo.tipo as t
                                         where p.idproduto = vwpmp.idproduto
                                         and t.idtipo =  p.idtipo_produto
                                     ) as res';

    private $tpdo = null;

    public function __construct($tpdo=null)
    {
        FormDinHelper::validateObjTypeTPDOConnectionObj($tpdo,__METHOD__,__LINE__);
        if( empty($tpdo) ){
            $tpdo = New TPDOConnectionObj();
        }
        $this->setTPDOConnection($tpdo);
    }
    public function getTPDOConnection()
    {
        return $this->tpdo;
    }
    public function setTPDOConnection($tpdo)
    {
        FormDinHelper::validateObjTypeTPDOConnectionObj($tpdo,__METHOD__,__LINE__);
        $this->tpdo = $tpdo;
    }
    private function processWhereGridParameters( $whereGrid )
    {
        $result = $whereGrid;
        if ( is_array($whereGrid) ){
            $where = ' 1=1 ';
            $where = SqlHelper::getAtributeWhereGridParameters($where, $whereGrid, 'IDPRODUTO', SqlHelper::SQL_TYPE_NUMERIC);
            $where = SqlHelper::getAtributeWhereGridParameters($where, $whereGrid, 'NOM_PRODUTO', SqlHelper::SQL_TYPE_TEXT_LIKE);
            $where = SqlHelper::getAtributeWhereGridParameters($where, $whereGrid, 'MODELO', SqlHelper::SQL_TYPE_TEXT_LIKE);
            $where = SqlHelper::getAtributeWhereGridParameters($where, $whereGrid, 'VERSAO', SqlHelper::SQL_TYPE_TEXT_LIKE);
            $where = SqlHelper::getAtributeWhereGridParameters($where, $whereGrid, 'IDMARCA', SqlHelper::SQL_TYPE_NUMERIC);
            $where = SqlHelper::getAtributeWhereGridParameters($where, $whereGrid, 'IDTIPO_PRODUTO', SqlHelper::SQL_TYPE_NUMERIC);
            $where = SqlHelper::getAtributeWhereGridParameters($where, $whereGrid, 'IDPESSOA', SqlHelper::SQL_TYPE_NUMERIC);
            $result = $where;
        }
        return $result;
    }
    //--------------------------------------------------------------------------------
    public function selectById( $id )
    {
        FormDinHelper::validateIdIsNumeric($id,__METHOD__,__LINE__);
        $values = array($id);
        $sql = self::$sqlBasicSelect.' where idproduto = ?';
        $result = $this->tpdo->executeSql($sql, $values);
        return $result;
    }
    //--------------------------------------------------------------------------------
    public function selectCount( $where=null )
    {
        $where = $this->processWhereGridParameters($where);
		$sql = 'select count(idproduto) as qtd 	from (select
    									  p.idproduto
    									 ,p.nom_produto
    									 ,p.modelo
    									 ,p.versao
                                         ,vwpmp.idpessoa
                                         ,vwpmp.nome as nom_pessoa
    									 ,p.idmarca
                                         ,vwpmp.nom_marca
    									 ,p.idtipo_produto
                                         ,t.descricao as nom_tipo
    									 from form_exemplo.produto as p
                                             ,form_exemplo.vw_pessoa_marca_produto as vwpmp
                                             ,form_exemplo.tipo as t
                                         where p.idproduto = vwpmp.idproduto
                                         and t.idtipo =  p.idtipo_produto
                                     ) as res';
        $sql = $sql.( ($where)? ' where '.$where:'');
        $result = $this->tpdo->executeSql($sql);
        return $result['QTD'][0];
    }
    //--------------------------------------------------------------------------------
    public function selectAllPagination( $orderBy=null, $where=null, $page=null,  $rowsPerPage= null )
    {
        $rowStart = SqlHelper::getRowStart($page,$rowsPerPage);
        $where = $this->processWhereGridParameters($where);

        $sql = self::$sqlBasicSelect
        .( ($where)? ' where '.$where:'')
        .( ($orderBy) ? ' order by '.$orderBy:'')
        .( ' LIMIT '.$rowStart.','.$rowsPerPage);

        $result = $this->tpdo->executeSql($sql);
        return $result;
    }
    //--------------------------------------------------------------------------------
    public function selectAll( $orderBy=null, $where=null )
    {
        $where = $this->processWhereGridParameters($where);
        $sql = self::$sqlBasicSelect
        .( ($where)? ' where '.$where:'')
        .( ($orderBy) ? ' order by '.$orderBy:'');

        $result = $this->tpdo->executeSql($sql);
        return $result;
    }
    //--------------------------------------------------------------------------------
    public function insert( ProdutoVO $objVo )
    {
        $values = array(  $objVo->getNom_produto() 
                        , $objVo->getModelo() 
                        , $objVo->getVersao() 
                        , $objVo->getIdmarca() 
                        , $objVo->getIdtipo_produto() 
                        );
        $sql = 'insert into form_exemplo.produto(
                                 nom_produto
                                ,modelo
                                ,versao
                                ,idmarca
                                ,idtipo_produto
                                ) values (?,?,?,?,?)';
        $result = $this->tpdo->executeSql($sql, $values);
        $result = $this->tpdo->getLastInsertId();
        return intval($result);
    }
    //--------------------------------------------------------------------------------
    public function update ( ProdutoVO $objVo )
    {
        $values = array( $objVo->getNom_produto()
                        ,$objVo->getModelo()
                        ,$objVo->getVersao()
                        ,$objVo->getIdmarca()
                        ,$objVo->getIdtipo_produto()
                        ,$objVo->getIdproduto() );
        $sql = 'update form_exemplo.produto set 
                                 nom_produto = ?
                                ,modelo = ?
                                ,versao = ?
                                ,idmarca = ?
                                ,idtipo_produto = ?
                                where idproduto = ?';
        $result = $this->tpdo->executeSql($sql, $values);
        return intval($result);
    }
    //--------------------------------------------------------------------------------
    public function delete( $id )
    {
        FormDinHelper::validateIdIsNumeric($id,__METHOD__,__LINE__);
        $values = array($id);
        $sql = 'delete from form_exemplo.produto where idproduto = ?';
        $result = $this->tpdo->executeSql($sql, $values);
        return $result;
    }
    //--------------------------------------------------------------------------------
    public function getVoById( $id )
    {
        FormDinHelper::validateIdIsNumeric($id,__METHOD__,__LINE__);
        $result = $this->selectById( $id );
        $result = \ArrayHelper::convertArrayFormDin2Pdo($result,false);
        $result = $result[0];
        $vo = new ProdutoVO();
        $vo = \FormDinHelper::setPropertyVo($result,$vo);
        return $vo;
    }
}
?>