# Styleguides

[Using the atom model](https://github.com/atom/atom/blob/master/CONTRIBUTING.md#styleguides)


### Git Commit Messages

* Use the present tense ("Add feature" not "Added feature")
* Use the imperative mood ("Move cursor to..." not "Moves cursor to...")
* Limit the first line to 72 characters or less
* Reference issues and pull requests liberally after the first line
* When only changing documentation, include `[ci skip]` in the commit description
* Consider starting the commit message with an applicable emoji:
    * :art: `:art:` when changed CSS, Images, Layout
    * :abc: `:abc:` when improving the format/structure of the code
    * :racehorse: `:racehorse:` when improving performance
    * :non-potable_water: `:non-potable_water:` when plugging memory leaks
    * :memo: `:memo:` when writing docs
    * :penguin: `:penguin:` when fixing something on Linux
    * :apple: `:apple:` when fixing something on macOS
    * :checkered_flag: `:checkered_flag:` when fixing something on Windows
    * :bug: `:bug:` when fixing a bug
    * :fire: `:fire:` when removing code or files
    * :green_heart: `:green_heart:` when fixing the CI build
    * :white_check_mark: `:white_check_mark:` when adding tests
    * :hammer: `:hammer:` when adding new features
    * :lock: `:lock:` when dealing with security
    * :arrow_up: `:arrow_up:` when upgrading dependencies
    * :arrow_down: `:arrow_down:` when downgrading dependencies
    * :shirt: `:shirt:` when removing linter warnings

[other images](https://gist.github.com/rxaviers/7360908)


## Documentation Styleguide

* Use AtomDoc.
* Use Markdown.
* Reference methods and classes in markdown with the custom {} notation:
  * Reference classes with {ClassName}
  * Reference instance methods with {ClassName::methodName}
  * Reference class methods with {ClassName.methodName}    

## Example of commit message

emoji BASE OR Example #ISSUE (FIXED) {ClassName.methodName} text comment
