# Разрешения

В BitShares каждый аккаунт разделен на

* **Активное разрешение**: контроль над его средствами и
* **Разрешение владельца**: контроль над аккаунтом.

Оба их можно назначить во вкладке `Разрешения` в Вашем аккаунте, воспользовавшись так называемыми *авторитетами* (см. ниже) в сочетании с так называемым *порогом*, который должен быть преодолен, чтобы транзакция стала действительной.

## Авторитеты

В BitShares *авторитет* состоит из одной или нескольких единиц, которые авторизуют действие, такое как перевод или торговля.

Авторитет состоит из одной или нескольких пар имен аккаунтов с *весом*.

Чтобы получить действительную транзакцию, сумма весов подписывающих сторон должна превысить порог, который определен в разрешениях.

# Примеры

Давайте обсудим несколько примеров, дабы пролить свет на используемую терминологию и варианты применения. Предположим, что новый аккаунт создан с такими активными разрешениями, какие указаны ниже. Обратите внимание, что такая же схема работает и для разрешений владельца!

## (Фиксированная) Мульти-подпись

Фиксированная мульти-подпись состоит из `M` единиц, из которых `N` единиц должны подписать транзакцию, чтобы она стала действительной. Сейчас в BitShares у нас *весы* и *пороги* вместо `M` и `N`. Тем не менее, мы можем достичь того же результата с еще большей гибкостью, как мы сейчас увидим.

Предположим, что Алиса, Боб, Чарли и Денис имеют общие средства. Мы хотим иметь возможность создать действительную транзакцию, если только двое из них согласятся. Значит, **2-из-4** (N-из-M) схема может выглядеть следующим образом:

| Аккаунт       | Вес      |
| ------------- | -------- |
| Алиса         | 33%      |
| Боб           | 33%      |
| Чарли         | 33%      |
| Денис         | 33%      |
| \---\---\---- | \---\--- |
| Порог:        | 51%      |

Все четыре участника имеют 33%, но порог установлен на 51%. Таким образом, нужно согласие всего лишь двух из четырех участников, чтобы подтвердить транзакцию.

Аналогично, чтобы составить схему 3-из-4, мы можем либо уменьшить вес до 17, либо повысить порог до 99%.

## (Фиксированная) Гибкая Мульти-подпись

Теперь, с порогом и весами, мы имеем большую гибкость в отношении наших средств, или точнее, мы обладаем большим *контролем*. Например, мы можем использовать отдельные весы для разных людей. Предположим, что Алиса хочет обезопасить свои средства от кражи, используя схему мульти-подписи, но она не хочет передавать слишком много контроля своим друзьям. Значит, мы создадим авторитет, подобный такому:

| Аккаунт       | Вес      |
| ------------- | -------- |
| Алиса         | 49%      |
| Боб           | 25%      |
| Чарли         | 25%      |
| Денис         | 10%      |
| \---\---\---- | \---\--- |
| Порог:        | 51%      |

Теперь доступ к средствам могут иметь либо Алиса и один из друзей, либо три друга вместе.

## Мульти-иерархическая Гибкая Мульти-подпись

Давайте взглянем на структуру простого мульти-иерархического корпоративного аккаунта. Мы рассматриваем компанию, в которой есть Финансовый Директор (CFO) и несколько отделов, работающих на него, такие как Казначей, Контролер, Налоговый Менеджер, Бухгалтер и т. п. В компании также есть Исполнительный директор (CEO), который хочет обладать привилегией тратить средства. Значит, мы создадим авторитет для средств в соответствии с:

| Аккаунт       | Вес      |
| ------------- | -------- |
| CEO.КОМПАНИИ  | 51%      |
| CFO.КОМПАНИИ  | 51%      |
| \---\---\---- | \---\--- |
| Порог:        | 51%      |

В то же время, CEO.КОМПАНИИ и CFO.КОМПАНИИ имеют свои собственные авторитеты. Например, аккаунт CFO.КОМПАНИИ может выглядеть так:

| CFO.КОМПАНИИ                | Вес      |
| --------------------------- | -------- |
| Шеф.КОМПАНИИ                | 51%      |
| Казначей.КОМПАНИИ           | 33%      |
| Контролер.КОМПАНИИ          | 33%      |
| Налоговый менеджер.КОМПАНИИ | 10%      |
| Бухгалтер.КОМПАНИИ          | 10%      |
| \---\---\---\---\---\----   | \---\--- |
| Порог:                      | 51%      |

Эта схема позволяет:

* CEO расходовать средства
* Финансовому Директору расходовать средства
* Казначею совместно с Контролером расходовать средства
* Контролеру или Казначею совместно с Налоговым менеджером и Бухгалтером расходовать средства.

Значит, попытка установить произвольную глубину может быть растянута, дабы установить гибкий авторитет, чтобы отобразить почти любой случай использования для бизнеса.