# Help

This is the reference wallet of BitShares Blockchain which connects to BitShares Blockchain nodes (bitshares-core).

This help section gives a brief overview and describes the most basic concepts
of this application.

## Introduction 
 * [Disclaimer](disclaimer.md)
 * [BitShares](introduction/bitshares.md)
 * [Wallet](introduction/wallets.md)
 * [Backups](introduction/backups.md)
 * [Blockchain](introduction/blockchain.md)
 * [Witnesses](introduction/witness.md)
 * [Workers](introduction/workers.md)
 * [Committe Members](introduction/committee.md)

## Accounts
 * [Introduction](accounts/general.md)
 * [Permissions](accounts/permissions.md)
 * [Memberships](accounts/membership.md)

## Assets
 * [Market Pegged Assets](assets/mpa.md) (BitUSD, BitEUR, BitGOLD, Bit\*,...)
 * [User Issued Assets](assets/uia.md)
 * [Privatized BitAssets](assets/privbitassets.md)

## Decentralized Exchange
 * [Introduction](dex/introduction.md)
 * [Trading](dex/trading.md)
 * [Short Selling BitAssets](dex/shorting.md)

## Development
 * [Bitshares UI Github](https://github.com/bitshares/bitshares-ui)

----------
[Glossary](glossary.md)
