# Decentralized Exchange

The decentralized exchange (further denoted simply as *the DEX*) allows for
direct exchange of digital goods traded in the BitShares ecosystem.

A decentralized exchange has a very particular set of advantages over
traditional centralized exchanges and we would like to address some of them
briefly below. Although the BitShares DEX comes with all of them, it is up to
the reader and customer to leverage those features in full or only partially.

* **Separation of Powers**: 
  There is no reason why the same entity needs to be responsible for
  issuing IOUs and for processing the order book. In BitShares, order matching
  is performed by the protocol, which is unaware of implications concerning the
  involved assets.
  
* **Global Unified Order Book**:
  Since BitShares is global, anybody with an internet access can use the DEX for
  trading. This brings the world's liquidity to a single order book for
  decentralized trading.
  
* **Trade Almost Anything**:
  The BitShares DEX is asset agnostic. Hence you can trade at **any** pair.
  While some pairs may end up with low liquidity, such as SILVER:GOLD, other
  pairs such as USD:EUR for FOREX trading will see huge volume.
  
* **No Limits**:
  The BitShares protocol is unable to limit your trading experience.
  
* **Decentralized**:
  The DEX is decentralized across the globe. This not only means that there is
  no single point of failure, but it also implies that the BitShares exchange is
  open for trading 24/7 because it's always daytime somewhere.
  
* **Secure**:
  Your funds and trades are secured with industry-grade elliptic curve
  cryptography. No one will be able to access your funds unless you let them. To
  further strengthen the security, we allow our customers to setup escrow and
  multi-signature schemes.
  
* **Fast**:
  In contrast to other decentralized networks, the BitShares DEX allows for
  real-time trading and is only limited by the speed of light and the size of
  the planet.
  
* **Provable Order Matching Algorithm**:
  What makes the BitShares DEX unique is the provable order matching algorithm.
  Given a set of orders, you will always be able to provably verify that these
  orders have been matched properly.
  
* **Collateralized Smartcoins**:
  One of the biggest features of BitShares are its *smartcoins* such as bitUSD,
  bitEUR, bitCNY, and others. For the sake of convenience, these assets are
  denotes simply as USD, EUR, CNY, etc. in the wallet. These digital tokens
  represent the same value as their underlaying physical asset. Hence 1 USD in
  this wallet is worth $1 and can be redeemed as such. Any of these tokens is
  backed by BitShares' company shares (BTS) being locked up as collateral and
  being available for settlement at its current price.
