#!/bin/bash

# This script will be run in the initial LFS chroot environment as
# the root user.
#
# DO NOT RUN THIS SCRIPT ON THE HOST SYSTEM OR AS THE LFS USER
# This script should only AND ONLY run in the chroot environment

prog_line()
{
	printf "> $1\n"
}

prog_line "Creating the rest of the Linux directory structure"
mkdir -pv /{boot,home,mnt,opt,srv}
mkdir -pv /etc/{opt,sysconfig}
mkdir -pv /lib/firmware
mkdir -pv /media/{floppy,cdrom}
mkdir -pv /usr/{,local/}{include,src}
mkdir -pv /usr/local/{bin,lib,sbin}
mkdir -pv /usr/{,local/}share/{color,dict,doc,info,locale,man}
mkdir -pv /usr/{,local/}share/{misc,terminfo,zoneinfo}
mkdir -pv /usr/{,local/}share/man/man{1..8}
mkdir -pv /var/{cache,local,log,mail,opt,spool}
mkdir -pv /var/lib/{color,misc,locate}

mkdir -pv /usr/share/fonts/TTF
touch /usr/share/fonts/TTF/.birb_symlink_lock
mkdir -pv /usr/share/fonts/X11/{misc,util}
touch /usr/share/fonts/X11/misc/.birb_symlink_lock,util
touch /usr/share/fonts/X11/util/.birb_symlink_lock,util

mkdir -pv /usr/share/applications
touch /usr/share/applications/.birb_symlink_lock

# Make sure that birb doesn't create any symlinks to certain
# empty directories
touch /sbin/.birb_symlink_lock

ln -sfv /run /var/run
ln -sfv /run/lock /var/lock

install -dv -m 0750 /root
install -dv -m 1777 /tmp /var/tmp

prog_line "Creating some important files and symlinks"
ln -sv /proc/self/mounts /etc/mtab

cat > /etc/hosts << EOF
127.0.0.1  localhost $(hostname)
::1        localhost
EOF

cat > /etc/passwd << "EOF"
root:x:0:0:root:/root:/bin/bash
bin:x:1:1:bin:/dev/null:/usr/bin/false
daemon:x:6:6:Daemon User:/dev/null:/usr/bin/false
messagebus:x:18:18:D-Bus Message Daemon User:/run/dbus:/usr/bin/false
uuidd:x:80:80:UUID Generation Daemon User:/dev/null:/usr/bin/false
nobody:x:65534:65534:Unprivileged User:/dev/null:/usr/bin/false
EOF

cat > /etc/group << "EOF"
root:x:0:
bin:x:1:daemon
sys:x:2:
kmem:x:3:
tape:x:4:
tty:x:5:
daemon:x:6:
floppy:x:7:
disk:x:8:
lp:x:9:
dialout:x:10:
audio:x:11:
video:x:12:
utmp:x:13:
usb:x:14:
cdrom:x:15:
adm:x:16:
messagebus:x:18:
input:x:24:
mail:x:34:
kvm:x:61:
uuidd:x:80:
wheel:x:97:
users:x:999:
nogroup:x:65534:
EOF

prog_line "Creating a normal user required for some tests"
echo "tester:x:101:101::/home/tester:/bin/bash" >> /etc/passwd
echo "tester:x:101:" >> /etc/group
install -o tester -d /home/tester

prog_line "Restarting the shell"
echo "After the shell restart, run the script 'chroot-install-part-2.sh'. It should be located at the root directory"
exec /usr/bin/bash --login
