#!/bin/bash
# shellcheck disable=SC1090,SC2154
# https://www.linuxfromscratch.org/~thomas/multilib/chapter06/gcc-pass2.html
set -e
~/bootstrap-scripts/installation_progress_manager.sh check "$0" && exit 0
source ~/bootstrap-scripts/packages.sh

PACKAGE="$gcc"

. ~/bootstrap-scripts/prepare_sources.sh "$PACKAGE"

# Extract some packages that aren't yet compiled into the system
tar -xf ../mpfr-4.2.1.tar.xz
mv -v mpfr-4.2.1 mpfr
tar -xf ../gmp-6.3.0.tar.xz
mv -v gmp-6.3.0 gmp
tar -xf ../mpc-1.3.1.tar.gz
mv -v mpc-1.3.1 mpc

# shellcheck disable=SC2016
sed -e '/m64=/s/lib64/lib/' \
    -e '/m32=/s/m32=.*/m32=..\/lib32$(call if_multiarch,:i386-linux-gnu)/' \
    -i.orig gcc/config/i386/t-linux64

sed '/thread_header =/s/@.*@/gthr-posix.h/' \
    -i libgcc/Makefile.in libstdc++-v3/include/Makefile.in

mkdir -v build
cd       build

mlist=m64,m32
../configure                                       \
    --build="$(../config.guess)"                   \
    --host="$LFS_TGT"                              \
    --target="$LFS_TGT"                            \
    LDFLAGS_FOR_TARGET=-L"$PWD/$LFS_TGT/libgcc"    \
    --prefix=/usr                                  \
    --with-build-sysroot="$LFS"                    \
    --enable-default-pie                           \
    --enable-default-ssp                           \
    --disable-nls                                  \
    --enable-multilib --with-multilib-list=$mlist  \
    --disable-libatomic                            \
    --disable-libgomp                              \
    --disable-libquadmath                          \
    --disable-libsanitizer                         \
    --disable-libssp                               \
    --disable-libvtv                               \
    --enable-languages=c,c++

make -j "$(nproc)"

make DESTDIR="$LFS" install

# Symlink cc to gcc
ln -sv gcc "$LFS/usr/bin/cc"

~/bootstrap-scripts/remove_sources.sh "$PACKAGE"
~/bootstrap-scripts/installation_progress_manager.sh add "$0"
