#!/bin/bash
# shellcheck disable=SC1090,SC2154
# https://www.linuxfromscratch.org/~thomas/multilib/chapter06/coreutils.html
set -e
~/bootstrap-scripts/installation_progress_manager.sh check "$0" && exit 0
source ~/bootstrap-scripts/packages.sh

PACKAGE="$coreutils"

. ~/bootstrap-scripts/prepare_sources.sh "$PACKAGE"

./configure --prefix=/usr                       \
            --host="$LFS_TGT"                   \
            --build="$(build-aux/config.guess)" \
            --enable-install-program=hostname   \
            --enable-no-install-program=kill,uptime

make -j "$(nproc)"

make DESTDIR="$LFS" install

# Move programs to their final expected locations
mv -v "$LFS/usr/bin/chroot"              "$LFS/usr/sbin"
mkdir -pv "$LFS/usr/share/man/man8"
mv -v "$LFS/usr/share/man/man1/chroot.1" "$LFS/usr/share/man/man8/chroot.8"
sed -i 's/"1"/"8"/'                    "$LFS/usr/share/man/man8/chroot.8"

~/bootstrap-scripts/remove_sources.sh "$PACKAGE"
~/bootstrap-scripts/installation_progress_manager.sh add "$0"
