import type { Ref } from 'vue';
import { nextTick, ref } from 'vue';

type ScrollElement = HTMLDivElement | null;

interface ScrollReturn {
	scrollRef: Ref<ScrollElement>;
	scrollToBottom: () => Promise<void>;
	scrollToTop: () => Promise<void>;
}

export function useScroll(): ScrollReturn {
	const scrollRef = ref<ScrollElement>(null);

	const scrollToBottom = async () => {
		await nextTick();
		if (scrollRef.value)
			scrollRef.value.scrollTop = scrollRef.value.scrollHeight;
	};

	const scrollToTop = async () => {
		await nextTick();
		if (scrollRef.value) scrollRef.value.scrollTop = 0;
	};

	return {
		scrollRef,
		scrollToBottom,
		scrollToTop,
	};
}
