export const CODE_CONTROL = ['Shift', 'Control', 'Alt', 'Meta'];

export const MAC_CODE_CONTROL_MAP = [
	{ code: 'Shift', text: '⇧' },
	{ code: 'Control', text: '⌃' },
	{ code: 'Alt', text: '⌥' },
	{ code: 'Meta', text: '⌘' },
];

export const WIN_CODE_CONTROL_MAP = [
	{ code: 'Shift', text: '⇧' },
	{ code: 'Control', text: '⌃' },
	{ code: 'Alt', text: '⎇' },
	{ code: 'Meta', text: '⊞' },
];

export const CODE_ABC_MAP = [
	{ code: 'KeyA', text: 'A' },
	{ code: 'KeyB', text: 'B' },
	{ code: 'KeyC', text: 'C' },
	{ code: 'KeyD', text: 'D' },
	{ code: 'KeyE', text: 'E' },
	{ code: 'KeyF', text: 'F' },
	{ code: 'KeyG', text: 'G' },
	{ code: 'KeyH', text: 'H' },
	{ code: 'KeyI', text: 'I' },
	{ code: 'KeyJ', text: 'J' },
	{ code: 'KeyK', text: 'K' },
	{ code: 'KeyL', text: 'L' },
	{ code: 'KeyM', text: 'M' },
	{ code: 'KeyN', text: 'N' },
	{ code: 'KeyO', text: 'O' },
	{ code: 'KeyP', text: 'P' },
	{ code: 'KeyQ', text: 'Q' },
	{ code: 'KeyR', text: 'R' },
	{ code: 'KeyS', text: 'S' },
	{ code: 'KeyT', text: 'T' },
	{ code: 'KeyU', text: 'U' },
	{ code: 'KeyV', text: 'V' },
	{ code: 'KeyW', text: 'W' },
	{ code: 'KeyX', text: 'X' },
	{ code: 'KeyY', text: 'Y' },
	{ code: 'KeyZ', text: 'Z' },
];

export const CODE_DIGIT_MAP = [
	{ code: 'Digit0', text: '0' },
	{ code: 'Digit1', text: '1' },
	{ code: 'Digit2', text: '2' },
	{ code: 'Digit3', text: '3' },
	{ code: 'Digit4', text: '4' },
	{ code: 'Digit5', text: '5' },
	{ code: 'Digit6', text: '6' },
	{ code: 'Digit7', text: '7' },
	{ code: 'Digit8', text: '8' },
	{ code: 'Digit9', text: '9' },
];

export const CODE_FN_MAP = [
	{ code: 'F1', text: 'F1' },
	{ code: 'F2', text: 'F2' },
	{ code: 'F3', text: 'F3' },
	{ code: 'F4', text: 'F4' },
	{ code: 'F5', text: 'F5' },
	{ code: 'F6', text: 'F6' },
	{ code: 'F7', text: 'F7' },
	{ code: 'F8', text: 'F8' },
	{ code: 'F9', text: 'F9' },
	{ code: 'F10', text: 'F10' },
	{ code: 'F11', text: 'F11' },
	{ code: 'F12', text: 'F12' },
];

export const CODE_NUMPAD_MAP = [
	{ code: 'Numpad0', text: '0' },
	{ code: 'Numpad1', text: '1' },
	{ code: 'Numpad2', text: '2' },
	{ code: 'Numpad3', text: '3' },
	{ code: 'Numpad4', text: '4' },
	{ code: 'Numpad5', text: '5' },
	{ code: 'Numpad6', text: '6' },
	{ code: 'Numpad7', text: '7' },
	{ code: 'Numpad8', text: '8' },
	{ code: 'Numpad9', text: '9' },
	{ code: 'NumpadDecimal', text: '.' },
	{ code: 'NumpadDivide', text: '/' },
	{ code: 'NumpadMultiply', text: '*' },
	{ code: 'NumpadSubtract', text: '-' },
	{ code: 'NumpadAdd', text: '+' },
	{ code: 'NumpadEnter', text: 'Enter' },
	{ code: 'NumpadEqual', text: '=' },
];

export const CODE_OTHER_MAP = [
	{ code: 'Backspace', text: '←' },
	{ code: 'Tab', text: '↹' },
	{ code: 'Enter', text: '↵' },
	{ code: 'CapsLock', text: '⇪' },
	{ code: 'Escape', text: 'Esc' },
	{ code: 'Space', text: 'Space' },
	{ code: 'PageUp', text: 'PageUp' },
	{ code: 'PageDown', text: 'PageDown' },
	{ code: 'End', text: 'End' },
	{ code: 'Home', text: 'Home' },
	{ code: 'ArrowLeft', text: '←' },
	{ code: 'ArrowUp', text: '↑' },
	{ code: 'ArrowRight', text: '→' },
	{ code: 'ArrowDown', text: '↓' },
	{ code: 'Insert', text: 'Insert' },
	{ code: 'Delete', text: 'Delete' },
	{ code: 'ContextMenu', text: 'ContextMenu' },
	{ code: 'NumLock', text: 'NumLock' },
	{ code: 'ScrollLock', text: 'ScrollLock' },
	{ code: 'AudioVolumeMute', text: 'AudioVolumeMute' },
	{ code: 'AudioVolumeDown', text: 'AudioVolumeDown' },
	{ code: 'AudioVolumeUp', text: 'AudioVolumeUp' },
	{ code: 'MediaTrackNext', text: 'MediaTrackNext' },
	{ code: 'MediaTrackPrevious', text: 'MediaTrackPrevious' },
	{ code: 'MediaStop', text: 'MediaStop' },
	{ code: 'MediaPlayPause', text: 'MediaPlayPause' },
	{ code: 'Semicolon', text: ';' },
	{ code: 'Equal', text: '=' },
	{ code: 'NumpadEqual', text: '=' },
	{ code: 'Comma', text: ',' },
	{ code: 'Minus', text: '-' },
	{ code: 'Period', text: '.' },
	{ code: 'Slash', text: '/' },
	{ code: 'Backquote', text: '`' },
	{ code: 'BracketLeft', text: '[' },
	{ code: 'Backslash', text: '\\' },
	{ code: 'BracketRight', text: ']' },
	{ code: 'Quote', text: "'" },
];

export const CODE_KEY_MAP = [
	...CODE_ABC_MAP,
	...CODE_DIGIT_MAP,
	...CODE_FN_MAP,
	...CODE_NUMPAD_MAP,
	...CODE_OTHER_MAP,
];

export const MAC_CODE_KEY_MAP = [
	...CODE_ABC_MAP,
	...CODE_DIGIT_MAP,
	...CODE_FN_MAP,
	...CODE_NUMPAD_MAP,
	...CODE_OTHER_MAP,
	...MAC_CODE_CONTROL_MAP,
];

export const WIN_CODE_KEY_MAP = [
	...CODE_ABC_MAP,
	...CODE_DIGIT_MAP,
	...CODE_FN_MAP,
	...CODE_NUMPAD_MAP,
	...CODE_OTHER_MAP,
	...WIN_CODE_CONTROL_MAP,
];

export const platformsCodeKeyMap = (code: string) => {
	let codeMap;
	if (window.navigator.platform.startsWith('Mac')) {
		codeMap = MAC_CODE_KEY_MAP;
	} else {
		codeMap = WIN_CODE_KEY_MAP;
	}

	const codeInfo = codeMap.find((item) => item.code === code);
	return codeInfo ? codeInfo.text : code;
};
