namespace Ordering.UnitTests.Domain.Models.Builders
{
    public class OrderBuilder
    {
        private readonly Order order;

        public OrderBuilder(Address address)
        {
            order = new Order(
                Guid.NewGuid(),
                "fakeName",
                address,
                cardTypeId: 5,
                cardNumber: "12",
                cardSecurityNumber: "123",
                cardHolderName: "name",
                cardExpiration: DateTime.UtcNow);
        }

        public OrderBuilder AddItem(
            int productId,
            string productName,
            decimal unitPrice,
            decimal discount,
            string pictureUrl,
            int units = 1)
        {
            order.AddOrderItem(productId, productName, unitPrice, discount, pictureUrl, units);
            return this;
        }

        public Order Build()
        {
            return order;
        }
    }
}