# Every front-end GUI client for ChatGPT API

Similar to [Every Proximity Chat App](https://github.com/billmei/every-proximity-chat-app), I made this list to keep track of every graphical user interface alternative to access the API for ChatGPT, Claude, and other LLMs.

If you want to add your app, feel free to open a pull request to add your app to the list. You can list your app under the appropriate category in alphabetical order. If you want your app removed from this list, you can also open a pull request to do that too.

## Open Source

### Web
- AI Chat | [demo](https://aichat.ksdev.pl) | [source](https://github.com/ksdev-pl/ai-chat)
- AI Belvedere | [demo](https://ai-belvedere-demo.alergant.us) | [source](https://github.com/DmitriyAlergant-T1A/ai-belvedere/)
- BetterChatGPT | [demo](https://bettergpt.chat/) | [source](https://github.com/ztjhz/BetterChatGPT)
- big-AGI | [demo](https://big-agi.com) | [source](https://github.com/enricoros/big-agi)
- claude-ui | [source](https://github.com/chihebnabil/claude-ui)
- Chatbot UI | [demo](https://www.chatbotui.com/) | [source](https://github.com/mckaywrigley/chatbot-ui)
- ChatGPT AI Template | [demo](https://horizon-ui.com/chatgpt-ai-template/) | [source](https://github.com/horizon-ui/chatgpt-ai-template)
- ChatGPT-API Demo | [demo](https://chatgpt.ddiu.me/) | [source](https://github.com/ddiu8081/chatgpt-demo)
- ChatGPT Cloned | [demo](https://chat-gpt-cloned.netlify.app/) | [source](https://github.com/PrasadBroo/ChatGPT)
- ChatGPT Lite | [demo](https://gptlite.vercel.app) | [source](https://github.com/blrchen/chatgpt-lite)
- ChatGPT Minimal | [demo](https://chatgpt-minimal.vercel.app) | [source](https://github.com/blrchen/chatgpt-minimal)
- ChatGPT Next Web | [demo](https://app.nextchat.dev/) | [source](https://github.com/ChatGPTNextWeb/ChatGPT-Next-Web)
- ChatGPT-Vercel | [demo](https://www.chatsverse.xyz/) | [source](https://github.com/ourongxing/chatgpt-vercel)
- ChatGPT-web | [demo](https://niek.github.io/chatgpt-web/) | [source](https://github.com/Niek/chatgpt-web)
- Chat with GPT | [demo](https://www.chatwithgpt.ai/) | [source](https://github.com/cogentapps/chat-with-gpt)
- L-GPT | [demo](https://le-ai.app/) | [source](https://github.com/Peek-A-Booo/L-GPT)
- LobeChat | [demo](https://lobechat.com/) | [source](https://github.com/lobehub/lobe-chat)
- MyChatGPT | [demo](https://my-chat-gpt-lake.vercel.app/) | [source](https://github.com/Loeffeldude/my-chat-gpt)
- OrionChat | [demo](https://eliaspereirah.github.io/OrionChat) | [source](https://github.com/EliasPereirah/OrionChat)
- SlickGPT | [demo](https://slickgpt.vercel.app) | [source](https://github.com/ShipBit/slickgpt)
- SmoothGPT | [demo](https://smoothgpt.app) | [source](https://github.com/agambon/SmoothGPT) (fork of [ChatGPT UI](https://github.com/patrikzudel/PatrikZeros-ChatGPT-API-UI))
- vanilla-chatgpt | [demo](https://raw.githack.com/casualwriter/vanilla-chatgpt/main/source/index.html) | [source](https://github.com/casualwriter/vanilla-chatgpt)
- WebLLM | [demo](https://chat.webllm.ai/) | [source](https://github.com/mlc-ai/web-llm-chat)


### Browser Extension
- chatGPTBox | [source](https://github.com/josStorer/chatGPTBox)  | [Firefox](https://addons.mozilla.org/firefox/addon/chatgptbox/) | [Chrome](https://chrome.google.com/webstore/detail/chatgptbox/eobbhoofkanlmddnplfhnmkfbnlhpbbo) | [Edge](https://microsoftedge.microsoft.com/addons/detail/fission-chatbox-best/enjmfilpkbbabhgeoadmdpjjpnahkogf) | [Safari](https://apps.apple.com/app/fission-chatbox/id6446611121)
- ChatHub | [source](https://github.com/chathub-dev/chathub/) | [Chrome](https://chrome.google.com/webstore/detail/chathub-all-in-one-chatbo/iaakpnchhognanibcahlpcplchdfmgma?utm_source=every-chat-gpt-gui) | [Edge](https://microsoftedge.microsoft.com/addons/detail/chathub-allinone-chat/kdlmggoacmfoombiokflpeompajfljga?utm_source=every-chat-gpt-gui)
- Superpower ChatGPT | [source](https://github.com/saeedezzati/superpower-chatgpt) | [Chrome](https://chrome.google.com/webstore/detail/superpower-chatgpt/amhmeenmapldpjdedekalnfifgnpfnkc) | [Firefox](https://addons.mozilla.org/en-US/firefox/addon/superpower-chatgpt/)

### Self-Hosted
- Anse | [demo](https://anse.app) | [source](https://github.com/anse-app/anse)
- ChatGPT Web | [source](https://github.com/Chanzhaoyu/chatgpt-web)
- Chatpad AI | [demo](https://chatpad.ai) | [source](https://github.com/deiucanta/chatpad)
- GPTPortal | [source](https://github.com/Zaki-1052/GPTPortal)
- Intelligence Hub | [source](https://github.com/streaver91/intelligence-hub)
- LibreChat | [demo](https://librechat-librechat.hf.space/login) | [source](https://github.com/danny-avila/LibreChat)
- Open WebUI | [source](https://github.com/open-webui/open-webui)
- VT.ai | [source](https://github.com/vinhnx/vt.ai)
- YakGPT | [demo](https://yakgpt.vercel.app) | [source](https://github.com/yakGPT/yakGPT)

### Desktop
- AnythingLLM | [download](https://github.com/Mintplex-Labs/anything-llm) | [source](https://github.com/Mintplex-Labs/anything-llm)
- Chatbox | [download](https://chatboxapp.xyz/) | [source](https://github.com/Bin-Huang/chatbox)
- ChatGPT menubar app | [source](https://github.com/sw-yx/chatgpt-mac)
- Clipboard Conqueror | [source](https://github.com/aseichter2007/ClipboardConqueror)
- GPTextual | [source](https://github.com/stefankirchfeld/gptextual)
- Marvin | [download](https://www.askmarvin.ai/) | [source](https://github.com/prefecthq/marvin)

## Not Open Source

### Web
- AI.LS | [demo](https://ai.ls/)
- AICamp | [demo](https://aicamp.so)
- Chatbus AI | [demo](https://www.chatbus.ai)
- ChatKit | [demo](https://chatkit.app/)
- grafychat | [demo](https://grafychat.com)
- Horizon AI Template | [demo](https://horizon-ui.com/horizon-ai-template/)
- InfernoAI | [demo](https://www.getinfernoai.com/)
- Keynet.AI | [demo](https://keynet.ai/)
- KoalaChat | [demo](https://koala.sh/chat)
- Mammouth | [demo](https://mammouth.ai/)
- MyGPT | [demo](https://mygpt.thesamur.ai/)
- Poe | [demo](https://poe.com/)
- TypingMind | [demo](https://www.typingmind.com)
- Wielded | [demo](https://wielded.com/)
- You.com | [demo](https://you.com/plans)

### Desktop
- BoltAI | [download](https://boltai.app/)
- ChatGPT Toolkit | [download](https://schmedu.com/tools/chatGpt)
- EasyChat AI | [download](https://easychat-ai.app/)
- FridayGPT | [download](https://www.fridaygpt.app/)
- GPT4All | [download](https://www.nomic.ai/gpt4all)
- MacGPT | [download](https://www.macgpt.com/)
- Msty | [download](https://msty.app)
- Writers brew | [download](https://writersbrew.app)

# More plugins and tools
- [Awesomelist](https://github.com/reorx/awesome-chatgpt-api)
