import Vue from 'vue'
import Router from 'vue-router'
/* Layout */
import Layout from '@/layout'
import { SysPerms } from '@/utils/enums/perms/system'
import { MiscPerms } from '@/utils/enums/perms/misc'
import { LibPerms } from '@/utils/enums/perms/library'

Vue.use(Router)

/**
 * Note: sub-menu only appear when route children.length >= 1
 * Detail see: https://panjiachen.github.io/vue-element-admin-site/guide/essentials/router-and-nav.html
 *
 * hidden: true                   if set true, item will not show in the sidebar(default is false)
 * alwaysShow: true               if set true, will always show the root menu
 *                                if not set alwaysShow, when item has more than one children route,
 *                                it will becomes nested mode, otherwise not show the root menu
 * redirect: noRedirect           if set noRedirect will no redirect in the breadcrumb
 * name:'router-name'             the name is used by <keep-alive> (must set!!!)
 * meta : {
    roles: ['admin','editor']    control the page roles (you can set multiple roles)
    title: 'title'               the name show in sidebar and breadcrumb (recommend set)
    icon: 'svg-name'/'el-icon-x' the icon show in the sidebar
    noCache: true                if set true, the page will no be cached(default is false)
    affix: true                  if set true, the tag will affix in the tags-view
    breadcrumb: false            if set false, the item will hidden in breadcrumb(default is true)
    activeMenu: '/example/list'  if set path, the sidebar will highlight the path you set
  }
 */

/**
 * constantRoutes
 * a base page that does not have permission requirements
 * all roles can be accessed
 */
export const constantRoutes = [
  {
    path: '/redirect',
    component: Layout,
    hidden: true,
    children: [
      {
        path: '/redirect/:path(.*)',
        component: () => import('@/views/redirect')
      }
    ]
  },
  {
    path: '/login',
    component: () => import('@/views/login'),
    hidden: true
  },
  {
    path: '/auth-redirect',
    component: () => import('@/views/login/auth-redirect'),
    hidden: true
  },
  {
    path: '/404',
    component: () => import('@/views/error-page/404'),
    hidden: true
  },
  {
    path: '/401',
    component: () => import('@/views/error-page/401'),
    hidden: true
  },
  {
    path: '/',
    component: Layout,
    redirect: '/dashboard',
    children: [
      {
        path: 'dashboard',
        component: () => import('@/views/dashboard'),
        name: 'Dashboard',
        meta: { title: '首页', icon: 'dashboard', affix: true }
      }
    ]
  },

  {
    path: '/profile',
    component: Layout,
    redirect: '/profile/index',
    hidden: true,
    children: [
      {
        path: 'index',
        component: () => import('@/views/profile'),
        name: 'Profile',
        meta: { title: '个人中心', icon: 'user', noCache: true }
      }
    ]
  }
]

/**
 * asyncRoutes
 * the routes that need to be dynamically loaded based on user perms
 */
export const asyncRoutes = [
  {
    path: '/system',
    name: 'System',
    component: Layout,
    redirect: "noRedirect",
    meta: { perm: SysPerms.menu_sys, title: '系统管理', icon: 'chart' },
    children: [
      {
        path: 'user',
        component: () => import('@/views/_module/_system/user'),
        name: 'SystemUserManage',
        meta: { perm: SysPerms.menu_sys_user, title: '用户管理', icon: 'user' }
      },
      {
        path: 'role',
        component: () => import('@/views/_module/_system/role'),
        name: 'SystemRoleManage',
        meta: { perm: SysPerms.menu_sys_role, title: '角色管理', icon: 'peoples' }
      },
      {
        path: 'perm',
        component: () => import('@/views/_module/_system/perm'),
        name: 'SystemPermManage',
        meta: { perm: SysPerms.menu_sys_perm, title: '权限管理', icon: 'lock' }
      }
    ]
  },

  {
    path: '/library',
    name: 'Library',
    component: Layout,
    redirect: "noRedirect",
    meta: { perm: LibPerms.menu_lib, title: '馆藏管理', icon: 'chart' },
    children: [
      {
        path: 'author',
        component: () => import('@/views/_module/library/author'),
        name: 'LibraryAuthorManage',
        meta: { perm: LibPerms.menu_lib_author, title: '作者管理', icon: 'user' }
      },
      {
        path: 'publisher',
        component: () => import('@/views/_module/library/publisher'),
        name: 'LibraryPublisherManage',
        meta: { perm: LibPerms.menu_lib_publisher, title: '出版社管理', icon: 'component' }
      },
      {
        path: 'book',
        component: () => import('@/views/_module/library/book'),
        name: 'LibraryBookManage',
        meta: { perm: LibPerms.menu_lib_book, title: '图书管理', icon: 'education' }
      },
    ]
  },

  {
    path: '/icons',
    component: Layout,
    redirect: '/icons/index',
    children: [
      {
        path: 'index',
        component: () => import('@/views/icons'),
        name: 'Icons',
        meta: { perm: MiscPerms.menu_icons, title: '图标预览', icon: 'icon', noCache: true }
      }
    ]
  },

  {
    path: '/docs',
    component: Layout,
    redirect: "noRedirect",
    meta: { perm: MiscPerms.menu_docs, title: '外部文档', icon: 'documentation' },
    children: [
      {
        path: 'https://cn.vuejs.org/v2/guide/',
        meta: { perm: MiscPerms.menu_docs_vue, title: 'Vue', icon: 'link' }
      },
      {
        path: 'https://element.eleme.cn/#/zh-CN/component/installation',
        meta: { perm: MiscPerms.menu_docs_element, title: 'ElementUI', icon: 'link' }
      },
      {
        path: 'https://lodash.com/docs',
        meta: { perm: MiscPerms.menu_docs_lodash, title: 'Lodash', icon: 'link' }
      },
      {
        path: 'https://moment.github.io/luxon/docs/index.html',
        meta: { perm: MiscPerms.menu_docs_luxon, title: 'Luxon', icon: 'link' }
      },
      {
        path: 'https://github.com/you-dont-need/You-Dont-Need-Lodash-Underscore',
        meta: { perm: MiscPerms.menu_docs_ydnlu, title: 'YDNLU', icon: 'link' }
      },

    ]
  },

  // 404 page must be placed at the end !!!
  { path: '*', redirect: '/404', hidden: true }
]

const createRouter = () => new Router({
  mode: 'history', // require service support
  scrollBehavior: () => ({ y: 0 }),
  routes: constantRoutes
})

const router = createRouter()

// Detail see: https://github.com/vuejs/vue-router/issues/1234#issuecomment-357941465
export function resetRouter() {
  const newRouter = createRouter()
  router.matcher = newRouter.matcher // reset router
}

export default router
