{# serial_post.h #}
{# DEFAULT_LICENCE.md is used #}
{{ license|safe }}
/*
{# Start with generated warning. It you want to change something, edit this file #}
This file is automatically generated by src/utils/gen-serial.py script from src/utils/templates/serial_post.h jinja2 template.
Do not modify this file directly, your changes will be eventually lost.
See template{# THIS #} file for aditional documentation.

To generate this file again, run
> python ./src/utils/gen-serial-j2.py > ./src/main/target/serial_post.h
in Betaflight topmost directory.

This include will provide following defines:
SERIAL_<type><n>_USED 0/1 - always defined, value depends on target configuration
SERIAL_<type>_MASK        - bitmask of used ports or given type. <port>0 or <port>1 is BIT(0), based on port first_index
SERIAL_<type>_COUNT       - number of enabled ports of given type
SERIAL_<type>_MAX         - <index of highest used port> + 1, 0 when no port is enabled

All <type><n>_(RX|TX)_PINS are normalized too:
 - if port is enabled, both will be defined (possibly as NONE)
 - if port is not enable, both will be undefined, possibly with warning
  - pass -DWARN_UNUSED_SERIAL_PORT to compiler to check pin defined without corresponding port being enabled.

{# add some usefull info #}
Generated on {{ date_generated }}

Configuration used:
{# TODO - maybe store configuration in this file, not Python one #}
{# TODO - pretty is not enough pretty #}
{{ user_config|pprint|safe }}
*/

#include "common/utils.h" // BIT, LOG2
{# config array is passed to this script. It is flattened version of user_config, with defaults filled in #}
{% for cfg in config %}

/****                                {{ cfg.typ }}                                 *****/

{%   if cfg.first_index %}
// normalize SERIAL_{{ cfg.typ }}_FIRST_INDEX
#ifndef SERIAL_{{ cfg.typ }}_FIRST_INDEX
#define SERIAL_{{ cfg.typ }}_FIRST_INDEX 1
#endif

{%   endif %}
{#   use_enables_all - USE_<type> enables all ports of this type #}
{%   if cfg.use_enables_all %}
#if defined(USE_{{cfg.typ}})
// USE_{{cfg.typ}} enables all {{cfg.typ}} ports
{%     for port in cfg.ports %}
# if !defined(USE_{{port}})
#  define USE_{{port}}
# endif
{%     endfor %}
#endif

{%   endif %}
{#   USE_<port> - SERIAL_<port>_USED 0/1 #}
{%   for port, i in cfg.ports|zip(cfg.ids|default([-1])) %}{# handle singleton without ids #}
{%    if i == 0 and cfg.first_index %}{# port 0, test if it is allowed #}
#if SERIAL_{{ cfg.typ }}_FIRST_INDEX == 0
{%    endif %}
#if defined(USE_{{port}})
# define SERIAL_{{port}}_USED 1
#else
# define SERIAL_{{port}}_USED 0
#endif
{%    if i == 0 and cfg.first_index %}{# port 0, #else branch #}
#else // USE_{{port}} is not allowed
# if defined(USE_{{port}})
#  error "USE_{{port}} is defined, but SERIAL_{{ cfg.typ }} does not allow index 0"
# else
#  define SERIAL_{{port}}_USED 0
# endif
#endif
{%    endif %}
{%   endfor %}

{#   SERIAL_<port>_* summary macros #}
{%   if not cfg.singleton %}
{%     set pipe = joiner(' | ') %}
#define SERIAL_{{ cfg.typ }}_MASK ({% for port, i in cfg.ports|zip(cfg.ids) %}
    {{- pipe() }}(SERIAL_{{ port }}_USED * BIT({{ "0" if i==0 else "{} - SERIAL_{}_FIRST_INDEX".format(i, cfg.typ) if cfg.first_index else "{} - 1".format(i) }})){% endfor %})
{# export first index information, so serial.h can assert that it does match #}
{%   else %}
{#     one port without number is defined #}
// for consistency, set one bit if port is enabled
#define SERIAL_{{ cfg.typ }}_MASK (SERIAL_{{ cfg.ports[0] }}_USED * BIT(0))
{%   endif %}
{%   set plus = joiner(' + ') %}
#define SERIAL_{{ cfg.typ }}_COUNT ({% for port in cfg.ports %}{{ plus() }}SERIAL_{{ port }}_USED{% endfor %})
// 0 if no port is defined
{# LOG2 is simpler than chaining MAX(SERIAL_x1_USED * 1, MAX(SERIAL_x2_USED * 2, ... #}
#define SERIAL_{{ cfg.typ }}_MAX (SERIAL_{{cfg.typ}}_MASK ? LOG2(SERIAL_{{cfg.typ}}_MASK) + 1 : 0)
{#   for softserial, we don't want softserial2 only #}
{%   if cfg.force_continuous %}

#if SERIAL_{{cfg.typ}}_COUNT != SERIAL_{{cfg.typ}}_MAX
# error {{cfg.typ}} ports must start with {{cfg.typ}}1 and be continuous
#endif
{%   endif %}
{#   backward compatibility, code did set USE_INVERTER this way. It must be done before normalizing to NONE #}
{%   if cfg.inverter %}
// enable USE_INVERTED first, before normalization
{%     set pipe2 = joiner(' || ') %}
#if !defined(USE_INVERTER) && ({% for port in cfg.ports %}{{ pipe2() }}INVERTER_PIN_{{ port }}{% endfor %})
# define USE_INVERTER
#endif
{%   endif %}
{#   no pins for VCP port #}
{%   if not cfg.no_pins %}

// Normalize {{cfg.typ}} TX/RX{{ "/INVERTER" if cfg.inverter else "" }}
{%     for port in cfg.ports %}
{%       set pins = [  port ~ '_RX_PIN', port ~ '_TX_PIN' ] + (['INVERTER_PIN_' ~ port]  if cfg.inverter else []) %}
{%       for pin in pins %}
#if SERIAL_{{port}}_USED && !defined({{pin}})
# define {{ pin }} NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_{{ port }}_USED && defined({{ pin }})
# warning "{{ pin }} is defined but {{ port }} is not enabled"
#endif
#if !SERIAL_{{ port }}_USED &&  defined({{ pin }})
# undef {{ pin }}
#endif
{%       endfor %}
{%     endfor %}
{%   endif %}
{% endfor %}

// normalize USE_x after all ports are enumerated (x_COUNT of dependencies must be available)
{% for cfg in config %}
{%   set depends = [cfg.typ] + config|rdepends(cfg.typ) %}
{%   set pipe2 = joiner(' || ') %}
#if !defined(USE_{{cfg.typ}}) && ({% for typ in depends %}{{ pipe2() }}SERIAL_{{ typ }}_COUNT{% endfor %})
# define USE_{{cfg.typ}}
#endif
{% endfor %}
