/*
 * This file is part of Betaflight.
 *
 * Betaflight is free software. You can redistribute this software
 * and/or modify this software under the terms of the GNU General
 * Public License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later
 * version.
 *
 * Betaflight is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this software.
 *
 * If not, see <http://www.gnu.org/licenses/>.
 */

/*
This file is automatically generated by src/utils/gen-serial.py script from src/utils/templates/serial_post.h jinja2 template.
Do not modify this file directly, your changes will be eventually lost.
See template file for aditional documentation.

To generate this file again, run
> python ./src/utils/gen-serial-j2.py > ./src/main/target/serial_post.h
in Betaflight topmost directory.

This include will provide following defines:
SERIAL_<type><n>_USED 0/1 - always defined, value depends on target configuration
SERIAL_<type>_MASK        - bitmask of used ports or given type. <port>0 or <port>1 is BIT(0), based on port first_index
SERIAL_<type>_COUNT       - number of enabled ports of given type
SERIAL_<type>_MAX         - <index of highest used port> + 1, 0 when no port is enabled

All <type><n>_(RX|TX)_PINS are normalized too:
 - if port is enabled, both will be defined (possibly as NONE)
 - if port is not enable, both will be undefined, possibly with warning
  - pass -DWARN_UNUSED_SERIAL_PORT to compiler to check pin defined without corresponding port being enabled.

Generated on 2024-12-20

Configuration used:
{   'LPUART': {'depends': {'UART'}, 'ids': [1]},
    'SOFTSERIAL': {   'force_continuous': True,
                      'ids': [1, 2],
                      'use_enables_all': True},
    'UART': {   'first_index': True,
                'ids': [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
                'inverter': True},
    'VCP': {'no_pins': True, 'singleton': True}}
*/

#include "common/utils.h" // BIT, LOG2

/****                                UART                                 *****/

// normalize SERIAL_UART_FIRST_INDEX
#ifndef SERIAL_UART_FIRST_INDEX
#define SERIAL_UART_FIRST_INDEX 1
#endif

#if SERIAL_UART_FIRST_INDEX == 0
#if defined(USE_UART0)
# define SERIAL_UART0_USED 1
#else
# define SERIAL_UART0_USED 0
#endif
#else // USE_UART0 is not allowed
# if defined(USE_UART0)
#  error "USE_UART0 is defined, but SERIAL_UART does not allow index 0"
# else
#  define SERIAL_UART0_USED 0
# endif
#endif
#if defined(USE_UART1)
# define SERIAL_UART1_USED 1
#else
# define SERIAL_UART1_USED 0
#endif
#if defined(USE_UART2)
# define SERIAL_UART2_USED 1
#else
# define SERIAL_UART2_USED 0
#endif
#if defined(USE_UART3)
# define SERIAL_UART3_USED 1
#else
# define SERIAL_UART3_USED 0
#endif
#if defined(USE_UART4)
# define SERIAL_UART4_USED 1
#else
# define SERIAL_UART4_USED 0
#endif
#if defined(USE_UART5)
# define SERIAL_UART5_USED 1
#else
# define SERIAL_UART5_USED 0
#endif
#if defined(USE_UART6)
# define SERIAL_UART6_USED 1
#else
# define SERIAL_UART6_USED 0
#endif
#if defined(USE_UART7)
# define SERIAL_UART7_USED 1
#else
# define SERIAL_UART7_USED 0
#endif
#if defined(USE_UART8)
# define SERIAL_UART8_USED 1
#else
# define SERIAL_UART8_USED 0
#endif
#if defined(USE_UART9)
# define SERIAL_UART9_USED 1
#else
# define SERIAL_UART9_USED 0
#endif
#if defined(USE_UART10)
# define SERIAL_UART10_USED 1
#else
# define SERIAL_UART10_USED 0
#endif

#define SERIAL_UART_MASK ((SERIAL_UART0_USED * BIT(0)) | (SERIAL_UART1_USED * BIT(1 - SERIAL_UART_FIRST_INDEX)) | (SERIAL_UART2_USED * BIT(2 - SERIAL_UART_FIRST_INDEX)) | (SERIAL_UART3_USED * BIT(3 - SERIAL_UART_FIRST_INDEX)) | (SERIAL_UART4_USED * BIT(4 - SERIAL_UART_FIRST_INDEX)) | (SERIAL_UART5_USED * BIT(5 - SERIAL_UART_FIRST_INDEX)) | (SERIAL_UART6_USED * BIT(6 - SERIAL_UART_FIRST_INDEX)) | (SERIAL_UART7_USED * BIT(7 - SERIAL_UART_FIRST_INDEX)) | (SERIAL_UART8_USED * BIT(8 - SERIAL_UART_FIRST_INDEX)) | (SERIAL_UART9_USED * BIT(9 - SERIAL_UART_FIRST_INDEX)) | (SERIAL_UART10_USED * BIT(10 - SERIAL_UART_FIRST_INDEX)))
#define SERIAL_UART_COUNT (SERIAL_UART0_USED + SERIAL_UART1_USED + SERIAL_UART2_USED + SERIAL_UART3_USED + SERIAL_UART4_USED + SERIAL_UART5_USED + SERIAL_UART6_USED + SERIAL_UART7_USED + SERIAL_UART8_USED + SERIAL_UART9_USED + SERIAL_UART10_USED)
// 0 if no port is defined
#define SERIAL_UART_MAX (SERIAL_UART_MASK ? LOG2(SERIAL_UART_MASK) + 1 : 0)
// enable USE_INVERTED first, before normalization
#if !defined(USE_INVERTER) && (INVERTER_PIN_UART0 || INVERTER_PIN_UART1 || INVERTER_PIN_UART2 || INVERTER_PIN_UART3 || INVERTER_PIN_UART4 || INVERTER_PIN_UART5 || INVERTER_PIN_UART6 || INVERTER_PIN_UART7 || INVERTER_PIN_UART8 || INVERTER_PIN_UART9 || INVERTER_PIN_UART10)
# define USE_INVERTER
#endif

// Normalize UART TX/RX/INVERTER
#if SERIAL_UART0_USED && !defined(UART0_RX_PIN)
# define UART0_RX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART0_USED && defined(UART0_RX_PIN)
# warning "UART0_RX_PIN is defined but UART0 is not enabled"
#endif
#if !SERIAL_UART0_USED &&  defined(UART0_RX_PIN)
# undef UART0_RX_PIN
#endif
#if SERIAL_UART0_USED && !defined(UART0_TX_PIN)
# define UART0_TX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART0_USED && defined(UART0_TX_PIN)
# warning "UART0_TX_PIN is defined but UART0 is not enabled"
#endif
#if !SERIAL_UART0_USED &&  defined(UART0_TX_PIN)
# undef UART0_TX_PIN
#endif
#if SERIAL_UART0_USED && !defined(INVERTER_PIN_UART0)
# define INVERTER_PIN_UART0 NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART0_USED && defined(INVERTER_PIN_UART0)
# warning "INVERTER_PIN_UART0 is defined but UART0 is not enabled"
#endif
#if !SERIAL_UART0_USED &&  defined(INVERTER_PIN_UART0)
# undef INVERTER_PIN_UART0
#endif
#if SERIAL_UART1_USED && !defined(UART1_RX_PIN)
# define UART1_RX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART1_USED && defined(UART1_RX_PIN)
# warning "UART1_RX_PIN is defined but UART1 is not enabled"
#endif
#if !SERIAL_UART1_USED &&  defined(UART1_RX_PIN)
# undef UART1_RX_PIN
#endif
#if SERIAL_UART1_USED && !defined(UART1_TX_PIN)
# define UART1_TX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART1_USED && defined(UART1_TX_PIN)
# warning "UART1_TX_PIN is defined but UART1 is not enabled"
#endif
#if !SERIAL_UART1_USED &&  defined(UART1_TX_PIN)
# undef UART1_TX_PIN
#endif
#if SERIAL_UART1_USED && !defined(INVERTER_PIN_UART1)
# define INVERTER_PIN_UART1 NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART1_USED && defined(INVERTER_PIN_UART1)
# warning "INVERTER_PIN_UART1 is defined but UART1 is not enabled"
#endif
#if !SERIAL_UART1_USED &&  defined(INVERTER_PIN_UART1)
# undef INVERTER_PIN_UART1
#endif
#if SERIAL_UART2_USED && !defined(UART2_RX_PIN)
# define UART2_RX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART2_USED && defined(UART2_RX_PIN)
# warning "UART2_RX_PIN is defined but UART2 is not enabled"
#endif
#if !SERIAL_UART2_USED &&  defined(UART2_RX_PIN)
# undef UART2_RX_PIN
#endif
#if SERIAL_UART2_USED && !defined(UART2_TX_PIN)
# define UART2_TX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART2_USED && defined(UART2_TX_PIN)
# warning "UART2_TX_PIN is defined but UART2 is not enabled"
#endif
#if !SERIAL_UART2_USED &&  defined(UART2_TX_PIN)
# undef UART2_TX_PIN
#endif
#if SERIAL_UART2_USED && !defined(INVERTER_PIN_UART2)
# define INVERTER_PIN_UART2 NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART2_USED && defined(INVERTER_PIN_UART2)
# warning "INVERTER_PIN_UART2 is defined but UART2 is not enabled"
#endif
#if !SERIAL_UART2_USED &&  defined(INVERTER_PIN_UART2)
# undef INVERTER_PIN_UART2
#endif
#if SERIAL_UART3_USED && !defined(UART3_RX_PIN)
# define UART3_RX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART3_USED && defined(UART3_RX_PIN)
# warning "UART3_RX_PIN is defined but UART3 is not enabled"
#endif
#if !SERIAL_UART3_USED &&  defined(UART3_RX_PIN)
# undef UART3_RX_PIN
#endif
#if SERIAL_UART3_USED && !defined(UART3_TX_PIN)
# define UART3_TX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART3_USED && defined(UART3_TX_PIN)
# warning "UART3_TX_PIN is defined but UART3 is not enabled"
#endif
#if !SERIAL_UART3_USED &&  defined(UART3_TX_PIN)
# undef UART3_TX_PIN
#endif
#if SERIAL_UART3_USED && !defined(INVERTER_PIN_UART3)
# define INVERTER_PIN_UART3 NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART3_USED && defined(INVERTER_PIN_UART3)
# warning "INVERTER_PIN_UART3 is defined but UART3 is not enabled"
#endif
#if !SERIAL_UART3_USED &&  defined(INVERTER_PIN_UART3)
# undef INVERTER_PIN_UART3
#endif
#if SERIAL_UART4_USED && !defined(UART4_RX_PIN)
# define UART4_RX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART4_USED && defined(UART4_RX_PIN)
# warning "UART4_RX_PIN is defined but UART4 is not enabled"
#endif
#if !SERIAL_UART4_USED &&  defined(UART4_RX_PIN)
# undef UART4_RX_PIN
#endif
#if SERIAL_UART4_USED && !defined(UART4_TX_PIN)
# define UART4_TX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART4_USED && defined(UART4_TX_PIN)
# warning "UART4_TX_PIN is defined but UART4 is not enabled"
#endif
#if !SERIAL_UART4_USED &&  defined(UART4_TX_PIN)
# undef UART4_TX_PIN
#endif
#if SERIAL_UART4_USED && !defined(INVERTER_PIN_UART4)
# define INVERTER_PIN_UART4 NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART4_USED && defined(INVERTER_PIN_UART4)
# warning "INVERTER_PIN_UART4 is defined but UART4 is not enabled"
#endif
#if !SERIAL_UART4_USED &&  defined(INVERTER_PIN_UART4)
# undef INVERTER_PIN_UART4
#endif
#if SERIAL_UART5_USED && !defined(UART5_RX_PIN)
# define UART5_RX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART5_USED && defined(UART5_RX_PIN)
# warning "UART5_RX_PIN is defined but UART5 is not enabled"
#endif
#if !SERIAL_UART5_USED &&  defined(UART5_RX_PIN)
# undef UART5_RX_PIN
#endif
#if SERIAL_UART5_USED && !defined(UART5_TX_PIN)
# define UART5_TX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART5_USED && defined(UART5_TX_PIN)
# warning "UART5_TX_PIN is defined but UART5 is not enabled"
#endif
#if !SERIAL_UART5_USED &&  defined(UART5_TX_PIN)
# undef UART5_TX_PIN
#endif
#if SERIAL_UART5_USED && !defined(INVERTER_PIN_UART5)
# define INVERTER_PIN_UART5 NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART5_USED && defined(INVERTER_PIN_UART5)
# warning "INVERTER_PIN_UART5 is defined but UART5 is not enabled"
#endif
#if !SERIAL_UART5_USED &&  defined(INVERTER_PIN_UART5)
# undef INVERTER_PIN_UART5
#endif
#if SERIAL_UART6_USED && !defined(UART6_RX_PIN)
# define UART6_RX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART6_USED && defined(UART6_RX_PIN)
# warning "UART6_RX_PIN is defined but UART6 is not enabled"
#endif
#if !SERIAL_UART6_USED &&  defined(UART6_RX_PIN)
# undef UART6_RX_PIN
#endif
#if SERIAL_UART6_USED && !defined(UART6_TX_PIN)
# define UART6_TX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART6_USED && defined(UART6_TX_PIN)
# warning "UART6_TX_PIN is defined but UART6 is not enabled"
#endif
#if !SERIAL_UART6_USED &&  defined(UART6_TX_PIN)
# undef UART6_TX_PIN
#endif
#if SERIAL_UART6_USED && !defined(INVERTER_PIN_UART6)
# define INVERTER_PIN_UART6 NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART6_USED && defined(INVERTER_PIN_UART6)
# warning "INVERTER_PIN_UART6 is defined but UART6 is not enabled"
#endif
#if !SERIAL_UART6_USED &&  defined(INVERTER_PIN_UART6)
# undef INVERTER_PIN_UART6
#endif
#if SERIAL_UART7_USED && !defined(UART7_RX_PIN)
# define UART7_RX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART7_USED && defined(UART7_RX_PIN)
# warning "UART7_RX_PIN is defined but UART7 is not enabled"
#endif
#if !SERIAL_UART7_USED &&  defined(UART7_RX_PIN)
# undef UART7_RX_PIN
#endif
#if SERIAL_UART7_USED && !defined(UART7_TX_PIN)
# define UART7_TX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART7_USED && defined(UART7_TX_PIN)
# warning "UART7_TX_PIN is defined but UART7 is not enabled"
#endif
#if !SERIAL_UART7_USED &&  defined(UART7_TX_PIN)
# undef UART7_TX_PIN
#endif
#if SERIAL_UART7_USED && !defined(INVERTER_PIN_UART7)
# define INVERTER_PIN_UART7 NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART7_USED && defined(INVERTER_PIN_UART7)
# warning "INVERTER_PIN_UART7 is defined but UART7 is not enabled"
#endif
#if !SERIAL_UART7_USED &&  defined(INVERTER_PIN_UART7)
# undef INVERTER_PIN_UART7
#endif
#if SERIAL_UART8_USED && !defined(UART8_RX_PIN)
# define UART8_RX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART8_USED && defined(UART8_RX_PIN)
# warning "UART8_RX_PIN is defined but UART8 is not enabled"
#endif
#if !SERIAL_UART8_USED &&  defined(UART8_RX_PIN)
# undef UART8_RX_PIN
#endif
#if SERIAL_UART8_USED && !defined(UART8_TX_PIN)
# define UART8_TX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART8_USED && defined(UART8_TX_PIN)
# warning "UART8_TX_PIN is defined but UART8 is not enabled"
#endif
#if !SERIAL_UART8_USED &&  defined(UART8_TX_PIN)
# undef UART8_TX_PIN
#endif
#if SERIAL_UART8_USED && !defined(INVERTER_PIN_UART8)
# define INVERTER_PIN_UART8 NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART8_USED && defined(INVERTER_PIN_UART8)
# warning "INVERTER_PIN_UART8 is defined but UART8 is not enabled"
#endif
#if !SERIAL_UART8_USED &&  defined(INVERTER_PIN_UART8)
# undef INVERTER_PIN_UART8
#endif
#if SERIAL_UART9_USED && !defined(UART9_RX_PIN)
# define UART9_RX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART9_USED && defined(UART9_RX_PIN)
# warning "UART9_RX_PIN is defined but UART9 is not enabled"
#endif
#if !SERIAL_UART9_USED &&  defined(UART9_RX_PIN)
# undef UART9_RX_PIN
#endif
#if SERIAL_UART9_USED && !defined(UART9_TX_PIN)
# define UART9_TX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART9_USED && defined(UART9_TX_PIN)
# warning "UART9_TX_PIN is defined but UART9 is not enabled"
#endif
#if !SERIAL_UART9_USED &&  defined(UART9_TX_PIN)
# undef UART9_TX_PIN
#endif
#if SERIAL_UART9_USED && !defined(INVERTER_PIN_UART9)
# define INVERTER_PIN_UART9 NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART9_USED && defined(INVERTER_PIN_UART9)
# warning "INVERTER_PIN_UART9 is defined but UART9 is not enabled"
#endif
#if !SERIAL_UART9_USED &&  defined(INVERTER_PIN_UART9)
# undef INVERTER_PIN_UART9
#endif
#if SERIAL_UART10_USED && !defined(UART10_RX_PIN)
# define UART10_RX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART10_USED && defined(UART10_RX_PIN)
# warning "UART10_RX_PIN is defined but UART10 is not enabled"
#endif
#if !SERIAL_UART10_USED &&  defined(UART10_RX_PIN)
# undef UART10_RX_PIN
#endif
#if SERIAL_UART10_USED && !defined(UART10_TX_PIN)
# define UART10_TX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART10_USED && defined(UART10_TX_PIN)
# warning "UART10_TX_PIN is defined but UART10 is not enabled"
#endif
#if !SERIAL_UART10_USED &&  defined(UART10_TX_PIN)
# undef UART10_TX_PIN
#endif
#if SERIAL_UART10_USED && !defined(INVERTER_PIN_UART10)
# define INVERTER_PIN_UART10 NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_UART10_USED && defined(INVERTER_PIN_UART10)
# warning "INVERTER_PIN_UART10 is defined but UART10 is not enabled"
#endif
#if !SERIAL_UART10_USED &&  defined(INVERTER_PIN_UART10)
# undef INVERTER_PIN_UART10
#endif

/****                                LPUART                                 *****/

#if defined(USE_LPUART1)
# define SERIAL_LPUART1_USED 1
#else
# define SERIAL_LPUART1_USED 0
#endif

#define SERIAL_LPUART_MASK ((SERIAL_LPUART1_USED * BIT(1 - 1)))
#define SERIAL_LPUART_COUNT (SERIAL_LPUART1_USED)
// 0 if no port is defined
#define SERIAL_LPUART_MAX (SERIAL_LPUART_MASK ? LOG2(SERIAL_LPUART_MASK) + 1 : 0)

// Normalize LPUART TX/RX
#if SERIAL_LPUART1_USED && !defined(LPUART1_RX_PIN)
# define LPUART1_RX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_LPUART1_USED && defined(LPUART1_RX_PIN)
# warning "LPUART1_RX_PIN is defined but LPUART1 is not enabled"
#endif
#if !SERIAL_LPUART1_USED &&  defined(LPUART1_RX_PIN)
# undef LPUART1_RX_PIN
#endif
#if SERIAL_LPUART1_USED && !defined(LPUART1_TX_PIN)
# define LPUART1_TX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_LPUART1_USED && defined(LPUART1_TX_PIN)
# warning "LPUART1_TX_PIN is defined but LPUART1 is not enabled"
#endif
#if !SERIAL_LPUART1_USED &&  defined(LPUART1_TX_PIN)
# undef LPUART1_TX_PIN
#endif

/****                                SOFTSERIAL                                 *****/

#if defined(USE_SOFTSERIAL)
// USE_SOFTSERIAL enables all SOFTSERIAL ports
# if !defined(USE_SOFTSERIAL1)
#  define USE_SOFTSERIAL1
# endif
# if !defined(USE_SOFTSERIAL2)
#  define USE_SOFTSERIAL2
# endif
#endif

#if defined(USE_SOFTSERIAL1)
# define SERIAL_SOFTSERIAL1_USED 1
#else
# define SERIAL_SOFTSERIAL1_USED 0
#endif
#if defined(USE_SOFTSERIAL2)
# define SERIAL_SOFTSERIAL2_USED 1
#else
# define SERIAL_SOFTSERIAL2_USED 0
#endif

#define SERIAL_SOFTSERIAL_MASK ((SERIAL_SOFTSERIAL1_USED * BIT(1 - 1)) | (SERIAL_SOFTSERIAL2_USED * BIT(2 - 1)))
#define SERIAL_SOFTSERIAL_COUNT (SERIAL_SOFTSERIAL1_USED + SERIAL_SOFTSERIAL2_USED)
// 0 if no port is defined
#define SERIAL_SOFTSERIAL_MAX (SERIAL_SOFTSERIAL_MASK ? LOG2(SERIAL_SOFTSERIAL_MASK) + 1 : 0)

#if SERIAL_SOFTSERIAL_COUNT != SERIAL_SOFTSERIAL_MAX
# error SOFTSERIAL ports must start with SOFTSERIAL1 and be continuous
#endif

// Normalize SOFTSERIAL TX/RX
#if SERIAL_SOFTSERIAL1_USED && !defined(SOFTSERIAL1_RX_PIN)
# define SOFTSERIAL1_RX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_SOFTSERIAL1_USED && defined(SOFTSERIAL1_RX_PIN)
# warning "SOFTSERIAL1_RX_PIN is defined but SOFTSERIAL1 is not enabled"
#endif
#if !SERIAL_SOFTSERIAL1_USED &&  defined(SOFTSERIAL1_RX_PIN)
# undef SOFTSERIAL1_RX_PIN
#endif
#if SERIAL_SOFTSERIAL1_USED && !defined(SOFTSERIAL1_TX_PIN)
# define SOFTSERIAL1_TX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_SOFTSERIAL1_USED && defined(SOFTSERIAL1_TX_PIN)
# warning "SOFTSERIAL1_TX_PIN is defined but SOFTSERIAL1 is not enabled"
#endif
#if !SERIAL_SOFTSERIAL1_USED &&  defined(SOFTSERIAL1_TX_PIN)
# undef SOFTSERIAL1_TX_PIN
#endif
#if SERIAL_SOFTSERIAL2_USED && !defined(SOFTSERIAL2_RX_PIN)
# define SOFTSERIAL2_RX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_SOFTSERIAL2_USED && defined(SOFTSERIAL2_RX_PIN)
# warning "SOFTSERIAL2_RX_PIN is defined but SOFTSERIAL2 is not enabled"
#endif
#if !SERIAL_SOFTSERIAL2_USED &&  defined(SOFTSERIAL2_RX_PIN)
# undef SOFTSERIAL2_RX_PIN
#endif
#if SERIAL_SOFTSERIAL2_USED && !defined(SOFTSERIAL2_TX_PIN)
# define SOFTSERIAL2_TX_PIN NONE
#endif
#if defined(WARN_UNUSED_SERIAL_PORT) && !SERIAL_SOFTSERIAL2_USED && defined(SOFTSERIAL2_TX_PIN)
# warning "SOFTSERIAL2_TX_PIN is defined but SOFTSERIAL2 is not enabled"
#endif
#if !SERIAL_SOFTSERIAL2_USED &&  defined(SOFTSERIAL2_TX_PIN)
# undef SOFTSERIAL2_TX_PIN
#endif

/****                                VCP                                 *****/

#if defined(USE_VCP)
# define SERIAL_VCP_USED 1
#else
# define SERIAL_VCP_USED 0
#endif

// for consistency, set one bit if port is enabled
#define SERIAL_VCP_MASK (SERIAL_VCP_USED * BIT(0))
#define SERIAL_VCP_COUNT (SERIAL_VCP_USED)
// 0 if no port is defined
#define SERIAL_VCP_MAX (SERIAL_VCP_MASK ? LOG2(SERIAL_VCP_MASK) + 1 : 0)

// normalize USE_x after all ports are enumerated (x_COUNT of dependencies must be available)
#if !defined(USE_UART) && (SERIAL_UART_COUNT || SERIAL_LPUART_COUNT)
# define USE_UART
#endif
#if !defined(USE_LPUART) && (SERIAL_LPUART_COUNT)
# define USE_LPUART
#endif
#if !defined(USE_SOFTSERIAL) && (SERIAL_SOFTSERIAL_COUNT)
# define USE_SOFTSERIAL
#endif
#if !defined(USE_VCP) && (SERIAL_VCP_COUNT)
# define USE_VCP
#endif

