/* ----------------------------------------------------------------------
 * Project:      CMSIS DSP Library
 * Title:        arm_mve_tables.c
 * Description:  common tables like fft twiddle factors, Bitreverse, reciprocal etc
 *               used for MVE implementation only
 *
 * $Date:        08. January 2020
 * $Revision:    V1.7.0
 *
 * Target Processor: Cortex-M cores
 * -------------------------------------------------------------------- */
/*
 * Copyright (C) 2010-2020 ARM Limited or its affiliates. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


#include "arm_math.h"

#if defined(ARM_MATH_MVEF) && !defined(ARM_MATH_AUTOVECTORIZE)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F32_16) || defined(ARM_TABLE_TWIDDLECOEF_F32_32)

uint32_t rearranged_twiddle_tab_stride1_arr_16_f32[2]={
0,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_16_f32[2]={
0,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_16_f32[2]={
0,0,};

float32_t rearranged_twiddle_stride1_16_f32[8]={
1.00000000000000000000f,0.00000000000000000000f,0.92387953251128673848f,
0.38268343236508978178f,0.70710678118654757274f,0.70710678118654757274f,
0.38268343236508983729f,0.92387953251128673848f,};

float32_t rearranged_twiddle_stride2_16_f32[8]={
1.00000000000000000000f,0.00000000000000000000f,0.70710678118654757274f,
0.70710678118654757274f,0.00000000000000006123f,1.00000000000000000000f,
-0.70710678118654746172f,0.70710678118654757274f,};

float32_t rearranged_twiddle_stride3_16_f32[8]={
1.00000000000000000000f,0.00000000000000000000f,0.38268343236508983729f,
0.92387953251128673848f,-0.70710678118654746172f,0.70710678118654757274f,
-0.92387953251128684951f,-0.38268343236508967076f,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F32_64) || defined(ARM_TABLE_TWIDDLECOEF_F32_128)

uint32_t rearranged_twiddle_tab_stride1_arr_64_f32[3]={
0,32,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_64_f32[3]={
0,32,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_64_f32[3]={
0,32,0,};

float32_t rearranged_twiddle_stride1_64_f32[40]={
1.00000000000000000000f,0.00000000000000000000f,0.99518472667219692873f,
0.09801714032956060363f,0.98078528040323043058f,0.19509032201612824808f,
0.95694033573220882438f,0.29028467725446233105f,0.92387953251128673848f,
0.38268343236508978178f,0.88192126434835504956f,0.47139673682599764204f,
0.83146961230254523567f,0.55557023301960217765f,0.77301045336273699338f,
0.63439328416364548779f,0.70710678118654757274f,0.70710678118654757274f,
0.63439328416364548779f,0.77301045336273688235f,0.55557023301960228867f,
0.83146961230254523567f,0.47139673682599780857f,0.88192126434835493853f,
0.38268343236508983729f,0.92387953251128673848f,0.29028467725446233105f,
0.95694033573220893540f,0.19509032201612833135f,0.98078528040323043058f,
0.09801714032956077016f,0.99518472667219681771f,1.00000000000000000000f,
0.00000000000000000000f,0.92387953251128673848f,0.38268343236508978178f,
0.70710678118654757274f,0.70710678118654757274f,0.38268343236508983729f,
0.92387953251128673848f,};

float32_t rearranged_twiddle_stride2_64_f32[40]={
1.00000000000000000000f,0.00000000000000000000f,0.98078528040323043058f,
0.19509032201612824808f,0.92387953251128673848f,0.38268343236508978178f,
0.83146961230254523567f,0.55557023301960217765f,0.70710678118654757274f,
0.70710678118654757274f,0.55557023301960228867f,0.83146961230254523567f,
0.38268343236508983729f,0.92387953251128673848f,0.19509032201612833135f,
0.98078528040323043058f,0.00000000000000006123f,1.00000000000000000000f,
-0.19509032201612819257f,0.98078528040323043058f,-0.38268343236508972627f,
0.92387953251128673848f,-0.55557023301960195560f,0.83146961230254534669f,
-0.70710678118654746172f,0.70710678118654757274f,-0.83146961230254534669f,
0.55557023301960217765f,-0.92387953251128673848f,0.38268343236508989280f,
-0.98078528040323043058f,0.19509032201612860891f,1.00000000000000000000f,
0.00000000000000000000f,0.70710678118654757274f,0.70710678118654757274f,
0.00000000000000006123f,1.00000000000000000000f,-0.70710678118654746172f,
0.70710678118654757274f,};

float32_t rearranged_twiddle_stride3_64_f32[40]={
1.00000000000000000000f,0.00000000000000000000f,0.95694033573220882438f,
0.29028467725446233105f,0.83146961230254523567f,0.55557023301960217765f,
0.63439328416364548779f,0.77301045336273688235f,0.38268343236508983729f,
0.92387953251128673848f,0.09801714032956077016f,0.99518472667219681771f,
-0.19509032201612819257f,0.98078528040323043058f,-0.47139673682599769755f,
0.88192126434835504956f,-0.70710678118654746172f,0.70710678118654757274f,
-0.88192126434835493853f,0.47139673682599780857f,-0.98078528040323043058f,
0.19509032201612860891f,-0.99518472667219692873f,-0.09801714032956058975f,
-0.92387953251128684951f,-0.38268343236508967076f,-0.77301045336273710440f,
-0.63439328416364526575f,-0.55557023301960217765f,-0.83146961230254523567f,
-0.29028467725446244208f,-0.95694033573220882438f,1.00000000000000000000f,
0.00000000000000000000f,0.38268343236508983729f,0.92387953251128673848f,
-0.70710678118654746172f,0.70710678118654757274f,-0.92387953251128684951f,
-0.38268343236508967076f,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F32_256) || defined(ARM_TABLE_TWIDDLECOEF_F32_512)

uint32_t rearranged_twiddle_tab_stride1_arr_256_f32[4]={
0,128,160,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_256_f32[4]={
0,128,160,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_256_f32[4]={
0,128,160,0,};

float32_t rearranged_twiddle_stride1_256_f32[168]={
1.00000000000000000000f,0.00000000000000000000f,0.99969881869620424997f,
0.02454122852291228812f,0.99879545620517240501f,0.04906767432741801493f,
0.99729045667869020697f,0.07356456359966742631f,0.99518472667219692873f,
0.09801714032956060363f,0.99247953459870996706f,0.12241067519921619566f,
0.98917650996478101444f,0.14673047445536174793f,0.98527764238894122162f,
0.17096188876030121717f,0.98078528040323043058f,0.19509032201612824808f,
0.97570213003852857003f,0.21910124015686979759f,0.97003125319454397424f,
0.24298017990326387094f,0.96377606579543984022f,0.26671275747489836538f,
0.95694033573220882438f,0.29028467725446233105f,0.94952818059303667475f,
0.31368174039889151761f,0.94154406518302080631f,0.33688985339222005111f,
0.93299279883473895669f,0.35989503653498811087f,0.92387953251128673848f,
0.38268343236508978178f,0.91420975570353069095f,0.40524131400498986100f,
0.90398929312344333820f,0.42755509343028208491f,0.89322430119551532446f,
0.44961132965460653965f,0.88192126434835504956f,0.47139673682599764204f,
0.87008699110871146054f,0.49289819222978403790f,0.85772861000027211809f,
0.51410274419322166128f,0.84485356524970711689f,0.53499761988709715332f,
0.83146961230254523567f,0.55557023301960217765f,0.81758481315158371139f,
0.57580819141784533866f,0.80320753148064494287f,0.59569930449243335691f,
0.78834642762660622761f,0.61523159058062681925f,0.77301045336273699338f,
0.63439328416364548779f,0.75720884650648456748f,0.65317284295377675551f,
0.74095112535495921691f,0.67155895484701833009f,0.72424708295146700276f,
0.68954054473706682948f,0.70710678118654757274f,0.70710678118654757274f,
0.68954054473706694051f,0.72424708295146689174f,0.67155895484701833009f,
0.74095112535495910588f,0.65317284295377686654f,0.75720884650648456748f,
0.63439328416364548779f,0.77301045336273688235f,0.61523159058062681925f,
0.78834642762660622761f,0.59569930449243346793f,0.80320753148064483184f,
0.57580819141784533866f,0.81758481315158371139f,0.55557023301960228867f,
0.83146961230254523567f,0.53499761988709726435f,0.84485356524970700587f,
0.51410274419322166128f,0.85772861000027211809f,0.49289819222978409341f,
0.87008699110871134952f,0.47139673682599780857f,0.88192126434835493853f,
0.44961132965460659516f,0.89322430119551532446f,0.42755509343028219593f,
0.90398929312344333820f,0.40524131400498986100f,0.91420975570353069095f,
0.38268343236508983729f,0.92387953251128673848f,0.35989503653498827740f,
0.93299279883473884567f,0.33688985339222005111f,0.94154406518302080631f,
0.31368174039889157312f,0.94952818059303667475f,0.29028467725446233105f,
0.95694033573220893540f,0.26671275747489842090f,0.96377606579543984022f,
0.24298017990326398197f,0.97003125319454397424f,0.21910124015686976984f,
0.97570213003852857003f,0.19509032201612833135f,0.98078528040323043058f,
0.17096188876030135595f,0.98527764238894122162f,0.14673047445536174793f,
0.98917650996478101444f,0.12241067519921627893f,0.99247953459870996706f,
0.09801714032956077016f,0.99518472667219681771f,0.07356456359966745406f,
0.99729045667869020697f,0.04906767432741812596f,0.99879545620517240501f,
0.02454122852291226384f,0.99969881869620424997f,1.00000000000000000000f,
0.00000000000000000000f,0.99518472667219692873f,0.09801714032956060363f,
0.98078528040323043058f,0.19509032201612824808f,0.95694033573220882438f,
0.29028467725446233105f,0.92387953251128673848f,0.38268343236508978178f,
0.88192126434835504956f,0.47139673682599764204f,0.83146961230254523567f,
0.55557023301960217765f,0.77301045336273699338f,0.63439328416364548779f,
0.70710678118654757274f,0.70710678118654757274f,0.63439328416364548779f,
0.77301045336273688235f,0.55557023301960228867f,0.83146961230254523567f,
0.47139673682599780857f,0.88192126434835493853f,0.38268343236508983729f,
0.92387953251128673848f,0.29028467725446233105f,0.95694033573220893540f,
0.19509032201612833135f,0.98078528040323043058f,0.09801714032956077016f,
0.99518472667219681771f,1.00000000000000000000f,0.00000000000000000000f,
0.92387953251128673848f,0.38268343236508978178f,0.70710678118654757274f,
0.70710678118654757274f,0.38268343236508983729f,0.92387953251128673848f,};

float32_t rearranged_twiddle_stride2_256_f32[168]={
1.00000000000000000000f,0.00000000000000000000f,0.99879545620517240501f,
0.04906767432741801493f,0.99518472667219692873f,0.09801714032956060363f,
0.98917650996478101444f,0.14673047445536174793f,0.98078528040323043058f,
0.19509032201612824808f,0.97003125319454397424f,0.24298017990326387094f,
0.95694033573220882438f,0.29028467725446233105f,0.94154406518302080631f,
0.33688985339222005111f,0.92387953251128673848f,0.38268343236508978178f,
0.90398929312344333820f,0.42755509343028208491f,0.88192126434835504956f,
0.47139673682599764204f,0.85772861000027211809f,0.51410274419322166128f,
0.83146961230254523567f,0.55557023301960217765f,0.80320753148064494287f,
0.59569930449243335691f,0.77301045336273699338f,0.63439328416364548779f,
0.74095112535495921691f,0.67155895484701833009f,0.70710678118654757274f,
0.70710678118654757274f,0.67155895484701833009f,0.74095112535495910588f,
0.63439328416364548779f,0.77301045336273688235f,0.59569930449243346793f,
0.80320753148064483184f,0.55557023301960228867f,0.83146961230254523567f,
0.51410274419322166128f,0.85772861000027211809f,0.47139673682599780857f,
0.88192126434835493853f,0.42755509343028219593f,0.90398929312344333820f,
0.38268343236508983729f,0.92387953251128673848f,0.33688985339222005111f,
0.94154406518302080631f,0.29028467725446233105f,0.95694033573220893540f,
0.24298017990326398197f,0.97003125319454397424f,0.19509032201612833135f,
0.98078528040323043058f,0.14673047445536174793f,0.98917650996478101444f,
0.09801714032956077016f,0.99518472667219681771f,0.04906767432741812596f,
0.99879545620517240501f,0.00000000000000006123f,1.00000000000000000000f,
-0.04906767432741800800f,0.99879545620517240501f,-0.09801714032956064526f,
0.99518472667219692873f,-0.14673047445536163691f,0.98917650996478101444f,
-0.19509032201612819257f,0.98078528040323043058f,-0.24298017990326387094f,
0.97003125319454397424f,-0.29028467725446216452f,0.95694033573220893540f,
-0.33688985339221994009f,0.94154406518302080631f,-0.38268343236508972627f,
0.92387953251128673848f,-0.42755509343028186287f,0.90398929312344344922f,
-0.47139673682599769755f,0.88192126434835504956f,-0.51410274419322155026f,
0.85772861000027211809f,-0.55557023301960195560f,0.83146961230254534669f,
-0.59569930449243335691f,0.80320753148064494287f,-0.63439328416364537677f,
0.77301045336273710440f,-0.67155895484701844111f,0.74095112535495899486f,
-0.70710678118654746172f,0.70710678118654757274f,-0.74095112535495888384f,
0.67155895484701855214f,-0.77301045336273699338f,0.63439328416364548779f,
-0.80320753148064483184f,0.59569930449243346793f,-0.83146961230254534669f,
0.55557023301960217765f,-0.85772861000027200706f,0.51410274419322177231f,
-0.88192126434835493853f,0.47139673682599780857f,-0.90398929312344333820f,
0.42755509343028202940f,-0.92387953251128673848f,0.38268343236508989280f,
-0.94154406518302069529f,0.33688985339222032867f,-0.95694033573220882438f,
0.29028467725446238656f,-0.97003125319454397424f,0.24298017990326406523f,
-0.98078528040323043058f,0.19509032201612860891f,-0.98917650996478101444f,
0.14673047445536180344f,-0.99518472667219681771f,0.09801714032956082567f,
-0.99879545620517240501f,0.04906767432741796636f,1.00000000000000000000f,
0.00000000000000000000f,0.98078528040323043058f,0.19509032201612824808f,
0.92387953251128673848f,0.38268343236508978178f,0.83146961230254523567f,
0.55557023301960217765f,0.70710678118654757274f,0.70710678118654757274f,
0.55557023301960228867f,0.83146961230254523567f,0.38268343236508983729f,
0.92387953251128673848f,0.19509032201612833135f,0.98078528040323043058f,
0.00000000000000006123f,1.00000000000000000000f,-0.19509032201612819257f,
0.98078528040323043058f,-0.38268343236508972627f,0.92387953251128673848f,
-0.55557023301960195560f,0.83146961230254534669f,-0.70710678118654746172f,
0.70710678118654757274f,-0.83146961230254534669f,0.55557023301960217765f,
-0.92387953251128673848f,0.38268343236508989280f,-0.98078528040323043058f,
0.19509032201612860891f,1.00000000000000000000f,0.00000000000000000000f,
0.70710678118654757274f,0.70710678118654757274f,0.00000000000000006123f,
1.00000000000000000000f,-0.70710678118654746172f,0.70710678118654757274f,};

float32_t rearranged_twiddle_stride3_256_f32[168]={
1.00000000000000000000f,0.00000000000000000000f,0.99729045667869020697f,
0.07356456359966742631f,0.98917650996478101444f,0.14673047445536174793f,
0.97570213003852857003f,0.21910124015686979759f,0.95694033573220882438f,
0.29028467725446233105f,0.93299279883473895669f,0.35989503653498811087f,
0.90398929312344333820f,0.42755509343028208491f,0.87008699110871146054f,
0.49289819222978403790f,0.83146961230254523567f,0.55557023301960217765f,
0.78834642762660622761f,0.61523159058062681925f,0.74095112535495921691f,
0.67155895484701833009f,0.68954054473706694051f,0.72424708295146689174f,
0.63439328416364548779f,0.77301045336273688235f,0.57580819141784533866f,
0.81758481315158371139f,0.51410274419322166128f,0.85772861000027211809f,
0.44961132965460659516f,0.89322430119551532446f,0.38268343236508983729f,
0.92387953251128673848f,0.31368174039889157312f,0.94952818059303667475f,
0.24298017990326398197f,0.97003125319454397424f,0.17096188876030135595f,
0.98527764238894122162f,0.09801714032956077016f,0.99518472667219681771f,
0.02454122852291226384f,0.99969881869620424997f,-0.04906767432741800800f,
0.99879545620517240501f,-0.12241067519921615403f,0.99247953459870996706f,
-0.19509032201612819257f,0.98078528040323043058f,-0.26671275747489830987f,
0.96377606579543984022f,-0.33688985339221994009f,0.94154406518302080631f,
-0.40524131400498974998f,0.91420975570353069095f,-0.47139673682599769755f,
0.88192126434835504956f,-0.53499761988709704230f,0.84485356524970722791f,
-0.59569930449243335691f,0.80320753148064494287f,-0.65317284295377653347f,
0.75720884650648467851f,-0.70710678118654746172f,0.70710678118654757274f,
-0.75720884650648467851f,0.65317284295377664449f,-0.80320753148064483184f,
0.59569930449243346793f,-0.84485356524970711689f,0.53499761988709715332f,
-0.88192126434835493853f,0.47139673682599780857f,-0.91420975570353069095f,
0.40524131400498991651f,-0.94154406518302069529f,0.33688985339222032867f,
-0.96377606579543984022f,0.26671275747489847641f,-0.98078528040323043058f,
0.19509032201612860891f,-0.99247953459870996706f,0.12241067519921634832f,
-0.99879545620517240501f,0.04906767432741796636f,-0.99969881869620424997f,
-0.02454122852291207996f,-0.99518472667219692873f,-0.09801714032956058975f,
-0.98527764238894133264f,-0.17096188876030096737f,-0.97003125319454397424f,
-0.24298017990326381543f,-0.94952818059303678577f,-0.31368174039889118454f,
-0.92387953251128684951f,-0.38268343236508967076f,-0.89322430119551532446f,
-0.44961132965460665067f,-0.85772861000027211809f,-0.51410274419322155026f,
-0.81758481315158371139f,-0.57580819141784533866f,-0.77301045336273710440f,
-0.63439328416364526575f,-0.72424708295146700276f,-0.68954054473706682948f,
-0.67155895484701866316f,-0.74095112535495888384f,-0.61523159058062726334f,
-0.78834642762660589455f,-0.55557023301960217765f,-0.83146961230254523567f,
-0.49289819222978420443f,-0.87008699110871134952f,-0.42755509343028247349f,
-0.90398929312344311615f,-0.35989503653498794433f,-0.93299279883473895669f,
-0.29028467725446244208f,-0.95694033573220882438f,-0.21910124015687010290f,
-0.97570213003852845901f,-0.14673047445536230304f,-0.98917650996478090342f,
-0.07356456359966735692f,-0.99729045667869020697f,1.00000000000000000000f,
0.00000000000000000000f,0.95694033573220882438f,0.29028467725446233105f,
0.83146961230254523567f,0.55557023301960217765f,0.63439328416364548779f,
0.77301045336273688235f,0.38268343236508983729f,0.92387953251128673848f,
0.09801714032956077016f,0.99518472667219681771f,-0.19509032201612819257f,
0.98078528040323043058f,-0.47139673682599769755f,0.88192126434835504956f,
-0.70710678118654746172f,0.70710678118654757274f,-0.88192126434835493853f,
0.47139673682599780857f,-0.98078528040323043058f,0.19509032201612860891f,
-0.99518472667219692873f,-0.09801714032956058975f,-0.92387953251128684951f,
-0.38268343236508967076f,-0.77301045336273710440f,-0.63439328416364526575f,
-0.55557023301960217765f,-0.83146961230254523567f,-0.29028467725446244208f,
-0.95694033573220882438f,1.00000000000000000000f,0.00000000000000000000f,
0.38268343236508983729f,0.92387953251128673848f,-0.70710678118654746172f,
0.70710678118654757274f,-0.92387953251128684951f,-0.38268343236508967076f,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F32_1024) || defined(ARM_TABLE_TWIDDLECOEF_F32_2048)

uint32_t rearranged_twiddle_tab_stride1_arr_1024_f32[5]={
0,512,640,672,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_1024_f32[5]={
0,512,640,672,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_1024_f32[5]={
0,512,640,672,0,};

float32_t rearranged_twiddle_stride1_1024_f32[680]={
1.00000000000000000000f,0.00000000000000000000f,0.99998117528260110909f,
0.00613588464915447527f,0.99992470183914450299f,0.01227153828571992539f,
0.99983058179582340319f,0.01840672990580482019f,0.99969881869620424997f,
0.02454122852291228812f,0.99952941750109314256f,0.03067480317663662595f,
0.99932238458834954375f,0.03680722294135883171f,0.99907772775264536147f,
0.04293825693494082024f,0.99879545620517240501f,0.04906767432741801493f,
0.99847558057329477421f,0.05519524434968993420f,0.99811811290014917919f,
0.06132073630220857829f,0.99772306664419163624f,0.06744391956366405094f,
0.99729045667869020697f,0.07356456359966742631f,0.99682029929116566791f,
0.07968243797143012563f,0.99631261218277800129f,0.08579731234443989385f,
0.99576741446765981713f,0.09190895649713272386f,0.99518472667219692873f,
0.09801714032956060363f,0.99456457073425541537f,0.10412163387205458642f,
0.99390697000235606051f,0.11022220729388305938f,0.99321194923479450001f,
0.11631863091190475235f,0.99247953459870996706f,0.12241067519921619566f,
0.99170975366909952520f,0.12849811079379316880f,0.99090263542778000971f,
0.13458070850712616773f,0.99005821026229712256f,0.14065823933284921088f,
0.98917650996478101444f,0.14673047445536174793f,0.98825756773074946437f,
0.15279718525844343535f,0.98730141815785843473f,0.15885814333386144570f,
0.98630809724459866938f,0.16491312048996989437f,0.98527764238894122162f,
0.17096188876030121717f,0.98421009238692902521f,0.17700422041214874946f,
0.98310548743121628501f,0.18303988795514095078f,0.98196386910955524296f,
0.18906866414980619262f,0.98078528040323043058f,0.19509032201612824808f,
0.97956976568544051887f,0.20110463484209190055f,0.97831737071962765473f,
0.20711137619221856032f,0.97702814265775439484f,0.21311031991609136194f,
0.97570213003852857003f,0.21910124015686979759f,0.97433938278557585821f,
0.22508391135979283204f,0.97293995220556017678f,0.23105810828067110951f,
0.97150389098625178352f,0.23702360599436719801f,0.97003125319454397424f,
0.24298017990326387094f,0.96852209427441737777f,0.24892760574572014853f,
0.96697647104485207059f,0.25486565960451457169f,0.96539444169768939830f,
0.26079411791527551401f,0.96377606579543984022f,0.26671275747489836538f,
0.96212140426904158019f,0.27262135544994897662f,0.96043051941556578655f,
0.27851968938505305973f,0.95870347489587159906f,0.28440753721127187692f,
0.95694033573220882438f,0.29028467725446233105f,0.95514116830577078243f,
0.29615088824362378883f,0.95330604035419386211f,0.30200594931922808417f,
0.95143502096900833820f,0.30784964004153486661f,0.94952818059303667475f,
0.31368174039889151761f,0.94758559101774109124f,0.31950203081601569188f,
0.94560732538052127971f,0.32531029216226292622f,0.94359345816196038559f,
0.33110630575987642921f,0.94154406518302080631f,0.33688985339222005111f,
0.93945922360218991898f,0.34266071731199437833f,0.93733901191257495977f,
0.34841868024943456472f,0.93518350993894761025f,0.35416352542049034380f,
0.93299279883473895669f,0.35989503653498811087f,0.93076696107898371224f,
0.36561299780477385379f,0.92850608047321558924f,0.37131719395183754306f,
0.92621024213831137928f,0.37700741021641825945f,0.92387953251128673848f,
0.38268343236508978178f,0.92151403934204190183f,0.38834504669882624617f,
0.91911385169005777040f,0.39399204006104809883f,0.91667905992104270485f,
0.39962419984564678810f,0.91420975570353069095f,0.40524131400498986100f,
0.91170603200542987832f,0.41084317105790391089f,0.90916798309052238025f,
0.41642956009763715253f,0.90659570451491533483f,0.42200027079979968159f,
0.90398929312344333820f,0.42755509343028208491f,0.90134884704602202810f,
0.43309381885315195726f,0.89867446569395381673f,0.43861623853852765853f,
0.89596624975618521791f,0.44412214457042920035f,0.89322430119551532446f,
0.44961132965460653965f,0.89044872324475787817f,0.45508358712634383592f,
0.88763962040285393496f,0.46053871095824000514f,0.88479709843093778954f,
0.46597649576796618121f,0.88192126434835504956f,0.47139673682599764204f,
0.87901222642863352519f,0.47679923006332208812f,0.87607009419540660122f,
0.48218377207912271887f,0.87309497841829009079f,0.48755016014843599592f,
0.87008699110871146054f,0.49289819222978403790f,0.86704624551569264845f,
0.49822766697278181303f,0.86397285612158669643f,0.50353838372571757542f,
0.86086693863776730939f,0.50883014254310698909f,0.85772861000027211809f,
0.51410274419322166128f,0.85455798836540053376f,0.51935599016558964269f,
0.85135519310526519554f,0.52458968267846894928f,0.84812034480329723252f,
0.52980362468629460526f,0.84485356524970711689f,0.53499761988709715332f,
0.84155497743689844370f,0.54017147272989285423f,0.83822470555483807875f,
0.54532498842204646383f,0.83486287498638001026f,0.55045797293660481131f,
0.83146961230254523567f,0.55557023301960217765f,0.82804504525775579626f,
0.56066157619733603124f,0.82458930278502529099f,0.56573181078361312046f,
0.82110251499110464835f,0.57078074588696725566f,0.81758481315158371139f,
0.57580819141784533866f,0.81403632970594841378f,0.58081395809576452649f,
0.81045719825259476821f,0.58579785745643886408f,0.80684755354379933401f,
0.59075970185887416442f,0.80320753148064494287f,0.59569930449243335691f,
0.79953726910790501314f,0.60061647938386897305f,0.79583690460888356633f,
0.60551104140432554512f,0.79210657730021238887f,0.61038280627630947528f,
0.78834642762660622761f,0.61523159058062681925f,0.78455659715557524159f,
0.62005721176328909561f,0.78073722857209448822f,0.62485948814238634341f,
0.77688846567323244230f,0.62963823891492698426f,0.77301045336273699338f,
0.63439328416364548779f,0.76910333764557969882f,0.63912444486377573138f,
0.76516726562245895860f,0.64383154288979138613f,0.76120238548426177871f,
0.64851440102211244110f,0.75720884650648456748f,0.65317284295377675551f,
0.75318679904361252042f,0.65780669329707863735f,0.74913639452345937020f,
0.66241577759017178373f,0.74505778544146594733f,0.66699992230363747137f,
0.74095112535495921691f,0.67155895484701833009f,0.73681656887736979300f,
0.67609270357531592310f,0.73265427167241281570f,0.68060099779545302212f,
0.72846439044822519637f,0.68508366777270035541f,0.72424708295146700276f,
0.68954054473706682948f,0.72000250796138165477f,0.69397146088965389055f,
0.71573082528381870571f,0.69837624940897280457f,0.71143219574521643356f,
0.70275474445722529993f,0.70710678118654757274f,0.70710678118654757274f,
0.70275474445722529993f,0.71143219574521643356f,0.69837624940897291559f,
0.71573082528381859468f,0.69397146088965400157f,0.72000250796138165477f,
0.68954054473706694051f,0.72424708295146689174f,0.68508366777270035541f,
0.72846439044822519637f,0.68060099779545302212f,0.73265427167241281570f,
0.67609270357531603413f,0.73681656887736979300f,0.67155895484701833009f,
0.74095112535495910588f,0.66699992230363747137f,0.74505778544146594733f,
0.66241577759017178373f,0.74913639452345925918f,0.65780669329707874837f,
0.75318679904361252042f,0.65317284295377686654f,0.75720884650648456748f,
0.64851440102211255212f,0.76120238548426177871f,0.64383154288979149715f,
0.76516726562245895860f,0.63912444486377573138f,0.76910333764557958780f,
0.63439328416364548779f,0.77301045336273688235f,0.62963823891492709528f,
0.77688846567323244230f,0.62485948814238645443f,0.78073722857209448822f,
0.62005721176328920663f,0.78455659715557524159f,0.61523159058062681925f,
0.78834642762660622761f,0.61038280627630947528f,0.79210657730021227785f,
0.60551104140432554512f,0.79583690460888345530f,0.60061647938386897305f,
0.79953726910790501314f,0.59569930449243346793f,0.80320753148064483184f,
0.59075970185887427544f,0.80684755354379922299f,0.58579785745643886408f,
0.81045719825259476821f,0.58081395809576452649f,0.81403632970594830276f,
0.57580819141784533866f,0.81758481315158371139f,0.57078074588696736669f,
0.82110251499110464835f,0.56573181078361323149f,0.82458930278502529099f,
0.56066157619733603124f,0.82804504525775579626f,0.55557023301960228867f,
0.83146961230254523567f,0.55045797293660481131f,0.83486287498638001026f,
0.54532498842204646383f,0.83822470555483796772f,0.54017147272989296525f,
0.84155497743689833268f,0.53499761988709726435f,0.84485356524970700587f,
0.52980362468629482731f,0.84812034480329712149f,0.52458968267846883826f,
0.85135519310526519554f,0.51935599016558953167f,0.85455798836540053376f,
0.51410274419322166128f,0.85772861000027211809f,0.50883014254310698909f,
0.86086693863776730939f,0.50353838372571757542f,0.86397285612158669643f,
0.49822766697278186854f,0.86704624551569264845f,0.49289819222978409341f,
0.87008699110871134952f,0.48755016014843605143f,0.87309497841829009079f,
0.48218377207912282989f,0.87607009419540660122f,0.47679923006332225466f,
0.87901222642863341417f,0.47139673682599780857f,0.88192126434835493853f,
0.46597649576796612569f,0.88479709843093778954f,0.46053871095824000514f,
0.88763962040285393496f,0.45508358712634383592f,0.89044872324475787817f,
0.44961132965460659516f,0.89322430119551532446f,0.44412214457042925586f,
0.89596624975618510689f,0.43861623853852771404f,0.89867446569395381673f,
0.43309381885315201277f,0.90134884704602202810f,0.42755509343028219593f,
0.90398929312344333820f,0.42200027079979979261f,0.90659570451491533483f,
0.41642956009763731906f,0.90916798309052226923f,0.41084317105790391089f,
0.91170603200542987832f,0.40524131400498986100f,0.91420975570353069095f,
0.39962419984564678810f,0.91667905992104270485f,0.39399204006104809883f,
0.91911385169005777040f,0.38834504669882630168f,0.92151403934204190183f,
0.38268343236508983729f,0.92387953251128673848f,0.37700741021641831496f,
0.92621024213831126826f,0.37131719395183759858f,0.92850608047321558924f,
0.36561299780477396482f,0.93076696107898371224f,0.35989503653498827740f,
0.93299279883473884567f,0.35416352542049051033f,0.93518350993894749923f,
0.34841868024943450921f,0.93733901191257495977f,0.34266071731199437833f,
0.93945922360218991898f,0.33688985339222005111f,0.94154406518302080631f,
0.33110630575987642921f,0.94359345816196038559f,0.32531029216226298173f,
0.94560732538052127971f,0.31950203081601574739f,0.94758559101774109124f,
0.31368174039889157312f,0.94952818059303667475f,0.30784964004153497763f,
0.95143502096900833820f,0.30200594931922819519f,0.95330604035419375109f,
0.29615088824362395536f,0.95514116830577067141f,0.29028467725446233105f,
0.95694033573220893540f,0.28440753721127182141f,0.95870347489587159906f,
0.27851968938505305973f,0.96043051941556578655f,0.27262135544994897662f,
0.96212140426904158019f,0.26671275747489842090f,0.96377606579543984022f,
0.26079411791527556952f,0.96539444169768939830f,0.25486565960451462720f,
0.96697647104485207059f,0.24892760574572025956f,0.96852209427441726675f,
0.24298017990326398197f,0.97003125319454397424f,0.23702360599436733679f,
0.97150389098625178352f,0.23105810828067127605f,0.97293995220556006576f,
0.22508391135979277653f,0.97433938278557585821f,0.21910124015686976984f,
0.97570213003852857003f,0.21311031991609136194f,0.97702814265775439484f,
0.20711137619221856032f,0.97831737071962765473f,0.20110463484209195606f,
0.97956976568544051887f,0.19509032201612833135f,0.98078528040323043058f,
0.18906866414980627589f,0.98196386910955524296f,0.18303988795514106180f,
0.98310548743121628501f,0.17700422041214886049f,0.98421009238692902521f,
0.17096188876030135595f,0.98527764238894122162f,0.16491312048997008866f,
0.98630809724459866938f,0.15885814333386139019f,0.98730141815785843473f,
0.15279718525844340760f,0.98825756773074946437f,0.14673047445536174793f,
0.98917650996478101444f,0.14065823933284923863f,0.99005821026229712256f,
0.13458070850712622324f,0.99090263542778000971f,0.12849811079379322432f,
0.99170975366909952520f,0.12241067519921627893f,0.99247953459870996706f,
0.11631863091190487725f,0.99321194923479450001f,0.11022220729388318428f,
0.99390697000235606051f,0.10412163387205472520f,0.99456457073425541537f,
0.09801714032956077016f,0.99518472667219681771f,0.09190895649713269611f,
0.99576741446765981713f,0.08579731234443987997f,0.99631261218277800129f,
0.07968243797143012563f,0.99682029929116566791f,0.07356456359966745406f,
0.99729045667869020697f,0.06744391956366410645f,0.99772306664419163624f,
0.06132073630220864768f,0.99811811290014917919f,0.05519524434969003135f,
0.99847558057329477421f,0.04906767432741812596f,0.99879545620517240501f,
0.04293825693494095902f,0.99907772775264536147f,0.03680722294135899131f,
0.99932238458834954375f,0.03067480317663658085f,0.99952941750109314256f,
0.02454122852291226384f,0.99969881869620424997f,0.01840672990580482019f,
0.99983058179582340319f,0.01227153828571994447f,0.99992470183914450299f,
0.00613588464915451517f,0.99998117528260110909f,1.00000000000000000000f,
0.00000000000000000000f,0.99969881869620424997f,0.02454122852291228812f,
0.99879545620517240501f,0.04906767432741801493f,0.99729045667869020697f,
0.07356456359966742631f,0.99518472667219692873f,0.09801714032956060363f,
0.99247953459870996706f,0.12241067519921619566f,0.98917650996478101444f,
0.14673047445536174793f,0.98527764238894122162f,0.17096188876030121717f,
0.98078528040323043058f,0.19509032201612824808f,0.97570213003852857003f,
0.21910124015686979759f,0.97003125319454397424f,0.24298017990326387094f,
0.96377606579543984022f,0.26671275747489836538f,0.95694033573220882438f,
0.29028467725446233105f,0.94952818059303667475f,0.31368174039889151761f,
0.94154406518302080631f,0.33688985339222005111f,0.93299279883473895669f,
0.35989503653498811087f,0.92387953251128673848f,0.38268343236508978178f,
0.91420975570353069095f,0.40524131400498986100f,0.90398929312344333820f,
0.42755509343028208491f,0.89322430119551532446f,0.44961132965460653965f,
0.88192126434835504956f,0.47139673682599764204f,0.87008699110871146054f,
0.49289819222978403790f,0.85772861000027211809f,0.51410274419322166128f,
0.84485356524970711689f,0.53499761988709715332f,0.83146961230254523567f,
0.55557023301960217765f,0.81758481315158371139f,0.57580819141784533866f,
0.80320753148064494287f,0.59569930449243335691f,0.78834642762660622761f,
0.61523159058062681925f,0.77301045336273699338f,0.63439328416364548779f,
0.75720884650648456748f,0.65317284295377675551f,0.74095112535495921691f,
0.67155895484701833009f,0.72424708295146700276f,0.68954054473706682948f,
0.70710678118654757274f,0.70710678118654757274f,0.68954054473706694051f,
0.72424708295146689174f,0.67155895484701833009f,0.74095112535495910588f,
0.65317284295377686654f,0.75720884650648456748f,0.63439328416364548779f,
0.77301045336273688235f,0.61523159058062681925f,0.78834642762660622761f,
0.59569930449243346793f,0.80320753148064483184f,0.57580819141784533866f,
0.81758481315158371139f,0.55557023301960228867f,0.83146961230254523567f,
0.53499761988709726435f,0.84485356524970700587f,0.51410274419322166128f,
0.85772861000027211809f,0.49289819222978409341f,0.87008699110871134952f,
0.47139673682599780857f,0.88192126434835493853f,0.44961132965460659516f,
0.89322430119551532446f,0.42755509343028219593f,0.90398929312344333820f,
0.40524131400498986100f,0.91420975570353069095f,0.38268343236508983729f,
0.92387953251128673848f,0.35989503653498827740f,0.93299279883473884567f,
0.33688985339222005111f,0.94154406518302080631f,0.31368174039889157312f,
0.94952818059303667475f,0.29028467725446233105f,0.95694033573220893540f,
0.26671275747489842090f,0.96377606579543984022f,0.24298017990326398197f,
0.97003125319454397424f,0.21910124015686976984f,0.97570213003852857003f,
0.19509032201612833135f,0.98078528040323043058f,0.17096188876030135595f,
0.98527764238894122162f,0.14673047445536174793f,0.98917650996478101444f,
0.12241067519921627893f,0.99247953459870996706f,0.09801714032956077016f,
0.99518472667219681771f,0.07356456359966745406f,0.99729045667869020697f,
0.04906767432741812596f,0.99879545620517240501f,0.02454122852291226384f,
0.99969881869620424997f,1.00000000000000000000f,0.00000000000000000000f,
0.99518472667219692873f,0.09801714032956060363f,0.98078528040323043058f,
0.19509032201612824808f,0.95694033573220882438f,0.29028467725446233105f,
0.92387953251128673848f,0.38268343236508978178f,0.88192126434835504956f,
0.47139673682599764204f,0.83146961230254523567f,0.55557023301960217765f,
0.77301045336273699338f,0.63439328416364548779f,0.70710678118654757274f,
0.70710678118654757274f,0.63439328416364548779f,0.77301045336273688235f,
0.55557023301960228867f,0.83146961230254523567f,0.47139673682599780857f,
0.88192126434835493853f,0.38268343236508983729f,0.92387953251128673848f,
0.29028467725446233105f,0.95694033573220893540f,0.19509032201612833135f,
0.98078528040323043058f,0.09801714032956077016f,0.99518472667219681771f,
1.00000000000000000000f,0.00000000000000000000f,0.92387953251128673848f,
0.38268343236508978178f,0.70710678118654757274f,0.70710678118654757274f,
0.38268343236508983729f,0.92387953251128673848f,};

float32_t rearranged_twiddle_stride2_1024_f32[680]={
1.00000000000000000000f,0.00000000000000000000f,0.99992470183914450299f,
0.01227153828571992539f,0.99969881869620424997f,0.02454122852291228812f,
0.99932238458834954375f,0.03680722294135883171f,0.99879545620517240501f,
0.04906767432741801493f,0.99811811290014917919f,0.06132073630220857829f,
0.99729045667869020697f,0.07356456359966742631f,0.99631261218277800129f,
0.08579731234443989385f,0.99518472667219692873f,0.09801714032956060363f,
0.99390697000235606051f,0.11022220729388305938f,0.99247953459870996706f,
0.12241067519921619566f,0.99090263542778000971f,0.13458070850712616773f,
0.98917650996478101444f,0.14673047445536174793f,0.98730141815785843473f,
0.15885814333386144570f,0.98527764238894122162f,0.17096188876030121717f,
0.98310548743121628501f,0.18303988795514095078f,0.98078528040323043058f,
0.19509032201612824808f,0.97831737071962765473f,0.20711137619221856032f,
0.97570213003852857003f,0.21910124015686979759f,0.97293995220556017678f,
0.23105810828067110951f,0.97003125319454397424f,0.24298017990326387094f,
0.96697647104485207059f,0.25486565960451457169f,0.96377606579543984022f,
0.26671275747489836538f,0.96043051941556578655f,0.27851968938505305973f,
0.95694033573220882438f,0.29028467725446233105f,0.95330604035419386211f,
0.30200594931922808417f,0.94952818059303667475f,0.31368174039889151761f,
0.94560732538052127971f,0.32531029216226292622f,0.94154406518302080631f,
0.33688985339222005111f,0.93733901191257495977f,0.34841868024943456472f,
0.93299279883473895669f,0.35989503653498811087f,0.92850608047321558924f,
0.37131719395183754306f,0.92387953251128673848f,0.38268343236508978178f,
0.91911385169005777040f,0.39399204006104809883f,0.91420975570353069095f,
0.40524131400498986100f,0.90916798309052238025f,0.41642956009763715253f,
0.90398929312344333820f,0.42755509343028208491f,0.89867446569395381673f,
0.43861623853852765853f,0.89322430119551532446f,0.44961132965460653965f,
0.88763962040285393496f,0.46053871095824000514f,0.88192126434835504956f,
0.47139673682599764204f,0.87607009419540660122f,0.48218377207912271887f,
0.87008699110871146054f,0.49289819222978403790f,0.86397285612158669643f,
0.50353838372571757542f,0.85772861000027211809f,0.51410274419322166128f,
0.85135519310526519554f,0.52458968267846894928f,0.84485356524970711689f,
0.53499761988709715332f,0.83822470555483807875f,0.54532498842204646383f,
0.83146961230254523567f,0.55557023301960217765f,0.82458930278502529099f,
0.56573181078361312046f,0.81758481315158371139f,0.57580819141784533866f,
0.81045719825259476821f,0.58579785745643886408f,0.80320753148064494287f,
0.59569930449243335691f,0.79583690460888356633f,0.60551104140432554512f,
0.78834642762660622761f,0.61523159058062681925f,0.78073722857209448822f,
0.62485948814238634341f,0.77301045336273699338f,0.63439328416364548779f,
0.76516726562245895860f,0.64383154288979138613f,0.75720884650648456748f,
0.65317284295377675551f,0.74913639452345937020f,0.66241577759017178373f,
0.74095112535495921691f,0.67155895484701833009f,0.73265427167241281570f,
0.68060099779545302212f,0.72424708295146700276f,0.68954054473706682948f,
0.71573082528381870571f,0.69837624940897280457f,0.70710678118654757274f,
0.70710678118654757274f,0.69837624940897291559f,0.71573082528381859468f,
0.68954054473706694051f,0.72424708295146689174f,0.68060099779545302212f,
0.73265427167241281570f,0.67155895484701833009f,0.74095112535495910588f,
0.66241577759017178373f,0.74913639452345925918f,0.65317284295377686654f,
0.75720884650648456748f,0.64383154288979149715f,0.76516726562245895860f,
0.63439328416364548779f,0.77301045336273688235f,0.62485948814238645443f,
0.78073722857209448822f,0.61523159058062681925f,0.78834642762660622761f,
0.60551104140432554512f,0.79583690460888345530f,0.59569930449243346793f,
0.80320753148064483184f,0.58579785745643886408f,0.81045719825259476821f,
0.57580819141784533866f,0.81758481315158371139f,0.56573181078361323149f,
0.82458930278502529099f,0.55557023301960228867f,0.83146961230254523567f,
0.54532498842204646383f,0.83822470555483796772f,0.53499761988709726435f,
0.84485356524970700587f,0.52458968267846883826f,0.85135519310526519554f,
0.51410274419322166128f,0.85772861000027211809f,0.50353838372571757542f,
0.86397285612158669643f,0.49289819222978409341f,0.87008699110871134952f,
0.48218377207912282989f,0.87607009419540660122f,0.47139673682599780857f,
0.88192126434835493853f,0.46053871095824000514f,0.88763962040285393496f,
0.44961132965460659516f,0.89322430119551532446f,0.43861623853852771404f,
0.89867446569395381673f,0.42755509343028219593f,0.90398929312344333820f,
0.41642956009763731906f,0.90916798309052226923f,0.40524131400498986100f,
0.91420975570353069095f,0.39399204006104809883f,0.91911385169005777040f,
0.38268343236508983729f,0.92387953251128673848f,0.37131719395183759858f,
0.92850608047321558924f,0.35989503653498827740f,0.93299279883473884567f,
0.34841868024943450921f,0.93733901191257495977f,0.33688985339222005111f,
0.94154406518302080631f,0.32531029216226298173f,0.94560732538052127971f,
0.31368174039889157312f,0.94952818059303667475f,0.30200594931922819519f,
0.95330604035419375109f,0.29028467725446233105f,0.95694033573220893540f,
0.27851968938505305973f,0.96043051941556578655f,0.26671275747489842090f,
0.96377606579543984022f,0.25486565960451462720f,0.96697647104485207059f,
0.24298017990326398197f,0.97003125319454397424f,0.23105810828067127605f,
0.97293995220556006576f,0.21910124015686976984f,0.97570213003852857003f,
0.20711137619221856032f,0.97831737071962765473f,0.19509032201612833135f,
0.98078528040323043058f,0.18303988795514106180f,0.98310548743121628501f,
0.17096188876030135595f,0.98527764238894122162f,0.15885814333386139019f,
0.98730141815785843473f,0.14673047445536174793f,0.98917650996478101444f,
0.13458070850712622324f,0.99090263542778000971f,0.12241067519921627893f,
0.99247953459870996706f,0.11022220729388318428f,0.99390697000235606051f,
0.09801714032956077016f,0.99518472667219681771f,0.08579731234443987997f,
0.99631261218277800129f,0.07356456359966745406f,0.99729045667869020697f,
0.06132073630220864768f,0.99811811290014917919f,0.04906767432741812596f,
0.99879545620517240501f,0.03680722294135899131f,0.99932238458834954375f,
0.02454122852291226384f,0.99969881869620424997f,0.01227153828571994447f,
0.99992470183914450299f,0.00000000000000006123f,1.00000000000000000000f,
-0.01227153828571982304f,0.99992470183914450299f,-0.02454122852291214241f,
0.99969881869620424997f,-0.03680722294135886641f,0.99932238458834954375f,
-0.04906767432741800800f,0.99879545620517240501f,-0.06132073630220852972f,
0.99811811290014917919f,-0.07356456359966732916f,0.99729045667869020697f,
-0.08579731234443975507f,0.99631261218277800129f,-0.09801714032956064526f,
0.99518472667219692873f,-0.11022220729388305938f,0.99390697000235606051f,
-0.12241067519921615403f,0.99247953459870996706f,-0.13458070850712611222f,
0.99090263542778000971f,-0.14673047445536163691f,0.98917650996478101444f,
-0.15885814333386127917f,0.98730141815785843473f,-0.17096188876030124493f,
0.98527764238894122162f,-0.18303988795514092303f,0.98310548743121628501f,
-0.19509032201612819257f,0.98078528040323043058f,-0.20711137619221844930f,
0.97831737071962765473f,-0.21910124015686965881f,0.97570213003852857003f,
-0.23105810828067113727f,0.97293995220556017678f,-0.24298017990326387094f,
0.97003125319454397424f,-0.25486565960451451618f,0.96697647104485207059f,
-0.26671275747489830987f,0.96377606579543984022f,-0.27851968938505294870f,
0.96043051941556589757f,-0.29028467725446216452f,0.95694033573220893540f,
-0.30200594931922808417f,0.95330604035419386211f,-0.31368174039889140658f,
0.94952818059303667475f,-0.32531029216226287071f,0.94560732538052139073f,
-0.33688985339221994009f,0.94154406518302080631f,-0.34841868024943439819f,
0.93733901191257495977f,-0.35989503653498816638f,0.93299279883473884567f,
-0.37131719395183748755f,0.92850608047321558924f,-0.38268343236508972627f,
0.92387953251128673848f,-0.39399204006104798781f,0.91911385169005777040f,
-0.40524131400498974998f,0.91420975570353069095f,-0.41642956009763698599f,
0.90916798309052249127f,-0.42755509343028186287f,0.90398929312344344922f,
-0.43861623853852738097f,0.89867446569395392775f,-0.44961132965460670619f,
0.89322430119551521344f,-0.46053871095824006066f,0.88763962040285393496f,
-0.47139673682599769755f,0.88192126434835504956f,-0.48218377207912271887f,
0.87607009419540660122f,-0.49289819222978398239f,0.87008699110871146054f,
-0.50353838372571746440f,0.86397285612158680745f,-0.51410274419322155026f,
0.85772861000027211809f,-0.52458968267846872724f,0.85135519310526519554f,
-0.53499761988709704230f,0.84485356524970722791f,-0.54532498842204624179f,
0.83822470555483818977f,-0.55557023301960195560f,0.83146961230254534669f,
-0.56573181078361323149f,0.82458930278502517996f,-0.57580819141784533866f,
0.81758481315158371139f,-0.58579785745643886408f,0.81045719825259476821f,
-0.59569930449243335691f,0.80320753148064494287f,-0.60551104140432543410f,
0.79583690460888356633f,-0.61523159058062670823f,0.78834642762660633863f,
-0.62485948814238623239f,0.78073722857209459924f,-0.63439328416364537677f,
0.77301045336273710440f,-0.64383154288979127511f,0.76516726562245906962f,
-0.65317284295377653347f,0.75720884650648467851f,-0.66241577759017189475f,
0.74913639452345925918f,-0.67155895484701844111f,0.74095112535495899486f,
-0.68060099779545302212f,0.73265427167241281570f,-0.68954054473706694051f,
0.72424708295146689174f,-0.69837624940897280457f,0.71573082528381870571f,
-0.70710678118654746172f,0.70710678118654757274f,-0.71573082528381859468f,
0.69837624940897291559f,-0.72424708295146678072f,0.68954054473706705153f,
-0.73265427167241270467f,0.68060099779545324417f,-0.74095112535495888384f,
0.67155895484701855214f,-0.74913639452345914815f,0.66241577759017200577f,
-0.75720884650648467851f,0.65317284295377664449f,-0.76516726562245895860f,
0.64383154288979138613f,-0.77301045336273699338f,0.63439328416364548779f,
-0.78073722857209448822f,0.62485948814238634341f,-0.78834642762660622761f,
0.61523159058062693028f,-0.79583690460888345530f,0.60551104140432565615f,
-0.80320753148064483184f,0.59569930449243346793f,-0.81045719825259465718f,
0.58579785745643897510f,-0.81758481315158360037f,0.57580819141784544968f,
-0.82458930278502506894f,0.56573181078361345353f,-0.83146961230254534669f,
0.55557023301960217765f,-0.83822470555483807875f,0.54532498842204635281f,
-0.84485356524970711689f,0.53499761988709715332f,-0.85135519310526519554f,
0.52458968267846894928f,-0.85772861000027200706f,0.51410274419322177231f,
-0.86397285612158669643f,0.50353838372571757542f,-0.87008699110871134952f,
0.49289819222978414892f,-0.87607009419540649020f,0.48218377207912288540f,
-0.88192126434835493853f,0.47139673682599780857f,-0.88763962040285382393f,
0.46053871095824022719f,-0.89322430119551521344f,0.44961132965460687272f,
-0.89867446569395392775f,0.43861623853852754751f,-0.90398929312344333820f,
0.42755509343028202940f,-0.90916798309052238025f,0.41642956009763715253f,
-0.91420975570353069095f,0.40524131400498991651f,-0.91911385169005777040f,
0.39399204006104815434f,-0.92387953251128673848f,0.38268343236508989280f,
-0.92850608047321547822f,0.37131719395183770960f,-0.93299279883473884567f,
0.35989503653498833291f,-0.93733901191257484875f,0.34841868024943478677f,
-0.94154406518302069529f,0.33688985339222032867f,-0.94560732538052116869f,
0.32531029216226325929f,-0.94952818059303667475f,0.31368174039889140658f,
-0.95330604035419386211f,0.30200594931922802866f,-0.95694033573220882438f,
0.29028467725446238656f,-0.96043051941556578655f,0.27851968938505317075f,
-0.96377606579543984022f,0.26671275747489847641f,-0.96697647104485207059f,
0.25486565960451468271f,-0.97003125319454397424f,0.24298017990326406523f,
-0.97293995220556006576f,0.23105810828067133156f,-0.97570213003852845901f,
0.21910124015687004739f,-0.97831737071962754371f,0.20711137619221883788f,
-0.98078528040323043058f,0.19509032201612860891f,-0.98310548743121628501f,
0.18303988795514089527f,-0.98527764238894122162f,0.17096188876030121717f,
-0.98730141815785843473f,0.15885814333386147346f,-0.98917650996478101444f,
0.14673047445536180344f,-0.99090263542778000971f,0.13458070850712627875f,
-0.99247953459870996706f,0.12241067519921634832f,-0.99390697000235606051f,
0.11022220729388323979f,-0.99518472667219681771f,0.09801714032956082567f,
-0.99631261218277800129f,0.08579731234444015753f,-0.99729045667869020697f,
0.07356456359966773162f,-0.99811811290014917919f,0.06132073630220848809f,
-0.99879545620517240501f,0.04906767432741796636f,-0.99932238458834954375f,
0.03680722294135883171f,-0.99969881869620424997f,0.02454122852291232629f,
-0.99992470183914450299f,0.01227153828572000692f,1.00000000000000000000f,
0.00000000000000000000f,0.99879545620517240501f,0.04906767432741801493f,
0.99518472667219692873f,0.09801714032956060363f,0.98917650996478101444f,
0.14673047445536174793f,0.98078528040323043058f,0.19509032201612824808f,
0.97003125319454397424f,0.24298017990326387094f,0.95694033573220882438f,
0.29028467725446233105f,0.94154406518302080631f,0.33688985339222005111f,
0.92387953251128673848f,0.38268343236508978178f,0.90398929312344333820f,
0.42755509343028208491f,0.88192126434835504956f,0.47139673682599764204f,
0.85772861000027211809f,0.51410274419322166128f,0.83146961230254523567f,
0.55557023301960217765f,0.80320753148064494287f,0.59569930449243335691f,
0.77301045336273699338f,0.63439328416364548779f,0.74095112535495921691f,
0.67155895484701833009f,0.70710678118654757274f,0.70710678118654757274f,
0.67155895484701833009f,0.74095112535495910588f,0.63439328416364548779f,
0.77301045336273688235f,0.59569930449243346793f,0.80320753148064483184f,
0.55557023301960228867f,0.83146961230254523567f,0.51410274419322166128f,
0.85772861000027211809f,0.47139673682599780857f,0.88192126434835493853f,
0.42755509343028219593f,0.90398929312344333820f,0.38268343236508983729f,
0.92387953251128673848f,0.33688985339222005111f,0.94154406518302080631f,
0.29028467725446233105f,0.95694033573220893540f,0.24298017990326398197f,
0.97003125319454397424f,0.19509032201612833135f,0.98078528040323043058f,
0.14673047445536174793f,0.98917650996478101444f,0.09801714032956077016f,
0.99518472667219681771f,0.04906767432741812596f,0.99879545620517240501f,
0.00000000000000006123f,1.00000000000000000000f,-0.04906767432741800800f,
0.99879545620517240501f,-0.09801714032956064526f,0.99518472667219692873f,
-0.14673047445536163691f,0.98917650996478101444f,-0.19509032201612819257f,
0.98078528040323043058f,-0.24298017990326387094f,0.97003125319454397424f,
-0.29028467725446216452f,0.95694033573220893540f,-0.33688985339221994009f,
0.94154406518302080631f,-0.38268343236508972627f,0.92387953251128673848f,
-0.42755509343028186287f,0.90398929312344344922f,-0.47139673682599769755f,
0.88192126434835504956f,-0.51410274419322155026f,0.85772861000027211809f,
-0.55557023301960195560f,0.83146961230254534669f,-0.59569930449243335691f,
0.80320753148064494287f,-0.63439328416364537677f,0.77301045336273710440f,
-0.67155895484701844111f,0.74095112535495899486f,-0.70710678118654746172f,
0.70710678118654757274f,-0.74095112535495888384f,0.67155895484701855214f,
-0.77301045336273699338f,0.63439328416364548779f,-0.80320753148064483184f,
0.59569930449243346793f,-0.83146961230254534669f,0.55557023301960217765f,
-0.85772861000027200706f,0.51410274419322177231f,-0.88192126434835493853f,
0.47139673682599780857f,-0.90398929312344333820f,0.42755509343028202940f,
-0.92387953251128673848f,0.38268343236508989280f,-0.94154406518302069529f,
0.33688985339222032867f,-0.95694033573220882438f,0.29028467725446238656f,
-0.97003125319454397424f,0.24298017990326406523f,-0.98078528040323043058f,
0.19509032201612860891f,-0.98917650996478101444f,0.14673047445536180344f,
-0.99518472667219681771f,0.09801714032956082567f,-0.99879545620517240501f,
0.04906767432741796636f,1.00000000000000000000f,0.00000000000000000000f,
0.98078528040323043058f,0.19509032201612824808f,0.92387953251128673848f,
0.38268343236508978178f,0.83146961230254523567f,0.55557023301960217765f,
0.70710678118654757274f,0.70710678118654757274f,0.55557023301960228867f,
0.83146961230254523567f,0.38268343236508983729f,0.92387953251128673848f,
0.19509032201612833135f,0.98078528040323043058f,0.00000000000000006123f,
1.00000000000000000000f,-0.19509032201612819257f,0.98078528040323043058f,
-0.38268343236508972627f,0.92387953251128673848f,-0.55557023301960195560f,
0.83146961230254534669f,-0.70710678118654746172f,0.70710678118654757274f,
-0.83146961230254534669f,0.55557023301960217765f,-0.92387953251128673848f,
0.38268343236508989280f,-0.98078528040323043058f,0.19509032201612860891f,
1.00000000000000000000f,0.00000000000000000000f,0.70710678118654757274f,
0.70710678118654757274f,0.00000000000000006123f,1.00000000000000000000f,
-0.70710678118654746172f,0.70710678118654757274f,};

float32_t rearranged_twiddle_stride3_1024_f32[680]={
1.00000000000000000000f,0.00000000000000000000f,0.99983058179582340319f,
0.01840672990580482019f,0.99932238458834954375f,0.03680722294135883171f,
0.99847558057329477421f,0.05519524434968993420f,0.99729045667869020697f,
0.07356456359966742631f,0.99576741446765981713f,0.09190895649713272386f,
0.99390697000235606051f,0.11022220729388305938f,0.99170975366909952520f,
0.12849811079379316880f,0.98917650996478101444f,0.14673047445536174793f,
0.98630809724459866938f,0.16491312048996989437f,0.98310548743121628501f,
0.18303988795514095078f,0.97956976568544051887f,0.20110463484209190055f,
0.97570213003852857003f,0.21910124015686979759f,0.97150389098625178352f,
0.23702360599436719801f,0.96697647104485207059f,0.25486565960451457169f,
0.96212140426904158019f,0.27262135544994897662f,0.95694033573220882438f,
0.29028467725446233105f,0.95143502096900833820f,0.30784964004153486661f,
0.94560732538052127971f,0.32531029216226292622f,0.93945922360218991898f,
0.34266071731199437833f,0.93299279883473895669f,0.35989503653498811087f,
0.92621024213831137928f,0.37700741021641825945f,0.91911385169005777040f,
0.39399204006104809883f,0.91170603200542987832f,0.41084317105790391089f,
0.90398929312344333820f,0.42755509343028208491f,0.89596624975618521791f,
0.44412214457042920035f,0.88763962040285393496f,0.46053871095824000514f,
0.87901222642863352519f,0.47679923006332208812f,0.87008699110871146054f,
0.49289819222978403790f,0.86086693863776730939f,0.50883014254310698909f,
0.85135519310526519554f,0.52458968267846894928f,0.84155497743689844370f,
0.54017147272989285423f,0.83146961230254523567f,0.55557023301960217765f,
0.82110251499110464835f,0.57078074588696725566f,0.81045719825259476821f,
0.58579785745643886408f,0.79953726910790501314f,0.60061647938386897305f,
0.78834642762660622761f,0.61523159058062681925f,0.77688846567323244230f,
0.62963823891492698426f,0.76516726562245895860f,0.64383154288979138613f,
0.75318679904361252042f,0.65780669329707863735f,0.74095112535495921691f,
0.67155895484701833009f,0.72846439044822519637f,0.68508366777270035541f,
0.71573082528381870571f,0.69837624940897280457f,0.70275474445722529993f,
0.71143219574521643356f,0.68954054473706694051f,0.72424708295146689174f,
0.67609270357531603413f,0.73681656887736979300f,0.66241577759017178373f,
0.74913639452345925918f,0.64851440102211255212f,0.76120238548426177871f,
0.63439328416364548779f,0.77301045336273688235f,0.62005721176328920663f,
0.78455659715557524159f,0.60551104140432554512f,0.79583690460888345530f,
0.59075970185887427544f,0.80684755354379922299f,0.57580819141784533866f,
0.81758481315158371139f,0.56066157619733603124f,0.82804504525775579626f,
0.54532498842204646383f,0.83822470555483796772f,0.52980362468629482731f,
0.84812034480329712149f,0.51410274419322166128f,0.85772861000027211809f,
0.49822766697278186854f,0.86704624551569264845f,0.48218377207912282989f,
0.87607009419540660122f,0.46597649576796612569f,0.88479709843093778954f,
0.44961132965460659516f,0.89322430119551532446f,0.43309381885315201277f,
0.90134884704602202810f,0.41642956009763731906f,0.90916798309052226923f,
0.39962419984564678810f,0.91667905992104270485f,0.38268343236508983729f,
0.92387953251128673848f,0.36561299780477396482f,0.93076696107898371224f,
0.34841868024943450921f,0.93733901191257495977f,0.33110630575987642921f,
0.94359345816196038559f,0.31368174039889157312f,0.94952818059303667475f,
0.29615088824362395536f,0.95514116830577067141f,0.27851968938505305973f,
0.96043051941556578655f,0.26079411791527556952f,0.96539444169768939830f,
0.24298017990326398197f,0.97003125319454397424f,0.22508391135979277653f,
0.97433938278557585821f,0.20711137619221856032f,0.97831737071962765473f,
0.18906866414980627589f,0.98196386910955524296f,0.17096188876030135595f,
0.98527764238894122162f,0.15279718525844340760f,0.98825756773074946437f,
0.13458070850712622324f,0.99090263542778000971f,0.11631863091190487725f,
0.99321194923479450001f,0.09801714032956077016f,0.99518472667219681771f,
0.07968243797143012563f,0.99682029929116566791f,0.06132073630220864768f,
0.99811811290014917919f,0.04293825693494095902f,0.99907772775264536147f,
0.02454122852291226384f,0.99969881869620424997f,0.00613588464915451517f,
0.99998117528260110909f,-0.01227153828571982304f,0.99992470183914450299f,
-0.03067480317663645942f,0.99952941750109314256f,-0.04906767432741800800f,
0.99879545620517240501f,-0.06744391956366398155f,0.99772306664419163624f,
-0.08579731234443975507f,0.99631261218277800129f,-0.10412163387205460030f,
0.99456457073425541537f,-0.12241067519921615403f,0.99247953459870996706f,
-0.14065823933284912761f,0.99005821026229712256f,-0.15885814333386127917f,
0.98730141815785843473f,-0.17700422041214874946f,0.98421009238692902521f,
-0.19509032201612819257f,0.98078528040323043058f,-0.21311031991609125091f,
0.97702814265775439484f,-0.23105810828067113727f,0.97293995220556017678f,
-0.24892760574572012078f,0.96852209427441737777f,-0.26671275747489830987f,
0.96377606579543984022f,-0.28440753721127171039f,0.95870347489587159906f,
-0.30200594931922808417f,0.95330604035419386211f,-0.31950203081601563637f,
0.94758559101774120226f,-0.33688985339221994009f,0.94154406518302080631f,
-0.35416352542049039931f,0.93518350993894761025f,-0.37131719395183748755f,
0.92850608047321558924f,-0.38834504669882619066f,0.92151403934204201285f,
-0.40524131400498974998f,0.91420975570353069095f,-0.42200027079979968159f,
0.90659570451491533483f,-0.43861623853852738097f,0.89867446569395392775f,
-0.45508358712634372489f,0.89044872324475798919f,-0.47139673682599769755f,
0.88192126434835504956f,-0.48755016014843571837f,0.87309497841829020182f,
-0.50353838372571746440f,0.86397285612158680745f,-0.51935599016558964269f,
0.85455798836540053376f,-0.53499761988709704230f,0.84485356524970722791f,
-0.55045797293660470029f,0.83486287498638012128f,-0.56573181078361323149f,
0.82458930278502517996f,-0.58081395809576441547f,0.81403632970594852480f,
-0.59569930449243335691f,0.80320753148064494287f,-0.61038280627630958630f,
0.79210657730021227785f,-0.62485948814238623239f,0.78073722857209459924f,
-0.63912444486377573138f,0.76910333764557958780f,-0.65317284295377653347f,
0.75720884650648467851f,-0.66699992230363736034f,0.74505778544146605835f,
-0.68060099779545302212f,0.73265427167241281570f,-0.69397146088965377952f,
0.72000250796138176579f,-0.70710678118654746172f,0.70710678118654757274f,
-0.72000250796138165477f,0.69397146088965389055f,-0.73265427167241270467f,
0.68060099779545324417f,-0.74505778544146594733f,0.66699992230363758239f,
-0.75720884650648467851f,0.65317284295377664449f,-0.76910333764557947678f,
0.63912444486377584241f,-0.78073722857209448822f,0.62485948814238634341f,
-0.79210657730021216683f,0.61038280627630969732f,-0.80320753148064483184f,
0.59569930449243346793f,-0.81403632970594841378f,0.58081395809576452649f,
-0.82458930278502506894f,0.56573181078361345353f,-0.83486287498638001026f,
0.55045797293660492233f,-0.84485356524970711689f,0.53499761988709715332f,
-0.85455798836540042274f,0.51935599016558975372f,-0.86397285612158669643f,
0.50353838372571757542f,-0.87309497841829009079f,0.48755016014843588490f,
-0.88192126434835493853f,0.47139673682599780857f,-0.89044872324475787817f,
0.45508358712634389143f,-0.89867446569395392775f,0.43861623853852754751f,
-0.90659570451491533483f,0.42200027079979984812f,-0.91420975570353069095f,
0.40524131400498991651f,-0.92151403934204179080f,0.38834504669882657923f,
-0.92850608047321547822f,0.37131719395183770960f,-0.93518350993894761025f,
0.35416352542049039931f,-0.94154406518302069529f,0.33688985339222032867f,
-0.94758559101774109124f,0.31950203081601580291f,-0.95330604035419386211f,
0.30200594931922802866f,-0.95870347489587148804f,0.28440753721127209896f,
-0.96377606579543984022f,0.26671275747489847641f,-0.96852209427441737777f,
0.24892760574572009302f,-0.97293995220556006576f,0.23105810828067133156f,
-0.97702814265775439484f,0.21311031991609141745f,-0.98078528040323043058f,
0.19509032201612860891f,-0.98421009238692902521f,0.17700422041214894375f,
-0.98730141815785843473f,0.15885814333386147346f,-0.99005821026229701154f,
0.14065823933284954395f,-0.99247953459870996706f,0.12241067519921634832f,
-0.99456457073425541537f,0.10412163387205457254f,-0.99631261218277800129f,
0.08579731234444015753f,-0.99772306664419163624f,0.06744391956366417584f,
-0.99879545620517240501f,0.04906767432741796636f,-0.99952941750109314256f,
0.03067480317663686534f,-0.99992470183914450299f,0.01227153828572000692f,
-0.99998117528260110909f,-0.00613588464915455420f,-0.99969881869620424997f,
-0.02454122852291207996f,-0.99907772775264536147f,-0.04293825693494077861f,
-0.99811811290014917919f,-0.06132073630220824523f,-0.99682029929116577893f,
-0.07968243797142994522f,-0.99518472667219692873f,-0.09801714032956058975f,
-0.99321194923479461103f,-0.11631863091190447479f,-0.99090263542778000971f,
-0.13458070850712605671f,-0.98825756773074946437f,-0.15279718525844343535f,
-0.98527764238894133264f,-0.17096188876030096737f,-0.98196386910955524296f,
-0.18906866414980610935f,-0.97831737071962765473f,-0.20711137619221858808f,
-0.97433938278557585821f,-0.22508391135979261000f,-0.97003125319454397424f,
-0.24298017990326381543f,-0.96539444169768939830f,-0.26079411791527562503f,
-0.96043051941556589757f,-0.27851968938505289319f,-0.95514116830577078243f,
-0.29615088824362378883f,-0.94952818059303678577f,-0.31368174039889118454f,
-0.94359345816196038559f,-0.33110630575987626267f,-0.93733901191257495977f,
-0.34841868024943456472f,-0.93076696107898382326f,-0.36561299780477357624f,
-0.92387953251128684951f,-0.38268343236508967076f,-0.91667905992104270485f,
-0.39962419984564684361f,-0.90916798309052249127f,-0.41642956009763693048f,
-0.90134884704602202810f,-0.43309381885315184624f,-0.89322430119551532446f,
-0.44961132965460665067f,-0.88479709843093790056f,-0.46597649576796595916f,
-0.87607009419540660122f,-0.48218377207912266336f,-0.86704624551569287050f,
-0.49822766697278153547f,-0.85772861000027211809f,-0.51410274419322155026f,
-0.84812034480329723252f,-0.52980362468629460526f,-0.83822470555483818977f,
-0.54532498842204613076f,-0.82804504525775590729f,-0.56066157619733592021f,
-0.81758481315158371139f,-0.57580819141784533866f,-0.80684755354379944503f,
-0.59075970185887394237f,-0.79583690460888356633f,-0.60551104140432543410f,
-0.78455659715557524159f,-0.62005721176328920663f,-0.77301045336273710440f,
-0.63439328416364526575f,-0.76120238548426188974f,-0.64851440102211233008f,
-0.74913639452345925918f,-0.66241577759017178373f,-0.73681656887737001504f,
-0.67609270357531581208f,-0.72424708295146700276f,-0.68954054473706682948f,
-0.71143219574521665560f,-0.70275474445722507788f,-0.69837624940897302661f,
-0.71573082528381848366f,-0.68508366777270035541f,-0.72846439044822519637f,
-0.67155895484701866316f,-0.74095112535495888384f,-0.65780669329707874837f,
-0.75318679904361240940f,-0.64383154288979149715f,-0.76516726562245895860f,
-0.62963823891492687324f,-0.77688846567323255332f,-0.61523159058062726334f,
-0.78834642762660589455f,-0.60061647938386930612f,-0.79953726910790479110f,
-0.58579785745643908612f,-0.81045719825259465718f,-0.57078074588696736669f,
-0.82110251499110464835f,-0.55557023301960217765f,-0.83146961230254523567f,
-0.54017147272989274320f,-0.84155497743689855472f,-0.52458968267846928235f,
-0.85135519310526486247f,-0.50883014254310732216f,-0.86086693863776708735f,
-0.49289819222978420443f,-0.87008699110871134952f,-0.47679923006332214364f,
-0.87901222642863341417f,-0.46053871095823989412f,-0.88763962040285404598f,
-0.44412214457042975546f,-0.89596624975618488484f,-0.42755509343028247349f,
-0.90398929312344311615f,-0.41084317105790418845f,-0.91170603200542976730f,
-0.39399204006104820985f,-0.91911385169005765938f,-0.37700741021641820394f,
-0.92621024213831137928f,-0.35989503653498794433f,-0.93299279883473895669f,
-0.34266071731199487793f,-0.93945922360218969693f,-0.32531029216226331480f,
-0.94560732538052116869f,-0.30784964004153508865f,-0.95143502096900833820f,
-0.29028467725446244208f,-0.95694033573220882438f,-0.27262135544994886560f,
-0.96212140426904158019f,-0.25486565960451434965f,-0.96697647104485218161f,
-0.23702360599436766986f,-0.97150389098625167250f,-0.21910124015687010290f,
-0.97570213003852845901f,-0.20110463484209206708f,-0.97956976568544051887f,
-0.18303988795514095078f,-0.98310548743121628501f,-0.16491312048996975559f,
-0.98630809724459866938f,-0.14673047445536230304f,-0.98917650996478090342f,
-0.12849811079379358514f,-0.99170975366909952520f,-0.11022220729388330918f,
-0.99390697000235606051f,-0.09190895649713282101f,-0.99576741446765981713f,
-0.07356456359966735692f,-0.99729045667869020697f,-0.05519524434968971216f,
-0.99847558057329477421f,-0.03680722294135933131f,-0.99932238458834943273f,
-0.01840672990580516366f,-0.99983058179582340319f,1.00000000000000000000f,
0.00000000000000000000f,0.99729045667869020697f,0.07356456359966742631f,
0.98917650996478101444f,0.14673047445536174793f,0.97570213003852857003f,
0.21910124015686979759f,0.95694033573220882438f,0.29028467725446233105f,
0.93299279883473895669f,0.35989503653498811087f,0.90398929312344333820f,
0.42755509343028208491f,0.87008699110871146054f,0.49289819222978403790f,
0.83146961230254523567f,0.55557023301960217765f,0.78834642762660622761f,
0.61523159058062681925f,0.74095112535495921691f,0.67155895484701833009f,
0.68954054473706694051f,0.72424708295146689174f,0.63439328416364548779f,
0.77301045336273688235f,0.57580819141784533866f,0.81758481315158371139f,
0.51410274419322166128f,0.85772861000027211809f,0.44961132965460659516f,
0.89322430119551532446f,0.38268343236508983729f,0.92387953251128673848f,
0.31368174039889157312f,0.94952818059303667475f,0.24298017990326398197f,
0.97003125319454397424f,0.17096188876030135595f,0.98527764238894122162f,
0.09801714032956077016f,0.99518472667219681771f,0.02454122852291226384f,
0.99969881869620424997f,-0.04906767432741800800f,0.99879545620517240501f,
-0.12241067519921615403f,0.99247953459870996706f,-0.19509032201612819257f,
0.98078528040323043058f,-0.26671275747489830987f,0.96377606579543984022f,
-0.33688985339221994009f,0.94154406518302080631f,-0.40524131400498974998f,
0.91420975570353069095f,-0.47139673682599769755f,0.88192126434835504956f,
-0.53499761988709704230f,0.84485356524970722791f,-0.59569930449243335691f,
0.80320753148064494287f,-0.65317284295377653347f,0.75720884650648467851f,
-0.70710678118654746172f,0.70710678118654757274f,-0.75720884650648467851f,
0.65317284295377664449f,-0.80320753148064483184f,0.59569930449243346793f,
-0.84485356524970711689f,0.53499761988709715332f,-0.88192126434835493853f,
0.47139673682599780857f,-0.91420975570353069095f,0.40524131400498991651f,
-0.94154406518302069529f,0.33688985339222032867f,-0.96377606579543984022f,
0.26671275747489847641f,-0.98078528040323043058f,0.19509032201612860891f,
-0.99247953459870996706f,0.12241067519921634832f,-0.99879545620517240501f,
0.04906767432741796636f,-0.99969881869620424997f,-0.02454122852291207996f,
-0.99518472667219692873f,-0.09801714032956058975f,-0.98527764238894133264f,
-0.17096188876030096737f,-0.97003125319454397424f,-0.24298017990326381543f,
-0.94952818059303678577f,-0.31368174039889118454f,-0.92387953251128684951f,
-0.38268343236508967076f,-0.89322430119551532446f,-0.44961132965460665067f,
-0.85772861000027211809f,-0.51410274419322155026f,-0.81758481315158371139f,
-0.57580819141784533866f,-0.77301045336273710440f,-0.63439328416364526575f,
-0.72424708295146700276f,-0.68954054473706682948f,-0.67155895484701866316f,
-0.74095112535495888384f,-0.61523159058062726334f,-0.78834642762660589455f,
-0.55557023301960217765f,-0.83146961230254523567f,-0.49289819222978420443f,
-0.87008699110871134952f,-0.42755509343028247349f,-0.90398929312344311615f,
-0.35989503653498794433f,-0.93299279883473895669f,-0.29028467725446244208f,
-0.95694033573220882438f,-0.21910124015687010290f,-0.97570213003852845901f,
-0.14673047445536230304f,-0.98917650996478090342f,-0.07356456359966735692f,
-0.99729045667869020697f,1.00000000000000000000f,0.00000000000000000000f,
0.95694033573220882438f,0.29028467725446233105f,0.83146961230254523567f,
0.55557023301960217765f,0.63439328416364548779f,0.77301045336273688235f,
0.38268343236508983729f,0.92387953251128673848f,0.09801714032956077016f,
0.99518472667219681771f,-0.19509032201612819257f,0.98078528040323043058f,
-0.47139673682599769755f,0.88192126434835504956f,-0.70710678118654746172f,
0.70710678118654757274f,-0.88192126434835493853f,0.47139673682599780857f,
-0.98078528040323043058f,0.19509032201612860891f,-0.99518472667219692873f,
-0.09801714032956058975f,-0.92387953251128684951f,-0.38268343236508967076f,
-0.77301045336273710440f,-0.63439328416364526575f,-0.55557023301960217765f,
-0.83146961230254523567f,-0.29028467725446244208f,-0.95694033573220882438f,
1.00000000000000000000f,0.00000000000000000000f,0.38268343236508983729f,
0.92387953251128673848f,-0.70710678118654746172f,0.70710678118654757274f,
-0.92387953251128684951f,-0.38268343236508967076f,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F32_4096) || defined(ARM_TABLE_TWIDDLECOEF_F32_8192)

uint32_t rearranged_twiddle_tab_stride1_arr_4096_f32[6]={
0,2048,2560,2688,2720,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_4096_f32[6]={
0,2048,2560,2688,2720,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_4096_f32[6]={
0,2048,2560,2688,2720,0,};

float32_t rearranged_twiddle_stride1_4096_f32[2728]={
1.00000000000000000000f,0.00000000000000000000f,0.99999882345170187925f,
0.00153398018628476550f,0.99999529380957619118f,0.00306795676296597614f,
0.99998941108192840321f,0.00460192612044857050f,0.99998117528260110909f,
0.00613588464915447527f,0.99997058643097413988f,0.00766982873953109701f,
0.99995764455196389786f,0.00920375478205981944f,0.99994234967602391162f,
0.01073765916726449055f,0.99992470183914450299f,0.01227153828571992539f,
0.99990470108285289808f,0.01380538852806039059f,0.99988234745421256111f,
0.01533920628498810015f,0.99985764100582386060f,0.01687298794728171042f,
0.99983058179582340319f,0.01840672990580482019f,0.99980116988788425569f,
0.01994042855151444138f,0.99976940535121527898f,0.02147408027546950787f,
0.99973528826056168306f,0.02300768146883936868f,0.99969881869620424997f,
0.02454122852291228812f,0.99965999674395922270f,0.02607471782910390085f,
0.99961882249517863830f,0.02760814577896573974f,0.99957529604674921764f,
0.02914150876419372219f,0.99952941750109314256f,0.03067480317663662595f,
0.99948118696616694567f,0.03220802540830458582f,0.99943060455546173237f,
0.03374117185137757990f,0.99937767038800284780f,0.03527423889821394709f,
0.99932238458834954375f,0.03680722294135883171f,0.99926474728659442359f,
0.03834012037355269409f,0.99920475861836388631f,0.03987292758773981066f,
0.99914241872481690532f,0.04140564097707673946f,0.99907772775264536147f,
0.04293825693494082024f,0.99901068585407337697f,0.04447077185493866769f,
0.99894129318685687124f,0.04600318213091462299f,0.99886954991428356099f,
0.04753548415695930257f,0.99879545620517240501f,0.04906767432741801493f,
0.99871901223387293811f,0.05059974903689928166f,0.99864021818026527111f,
0.05213170468028332366f,0.99855907422975931365f,0.05366353765273051968f,
0.99847558057329477421f,0.05519524434968993420f,0.99838973740734016094f,
0.05672682116690774823f,0.99830154493389289261f,0.05825826450043575244f,
0.99821100336047818846f,0.05978957074663986820f,0.99811811290014917919f,
0.06132073630220857829f,0.99802287377148624081f,0.06285175756416140624f,
0.99792528619859599548f,0.06438263092985746505f,0.99782535041111164453f,
0.06591335279700380467f,0.99772306664419163624f,0.06744391956366405094f,
0.99761843513851955478f,0.06897432762826674613f,0.99751145614030345410f,
0.07050457338961385600f,0.99740212990127530279f,0.07203465324688933247f,
0.99729045667869020697f,0.07356456359966742631f,0.99717643673532618820f,
0.07509430084792130533f,0.99706007033948296225f,0.07662386139203149205f,
0.99694135776498216117f,0.07815324163279423197f,0.99682029929116566791f,
0.07968243797143012563f,0.99669689520289606044f,0.08121144680959244133f,
0.99657114579055483539f,0.08274026454937569164f,0.99644305135004263008f,
0.08426888759332407108f,0.99631261218277800129f,0.08579731234443989385f,
0.99617982859569698117f,0.08732553520619205922f,0.99604470090125196702f,
0.08885355258252460031f,0.99590722941741172125f,0.09038136087786498296f,
0.99576741446765981713f,0.09190895649713272386f,0.99562525638099430569f,
0.09343633584574778661f,0.99548075549192693856f,0.09496349532963899165f,
0.99533391214048227980f,0.09649043135525259274f,0.99518472667219692873f,
0.09801714032956060363f,0.99503319943811863180f,0.09954361866006931903f,
0.99487933079480561638f,0.10106986275482782167f,0.99472312110432570265f,
0.10259586902243628126f,0.99456457073425541537f,0.10412163387205458642f,
0.99440368005767909576f,0.10564715371341061589f,0.99424044945318790223f,
0.10717242495680884273f,0.99407487930487936634f,0.10869744401313871651f,
0.99390697000235606051f,0.11022220729388305938f,0.99373672194072459884f,
0.11174671121112658700f,0.99356413552059530403f,0.11327095217756434631f,
0.99338921114808065305f,0.11479492660651008373f,0.99321194923479450001f,
0.11631863091190475235f,0.99303235019785141002f,0.11784206150832497728f,
0.99285041445986510489f,0.11936521481099135467f,0.99266614244894801899f,
0.12088808723577708359f,0.99247953459870996706f,0.12241067519921619566f,
0.99229059134825736699f,0.12393297511851215920f,0.99209931314219179654f,
0.12545498341154623367f,0.99190570043060932726f,0.12697669649688586579f,
0.99170975366909952520f,0.12849811079379316880f,0.99151147331874389668f,
0.13001922272223334631f,0.99131085984611544415f,0.13154002870288311611f,
0.99110791372327688986f,0.13306052515713906459f,0.99090263542778000971f,
0.13458070850712616773f,0.99069502544266463406f,0.13610057517570620100f,
0.99048508425645709341f,0.13762012158648603832f,0.99027281236316910817f,
0.13913934416382620074f,0.99005821026229712256f,0.14065823933284921088f,
0.98984127845882052821f,0.14217680351944803063f,0.98962201746320088702f,
0.14369503315029447110f,0.98940042779138037687f,0.14521292465284746376f,
0.98917650996478101444f,0.14673047445536174793f,0.98895026451030298986f,
0.14824767898689603096f,0.98872169196032377858f,0.14976453467732150915f,
0.98849079285269658701f,0.15128103795733022219f,0.98825756773074946437f,
0.15279718525844343535f,0.98802201714328352633f,0.15431297301302010494f,
0.98778414164457217783f,0.15582839765426523271f,0.98754394179435922574f,
0.15734345561623824805f,0.98730141815785843473f,0.15885814333386144570f,
0.98705657130575097380f,0.16037245724292828464f,0.98680940181418552726f,
0.16188639378011182579f,0.98655991026477540817f,0.16339994938297322524f,
0.98630809724459866938f,0.16491312048996989437f,0.98605396334619543897f,
0.16642590354046410406f,0.98579750916756747614f,0.16793829497473117263f,
0.98553873531217606185f,0.16945029123396795900f,0.98527764238894122162f,
0.17096188876030121717f,0.98501423101223983814f,0.17247308399679595059f,
0.98474850180190420801f,0.17398387338746382214f,0.98448045538322093151f,
0.17549425337727142526f,0.98421009238692902521f,0.17700422041214874946f,
0.98393741344921892278f,0.17851377093899750692f,0.98366241921173025453f,
0.18002290140569951471f,0.98338511032155118130f,0.18153160826112496595f,
0.98310548743121628501f,0.18303988795514095078f,0.98282355119870523641f,
0.18454773693861961648f,0.98253930228744124076f,0.18605515166344663291f,
0.98225274136628937249f,0.18756212858252960252f,0.98196386910955524296f,
0.18906866414980619262f,0.98167268619698311305f,0.19057475482025273972f,
0.98137919331375456089f,0.19208039704989243734f,0.98108339115048670553f,
0.19358558729580360724f,0.98078528040323043058f,0.19509032201612824808f,
0.98048486177346938497f,0.19659459767008022335f,0.98018213596811742949f,
0.19809841071795356027f,0.97987710369951763756f,0.19960175762113097075f,
0.97956976568544051887f,0.20110463484209190055f,0.97926012264908202098f,
0.20260703884442113343f,0.97894817531906219710f,0.20410896609281686809f,
0.97863392442942320759f,0.20561041305309923910f,0.97831737071962765473f,
0.20711137619221856032f,0.97799851493455713936f,0.20861185197826348503f,
0.97767735782450992943f,0.21011183688046961016f,0.97735390014519996082f,
0.21161132736922755315f,0.97702814265775439484f,0.21311031991609136194f,
0.97670008612871184184f,0.21460881099378675829f,0.97636973133002114000f,
0.21610679707621952006f,0.97603707903903902388f,0.21760427463848364127f,
0.97570213003852857003f,0.21910124015686979759f,0.97536488511665697665f,
0.22059769010887350649f,0.97502534506699412020f,0.22209362097320350937f,
0.97468351068851066810f,0.22358902922978998729f,0.97433938278557585821f,
0.22508391135979283204f,0.97399296216795583359f,0.22657826384561000066f,
0.97364424965081197705f,0.22807208317088573102f,0.97329324605469824672f,
0.22956536582051886852f,0.97293995220556017678f,0.23105810828067110951f,
0.97258436893473221296f,0.23255030703877524467f,0.97222649707893626925f,
0.23404195858354343018f,0.97186633748027939639f,0.23553305940497548665f,
0.97150389098625178352f,0.23702360599436719801f,0.97113915844972509284f,
0.23851359484431841618f,0.97077214072895035013f,0.24000302244874149871f,
0.97040283868755550234f,0.24149188530286933019f,0.97003125319454397424f,
0.24298017990326387094f,0.96965738512429244800f,0.24446790274782415064f,
0.96928123535654853171f,0.24595505033579459497f,0.96890280477642887202f,
0.24744161916777326904f,0.96852209427441737777f,0.24892760574572014853f,
0.96813910474636244441f,0.25041300657296522436f,0.96775383709347551076f,
0.25189781815421696809f,0.96736629222232850545f,0.25338203699557015902f,
0.96697647104485207059f,0.25486565960451457169f,0.96658437447833311928f,
0.25634868248994291395f,0.96619000344541250413f,0.25783110216215898713f,
0.96579335887408368500f,0.25931291513288623474f,0.96539444169768939830f,
0.26079411791527551401f,0.96499325285492032478f,0.26227470702391358914f,
0.96458979328981275803f,0.26375467897483134694f,0.96418406395174582890f,
0.26523403028551179039f,0.96377606579543984022f,0.26671275747489836538f,
0.96336579978095404631f,0.26819085706340317632f,0.96295326687368387741f,
0.26966832557291509076f,0.96253846804435916340f,0.27114515952680801059f,
0.96212140426904158019f,0.27262135544994897662f,0.96170207652912254037f,
0.27409690986870638429f,0.96128048581132063966f,0.27557181931095814376f,
0.96085663310767965850f,0.27704608030609989555f,0.96043051941556578655f,
0.27851968938505305973f,0.96000214573766595727f,0.27999264308027321801f,
0.95957151308198451733f,0.28146493792575794091f,0.95913862246184189431f,
0.28293657045705539188f,0.95870347489587159906f,0.28440753721127187692f,
0.95826607140801767226f,0.28587783472708061527f,0.95782641302753290802f,
0.28734745954472951102f,0.95738450078897585627f,0.28881640820604947972f,
0.95694033573220882438f,0.29028467725446233105f,0.95649391890239510161f,
0.29175226323498926195f,0.95604525134999640557f,0.29321916269425862822f,
0.95559433413077110586f,0.29468537218051432669f,0.95514116830577078243f,
0.29615088824362378883f,0.95468575494133833814f,0.29761570743508619641f,
0.95422809510910566733f,0.29907982630804047508f,0.95376818988599032512f,
0.30054324141727345454f,0.95330604035419386211f,0.30200594931922808417f,
0.95284164760119871573f,0.30346794657201131562f,0.95237501271976587880f,
0.30492922973540237397f,0.95190613680793234597f,0.30638979537086091787f,
0.95143502096900833820f,0.30784964004153486661f,0.95096166631157508231f,
0.30930876031226872680f,0.95048607394948170235f,0.31076715274961147495f,
0.95000824500184299914f,0.31222481392182488413f,0.94952818059303667475f,
0.31368174039889151761f,0.94904588185270055689f,0.31513792875252244485f,
0.94856134991573026749f,0.31659337555616584581f,0.94807458592227622507f,
0.31804807738501494896f,0.94758559101774109124f,0.31950203081601569188f,
0.94709436635277721717f,0.32095523242787521445f,0.94660091308328353499f,
0.32240767880106985244f,0.94610523237040344835f,0.32385936651785285356f,
0.94560732538052127971f,0.32531029216226292622f,0.94510719328526060501f,
0.32676045232013173347f,0.94460483726148025685f,0.32820984357909249729f,
0.94410025849127265918f,0.32965846252858749255f,0.94359345816196038559f,
0.33110630575987642921f,0.94308443746609349478f,0.33255336986604422389f,
0.94257319760144686605f,0.33399965144200938205f,0.94205973977101731265f,
0.33544514708453160301f,0.94154406518302080631f,0.33688985339222005111f,
0.94102617505088925753f,0.33833376696554112728f,0.94050607059326829518f,
0.33977688440682685123f,0.93998375303401404679f,0.34121920232028235542f,
0.93945922360218991898f,0.34266071731199437833f,0.93893248353206459900f,
0.34410142598993881391f,0.93840353406310805795f,0.34554132496398909380f,
0.93787237643998988545f,0.34698041084592368133f,0.93733901191257495977f,
0.34841868024943456472f,0.93680344173592156043f,0.34985612979013491763f,
0.93626566717027825959f,0.35129275608556709276f,0.93572568948108036935f,
0.35272855575521072646f,0.93518350993894761025f,0.35416352542049034380f,
0.93463912981968078064f,0.35559766170478385172f,0.93409255040425887007f,
0.35703096123342997759f,0.93354377297883617270f,0.35846342063373654030f,
0.93299279883473895669f,0.35989503653498811087f,0.93243962926846235550f,
0.36132580556845428355f,0.93188426558166814750f,0.36275572436739722537f,
0.93132670908118042608f,0.36418478956707989180f,0.93076696107898371224f,
0.36561299780477385379f,0.93020502289221906889f,0.36704034571976718038f,
0.92964089584318121418f,0.36846682995337232125f,0.92907458125931585702f,
0.36989244714893410038f,0.92850608047321558924f,0.37131719395183754306f,
0.92793539482261788720f,0.37274106700951575855f,0.92736252565040111495f,
0.37416406297145793358f,0.92678747430458174872f,0.37558617848921721505f,
0.92621024213831137928f,0.37700741021641825945f,0.92563083050987271516f,
0.37842775480876555960f,0.92504924078267758425f,0.37984720892405116066f,
0.92446547432526260391f,0.38126576922216237620f,0.92387953251128673848f,
0.38268343236508978178f,0.92329141671952763559f,0.38410019501693504207f,
0.92270112833387862850f,0.38551605384391884890f,0.92210866874334518339f,
0.38693100551438858181f,0.92151403934204190183f,0.38834504669882624617f,
0.92091724152918941204f,0.38975817406985641123f,0.92031827670911059425f,
0.39117038430225387069f,0.91971714629122736095f,0.39258167407295146978f,
0.91911385169005777040f,0.39399204006104809883f,0.91850839432521225181f,
0.39540147894781635385f,0.91790077562139049672f,0.39680998741671030805f,
0.91729099700837790632f,0.39821756215337356100f,0.91667905992104270485f,
0.39962419984564678810f,0.91606496579933172075f,0.40102989718357562321f,
0.91544871608826783316f,0.40243465085941843018f,0.91483031223794619713f,
0.40383845756765407442f,0.91420975570353069095f,0.40524131400498986100f,
0.91358704794525080750f,0.40664321687036902864f,0.91296219042839821256f,
0.40804416286497868782f,0.91233518462332274801f,0.40944414869225759235f,
0.91170603200542987832f,0.41084317105790391089f,0.91107473405517636067f,
0.41224122666988288755f,0.91044129225806724737f,0.41363831223843450235f,
0.90980570810465222209f,0.41503442447608163146f,0.90916798309052238025f,
0.41642956009763715253f,0.90852811871630612117f,0.41782371582021227141f,
0.90788611648766626150f,0.41921688836322390515f,0.90724197791529581636f,
0.42060907444840250902f,0.90659570451491533483f,0.42200027079979968159f,
0.90594729780726845902f,0.42339047414379604728f,0.90529675931811881551f,
0.42477968120910880589f,0.90464409057824624050f,0.42616788872679961520f,
0.90398929312344333820f,0.42755509343028208491f,0.90333236849451181705f,
0.42894129205532949278f,0.90267331823725882600f,0.43032648134008261165f,
0.90201214390249317976f,0.43171065802505725895f,0.90134884704602202810f,
0.43309381885315195726f,0.90068342922864685907f,0.43447596056965565037f,
0.90001589201616016833f,0.43585707992225547480f,0.89934623697934157338f,
0.43723717366104408732f,0.89867446569395381673f,0.43861623853852765853f,
0.89800057974073987932f,0.43999427130963325583f,0.89732458070541831763f,
0.44137126873171667052f,0.89664647017868015499f,0.44274722756457002282f,
0.89596624975618521791f,0.44412214457042920035f,0.89528392103855758410f,
0.44549601651398174074f,0.89459948563138269595f,0.44686884016237415906f,
0.89391294514520325265f,0.44824061228521988598f,0.89322430119551532446f,
0.44961132965460653965f,0.89253355540276457791f,0.45098098904510386387f,
0.89184070939234272313f,0.45234958723377088896f,0.89114576479458318392f,
0.45371712100016386993f,0.89044872324475787817f,0.45508358712634383592f,
0.88974958638307277692f,0.45644898239688391772f,0.88904835585466457371f,
0.45781330359887717485f,0.88834503330959635470f,0.45917654752194408951f,
0.88763962040285393496f,0.46053871095824000514f,0.88693211879434219469f,
0.46189979070246273141f,0.88622253014888063838f,0.46325978355186014923f,
0.88551085613619995307f,0.46461868630623781584f,0.88479709843093778954f,
0.46597649576796618121f,0.88408125871263498752f,0.46733320874198841510f,
0.88336333866573157891f,0.46868882203582790114f,0.88264333997956279099f,
0.47004333245959561971f,0.88192126434835504956f,0.47139673682599764204f,
0.88119711347122209322f,0.47274903195034279069f,0.88047088905216075450f,
0.47410021465054996703f,0.87974259280004740713f,0.47545028174715586733f,
0.87901222642863352519f,0.47679923006332208812f,0.87827979165654157523f,
0.47814705642484300885f,0.87754529020726135258f,0.47949375766015295275f,
0.87680872380914565145f,0.48083933060033395845f,0.87607009419540660122f,
0.48218377207912271887f,0.87532940310411089246f,0.48352707893291868579f,
0.87458665227817611321f,0.48486924800079106435f,0.87384184346536686316f,
0.48621027612448641797f,0.87309497841829009079f,0.48755016014843599592f,
0.87234605889439154058f,0.48888889691976317176f,0.87159508665595097909f,
0.49022648328829115938f,0.87084206347007897531f,0.49156291610654989643f,
0.87008699110871146054f,0.49289819222978403790f,0.86932987134860684186f,
0.49423230851595967295f,0.86857070597134089507f,0.49556526182577254058f,
0.86780949676330332299f,0.49689704902265446895f,0.86704624551569264845f,
0.49822766697278181303f,0.86628095402451299467f,0.49955711254508183838f,
0.86551362409056908920f,0.50088538261124071482f,0.86474425751946237817f,
0.50221247404571078832f,0.86397285612158669643f,0.50353838372571757542f,
0.86319942171212415971f,0.50486310853126759035f,0.86242395611104050168f,
0.50618664534515522835f,0.86164646114308129921f,0.50750899105297087033f,
0.86086693863776730939f,0.50883014254310698909f,0.86008539042939013974f,
0.51015009670676680908f,0.85930181835700847337f,0.51146885043797030157f,
0.85851622426444273994f,0.51278640063356295542f,0.85772861000027211809f,
0.51410274419322166128f,0.85693897741782876221f,0.51541787801946292724f,
0.85614732837519447184f,0.51673179901764987321f,0.85535366473519602870f,
0.51804450409599933636f,0.85455798836540053376f,0.51935599016558964269f,
0.85376030113811141042f,0.52066625414036715735f,0.85296060493036363059f,
0.52197529293715438925f,0.85215890162391982887f,0.52328310347565643035f,
0.85135519310526519554f,0.52458968267846894928f,0.85054948126560347976f,
0.52589502747108463065f,0.84974176800085254868f,0.52719913478190127964f,
0.84893205521163961347f,0.52850200154222848337f,0.84812034480329723252f,
0.52980362468629460526f,0.84730663868585831544f,0.53110400115125500076f,
0.84649093877405212627f,0.53240312787719790144f,0.84567324698729906540f,
0.53370100180715296379f,0.84485356524970711689f,0.53499761988709715332f,
0.84403189549006640835f,0.53629297906596318235f,0.84320823964184543620f,
0.53758707629564539410f,0.84238259964318584760f,0.53887990853100842248f,
0.84155497743689844370f,0.54017147272989285423f,0.84072537497045807253f,
0.54146176585312344454f,0.83989379419599952126f,0.54275078486451588944f,
0.83906023707031274217f,0.54403852673088382019f,0.83822470555483807875f,
0.54532498842204646383f,0.83738720161566193578f,0.54661016691083486041f,
0.83654772722351200542f,0.54789405917310018967f,0.83570628435375260423f,
0.54917666218771965525f,0.83486287498638001026f,0.55045797293660481131f,
0.83401750110601813315f,0.55173798840470733573f,0.83317016470191318511f,
0.55301670558002746780f,0.83232086776792968408f,0.55429412145362000341f,
0.83146961230254523567f,0.55557023301960217765f,0.83061640030884631436f,
0.55684503727516010407f,0.82976123379452304540f,0.55811853122055610221f,
0.82890411477186487499f,0.55939071185913613604f,0.82804504525775579626f,
0.56066157619733603124f,0.82718402727366913130f,0.56193112124468935775f,
0.82632106284566353427f,0.56319934401383409117f,0.82545615400437755138f,
0.56446624152051938506f,0.82458930278502529099f,0.56573181078361312046f,
0.82372051122739142759f,0.56699604882510867832f,0.82284978137582642788f,
0.56825895267013148970f,0.82197711527924155472f,0.56952051934694714053f,
0.82110251499110464835f,0.57078074588696725566f,0.82022598256943468620f,
0.57203962932475704850f,0.81934752007679700903f,0.57329716669804220430f,
0.81846712958029865792f,0.57455335504771576360f,0.81758481315158371139f,
0.57580819141784533866f,0.81670057286682784525f,0.57706167285567944170f,
0.81581441080673378075f,0.57831379641165558958f,0.81492632905652662156f,
0.57956455913940563285f,0.81403632970594841378f,0.58081395809576452649f,
0.81314441484925359394f,0.58206199034077543697f,0.81225058658520399302f,
0.58330865293769829094f,0.81135484701706372945f,0.58455394295301532637f,
0.81045719825259476821f,0.58579785745643886408f,0.80955764240405125864f,
0.58704039352091796911f,0.80865618158817498262f,0.58828154822264522306f,
0.80775281792619035848f,0.58952131864106394055f,0.80684755354379933401f,
0.59075970185887416442f,0.80594039057117627944f,0.59199669496204099239f,
0.80503133114296365758f,0.59323229503979979516f,0.80412037739826569549f,
0.59446649918466443197f,0.80320753148064494287f,0.59569930449243335691f,
0.80229279553811572168f,0.59693070806219639124f,0.80137617172314024039f,
0.59816070699634238395f,0.80045766219262282082f,0.59938929840056454079f,
0.79953726910790501314f,0.60061647938386897305f,0.79861499463476093297f,
0.60184224705858002658f,0.79769084094339115509f,0.60306659854034816437f,
0.79676481020841882774f,0.60428953094815596181f,0.79583690460888356633f,
0.60551104140432554512f,0.79490712632823701256f,0.60673112703452447558f,
0.79397547755433717231f,0.60794978496777363208f,0.79304196047944364167f,
0.60916701233645320634f,0.79210657730021238887f,0.61038280627630947528f,
0.79116933021769020318f,0.61159716392646190641f,0.79023022143731003197f,
0.61281008242940970820f,0.78928925316888565167f,0.61402155893103849138f,
0.78834642762660622761f,0.61523159058062681925f,0.78740174702903142911f,
0.61644017453085364622f,0.78645521359908576731f,0.61764730793780386886f,
0.78550682956405393220f,0.61885298796097631957f,0.78455659715557524159f,
0.62005721176328909561f,0.78360451860963820092f,0.62125997651108755271f,
0.78265059616657572938f,0.62246127937414996723f,0.78169483207105938671f,
0.62366111752569453053f,0.78073722857209448822f,0.62485948814238634341f,
0.77977778792301455368f,0.62605638840434352232f,0.77881651238147597827f,
0.62725181549514408275f,0.77785340420945314754f,0.62844576660183271155f,
0.77688846567323244230f,0.62963823891492698426f,0.77592169904340768660f,
0.63082922962842447046f,0.77495310659487393057f,0.63201873593980906207f,
0.77398269060682289844f,0.63320675505005719064f,0.77301045336273699338f,
0.63439328416364548779f,0.77203639715038452351f,0.63557832048855611440f,
0.77106052426181381776f,0.63676186123628419899f,0.77008283699334789674f,
0.63794390362184405507f,0.76910333764557969882f,0.63912444486377573138f,
0.76812202852336541881f,0.64030348218415167327f,0.76713891193582040007f,
0.64148101280858305095f,0.76615399019631291733f,0.64265703396622686494f,
0.76516726562245895860f,0.64383154288979138613f,0.76417874053611667406f,
0.64500453681554392737f,0.76318841726338138010f,0.64617601298331628357f,
0.76219629813457900891f,0.64734596863651205911f,0.76120238548426177871f,
0.64851440102211244110f,0.76020668165120242055f,0.64968130739068319368f,
0.75920918897838796102f,0.65084668499638087535f,0.75820990981301528144f,
0.65201053109695950027f,0.75720884650648456748f,0.65317284295377675551f,
0.75620600141439453523f,0.65433361783180044036f,0.75520137689653654700f,
0.65549285299961534967f,0.75419497531688917125f,0.65665054572942893607f,
0.75318679904361252042f,0.65780669329707863735f,0.75217685044904269986f,
0.65896129298203731661f,0.75116513190968636771f,0.66011434206742047870f,
0.75015164580621507273f,0.66126583783999226540f,0.74913639452345937020f,
0.66241577759017178373f,0.74811938045040360379f,0.66356415861203976725f,
0.74710060598018013245f,0.66471097820334479334f,0.74608007351006377927f,
0.66585623366550972246f,0.74505778544146594733f,0.66699992230363747137f,
0.74403374417992929057f,0.66814204142651845153f,0.74300795213512171866f,
0.66928258834663600929f,0.74198041172083106787f,0.67042156038017308717f,
0.74095112535495921691f,0.67155895484701833009f,0.73992009545951620275f,
0.67269476907077285777f,0.73888732446061511361f,0.67382900037875603783f,
0.73785281478846598269f,0.67496164610201192513f,0.73681656887736979300f,
0.67609270357531592310f,0.73577858916571359238f,0.67722217013718033485f,
0.73473887809596349907f,0.67835004312986146857f,0.73369743811466026084f,
0.67947631989936496666f,0.73265427167241281570f,0.68060099779545302212f,
0.73160938122389262972f,0.68172407417164970767f,0.73056276922782759087f,
0.68284554638524808112f,0.72951443814699701296f,0.68396541179731540350f,
0.72846439044822519637f,0.68508366777270035541f,0.72741262860237576593f,
0.68620031168003858824f,0.72635915508434600873f,0.68731534089175905233f,
0.72530397237306076796f,0.68842875278409043638f,0.72424708295146700276f,
0.68954054473706682948f,0.72318848930652745999f,0.69065071413453460458f,
0.72212819392921534511f,0.69175925836415774750f,0.72106619931450810501f,
0.69286617481742462932f,0.72000250796138165477f,0.69397146088965389055f,
0.71893712237280449351f,0.69507511398000088043f,0.71787004505573170920f,
0.69617713149146298601f,0.71680127852109953857f,0.69727751083088651551f,
0.71573082528381870571f,0.69837624940897280457f,0.71465868786276909308f,
0.69947334464028376733f,0.71358486878079352422f,0.70056879394324833576f,
0.71250937056469243469f,0.70166259474016845488f,0.71143219574521643356f,
0.70275474445722529993f,0.71035334685706241764f,0.70384524052448493858f,
0.70927282643886568891f,0.70493408037590488124f,0.70819063703319540259f,
0.70602126144933974317f,0.70710678118654757274f,0.70710678118654757274f,
0.70602126144933974317f,0.70819063703319540259f,0.70493408037590499227f,
0.70927282643886568891f,0.70384524052448493858f,0.71035334685706241764f,
0.70275474445722529993f,0.71143219574521643356f,0.70166259474016845488f,
0.71250937056469232367f,0.70056879394324844679f,0.71358486878079352422f,
0.69947334464028376733f,0.71465868786276909308f,0.69837624940897291559f,
0.71573082528381859468f,0.69727751083088662654f,0.71680127852109942754f,
0.69617713149146298601f,0.71787004505573170920f,0.69507511398000088043f,
0.71893712237280438249f,0.69397146088965400157f,0.72000250796138165477f,
0.69286617481742474034f,0.72106619931450810501f,0.69175925836415774750f,
0.72212819392921534511f,0.69065071413453460458f,0.72318848930652734897f,
0.68954054473706694051f,0.72424708295146689174f,0.68842875278409043638f,
0.72530397237306076796f,0.68731534089175905233f,0.72635915508434600873f,
0.68620031168003858824f,0.72741262860237576593f,0.68508366777270035541f,
0.72846439044822519637f,0.68396541179731551452f,0.72951443814699690193f,
0.68284554638524808112f,0.73056276922782759087f,0.68172407417164981869f,
0.73160938122389262972f,0.68060099779545302212f,0.73265427167241281570f,
0.67947631989936496666f,0.73369743811466026084f,0.67835004312986146857f,
0.73473887809596349907f,0.67722217013718044587f,0.73577858916571348136f,
0.67609270357531603413f,0.73681656887736979300f,0.67496164610201203615f,
0.73785281478846598269f,0.67382900037875614885f,0.73888732446061511361f,
0.67269476907077296879f,0.73992009545951609173f,0.67155895484701833009f,
0.74095112535495910588f,0.67042156038017308717f,0.74198041172083095685f,
0.66928258834663600929f,0.74300795213512171866f,0.66814204142651856255f,
0.74403374417992929057f,0.66699992230363747137f,0.74505778544146594733f,
0.66585623366550972246f,0.74608007351006366825f,0.66471097820334490436f,
0.74710060598018013245f,0.66356415861203987827f,0.74811938045040349277f,
0.66241577759017178373f,0.74913639452345925918f,0.66126583783999226540f,
0.75015164580621496171f,0.66011434206742047870f,0.75116513190968636771f,
0.65896129298203731661f,0.75217685044904269986f,0.65780669329707874837f,
0.75318679904361252042f,0.65665054572942904709f,0.75419497531688917125f,
0.65549285299961546070f,0.75520137689653654700f,0.65433361783180055138f,
0.75620600141439453523f,0.65317284295377686654f,0.75720884650648456748f,
0.65201053109695950027f,0.75820990981301528144f,0.65084668499638098638f,
0.75920918897838796102f,0.64968130739068319368f,0.76020668165120242055f,
0.64851440102211255212f,0.76120238548426177871f,0.64734596863651205911f,
0.76219629813457889789f,0.64617601298331639459f,0.76318841726338126907f,
0.64500453681554403840f,0.76417874053611667406f,0.64383154288979149715f,
0.76516726562245895860f,0.64265703396622686494f,0.76615399019631280630f,
0.64148101280858316198f,0.76713891193582040007f,0.64030348218415167327f,
0.76812202852336530778f,0.63912444486377573138f,0.76910333764557958780f,
0.63794390362184416610f,0.77008283699334789674f,0.63676186123628419899f,
0.77106052426181381776f,0.63557832048855622542f,0.77203639715038441249f,
0.63439328416364548779f,0.77301045336273688235f,0.63320675505005719064f,
0.77398269060682278742f,0.63201873593980906207f,0.77495310659487381955f,
0.63082922962842458148f,0.77592169904340757558f,0.62963823891492709528f,
0.77688846567323244230f,0.62844576660183271155f,0.77785340420945303652f,
0.62725181549514419377f,0.77881651238147586724f,0.62605638840434352232f,
0.77977778792301444266f,0.62485948814238645443f,0.78073722857209448822f,
0.62366111752569464155f,0.78169483207105938671f,0.62246127937415007825f,
0.78265059616657572938f,0.62125997651108766373f,0.78360451860963820092f,
0.62005721176328920663f,0.78455659715557524159f,0.61885298796097631957f,
0.78550682956405393220f,0.61764730793780397988f,0.78645521359908576731f,
0.61644017453085364622f,0.78740174702903131809f,0.61523159058062681925f,
0.78834642762660622761f,0.61402155893103849138f,0.78928925316888565167f,
0.61281008242940970820f,0.79023022143731003197f,0.61159716392646201744f,
0.79116933021769009216f,0.61038280627630947528f,0.79210657730021227785f,
0.60916701233645320634f,0.79304196047944364167f,0.60794978496777374311f,
0.79397547755433717231f,0.60673112703452447558f,0.79490712632823701256f,
0.60551104140432554512f,0.79583690460888345530f,0.60428953094815607283f,
0.79676481020841871672f,0.60306659854034827539f,0.79769084094339104407f,
0.60184224705858002658f,0.79861499463476082195f,0.60061647938386897305f,
0.79953726910790501314f,0.59938929840056454079f,0.80045766219262270980f,
0.59816070699634238395f,0.80137617172314012937f,0.59693070806219650226f,
0.80229279553811572168f,0.59569930449243346793f,0.80320753148064483184f,
0.59446649918466454299f,0.80412037739826569549f,0.59323229503979979516f,
0.80503133114296365758f,0.59199669496204099239f,0.80594039057117627944f,
0.59075970185887427544f,0.80684755354379922299f,0.58952131864106394055f,
0.80775281792619024746f,0.58828154822264533408f,0.80865618158817498262f,
0.58704039352091808013f,0.80955764240405125864f,0.58579785745643886408f,
0.81045719825259476821f,0.58455394295301532637f,0.81135484701706372945f,
0.58330865293769829094f,0.81225058658520388200f,0.58206199034077554799f,
0.81314441484925359394f,0.58081395809576452649f,0.81403632970594830276f,
0.57956455913940574387f,0.81492632905652662156f,0.57831379641165558958f,
0.81581441080673378075f,0.57706167285567955272f,0.81670057286682784525f,
0.57580819141784533866f,0.81758481315158371139f,0.57455335504771576360f,
0.81846712958029865792f,0.57329716669804231532f,0.81934752007679689800f,
0.57203962932475704850f,0.82022598256943468620f,0.57078074588696736669f,
0.82110251499110464835f,0.56952051934694725155f,0.82197711527924155472f,
0.56825895267013148970f,0.82284978137582631685f,0.56699604882510867832f,
0.82372051122739131657f,0.56573181078361323149f,0.82458930278502529099f,
0.56446624152051949608f,0.82545615400437744036f,0.56319934401383409117f,
0.82632106284566353427f,0.56193112124468946877f,0.82718402727366913130f,
0.56066157619733603124f,0.82804504525775579626f,0.55939071185913613604f,
0.82890411477186487499f,0.55811853122055610221f,0.82976123379452304540f,
0.55684503727516010407f,0.83061640030884620334f,0.55557023301960228867f,
0.83146961230254523567f,0.55429412145362011444f,0.83232086776792968408f,
0.55301670558002757883f,0.83317016470191318511f,0.55173798840470744675f,
0.83401750110601813315f,0.55045797293660481131f,0.83486287498638001026f,
0.54917666218771976627f,0.83570628435375260423f,0.54789405917310018967f,
0.83654772722351189440f,0.54661016691083486041f,0.83738720161566193578f,
0.54532498842204646383f,0.83822470555483796772f,0.54403852673088393122f,
0.83906023707031263115f,0.54275078486451600046f,0.83989379419599941023f,
0.54146176585312355556f,0.84072537497045796151f,0.54017147272989296525f,
0.84155497743689833268f,0.53887990853100842248f,0.84238259964318584760f,
0.53758707629564550512f,0.84320823964184543620f,0.53629297906596318235f,
0.84403189549006640835f,0.53499761988709726435f,0.84485356524970700587f,
0.53370100180715296379f,0.84567324698729906540f,0.53240312787719801246f,
0.84649093877405212627f,0.53110400115125500076f,0.84730663868585831544f,
0.52980362468629482731f,0.84812034480329712149f,0.52850200154222848337f,
0.84893205521163961347f,0.52719913478190139067f,0.84974176800085243766f,
0.52589502747108474168f,0.85054948126560336874f,0.52458968267846883826f,
0.85135519310526519554f,0.52328310347565643035f,0.85215890162391982887f,
0.52197529293715438925f,0.85296060493036363059f,0.52066625414036726838f,
0.85376030113811129940f,0.51935599016558953167f,0.85455798836540053376f,
0.51804450409599933636f,0.85535366473519602870f,0.51673179901764998423f,
0.85614732837519447184f,0.51541787801946314929f,0.85693897741782865118f,
0.51410274419322166128f,0.85772861000027211809f,0.51278640063356306644f,
0.85851622426444273994f,0.51146885043797052361f,0.85930181835700836235f,
0.51015009670676669806f,0.86008539042939025077f,0.50883014254310698909f,
0.86086693863776730939f,0.50750899105297087033f,0.86164646114308129921f,
0.50618664534515533937f,0.86242395611104050168f,0.50486310853126747933f,
0.86319942171212415971f,0.50353838372571757542f,0.86397285612158669643f,
0.50221247404571089934f,0.86474425751946237817f,0.50088538261124093687f,
0.86551362409056897818f,0.49955711254508183838f,0.86628095402451299467f,
0.49822766697278186854f,0.86704624551569264845f,0.49689704902265463549f,
0.86780949676330321196f,0.49556526182577248507f,0.86857070597134089507f,
0.49423230851595972846f,0.86932987134860673084f,0.49289819222978409341f,
0.87008699110871134952f,0.49156291610655006297f,0.87084206347007886428f,
0.49022648328829110387f,0.87159508665595109012f,0.48888889691976322727f,
0.87234605889439142956f,0.48755016014843605143f,0.87309497841829009079f,
0.48621027612448652899f,0.87384184346536675214f,0.48486924800079111986f,
0.87458665227817611321f,0.48352707893291874131f,0.87532940310411078144f,
0.48218377207912282989f,0.87607009419540660122f,0.48083933060033390294f,
0.87680872380914576247f,0.47949375766015300826f,0.87754529020726124156f,
0.47814705642484311987f,0.87827979165654146421f,0.47679923006332225466f,
0.87901222642863341417f,0.47545028174715586733f,0.87974259280004740713f,
0.47410021465055002254f,0.88047088905216075450f,0.47274903195034290171f,
0.88119711347122198219f,0.47139673682599780857f,0.88192126434835493853f,
0.47004333245959561971f,0.88264333997956279099f,0.46868882203582795665f,
0.88336333866573157891f,0.46733320874198852612f,0.88408125871263498752f,
0.46597649576796612569f,0.88479709843093778954f,0.46461868630623781584f,
0.88551085613619995307f,0.46325978355186026025f,0.88622253014888063838f,
0.46189979070246284243f,0.88693211879434208367f,0.46053871095824000514f,
0.88763962040285393496f,0.45917654752194414502f,0.88834503330959635470f,
0.45781330359887728587f,0.88904835585466457371f,0.45644898239688386221f,
0.88974958638307288794f,0.45508358712634383592f,0.89044872324475787817f,
0.45371712100016392544f,0.89114576479458318392f,0.45234958723377099998f,
0.89184070939234272313f,0.45098098904510380835f,0.89253355540276468894f,
0.44961132965460659516f,0.89322430119551532446f,0.44824061228521999700f,
0.89391294514520325265f,0.44686884016237432560f,0.89459948563138258493f,
0.44549601651398174074f,0.89528392103855758410f,0.44412214457042925586f,
0.89596624975618510689f,0.44274722756457013384f,0.89664647017868015499f,
0.44137126873171661501f,0.89732458070541831763f,0.43999427130963325583f,
0.89800057974073987932f,0.43861623853852771404f,0.89867446569395381673f,
0.43723717366104419835f,0.89934623697934146236f,0.43585707992225547480f,
0.90001589201616027935f,0.43447596056965570588f,0.90068342922864685907f,
0.43309381885315201277f,0.90134884704602202810f,0.43171065802505736997f,
0.90201214390249306874f,0.43032648134008261165f,0.90267331823725882600f,
0.42894129205532954829f,0.90333236849451181705f,0.42755509343028219593f,
0.90398929312344333820f,0.42616788872679961520f,0.90464409057824624050f,
0.42477968120910880589f,0.90529675931811881551f,0.42339047414379610279f,
0.90594729780726845902f,0.42200027079979979261f,0.90659570451491533483f,
0.42060907444840250902f,0.90724197791529592738f,0.41921688836322396066f,
0.90788611648766626150f,0.41782371582021238243f,0.90852811871630612117f,
0.41642956009763731906f,0.90916798309052226923f,0.41503442447608163146f,
0.90980570810465222209f,0.41363831223843455787f,0.91044129225806713634f,
0.41224122666988299857f,0.91107473405517624965f,0.41084317105790391089f,
0.91170603200542987832f,0.40944414869225764786f,0.91233518462332274801f,
0.40804416286497874333f,0.91296219042839810154f,0.40664321687036913966f,
0.91358704794525080750f,0.40524131400498986100f,0.91420975570353069095f,
0.40383845756765412993f,0.91483031223794608611f,0.40243465085941854120f,
0.91544871608826783316f,0.40102989718357578974f,0.91606496579933160973f,
0.39962419984564678810f,0.91667905992104270485f,0.39821756215337361651f,
0.91729099700837790632f,0.39680998741671041907f,0.91790077562139038569f,
0.39540147894781629834f,0.91850839432521225181f,0.39399204006104809883f,
0.91911385169005777040f,0.39258167407295152529f,0.91971714629122736095f,
0.39117038430225398171f,0.92031827670911048322f,0.38975817406985641123f,
0.92091724152918941204f,0.38834504669882630168f,0.92151403934204190183f,
0.38693100551438869283f,0.92210866874334507237f,0.38551605384391901543f,
0.92270112833387851747f,0.38410019501693504207f,0.92329141671952763559f,
0.38268343236508983729f,0.92387953251128673848f,0.38126576922216248722f,
0.92446547432526260391f,0.37984720892405110515f,0.92504924078267758425f,
0.37842775480876561511f,0.92563083050987271516f,0.37700741021641831496f,
0.92621024213831126826f,0.37558617848921732607f,0.92678747430458174872f,
0.37416406297145798909f,0.92736252565040111495f,0.37274106700951581406f,
0.92793539482261788720f,0.37131719395183759858f,0.92850608047321558924f,
0.36989244714893426691f,0.92907458125931574600f,0.36846682995337232125f,
0.92964089584318121418f,0.36704034571976723589f,0.93020502289221906889f,
0.36561299780477396482f,0.93076696107898371224f,0.36418478956707983629f,
0.93132670908118042608f,0.36275572436739722537f,0.93188426558166814750f,
0.36132580556845433906f,0.93243962926846235550f,0.35989503653498827740f,
0.93299279883473884567f,0.35846342063373654030f,0.93354377297883617270f,
0.35703096123343003310f,0.93409255040425887007f,0.35559766170478396274f,
0.93463912981968078064f,0.35416352542049051033f,0.93518350993894749923f,
0.35272855575521072646f,0.93572568948108036935f,0.35129275608556714827f,
0.93626566717027825959f,0.34985612979013502866f,0.93680344173592156043f,
0.34841868024943450921f,0.93733901191257495977f,0.34698041084592368133f,
0.93787237643998988545f,0.34554132496398914931f,0.93840353406310805795f,
0.34410142598993898044f,0.93893248353206448797f,0.34266071731199437833f,
0.93945922360218991898f,0.34121920232028241093f,0.93998375303401393577f,
0.33977688440682696225f,0.94050607059326829518f,0.33833376696554129381f,
0.94102617505088925753f,0.33688985339222005111f,0.94154406518302080631f,
0.33544514708453165852f,0.94205973977101731265f,0.33399965144200949307f,
0.94257319760144686605f,0.33255336986604422389f,0.94308443746609349478f,
0.33110630575987642921f,0.94359345816196038559f,0.32965846252858754806f,
0.94410025849127265918f,0.32820984357909266382f,0.94460483726148025685f,
0.32676045232013178898f,0.94510719328526060501f,0.32531029216226298173f,
0.94560732538052127971f,0.32385936651785296458f,0.94610523237040333733f,
0.32240767880107001897f,0.94660091308328353499f,0.32095523242787521445f,
0.94709436635277721717f,0.31950203081601574739f,0.94758559101774109124f,
0.31804807738501505998f,0.94807458592227622507f,0.31659337555616584581f,
0.94856134991573026749f,0.31513792875252244485f,0.94904588185270055689f,
0.31368174039889157312f,0.94952818059303667475f,0.31222481392182505067f,
0.95000824500184299914f,0.31076715274961147495f,0.95048607394948170235f,
0.30930876031226878231f,0.95096166631157508231f,0.30784964004153497763f,
0.95143502096900833820f,0.30638979537086108440f,0.95190613680793223494f,
0.30492922973540242948f,0.95237501271976587880f,0.30346794657201137113f,
0.95284164760119871573f,0.30200594931922819519f,0.95330604035419375109f,
0.30054324141727339903f,0.95376818988599032512f,0.29907982630804047508f,
0.95422809510910566733f,0.29761570743508630743f,0.95468575494133833814f,
0.29615088824362395536f,0.95514116830577067141f,0.29468537218051432669f,
0.95559433413077110586f,0.29321916269425868373f,0.95604525134999640557f,
0.29175226323498937298f,0.95649391890239499059f,0.29028467725446233105f,
0.95694033573220893540f,0.28881640820604947972f,0.95738450078897585627f,
0.28734745954472956653f,0.95782641302753290802f,0.28587783472708072630f,
0.95826607140801767226f,0.28440753721127182141f,0.95870347489587159906f,
0.28293657045705539188f,0.95913862246184189431f,0.28146493792575805193f,
0.95957151308198451733f,0.27999264308027338455f,0.96000214573766584625f,
0.27851968938505305973f,0.96043051941556578655f,0.27704608030609995106f,
0.96085663310767965850f,0.27557181931095825478f,0.96128048581132063966f,
0.27409690986870632878f,0.96170207652912254037f,0.27262135544994897662f,
0.96212140426904158019f,0.27114515952680806610f,0.96253846804435916340f,
0.26966832557291520178f,0.96295326687368387741f,0.26819085706340317632f,
0.96336579978095404631f,0.26671275747489842090f,0.96377606579543984022f,
0.26523403028551190141f,0.96418406395174571788f,0.26375467897483151347f,
0.96458979328981264700f,0.26227470702391358914f,0.96499325285492032478f,
0.26079411791527556952f,0.96539444169768939830f,0.25931291513288634576f,
0.96579335887408357397f,0.25783110216215893162f,0.96619000344541261516f,
0.25634868248994291395f,0.96658437447833311928f,0.25486565960451462720f,
0.96697647104485207059f,0.25338203699557027004f,0.96736629222232850545f,
0.25189781815421691258f,0.96775383709347551076f,0.25041300657296527987f,
0.96813910474636244441f,0.24892760574572025956f,0.96852209427441726675f,
0.24744161916777343557f,0.96890280477642887202f,0.24595505033579459497f,
0.96928123535654853171f,0.24446790274782420616f,0.96965738512429244800f,
0.24298017990326398197f,0.97003125319454397424f,0.24149188530286930243f,
0.97040283868755550234f,0.24000302244874149871f,0.97077214072895035013f,
0.23851359484431849944f,0.97113915844972509284f,0.23702360599436733679f,
0.97150389098625178352f,0.23553305940497545889f,0.97186633748027939639f,
0.23404195858354345794f,0.97222649707893626925f,0.23255030703877532794f,
0.97258436893473221296f,0.23105810828067127605f,0.97293995220556006576f,
0.22956536582051886852f,0.97329324605469824672f,0.22807208317088578653f,
0.97364424965081186603f,0.22657826384561011168f,0.97399296216795583359f,
0.22508391135979277653f,0.97433938278557585821f,0.22358902922979001504f,
0.97468351068851066810f,0.22209362097320359264f,0.97502534506699412020f,
0.22059769010887364526f,0.97536488511665686563f,0.21910124015686976984f,
0.97570213003852857003f,0.21760427463848366902f,0.97603707903903902388f,
0.21610679707621960333f,0.97636973133002114000f,0.21460881099378692483f,
0.97670008612871184184f,0.21311031991609136194f,0.97702814265775439484f,
0.21161132736922760866f,0.97735390014519996082f,0.21011183688046972118f,
0.97767735782450992943f,0.20861185197826345727f,0.97799851493455713936f,
0.20711137619221856032f,0.97831737071962765473f,0.20561041305309932237f,
0.97863392442942309657f,0.20410896609281700687f,0.97894817531906219710f,
0.20260703884442110567f,0.97926012264908202098f,0.20110463484209195606f,
0.97956976568544051887f,0.19960175762113105402f,0.97987710369951763756f,
0.19809841071795372680f,0.98018213596811731847f,0.19659459767008022335f,
0.98048486177346938497f,0.19509032201612833135f,0.98078528040323043058f,
0.19358558729580374602f,0.98108339115048659451f,0.19208039704989238183f,
0.98137919331375456089f,0.19057475482025279523f,0.98167268619698311305f,
0.18906866414980627589f,0.98196386910955524296f,0.18756212858252974129f,
0.98225274136628937249f,0.18605515166344663291f,0.98253930228744124076f,
0.18454773693861964423f,0.98282355119870523641f,0.18303988795514106180f,
0.98310548743121628501f,0.18153160826112513249f,0.98338511032155118130f,
0.18002290140569951471f,0.98366241921173025453f,0.17851377093899759019f,
0.98393741344921892278f,0.17700422041214886049f,0.98421009238692902521f,
0.17549425337727139751f,0.98448045538322093151f,0.17398387338746384989f,
0.98474850180190420801f,0.17247308399679603386f,0.98501423101223983814f,
0.17096188876030135595f,0.98527764238894122162f,0.16945029123396793125f,
0.98553873531217606185f,0.16793829497473122814f,0.98579750916756736512f,
0.16642590354046421508f,0.98605396334619543897f,0.16491312048997008866f,
0.98630809724459866938f,0.16339994938297322524f,0.98655991026477540817f,
0.16188639378011188130f,0.98680940181418541624f,0.16037245724292839566f,
0.98705657130575097380f,0.15885814333386139019f,0.98730141815785843473f,
0.15734345561623827581f,0.98754394179435922574f,0.15582839765426531597f,
0.98778414164457217783f,0.15431297301302024372f,0.98802201714328352633f,
0.15279718525844340760f,0.98825756773074946437f,0.15128103795733024994f,
0.98849079285269658701f,0.14976453467732162017f,0.98872169196032377858f,
0.14824767898689619749f,0.98895026451030298986f,0.14673047445536174793f,
0.98917650996478101444f,0.14521292465284751927f,0.98940042779138037687f,
0.14369503315029458212f,0.98962201746320077600f,0.14217680351944800288f,
0.98984127845882052821f,0.14065823933284923863f,0.99005821026229712256f,
0.13913934416382628401f,0.99027281236316910817f,0.13762012158648617710f,
0.99048508425645698239f,0.13610057517570620100f,0.99069502544266463406f,
0.13458070850712622324f,0.99090263542778000971f,0.13306052515713917561f,
0.99110791372327677884f,0.13154002870288328264f,0.99131085984611544415f,
0.13001922272223334631f,0.99151147331874389668f,0.12849811079379322432f,
0.99170975366909952520f,0.12697669649688597682f,0.99190570043060932726f,
0.12545498341154620592f,0.99209931314219179654f,0.12393297511851220083f,
0.99229059134825736699f,0.12241067519921627893f,0.99247953459870996706f,
0.12088808723577722237f,0.99266614244894801899f,0.11936521481099135467f,
0.99285041445986510489f,0.11784206150832501891f,0.99303235019785141002f,
0.11631863091190487725f,0.99321194923479450001f,0.11479492660651025027f,
0.99338921114808065305f,0.11327095217756436019f,0.99356413552059530403f,
0.11174671121112665639f,0.99373672194072459884f,0.11022220729388318428f,
0.99390697000235606051f,0.10869744401313867488f,0.99407487930487936634f,
0.10717242495680887049f,0.99424044945318790223f,0.10564715371341069916f,
0.99440368005767909576f,0.10412163387205472520f,0.99456457073425541537f,
0.10259586902243628126f,0.99472312110432570265f,0.10106986275482787718f,
0.99487933079480561638f,0.09954361866006944393f,0.99503319943811863180f,
0.09801714032956077016f,0.99518472667219681771f,0.09649043135525260662f,
0.99533391214048227980f,0.09496349532963906104f,0.99548075549192693856f,
0.09343633584574791151f,0.99562525638099430569f,0.09190895649713269611f,
0.99576741446765981713f,0.09038136087786501072f,0.99590722941741172125f,
0.08885355258252468358f,0.99604470090125196702f,0.08732553520619222576f,
0.99617982859569687015f,0.08579731234443987997f,0.99631261218277800129f,
0.08426888759332412659f,0.99644305135004263008f,0.08274026454937580266f,
0.99657114579055483539f,0.08121144680959238582f,0.99669689520289606044f,
0.07968243797143012563f,0.99682029929116566791f,0.07815324163279431524f,
0.99694135776498216117f,0.07662386139203161695f,0.99706007033948296225f,
0.07509430084792129145f,0.99717643673532618820f,0.07356456359966745406f,
0.99729045667869020697f,0.07203465324688941573f,0.99740212990127530279f,
0.07050457338961400866f,0.99751145614030345410f,0.06897432762826673225f,
0.99761843513851955478f,0.06744391956366410645f,0.99772306664419163624f,
0.06591335279700392957f,0.99782535041111164453f,0.06438263092985740954f,
0.99792528619859599548f,0.06285175756416142012f,0.99802287377148624081f,
0.06132073630220864768f,0.99811811290014917919f,0.05978957074664000698f,
0.99821100336047818846f,0.05825826450043573163f,0.99830154493389289261f,
0.05672682116690778292f,0.99838973740734016094f,0.05519524434969003135f,
0.99847558057329477421f,0.05366353765273067927f,0.99855907422975931365f,
0.05213170468028331672f,0.99864021818026527111f,0.05059974903689933717f,
0.99871901223387293811f,0.04906767432741812596f,0.99879545620517240501f,
0.04753548415695926094f,0.99886954991428356099f,0.04600318213091464381f,
0.99894129318685687124f,0.04447077185493874402f,0.99901068585407337697f,
0.04293825693494095902f,0.99907772775264536147f,0.04140564097707671171f,
0.99914241872481690532f,0.03987292758773984536f,0.99920475861836388631f,
0.03834012037355279123f,0.99926474728659442359f,0.03680722294135899131f,
0.99932238458834954375f,0.03527423889821394709f,0.99937767038800284780f,
0.03374117185137764235f,0.99943060455546173237f,0.03220802540830470378f,
0.99948118696616694567f,0.03067480317663658085f,0.99952941750109314256f,
0.02914150876419373953f,0.99957529604674921764f,0.02760814577896581953f,
0.99961882249517863830f,0.02607471782910403962f,0.99965999674395922270f,
0.02454122852291226384f,0.99969881869620424997f,0.02300768146883941032f,
0.99973528826056168306f,0.02147408027546960502f,0.99976940535121527898f,
0.01994042855151459750f,0.99980116988788425569f,0.01840672990580482019f,
0.99983058179582340319f,0.01687298794728177287f,0.99985764100582386060f,
0.01533920628498821985f,0.99988234745421256111f,0.01380538852806034895f,
0.99990470108285289808f,0.01227153828571994447f,0.99992470183914450299f,
0.01073765916726457208f,0.99994234967602391162f,0.00920375478205995995f,
0.99995764455196389786f,0.00766982873953107706f,0.99997058643097413988f,
0.00613588464915451517f,0.99998117528260110909f,0.00460192612044867198f,
0.99998941108192840321f,0.00306795676296613791f,0.99999529380957619118f,
0.00153398018628476615f,0.99999882345170187925f,1.00000000000000000000f,
0.00000000000000000000f,0.99998117528260110909f,0.00613588464915447527f,
0.99992470183914450299f,0.01227153828571992539f,0.99983058179582340319f,
0.01840672990580482019f,0.99969881869620424997f,0.02454122852291228812f,
0.99952941750109314256f,0.03067480317663662595f,0.99932238458834954375f,
0.03680722294135883171f,0.99907772775264536147f,0.04293825693494082024f,
0.99879545620517240501f,0.04906767432741801493f,0.99847558057329477421f,
0.05519524434968993420f,0.99811811290014917919f,0.06132073630220857829f,
0.99772306664419163624f,0.06744391956366405094f,0.99729045667869020697f,
0.07356456359966742631f,0.99682029929116566791f,0.07968243797143012563f,
0.99631261218277800129f,0.08579731234443989385f,0.99576741446765981713f,
0.09190895649713272386f,0.99518472667219692873f,0.09801714032956060363f,
0.99456457073425541537f,0.10412163387205458642f,0.99390697000235606051f,
0.11022220729388305938f,0.99321194923479450001f,0.11631863091190475235f,
0.99247953459870996706f,0.12241067519921619566f,0.99170975366909952520f,
0.12849811079379316880f,0.99090263542778000971f,0.13458070850712616773f,
0.99005821026229712256f,0.14065823933284921088f,0.98917650996478101444f,
0.14673047445536174793f,0.98825756773074946437f,0.15279718525844343535f,
0.98730141815785843473f,0.15885814333386144570f,0.98630809724459866938f,
0.16491312048996989437f,0.98527764238894122162f,0.17096188876030121717f,
0.98421009238692902521f,0.17700422041214874946f,0.98310548743121628501f,
0.18303988795514095078f,0.98196386910955524296f,0.18906866414980619262f,
0.98078528040323043058f,0.19509032201612824808f,0.97956976568544051887f,
0.20110463484209190055f,0.97831737071962765473f,0.20711137619221856032f,
0.97702814265775439484f,0.21311031991609136194f,0.97570213003852857003f,
0.21910124015686979759f,0.97433938278557585821f,0.22508391135979283204f,
0.97293995220556017678f,0.23105810828067110951f,0.97150389098625178352f,
0.23702360599436719801f,0.97003125319454397424f,0.24298017990326387094f,
0.96852209427441737777f,0.24892760574572014853f,0.96697647104485207059f,
0.25486565960451457169f,0.96539444169768939830f,0.26079411791527551401f,
0.96377606579543984022f,0.26671275747489836538f,0.96212140426904158019f,
0.27262135544994897662f,0.96043051941556578655f,0.27851968938505305973f,
0.95870347489587159906f,0.28440753721127187692f,0.95694033573220882438f,
0.29028467725446233105f,0.95514116830577078243f,0.29615088824362378883f,
0.95330604035419386211f,0.30200594931922808417f,0.95143502096900833820f,
0.30784964004153486661f,0.94952818059303667475f,0.31368174039889151761f,
0.94758559101774109124f,0.31950203081601569188f,0.94560732538052127971f,
0.32531029216226292622f,0.94359345816196038559f,0.33110630575987642921f,
0.94154406518302080631f,0.33688985339222005111f,0.93945922360218991898f,
0.34266071731199437833f,0.93733901191257495977f,0.34841868024943456472f,
0.93518350993894761025f,0.35416352542049034380f,0.93299279883473895669f,
0.35989503653498811087f,0.93076696107898371224f,0.36561299780477385379f,
0.92850608047321558924f,0.37131719395183754306f,0.92621024213831137928f,
0.37700741021641825945f,0.92387953251128673848f,0.38268343236508978178f,
0.92151403934204190183f,0.38834504669882624617f,0.91911385169005777040f,
0.39399204006104809883f,0.91667905992104270485f,0.39962419984564678810f,
0.91420975570353069095f,0.40524131400498986100f,0.91170603200542987832f,
0.41084317105790391089f,0.90916798309052238025f,0.41642956009763715253f,
0.90659570451491533483f,0.42200027079979968159f,0.90398929312344333820f,
0.42755509343028208491f,0.90134884704602202810f,0.43309381885315195726f,
0.89867446569395381673f,0.43861623853852765853f,0.89596624975618521791f,
0.44412214457042920035f,0.89322430119551532446f,0.44961132965460653965f,
0.89044872324475787817f,0.45508358712634383592f,0.88763962040285393496f,
0.46053871095824000514f,0.88479709843093778954f,0.46597649576796618121f,
0.88192126434835504956f,0.47139673682599764204f,0.87901222642863352519f,
0.47679923006332208812f,0.87607009419540660122f,0.48218377207912271887f,
0.87309497841829009079f,0.48755016014843599592f,0.87008699110871146054f,
0.49289819222978403790f,0.86704624551569264845f,0.49822766697278181303f,
0.86397285612158669643f,0.50353838372571757542f,0.86086693863776730939f,
0.50883014254310698909f,0.85772861000027211809f,0.51410274419322166128f,
0.85455798836540053376f,0.51935599016558964269f,0.85135519310526519554f,
0.52458968267846894928f,0.84812034480329723252f,0.52980362468629460526f,
0.84485356524970711689f,0.53499761988709715332f,0.84155497743689844370f,
0.54017147272989285423f,0.83822470555483807875f,0.54532498842204646383f,
0.83486287498638001026f,0.55045797293660481131f,0.83146961230254523567f,
0.55557023301960217765f,0.82804504525775579626f,0.56066157619733603124f,
0.82458930278502529099f,0.56573181078361312046f,0.82110251499110464835f,
0.57078074588696725566f,0.81758481315158371139f,0.57580819141784533866f,
0.81403632970594841378f,0.58081395809576452649f,0.81045719825259476821f,
0.58579785745643886408f,0.80684755354379933401f,0.59075970185887416442f,
0.80320753148064494287f,0.59569930449243335691f,0.79953726910790501314f,
0.60061647938386897305f,0.79583690460888356633f,0.60551104140432554512f,
0.79210657730021238887f,0.61038280627630947528f,0.78834642762660622761f,
0.61523159058062681925f,0.78455659715557524159f,0.62005721176328909561f,
0.78073722857209448822f,0.62485948814238634341f,0.77688846567323244230f,
0.62963823891492698426f,0.77301045336273699338f,0.63439328416364548779f,
0.76910333764557969882f,0.63912444486377573138f,0.76516726562245895860f,
0.64383154288979138613f,0.76120238548426177871f,0.64851440102211244110f,
0.75720884650648456748f,0.65317284295377675551f,0.75318679904361252042f,
0.65780669329707863735f,0.74913639452345937020f,0.66241577759017178373f,
0.74505778544146594733f,0.66699992230363747137f,0.74095112535495921691f,
0.67155895484701833009f,0.73681656887736979300f,0.67609270357531592310f,
0.73265427167241281570f,0.68060099779545302212f,0.72846439044822519637f,
0.68508366777270035541f,0.72424708295146700276f,0.68954054473706682948f,
0.72000250796138165477f,0.69397146088965389055f,0.71573082528381870571f,
0.69837624940897280457f,0.71143219574521643356f,0.70275474445722529993f,
0.70710678118654757274f,0.70710678118654757274f,0.70275474445722529993f,
0.71143219574521643356f,0.69837624940897291559f,0.71573082528381859468f,
0.69397146088965400157f,0.72000250796138165477f,0.68954054473706694051f,
0.72424708295146689174f,0.68508366777270035541f,0.72846439044822519637f,
0.68060099779545302212f,0.73265427167241281570f,0.67609270357531603413f,
0.73681656887736979300f,0.67155895484701833009f,0.74095112535495910588f,
0.66699992230363747137f,0.74505778544146594733f,0.66241577759017178373f,
0.74913639452345925918f,0.65780669329707874837f,0.75318679904361252042f,
0.65317284295377686654f,0.75720884650648456748f,0.64851440102211255212f,
0.76120238548426177871f,0.64383154288979149715f,0.76516726562245895860f,
0.63912444486377573138f,0.76910333764557958780f,0.63439328416364548779f,
0.77301045336273688235f,0.62963823891492709528f,0.77688846567323244230f,
0.62485948814238645443f,0.78073722857209448822f,0.62005721176328920663f,
0.78455659715557524159f,0.61523159058062681925f,0.78834642762660622761f,
0.61038280627630947528f,0.79210657730021227785f,0.60551104140432554512f,
0.79583690460888345530f,0.60061647938386897305f,0.79953726910790501314f,
0.59569930449243346793f,0.80320753148064483184f,0.59075970185887427544f,
0.80684755354379922299f,0.58579785745643886408f,0.81045719825259476821f,
0.58081395809576452649f,0.81403632970594830276f,0.57580819141784533866f,
0.81758481315158371139f,0.57078074588696736669f,0.82110251499110464835f,
0.56573181078361323149f,0.82458930278502529099f,0.56066157619733603124f,
0.82804504525775579626f,0.55557023301960228867f,0.83146961230254523567f,
0.55045797293660481131f,0.83486287498638001026f,0.54532498842204646383f,
0.83822470555483796772f,0.54017147272989296525f,0.84155497743689833268f,
0.53499761988709726435f,0.84485356524970700587f,0.52980362468629482731f,
0.84812034480329712149f,0.52458968267846883826f,0.85135519310526519554f,
0.51935599016558953167f,0.85455798836540053376f,0.51410274419322166128f,
0.85772861000027211809f,0.50883014254310698909f,0.86086693863776730939f,
0.50353838372571757542f,0.86397285612158669643f,0.49822766697278186854f,
0.86704624551569264845f,0.49289819222978409341f,0.87008699110871134952f,
0.48755016014843605143f,0.87309497841829009079f,0.48218377207912282989f,
0.87607009419540660122f,0.47679923006332225466f,0.87901222642863341417f,
0.47139673682599780857f,0.88192126434835493853f,0.46597649576796612569f,
0.88479709843093778954f,0.46053871095824000514f,0.88763962040285393496f,
0.45508358712634383592f,0.89044872324475787817f,0.44961132965460659516f,
0.89322430119551532446f,0.44412214457042925586f,0.89596624975618510689f,
0.43861623853852771404f,0.89867446569395381673f,0.43309381885315201277f,
0.90134884704602202810f,0.42755509343028219593f,0.90398929312344333820f,
0.42200027079979979261f,0.90659570451491533483f,0.41642956009763731906f,
0.90916798309052226923f,0.41084317105790391089f,0.91170603200542987832f,
0.40524131400498986100f,0.91420975570353069095f,0.39962419984564678810f,
0.91667905992104270485f,0.39399204006104809883f,0.91911385169005777040f,
0.38834504669882630168f,0.92151403934204190183f,0.38268343236508983729f,
0.92387953251128673848f,0.37700741021641831496f,0.92621024213831126826f,
0.37131719395183759858f,0.92850608047321558924f,0.36561299780477396482f,
0.93076696107898371224f,0.35989503653498827740f,0.93299279883473884567f,
0.35416352542049051033f,0.93518350993894749923f,0.34841868024943450921f,
0.93733901191257495977f,0.34266071731199437833f,0.93945922360218991898f,
0.33688985339222005111f,0.94154406518302080631f,0.33110630575987642921f,
0.94359345816196038559f,0.32531029216226298173f,0.94560732538052127971f,
0.31950203081601574739f,0.94758559101774109124f,0.31368174039889157312f,
0.94952818059303667475f,0.30784964004153497763f,0.95143502096900833820f,
0.30200594931922819519f,0.95330604035419375109f,0.29615088824362395536f,
0.95514116830577067141f,0.29028467725446233105f,0.95694033573220893540f,
0.28440753721127182141f,0.95870347489587159906f,0.27851968938505305973f,
0.96043051941556578655f,0.27262135544994897662f,0.96212140426904158019f,
0.26671275747489842090f,0.96377606579543984022f,0.26079411791527556952f,
0.96539444169768939830f,0.25486565960451462720f,0.96697647104485207059f,
0.24892760574572025956f,0.96852209427441726675f,0.24298017990326398197f,
0.97003125319454397424f,0.23702360599436733679f,0.97150389098625178352f,
0.23105810828067127605f,0.97293995220556006576f,0.22508391135979277653f,
0.97433938278557585821f,0.21910124015686976984f,0.97570213003852857003f,
0.21311031991609136194f,0.97702814265775439484f,0.20711137619221856032f,
0.97831737071962765473f,0.20110463484209195606f,0.97956976568544051887f,
0.19509032201612833135f,0.98078528040323043058f,0.18906866414980627589f,
0.98196386910955524296f,0.18303988795514106180f,0.98310548743121628501f,
0.17700422041214886049f,0.98421009238692902521f,0.17096188876030135595f,
0.98527764238894122162f,0.16491312048997008866f,0.98630809724459866938f,
0.15885814333386139019f,0.98730141815785843473f,0.15279718525844340760f,
0.98825756773074946437f,0.14673047445536174793f,0.98917650996478101444f,
0.14065823933284923863f,0.99005821026229712256f,0.13458070850712622324f,
0.99090263542778000971f,0.12849811079379322432f,0.99170975366909952520f,
0.12241067519921627893f,0.99247953459870996706f,0.11631863091190487725f,
0.99321194923479450001f,0.11022220729388318428f,0.99390697000235606051f,
0.10412163387205472520f,0.99456457073425541537f,0.09801714032956077016f,
0.99518472667219681771f,0.09190895649713269611f,0.99576741446765981713f,
0.08579731234443987997f,0.99631261218277800129f,0.07968243797143012563f,
0.99682029929116566791f,0.07356456359966745406f,0.99729045667869020697f,
0.06744391956366410645f,0.99772306664419163624f,0.06132073630220864768f,
0.99811811290014917919f,0.05519524434969003135f,0.99847558057329477421f,
0.04906767432741812596f,0.99879545620517240501f,0.04293825693494095902f,
0.99907772775264536147f,0.03680722294135899131f,0.99932238458834954375f,
0.03067480317663658085f,0.99952941750109314256f,0.02454122852291226384f,
0.99969881869620424997f,0.01840672990580482019f,0.99983058179582340319f,
0.01227153828571994447f,0.99992470183914450299f,0.00613588464915451517f,
0.99998117528260110909f,1.00000000000000000000f,0.00000000000000000000f,
0.99969881869620424997f,0.02454122852291228812f,0.99879545620517240501f,
0.04906767432741801493f,0.99729045667869020697f,0.07356456359966742631f,
0.99518472667219692873f,0.09801714032956060363f,0.99247953459870996706f,
0.12241067519921619566f,0.98917650996478101444f,0.14673047445536174793f,
0.98527764238894122162f,0.17096188876030121717f,0.98078528040323043058f,
0.19509032201612824808f,0.97570213003852857003f,0.21910124015686979759f,
0.97003125319454397424f,0.24298017990326387094f,0.96377606579543984022f,
0.26671275747489836538f,0.95694033573220882438f,0.29028467725446233105f,
0.94952818059303667475f,0.31368174039889151761f,0.94154406518302080631f,
0.33688985339222005111f,0.93299279883473895669f,0.35989503653498811087f,
0.92387953251128673848f,0.38268343236508978178f,0.91420975570353069095f,
0.40524131400498986100f,0.90398929312344333820f,0.42755509343028208491f,
0.89322430119551532446f,0.44961132965460653965f,0.88192126434835504956f,
0.47139673682599764204f,0.87008699110871146054f,0.49289819222978403790f,
0.85772861000027211809f,0.51410274419322166128f,0.84485356524970711689f,
0.53499761988709715332f,0.83146961230254523567f,0.55557023301960217765f,
0.81758481315158371139f,0.57580819141784533866f,0.80320753148064494287f,
0.59569930449243335691f,0.78834642762660622761f,0.61523159058062681925f,
0.77301045336273699338f,0.63439328416364548779f,0.75720884650648456748f,
0.65317284295377675551f,0.74095112535495921691f,0.67155895484701833009f,
0.72424708295146700276f,0.68954054473706682948f,0.70710678118654757274f,
0.70710678118654757274f,0.68954054473706694051f,0.72424708295146689174f,
0.67155895484701833009f,0.74095112535495910588f,0.65317284295377686654f,
0.75720884650648456748f,0.63439328416364548779f,0.77301045336273688235f,
0.61523159058062681925f,0.78834642762660622761f,0.59569930449243346793f,
0.80320753148064483184f,0.57580819141784533866f,0.81758481315158371139f,
0.55557023301960228867f,0.83146961230254523567f,0.53499761988709726435f,
0.84485356524970700587f,0.51410274419322166128f,0.85772861000027211809f,
0.49289819222978409341f,0.87008699110871134952f,0.47139673682599780857f,
0.88192126434835493853f,0.44961132965460659516f,0.89322430119551532446f,
0.42755509343028219593f,0.90398929312344333820f,0.40524131400498986100f,
0.91420975570353069095f,0.38268343236508983729f,0.92387953251128673848f,
0.35989503653498827740f,0.93299279883473884567f,0.33688985339222005111f,
0.94154406518302080631f,0.31368174039889157312f,0.94952818059303667475f,
0.29028467725446233105f,0.95694033573220893540f,0.26671275747489842090f,
0.96377606579543984022f,0.24298017990326398197f,0.97003125319454397424f,
0.21910124015686976984f,0.97570213003852857003f,0.19509032201612833135f,
0.98078528040323043058f,0.17096188876030135595f,0.98527764238894122162f,
0.14673047445536174793f,0.98917650996478101444f,0.12241067519921627893f,
0.99247953459870996706f,0.09801714032956077016f,0.99518472667219681771f,
0.07356456359966745406f,0.99729045667869020697f,0.04906767432741812596f,
0.99879545620517240501f,0.02454122852291226384f,0.99969881869620424997f,
1.00000000000000000000f,0.00000000000000000000f,0.99518472667219692873f,
0.09801714032956060363f,0.98078528040323043058f,0.19509032201612824808f,
0.95694033573220882438f,0.29028467725446233105f,0.92387953251128673848f,
0.38268343236508978178f,0.88192126434835504956f,0.47139673682599764204f,
0.83146961230254523567f,0.55557023301960217765f,0.77301045336273699338f,
0.63439328416364548779f,0.70710678118654757274f,0.70710678118654757274f,
0.63439328416364548779f,0.77301045336273688235f,0.55557023301960228867f,
0.83146961230254523567f,0.47139673682599780857f,0.88192126434835493853f,
0.38268343236508983729f,0.92387953251128673848f,0.29028467725446233105f,
0.95694033573220893540f,0.19509032201612833135f,0.98078528040323043058f,
0.09801714032956077016f,0.99518472667219681771f,1.00000000000000000000f,
0.00000000000000000000f,0.92387953251128673848f,0.38268343236508978178f,
0.70710678118654757274f,0.70710678118654757274f,0.38268343236508983729f,
0.92387953251128673848f,};

float32_t rearranged_twiddle_stride2_4096_f32[2728]={
1.00000000000000000000f,0.00000000000000000000f,0.99999529380957619118f,
0.00306795676296597614f,0.99998117528260110909f,0.00613588464915447527f,
0.99995764455196389786f,0.00920375478205981944f,0.99992470183914450299f,
0.01227153828571992539f,0.99988234745421256111f,0.01533920628498810015f,
0.99983058179582340319f,0.01840672990580482019f,0.99976940535121527898f,
0.02147408027546950787f,0.99969881869620424997f,0.02454122852291228812f,
0.99961882249517863830f,0.02760814577896573974f,0.99952941750109314256f,
0.03067480317663662595f,0.99943060455546173237f,0.03374117185137757990f,
0.99932238458834954375f,0.03680722294135883171f,0.99920475861836388631f,
0.03987292758773981066f,0.99907772775264536147f,0.04293825693494082024f,
0.99894129318685687124f,0.04600318213091462299f,0.99879545620517240501f,
0.04906767432741801493f,0.99864021818026527111f,0.05213170468028332366f,
0.99847558057329477421f,0.05519524434968993420f,0.99830154493389289261f,
0.05825826450043575244f,0.99811811290014917919f,0.06132073630220857829f,
0.99792528619859599548f,0.06438263092985746505f,0.99772306664419163624f,
0.06744391956366405094f,0.99751145614030345410f,0.07050457338961385600f,
0.99729045667869020697f,0.07356456359966742631f,0.99706007033948296225f,
0.07662386139203149205f,0.99682029929116566791f,0.07968243797143012563f,
0.99657114579055483539f,0.08274026454937569164f,0.99631261218277800129f,
0.08579731234443989385f,0.99604470090125196702f,0.08885355258252460031f,
0.99576741446765981713f,0.09190895649713272386f,0.99548075549192693856f,
0.09496349532963899165f,0.99518472667219692873f,0.09801714032956060363f,
0.99487933079480561638f,0.10106986275482782167f,0.99456457073425541537f,
0.10412163387205458642f,0.99424044945318790223f,0.10717242495680884273f,
0.99390697000235606051f,0.11022220729388305938f,0.99356413552059530403f,
0.11327095217756434631f,0.99321194923479450001f,0.11631863091190475235f,
0.99285041445986510489f,0.11936521481099135467f,0.99247953459870996706f,
0.12241067519921619566f,0.99209931314219179654f,0.12545498341154623367f,
0.99170975366909952520f,0.12849811079379316880f,0.99131085984611544415f,
0.13154002870288311611f,0.99090263542778000971f,0.13458070850712616773f,
0.99048508425645709341f,0.13762012158648603832f,0.99005821026229712256f,
0.14065823933284921088f,0.98962201746320088702f,0.14369503315029447110f,
0.98917650996478101444f,0.14673047445536174793f,0.98872169196032377858f,
0.14976453467732150915f,0.98825756773074946437f,0.15279718525844343535f,
0.98778414164457217783f,0.15582839765426523271f,0.98730141815785843473f,
0.15885814333386144570f,0.98680940181418552726f,0.16188639378011182579f,
0.98630809724459866938f,0.16491312048996989437f,0.98579750916756747614f,
0.16793829497473117263f,0.98527764238894122162f,0.17096188876030121717f,
0.98474850180190420801f,0.17398387338746382214f,0.98421009238692902521f,
0.17700422041214874946f,0.98366241921173025453f,0.18002290140569951471f,
0.98310548743121628501f,0.18303988795514095078f,0.98253930228744124076f,
0.18605515166344663291f,0.98196386910955524296f,0.18906866414980619262f,
0.98137919331375456089f,0.19208039704989243734f,0.98078528040323043058f,
0.19509032201612824808f,0.98018213596811742949f,0.19809841071795356027f,
0.97956976568544051887f,0.20110463484209190055f,0.97894817531906219710f,
0.20410896609281686809f,0.97831737071962765473f,0.20711137619221856032f,
0.97767735782450992943f,0.21011183688046961016f,0.97702814265775439484f,
0.21311031991609136194f,0.97636973133002114000f,0.21610679707621952006f,
0.97570213003852857003f,0.21910124015686979759f,0.97502534506699412020f,
0.22209362097320350937f,0.97433938278557585821f,0.22508391135979283204f,
0.97364424965081197705f,0.22807208317088573102f,0.97293995220556017678f,
0.23105810828067110951f,0.97222649707893626925f,0.23404195858354343018f,
0.97150389098625178352f,0.23702360599436719801f,0.97077214072895035013f,
0.24000302244874149871f,0.97003125319454397424f,0.24298017990326387094f,
0.96928123535654853171f,0.24595505033579459497f,0.96852209427441737777f,
0.24892760574572014853f,0.96775383709347551076f,0.25189781815421696809f,
0.96697647104485207059f,0.25486565960451457169f,0.96619000344541250413f,
0.25783110216215898713f,0.96539444169768939830f,0.26079411791527551401f,
0.96458979328981275803f,0.26375467897483134694f,0.96377606579543984022f,
0.26671275747489836538f,0.96295326687368387741f,0.26966832557291509076f,
0.96212140426904158019f,0.27262135544994897662f,0.96128048581132063966f,
0.27557181931095814376f,0.96043051941556578655f,0.27851968938505305973f,
0.95957151308198451733f,0.28146493792575794091f,0.95870347489587159906f,
0.28440753721127187692f,0.95782641302753290802f,0.28734745954472951102f,
0.95694033573220882438f,0.29028467725446233105f,0.95604525134999640557f,
0.29321916269425862822f,0.95514116830577078243f,0.29615088824362378883f,
0.95422809510910566733f,0.29907982630804047508f,0.95330604035419386211f,
0.30200594931922808417f,0.95237501271976587880f,0.30492922973540237397f,
0.95143502096900833820f,0.30784964004153486661f,0.95048607394948170235f,
0.31076715274961147495f,0.94952818059303667475f,0.31368174039889151761f,
0.94856134991573026749f,0.31659337555616584581f,0.94758559101774109124f,
0.31950203081601569188f,0.94660091308328353499f,0.32240767880106985244f,
0.94560732538052127971f,0.32531029216226292622f,0.94460483726148025685f,
0.32820984357909249729f,0.94359345816196038559f,0.33110630575987642921f,
0.94257319760144686605f,0.33399965144200938205f,0.94154406518302080631f,
0.33688985339222005111f,0.94050607059326829518f,0.33977688440682685123f,
0.93945922360218991898f,0.34266071731199437833f,0.93840353406310805795f,
0.34554132496398909380f,0.93733901191257495977f,0.34841868024943456472f,
0.93626566717027825959f,0.35129275608556709276f,0.93518350993894761025f,
0.35416352542049034380f,0.93409255040425887007f,0.35703096123342997759f,
0.93299279883473895669f,0.35989503653498811087f,0.93188426558166814750f,
0.36275572436739722537f,0.93076696107898371224f,0.36561299780477385379f,
0.92964089584318121418f,0.36846682995337232125f,0.92850608047321558924f,
0.37131719395183754306f,0.92736252565040111495f,0.37416406297145793358f,
0.92621024213831137928f,0.37700741021641825945f,0.92504924078267758425f,
0.37984720892405116066f,0.92387953251128673848f,0.38268343236508978178f,
0.92270112833387862850f,0.38551605384391884890f,0.92151403934204190183f,
0.38834504669882624617f,0.92031827670911059425f,0.39117038430225387069f,
0.91911385169005777040f,0.39399204006104809883f,0.91790077562139049672f,
0.39680998741671030805f,0.91667905992104270485f,0.39962419984564678810f,
0.91544871608826783316f,0.40243465085941843018f,0.91420975570353069095f,
0.40524131400498986100f,0.91296219042839821256f,0.40804416286497868782f,
0.91170603200542987832f,0.41084317105790391089f,0.91044129225806724737f,
0.41363831223843450235f,0.90916798309052238025f,0.41642956009763715253f,
0.90788611648766626150f,0.41921688836322390515f,0.90659570451491533483f,
0.42200027079979968159f,0.90529675931811881551f,0.42477968120910880589f,
0.90398929312344333820f,0.42755509343028208491f,0.90267331823725882600f,
0.43032648134008261165f,0.90134884704602202810f,0.43309381885315195726f,
0.90001589201616016833f,0.43585707992225547480f,0.89867446569395381673f,
0.43861623853852765853f,0.89732458070541831763f,0.44137126873171667052f,
0.89596624975618521791f,0.44412214457042920035f,0.89459948563138269595f,
0.44686884016237415906f,0.89322430119551532446f,0.44961132965460653965f,
0.89184070939234272313f,0.45234958723377088896f,0.89044872324475787817f,
0.45508358712634383592f,0.88904835585466457371f,0.45781330359887717485f,
0.88763962040285393496f,0.46053871095824000514f,0.88622253014888063838f,
0.46325978355186014923f,0.88479709843093778954f,0.46597649576796618121f,
0.88336333866573157891f,0.46868882203582790114f,0.88192126434835504956f,
0.47139673682599764204f,0.88047088905216075450f,0.47410021465054996703f,
0.87901222642863352519f,0.47679923006332208812f,0.87754529020726135258f,
0.47949375766015295275f,0.87607009419540660122f,0.48218377207912271887f,
0.87458665227817611321f,0.48486924800079106435f,0.87309497841829009079f,
0.48755016014843599592f,0.87159508665595097909f,0.49022648328829115938f,
0.87008699110871146054f,0.49289819222978403790f,0.86857070597134089507f,
0.49556526182577254058f,0.86704624551569264845f,0.49822766697278181303f,
0.86551362409056908920f,0.50088538261124071482f,0.86397285612158669643f,
0.50353838372571757542f,0.86242395611104050168f,0.50618664534515522835f,
0.86086693863776730939f,0.50883014254310698909f,0.85930181835700847337f,
0.51146885043797030157f,0.85772861000027211809f,0.51410274419322166128f,
0.85614732837519447184f,0.51673179901764987321f,0.85455798836540053376f,
0.51935599016558964269f,0.85296060493036363059f,0.52197529293715438925f,
0.85135519310526519554f,0.52458968267846894928f,0.84974176800085254868f,
0.52719913478190127964f,0.84812034480329723252f,0.52980362468629460526f,
0.84649093877405212627f,0.53240312787719790144f,0.84485356524970711689f,
0.53499761988709715332f,0.84320823964184543620f,0.53758707629564539410f,
0.84155497743689844370f,0.54017147272989285423f,0.83989379419599952126f,
0.54275078486451588944f,0.83822470555483807875f,0.54532498842204646383f,
0.83654772722351200542f,0.54789405917310018967f,0.83486287498638001026f,
0.55045797293660481131f,0.83317016470191318511f,0.55301670558002746780f,
0.83146961230254523567f,0.55557023301960217765f,0.82976123379452304540f,
0.55811853122055610221f,0.82804504525775579626f,0.56066157619733603124f,
0.82632106284566353427f,0.56319934401383409117f,0.82458930278502529099f,
0.56573181078361312046f,0.82284978137582642788f,0.56825895267013148970f,
0.82110251499110464835f,0.57078074588696725566f,0.81934752007679700903f,
0.57329716669804220430f,0.81758481315158371139f,0.57580819141784533866f,
0.81581441080673378075f,0.57831379641165558958f,0.81403632970594841378f,
0.58081395809576452649f,0.81225058658520399302f,0.58330865293769829094f,
0.81045719825259476821f,0.58579785745643886408f,0.80865618158817498262f,
0.58828154822264522306f,0.80684755354379933401f,0.59075970185887416442f,
0.80503133114296365758f,0.59323229503979979516f,0.80320753148064494287f,
0.59569930449243335691f,0.80137617172314024039f,0.59816070699634238395f,
0.79953726910790501314f,0.60061647938386897305f,0.79769084094339115509f,
0.60306659854034816437f,0.79583690460888356633f,0.60551104140432554512f,
0.79397547755433717231f,0.60794978496777363208f,0.79210657730021238887f,
0.61038280627630947528f,0.79023022143731003197f,0.61281008242940970820f,
0.78834642762660622761f,0.61523159058062681925f,0.78645521359908576731f,
0.61764730793780386886f,0.78455659715557524159f,0.62005721176328909561f,
0.78265059616657572938f,0.62246127937414996723f,0.78073722857209448822f,
0.62485948814238634341f,0.77881651238147597827f,0.62725181549514408275f,
0.77688846567323244230f,0.62963823891492698426f,0.77495310659487393057f,
0.63201873593980906207f,0.77301045336273699338f,0.63439328416364548779f,
0.77106052426181381776f,0.63676186123628419899f,0.76910333764557969882f,
0.63912444486377573138f,0.76713891193582040007f,0.64148101280858305095f,
0.76516726562245895860f,0.64383154288979138613f,0.76318841726338138010f,
0.64617601298331628357f,0.76120238548426177871f,0.64851440102211244110f,
0.75920918897838796102f,0.65084668499638087535f,0.75720884650648456748f,
0.65317284295377675551f,0.75520137689653654700f,0.65549285299961534967f,
0.75318679904361252042f,0.65780669329707863735f,0.75116513190968636771f,
0.66011434206742047870f,0.74913639452345937020f,0.66241577759017178373f,
0.74710060598018013245f,0.66471097820334479334f,0.74505778544146594733f,
0.66699992230363747137f,0.74300795213512171866f,0.66928258834663600929f,
0.74095112535495921691f,0.67155895484701833009f,0.73888732446061511361f,
0.67382900037875603783f,0.73681656887736979300f,0.67609270357531592310f,
0.73473887809596349907f,0.67835004312986146857f,0.73265427167241281570f,
0.68060099779545302212f,0.73056276922782759087f,0.68284554638524808112f,
0.72846439044822519637f,0.68508366777270035541f,0.72635915508434600873f,
0.68731534089175905233f,0.72424708295146700276f,0.68954054473706682948f,
0.72212819392921534511f,0.69175925836415774750f,0.72000250796138165477f,
0.69397146088965389055f,0.71787004505573170920f,0.69617713149146298601f,
0.71573082528381870571f,0.69837624940897280457f,0.71358486878079352422f,
0.70056879394324833576f,0.71143219574521643356f,0.70275474445722529993f,
0.70927282643886568891f,0.70493408037590488124f,0.70710678118654757274f,
0.70710678118654757274f,0.70493408037590499227f,0.70927282643886568891f,
0.70275474445722529993f,0.71143219574521643356f,0.70056879394324844679f,
0.71358486878079352422f,0.69837624940897291559f,0.71573082528381859468f,
0.69617713149146298601f,0.71787004505573170920f,0.69397146088965400157f,
0.72000250796138165477f,0.69175925836415774750f,0.72212819392921534511f,
0.68954054473706694051f,0.72424708295146689174f,0.68731534089175905233f,
0.72635915508434600873f,0.68508366777270035541f,0.72846439044822519637f,
0.68284554638524808112f,0.73056276922782759087f,0.68060099779545302212f,
0.73265427167241281570f,0.67835004312986146857f,0.73473887809596349907f,
0.67609270357531603413f,0.73681656887736979300f,0.67382900037875614885f,
0.73888732446061511361f,0.67155895484701833009f,0.74095112535495910588f,
0.66928258834663600929f,0.74300795213512171866f,0.66699992230363747137f,
0.74505778544146594733f,0.66471097820334490436f,0.74710060598018013245f,
0.66241577759017178373f,0.74913639452345925918f,0.66011434206742047870f,
0.75116513190968636771f,0.65780669329707874837f,0.75318679904361252042f,
0.65549285299961546070f,0.75520137689653654700f,0.65317284295377686654f,
0.75720884650648456748f,0.65084668499638098638f,0.75920918897838796102f,
0.64851440102211255212f,0.76120238548426177871f,0.64617601298331639459f,
0.76318841726338126907f,0.64383154288979149715f,0.76516726562245895860f,
0.64148101280858316198f,0.76713891193582040007f,0.63912444486377573138f,
0.76910333764557958780f,0.63676186123628419899f,0.77106052426181381776f,
0.63439328416364548779f,0.77301045336273688235f,0.63201873593980906207f,
0.77495310659487381955f,0.62963823891492709528f,0.77688846567323244230f,
0.62725181549514419377f,0.77881651238147586724f,0.62485948814238645443f,
0.78073722857209448822f,0.62246127937415007825f,0.78265059616657572938f,
0.62005721176328920663f,0.78455659715557524159f,0.61764730793780397988f,
0.78645521359908576731f,0.61523159058062681925f,0.78834642762660622761f,
0.61281008242940970820f,0.79023022143731003197f,0.61038280627630947528f,
0.79210657730021227785f,0.60794978496777374311f,0.79397547755433717231f,
0.60551104140432554512f,0.79583690460888345530f,0.60306659854034827539f,
0.79769084094339104407f,0.60061647938386897305f,0.79953726910790501314f,
0.59816070699634238395f,0.80137617172314012937f,0.59569930449243346793f,
0.80320753148064483184f,0.59323229503979979516f,0.80503133114296365758f,
0.59075970185887427544f,0.80684755354379922299f,0.58828154822264533408f,
0.80865618158817498262f,0.58579785745643886408f,0.81045719825259476821f,
0.58330865293769829094f,0.81225058658520388200f,0.58081395809576452649f,
0.81403632970594830276f,0.57831379641165558958f,0.81581441080673378075f,
0.57580819141784533866f,0.81758481315158371139f,0.57329716669804231532f,
0.81934752007679689800f,0.57078074588696736669f,0.82110251499110464835f,
0.56825895267013148970f,0.82284978137582631685f,0.56573181078361323149f,
0.82458930278502529099f,0.56319934401383409117f,0.82632106284566353427f,
0.56066157619733603124f,0.82804504525775579626f,0.55811853122055610221f,
0.82976123379452304540f,0.55557023301960228867f,0.83146961230254523567f,
0.55301670558002757883f,0.83317016470191318511f,0.55045797293660481131f,
0.83486287498638001026f,0.54789405917310018967f,0.83654772722351189440f,
0.54532498842204646383f,0.83822470555483796772f,0.54275078486451600046f,
0.83989379419599941023f,0.54017147272989296525f,0.84155497743689833268f,
0.53758707629564550512f,0.84320823964184543620f,0.53499761988709726435f,
0.84485356524970700587f,0.53240312787719801246f,0.84649093877405212627f,
0.52980362468629482731f,0.84812034480329712149f,0.52719913478190139067f,
0.84974176800085243766f,0.52458968267846883826f,0.85135519310526519554f,
0.52197529293715438925f,0.85296060493036363059f,0.51935599016558953167f,
0.85455798836540053376f,0.51673179901764998423f,0.85614732837519447184f,
0.51410274419322166128f,0.85772861000027211809f,0.51146885043797052361f,
0.85930181835700836235f,0.50883014254310698909f,0.86086693863776730939f,
0.50618664534515533937f,0.86242395611104050168f,0.50353838372571757542f,
0.86397285612158669643f,0.50088538261124093687f,0.86551362409056897818f,
0.49822766697278186854f,0.86704624551569264845f,0.49556526182577248507f,
0.86857070597134089507f,0.49289819222978409341f,0.87008699110871134952f,
0.49022648328829110387f,0.87159508665595109012f,0.48755016014843605143f,
0.87309497841829009079f,0.48486924800079111986f,0.87458665227817611321f,
0.48218377207912282989f,0.87607009419540660122f,0.47949375766015300826f,
0.87754529020726124156f,0.47679923006332225466f,0.87901222642863341417f,
0.47410021465055002254f,0.88047088905216075450f,0.47139673682599780857f,
0.88192126434835493853f,0.46868882203582795665f,0.88336333866573157891f,
0.46597649576796612569f,0.88479709843093778954f,0.46325978355186026025f,
0.88622253014888063838f,0.46053871095824000514f,0.88763962040285393496f,
0.45781330359887728587f,0.88904835585466457371f,0.45508358712634383592f,
0.89044872324475787817f,0.45234958723377099998f,0.89184070939234272313f,
0.44961132965460659516f,0.89322430119551532446f,0.44686884016237432560f,
0.89459948563138258493f,0.44412214457042925586f,0.89596624975618510689f,
0.44137126873171661501f,0.89732458070541831763f,0.43861623853852771404f,
0.89867446569395381673f,0.43585707992225547480f,0.90001589201616027935f,
0.43309381885315201277f,0.90134884704602202810f,0.43032648134008261165f,
0.90267331823725882600f,0.42755509343028219593f,0.90398929312344333820f,
0.42477968120910880589f,0.90529675931811881551f,0.42200027079979979261f,
0.90659570451491533483f,0.41921688836322396066f,0.90788611648766626150f,
0.41642956009763731906f,0.90916798309052226923f,0.41363831223843455787f,
0.91044129225806713634f,0.41084317105790391089f,0.91170603200542987832f,
0.40804416286497874333f,0.91296219042839810154f,0.40524131400498986100f,
0.91420975570353069095f,0.40243465085941854120f,0.91544871608826783316f,
0.39962419984564678810f,0.91667905992104270485f,0.39680998741671041907f,
0.91790077562139038569f,0.39399204006104809883f,0.91911385169005777040f,
0.39117038430225398171f,0.92031827670911048322f,0.38834504669882630168f,
0.92151403934204190183f,0.38551605384391901543f,0.92270112833387851747f,
0.38268343236508983729f,0.92387953251128673848f,0.37984720892405110515f,
0.92504924078267758425f,0.37700741021641831496f,0.92621024213831126826f,
0.37416406297145798909f,0.92736252565040111495f,0.37131719395183759858f,
0.92850608047321558924f,0.36846682995337232125f,0.92964089584318121418f,
0.36561299780477396482f,0.93076696107898371224f,0.36275572436739722537f,
0.93188426558166814750f,0.35989503653498827740f,0.93299279883473884567f,
0.35703096123343003310f,0.93409255040425887007f,0.35416352542049051033f,
0.93518350993894749923f,0.35129275608556714827f,0.93626566717027825959f,
0.34841868024943450921f,0.93733901191257495977f,0.34554132496398914931f,
0.93840353406310805795f,0.34266071731199437833f,0.93945922360218991898f,
0.33977688440682696225f,0.94050607059326829518f,0.33688985339222005111f,
0.94154406518302080631f,0.33399965144200949307f,0.94257319760144686605f,
0.33110630575987642921f,0.94359345816196038559f,0.32820984357909266382f,
0.94460483726148025685f,0.32531029216226298173f,0.94560732538052127971f,
0.32240767880107001897f,0.94660091308328353499f,0.31950203081601574739f,
0.94758559101774109124f,0.31659337555616584581f,0.94856134991573026749f,
0.31368174039889157312f,0.94952818059303667475f,0.31076715274961147495f,
0.95048607394948170235f,0.30784964004153497763f,0.95143502096900833820f,
0.30492922973540242948f,0.95237501271976587880f,0.30200594931922819519f,
0.95330604035419375109f,0.29907982630804047508f,0.95422809510910566733f,
0.29615088824362395536f,0.95514116830577067141f,0.29321916269425868373f,
0.95604525134999640557f,0.29028467725446233105f,0.95694033573220893540f,
0.28734745954472956653f,0.95782641302753290802f,0.28440753721127182141f,
0.95870347489587159906f,0.28146493792575805193f,0.95957151308198451733f,
0.27851968938505305973f,0.96043051941556578655f,0.27557181931095825478f,
0.96128048581132063966f,0.27262135544994897662f,0.96212140426904158019f,
0.26966832557291520178f,0.96295326687368387741f,0.26671275747489842090f,
0.96377606579543984022f,0.26375467897483151347f,0.96458979328981264700f,
0.26079411791527556952f,0.96539444169768939830f,0.25783110216215893162f,
0.96619000344541261516f,0.25486565960451462720f,0.96697647104485207059f,
0.25189781815421691258f,0.96775383709347551076f,0.24892760574572025956f,
0.96852209427441726675f,0.24595505033579459497f,0.96928123535654853171f,
0.24298017990326398197f,0.97003125319454397424f,0.24000302244874149871f,
0.97077214072895035013f,0.23702360599436733679f,0.97150389098625178352f,
0.23404195858354345794f,0.97222649707893626925f,0.23105810828067127605f,
0.97293995220556006576f,0.22807208317088578653f,0.97364424965081186603f,
0.22508391135979277653f,0.97433938278557585821f,0.22209362097320359264f,
0.97502534506699412020f,0.21910124015686976984f,0.97570213003852857003f,
0.21610679707621960333f,0.97636973133002114000f,0.21311031991609136194f,
0.97702814265775439484f,0.21011183688046972118f,0.97767735782450992943f,
0.20711137619221856032f,0.97831737071962765473f,0.20410896609281700687f,
0.97894817531906219710f,0.20110463484209195606f,0.97956976568544051887f,
0.19809841071795372680f,0.98018213596811731847f,0.19509032201612833135f,
0.98078528040323043058f,0.19208039704989238183f,0.98137919331375456089f,
0.18906866414980627589f,0.98196386910955524296f,0.18605515166344663291f,
0.98253930228744124076f,0.18303988795514106180f,0.98310548743121628501f,
0.18002290140569951471f,0.98366241921173025453f,0.17700422041214886049f,
0.98421009238692902521f,0.17398387338746384989f,0.98474850180190420801f,
0.17096188876030135595f,0.98527764238894122162f,0.16793829497473122814f,
0.98579750916756736512f,0.16491312048997008866f,0.98630809724459866938f,
0.16188639378011188130f,0.98680940181418541624f,0.15885814333386139019f,
0.98730141815785843473f,0.15582839765426531597f,0.98778414164457217783f,
0.15279718525844340760f,0.98825756773074946437f,0.14976453467732162017f,
0.98872169196032377858f,0.14673047445536174793f,0.98917650996478101444f,
0.14369503315029458212f,0.98962201746320077600f,0.14065823933284923863f,
0.99005821026229712256f,0.13762012158648617710f,0.99048508425645698239f,
0.13458070850712622324f,0.99090263542778000971f,0.13154002870288328264f,
0.99131085984611544415f,0.12849811079379322432f,0.99170975366909952520f,
0.12545498341154620592f,0.99209931314219179654f,0.12241067519921627893f,
0.99247953459870996706f,0.11936521481099135467f,0.99285041445986510489f,
0.11631863091190487725f,0.99321194923479450001f,0.11327095217756436019f,
0.99356413552059530403f,0.11022220729388318428f,0.99390697000235606051f,
0.10717242495680887049f,0.99424044945318790223f,0.10412163387205472520f,
0.99456457073425541537f,0.10106986275482787718f,0.99487933079480561638f,
0.09801714032956077016f,0.99518472667219681771f,0.09496349532963906104f,
0.99548075549192693856f,0.09190895649713269611f,0.99576741446765981713f,
0.08885355258252468358f,0.99604470090125196702f,0.08579731234443987997f,
0.99631261218277800129f,0.08274026454937580266f,0.99657114579055483539f,
0.07968243797143012563f,0.99682029929116566791f,0.07662386139203161695f,
0.99706007033948296225f,0.07356456359966745406f,0.99729045667869020697f,
0.07050457338961400866f,0.99751145614030345410f,0.06744391956366410645f,
0.99772306664419163624f,0.06438263092985740954f,0.99792528619859599548f,
0.06132073630220864768f,0.99811811290014917919f,0.05825826450043573163f,
0.99830154493389289261f,0.05519524434969003135f,0.99847558057329477421f,
0.05213170468028331672f,0.99864021818026527111f,0.04906767432741812596f,
0.99879545620517240501f,0.04600318213091464381f,0.99894129318685687124f,
0.04293825693494095902f,0.99907772775264536147f,0.03987292758773984536f,
0.99920475861836388631f,0.03680722294135899131f,0.99932238458834954375f,
0.03374117185137764235f,0.99943060455546173237f,0.03067480317663658085f,
0.99952941750109314256f,0.02760814577896581953f,0.99961882249517863830f,
0.02454122852291226384f,0.99969881869620424997f,0.02147408027546960502f,
0.99976940535121527898f,0.01840672990580482019f,0.99983058179582340319f,
0.01533920628498821985f,0.99988234745421256111f,0.01227153828571994447f,
0.99992470183914450299f,0.00920375478205995995f,0.99995764455196389786f,
0.00613588464915451517f,0.99998117528260110909f,0.00306795676296613791f,
0.99999529380957619118f,0.00000000000000006123f,1.00000000000000000000f,
-0.00306795676296601561f,0.99999529380957619118f,-0.00613588464915439287f,
0.99998117528260110909f,-0.00920375478205983678f,0.99995764455196389786f,
-0.01227153828571982304f,0.99992470183914450299f,-0.01533920628498809842f,
0.99988234745421256111f,-0.01840672990580469529f,0.99983058179582340319f,
-0.02147408027546948359f,0.99976940535121527898f,-0.02454122852291214241f,
0.99969881869620424997f,-0.02760814577896569810f,0.99961882249517863830f,
-0.03067480317663645942f,0.99952941750109314256f,-0.03374117185137751745f,
0.99943060455546173237f,-0.03680722294135886641f,0.99932238458834954375f,
-0.03987292758773972740f,0.99920475861836388631f,-0.04293825693494083412f,
0.99907772775264536147f,-0.04600318213091451891f,0.99894129318685687124f,
-0.04906767432741800800f,0.99879545620517240501f,-0.05213170468028319182f,
0.99864021818026527111f,-0.05519524434968991339f,0.99847558057329477421f,
-0.05825826450043560673f,0.99830154493389289261f,-0.06132073630220852972f,
0.99811811290014917919f,-0.06438263092985728464f,0.99792528619859599548f,
-0.06744391956366398155f,0.99772306664419163624f,-0.07050457338961389764f,
0.99751145614030345410f,-0.07356456359966732916f,0.99729045667869020697f,
-0.07662386139203150592f,0.99706007033948296225f,-0.07968243797143001461f,
0.99682029929116577893f,-0.08274026454937567776f,0.99657114579055483539f,
-0.08579731234443975507f,0.99631261218277800129f,-0.08885355258252455868f,
0.99604470090125196702f,-0.09190895649713257121f,0.99576741446765981713f,
-0.09496349532963895002f,0.99548075549192693856f,-0.09801714032956064526f,
0.99518472667219692873f,-0.10106986275482775228f,0.99487933079480561638f,
-0.10412163387205460030f,0.99456457073425541537f,-0.10717242495680875947f,
0.99424044945318790223f,-0.11022220729388305938f,0.99390697000235606051f,
-0.11327095217756423529f,0.99356413552059530403f,-0.11631863091190475235f,
0.99321194923479450001f,-0.11936521481099122977f,0.99285041445986510489f,
-0.12241067519921615403f,0.99247953459870996706f,-0.12545498341154606714f,
0.99209931314219179654f,-0.12849811079379311329f,0.99170975366909952520f,
-0.13154002870288314386f,0.99131085984611544415f,-0.13458070850712611222f,
0.99090263542778000971f,-0.13762012158648606608f,0.99048508425645698239f,
-0.14065823933284912761f,0.99005821026229712256f,-0.14369503315029444335f,
0.98962201746320088702f,-0.14673047445536163691f,0.98917650996478101444f,
-0.14976453467732150915f,0.98872169196032377858f,-0.15279718525844329657f,
0.98825756773074946437f,-0.15582839765426520495f,0.98778414164457217783f,
-0.15885814333386127917f,0.98730141815785843473f,-0.16188639378011177028f,
0.98680940181418552726f,-0.16491312048996994988f,0.98630809724459866938f,
-0.16793829497473108936f,0.98579750916756747614f,-0.17096188876030124493f,
0.98527764238894122162f,-0.17398387338746371111f,0.98474850180190420801f,
-0.17700422041214874946f,0.98421009238692902521f,-0.18002290140569940369f,
0.98366241921173025453f,-0.18303988795514092303f,0.98310548743121628501f,
-0.18605515166344649414f,0.98253930228744124076f,-0.18906866414980616486f,
0.98196386910955524296f,-0.19208039704989227081f,0.98137919331375456089f,
-0.19509032201612819257f,0.98078528040323043058f,-0.19809841071795361578f,
0.98018213596811742949f,-0.20110463484209181728f,0.97956976568544051887f,
-0.20410896609281689584f,0.97894817531906219710f,-0.20711137619221844930f,
0.97831737071962765473f,-0.21011183688046961016f,0.97767735782450992943f,
-0.21311031991609125091f,0.97702814265775439484f,-0.21610679707621949230f,
0.97636973133002114000f,-0.21910124015686965881f,0.97570213003852857003f,
-0.22209362097320348162f,0.97502534506699412020f,-0.22508391135979266551f,
0.97433938278557585821f,-0.22807208317088567551f,0.97364424965081197705f,
-0.23105810828067113727f,0.97293995220556017678f,-0.23404195858354331916f,
0.97222649707893638027f,-0.23702360599436722577f,0.97150389098625178352f,
-0.24000302244874138768f,0.97077214072895035013f,-0.24298017990326387094f,
0.97003125319454397424f,-0.24595505033579448395f,0.96928123535654853171f,
-0.24892760574572012078f,0.96852209427441737777f,-0.25189781815421680156f,
0.96775383709347551076f,-0.25486565960451451618f,0.96697647104485207059f,
-0.25783110216215882060f,0.96619000344541261516f,-0.26079411791527545850f,
0.96539444169768939830f,-0.26375467897483140245f,0.96458979328981275803f,
-0.26671275747489830987f,0.96377606579543984022f,-0.26966832557291509076f,
0.96295326687368387741f,-0.27262135544994886560f,0.96212140426904158019f,
-0.27557181931095814376f,0.96128048581132063966f,-0.27851968938505294870f,
0.96043051941556589757f,-0.28146493792575794091f,0.95957151308198451733f,
-0.28440753721127171039f,0.95870347489587159906f,-0.28734745954472945551f,
0.95782641302753290802f,-0.29028467725446216452f,0.95694033573220893540f,
-0.29321916269425857271f,0.95604525134999651659f,-0.29615088824362384434f,
0.95514116830577067141f,-0.29907982630804036406f,0.95422809510910566733f,
-0.30200594931922808417f,0.95330604035419386211f,-0.30492922973540226295f,
0.95237501271976587880f,-0.30784964004153486661f,0.95143502096900833820f,
-0.31076715274961136393f,0.95048607394948181337f,-0.31368174039889140658f,
0.94952818059303667475f,-0.31659337555616573479f,0.94856134991573037851f,
-0.31950203081601563637f,0.94758559101774120226f,-0.32240767880106985244f,
0.94660091308328353499f,-0.32531029216226287071f,0.94560732538052139073f,
-0.32820984357909255280f,0.94460483726148025685f,-0.33110630575987631818f,
0.94359345816196038559f,-0.33399965144200938205f,0.94257319760144686605f,
-0.33688985339221994009f,0.94154406518302080631f,-0.33977688440682685123f,
0.94050607059326829518f,-0.34266071731199426731f,0.93945922360218991898f,
-0.34554132496398903829f,0.93840353406310816897f,-0.34841868024943439819f,
0.93733901191257495977f,-0.35129275608556703725f,0.93626566717027825959f,
-0.35416352542049039931f,0.93518350993894761025f,-0.35703096123342992207f,
0.93409255040425898109f,-0.35989503653498816638f,0.93299279883473884567f,
-0.36275572436739711435f,0.93188426558166814750f,-0.36561299780477385379f,
0.93076696107898371224f,-0.36846682995337221023f,0.92964089584318132520f,
-0.37131719395183748755f,0.92850608047321558924f,-0.37416406297145787807f,
0.92736252565040111495f,-0.37700741021641820394f,0.92621024213831137928f,
-0.37984720892405099413f,0.92504924078267769527f,-0.38268343236508972627f,
0.92387953251128673848f,-0.38551605384391890441f,0.92270112833387851747f,
-0.38834504669882619066f,0.92151403934204201285f,-0.39117038430225387069f,
0.92031827670911059425f,-0.39399204006104798781f,0.91911385169005777040f,
-0.39680998741671030805f,0.91790077562139049672f,-0.39962419984564667708f,
0.91667905992104270485f,-0.40243465085941843018f,0.91544871608826783316f,
-0.40524131400498974998f,0.91420975570353069095f,-0.40804416286497863231f,
0.91296219042839821256f,-0.41084317105790379987f,0.91170603200542987832f,
-0.41363831223843450235f,0.91044129225806724737f,-0.41642956009763698599f,
0.90916798309052249127f,-0.41921688836322407168f,0.90788611648766615048f,
-0.42200027079979968159f,0.90659570451491533483f,-0.42477968120910869487f,
0.90529675931811881551f,-0.42755509343028186287f,0.90398929312344344922f,
-0.43032648134008272267f,0.90267331823725871498f,-0.43309381885315190175f,
0.90134884704602202810f,-0.43585707992225536378f,0.90001589201616027935f,
-0.43861623853852738097f,0.89867446569395392775f,-0.44137126873171672603f,
0.89732458070541831763f,-0.44412214457042914484f,0.89596624975618521791f,
-0.44686884016237399253f,0.89459948563138280697f,-0.44961132965460670619f,
0.89322430119551521344f,-0.45234958723377088896f,0.89184070939234272313f,
-0.45508358712634372489f,0.89044872324475798919f,-0.45781330359887700832f,
0.88904835585466468473f,-0.46053871095824006066f,0.88763962040285393496f,
-0.46325978355186014923f,0.88622253014888063838f,-0.46597649576796601467f,
0.88479709843093790056f,-0.46868882203582767909f,0.88336333866573168994f,
-0.47139673682599769755f,0.88192126434835504956f,-0.47410021465054991152f,
0.88047088905216086552f,-0.47679923006332192159f,0.87901222642863352519f,
-0.47949375766015311928f,0.87754529020726124156f,-0.48218377207912271887f,
0.87607009419540660122f,-0.48486924800079100883f,0.87458665227817622423f,
-0.48755016014843571837f,0.87309497841829020182f,-0.49022648328829121489f,
0.87159508665595097909f,-0.49289819222978398239f,0.87008699110871146054f,
-0.49556526182577237405f,0.86857070597134100609f,-0.49822766697278159098f,
0.86704624551569275948f,-0.50088538261124082585f,0.86551362409056908920f,
-0.50353838372571746440f,0.86397285612158680745f,-0.50618664534515511733f,
0.86242395611104061270f,-0.50883014254310710012f,0.86086693863776719837f,
-0.51146885043797041259f,0.85930181835700847337f,-0.51410274419322155026f,
0.85772861000027211809f,-0.51673179901764965116f,0.85614732837519458286f,
-0.51935599016558964269f,0.85455798836540053376f,-0.52197529293715427823f,
0.85296060493036374162f,-0.52458968267846872724f,0.85135519310526519554f,
-0.52719913478190105760f,0.84974176800085265970f,-0.52980362468629471628f,
0.84812034480329723252f,-0.53240312787719790144f,0.84649093877405212627f,
-0.53499761988709704230f,0.84485356524970722791f,-0.53758707629564561614f,
0.84320823964184532517f,-0.54017147272989285423f,0.84155497743689844370f,
-0.54275078486451577842f,0.83989379419599952126f,-0.54532498842204624179f,
0.83822470555483818977f,-0.54789405917310018967f,0.83654772722351200542f,
-0.55045797293660470029f,0.83486287498638012128f,-0.55301670558002735678f,
0.83317016470191329613f,-0.55557023301960195560f,0.83146961230254534669f,
-0.55811853122055610221f,0.82976123379452304540f,-0.56066157619733592021f,
0.82804504525775579626f,-0.56319934401383386913f,0.82632106284566364529f,
-0.56573181078361323149f,0.82458930278502517996f,-0.56825895267013148970f,
0.82284978137582631685f,-0.57078074588696714464f,0.82110251499110475937f,
-0.57329716669804198226f,0.81934752007679712005f,-0.57580819141784533866f,
0.81758481315158371139f,-0.57831379641165547856f,0.81581441080673378075f,
-0.58081395809576441547f,0.81403632970594852480f,-0.58330865293769840196f,
0.81225058658520388200f,-0.58579785745643886408f,0.81045719825259476821f,
-0.58828154822264522306f,0.80865618158817509364f,-0.59075970185887405339f,
0.80684755354379944503f,-0.59323229503979990618f,0.80503133114296354655f,
-0.59569930449243335691f,0.80320753148064494287f,-0.59816070699634216190f,
0.80137617172314024039f,-0.60061647938386875101f,0.79953726910790523519f,
-0.60306659854034827539f,0.79769084094339104407f,-0.60551104140432543410f,
0.79583690460888356633f,-0.60794978496777352106f,0.79397547755433728334f,
-0.61038280627630958630f,0.79210657730021227785f,-0.61281008242940970820f,
0.79023022143731003197f,-0.61523159058062670823f,0.78834642762660633863f,
-0.61764730793780375784f,0.78645521359908587833f,-0.62005721176328920663f,
0.78455659715557513056f,-0.62246127937414996723f,0.78265059616657572938f,
-0.62485948814238623239f,0.78073722857209459924f,-0.62725181549514386070f,
0.77881651238147608929f,-0.62963823891492709528f,0.77688846567323244230f,
-0.63201873593980895105f,0.77495310659487393057f,-0.63439328416364537677f,
0.77301045336273710440f,-0.63676186123628431002f,0.77106052426181370674f,
-0.63912444486377573138f,0.76910333764557958780f,-0.64148101280858305095f,
0.76713891193582040007f,-0.64383154288979127511f,0.76516726562245906962f,
-0.64617601298331639459f,0.76318841726338115805f,-0.64851440102211244110f,
0.76120238548426188974f,-0.65084668499638076433f,0.75920918897838807204f,
-0.65317284295377653347f,0.75720884650648467851f,-0.65549285299961546070f,
0.75520137689653643598f,-0.65780669329707852633f,0.75318679904361252042f,
-0.66011434206742036768f,0.75116513190968658975f,-0.66241577759017189475f,
0.74913639452345925918f,-0.66471097820334490436f,0.74710060598018013245f,
-0.66699992230363736034f,0.74505778544146605835f,-0.66928258834663589827f,
0.74300795213512182968f,-0.67155895484701844111f,0.74095112535495899486f,
-0.67382900037875603783f,0.73888732446061522463f,-0.67609270357531581208f,
0.73681656887737001504f,-0.67835004312986124653f,0.73473887809596372112f,
-0.68060099779545302212f,0.73265427167241281570f,-0.68284554638524797010f,
0.73056276922782759087f,-0.68508366777270024439f,0.72846439044822530740f,
-0.68731534089175916336f,0.72635915508434589771f,-0.68954054473706694051f,
0.72424708295146689174f,-0.69175925836415763648f,0.72212819392921545614f,
-0.69397146088965377952f,0.72000250796138176579f,-0.69617713149146298601f,
0.71787004505573170920f,-0.69837624940897280457f,0.71573082528381870571f,
-0.70056879394324822474f,0.71358486878079363525f,-0.70275474445722507788f,
0.71143219574521665560f,-0.70493408037590488124f,0.70927282643886557789f,
-0.70710678118654746172f,0.70710678118654757274f,-0.70927282643886546687f,
0.70493408037590510329f,-0.71143219574521654458f,0.70275474445722518890f,
-0.71358486878079352422f,0.70056879394324833576f,-0.71573082528381859468f,
0.69837624940897291559f,-0.71787004505573159818f,0.69617713149146309703f,
-0.72000250796138165477f,0.69397146088965389055f,-0.72212819392921523409f,
0.69175925836415785852f,-0.72424708295146678072f,0.68954054473706705153f,
-0.72635915508434578669f,0.68731534089175927438f,-0.72846439044822519637f,
0.68508366777270035541f,-0.73056276922782747985f,0.68284554638524808112f,
-0.73265427167241270467f,0.68060099779545324417f,-0.73473887809596349907f,
0.67835004312986135755f,-0.73681656887736979300f,0.67609270357531592310f,
-0.73888732446061511361f,0.67382900037875614885f,-0.74095112535495888384f,
0.67155895484701855214f,-0.74300795213512171866f,0.66928258834663600929f,
-0.74505778544146594733f,0.66699992230363758239f,-0.74710060598018002143f,
0.66471097820334501538f,-0.74913639452345914815f,0.66241577759017200577f,
-0.75116513190968636771f,0.66011434206742047870f,-0.75318679904361240940f,
0.65780669329707874837f,-0.75520137689653643598f,0.65549285299961557172f,
-0.75720884650648467851f,0.65317284295377664449f,-0.75920918897838796102f,
0.65084668499638098638f,-0.76120238548426166769f,0.64851440102211255212f,
-0.76318841726338115805f,0.64617601298331661663f,-0.76516726562245895860f,
0.64383154288979138613f,-0.76713891193582040007f,0.64148101280858316198f,
-0.76910333764557947678f,0.63912444486377584241f,-0.77106052426181359571f,
0.63676186123628442104f,-0.77301045336273699338f,0.63439328416364548779f,
-0.77495310659487381955f,0.63201873593980906207f,-0.77688846567323233128f,
0.62963823891492720630f,-0.77881651238147597827f,0.62725181549514408275f,
-0.78073722857209448822f,0.62485948814238634341f,-0.78265059616657561836f,
0.62246127937415007825f,-0.78455659715557501954f,0.62005721176328942867f,
-0.78645521359908576731f,0.61764730793780386886f,-0.78834642762660622761f,
0.61523159058062693028f,-0.79023022143730992095f,0.61281008242940981923f,
-0.79210657730021216683f,0.61038280627630969732f,-0.79397547755433717231f,
0.60794978496777363208f,-0.79583690460888345530f,0.60551104140432565615f,
-0.79769084094339093305f,0.60306659854034838641f,-0.79953726910790512417f,
0.60061647938386886203f,-0.80137617172314024039f,0.59816070699634238395f,
-0.80320753148064483184f,0.59569930449243346793f,-0.80503133114296343553f,
0.59323229503980001720f,-0.80684755354379933401f,0.59075970185887416442f,
-0.80865618158817498262f,0.58828154822264533408f,-0.81045719825259465718f,
0.58579785745643897510f,-0.81225058658520377097f,0.58330865293769851299f,
-0.81403632970594841378f,0.58081395809576452649f,-0.81581441080673378075f,
0.57831379641165570060f,-0.81758481315158360037f,0.57580819141784544968f,
-0.81934752007679700903f,0.57329716669804209328f,-0.82110251499110464835f,
0.57078074588696725566f,-0.82284978137582620583f,0.56825895267013171175f,
-0.82458930278502506894f,0.56573181078361345353f,-0.82632106284566353427f,
0.56319934401383409117f,-0.82804504525775568524f,0.56066157619733614226f,
-0.82976123379452293438f,0.55811853122055632426f,-0.83146961230254534669f,
0.55557023301960217765f,-0.83317016470191318511f,0.55301670558002746780f,
-0.83486287498638001026f,0.55045797293660492233f,-0.83654772722351189440f,
0.54789405917310041172f,-0.83822470555483807875f,0.54532498842204635281f,
-0.83989379419599952126f,0.54275078486451588944f,-0.84155497743689833268f,
0.54017147272989296525f,-0.84320823964184532517f,0.53758707629564572716f,
-0.84485356524970711689f,0.53499761988709715332f,-0.84649093877405201525f,
0.53240312787719801246f,-0.84812034480329712149f,0.52980362468629482731f,
-0.84974176800085254868f,0.52719913478190127964f,-0.85135519310526519554f,
0.52458968267846894928f,-0.85296060493036363059f,0.52197529293715438925f,
-0.85455798836540042274f,0.51935599016558975372f,-0.85614732837519447184f,
0.51673179901764976218f,-0.85772861000027200706f,0.51410274419322177231f,
-0.85930181835700836235f,0.51146885043797052361f,-0.86086693863776719837f,
0.50883014254310732216f,-0.86242395611104050168f,0.50618664534515522835f,
-0.86397285612158669643f,0.50353838372571757542f,-0.86551362409056897818f,
0.50088538261124093687f,-0.86704624551569264845f,0.49822766697278175752f,
-0.86857070597134089507f,0.49556526182577254058f,-0.87008699110871134952f,
0.49289819222978414892f,-0.87159508665595086807f,0.49022648328829138142f,
-0.87309497841829009079f,0.48755016014843588490f,-0.87458665227817611321f,
0.48486924800079111986f,-0.87607009419540649020f,0.48218377207912288540f,
-0.87754529020726113053f,0.47949375766015328582f,-0.87901222642863352519f,
0.47679923006332208812f,-0.88047088905216075450f,0.47410021465055007805f,
-0.88192126434835493853f,0.47139673682599780857f,-0.88336333866573168994f,
0.46868882203582784562f,-0.88479709843093778954f,0.46597649576796618121f,
-0.88622253014888052736f,0.46325978355186031576f,-0.88763962040285382393f,
0.46053871095824022719f,-0.88904835585466457371f,0.45781330359887717485f,
-0.89044872324475787817f,0.45508358712634389143f,-0.89184070939234261211f,
0.45234958723377105549f,-0.89322430119551521344f,0.44961132965460687272f,
-0.89459948563138269595f,0.44686884016237415906f,-0.89596624975618510689f,
0.44412214457042931137f,-0.89732458070541820661f,0.44137126873171689256f,
-0.89867446569395392775f,0.43861623853852754751f,-0.90001589201616016833f,
0.43585707992225553031f,-0.90134884704602191707f,0.43309381885315206828f,
-0.90267331823725871498f,0.43032648134008288920f,-0.90398929312344333820f,
0.42755509343028202940f,-0.90529675931811870448f,0.42477968120910886141f,
-0.90659570451491533483f,0.42200027079979984812f,-0.90788611648766603945f,
0.41921688836322423821f,-0.90916798309052238025f,0.41642956009763715253f,
-0.91044129225806713634f,0.41363831223843466889f,-0.91170603200542976730f,
0.41084317105790413294f,-0.91296219042839821256f,0.40804416286497857680f,
-0.91420975570353069095f,0.40524131400498991651f,-0.91544871608826772214f,
0.40243465085941859671f,-0.91667905992104259383f,0.39962419984564706565f,
-0.91790077562139049672f,0.39680998741671025254f,-0.91911385169005777040f,
0.39399204006104815434f,-0.92031827670911048322f,0.39117038430225403722f,
-0.92151403934204179080f,0.38834504669882657923f,-0.92270112833387862850f,
0.38551605384391884890f,-0.92387953251128673848f,0.38268343236508989280f,
-0.92504924078267747323f,0.37984720892405138271f,-0.92621024213831137928f,
0.37700741021641814843f,-0.92736252565040111495f,0.37416406297145804460f,
-0.92850608047321547822f,0.37131719395183770960f,-0.92964089584318121418f,
0.36846682995337259880f,-0.93076696107898371224f,0.36561299780477379828f,
-0.93188426558166803648f,0.36275572436739728088f,-0.93299279883473884567f,
0.35989503653498833291f,-0.93409255040425875904f,0.35703096123343031065f,
-0.93518350993894761025f,0.35416352542049039931f,-0.93626566717027825959f,
0.35129275608556720378f,-0.93733901191257484875f,0.34841868024943478677f,
-0.93840353406310816897f,0.34554132496398898278f,-0.93945922360218991898f,
0.34266071731199443384f,-0.94050607059326829518f,0.33977688440682701776f,
-0.94154406518302069529f,0.33688985339222032867f,-0.94257319760144686605f,
0.33399965144200938205f,-0.94359345816196038559f,0.33110630575987648472f,
-0.94460483726148014583f,0.32820984357909271933f,-0.94560732538052116869f,
0.32531029216226325929f,-0.94660091308328353499f,0.32240767880106985244f,
-0.94758559101774109124f,0.31950203081601580291f,-0.94856134991573026749f,
0.31659337555616606785f,-0.94952818059303667475f,0.31368174039889140658f,
-0.95048607394948170235f,0.31076715274961153046f,-0.95143502096900833820f,
0.30784964004153503314f,-0.95237501271976576778f,0.30492922973540265152f,
-0.95330604035419386211f,0.30200594931922802866f,-0.95422809510910555630f,
0.29907982630804053059f,-0.95514116830577067141f,0.29615088824362401088f,
-0.95604525134999629454f,0.29321916269425896129f,-0.95694033573220882438f,
0.29028467725446238656f,-0.95782641302753290802f,0.28734745954472962204f,
-0.95870347489587148804f,0.28440753721127209896f,-0.95957151308198451733f,
0.28146493792575788540f,-0.96043051941556578655f,0.27851968938505317075f,
-0.96128048581132063966f,0.27557181931095831029f,-0.96212140426904146917f,
0.27262135544994925418f,-0.96295326687368387741f,0.26966832557291509076f,
-0.96377606579543984022f,0.26671275747489847641f,-0.96458979328981264700f,
0.26375467897483156898f,-0.96539444169768928727f,0.26079411791527584707f,
-0.96619000344541250413f,0.25783110216215898713f,-0.96697647104485207059f,
0.25486565960451468271f,-0.96775383709347539973f,0.25189781815421719013f,
-0.96852209427441737777f,0.24892760574572009302f,-0.96928123535654842069f,
0.24595505033579465048f,-0.97003125319454397424f,0.24298017990326406523f,
-0.97077214072895023911f,0.24000302244874177626f,-0.97150389098625178352f,
0.23702360599436717026f,-0.97222649707893626925f,0.23404195858354351345f,
-0.97293995220556006576f,0.23105810828067133156f,-0.97364424965081186603f,
0.22807208317088606409f,-0.97433938278557585821f,0.22508391135979283204f,
-0.97502534506699412020f,0.22209362097320364815f,-0.97570213003852845901f,
0.21910124015687004739f,-0.97636973133002114000f,0.21610679707621943679f,
-0.97702814265775439484f,0.21311031991609141745f,-0.97767735782450992943f,
0.21011183688046980444f,-0.97831737071962754371f,0.20711137619221883788f,
-0.97894817531906219710f,0.20410896609281684033f,-0.97956976568544051887f,
0.20110463484209201157f,-0.98018213596811731847f,0.19809841071795381007f,
-0.98078528040323043058f,0.19509032201612860891f,-0.98137919331375456089f,
0.19208039704989246510f,-0.98196386910955524296f,0.18906866414980635915f,
-0.98253930228744124076f,0.18605515166344691047f,-0.98310548743121628501f,
0.18303988795514089527f,-0.98366241921173025453f,0.18002290140569957022f,
-0.98421009238692902521f,0.17700422041214894375f,-0.98474850180190420801f,
0.17398387338746412745f,-0.98527764238894122162f,0.17096188876030121717f,
-0.98579750916756736512f,0.16793829497473128365f,-0.98630809724459855836f,
0.16491312048997014417f,-0.98680940181418552726f,0.16188639378011174252f,
-0.98730141815785843473f,0.15885814333386147346f,-0.98778414164457217783f,
0.15582839765426537149f,-0.98825756773074946437f,0.15279718525844368515f,
-0.98872169196032377858f,0.14976453467732145364f,-0.98917650996478101444f,
0.14673047445536180344f,-0.98962201746320077600f,0.14369503315029463764f,
-0.99005821026229701154f,0.14065823933284954395f,-0.99048508425645709341f,
0.13762012158648603832f,-0.99090263542778000971f,0.13458070850712627875f,
-0.99131085984611544415f,0.13154002870288333815f,-0.99170975366909952520f,
0.12849811079379308554f,-0.99209931314219179654f,0.12545498341154626143f,
-0.99247953459870996706f,0.12241067519921634832f,-0.99285041445986510489f,
0.11936521481099163222f,-0.99321194923479450001f,0.11631863091190471071f,
-0.99356413552059530403f,0.11327095217756441570f,-0.99390697000235606051f,
0.11022220729388323979f,-0.99424044945318790223f,0.10717242495680916192f,
-0.99456457073425541537f,0.10412163387205457254f,-0.99487933079480561638f,
0.10106986275482793269f,-0.99518472667219681771f,0.09801714032956082567f,
-0.99548075549192693856f,0.09496349532963890838f,-0.99576741446765981713f,
0.09190895649713275162f,-0.99604470090125196702f,0.08885355258252475297f,
-0.99631261218277800129f,0.08579731234444015753f,-0.99657114579055483539f,
0.08274026454937563613f,-0.99682029929116566791f,0.07968243797143019502f,
-0.99706007033948296225f,0.07662386139203168633f,-0.99729045667869020697f,
0.07356456359966773162f,-0.99751145614030345410f,0.07050457338961385600f,
-0.99772306664419163624f,0.06744391956366417584f,-0.99792528619859599548f,
0.06438263092985770097f,-0.99811811290014917919f,0.06132073630220848809f,
-0.99830154493389289261f,0.05825826450043579408f,-0.99847558057329477421f,
0.05519524434969009380f,-0.99864021818026516009f,0.05213170468028359428f,
-0.99879545620517240501f,0.04906767432741796636f,-0.99894129318685687124f,
0.04600318213091470626f,-0.99907772775264536147f,0.04293825693494102147f,
-0.99920475861836388631f,0.03987292758774012985f,-0.99932238458834954375f,
0.03680722294135883171f,-0.99943060455546173237f,0.03374117185137770480f,
-0.99952941750109314256f,0.03067480317663686534f,-0.99961882249517863830f,
0.02760814577896565994f,-0.99969881869620424997f,0.02454122852291232629f,
-0.99976940535121527898f,0.02147408027546966747f,-0.99983058179582340319f,
0.01840672990580510121f,-0.99988234745421256111f,0.01533920628498806026f,
-0.99992470183914450299f,0.01227153828572000692f,-0.99995764455196389786f,
0.00920375478206002066f,-0.99998117528260110909f,0.00613588464915479880f,
-0.99999529380957619118f,0.00306795676296597701f,1.00000000000000000000f,
0.00000000000000000000f,0.99992470183914450299f,0.01227153828571992539f,
0.99969881869620424997f,0.02454122852291228812f,0.99932238458834954375f,
0.03680722294135883171f,0.99879545620517240501f,0.04906767432741801493f,
0.99811811290014917919f,0.06132073630220857829f,0.99729045667869020697f,
0.07356456359966742631f,0.99631261218277800129f,0.08579731234443989385f,
0.99518472667219692873f,0.09801714032956060363f,0.99390697000235606051f,
0.11022220729388305938f,0.99247953459870996706f,0.12241067519921619566f,
0.99090263542778000971f,0.13458070850712616773f,0.98917650996478101444f,
0.14673047445536174793f,0.98730141815785843473f,0.15885814333386144570f,
0.98527764238894122162f,0.17096188876030121717f,0.98310548743121628501f,
0.18303988795514095078f,0.98078528040323043058f,0.19509032201612824808f,
0.97831737071962765473f,0.20711137619221856032f,0.97570213003852857003f,
0.21910124015686979759f,0.97293995220556017678f,0.23105810828067110951f,
0.97003125319454397424f,0.24298017990326387094f,0.96697647104485207059f,
0.25486565960451457169f,0.96377606579543984022f,0.26671275747489836538f,
0.96043051941556578655f,0.27851968938505305973f,0.95694033573220882438f,
0.29028467725446233105f,0.95330604035419386211f,0.30200594931922808417f,
0.94952818059303667475f,0.31368174039889151761f,0.94560732538052127971f,
0.32531029216226292622f,0.94154406518302080631f,0.33688985339222005111f,
0.93733901191257495977f,0.34841868024943456472f,0.93299279883473895669f,
0.35989503653498811087f,0.92850608047321558924f,0.37131719395183754306f,
0.92387953251128673848f,0.38268343236508978178f,0.91911385169005777040f,
0.39399204006104809883f,0.91420975570353069095f,0.40524131400498986100f,
0.90916798309052238025f,0.41642956009763715253f,0.90398929312344333820f,
0.42755509343028208491f,0.89867446569395381673f,0.43861623853852765853f,
0.89322430119551532446f,0.44961132965460653965f,0.88763962040285393496f,
0.46053871095824000514f,0.88192126434835504956f,0.47139673682599764204f,
0.87607009419540660122f,0.48218377207912271887f,0.87008699110871146054f,
0.49289819222978403790f,0.86397285612158669643f,0.50353838372571757542f,
0.85772861000027211809f,0.51410274419322166128f,0.85135519310526519554f,
0.52458968267846894928f,0.84485356524970711689f,0.53499761988709715332f,
0.83822470555483807875f,0.54532498842204646383f,0.83146961230254523567f,
0.55557023301960217765f,0.82458930278502529099f,0.56573181078361312046f,
0.81758481315158371139f,0.57580819141784533866f,0.81045719825259476821f,
0.58579785745643886408f,0.80320753148064494287f,0.59569930449243335691f,
0.79583690460888356633f,0.60551104140432554512f,0.78834642762660622761f,
0.61523159058062681925f,0.78073722857209448822f,0.62485948814238634341f,
0.77301045336273699338f,0.63439328416364548779f,0.76516726562245895860f,
0.64383154288979138613f,0.75720884650648456748f,0.65317284295377675551f,
0.74913639452345937020f,0.66241577759017178373f,0.74095112535495921691f,
0.67155895484701833009f,0.73265427167241281570f,0.68060099779545302212f,
0.72424708295146700276f,0.68954054473706682948f,0.71573082528381870571f,
0.69837624940897280457f,0.70710678118654757274f,0.70710678118654757274f,
0.69837624940897291559f,0.71573082528381859468f,0.68954054473706694051f,
0.72424708295146689174f,0.68060099779545302212f,0.73265427167241281570f,
0.67155895484701833009f,0.74095112535495910588f,0.66241577759017178373f,
0.74913639452345925918f,0.65317284295377686654f,0.75720884650648456748f,
0.64383154288979149715f,0.76516726562245895860f,0.63439328416364548779f,
0.77301045336273688235f,0.62485948814238645443f,0.78073722857209448822f,
0.61523159058062681925f,0.78834642762660622761f,0.60551104140432554512f,
0.79583690460888345530f,0.59569930449243346793f,0.80320753148064483184f,
0.58579785745643886408f,0.81045719825259476821f,0.57580819141784533866f,
0.81758481315158371139f,0.56573181078361323149f,0.82458930278502529099f,
0.55557023301960228867f,0.83146961230254523567f,0.54532498842204646383f,
0.83822470555483796772f,0.53499761988709726435f,0.84485356524970700587f,
0.52458968267846883826f,0.85135519310526519554f,0.51410274419322166128f,
0.85772861000027211809f,0.50353838372571757542f,0.86397285612158669643f,
0.49289819222978409341f,0.87008699110871134952f,0.48218377207912282989f,
0.87607009419540660122f,0.47139673682599780857f,0.88192126434835493853f,
0.46053871095824000514f,0.88763962040285393496f,0.44961132965460659516f,
0.89322430119551532446f,0.43861623853852771404f,0.89867446569395381673f,
0.42755509343028219593f,0.90398929312344333820f,0.41642956009763731906f,
0.90916798309052226923f,0.40524131400498986100f,0.91420975570353069095f,
0.39399204006104809883f,0.91911385169005777040f,0.38268343236508983729f,
0.92387953251128673848f,0.37131719395183759858f,0.92850608047321558924f,
0.35989503653498827740f,0.93299279883473884567f,0.34841868024943450921f,
0.93733901191257495977f,0.33688985339222005111f,0.94154406518302080631f,
0.32531029216226298173f,0.94560732538052127971f,0.31368174039889157312f,
0.94952818059303667475f,0.30200594931922819519f,0.95330604035419375109f,
0.29028467725446233105f,0.95694033573220893540f,0.27851968938505305973f,
0.96043051941556578655f,0.26671275747489842090f,0.96377606579543984022f,
0.25486565960451462720f,0.96697647104485207059f,0.24298017990326398197f,
0.97003125319454397424f,0.23105810828067127605f,0.97293995220556006576f,
0.21910124015686976984f,0.97570213003852857003f,0.20711137619221856032f,
0.97831737071962765473f,0.19509032201612833135f,0.98078528040323043058f,
0.18303988795514106180f,0.98310548743121628501f,0.17096188876030135595f,
0.98527764238894122162f,0.15885814333386139019f,0.98730141815785843473f,
0.14673047445536174793f,0.98917650996478101444f,0.13458070850712622324f,
0.99090263542778000971f,0.12241067519921627893f,0.99247953459870996706f,
0.11022220729388318428f,0.99390697000235606051f,0.09801714032956077016f,
0.99518472667219681771f,0.08579731234443987997f,0.99631261218277800129f,
0.07356456359966745406f,0.99729045667869020697f,0.06132073630220864768f,
0.99811811290014917919f,0.04906767432741812596f,0.99879545620517240501f,
0.03680722294135899131f,0.99932238458834954375f,0.02454122852291226384f,
0.99969881869620424997f,0.01227153828571994447f,0.99992470183914450299f,
0.00000000000000006123f,1.00000000000000000000f,-0.01227153828571982304f,
0.99992470183914450299f,-0.02454122852291214241f,0.99969881869620424997f,
-0.03680722294135886641f,0.99932238458834954375f,-0.04906767432741800800f,
0.99879545620517240501f,-0.06132073630220852972f,0.99811811290014917919f,
-0.07356456359966732916f,0.99729045667869020697f,-0.08579731234443975507f,
0.99631261218277800129f,-0.09801714032956064526f,0.99518472667219692873f,
-0.11022220729388305938f,0.99390697000235606051f,-0.12241067519921615403f,
0.99247953459870996706f,-0.13458070850712611222f,0.99090263542778000971f,
-0.14673047445536163691f,0.98917650996478101444f,-0.15885814333386127917f,
0.98730141815785843473f,-0.17096188876030124493f,0.98527764238894122162f,
-0.18303988795514092303f,0.98310548743121628501f,-0.19509032201612819257f,
0.98078528040323043058f,-0.20711137619221844930f,0.97831737071962765473f,
-0.21910124015686965881f,0.97570213003852857003f,-0.23105810828067113727f,
0.97293995220556017678f,-0.24298017990326387094f,0.97003125319454397424f,
-0.25486565960451451618f,0.96697647104485207059f,-0.26671275747489830987f,
0.96377606579543984022f,-0.27851968938505294870f,0.96043051941556589757f,
-0.29028467725446216452f,0.95694033573220893540f,-0.30200594931922808417f,
0.95330604035419386211f,-0.31368174039889140658f,0.94952818059303667475f,
-0.32531029216226287071f,0.94560732538052139073f,-0.33688985339221994009f,
0.94154406518302080631f,-0.34841868024943439819f,0.93733901191257495977f,
-0.35989503653498816638f,0.93299279883473884567f,-0.37131719395183748755f,
0.92850608047321558924f,-0.38268343236508972627f,0.92387953251128673848f,
-0.39399204006104798781f,0.91911385169005777040f,-0.40524131400498974998f,
0.91420975570353069095f,-0.41642956009763698599f,0.90916798309052249127f,
-0.42755509343028186287f,0.90398929312344344922f,-0.43861623853852738097f,
0.89867446569395392775f,-0.44961132965460670619f,0.89322430119551521344f,
-0.46053871095824006066f,0.88763962040285393496f,-0.47139673682599769755f,
0.88192126434835504956f,-0.48218377207912271887f,0.87607009419540660122f,
-0.49289819222978398239f,0.87008699110871146054f,-0.50353838372571746440f,
0.86397285612158680745f,-0.51410274419322155026f,0.85772861000027211809f,
-0.52458968267846872724f,0.85135519310526519554f,-0.53499761988709704230f,
0.84485356524970722791f,-0.54532498842204624179f,0.83822470555483818977f,
-0.55557023301960195560f,0.83146961230254534669f,-0.56573181078361323149f,
0.82458930278502517996f,-0.57580819141784533866f,0.81758481315158371139f,
-0.58579785745643886408f,0.81045719825259476821f,-0.59569930449243335691f,
0.80320753148064494287f,-0.60551104140432543410f,0.79583690460888356633f,
-0.61523159058062670823f,0.78834642762660633863f,-0.62485948814238623239f,
0.78073722857209459924f,-0.63439328416364537677f,0.77301045336273710440f,
-0.64383154288979127511f,0.76516726562245906962f,-0.65317284295377653347f,
0.75720884650648467851f,-0.66241577759017189475f,0.74913639452345925918f,
-0.67155895484701844111f,0.74095112535495899486f,-0.68060099779545302212f,
0.73265427167241281570f,-0.68954054473706694051f,0.72424708295146689174f,
-0.69837624940897280457f,0.71573082528381870571f,-0.70710678118654746172f,
0.70710678118654757274f,-0.71573082528381859468f,0.69837624940897291559f,
-0.72424708295146678072f,0.68954054473706705153f,-0.73265427167241270467f,
0.68060099779545324417f,-0.74095112535495888384f,0.67155895484701855214f,
-0.74913639452345914815f,0.66241577759017200577f,-0.75720884650648467851f,
0.65317284295377664449f,-0.76516726562245895860f,0.64383154288979138613f,
-0.77301045336273699338f,0.63439328416364548779f,-0.78073722857209448822f,
0.62485948814238634341f,-0.78834642762660622761f,0.61523159058062693028f,
-0.79583690460888345530f,0.60551104140432565615f,-0.80320753148064483184f,
0.59569930449243346793f,-0.81045719825259465718f,0.58579785745643897510f,
-0.81758481315158360037f,0.57580819141784544968f,-0.82458930278502506894f,
0.56573181078361345353f,-0.83146961230254534669f,0.55557023301960217765f,
-0.83822470555483807875f,0.54532498842204635281f,-0.84485356524970711689f,
0.53499761988709715332f,-0.85135519310526519554f,0.52458968267846894928f,
-0.85772861000027200706f,0.51410274419322177231f,-0.86397285612158669643f,
0.50353838372571757542f,-0.87008699110871134952f,0.49289819222978414892f,
-0.87607009419540649020f,0.48218377207912288540f,-0.88192126434835493853f,
0.47139673682599780857f,-0.88763962040285382393f,0.46053871095824022719f,
-0.89322430119551521344f,0.44961132965460687272f,-0.89867446569395392775f,
0.43861623853852754751f,-0.90398929312344333820f,0.42755509343028202940f,
-0.90916798309052238025f,0.41642956009763715253f,-0.91420975570353069095f,
0.40524131400498991651f,-0.91911385169005777040f,0.39399204006104815434f,
-0.92387953251128673848f,0.38268343236508989280f,-0.92850608047321547822f,
0.37131719395183770960f,-0.93299279883473884567f,0.35989503653498833291f,
-0.93733901191257484875f,0.34841868024943478677f,-0.94154406518302069529f,
0.33688985339222032867f,-0.94560732538052116869f,0.32531029216226325929f,
-0.94952818059303667475f,0.31368174039889140658f,-0.95330604035419386211f,
0.30200594931922802866f,-0.95694033573220882438f,0.29028467725446238656f,
-0.96043051941556578655f,0.27851968938505317075f,-0.96377606579543984022f,
0.26671275747489847641f,-0.96697647104485207059f,0.25486565960451468271f,
-0.97003125319454397424f,0.24298017990326406523f,-0.97293995220556006576f,
0.23105810828067133156f,-0.97570213003852845901f,0.21910124015687004739f,
-0.97831737071962754371f,0.20711137619221883788f,-0.98078528040323043058f,
0.19509032201612860891f,-0.98310548743121628501f,0.18303988795514089527f,
-0.98527764238894122162f,0.17096188876030121717f,-0.98730141815785843473f,
0.15885814333386147346f,-0.98917650996478101444f,0.14673047445536180344f,
-0.99090263542778000971f,0.13458070850712627875f,-0.99247953459870996706f,
0.12241067519921634832f,-0.99390697000235606051f,0.11022220729388323979f,
-0.99518472667219681771f,0.09801714032956082567f,-0.99631261218277800129f,
0.08579731234444015753f,-0.99729045667869020697f,0.07356456359966773162f,
-0.99811811290014917919f,0.06132073630220848809f,-0.99879545620517240501f,
0.04906767432741796636f,-0.99932238458834954375f,0.03680722294135883171f,
-0.99969881869620424997f,0.02454122852291232629f,-0.99992470183914450299f,
0.01227153828572000692f,1.00000000000000000000f,0.00000000000000000000f,
0.99879545620517240501f,0.04906767432741801493f,0.99518472667219692873f,
0.09801714032956060363f,0.98917650996478101444f,0.14673047445536174793f,
0.98078528040323043058f,0.19509032201612824808f,0.97003125319454397424f,
0.24298017990326387094f,0.95694033573220882438f,0.29028467725446233105f,
0.94154406518302080631f,0.33688985339222005111f,0.92387953251128673848f,
0.38268343236508978178f,0.90398929312344333820f,0.42755509343028208491f,
0.88192126434835504956f,0.47139673682599764204f,0.85772861000027211809f,
0.51410274419322166128f,0.83146961230254523567f,0.55557023301960217765f,
0.80320753148064494287f,0.59569930449243335691f,0.77301045336273699338f,
0.63439328416364548779f,0.74095112535495921691f,0.67155895484701833009f,
0.70710678118654757274f,0.70710678118654757274f,0.67155895484701833009f,
0.74095112535495910588f,0.63439328416364548779f,0.77301045336273688235f,
0.59569930449243346793f,0.80320753148064483184f,0.55557023301960228867f,
0.83146961230254523567f,0.51410274419322166128f,0.85772861000027211809f,
0.47139673682599780857f,0.88192126434835493853f,0.42755509343028219593f,
0.90398929312344333820f,0.38268343236508983729f,0.92387953251128673848f,
0.33688985339222005111f,0.94154406518302080631f,0.29028467725446233105f,
0.95694033573220893540f,0.24298017990326398197f,0.97003125319454397424f,
0.19509032201612833135f,0.98078528040323043058f,0.14673047445536174793f,
0.98917650996478101444f,0.09801714032956077016f,0.99518472667219681771f,
0.04906767432741812596f,0.99879545620517240501f,0.00000000000000006123f,
1.00000000000000000000f,-0.04906767432741800800f,0.99879545620517240501f,
-0.09801714032956064526f,0.99518472667219692873f,-0.14673047445536163691f,
0.98917650996478101444f,-0.19509032201612819257f,0.98078528040323043058f,
-0.24298017990326387094f,0.97003125319454397424f,-0.29028467725446216452f,
0.95694033573220893540f,-0.33688985339221994009f,0.94154406518302080631f,
-0.38268343236508972627f,0.92387953251128673848f,-0.42755509343028186287f,
0.90398929312344344922f,-0.47139673682599769755f,0.88192126434835504956f,
-0.51410274419322155026f,0.85772861000027211809f,-0.55557023301960195560f,
0.83146961230254534669f,-0.59569930449243335691f,0.80320753148064494287f,
-0.63439328416364537677f,0.77301045336273710440f,-0.67155895484701844111f,
0.74095112535495899486f,-0.70710678118654746172f,0.70710678118654757274f,
-0.74095112535495888384f,0.67155895484701855214f,-0.77301045336273699338f,
0.63439328416364548779f,-0.80320753148064483184f,0.59569930449243346793f,
-0.83146961230254534669f,0.55557023301960217765f,-0.85772861000027200706f,
0.51410274419322177231f,-0.88192126434835493853f,0.47139673682599780857f,
-0.90398929312344333820f,0.42755509343028202940f,-0.92387953251128673848f,
0.38268343236508989280f,-0.94154406518302069529f,0.33688985339222032867f,
-0.95694033573220882438f,0.29028467725446238656f,-0.97003125319454397424f,
0.24298017990326406523f,-0.98078528040323043058f,0.19509032201612860891f,
-0.98917650996478101444f,0.14673047445536180344f,-0.99518472667219681771f,
0.09801714032956082567f,-0.99879545620517240501f,0.04906767432741796636f,
1.00000000000000000000f,0.00000000000000000000f,0.98078528040323043058f,
0.19509032201612824808f,0.92387953251128673848f,0.38268343236508978178f,
0.83146961230254523567f,0.55557023301960217765f,0.70710678118654757274f,
0.70710678118654757274f,0.55557023301960228867f,0.83146961230254523567f,
0.38268343236508983729f,0.92387953251128673848f,0.19509032201612833135f,
0.98078528040323043058f,0.00000000000000006123f,1.00000000000000000000f,
-0.19509032201612819257f,0.98078528040323043058f,-0.38268343236508972627f,
0.92387953251128673848f,-0.55557023301960195560f,0.83146961230254534669f,
-0.70710678118654746172f,0.70710678118654757274f,-0.83146961230254534669f,
0.55557023301960217765f,-0.92387953251128673848f,0.38268343236508989280f,
-0.98078528040323043058f,0.19509032201612860891f,1.00000000000000000000f,
0.00000000000000000000f,0.70710678118654757274f,0.70710678118654757274f,
0.00000000000000006123f,1.00000000000000000000f,-0.70710678118654746172f,
0.70710678118654757274f,};

float32_t rearranged_twiddle_stride3_4096_f32[2728]={
1.00000000000000000000f,0.00000000000000000000f,0.99998941108192840321f,
0.00460192612044857050f,0.99995764455196389786f,0.00920375478205981944f,
0.99990470108285289808f,0.01380538852806039059f,0.99983058179582340319f,
0.01840672990580482019f,0.99973528826056168306f,0.02300768146883936868f,
0.99961882249517863830f,0.02760814577896573974f,0.99948118696616694567f,
0.03220802540830458582f,0.99932238458834954375f,0.03680722294135883171f,
0.99914241872481690532f,0.04140564097707673946f,0.99894129318685687124f,
0.04600318213091462299f,0.99871901223387293811f,0.05059974903689928166f,
0.99847558057329477421f,0.05519524434968993420f,0.99821100336047818846f,
0.05978957074663986820f,0.99792528619859599548f,0.06438263092985746505f,
0.99761843513851955478f,0.06897432762826674613f,0.99729045667869020697f,
0.07356456359966742631f,0.99694135776498216117f,0.07815324163279423197f,
0.99657114579055483539f,0.08274026454937569164f,0.99617982859569698117f,
0.08732553520619205922f,0.99576741446765981713f,0.09190895649713272386f,
0.99533391214048227980f,0.09649043135525259274f,0.99487933079480561638f,
0.10106986275482782167f,0.99440368005767909576f,0.10564715371341061589f,
0.99390697000235606051f,0.11022220729388305938f,0.99338921114808065305f,
0.11479492660651008373f,0.99285041445986510489f,0.11936521481099135467f,
0.99229059134825736699f,0.12393297511851215920f,0.99170975366909952520f,
0.12849811079379316880f,0.99110791372327688986f,0.13306052515713906459f,
0.99048508425645709341f,0.13762012158648603832f,0.98984127845882052821f,
0.14217680351944803063f,0.98917650996478101444f,0.14673047445536174793f,
0.98849079285269658701f,0.15128103795733022219f,0.98778414164457217783f,
0.15582839765426523271f,0.98705657130575097380f,0.16037245724292828464f,
0.98630809724459866938f,0.16491312048996989437f,0.98553873531217606185f,
0.16945029123396795900f,0.98474850180190420801f,0.17398387338746382214f,
0.98393741344921892278f,0.17851377093899750692f,0.98310548743121628501f,
0.18303988795514095078f,0.98225274136628937249f,0.18756212858252960252f,
0.98137919331375456089f,0.19208039704989243734f,0.98048486177346938497f,
0.19659459767008022335f,0.97956976568544051887f,0.20110463484209190055f,
0.97863392442942320759f,0.20561041305309923910f,0.97767735782450992943f,
0.21011183688046961016f,0.97670008612871184184f,0.21460881099378675829f,
0.97570213003852857003f,0.21910124015686979759f,0.97468351068851066810f,
0.22358902922978998729f,0.97364424965081197705f,0.22807208317088573102f,
0.97258436893473221296f,0.23255030703877524467f,0.97150389098625178352f,
0.23702360599436719801f,0.97040283868755550234f,0.24149188530286933019f,
0.96928123535654853171f,0.24595505033579459497f,0.96813910474636244441f,
0.25041300657296522436f,0.96697647104485207059f,0.25486565960451457169f,
0.96579335887408368500f,0.25931291513288623474f,0.96458979328981275803f,
0.26375467897483134694f,0.96336579978095404631f,0.26819085706340317632f,
0.96212140426904158019f,0.27262135544994897662f,0.96085663310767965850f,
0.27704608030609989555f,0.95957151308198451733f,0.28146493792575794091f,
0.95826607140801767226f,0.28587783472708061527f,0.95694033573220882438f,
0.29028467725446233105f,0.95559433413077110586f,0.29468537218051432669f,
0.95422809510910566733f,0.29907982630804047508f,0.95284164760119871573f,
0.30346794657201131562f,0.95143502096900833820f,0.30784964004153486661f,
0.95000824500184299914f,0.31222481392182488413f,0.94856134991573026749f,
0.31659337555616584581f,0.94709436635277721717f,0.32095523242787521445f,
0.94560732538052127971f,0.32531029216226292622f,0.94410025849127265918f,
0.32965846252858749255f,0.94257319760144686605f,0.33399965144200938205f,
0.94102617505088925753f,0.33833376696554112728f,0.93945922360218991898f,
0.34266071731199437833f,0.93787237643998988545f,0.34698041084592368133f,
0.93626566717027825959f,0.35129275608556709276f,0.93463912981968078064f,
0.35559766170478385172f,0.93299279883473895669f,0.35989503653498811087f,
0.93132670908118042608f,0.36418478956707989180f,0.92964089584318121418f,
0.36846682995337232125f,0.92793539482261788720f,0.37274106700951575855f,
0.92621024213831137928f,0.37700741021641825945f,0.92446547432526260391f,
0.38126576922216237620f,0.92270112833387862850f,0.38551605384391884890f,
0.92091724152918941204f,0.38975817406985641123f,0.91911385169005777040f,
0.39399204006104809883f,0.91729099700837790632f,0.39821756215337356100f,
0.91544871608826783316f,0.40243465085941843018f,0.91358704794525080750f,
0.40664321687036902864f,0.91170603200542987832f,0.41084317105790391089f,
0.90980570810465222209f,0.41503442447608163146f,0.90788611648766626150f,
0.41921688836322390515f,0.90594729780726845902f,0.42339047414379604728f,
0.90398929312344333820f,0.42755509343028208491f,0.90201214390249317976f,
0.43171065802505725895f,0.90001589201616016833f,0.43585707992225547480f,
0.89800057974073987932f,0.43999427130963325583f,0.89596624975618521791f,
0.44412214457042920035f,0.89391294514520325265f,0.44824061228521988598f,
0.89184070939234272313f,0.45234958723377088896f,0.88974958638307277692f,
0.45644898239688391772f,0.88763962040285393496f,0.46053871095824000514f,
0.88551085613619995307f,0.46461868630623781584f,0.88336333866573157891f,
0.46868882203582790114f,0.88119711347122209322f,0.47274903195034279069f,
0.87901222642863352519f,0.47679923006332208812f,0.87680872380914565145f,
0.48083933060033395845f,0.87458665227817611321f,0.48486924800079106435f,
0.87234605889439154058f,0.48888889691976317176f,0.87008699110871146054f,
0.49289819222978403790f,0.86780949676330332299f,0.49689704902265446895f,
0.86551362409056908920f,0.50088538261124071482f,0.86319942171212415971f,
0.50486310853126759035f,0.86086693863776730939f,0.50883014254310698909f,
0.85851622426444273994f,0.51278640063356295542f,0.85614732837519447184f,
0.51673179901764987321f,0.85376030113811141042f,0.52066625414036715735f,
0.85135519310526519554f,0.52458968267846894928f,0.84893205521163961347f,
0.52850200154222848337f,0.84649093877405212627f,0.53240312787719790144f,
0.84403189549006640835f,0.53629297906596318235f,0.84155497743689844370f,
0.54017147272989285423f,0.83906023707031274217f,0.54403852673088382019f,
0.83654772722351200542f,0.54789405917310018967f,0.83401750110601813315f,
0.55173798840470733573f,0.83146961230254523567f,0.55557023301960217765f,
0.82890411477186487499f,0.55939071185913613604f,0.82632106284566353427f,
0.56319934401383409117f,0.82372051122739142759f,0.56699604882510867832f,
0.82110251499110464835f,0.57078074588696725566f,0.81846712958029865792f,
0.57455335504771576360f,0.81581441080673378075f,0.57831379641165558958f,
0.81314441484925359394f,0.58206199034077543697f,0.81045719825259476821f,
0.58579785745643886408f,0.80775281792619035848f,0.58952131864106394055f,
0.80503133114296365758f,0.59323229503979979516f,0.80229279553811572168f,
0.59693070806219639124f,0.79953726910790501314f,0.60061647938386897305f,
0.79676481020841882774f,0.60428953094815596181f,0.79397547755433717231f,
0.60794978496777363208f,0.79116933021769020318f,0.61159716392646190641f,
0.78834642762660622761f,0.61523159058062681925f,0.78550682956405393220f,
0.61885298796097631957f,0.78265059616657572938f,0.62246127937414996723f,
0.77977778792301455368f,0.62605638840434352232f,0.77688846567323244230f,
0.62963823891492698426f,0.77398269060682289844f,0.63320675505005719064f,
0.77106052426181381776f,0.63676186123628419899f,0.76812202852336541881f,
0.64030348218415167327f,0.76516726562245895860f,0.64383154288979138613f,
0.76219629813457900891f,0.64734596863651205911f,0.75920918897838796102f,
0.65084668499638087535f,0.75620600141439453523f,0.65433361783180044036f,
0.75318679904361252042f,0.65780669329707863735f,0.75015164580621507273f,
0.66126583783999226540f,0.74710060598018013245f,0.66471097820334479334f,
0.74403374417992929057f,0.66814204142651845153f,0.74095112535495921691f,
0.67155895484701833009f,0.73785281478846598269f,0.67496164610201192513f,
0.73473887809596349907f,0.67835004312986146857f,0.73160938122389262972f,
0.68172407417164970767f,0.72846439044822519637f,0.68508366777270035541f,
0.72530397237306076796f,0.68842875278409043638f,0.72212819392921534511f,
0.69175925836415774750f,0.71893712237280449351f,0.69507511398000088043f,
0.71573082528381870571f,0.69837624940897280457f,0.71250937056469243469f,
0.70166259474016845488f,0.70927282643886568891f,0.70493408037590488124f,
0.70602126144933974317f,0.70819063703319540259f,0.70275474445722529993f,
0.71143219574521643356f,0.69947334464028376733f,0.71465868786276909308f,
0.69617713149146298601f,0.71787004505573170920f,0.69286617481742474034f,
0.72106619931450810501f,0.68954054473706694051f,0.72424708295146689174f,
0.68620031168003858824f,0.72741262860237576593f,0.68284554638524808112f,
0.73056276922782759087f,0.67947631989936496666f,0.73369743811466026084f,
0.67609270357531603413f,0.73681656887736979300f,0.67269476907077296879f,
0.73992009545951609173f,0.66928258834663600929f,0.74300795213512171866f,
0.66585623366550972246f,0.74608007351006366825f,0.66241577759017178373f,
0.74913639452345925918f,0.65896129298203731661f,0.75217685044904269986f,
0.65549285299961546070f,0.75520137689653654700f,0.65201053109695950027f,
0.75820990981301528144f,0.64851440102211255212f,0.76120238548426177871f,
0.64500453681554403840f,0.76417874053611667406f,0.64148101280858316198f,
0.76713891193582040007f,0.63794390362184416610f,0.77008283699334789674f,
0.63439328416364548779f,0.77301045336273688235f,0.63082922962842458148f,
0.77592169904340757558f,0.62725181549514419377f,0.77881651238147586724f,
0.62366111752569464155f,0.78169483207105938671f,0.62005721176328920663f,
0.78455659715557524159f,0.61644017453085364622f,0.78740174702903131809f,
0.61281008242940970820f,0.79023022143731003197f,0.60916701233645320634f,
0.79304196047944364167f,0.60551104140432554512f,0.79583690460888345530f,
0.60184224705858002658f,0.79861499463476082195f,0.59816070699634238395f,
0.80137617172314012937f,0.59446649918466454299f,0.80412037739826569549f,
0.59075970185887427544f,0.80684755354379922299f,0.58704039352091808013f,
0.80955764240405125864f,0.58330865293769829094f,0.81225058658520388200f,
0.57956455913940574387f,0.81492632905652662156f,0.57580819141784533866f,
0.81758481315158371139f,0.57203962932475704850f,0.82022598256943468620f,
0.56825895267013148970f,0.82284978137582631685f,0.56446624152051949608f,
0.82545615400437744036f,0.56066157619733603124f,0.82804504525775579626f,
0.55684503727516010407f,0.83061640030884620334f,0.55301670558002757883f,
0.83317016470191318511f,0.54917666218771976627f,0.83570628435375260423f,
0.54532498842204646383f,0.83822470555483796772f,0.54146176585312355556f,
0.84072537497045796151f,0.53758707629564550512f,0.84320823964184543620f,
0.53370100180715296379f,0.84567324698729906540f,0.52980362468629482731f,
0.84812034480329712149f,0.52589502747108474168f,0.85054948126560336874f,
0.52197529293715438925f,0.85296060493036363059f,0.51804450409599933636f,
0.85535366473519602870f,0.51410274419322166128f,0.85772861000027211809f,
0.51015009670676669806f,0.86008539042939025077f,0.50618664534515533937f,
0.86242395611104050168f,0.50221247404571089934f,0.86474425751946237817f,
0.49822766697278186854f,0.86704624551569264845f,0.49423230851595972846f,
0.86932987134860673084f,0.49022648328829110387f,0.87159508665595109012f,
0.48621027612448652899f,0.87384184346536675214f,0.48218377207912282989f,
0.87607009419540660122f,0.47814705642484311987f,0.87827979165654146421f,
0.47410021465055002254f,0.88047088905216075450f,0.47004333245959561971f,
0.88264333997956279099f,0.46597649576796612569f,0.88479709843093778954f,
0.46189979070246284243f,0.88693211879434208367f,0.45781330359887728587f,
0.88904835585466457371f,0.45371712100016392544f,0.89114576479458318392f,
0.44961132965460659516f,0.89322430119551532446f,0.44549601651398174074f,
0.89528392103855758410f,0.44137126873171661501f,0.89732458070541831763f,
0.43723717366104419835f,0.89934623697934146236f,0.43309381885315201277f,
0.90134884704602202810f,0.42894129205532954829f,0.90333236849451181705f,
0.42477968120910880589f,0.90529675931811881551f,0.42060907444840250902f,
0.90724197791529592738f,0.41642956009763731906f,0.90916798309052226923f,
0.41224122666988299857f,0.91107473405517624965f,0.40804416286497874333f,
0.91296219042839810154f,0.40383845756765412993f,0.91483031223794608611f,
0.39962419984564678810f,0.91667905992104270485f,0.39540147894781629834f,
0.91850839432521225181f,0.39117038430225398171f,0.92031827670911048322f,
0.38693100551438869283f,0.92210866874334507237f,0.38268343236508983729f,
0.92387953251128673848f,0.37842775480876561511f,0.92563083050987271516f,
0.37416406297145798909f,0.92736252565040111495f,0.36989244714893426691f,
0.92907458125931574600f,0.36561299780477396482f,0.93076696107898371224f,
0.36132580556845433906f,0.93243962926846235550f,0.35703096123343003310f,
0.93409255040425887007f,0.35272855575521072646f,0.93572568948108036935f,
0.34841868024943450921f,0.93733901191257495977f,0.34410142598993898044f,
0.93893248353206448797f,0.33977688440682696225f,0.94050607059326829518f,
0.33544514708453165852f,0.94205973977101731265f,0.33110630575987642921f,
0.94359345816196038559f,0.32676045232013178898f,0.94510719328526060501f,
0.32240767880107001897f,0.94660091308328353499f,0.31804807738501505998f,
0.94807458592227622507f,0.31368174039889157312f,0.94952818059303667475f,
0.30930876031226878231f,0.95096166631157508231f,0.30492922973540242948f,
0.95237501271976587880f,0.30054324141727339903f,0.95376818988599032512f,
0.29615088824362395536f,0.95514116830577067141f,0.29175226323498937298f,
0.95649391890239499059f,0.28734745954472956653f,0.95782641302753290802f,
0.28293657045705539188f,0.95913862246184189431f,0.27851968938505305973f,
0.96043051941556578655f,0.27409690986870632878f,0.96170207652912254037f,
0.26966832557291520178f,0.96295326687368387741f,0.26523403028551190141f,
0.96418406395174571788f,0.26079411791527556952f,0.96539444169768939830f,
0.25634868248994291395f,0.96658437447833311928f,0.25189781815421691258f,
0.96775383709347551076f,0.24744161916777343557f,0.96890280477642887202f,
0.24298017990326398197f,0.97003125319454397424f,0.23851359484431849944f,
0.97113915844972509284f,0.23404195858354345794f,0.97222649707893626925f,
0.22956536582051886852f,0.97329324605469824672f,0.22508391135979277653f,
0.97433938278557585821f,0.22059769010887364526f,0.97536488511665686563f,
0.21610679707621960333f,0.97636973133002114000f,0.21161132736922760866f,
0.97735390014519996082f,0.20711137619221856032f,0.97831737071962765473f,
0.20260703884442110567f,0.97926012264908202098f,0.19809841071795372680f,
0.98018213596811731847f,0.19358558729580374602f,0.98108339115048659451f,
0.18906866414980627589f,0.98196386910955524296f,0.18454773693861964423f,
0.98282355119870523641f,0.18002290140569951471f,0.98366241921173025453f,
0.17549425337727139751f,0.98448045538322093151f,0.17096188876030135595f,
0.98527764238894122162f,0.16642590354046421508f,0.98605396334619543897f,
0.16188639378011188130f,0.98680940181418541624f,0.15734345561623827581f,
0.98754394179435922574f,0.15279718525844340760f,0.98825756773074946437f,
0.14824767898689619749f,0.98895026451030298986f,0.14369503315029458212f,
0.98962201746320077600f,0.13913934416382628401f,0.99027281236316910817f,
0.13458070850712622324f,0.99090263542778000971f,0.13001922272223334631f,
0.99151147331874389668f,0.12545498341154620592f,0.99209931314219179654f,
0.12088808723577722237f,0.99266614244894801899f,0.11631863091190487725f,
0.99321194923479450001f,0.11174671121112665639f,0.99373672194072459884f,
0.10717242495680887049f,0.99424044945318790223f,0.10259586902243628126f,
0.99472312110432570265f,0.09801714032956077016f,0.99518472667219681771f,
0.09343633584574791151f,0.99562525638099430569f,0.08885355258252468358f,
0.99604470090125196702f,0.08426888759332412659f,0.99644305135004263008f,
0.07968243797143012563f,0.99682029929116566791f,0.07509430084792129145f,
0.99717643673532618820f,0.07050457338961400866f,0.99751145614030345410f,
0.06591335279700392957f,0.99782535041111164453f,0.06132073630220864768f,
0.99811811290014917919f,0.05672682116690778292f,0.99838973740734016094f,
0.05213170468028331672f,0.99864021818026527111f,0.04753548415695926094f,
0.99886954991428356099f,0.04293825693494095902f,0.99907772775264536147f,
0.03834012037355279123f,0.99926474728659442359f,0.03374117185137764235f,
0.99943060455546173237f,0.02914150876419373953f,0.99957529604674921764f,
0.02454122852291226384f,0.99969881869620424997f,0.01994042855151459750f,
0.99980116988788425569f,0.01533920628498821985f,0.99988234745421256111f,
0.01073765916726457208f,0.99994234967602391162f,0.00613588464915451517f,
0.99998117528260110909f,0.00153398018628476615f,0.99999882345170187925f,
-0.00306795676296601561f,0.99999529380957619118f,-0.00766982873953095477f,
0.99997058643097413988f,-0.01227153828571982304f,0.99992470183914450299f,
-0.01687298794728165144f,0.99985764100582386060f,-0.02147408027546948359f,
0.99976940535121527898f,-0.02607471782910391472f,0.99965999674395922270f,
-0.03067480317663645942f,0.99952941750109314256f,-0.03527423889821382219f,
0.99937767038800284780f,-0.03987292758773972740f,0.99920475861836388631f,
-0.04447077185493861912f,0.99901068585407337697f,-0.04906767432741800800f,
0.99879545620517240501f,-0.05366353765273055437f,0.99855907422975931365f,
-0.05825826450043560673f,0.99830154493389289261f,-0.06285175756416130910f,
0.99802287377148624081f,-0.06744391956366398155f,0.99772306664419163624f,
-0.07203465324688929083f,0.99740212990127530279f,-0.07662386139203150592f,
0.99706007033948296225f,-0.08121144680959226092f,0.99669689520289606044f,
-0.08579731234443975507f,0.99631261218277800129f,-0.09038136087786488582f,
0.99590722941741172125f,-0.09496349532963895002f,0.99548075549192693856f,
-0.09954361866006931903f,0.99503319943811863180f,-0.10412163387205460030f,
0.99456457073425541537f,-0.10869744401313856386f,0.99407487930487947736f,
-0.11327095217756423529f,0.99356413552059530403f,-0.11784206150832489401f,
0.99303235019785141002f,-0.12241067519921615403f,0.99247953459870996706f,
-0.12697669649688586579f,0.99190570043060932726f,-0.13154002870288314386f,
0.99131085984611544415f,-0.13610057517570606223f,0.99069502544266463406f,
-0.14065823933284912761f,0.99005821026229712256f,-0.14521292465284740825f,
0.98940042779138037687f,-0.14976453467732150915f,0.98872169196032377858f,
-0.15431297301302013270f,0.98802201714328352633f,-0.15885814333386127917f,
0.98730141815785843473f,-0.16339994938297311422f,0.98655991026477551920f,
-0.16793829497473108936f,0.98579750916756747614f,-0.17247308399679592283f,
0.98501423101223983814f,-0.17700422041214874946f,0.98421009238692902521f,
-0.18153160826112502146f,0.98338511032155118130f,-0.18605515166344649414f,
0.98253930228744124076f,-0.19057475482025265645f,0.98167268619698311305f,
-0.19509032201612819257f,0.98078528040323043058f,-0.19960175762113094300f,
0.97987710369951763756f,-0.20410896609281689584f,0.97894817531906219710f,
-0.20861185197826331850f,0.97799851493455713936f,-0.21311031991609125091f,
0.97702814265775439484f,-0.21760427463848355800f,0.97603707903903913490f,
-0.22209362097320348162f,0.97502534506699412020f,-0.22657826384560997290f,
0.97399296216795583359f,-0.23105810828067113727f,0.97293995220556017678f,
-0.23553305940497534787f,0.97186633748027939639f,-0.24000302244874138768f,
0.97077214072895035013f,-0.24446790274782409513f,0.96965738512429244800f,
-0.24892760574572012078f,0.96852209427441737777f,-0.25338203699557015902f,
0.96736629222232850545f,-0.25783110216215882060f,0.96619000344541261516f,
-0.26227470702391347812f,0.96499325285492043580f,-0.26671275747489830987f,
0.96377606579543984022f,-0.27114515952680795507f,0.96253846804435916340f,
-0.27557181931095814376f,0.96128048581132063966f,-0.27999264308027327353f,
0.96000214573766584625f,-0.28440753721127171039f,0.95870347489587159906f,
-0.28881640820604936870f,0.95738450078897596729f,-0.29321916269425857271f,
0.95604525134999651659f,-0.29761570743508619641f,0.95468575494133833814f,
-0.30200594931922808417f,0.95330604035419386211f,-0.30638979537086097338f,
0.95190613680793234597f,-0.31076715274961136393f,0.95048607394948181337f,
-0.31513792875252233383f,0.94904588185270055689f,-0.31950203081601563637f,
0.94758559101774120226f,-0.32385936651785285356f,0.94610523237040344835f,
-0.32820984357909255280f,0.94460483726148025685f,-0.33255336986604405736f,
0.94308443746609349478f,-0.33688985339221994009f,0.94154406518302080631f,
-0.34121920232028229991f,0.93998375303401404679f,-0.34554132496398903829f,
0.93840353406310816897f,-0.34985612979013491763f,0.93680344173592156043f,
-0.35416352542049039931f,0.93518350993894761025f,-0.35846342063373642928f,
0.93354377297883628373f,-0.36275572436739711435f,0.93188426558166814750f,
-0.36704034571976712487f,0.93020502289221906889f,-0.37131719395183748755f,
0.92850608047321558924f,-0.37558617848921721505f,0.92678747430458174872f,
-0.37984720892405099413f,0.92504924078267769527f,-0.38410019501693493105f,
0.92329141671952774661f,-0.38834504669882619066f,0.92151403934204201285f,
-0.39258167407295141427f,0.91971714629122736095f,-0.39680998741671030805f,
0.91790077562139049672f,-0.40102989718357567872f,0.91606496579933172075f,
-0.40524131400498974998f,0.91420975570353069095f,-0.40944414869225753684f,
0.91233518462332285903f,-0.41363831223843450235f,0.91044129225806724737f,
-0.41782371582021227141f,0.90852811871630612117f,-0.42200027079979968159f,
0.90659570451491533483f,-0.42616788872679967071f,0.90464409057824612947f,
-0.43032648134008272267f,0.90267331823725871498f,-0.43447596056965581690f,
0.90068342922864685907f,-0.43861623853852738097f,0.89867446569395392775f,
-0.44274722756456980077f,0.89664647017868026602f,-0.44686884016237399253f,
0.89459948563138280697f,-0.45098098904510369733f,0.89253355540276468894f,
-0.45508358712634372489f,0.89044872324475798919f,-0.45917654752194403400f,
0.88834503330959635470f,-0.46325978355186014923f,0.88622253014888063838f,
-0.46733320874198841510f,0.88408125871263498752f,-0.47139673682599769755f,
0.88192126434835504956f,-0.47545028174715592284f,0.87974259280004740713f,
-0.47949375766015311928f,0.87754529020726124156f,-0.48352707893291846375f,
0.87532940310411100349f,-0.48755016014843571837f,0.87309497841829020182f,
-0.49156291610654972990f,0.87084206347007897531f,-0.49556526182577237405f,
0.86857070597134100609f,-0.49955711254508178287f,0.86628095402451310569f,
-0.50353838372571746440f,0.86397285612158680745f,-0.50750899105297075931f,
0.86164646114308141023f,-0.51146885043797041259f,0.85930181835700847337f,
-0.51541787801946303826f,0.85693897741782865118f,-0.51935599016558964269f,
0.85455798836540053376f,-0.52328310347565654137f,0.85215890162391971785f,
-0.52719913478190105760f,0.84974176800085265970f,-0.53110400115125477871f,
0.84730663868585853749f,-0.53499761988709704230f,0.84485356524970722791f,
-0.53887990853100831146f,0.84238259964318595863f,-0.54275078486451577842f,
0.83989379419599952126f,-0.54661016691083474939f,0.83738720161566193578f,
-0.55045797293660470029f,0.83486287498638012128f,-0.55429412145362011444f,
0.83232086776792968408f,-0.55811853122055610221f,0.82976123379452304540f,
-0.56193112124468946877f,0.82718402727366902027f,-0.56573181078361323149f,
0.82458930278502517996f,-0.56952051934694725155f,0.82197711527924144370f,
-0.57329716669804198226f,0.81934752007679712005f,-0.57706167285567933067f,
0.81670057286682795628f,-0.58081395809576441547f,0.81403632970594852480f,
-0.58455394295301521534f,0.81135484701706384048f,-0.58828154822264522306f,
0.80865618158817509364f,-0.59199669496204088137f,0.80594039057117639047f,
-0.59569930449243335691f,0.80320753148064494287f,-0.59938929840056454079f,
0.80045766219262282082f,-0.60306659854034827539f,0.79769084094339104407f,
-0.60673112703452458661f,0.79490712632823690154f,-0.61038280627630958630f,
0.79210657730021227785f,-0.61402155893103815831f,0.78928925316888587371f,
-0.61764730793780375784f,0.78645521359908587833f,-0.62125997651108744169f,
0.78360451860963831194f,-0.62485948814238623239f,0.78073722857209459924f,
-0.62844576660183260053f,0.77785340420945314754f,-0.63201873593980895105f,
0.77495310659487393057f,-0.63557832048855611440f,0.77203639715038452351f,
-0.63912444486377573138f,0.76910333764557958780f,-0.64265703396622686494f,
0.76615399019631280630f,-0.64617601298331639459f,0.76318841726338115805f,
-0.64968130739068330470f,0.76020668165120230952f,-0.65317284295377653347f,
0.75720884650648467851f,-0.65665054572942882505f,0.75419497531688928227f,
-0.66011434206742036768f,0.75116513190968658975f,-0.66356415861203965623f,
0.74811938045040371481f,-0.66699992230363736034f,0.74505778544146605835f,
-0.67042156038017308717f,0.74198041172083106787f,-0.67382900037875603783f,
0.73888732446061522463f,-0.67722217013718044587f,0.73577858916571359238f,
-0.68060099779545302212f,0.73265427167241281570f,-0.68396541179731551452f,
0.72951443814699701296f,-0.68731534089175916336f,0.72635915508434589771f,
-0.69065071413453438254f,0.72318848930652757101f,-0.69397146088965377952f,
0.72000250796138176579f,-0.69727751083088640449f,0.71680127852109964959f,
-0.70056879394324822474f,0.71358486878079363525f,-0.70384524052448482756f,
0.71035334685706241764f,-0.70710678118654746172f,0.70710678118654757274f,
-0.71035334685706230662f,0.70384524052448504960f,-0.71358486878079352422f,
0.70056879394324833576f,-0.71680127852109953857f,0.69727751083088651551f,
-0.72000250796138165477f,0.69397146088965389055f,-0.72318848930652745999f,
0.69065071413453460458f,-0.72635915508434578669f,0.68731534089175927438f,
-0.72951443814699679091f,0.68396541179731562554f,-0.73265427167241270467f,
0.68060099779545324417f,-0.73577858916571337033f,0.67722217013718055689f,
-0.73888732446061511361f,0.67382900037875614885f,-0.74198041172083095685f,
0.67042156038017319819f,-0.74505778544146594733f,0.66699992230363758239f,
-0.74811938045040360379f,0.66356415861203976725f,-0.75116513190968636771f,
0.66011434206742047870f,-0.75419497531688917125f,0.65665054572942904709f,
-0.75720884650648467851f,0.65317284295377664449f,-0.76020668165120219850f,
0.64968130739068341573f,-0.76318841726338115805f,0.64617601298331661663f,
-0.76615399019631280630f,0.64265703396622708699f,-0.76910333764557947678f,
0.63912444486377584241f,-0.77203639715038441249f,0.63557832048855622542f,
-0.77495310659487381955f,0.63201873593980906207f,-0.77785340420945303652f,
0.62844576660183271155f,-0.78073722857209448822f,0.62485948814238634341f,
-0.78360451860963820092f,0.62125997651108755271f,-0.78645521359908576731f,
0.61764730793780386886f,-0.78928925316888576269f,0.61402155893103838036f,
-0.79210657730021216683f,0.61038280627630969732f,-0.79490712632823679051f,
0.60673112703452469763f,-0.79769084094339093305f,0.60306659854034838641f,
-0.80045766219262259877f,0.59938929840056465181f,-0.80320753148064483184f,
0.59569930449243346793f,-0.80594039057117627944f,0.59199669496204099239f,
-0.80865618158817498262f,0.58828154822264533408f,-0.81135484701706372945f,
0.58455394295301532637f,-0.81403632970594841378f,0.58081395809576452649f,
-0.81670057286682784525f,0.57706167285567944170f,-0.81934752007679700903f,
0.57329716669804209328f,-0.82197711527924133268f,0.56952051934694747359f,
-0.82458930278502506894f,0.56573181078361345353f,-0.82718402727366902027f,
0.56193112124468957980f,-0.82976123379452293438f,0.55811853122055632426f,
-0.83232086776792957306f,0.55429412145362022546f,-0.83486287498638001026f,
0.55045797293660492233f,-0.83738720161566182476f,0.54661016691083497143f,
-0.83989379419599952126f,0.54275078486451588944f,-0.84238259964318584760f,
0.53887990853100842248f,-0.84485356524970711689f,0.53499761988709715332f,
-0.84730663868585842646f,0.53110400115125488973f,-0.84974176800085254868f,
0.52719913478190127964f,-0.85215890162391960683f,0.52328310347565665239f,
-0.85455798836540042274f,0.51935599016558975372f,-0.85693897741782865118f,
0.51541787801946314929f,-0.85930181835700836235f,0.51146885043797052361f,
-0.86164646114308129921f,0.50750899105297098135f,-0.86397285612158669643f,
0.50353838372571757542f,-0.86628095402451299467f,0.49955711254508189390f,
-0.86857070597134089507f,0.49556526182577254058f,-0.87084206347007886428f,
0.49156291610654989643f,-0.87309497841829009079f,0.48755016014843588490f,
-0.87532940310411089246f,0.48352707893291863028f,-0.87754529020726113053f,
0.47949375766015328582f,-0.87974259280004729611f,0.47545028174715608937f,
-0.88192126434835493853f,0.47139673682599780857f,-0.88408125871263487650f,
0.46733320874198858164f,-0.88622253014888052736f,0.46325978355186031576f,
-0.88834503330959624368f,0.45917654752194420054f,-0.89044872324475787817f,
0.45508358712634389143f,-0.89253355540276457791f,0.45098098904510386387f,
-0.89459948563138269595f,0.44686884016237415906f,-0.89664647017868026602f,
0.44274722756456996731f,-0.89867446569395392775f,0.43861623853852754751f,
-0.90068342922864674804f,0.43447596056965598343f,-0.90267331823725871498f,
0.43032648134008288920f,-0.90464409057824612947f,0.42616788872679983724f,
-0.90659570451491533483f,0.42200027079979984812f,-0.90852811871630612117f,
0.41782371582021243794f,-0.91044129225806713634f,0.41363831223843466889f,
-0.91233518462332274801f,0.40944414869225770337f,-0.91420975570353069095f,
0.40524131400498991651f,-0.91606496579933172075f,0.40102989718357562321f,
-0.91790077562139049672f,0.39680998741671025254f,-0.91971714629122736095f,
0.39258167407295141427f,-0.92151403934204179080f,0.38834504669882657923f,
-0.92329141671952752457f,0.38410019501693531963f,-0.92504924078267747323f,
0.37984720892405138271f,-0.92678747430458174872f,0.37558617848921738158f,
-0.92850608047321547822f,0.37131719395183770960f,-0.93020502289221906889f,
0.36704034571976729140f,-0.93188426558166803648f,0.36275572436739728088f,
-0.93354377297883617270f,0.35846342063373659581f,-0.93518350993894761025f,
0.35416352542049039931f,-0.93680344173592167145f,0.34985612979013486212f,
-0.93840353406310816897f,0.34554132496398898278f,-0.93998375303401382475f,
0.34121920232028268849f,-0.94154406518302069529f,0.33688985339222032867f,
-0.94308443746609338376f,0.33255336986604444593f,-0.94460483726148014583f,
0.32820984357909271933f,-0.94610523237040333733f,0.32385936651785302010f,
-0.94758559101774109124f,0.31950203081601580291f,-0.94904588185270055689f,
0.31513792875252250036f,-0.95048607394948170235f,0.31076715274961153046f,
-0.95190613680793234597f,0.30638979537086091787f,-0.95330604035419386211f,
0.30200594931922802866f,-0.95468575494133833814f,0.29761570743508614090f,
-0.95604525134999629454f,0.29321916269425896129f,-0.95738450078897585627f,
0.28881640820604975728f,-0.95870347489587148804f,0.28440753721127209896f,
-0.96000214573766584625f,0.27999264308027344006f,-0.96128048581132063966f,
0.27557181931095831029f,-0.96253846804435916340f,0.27114515952680812161f,
-0.96377606579543984022f,0.26671275747489847641f,-0.96499325285492032478f,
0.26227470702391370017f,-0.96619000344541250413f,0.25783110216215898713f,
-0.96736629222232850545f,0.25338203699557010351f,-0.96852209427441737777f,
0.24892760574572009302f,-0.96965738512429233698f,0.24446790274782448371f,
-0.97077214072895023911f,0.24000302244874177626f,-0.97186633748027928537f,
0.23553305940497573645f,-0.97293995220556006576f,0.23105810828067133156f,
-0.97399296216795583359f,0.22657826384561016719f,-0.97502534506699412020f,
0.22209362097320364815f,-0.97603707903903902388f,0.21760427463848372454f,
-0.97702814265775439484f,0.21311031991609141745f,-0.97799851493455713936f,
0.20861185197826351279f,-0.97894817531906219710f,0.20410896609281684033f,
-0.97987710369951763756f,0.19960175762113091524f,-0.98078528040323043058f,
0.19509032201612860891f,-0.98167268619698311305f,0.19057475482025307278f,
-0.98253930228744124076f,0.18605515166344691047f,-0.98338511032155118130f,
0.18153160826112521575f,-0.98421009238692902521f,0.17700422041214894375f,
-0.98501423101223983814f,0.17247308399679611712f,-0.98579750916756736512f,
0.16793829497473128365f,-0.98655991026477540817f,0.16339994938297328075f,
-0.98730141815785843473f,0.15885814333386147346f,-0.98802201714328352633f,
0.15431297301302007718f,-0.98872169196032377858f,0.14976453467732145364f,
-0.98940042779138037687f,0.14521292465284735274f,-0.99005821026229701154f,
0.14065823933284954395f,-0.99069502544266463406f,0.13610057517570647856f,
-0.99131085984611544415f,0.13154002870288333815f,-0.99190570043060932726f,
0.12697669649688606008f,-0.99247953459870996706f,0.12241067519921634832f,
-0.99303235019785141002f,0.11784206150832508830f,-0.99356413552059530403f,
0.11327095217756441570f,-0.99407487930487936634f,0.10869744401313874427f,
-0.99456457073425541537f,0.10412163387205457254f,-0.99503319943811863180f,
0.09954361866006927739f,-0.99548075549192693856f,0.09496349532963890838f,
-0.99590722941741172125f,0.09038136087786528827f,-0.99631261218277800129f,
0.08579731234444015753f,-0.99669689520289606044f,0.08121144680959266338f,
-0.99706007033948296225f,0.07662386139203168633f,-0.99740212990127530279f,
0.07203465324688947125f,-0.99772306664419163624f,0.06744391956366417584f,
-0.99802287377148624081f,0.06285175756416148951f,-0.99830154493389289261f,
0.05825826450043579408f,-0.99855907422975931365f,0.05366353765273051968f,
-0.99879545620517240501f,0.04906767432741796636f,-0.99901068585407337697f,
0.04447077185493858442f,-0.99920475861836388631f,0.03987292758774012985f,
-0.99937767038800284780f,0.03527423889821423159f,-0.99952941750109314256f,
0.03067480317663686534f,-0.99965999674395922270f,0.02607471782910409860f,
-0.99976940535121527898f,0.02147408027546966747f,-0.99985764100582386060f,
0.01687298794728183532f,-0.99992470183914450299f,0.01227153828572000692f,
-0.99997058643097413988f,0.00766982873953113778f,-0.99999529380957619118f,
0.00306795676296597701f,-0.99999882345170187925f,-0.00153398018628480431f,
-0.99998117528260110909f,-0.00613588464915455420f,-0.99994234967602391162f,
-0.01073765916726416615f,-0.99988234745421256111f,-0.01533920628498781566f,
-0.99980116988788425569f,-0.01994042855151419158f,-0.99969881869620424997f,
-0.02454122852291207996f,-0.99957529604674921764f,-0.02914150876419355565f,
-0.99943060455546173237f,-0.03374117185137745500f,-0.99926474728659442359f,
-0.03834012037355261082f,-0.99907772775264536147f,-0.04293825693494077861f,
-0.99886954991428356099f,-0.04753548415695929563f,-0.99864021818026527111f,
-0.05213170468028335142f,-0.99838973740734016094f,-0.05672682116690781762f,
-0.99811811290014917919f,-0.06132073630220824523f,-0.99782535041111164453f,
-0.06591335279700352712f,-0.99751145614030345410f,-0.07050457338961360620f,
-0.99717643673532618820f,-0.07509430084792109716f,-0.99682029929116577893f,
-0.07968243797142994522f,-0.99644305135004263008f,-0.08426888759332393231f,
-0.99604470090125196702f,-0.08885355258252450317f,-0.99562525638099430569f,
-0.09343633584574773110f,-0.99518472667219692873f,-0.09801714032956058975f,
-0.99472312110432570265f,-0.10259586902243630901f,-0.99424044945318790223f,
-0.10717242495680891212f,-0.99373672194072470987f,-0.11174671121112625394f,
-0.99321194923479461103f,-0.11631863091190447479f,-0.99266614244894801899f,
-0.12088808723577681992f,-0.99209931314219179654f,-0.12545498341154601163f,
-0.99151147331874400770f,-0.13001922272223317978f,-0.99090263542778000971f,
-0.13458070850712605671f,-0.99027281236316910817f,-0.13913934416382611747f,
-0.98962201746320088702f,-0.14369503315029438784f,-0.98895026451030298986f,
-0.14824767898689603096f,-0.98825756773074946437f,-0.15279718525844343535f,
-0.98754394179435922574f,-0.15734345561623830356f,-0.98680940181418552726f,
-0.16188639378011149272f,-0.98605396334619543897f,-0.16642590354046382650f,
-0.98527764238894133264f,-0.17096188876030096737f,-0.98448045538322093151f,
-0.17549425337727120322f,-0.98366241921173025453f,-0.18002290140569934818f,
-0.98282355119870534743f,-0.18454773693861947770f,-0.98196386910955524296f,
-0.18906866414980610935f,-0.98108339115048670553f,-0.19358558729580355173f,
-0.98018213596811742949f,-0.19809841071795356027f,-0.97926012264908202098f,
-0.20260703884442113343f,-0.97831737071962765473f,-0.20711137619221858808f,
-0.97735390014519996082f,-0.21161132736922766417f,-0.97636973133002125103f,
-0.21610679707621921475f,-0.97536488511665697665f,-0.22059769010887325669f,
-0.97433938278557585821f,-0.22508391135979261000f,-0.97329324605469824672f,
-0.22956536582051870199f,-0.97222649707893638027f,-0.23404195858354326365f,
-0.97113915844972520386f,-0.23851359484431830515f,-0.97003125319454397424f,
-0.24298017990326381543f,-0.96890280477642887202f,-0.24744161916777326904f,
-0.96775383709347551076f,-0.25189781815421696809f,-0.96658437447833311928f,
-0.25634868248994291395f,-0.96539444169768939830f,-0.26079411791527562503f,
-0.96418406395174582890f,-0.26523403028551151284f,-0.96295326687368398844f,
-0.26966832557291481320f,-0.96170207652912265139f,-0.27409690986870616225f,
-0.96043051941556589757f,-0.27851968938505289319f,-0.95913862246184200533f,
-0.28293657045705516984f,-0.95782641302753290802f,-0.28734745954472939999f,
-0.95649391890239510161f,-0.29175226323498920644f,-0.95514116830577078243f,
-0.29615088824362378883f,-0.95376818988599032512f,-0.30054324141727345454f,
-0.95237501271976587880f,-0.30492922973540242948f,-0.95096166631157508231f,
-0.30930876031226878231f,-0.94952818059303678577f,-0.31368174039889118454f,
-0.94807458592227633609f,-0.31804807738501467140f,-0.94660091308328364601f,
-0.32240767880106963039f,-0.94510719328526060501f,-0.32676045232013156694f,
-0.94359345816196038559f,-0.33110630575987626267f,-0.94205973977101742367f,
-0.33544514708453149199f,-0.94050607059326840620f,-0.33977688440682679571f,
-0.93893248353206459900f,-0.34410142598993881391f,-0.93733901191257495977f,
-0.34841868024943456472f,-0.93572568948108036935f,-0.35272855575521072646f,
-0.93409255040425887007f,-0.35703096123343008861f,-0.93243962926846246653f,
-0.36132580556845395048f,-0.93076696107898382326f,-0.36561299780477357624f,
-0.92907458125931585702f,-0.36989244714893387833f,-0.92736252565040111495f,
-0.37416406297145782256f,-0.92563083050987282618f,-0.37842775480876539307f,
-0.92387953251128684951f,-0.38268343236508967076f,-0.92210866874334518339f,
-0.38693100551438852630f,-0.92031827670911059425f,-0.39117038430225381518f,
-0.91850839432521225181f,-0.39540147894781629834f,-0.91667905992104270485f,
-0.39962419984564684361f,-0.91483031223794608611f,-0.40383845756765418544f,
-0.91296219042839832358f,-0.40804416286497835475f,-0.91107473405517647169f,
-0.41224122666988260999f,-0.90916798309052249127f,-0.41642956009763693048f,
-0.90724197791529592738f,-0.42060907444840234248f,-0.90529675931811881551f,
-0.42477968120910863936f,-0.90333236849451192807f,-0.42894129205532938176f,
-0.90134884704602202810f,-0.43309381885315184624f,-0.89934623697934157338f,
-0.43723717366104403181f,-0.89732458070541831763f,-0.44137126873171667052f,
-0.89528392103855747308f,-0.44549601651398174074f,-0.89322430119551532446f,
-0.44961132965460665067f,-0.89114576479458340597f,-0.45371712100016353686f,
-0.88904835585466468473f,-0.45781330359887695280f,-0.88693211879434230571f,
-0.46189979070246250936f,-0.88479709843093790056f,-0.46597649576796595916f,
-0.88264333997956290201f,-0.47004333245959545318f,-0.88047088905216086552f,
-0.47410021465054985601f,-0.87827979165654157523f,-0.47814705642484295334f,
-0.87607009419540660122f,-0.48218377207912266336f,-0.87384184346536686316f,
-0.48621027612448636246f,-0.87159508665595109012f,-0.49022648328829115938f,
-0.86932987134860673084f,-0.49423230851595978397f,-0.86704624551569287050f,
-0.49822766697278153547f,-0.86474425751946248919f,-0.50221247404571056627f,
-0.86242395611104072373f,-0.50618664534515500630f,-0.86008539042939025077f,
-0.51015009670676658704f,-0.85772861000027211809f,-0.51410274419322155026f,
-0.85535366473519613972f,-0.51804450409599922533f,-0.85296060493036374162f,
-0.52197529293715427823f,-0.85054948126560347976f,-0.52589502747108463065f,
-0.84812034480329723252f,-0.52980362468629460526f,-0.84567324698729906540f,
-0.53370100180715296379f,-0.84320823964184543620f,-0.53758707629564550512f,
-0.84072537497045818355f,-0.54146176585312322249f,-0.83822470555483818977f,
-0.54532498842204613076f,-0.83570628435375271525f,-0.54917666218771943321f,
-0.83317016470191329613f,-0.55301670558002735678f,-0.83061640030884642538f,
-0.55684503727515988203f,-0.82804504525775590729f,-0.56066157619733592021f,
-0.82545615400437755138f,-0.56446624152051938506f,-0.82284978137582642788f,
-0.56825895267013148970f,-0.82022598256943468620f,-0.57203962932475704850f,
-0.81758481315158371139f,-0.57580819141784533866f,-0.81492632905652662156f,
-0.57956455913940574387f,-0.81225058658520388200f,-0.58330865293769829094f,
-0.80955764240405148069f,-0.58704039352091774706f,-0.80684755354379944503f,
-0.59075970185887394237f,-0.80412037739826591753f,-0.59446649918466420992f,
-0.80137617172314035141f,-0.59816070699634216190f,-0.79861499463476093297f,
-0.60184224705857991555f,-0.79583690460888356633f,-0.60551104140432543410f,
-0.79304196047944375270f,-0.60916701233645309532f,-0.79023022143731003197f,
-0.61281008242940970820f,-0.78740174702903142911f,-0.61644017453085364622f,
-0.78455659715557524159f,-0.62005721176328920663f,-0.78169483207105938671f,
-0.62366111752569464155f,-0.77881651238147620031f,-0.62725181549514386070f,
-0.77592169904340779762f,-0.63082922962842424841f,-0.77301045336273710440f,
-0.63439328416364526575f,-0.77008283699334811878f,-0.63794390362184394405f,
-0.76713891193582051109f,-0.64148101280858305095f,-0.76417874053611678509f,
-0.64500453681554381635f,-0.76120238548426188974f,-0.64851440102211233008f,
-0.75820990981301539247f,-0.65201053109695950027f,-0.75520137689653654700f,
-0.65549285299961534967f,-0.75217685044904269986f,-0.65896129298203731661f,
-0.74913639452345925918f,-0.66241577759017178373f,-0.74608007351006400132f,
-0.66585623366550938940f,-0.74300795213512194071f,-0.66928258834663578725f,
-0.73992009545951631377f,-0.67269476907077274674f,-0.73681656887737001504f,
-0.67609270357531581208f,-0.73369743811466037187f,-0.67947631989936485564f,
-0.73056276922782770189f,-0.68284554638524797010f,-0.72741262860237587695f,
-0.68620031168003847721f,-0.72424708295146700276f,-0.68954054473706682948f,
-0.72106619931450810501f,-0.69286617481742462932f,-0.71787004505573170920f,
-0.69617713149146298601f,-0.71465868786276898206f,-0.69947334464028387835f,
-0.71143219574521665560f,-0.70275474445722507788f,-0.70819063703319551362f,
-0.70602126144933952112f,-0.70493408037590510329f,-0.70927282643886546687f,
-0.70166259474016867692f,-0.71250937056469221265f,-0.69837624940897302661f,
-0.71573082528381848366f,-0.69507511398000099145f,-0.71893712237280438249f,
-0.69175925836415785852f,-0.72212819392921523409f,-0.68842875278409054740f,
-0.72530397237306065694f,-0.68508366777270035541f,-0.72846439044822519637f,
-0.68172407417164981869f,-0.73160938122389251870f,-0.67835004312986146857f,
-0.73473887809596349907f,-0.67496164610201225820f,-0.73785281478846576064f,
-0.67155895484701866316f,-0.74095112535495888384f,-0.66814204142651867357f,
-0.74403374417992906853f,-0.66471097820334501538f,-0.74710060598017991040f,
-0.66126583783999237642f,-0.75015164580621496171f,-0.65780669329707874837f,
-0.75318679904361240940f,-0.65433361783180066240f,-0.75620600141439442421f,
-0.65084668499638098638f,-0.75920918897838796102f,-0.64734596863651250320f,
-0.76219629813457856482f,-0.64383154288979149715f,-0.76516726562245895860f,
-0.64030348218415200634f,-0.76812202852336519676f,-0.63676186123628419899f,
-0.77106052426181381776f,-0.63320675505005752370f,-0.77398269060682256537f,
-0.62963823891492687324f,-0.77688846567323255332f,-0.62605638840434374437f,
-0.77977778792301433164f,-0.62246127937414974518f,-0.78265059616657584041f,
-0.61885298796097643059f,-0.78550682956405382118f,-0.61523159058062726334f,
-0.78834642762660589455f,-0.61159716392646201744f,-0.79116933021769009216f,
-0.60794978496777407617f,-0.79397547755433683925f,-0.60428953094815607283f,
-0.79676481020841871672f,-0.60061647938386930612f,-0.79953726910790479110f,
-0.59693070806219639124f,-0.80229279553811572168f,-0.59323229503980012822f,
-0.80503133114296343553f,-0.58952131864106382952f,-0.80775281792619046950f,
-0.58579785745643908612f,-0.81045719825259465718f,-0.58206199034077532595f,
-0.81314441484925370496f,-0.57831379641165570060f,-0.81581441080673366972f,
-0.57455335504771631872f,-0.81846712958029832485f,-0.57078074588696736669f,
-0.82110251499110464835f,-0.56699604882510901138f,-0.82372051122739109452f,
-0.56319934401383409117f,-0.82632106284566342325f,-0.55939071185913646911f,
-0.82890411477186465294f,-0.55557023301960217765f,-0.83146961230254523567f,
-0.55173798840470766880f,-0.83401750110601791111f,-0.54789405917310007865f,
-0.83654772722351211645f,-0.54403852673088415326f,-0.83906023707031252012f,
-0.54017147272989274320f,-0.84155497743689855472f,-0.53629297906596329337f,
-0.84403189549006629733f,-0.53240312787719845655f,-0.84649093877405179320f,
-0.52850200154222859439f,-0.84893205521163961347f,-0.52458968267846928235f,
-0.85135519310526486247f,-0.52066625414036715735f,-0.85376030113811141042f,
-0.51673179901765020627f,-0.85614732837519424979f,-0.51278640063356295542f,
-0.85851622426444285097f,-0.50883014254310732216f,-0.86086693863776708735f,
-0.50486310853126736831f,-0.86319942171212427073f,-0.50088538261124104789f,
-0.86551362409056897818f,-0.49689704902265435793f,-0.86780949676330332299f,
-0.49289819222978420443f,-0.87008699110871134952f,-0.48888889691976367136f,
-0.87234605889439120752f,-0.48486924800079117537f,-0.87458665227817611321f,
-0.48083933060033440254f,-0.87680872380914542941f,-0.47679923006332214364f,
-0.87901222642863341417f,-0.47274903195034317926f,-0.88119711347122187117f,
-0.46868882203582790114f,-0.88336333866573157891f,-0.46461868630623814891f,
-0.88551085613619973103f,-0.46053871095823989412f,-0.88763962040285404598f,
-0.45644898239688419528f,-0.88974958638307266590f,-0.45234958723377066692f,
-0.89184070939234283415f,-0.44824061228522010802f,-0.89391294514520314163f,
-0.44412214457042975546f,-0.89596624975618488484f,-0.43999427130963336685f,
-0.89800057974073976830f,-0.43585707992225597440f,-0.90001589201615994629f,
-0.43171065802505731446f,-0.90201214390249317976f,-0.42755509343028247349f,
-0.90398929312344311615f,-0.42339047414379599177f,-0.90594729780726845902f,
-0.41921688836322429372f,-0.90788611648766603945f,-0.41503442447608152044f,
-0.90980570810465233311f,-0.41084317105790418845f,-0.91170603200542976730f,
-0.40664321687036886210f,-0.91358704794525091852f,-0.40243465085941865222f,
-0.91544871608826772214f,-0.39821756215337417162f,-0.91729099700837768427f,
-0.39399204006104820985f,-0.91911385169005765938f,-0.38975817406985696634f,
-0.92091724152918930102f,-0.38551605384391890441f,-0.92270112833387851747f,
-0.38126576922216276477f,-0.92446547432526249288f,-0.37700741021641820394f,
-0.92621024213831137928f,-0.37274106700951614712f,-0.92793539482261766516f,
-0.36846682995337221023f,-0.92964089584318132520f,-0.36418478956708016936f,
-0.93132670908118031505f,-0.35989503653498794433f,-0.93299279883473895669f,
-0.35559766170478407377f,-0.93463912981968066962f,-0.35129275608556687072f,
-0.93626566717027837061f,-0.34698041084592379235f,-0.93787237643998977443f,
-0.34266071731199487793f,-0.93945922360218969693f,-0.33833376696554123830f,
-0.94102617505088925753f,-0.33399965144200982614f,-0.94257319760144675502f,
-0.32965846252858749255f,-0.94410025849127265918f,-0.32531029216226331480f,
-0.94560732538052116869f,-0.32095523242787515894f,-0.94709436635277721717f,
-0.31659337555616617887f,-0.94856134991573015647f,-0.31222481392182477311f,
-0.95000824500184311017f,-0.30784964004153508865f,-0.95143502096900833820f,
-0.30346794657201103806f,-0.95284164760119871573f,-0.29907982630804058610f,
-0.95422809510910555630f,-0.29468537218051488180f,-0.95559433413077088382f,
-0.29028467725446244208f,-0.95694033573220882438f,-0.28587783472708105936f,
-0.95826607140801756124f,-0.28146493792575794091f,-0.95957151308198451733f,
-0.27704608030610028413f,-0.96085663310767954748f,-0.27262135544994886560f,
-0.96212140426904158019f,-0.26819085706340350939f,-0.96336579978095393528f,
-0.26375467897483123592f,-0.96458979328981275803f,-0.25931291513288645678f,
-0.96579335887408357397f,-0.25486565960451434965f,-0.96697647104485218161f,
-0.25041300657296539089f,-0.96813910474636233339f,-0.24595505033579515008f,
-0.96928123535654830967f,-0.24149188530286941345f,-0.97040283868755550234f,
-0.23702360599436766986f,-0.97150389098625167250f,-0.23255030703877521692f,
-0.97258436893473221296f,-0.22807208317088611960f,-0.97364424965081186603f,
-0.22358902922978990402f,-0.97468351068851066810f,-0.21910124015687010290f,
-0.97570213003852845901f,-0.21460881099378659176f,-0.97670008612871184184f,
-0.21011183688046985996f,-0.97767735782450992943f,-0.20561041305309901706f,
-0.97863392442942320759f,-0.20110463484209206708f,-0.97956976568544051887f,
-0.19659459767008077846f,-0.98048486177346927395f,-0.19208039704989252061f,
-0.98137919331375456089f,-0.18756212858253007436f,-0.98225274136628937249f,
-0.18303988795514095078f,-0.98310548743121628501f,-0.17851377093899792325f,
-0.98393741344921881176f,-0.17398387338746373887f,-0.98474850180190420801f,
-0.16945029123396829207f,-0.98553873531217606185f,-0.16491312048996975559f,
-0.98630809724459866938f,-0.16037245724292850668f,-0.98705657130575097380f,
-0.15582839765426498291f,-0.98778414164457217783f,-0.15128103795733036097f,
-0.98849079285269658701f,-0.14673047445536230304f,-0.98917650996478090342f,
-0.14217680351944814165f,-0.98984127845882052821f,-0.13762012158648653792f,
-0.99048508425645698239f,-0.13306052515713906459f,-0.99110791372327688986f,
-0.12849811079379358514f,-0.99170975366909952520f,-0.12393297511851208981f,
-0.99229059134825736699f,-0.11936521481099168773f,-0.99285041445986510489f,
-0.11479492660650993108f,-0.99338921114808065305f,-0.11022220729388330918f,
-0.99390697000235606051f,-0.10564715371341037997f,-0.99440368005767909576f,
-0.10106986275482798820f,-0.99487933079480561638f,-0.09649043135525316173f,
-0.99533391214048216877f,-0.09190895649713282101f,-0.99576741446765981713f,
-0.08732553520619255882f,-0.99617982859569687015f,-0.08274026454937570552f,
-0.99657114579055483539f,-0.07815324163279464831f,-0.99694135776498205015f,
-0.07356456359966735692f,-0.99729045667869020697f,-0.06897432762826707919f,
-0.99761843513851955478f,-0.06438263092985731240f,-0.99792528619859599548f,
-0.05978957074664013188f,-0.99821100336047818846f,-0.05519524434968971216f,
-0.99847558057329477421f,-0.05059974903689945513f,-0.99871901223387293811f,
-0.04600318213091520586f,-0.99894129318685687124f,-0.04140564097707683661f,
-0.99914241872481690532f,-0.03680722294135933131f,-0.99932238458834943273f,
-0.03220802540830459970f,-0.99948118696616694567f,-0.02760814577896616301f,
-0.99961882249517863830f,-0.02300768146883930970f,-0.99973528826056168306f,
-0.01840672990580516366f,-0.99983058179582340319f,-0.01380538852806025008f,
-0.99990470108285289808f,-0.00920375478206008311f,-0.99995764455196389786f,
-0.00460192612044835019f,-0.99998941108192840321f,1.00000000000000000000f,
0.00000000000000000000f,0.99983058179582340319f,0.01840672990580482019f,
0.99932238458834954375f,0.03680722294135883171f,0.99847558057329477421f,
0.05519524434968993420f,0.99729045667869020697f,0.07356456359966742631f,
0.99576741446765981713f,0.09190895649713272386f,0.99390697000235606051f,
0.11022220729388305938f,0.99170975366909952520f,0.12849811079379316880f,
0.98917650996478101444f,0.14673047445536174793f,0.98630809724459866938f,
0.16491312048996989437f,0.98310548743121628501f,0.18303988795514095078f,
0.97956976568544051887f,0.20110463484209190055f,0.97570213003852857003f,
0.21910124015686979759f,0.97150389098625178352f,0.23702360599436719801f,
0.96697647104485207059f,0.25486565960451457169f,0.96212140426904158019f,
0.27262135544994897662f,0.95694033573220882438f,0.29028467725446233105f,
0.95143502096900833820f,0.30784964004153486661f,0.94560732538052127971f,
0.32531029216226292622f,0.93945922360218991898f,0.34266071731199437833f,
0.93299279883473895669f,0.35989503653498811087f,0.92621024213831137928f,
0.37700741021641825945f,0.91911385169005777040f,0.39399204006104809883f,
0.91170603200542987832f,0.41084317105790391089f,0.90398929312344333820f,
0.42755509343028208491f,0.89596624975618521791f,0.44412214457042920035f,
0.88763962040285393496f,0.46053871095824000514f,0.87901222642863352519f,
0.47679923006332208812f,0.87008699110871146054f,0.49289819222978403790f,
0.86086693863776730939f,0.50883014254310698909f,0.85135519310526519554f,
0.52458968267846894928f,0.84155497743689844370f,0.54017147272989285423f,
0.83146961230254523567f,0.55557023301960217765f,0.82110251499110464835f,
0.57078074588696725566f,0.81045719825259476821f,0.58579785745643886408f,
0.79953726910790501314f,0.60061647938386897305f,0.78834642762660622761f,
0.61523159058062681925f,0.77688846567323244230f,0.62963823891492698426f,
0.76516726562245895860f,0.64383154288979138613f,0.75318679904361252042f,
0.65780669329707863735f,0.74095112535495921691f,0.67155895484701833009f,
0.72846439044822519637f,0.68508366777270035541f,0.71573082528381870571f,
0.69837624940897280457f,0.70275474445722529993f,0.71143219574521643356f,
0.68954054473706694051f,0.72424708295146689174f,0.67609270357531603413f,
0.73681656887736979300f,0.66241577759017178373f,0.74913639452345925918f,
0.64851440102211255212f,0.76120238548426177871f,0.63439328416364548779f,
0.77301045336273688235f,0.62005721176328920663f,0.78455659715557524159f,
0.60551104140432554512f,0.79583690460888345530f,0.59075970185887427544f,
0.80684755354379922299f,0.57580819141784533866f,0.81758481315158371139f,
0.56066157619733603124f,0.82804504525775579626f,0.54532498842204646383f,
0.83822470555483796772f,0.52980362468629482731f,0.84812034480329712149f,
0.51410274419322166128f,0.85772861000027211809f,0.49822766697278186854f,
0.86704624551569264845f,0.48218377207912282989f,0.87607009419540660122f,
0.46597649576796612569f,0.88479709843093778954f,0.44961132965460659516f,
0.89322430119551532446f,0.43309381885315201277f,0.90134884704602202810f,
0.41642956009763731906f,0.90916798309052226923f,0.39962419984564678810f,
0.91667905992104270485f,0.38268343236508983729f,0.92387953251128673848f,
0.36561299780477396482f,0.93076696107898371224f,0.34841868024943450921f,
0.93733901191257495977f,0.33110630575987642921f,0.94359345816196038559f,
0.31368174039889157312f,0.94952818059303667475f,0.29615088824362395536f,
0.95514116830577067141f,0.27851968938505305973f,0.96043051941556578655f,
0.26079411791527556952f,0.96539444169768939830f,0.24298017990326398197f,
0.97003125319454397424f,0.22508391135979277653f,0.97433938278557585821f,
0.20711137619221856032f,0.97831737071962765473f,0.18906866414980627589f,
0.98196386910955524296f,0.17096188876030135595f,0.98527764238894122162f,
0.15279718525844340760f,0.98825756773074946437f,0.13458070850712622324f,
0.99090263542778000971f,0.11631863091190487725f,0.99321194923479450001f,
0.09801714032956077016f,0.99518472667219681771f,0.07968243797143012563f,
0.99682029929116566791f,0.06132073630220864768f,0.99811811290014917919f,
0.04293825693494095902f,0.99907772775264536147f,0.02454122852291226384f,
0.99969881869620424997f,0.00613588464915451517f,0.99998117528260110909f,
-0.01227153828571982304f,0.99992470183914450299f,-0.03067480317663645942f,
0.99952941750109314256f,-0.04906767432741800800f,0.99879545620517240501f,
-0.06744391956366398155f,0.99772306664419163624f,-0.08579731234443975507f,
0.99631261218277800129f,-0.10412163387205460030f,0.99456457073425541537f,
-0.12241067519921615403f,0.99247953459870996706f,-0.14065823933284912761f,
0.99005821026229712256f,-0.15885814333386127917f,0.98730141815785843473f,
-0.17700422041214874946f,0.98421009238692902521f,-0.19509032201612819257f,
0.98078528040323043058f,-0.21311031991609125091f,0.97702814265775439484f,
-0.23105810828067113727f,0.97293995220556017678f,-0.24892760574572012078f,
0.96852209427441737777f,-0.26671275747489830987f,0.96377606579543984022f,
-0.28440753721127171039f,0.95870347489587159906f,-0.30200594931922808417f,
0.95330604035419386211f,-0.31950203081601563637f,0.94758559101774120226f,
-0.33688985339221994009f,0.94154406518302080631f,-0.35416352542049039931f,
0.93518350993894761025f,-0.37131719395183748755f,0.92850608047321558924f,
-0.38834504669882619066f,0.92151403934204201285f,-0.40524131400498974998f,
0.91420975570353069095f,-0.42200027079979968159f,0.90659570451491533483f,
-0.43861623853852738097f,0.89867446569395392775f,-0.45508358712634372489f,
0.89044872324475798919f,-0.47139673682599769755f,0.88192126434835504956f,
-0.48755016014843571837f,0.87309497841829020182f,-0.50353838372571746440f,
0.86397285612158680745f,-0.51935599016558964269f,0.85455798836540053376f,
-0.53499761988709704230f,0.84485356524970722791f,-0.55045797293660470029f,
0.83486287498638012128f,-0.56573181078361323149f,0.82458930278502517996f,
-0.58081395809576441547f,0.81403632970594852480f,-0.59569930449243335691f,
0.80320753148064494287f,-0.61038280627630958630f,0.79210657730021227785f,
-0.62485948814238623239f,0.78073722857209459924f,-0.63912444486377573138f,
0.76910333764557958780f,-0.65317284295377653347f,0.75720884650648467851f,
-0.66699992230363736034f,0.74505778544146605835f,-0.68060099779545302212f,
0.73265427167241281570f,-0.69397146088965377952f,0.72000250796138176579f,
-0.70710678118654746172f,0.70710678118654757274f,-0.72000250796138165477f,
0.69397146088965389055f,-0.73265427167241270467f,0.68060099779545324417f,
-0.74505778544146594733f,0.66699992230363758239f,-0.75720884650648467851f,
0.65317284295377664449f,-0.76910333764557947678f,0.63912444486377584241f,
-0.78073722857209448822f,0.62485948814238634341f,-0.79210657730021216683f,
0.61038280627630969732f,-0.80320753148064483184f,0.59569930449243346793f,
-0.81403632970594841378f,0.58081395809576452649f,-0.82458930278502506894f,
0.56573181078361345353f,-0.83486287498638001026f,0.55045797293660492233f,
-0.84485356524970711689f,0.53499761988709715332f,-0.85455798836540042274f,
0.51935599016558975372f,-0.86397285612158669643f,0.50353838372571757542f,
-0.87309497841829009079f,0.48755016014843588490f,-0.88192126434835493853f,
0.47139673682599780857f,-0.89044872324475787817f,0.45508358712634389143f,
-0.89867446569395392775f,0.43861623853852754751f,-0.90659570451491533483f,
0.42200027079979984812f,-0.91420975570353069095f,0.40524131400498991651f,
-0.92151403934204179080f,0.38834504669882657923f,-0.92850608047321547822f,
0.37131719395183770960f,-0.93518350993894761025f,0.35416352542049039931f,
-0.94154406518302069529f,0.33688985339222032867f,-0.94758559101774109124f,
0.31950203081601580291f,-0.95330604035419386211f,0.30200594931922802866f,
-0.95870347489587148804f,0.28440753721127209896f,-0.96377606579543984022f,
0.26671275747489847641f,-0.96852209427441737777f,0.24892760574572009302f,
-0.97293995220556006576f,0.23105810828067133156f,-0.97702814265775439484f,
0.21311031991609141745f,-0.98078528040323043058f,0.19509032201612860891f,
-0.98421009238692902521f,0.17700422041214894375f,-0.98730141815785843473f,
0.15885814333386147346f,-0.99005821026229701154f,0.14065823933284954395f,
-0.99247953459870996706f,0.12241067519921634832f,-0.99456457073425541537f,
0.10412163387205457254f,-0.99631261218277800129f,0.08579731234444015753f,
-0.99772306664419163624f,0.06744391956366417584f,-0.99879545620517240501f,
0.04906767432741796636f,-0.99952941750109314256f,0.03067480317663686534f,
-0.99992470183914450299f,0.01227153828572000692f,-0.99998117528260110909f,
-0.00613588464915455420f,-0.99969881869620424997f,-0.02454122852291207996f,
-0.99907772775264536147f,-0.04293825693494077861f,-0.99811811290014917919f,
-0.06132073630220824523f,-0.99682029929116577893f,-0.07968243797142994522f,
-0.99518472667219692873f,-0.09801714032956058975f,-0.99321194923479461103f,
-0.11631863091190447479f,-0.99090263542778000971f,-0.13458070850712605671f,
-0.98825756773074946437f,-0.15279718525844343535f,-0.98527764238894133264f,
-0.17096188876030096737f,-0.98196386910955524296f,-0.18906866414980610935f,
-0.97831737071962765473f,-0.20711137619221858808f,-0.97433938278557585821f,
-0.22508391135979261000f,-0.97003125319454397424f,-0.24298017990326381543f,
-0.96539444169768939830f,-0.26079411791527562503f,-0.96043051941556589757f,
-0.27851968938505289319f,-0.95514116830577078243f,-0.29615088824362378883f,
-0.94952818059303678577f,-0.31368174039889118454f,-0.94359345816196038559f,
-0.33110630575987626267f,-0.93733901191257495977f,-0.34841868024943456472f,
-0.93076696107898382326f,-0.36561299780477357624f,-0.92387953251128684951f,
-0.38268343236508967076f,-0.91667905992104270485f,-0.39962419984564684361f,
-0.90916798309052249127f,-0.41642956009763693048f,-0.90134884704602202810f,
-0.43309381885315184624f,-0.89322430119551532446f,-0.44961132965460665067f,
-0.88479709843093790056f,-0.46597649576796595916f,-0.87607009419540660122f,
-0.48218377207912266336f,-0.86704624551569287050f,-0.49822766697278153547f,
-0.85772861000027211809f,-0.51410274419322155026f,-0.84812034480329723252f,
-0.52980362468629460526f,-0.83822470555483818977f,-0.54532498842204613076f,
-0.82804504525775590729f,-0.56066157619733592021f,-0.81758481315158371139f,
-0.57580819141784533866f,-0.80684755354379944503f,-0.59075970185887394237f,
-0.79583690460888356633f,-0.60551104140432543410f,-0.78455659715557524159f,
-0.62005721176328920663f,-0.77301045336273710440f,-0.63439328416364526575f,
-0.76120238548426188974f,-0.64851440102211233008f,-0.74913639452345925918f,
-0.66241577759017178373f,-0.73681656887737001504f,-0.67609270357531581208f,
-0.72424708295146700276f,-0.68954054473706682948f,-0.71143219574521665560f,
-0.70275474445722507788f,-0.69837624940897302661f,-0.71573082528381848366f,
-0.68508366777270035541f,-0.72846439044822519637f,-0.67155895484701866316f,
-0.74095112535495888384f,-0.65780669329707874837f,-0.75318679904361240940f,
-0.64383154288979149715f,-0.76516726562245895860f,-0.62963823891492687324f,
-0.77688846567323255332f,-0.61523159058062726334f,-0.78834642762660589455f,
-0.60061647938386930612f,-0.79953726910790479110f,-0.58579785745643908612f,
-0.81045719825259465718f,-0.57078074588696736669f,-0.82110251499110464835f,
-0.55557023301960217765f,-0.83146961230254523567f,-0.54017147272989274320f,
-0.84155497743689855472f,-0.52458968267846928235f,-0.85135519310526486247f,
-0.50883014254310732216f,-0.86086693863776708735f,-0.49289819222978420443f,
-0.87008699110871134952f,-0.47679923006332214364f,-0.87901222642863341417f,
-0.46053871095823989412f,-0.88763962040285404598f,-0.44412214457042975546f,
-0.89596624975618488484f,-0.42755509343028247349f,-0.90398929312344311615f,
-0.41084317105790418845f,-0.91170603200542976730f,-0.39399204006104820985f,
-0.91911385169005765938f,-0.37700741021641820394f,-0.92621024213831137928f,
-0.35989503653498794433f,-0.93299279883473895669f,-0.34266071731199487793f,
-0.93945922360218969693f,-0.32531029216226331480f,-0.94560732538052116869f,
-0.30784964004153508865f,-0.95143502096900833820f,-0.29028467725446244208f,
-0.95694033573220882438f,-0.27262135544994886560f,-0.96212140426904158019f,
-0.25486565960451434965f,-0.96697647104485218161f,-0.23702360599436766986f,
-0.97150389098625167250f,-0.21910124015687010290f,-0.97570213003852845901f,
-0.20110463484209206708f,-0.97956976568544051887f,-0.18303988795514095078f,
-0.98310548743121628501f,-0.16491312048996975559f,-0.98630809724459866938f,
-0.14673047445536230304f,-0.98917650996478090342f,-0.12849811079379358514f,
-0.99170975366909952520f,-0.11022220729388330918f,-0.99390697000235606051f,
-0.09190895649713282101f,-0.99576741446765981713f,-0.07356456359966735692f,
-0.99729045667869020697f,-0.05519524434968971216f,-0.99847558057329477421f,
-0.03680722294135933131f,-0.99932238458834943273f,-0.01840672990580516366f,
-0.99983058179582340319f,1.00000000000000000000f,0.00000000000000000000f,
0.99729045667869020697f,0.07356456359966742631f,0.98917650996478101444f,
0.14673047445536174793f,0.97570213003852857003f,0.21910124015686979759f,
0.95694033573220882438f,0.29028467725446233105f,0.93299279883473895669f,
0.35989503653498811087f,0.90398929312344333820f,0.42755509343028208491f,
0.87008699110871146054f,0.49289819222978403790f,0.83146961230254523567f,
0.55557023301960217765f,0.78834642762660622761f,0.61523159058062681925f,
0.74095112535495921691f,0.67155895484701833009f,0.68954054473706694051f,
0.72424708295146689174f,0.63439328416364548779f,0.77301045336273688235f,
0.57580819141784533866f,0.81758481315158371139f,0.51410274419322166128f,
0.85772861000027211809f,0.44961132965460659516f,0.89322430119551532446f,
0.38268343236508983729f,0.92387953251128673848f,0.31368174039889157312f,
0.94952818059303667475f,0.24298017990326398197f,0.97003125319454397424f,
0.17096188876030135595f,0.98527764238894122162f,0.09801714032956077016f,
0.99518472667219681771f,0.02454122852291226384f,0.99969881869620424997f,
-0.04906767432741800800f,0.99879545620517240501f,-0.12241067519921615403f,
0.99247953459870996706f,-0.19509032201612819257f,0.98078528040323043058f,
-0.26671275747489830987f,0.96377606579543984022f,-0.33688985339221994009f,
0.94154406518302080631f,-0.40524131400498974998f,0.91420975570353069095f,
-0.47139673682599769755f,0.88192126434835504956f,-0.53499761988709704230f,
0.84485356524970722791f,-0.59569930449243335691f,0.80320753148064494287f,
-0.65317284295377653347f,0.75720884650648467851f,-0.70710678118654746172f,
0.70710678118654757274f,-0.75720884650648467851f,0.65317284295377664449f,
-0.80320753148064483184f,0.59569930449243346793f,-0.84485356524970711689f,
0.53499761988709715332f,-0.88192126434835493853f,0.47139673682599780857f,
-0.91420975570353069095f,0.40524131400498991651f,-0.94154406518302069529f,
0.33688985339222032867f,-0.96377606579543984022f,0.26671275747489847641f,
-0.98078528040323043058f,0.19509032201612860891f,-0.99247953459870996706f,
0.12241067519921634832f,-0.99879545620517240501f,0.04906767432741796636f,
-0.99969881869620424997f,-0.02454122852291207996f,-0.99518472667219692873f,
-0.09801714032956058975f,-0.98527764238894133264f,-0.17096188876030096737f,
-0.97003125319454397424f,-0.24298017990326381543f,-0.94952818059303678577f,
-0.31368174039889118454f,-0.92387953251128684951f,-0.38268343236508967076f,
-0.89322430119551532446f,-0.44961132965460665067f,-0.85772861000027211809f,
-0.51410274419322155026f,-0.81758481315158371139f,-0.57580819141784533866f,
-0.77301045336273710440f,-0.63439328416364526575f,-0.72424708295146700276f,
-0.68954054473706682948f,-0.67155895484701866316f,-0.74095112535495888384f,
-0.61523159058062726334f,-0.78834642762660589455f,-0.55557023301960217765f,
-0.83146961230254523567f,-0.49289819222978420443f,-0.87008699110871134952f,
-0.42755509343028247349f,-0.90398929312344311615f,-0.35989503653498794433f,
-0.93299279883473895669f,-0.29028467725446244208f,-0.95694033573220882438f,
-0.21910124015687010290f,-0.97570213003852845901f,-0.14673047445536230304f,
-0.98917650996478090342f,-0.07356456359966735692f,-0.99729045667869020697f,
1.00000000000000000000f,0.00000000000000000000f,0.95694033573220882438f,
0.29028467725446233105f,0.83146961230254523567f,0.55557023301960217765f,
0.63439328416364548779f,0.77301045336273688235f,0.38268343236508983729f,
0.92387953251128673848f,0.09801714032956077016f,0.99518472667219681771f,
-0.19509032201612819257f,0.98078528040323043058f,-0.47139673682599769755f,
0.88192126434835504956f,-0.70710678118654746172f,0.70710678118654757274f,
-0.88192126434835493853f,0.47139673682599780857f,-0.98078528040323043058f,
0.19509032201612860891f,-0.99518472667219692873f,-0.09801714032956058975f,
-0.92387953251128684951f,-0.38268343236508967076f,-0.77301045336273710440f,
-0.63439328416364526575f,-0.55557023301960217765f,-0.83146961230254523567f,
-0.29028467725446244208f,-0.95694033573220882438f,1.00000000000000000000f,
0.00000000000000000000f,0.38268343236508983729f,0.92387953251128673848f,
-0.70710678118654746172f,0.70710678118654757274f,-0.92387953251128684951f,
-0.38268343236508967076f,};

#endif



#endif /* !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES) */
#endif /* defined(ARM_MATH_MVEF) && !defined(ARM_MATH_AUTOVECTORIZE) */

#include "arm_math.h"

#if defined(ARM_MATH_MVEI)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q31_16) || defined(ARM_TABLE_TWIDDLECOEF_Q31_32)

uint32_t rearranged_twiddle_tab_stride1_arr_16_q31[2]={
0,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_16_q31[2]={
0,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_16_q31[2]={
0,0,};

q31_t rearranged_twiddle_stride1_16_q31[8]={
0x7FFFFFFF,0x00000000,0x7641AF3D,0xCF043AB3,0x5A82799A,0xA57D8666,0x30FBC54D,
0x89BE50C3,};

q31_t rearranged_twiddle_stride2_16_q31[8]={
0x7FFFFFFF,0x00000000,0x5A82799A,0xA57D8666,0x00000000,0x80000000,0xA57D8666,
0xA57D8666,};

q31_t rearranged_twiddle_stride3_16_q31[8]={
0x7FFFFFFF,0x00000000,0x30FBC54D,0x89BE50C3,0xA57D8666,0xA57D8666,0x89BE50C3,
0x30FBC54D,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q31_64) || defined(ARM_TABLE_TWIDDLECOEF_Q31_128)

uint32_t rearranged_twiddle_tab_stride1_arr_64_q31[3]={
0,32,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_64_q31[3]={
0,32,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_64_q31[3]={
0,32,0,};

q31_t rearranged_twiddle_stride1_64_q31[40]={
0x7FFFFFFF,0x00000000,0x7F62368F,0xF3742CA2,0x7D8A5F40,0xE70747C4,0x7A7D055B,
0xDAD7F3A2,0x7641AF3D,0xCF043AB3,0x70E2CBC6,0xC3A94590,0x6A6D98A4,0xB8E31319,
0x62F201AC,0xAECC336C,0x5A82799A,0xA57D8666,0x5133CC94,0x9D0DFE54,0x471CECE7,
0x9592675C,0x3C56BA70,0x8F1D343A,0x30FBC54D,0x89BE50C3,0x25280C5E,0x8582FAA5,
0x18F8B83C,0x8275A0C0,0x0C8BD35E,0x809DC971,0x7FFFFFFF,0x00000000,0x7641AF3D,
0xCF043AB3,0x5A82799A,0xA57D8666,0x30FBC54D,0x89BE50C3,};

q31_t rearranged_twiddle_stride2_64_q31[40]={
0x7FFFFFFF,0x00000000,0x7D8A5F40,0xE70747C4,0x7641AF3D,0xCF043AB3,0x6A6D98A4,
0xB8E31319,0x5A82799A,0xA57D8666,0x471CECE7,0x9592675C,0x30FBC54D,0x89BE50C3,
0x18F8B83C,0x8275A0C0,0x00000000,0x80000000,0xE70747C4,0x8275A0C0,0xCF043AB3,
0x89BE50C3,0xB8E31319,0x9592675C,0xA57D8666,0xA57D8666,0x9592675C,0xB8E31319,
0x89BE50C3,0xCF043AB3,0x8275A0C0,0xE70747C4,0x7FFFFFFF,0x00000000,0x5A82799A,
0xA57D8666,0x00000000,0x80000000,0xA57D8666,0xA57D8666,};

q31_t rearranged_twiddle_stride3_64_q31[40]={
0x7FFFFFFF,0x00000000,0x7A7D055B,0xDAD7F3A2,0x6A6D98A4,0xB8E31319,0x5133CC94,
0x9D0DFE54,0x30FBC54D,0x89BE50C3,0x0C8BD35E,0x809DC971,0xE70747C4,0x8275A0C0,
0xC3A94590,0x8F1D343A,0xA57D8666,0xA57D8666,0x8F1D343A,0xC3A94590,0x8275A0C0,
0xE70747C4,0x809DC971,0x0C8BD35E,0x89BE50C3,0x30FBC54D,0x9D0DFE54,0x5133CC94,
0xB8E31319,0x6A6D98A4,0xDAD7F3A2,0x7A7D055B,0x7FFFFFFF,0x00000000,0x30FBC54D,
0x89BE50C3,0xA57D8666,0xA57D8666,0x89BE50C3,0x30FBC54D,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q31_256) || defined(ARM_TABLE_TWIDDLECOEF_Q31_512)

uint32_t rearranged_twiddle_tab_stride1_arr_256_q31[4]={
0,128,160,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_256_q31[4]={
0,128,160,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_256_q31[4]={
0,128,160,0,};

q31_t rearranged_twiddle_stride1_256_q31[168]={
0x7FFFFFFF,0x00000000,0x7FF62182,0xFCDBD541,0x7FD8878E,0xF9B82684,0x7FA736B4,
0xF6956FB7,0x7F62368F,0xF3742CA2,0x7F0991C4,0xF054D8D5,0x7E9D55FC,0xED37EF91,
0x7E1D93EA,0xEA1DEBBB,0x7D8A5F40,0xE70747C4,0x7CE3CEB2,0xE3F47D96,0x7C29FBEE,
0xE0E60685,0x7B5D039E,0xDDDC5B3B,0x7A7D055B,0xDAD7F3A2,0x798A23B1,0xD7D946D8,
0x78848414,0xD4E0CB15,0x776C4EDB,0xD1EEF59E,0x7641AF3D,0xCF043AB3,0x7504D345,
0xCC210D79,0x73B5EBD1,0xC945DFEC,0x72552C85,0xC67322CE,0x70E2CBC6,0xC3A94590,
0x6F5F02B2,0xC0E8B648,0x6DCA0D14,0xBE31E19B,0x6C242960,0xBB8532B0,0x6A6D98A4,
0xB8E31319,0x68A69E81,0xB64BEACD,0x66CF8120,0xB3C0200C,0x64E88926,0xB140175B,
0x62F201AC,0xAECC336C,0x60EC3830,0xAC64D510,0x5ED77C8A,0xAA0A5B2E,0x5CB420E0,
0xA7BD22AC,0x5A82799A,0xA57D8666,0x5842DD54,0xA34BDF20,0x55F5A4D2,0xA1288376,
0x539B2AF0,0x9F13C7D0,0x5133CC94,0x9D0DFE54,0x4EBFE8A5,0x9B1776DA,0x4C3FDFF4,
0x99307EE0,0x49B41533,0x9759617F,0x471CECE7,0x9592675C,0x447ACD50,0x93DBD6A0,
0x41CE1E65,0x9235F2EC,0x3F1749B8,0x90A0FD4E,0x3C56BA70,0x8F1D343A,0x398CDD32,
0x8DAAD37B,0x36BA2014,0x8C4A142F,0x33DEF287,0x8AFB2CBB,0x30FBC54D,0x89BE50C3,
0x2E110A62,0x8893B125,0x2B1F34EB,0x877B7BEC,0x2826B928,0x8675DC4F,0x25280C5E,
0x8582FAA5,0x2223A4C5,0x84A2FC62,0x1F19F97B,0x83D60412,0x1C0B826A,0x831C314E,
0x18F8B83C,0x8275A0C0,0x15E21445,0x81E26C16,0x12C8106F,0x8162AA04,0x0FAB272B,
0x80F66E3C,0x0C8BD35E,0x809DC971,0x096A9049,0x8058C94C,0x0647D97C,0x80277872,
0x03242ABF,0x8009DE7E,0x7FFFFFFF,0x00000000,0x7F62368F,0xF3742CA2,0x7D8A5F40,
0xE70747C4,0x7A7D055B,0xDAD7F3A2,0x7641AF3D,0xCF043AB3,0x70E2CBC6,0xC3A94590,
0x6A6D98A4,0xB8E31319,0x62F201AC,0xAECC336C,0x5A82799A,0xA57D8666,0x5133CC94,
0x9D0DFE54,0x471CECE7,0x9592675C,0x3C56BA70,0x8F1D343A,0x30FBC54D,0x89BE50C3,
0x25280C5E,0x8582FAA5,0x18F8B83C,0x8275A0C0,0x0C8BD35E,0x809DC971,0x7FFFFFFF,
0x00000000,0x7641AF3D,0xCF043AB3,0x5A82799A,0xA57D8666,0x30FBC54D,0x89BE50C3,};

q31_t rearranged_twiddle_stride2_256_q31[168]={
0x7FFFFFFF,0x00000000,0x7FD8878E,0xF9B82684,0x7F62368F,0xF3742CA2,0x7E9D55FC,
0xED37EF91,0x7D8A5F40,0xE70747C4,0x7C29FBEE,0xE0E60685,0x7A7D055B,0xDAD7F3A2,
0x78848414,0xD4E0CB15,0x7641AF3D,0xCF043AB3,0x73B5EBD1,0xC945DFEC,0x70E2CBC6,
0xC3A94590,0x6DCA0D14,0xBE31E19B,0x6A6D98A4,0xB8E31319,0x66CF8120,0xB3C0200C,
0x62F201AC,0xAECC336C,0x5ED77C8A,0xAA0A5B2E,0x5A82799A,0xA57D8666,0x55F5A4D2,
0xA1288376,0x5133CC94,0x9D0DFE54,0x4C3FDFF4,0x99307EE0,0x471CECE7,0x9592675C,
0x41CE1E65,0x9235F2EC,0x3C56BA70,0x8F1D343A,0x36BA2014,0x8C4A142F,0x30FBC54D,
0x89BE50C3,0x2B1F34EB,0x877B7BEC,0x25280C5E,0x8582FAA5,0x1F19F97B,0x83D60412,
0x18F8B83C,0x8275A0C0,0x12C8106F,0x8162AA04,0x0C8BD35E,0x809DC971,0x0647D97C,
0x80277872,0x00000000,0x80000000,0xF9B82684,0x80277872,0xF3742CA2,0x809DC971,
0xED37EF91,0x8162AA04,0xE70747C4,0x8275A0C0,0xE0E60685,0x83D60412,0xDAD7F3A2,
0x8582FAA5,0xD4E0CB15,0x877B7BEC,0xCF043AB3,0x89BE50C3,0xC945DFEC,0x8C4A142F,
0xC3A94590,0x8F1D343A,0xBE31E19B,0x9235F2EC,0xB8E31319,0x9592675C,0xB3C0200C,
0x99307EE0,0xAECC336C,0x9D0DFE54,0xAA0A5B2E,0xA1288376,0xA57D8666,0xA57D8666,
0xA1288376,0xAA0A5B2E,0x9D0DFE54,0xAECC336C,0x99307EE0,0xB3C0200C,0x9592675C,
0xB8E31319,0x9235F2EC,0xBE31E19B,0x8F1D343A,0xC3A94590,0x8C4A142F,0xC945DFEC,
0x89BE50C3,0xCF043AB3,0x877B7BEC,0xD4E0CB15,0x8582FAA5,0xDAD7F3A2,0x83D60412,
0xE0E60685,0x8275A0C0,0xE70747C4,0x8162AA04,0xED37EF91,0x809DC971,0xF3742CA2,
0x80277872,0xF9B82684,0x7FFFFFFF,0x00000000,0x7D8A5F40,0xE70747C4,0x7641AF3D,
0xCF043AB3,0x6A6D98A4,0xB8E31319,0x5A82799A,0xA57D8666,0x471CECE7,0x9592675C,
0x30FBC54D,0x89BE50C3,0x18F8B83C,0x8275A0C0,0x00000000,0x80000000,0xE70747C4,
0x8275A0C0,0xCF043AB3,0x89BE50C3,0xB8E31319,0x9592675C,0xA57D8666,0xA57D8666,
0x9592675C,0xB8E31319,0x89BE50C3,0xCF043AB3,0x8275A0C0,0xE70747C4,0x7FFFFFFF,
0x00000000,0x5A82799A,0xA57D8666,0x00000000,0x80000000,0xA57D8666,0xA57D8666,};

q31_t rearranged_twiddle_stride3_256_q31[168]={
0x7FFFFFFF,0x00000000,0x7FA736B4,0xF6956FB7,0x7E9D55FC,0xED37EF91,0x7CE3CEB2,
0xE3F47D96,0x7A7D055B,0xDAD7F3A2,0x776C4EDB,0xD1EEF59E,0x73B5EBD1,0xC945DFEC,
0x6F5F02B2,0xC0E8B648,0x6A6D98A4,0xB8E31319,0x64E88926,0xB140175B,0x5ED77C8A,
0xAA0A5B2E,0x5842DD54,0xA34BDF20,0x5133CC94,0x9D0DFE54,0x49B41533,0x9759617F,
0x41CE1E65,0x9235F2EC,0x398CDD32,0x8DAAD37B,0x30FBC54D,0x89BE50C3,0x2826B928,
0x8675DC4F,0x1F19F97B,0x83D60412,0x15E21445,0x81E26C16,0x0C8BD35E,0x809DC971,
0x03242ABF,0x8009DE7E,0xF9B82684,0x80277872,0xF054D8D5,0x80F66E3C,0xE70747C4,
0x8275A0C0,0xDDDC5B3B,0x84A2FC62,0xD4E0CB15,0x877B7BEC,0xCC210D79,0x8AFB2CBB,
0xC3A94590,0x8F1D343A,0xBB8532B0,0x93DBD6A0,0xB3C0200C,0x99307EE0,0xAC64D510,
0x9F13C7D0,0xA57D8666,0xA57D8666,0x9F13C7D0,0xAC64D510,0x99307EE0,0xB3C0200C,
0x93DBD6A0,0xBB8532B0,0x8F1D343A,0xC3A94590,0x8AFB2CBB,0xCC210D79,0x877B7BEC,
0xD4E0CB15,0x84A2FC62,0xDDDC5B3B,0x8275A0C0,0xE70747C4,0x80F66E3C,0xF054D8D5,
0x80277872,0xF9B82684,0x8009DE7E,0x03242ABF,0x809DC971,0x0C8BD35E,0x81E26C16,
0x15E21445,0x83D60412,0x1F19F97B,0x8675DC4F,0x2826B928,0x89BE50C3,0x30FBC54D,
0x8DAAD37B,0x398CDD32,0x9235F2EC,0x41CE1E65,0x9759617F,0x49B41533,0x9D0DFE54,
0x5133CC94,0xA34BDF20,0x5842DD54,0xAA0A5B2E,0x5ED77C8A,0xB140175B,0x64E88926,
0xB8E31319,0x6A6D98A4,0xC0E8B648,0x6F5F02B2,0xC945DFEC,0x73B5EBD1,0xD1EEF59E,
0x776C4EDB,0xDAD7F3A2,0x7A7D055B,0xE3F47D96,0x7CE3CEB2,0xED37EF91,0x7E9D55FC,
0xF6956FB7,0x7FA736B4,0x7FFFFFFF,0x00000000,0x7A7D055B,0xDAD7F3A2,0x6A6D98A4,
0xB8E31319,0x5133CC94,0x9D0DFE54,0x30FBC54D,0x89BE50C3,0x0C8BD35E,0x809DC971,
0xE70747C4,0x8275A0C0,0xC3A94590,0x8F1D343A,0xA57D8666,0xA57D8666,0x8F1D343A,
0xC3A94590,0x8275A0C0,0xE70747C4,0x809DC971,0x0C8BD35E,0x89BE50C3,0x30FBC54D,
0x9D0DFE54,0x5133CC94,0xB8E31319,0x6A6D98A4,0xDAD7F3A2,0x7A7D055B,0x7FFFFFFF,
0x00000000,0x30FBC54D,0x89BE50C3,0xA57D8666,0xA57D8666,0x89BE50C3,0x30FBC54D,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q31_1024) || defined(ARM_TABLE_TWIDDLECOEF_Q31_2048)

uint32_t rearranged_twiddle_tab_stride1_arr_1024_q31[5]={
0,512,640,672,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_1024_q31[5]={
0,512,640,672,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_1024_q31[5]={
0,512,640,672,0,};

q31_t rearranged_twiddle_stride1_1024_q31[680]={
0x7FFFFFFF,0x00000000,0x7FFF6216,0xFF36F078,0x7FFD885A,0xFE6DE2E0,0x7FFA72D1,
0xFDA4D929,0x7FF62182,0xFCDBD541,0x7FF09478,0xFC12D91A,0x7FE9CBC0,0xFB49E6A3,
0x7FE1C76B,0xFA80FFCB,0x7FD8878E,0xF9B82684,0x7FCE0C3E,0xF8EF5CBB,0x7FC25596,
0xF826A462,0x7FB563B3,0xF75DFF66,0x7FA736B4,0xF6956FB7,0x7F97CEBD,0xF5CCF743,
0x7F872BF3,0xF50497FB,0x7F754E80,0xF43C53CB,0x7F62368F,0xF3742CA2,0x7F4DE451,
0xF2AC246E,0x7F3857F6,0xF1E43D1C,0x7F2191B4,0xF11C789A,0x7F0991C4,0xF054D8D5,
0x7EF05860,0xEF8D5FB8,0x7ED5E5C6,0xEEC60F31,0x7EBA3A39,0xEDFEE92B,0x7E9D55FC,
0xED37EF91,0x7E7F3957,0xEC71244F,0x7E5FE493,0xEBAA894F,0x7E3F57FF,0xEAE4207A,
0x7E1D93EA,0xEA1DEBBB,0x7DFA98A8,0xE957ECFB,0x7DD6668F,0xE8922622,0x7DB0FDF8,
0xE7CC9917,0x7D8A5F40,0xE70747C4,0x7D628AC6,0xE642340D,0x7D3980EC,0xE57D5FDA,
0x7D0F4218,0xE4B8CD11,0x7CE3CEB2,0xE3F47D96,0x7CB72724,0xE330734D,0x7C894BDE,
0xE26CB01B,0x7C5A3D50,0xE1A935E2,0x7C29FBEE,0xE0E60685,0x7BF88830,0xE02323E5,
0x7BC5E290,0xDF608FE4,0x7B920B89,0xDE9E4C60,0x7B5D039E,0xDDDC5B3B,0x7B26CB4F,
0xDD1ABE51,0x7AEF6323,0xDC597781,0x7AB6CBA4,0xDB9888A8,0x7A7D055B,0xDAD7F3A2,
0x7A4210D8,0xDA17BA4A,0x7A05EEAD,0xD957DE7A,0x79C89F6E,0xD898620C,0x798A23B1,
0xD7D946D8,0x794A7C12,0xD71A8EB5,0x7909A92D,0xD65C3B7B,0x78C7ABA2,0xD59E4EFF,
0x78848414,0xD4E0CB15,0x78403329,0xD423B191,0x77FAB989,0xD3670446,0x77B417DF,
0xD2AAC504,0x776C4EDB,0xD1EEF59E,0x77235F2D,0xD13397E2,0x76D94989,0xD078AD9E,
0x768E0EA6,0xCFBE389F,0x7641AF3D,0xCF043AB3,0x75F42C0B,0xCE4AB5A2,0x75A585CF,
0xCD91AB39,0x7555BD4C,0xCCD91D3D,0x7504D345,0xCC210D79,0x74B2C884,0xCB697DB0,
0x745F9DD1,0xCAB26FA9,0x740B53FB,0xC9FBE527,0x73B5EBD1,0xC945DFEC,0x735F6626,
0xC89061BA,0x7307C3D0,0xC7DB6C50,0x72AF05A7,0xC727016D,0x72552C85,0xC67322CE,
0x71FA3949,0xC5BFD22E,0x719E2CD2,0xC50D1149,0x71410805,0xC45AE1D7,0x70E2CBC6,
0xC3A94590,0x708378FF,0xC2F83E2A,0x7023109A,0xC247CD5A,0x6FC19385,0xC197F4D4,
0x6F5F02B2,0xC0E8B648,0x6EFB5F12,0xC03A1368,0x6E96A99D,0xBF8C0DE3,0x6E30E34A,
0xBEDEA765,0x6DCA0D14,0xBE31E19B,0x6D6227FA,0xBD85BE30,0x6CF934FC,0xBCDA3ECB,
0x6C8F351C,0xBC2F6513,0x6C242960,0xBB8532B0,0x6BB812D1,0xBADBA943,0x6B4AF279,
0xBA32CA71,0x6ADCC964,0xB98A97D8,0x6A6D98A4,0xB8E31319,0x69FD614A,0xB83C3DD1,
0x698C246C,0xB796199B,0x6919E320,0xB6F0A812,0x68A69E81,0xB64BEACD,0x683257AB,
0xB5A7E362,0x67BD0FBD,0xB5049368,0x6746C7D8,0xB461FC70,0x66CF8120,0xB3C0200C,
0x66573CBB,0xB31EFFCC,0x65DDFBD3,0xB27E9D3C,0x6563BF92,0xB1DEF9E9,0x64E88926,
0xB140175B,0x646C59BF,0xB0A1F71D,0x63EF3290,0xB0049AB3,0x637114CC,0xAF6803A2,
0x62F201AC,0xAECC336C,0x6271FA69,0xAE312B92,0x61F1003F,0xAD96ED92,0x616F146C,
0xACFD7AE8,0x60EC3830,0xAC64D510,0x60686CCF,0xABCCFD83,0x5FE3B38D,0xAB35F5B5,
0x5F5E0DB3,0xAA9FBF1E,0x5ED77C8A,0xAA0A5B2E,0x5E50015D,0xA975CB57,0x5DC79D7C,
0xA8E21106,0x5D3E5237,0xA84F2DAA,0x5CB420E0,0xA7BD22AC,0x5C290ACC,0xA72BF174,
0x5B9D1154,0xA69B9B68,0x5B1035CF,0xA60C21EE,0x5A82799A,0xA57D8666,0x59F3DE12,
0xA4EFCA31,0x59646498,0xA462EEAC,0x58D40E8C,0xA3D6F534,0x5842DD54,0xA34BDF20,
0x57B0D256,0xA2C1ADC9,0x571DEEFA,0xA2386284,0x568A34A9,0xA1AFFEA3,0x55F5A4D2,
0xA1288376,0x556040E2,0xA0A1F24D,0x54CA0A4B,0xA01C4C73,0x5433027D,0x9F979331,
0x539B2AF0,0x9F13C7D0,0x53028518,0x9E90EB94,0x5269126E,0x9E0EFFC1,0x51CED46E,
0x9D8E0597,0x5133CC94,0x9D0DFE54,0x5097FC5E,0x9C8EEB34,0x4FFB654D,0x9C10CD70,
0x4F5E08E3,0x9B93A641,0x4EBFE8A5,0x9B1776DA,0x4E210617,0x9A9C406E,0x4D8162C4,
0x9A22042D,0x4CE10034,0x99A8C345,0x4C3FDFF4,0x99307EE0,0x4B9E0390,0x98B93828,
0x4AFB6C98,0x9842F043,0x4A581C9E,0x97CDA855,0x49B41533,0x9759617F,0x490F57EE,
0x96E61CE0,0x4869E665,0x9673DB94,0x47C3C22F,0x96029EB6,0x471CECE7,0x9592675C,
0x46756828,0x9523369C,0x45CD358F,0x94B50D87,0x452456BD,0x9447ED2F,0x447ACD50,
0x93DBD6A0,0x43D09AED,0x9370CAE4,0x4325C135,0x9306CB04,0x427A41D0,0x929DD806,
0x41CE1E65,0x9235F2EC,0x4121589B,0x91CF1CB6,0x4073F21D,0x91695663,0x3FC5EC98,
0x9104A0EE,0x3F1749B8,0x90A0FD4E,0x3E680B2C,0x903E6C7B,0x3DB832A6,0x8FDCEF66,
0x3D07C1D6,0x8F7C8701,0x3C56BA70,0x8F1D343A,0x3BA51E29,0x8EBEF7FB,0x3AF2EEB7,
0x8E61D32E,0x3A402DD2,0x8E05C6B7,0x398CDD32,0x8DAAD37B,0x38D8FE93,0x8D50FA59,
0x382493B0,0x8CF83C30,0x376F9E46,0x8CA099DA,0x36BA2014,0x8C4A142F,0x36041AD9,
0x8BF4AC05,0x354D9057,0x8BA0622F,0x34968250,0x8B4D377C,0x33DEF287,0x8AFB2CBB,
0x3326E2C3,0x8AAA42B4,0x326E54C7,0x8A5A7A31,0x31B54A5E,0x8A0BD3F5,0x30FBC54D,
0x89BE50C3,0x3041C761,0x8971F15A,0x2F875262,0x8926B677,0x2ECC681E,0x88DCA0D3,
0x2E110A62,0x8893B125,0x2D553AFC,0x884BE821,0x2C98FBBA,0x88054677,0x2BDC4E6F,
0x87BFCCD7,0x2B1F34EB,0x877B7BEC,0x2A61B101,0x8738545E,0x29A3C485,0x86F656D3,
0x28E5714B,0x86B583EE,0x2826B928,0x8675DC4F,0x27679DF4,0x86376092,0x26A82186,
0x85FA1153,0x25E845B6,0x85BDEF28,0x25280C5E,0x8582FAA5,0x24677758,0x8549345C,
0x23A6887F,0x85109CDD,0x22E541AF,0x84D934B1,0x2223A4C5,0x84A2FC62,0x2161B3A0,
0x846DF477,0x209F701C,0x843A1D70,0x1FDCDC1B,0x840777D0,0x1F19F97B,0x83D60412,
0x1E56CA1E,0x83A5C2B0,0x1D934FE5,0x8376B422,0x1CCF8CB3,0x8348D8DC,0x1C0B826A,
0x831C314E,0x1B4732EF,0x82F0BDE8,0x1A82A026,0x82C67F14,0x19BDCBF3,0x829D753A,
0x18F8B83C,0x8275A0C0,0x183366E9,0x824F0208,0x176DD9DE,0x82299971,0x16A81305,
0x82056758,0x15E21445,0x81E26C16,0x151BDF86,0x81C0A801,0x145576B1,0x81A01B6D,
0x138EDBB1,0x8180C6A9,0x12C8106F,0x8162AA04,0x120116D5,0x8145C5C7,0x1139F0CF,
0x812A1A3A,0x1072A048,0x810FA7A0,0x0FAB272B,0x80F66E3C,0x0EE38766,0x80DE6E4C,
0x0E1BC2E4,0x80C7A80A,0x0D53DB92,0x80B21BAF,0x0C8BD35E,0x809DC971,0x0BC3AC35,
0x808AB180,0x0AFB6805,0x8078D40D,0x0A3308BD,0x80683143,0x096A9049,0x8058C94C,
0x08A2009A,0x804A9C4D,0x07D95B9E,0x803DAA6A,0x0710A345,0x8031F3C2,0x0647D97C,
0x80277872,0x057F0035,0x801E3895,0x04B6195D,0x80163440,0x03ED26E6,0x800F6B88,
0x03242ABF,0x8009DE7E,0x025B26D7,0x80058D2F,0x01921D20,0x800277A6,0x00C90F88,
0x80009DEA,0x7FFFFFFF,0x00000000,0x7FF62182,0xFCDBD541,0x7FD8878E,0xF9B82684,
0x7FA736B4,0xF6956FB7,0x7F62368F,0xF3742CA2,0x7F0991C4,0xF054D8D5,0x7E9D55FC,
0xED37EF91,0x7E1D93EA,0xEA1DEBBB,0x7D8A5F40,0xE70747C4,0x7CE3CEB2,0xE3F47D96,
0x7C29FBEE,0xE0E60685,0x7B5D039E,0xDDDC5B3B,0x7A7D055B,0xDAD7F3A2,0x798A23B1,
0xD7D946D8,0x78848414,0xD4E0CB15,0x776C4EDB,0xD1EEF59E,0x7641AF3D,0xCF043AB3,
0x7504D345,0xCC210D79,0x73B5EBD1,0xC945DFEC,0x72552C85,0xC67322CE,0x70E2CBC6,
0xC3A94590,0x6F5F02B2,0xC0E8B648,0x6DCA0D14,0xBE31E19B,0x6C242960,0xBB8532B0,
0x6A6D98A4,0xB8E31319,0x68A69E81,0xB64BEACD,0x66CF8120,0xB3C0200C,0x64E88926,
0xB140175B,0x62F201AC,0xAECC336C,0x60EC3830,0xAC64D510,0x5ED77C8A,0xAA0A5B2E,
0x5CB420E0,0xA7BD22AC,0x5A82799A,0xA57D8666,0x5842DD54,0xA34BDF20,0x55F5A4D2,
0xA1288376,0x539B2AF0,0x9F13C7D0,0x5133CC94,0x9D0DFE54,0x4EBFE8A5,0x9B1776DA,
0x4C3FDFF4,0x99307EE0,0x49B41533,0x9759617F,0x471CECE7,0x9592675C,0x447ACD50,
0x93DBD6A0,0x41CE1E65,0x9235F2EC,0x3F1749B8,0x90A0FD4E,0x3C56BA70,0x8F1D343A,
0x398CDD32,0x8DAAD37B,0x36BA2014,0x8C4A142F,0x33DEF287,0x8AFB2CBB,0x30FBC54D,
0x89BE50C3,0x2E110A62,0x8893B125,0x2B1F34EB,0x877B7BEC,0x2826B928,0x8675DC4F,
0x25280C5E,0x8582FAA5,0x2223A4C5,0x84A2FC62,0x1F19F97B,0x83D60412,0x1C0B826A,
0x831C314E,0x18F8B83C,0x8275A0C0,0x15E21445,0x81E26C16,0x12C8106F,0x8162AA04,
0x0FAB272B,0x80F66E3C,0x0C8BD35E,0x809DC971,0x096A9049,0x8058C94C,0x0647D97C,
0x80277872,0x03242ABF,0x8009DE7E,0x7FFFFFFF,0x00000000,0x7F62368F,0xF3742CA2,
0x7D8A5F40,0xE70747C4,0x7A7D055B,0xDAD7F3A2,0x7641AF3D,0xCF043AB3,0x70E2CBC6,
0xC3A94590,0x6A6D98A4,0xB8E31319,0x62F201AC,0xAECC336C,0x5A82799A,0xA57D8666,
0x5133CC94,0x9D0DFE54,0x471CECE7,0x9592675C,0x3C56BA70,0x8F1D343A,0x30FBC54D,
0x89BE50C3,0x25280C5E,0x8582FAA5,0x18F8B83C,0x8275A0C0,0x0C8BD35E,0x809DC971,
0x7FFFFFFF,0x00000000,0x7641AF3D,0xCF043AB3,0x5A82799A,0xA57D8666,0x30FBC54D,
0x89BE50C3,};

q31_t rearranged_twiddle_stride2_1024_q31[680]={
0x7FFFFFFF,0x00000000,0x7FFD885A,0xFE6DE2E0,0x7FF62182,0xFCDBD541,0x7FE9CBC0,
0xFB49E6A3,0x7FD8878E,0xF9B82684,0x7FC25596,0xF826A462,0x7FA736B4,0xF6956FB7,
0x7F872BF3,0xF50497FB,0x7F62368F,0xF3742CA2,0x7F3857F6,0xF1E43D1C,0x7F0991C4,
0xF054D8D5,0x7ED5E5C6,0xEEC60F31,0x7E9D55FC,0xED37EF91,0x7E5FE493,0xEBAA894F,
0x7E1D93EA,0xEA1DEBBB,0x7DD6668F,0xE8922622,0x7D8A5F40,0xE70747C4,0x7D3980EC,
0xE57D5FDA,0x7CE3CEB2,0xE3F47D96,0x7C894BDE,0xE26CB01B,0x7C29FBEE,0xE0E60685,
0x7BC5E290,0xDF608FE4,0x7B5D039E,0xDDDC5B3B,0x7AEF6323,0xDC597781,0x7A7D055B,
0xDAD7F3A2,0x7A05EEAD,0xD957DE7A,0x798A23B1,0xD7D946D8,0x7909A92D,0xD65C3B7B,
0x78848414,0xD4E0CB15,0x77FAB989,0xD3670446,0x776C4EDB,0xD1EEF59E,0x76D94989,
0xD078AD9E,0x7641AF3D,0xCF043AB3,0x75A585CF,0xCD91AB39,0x7504D345,0xCC210D79,
0x745F9DD1,0xCAB26FA9,0x73B5EBD1,0xC945DFEC,0x7307C3D0,0xC7DB6C50,0x72552C85,
0xC67322CE,0x719E2CD2,0xC50D1149,0x70E2CBC6,0xC3A94590,0x7023109A,0xC247CD5A,
0x6F5F02B2,0xC0E8B648,0x6E96A99D,0xBF8C0DE3,0x6DCA0D14,0xBE31E19B,0x6CF934FC,
0xBCDA3ECB,0x6C242960,0xBB8532B0,0x6B4AF279,0xBA32CA71,0x6A6D98A4,0xB8E31319,
0x698C246C,0xB796199B,0x68A69E81,0xB64BEACD,0x67BD0FBD,0xB5049368,0x66CF8120,
0xB3C0200C,0x65DDFBD3,0xB27E9D3C,0x64E88926,0xB140175B,0x63EF3290,0xB0049AB3,
0x62F201AC,0xAECC336C,0x61F1003F,0xAD96ED92,0x60EC3830,0xAC64D510,0x5FE3B38D,
0xAB35F5B5,0x5ED77C8A,0xAA0A5B2E,0x5DC79D7C,0xA8E21106,0x5CB420E0,0xA7BD22AC,
0x5B9D1154,0xA69B9B68,0x5A82799A,0xA57D8666,0x59646498,0xA462EEAC,0x5842DD54,
0xA34BDF20,0x571DEEFA,0xA2386284,0x55F5A4D2,0xA1288376,0x54CA0A4B,0xA01C4C73,
0x539B2AF0,0x9F13C7D0,0x5269126E,0x9E0EFFC1,0x5133CC94,0x9D0DFE54,0x4FFB654D,
0x9C10CD70,0x4EBFE8A5,0x9B1776DA,0x4D8162C4,0x9A22042D,0x4C3FDFF4,0x99307EE0,
0x4AFB6C98,0x9842F043,0x49B41533,0x9759617F,0x4869E665,0x9673DB94,0x471CECE7,
0x9592675C,0x45CD358F,0x94B50D87,0x447ACD50,0x93DBD6A0,0x4325C135,0x9306CB04,
0x41CE1E65,0x9235F2EC,0x4073F21D,0x91695663,0x3F1749B8,0x90A0FD4E,0x3DB832A6,
0x8FDCEF66,0x3C56BA70,0x8F1D343A,0x3AF2EEB7,0x8E61D32E,0x398CDD32,0x8DAAD37B,
0x382493B0,0x8CF83C30,0x36BA2014,0x8C4A142F,0x354D9057,0x8BA0622F,0x33DEF287,
0x8AFB2CBB,0x326E54C7,0x8A5A7A31,0x30FBC54D,0x89BE50C3,0x2F875262,0x8926B677,
0x2E110A62,0x8893B125,0x2C98FBBA,0x88054677,0x2B1F34EB,0x877B7BEC,0x29A3C485,
0x86F656D3,0x2826B928,0x8675DC4F,0x26A82186,0x85FA1153,0x25280C5E,0x8582FAA5,
0x23A6887F,0x85109CDD,0x2223A4C5,0x84A2FC62,0x209F701C,0x843A1D70,0x1F19F97B,
0x83D60412,0x1D934FE5,0x8376B422,0x1C0B826A,0x831C314E,0x1A82A026,0x82C67F14,
0x18F8B83C,0x8275A0C0,0x176DD9DE,0x82299971,0x15E21445,0x81E26C16,0x145576B1,
0x81A01B6D,0x12C8106F,0x8162AA04,0x1139F0CF,0x812A1A3A,0x0FAB272B,0x80F66E3C,
0x0E1BC2E4,0x80C7A80A,0x0C8BD35E,0x809DC971,0x0AFB6805,0x8078D40D,0x096A9049,
0x8058C94C,0x07D95B9E,0x803DAA6A,0x0647D97C,0x80277872,0x04B6195D,0x80163440,
0x03242ABF,0x8009DE7E,0x01921D20,0x800277A6,0x00000000,0x80000000,0xFE6DE2E0,
0x800277A6,0xFCDBD541,0x8009DE7E,0xFB49E6A3,0x80163440,0xF9B82684,0x80277872,
0xF826A462,0x803DAA6A,0xF6956FB7,0x8058C94C,0xF50497FB,0x8078D40D,0xF3742CA2,
0x809DC971,0xF1E43D1C,0x80C7A80A,0xF054D8D5,0x80F66E3C,0xEEC60F31,0x812A1A3A,
0xED37EF91,0x8162AA04,0xEBAA894F,0x81A01B6D,0xEA1DEBBB,0x81E26C16,0xE8922622,
0x82299971,0xE70747C4,0x8275A0C0,0xE57D5FDA,0x82C67F14,0xE3F47D96,0x831C314E,
0xE26CB01B,0x8376B422,0xE0E60685,0x83D60412,0xDF608FE4,0x843A1D70,0xDDDC5B3B,
0x84A2FC62,0xDC597781,0x85109CDD,0xDAD7F3A2,0x8582FAA5,0xD957DE7A,0x85FA1153,
0xD7D946D8,0x8675DC4F,0xD65C3B7B,0x86F656D3,0xD4E0CB15,0x877B7BEC,0xD3670446,
0x88054677,0xD1EEF59E,0x8893B125,0xD078AD9E,0x8926B677,0xCF043AB3,0x89BE50C3,
0xCD91AB39,0x8A5A7A31,0xCC210D79,0x8AFB2CBB,0xCAB26FA9,0x8BA0622F,0xC945DFEC,
0x8C4A142F,0xC7DB6C50,0x8CF83C30,0xC67322CE,0x8DAAD37B,0xC50D1149,0x8E61D32E,
0xC3A94590,0x8F1D343A,0xC247CD5A,0x8FDCEF66,0xC0E8B648,0x90A0FD4E,0xBF8C0DE3,
0x91695663,0xBE31E19B,0x9235F2EC,0xBCDA3ECB,0x9306CB04,0xBB8532B0,0x93DBD6A0,
0xBA32CA71,0x94B50D87,0xB8E31319,0x9592675C,0xB796199B,0x9673DB94,0xB64BEACD,
0x9759617F,0xB5049368,0x9842F043,0xB3C0200C,0x99307EE0,0xB27E9D3C,0x9A22042D,
0xB140175B,0x9B1776DA,0xB0049AB3,0x9C10CD70,0xAECC336C,0x9D0DFE54,0xAD96ED92,
0x9E0EFFC1,0xAC64D510,0x9F13C7D0,0xAB35F5B5,0xA01C4C73,0xAA0A5B2E,0xA1288376,
0xA8E21106,0xA2386284,0xA7BD22AC,0xA34BDF20,0xA69B9B68,0xA462EEAC,0xA57D8666,
0xA57D8666,0xA462EEAC,0xA69B9B68,0xA34BDF20,0xA7BD22AC,0xA2386284,0xA8E21106,
0xA1288376,0xAA0A5B2E,0xA01C4C73,0xAB35F5B5,0x9F13C7D0,0xAC64D510,0x9E0EFFC1,
0xAD96ED92,0x9D0DFE54,0xAECC336C,0x9C10CD70,0xB0049AB3,0x9B1776DA,0xB140175B,
0x9A22042D,0xB27E9D3C,0x99307EE0,0xB3C0200C,0x9842F043,0xB5049368,0x9759617F,
0xB64BEACD,0x9673DB94,0xB796199B,0x9592675C,0xB8E31319,0x94B50D87,0xBA32CA71,
0x93DBD6A0,0xBB8532B0,0x9306CB04,0xBCDA3ECB,0x9235F2EC,0xBE31E19B,0x91695663,
0xBF8C0DE3,0x90A0FD4E,0xC0E8B648,0x8FDCEF66,0xC247CD5A,0x8F1D343A,0xC3A94590,
0x8E61D32E,0xC50D1149,0x8DAAD37B,0xC67322CE,0x8CF83C30,0xC7DB6C50,0x8C4A142F,
0xC945DFEC,0x8BA0622F,0xCAB26FA9,0x8AFB2CBB,0xCC210D79,0x8A5A7A31,0xCD91AB39,
0x89BE50C3,0xCF043AB3,0x8926B677,0xD078AD9E,0x8893B125,0xD1EEF59E,0x88054677,
0xD3670446,0x877B7BEC,0xD4E0CB15,0x86F656D3,0xD65C3B7B,0x8675DC4F,0xD7D946D8,
0x85FA1153,0xD957DE7A,0x8582FAA5,0xDAD7F3A2,0x85109CDD,0xDC597781,0x84A2FC62,
0xDDDC5B3B,0x843A1D70,0xDF608FE4,0x83D60412,0xE0E60685,0x8376B422,0xE26CB01B,
0x831C314E,0xE3F47D96,0x82C67F14,0xE57D5FDA,0x8275A0C0,0xE70747C4,0x82299971,
0xE8922622,0x81E26C16,0xEA1DEBBB,0x81A01B6D,0xEBAA894F,0x8162AA04,0xED37EF91,
0x812A1A3A,0xEEC60F31,0x80F66E3C,0xF054D8D5,0x80C7A80A,0xF1E43D1C,0x809DC971,
0xF3742CA2,0x8078D40D,0xF50497FB,0x8058C94C,0xF6956FB7,0x803DAA6A,0xF826A462,
0x80277872,0xF9B82684,0x80163440,0xFB49E6A3,0x8009DE7E,0xFCDBD541,0x800277A6,
0xFE6DE2E0,0x7FFFFFFF,0x00000000,0x7FD8878E,0xF9B82684,0x7F62368F,0xF3742CA2,
0x7E9D55FC,0xED37EF91,0x7D8A5F40,0xE70747C4,0x7C29FBEE,0xE0E60685,0x7A7D055B,
0xDAD7F3A2,0x78848414,0xD4E0CB15,0x7641AF3D,0xCF043AB3,0x73B5EBD1,0xC945DFEC,
0x70E2CBC6,0xC3A94590,0x6DCA0D14,0xBE31E19B,0x6A6D98A4,0xB8E31319,0x66CF8120,
0xB3C0200C,0x62F201AC,0xAECC336C,0x5ED77C8A,0xAA0A5B2E,0x5A82799A,0xA57D8666,
0x55F5A4D2,0xA1288376,0x5133CC94,0x9D0DFE54,0x4C3FDFF4,0x99307EE0,0x471CECE7,
0x9592675C,0x41CE1E65,0x9235F2EC,0x3C56BA70,0x8F1D343A,0x36BA2014,0x8C4A142F,
0x30FBC54D,0x89BE50C3,0x2B1F34EB,0x877B7BEC,0x25280C5E,0x8582FAA5,0x1F19F97B,
0x83D60412,0x18F8B83C,0x8275A0C0,0x12C8106F,0x8162AA04,0x0C8BD35E,0x809DC971,
0x0647D97C,0x80277872,0x00000000,0x80000000,0xF9B82684,0x80277872,0xF3742CA2,
0x809DC971,0xED37EF91,0x8162AA04,0xE70747C4,0x8275A0C0,0xE0E60685,0x83D60412,
0xDAD7F3A2,0x8582FAA5,0xD4E0CB15,0x877B7BEC,0xCF043AB3,0x89BE50C3,0xC945DFEC,
0x8C4A142F,0xC3A94590,0x8F1D343A,0xBE31E19B,0x9235F2EC,0xB8E31319,0x9592675C,
0xB3C0200C,0x99307EE0,0xAECC336C,0x9D0DFE54,0xAA0A5B2E,0xA1288376,0xA57D8666,
0xA57D8666,0xA1288376,0xAA0A5B2E,0x9D0DFE54,0xAECC336C,0x99307EE0,0xB3C0200C,
0x9592675C,0xB8E31319,0x9235F2EC,0xBE31E19B,0x8F1D343A,0xC3A94590,0x8C4A142F,
0xC945DFEC,0x89BE50C3,0xCF043AB3,0x877B7BEC,0xD4E0CB15,0x8582FAA5,0xDAD7F3A2,
0x83D60412,0xE0E60685,0x8275A0C0,0xE70747C4,0x8162AA04,0xED37EF91,0x809DC971,
0xF3742CA2,0x80277872,0xF9B82684,0x7FFFFFFF,0x00000000,0x7D8A5F40,0xE70747C4,
0x7641AF3D,0xCF043AB3,0x6A6D98A4,0xB8E31319,0x5A82799A,0xA57D8666,0x471CECE7,
0x9592675C,0x30FBC54D,0x89BE50C3,0x18F8B83C,0x8275A0C0,0x00000000,0x80000000,
0xE70747C4,0x8275A0C0,0xCF043AB3,0x89BE50C3,0xB8E31319,0x9592675C,0xA57D8666,
0xA57D8666,0x9592675C,0xB8E31319,0x89BE50C3,0xCF043AB3,0x8275A0C0,0xE70747C4,
0x7FFFFFFF,0x00000000,0x5A82799A,0xA57D8666,0x00000000,0x80000000,0xA57D8666,
0xA57D8666,};

q31_t rearranged_twiddle_stride3_1024_q31[680]={
0x7FFFFFFF,0x00000000,0x7FFA72D1,0xFDA4D929,0x7FE9CBC0,0xFB49E6A3,0x7FCE0C3E,
0xF8EF5CBB,0x7FA736B4,0xF6956FB7,0x7F754E80,0xF43C53CB,0x7F3857F6,0xF1E43D1C,
0x7EF05860,0xEF8D5FB8,0x7E9D55FC,0xED37EF91,0x7E3F57FF,0xEAE4207A,0x7DD6668F,
0xE8922622,0x7D628AC6,0xE642340D,0x7CE3CEB2,0xE3F47D96,0x7C5A3D50,0xE1A935E2,
0x7BC5E290,0xDF608FE4,0x7B26CB4F,0xDD1ABE51,0x7A7D055B,0xDAD7F3A2,0x79C89F6E,
0xD898620C,0x7909A92D,0xD65C3B7B,0x78403329,0xD423B191,0x776C4EDB,0xD1EEF59E,
0x768E0EA6,0xCFBE389F,0x75A585CF,0xCD91AB39,0x74B2C884,0xCB697DB0,0x73B5EBD1,
0xC945DFEC,0x72AF05A7,0xC727016D,0x719E2CD2,0xC50D1149,0x708378FF,0xC2F83E2A,
0x6F5F02B2,0xC0E8B648,0x6E30E34A,0xBEDEA765,0x6CF934FC,0xBCDA3ECB,0x6BB812D1,
0xBADBA943,0x6A6D98A4,0xB8E31319,0x6919E320,0xB6F0A812,0x67BD0FBD,0xB5049368,
0x66573CBB,0xB31EFFCC,0x64E88926,0xB140175B,0x637114CC,0xAF6803A2,0x61F1003F,
0xAD96ED92,0x60686CCF,0xABCCFD83,0x5ED77C8A,0xAA0A5B2E,0x5D3E5237,0xA84F2DAA,
0x5B9D1154,0xA69B9B68,0x59F3DE12,0xA4EFCA31,0x5842DD54,0xA34BDF20,0x568A34A9,
0xA1AFFEA3,0x54CA0A4B,0xA01C4C73,0x53028518,0x9E90EB94,0x5133CC94,0x9D0DFE54,
0x4F5E08E3,0x9B93A641,0x4D8162C4,0x9A22042D,0x4B9E0390,0x98B93828,0x49B41533,
0x9759617F,0x47C3C22F,0x96029EB6,0x45CD358F,0x94B50D87,0x43D09AED,0x9370CAE4,
0x41CE1E65,0x9235F2EC,0x3FC5EC98,0x9104A0EE,0x3DB832A6,0x8FDCEF66,0x3BA51E29,
0x8EBEF7FB,0x398CDD32,0x8DAAD37B,0x376F9E46,0x8CA099DA,0x354D9057,0x8BA0622F,
0x3326E2C3,0x8AAA42B4,0x30FBC54D,0x89BE50C3,0x2ECC681E,0x88DCA0D3,0x2C98FBBA,
0x88054677,0x2A61B101,0x8738545E,0x2826B928,0x8675DC4F,0x25E845B6,0x85BDEF28,
0x23A6887F,0x85109CDD,0x2161B3A0,0x846DF477,0x1F19F97B,0x83D60412,0x1CCF8CB3,
0x8348D8DC,0x1A82A026,0x82C67F14,0x183366E9,0x824F0208,0x15E21445,0x81E26C16,
0x138EDBB1,0x8180C6A9,0x1139F0CF,0x812A1A3A,0x0EE38766,0x80DE6E4C,0x0C8BD35E,
0x809DC971,0x0A3308BD,0x80683143,0x07D95B9E,0x803DAA6A,0x057F0035,0x801E3895,
0x03242ABF,0x8009DE7E,0x00C90F88,0x80009DEA,0xFE6DE2E0,0x800277A6,0xFC12D91A,
0x800F6B88,0xF9B82684,0x80277872,0xF75DFF66,0x804A9C4D,0xF50497FB,0x8078D40D,
0xF2AC246E,0x80B21BAF,0xF054D8D5,0x80F66E3C,0xEDFEE92B,0x8145C5C7,0xEBAA894F,
0x81A01B6D,0xE957ECFB,0x82056758,0xE70747C4,0x8275A0C0,0xE4B8CD11,0x82F0BDE8,
0xE26CB01B,0x8376B422,0xE02323E5,0x840777D0,0xDDDC5B3B,0x84A2FC62,0xDB9888A8,
0x8549345C,0xD957DE7A,0x85FA1153,0xD71A8EB5,0x86B583EE,0xD4E0CB15,0x877B7BEC,
0xD2AAC504,0x884BE821,0xD078AD9E,0x8926B677,0xCE4AB5A2,0x8A0BD3F5,0xCC210D79,
0x8AFB2CBB,0xC9FBE527,0x8BF4AC05,0xC7DB6C50,0x8CF83C30,0xC5BFD22E,0x8E05C6B7,
0xC3A94590,0x8F1D343A,0xC197F4D4,0x903E6C7B,0xBF8C0DE3,0x91695663,0xBD85BE30,
0x929DD806,0xBB8532B0,0x93DBD6A0,0xB98A97D8,0x9523369C,0xB796199B,0x9673DB94,
0xB5A7E362,0x97CDA855,0xB3C0200C,0x99307EE0,0xB1DEF9E9,0x9A9C406E,0xB0049AB3,
0x9C10CD70,0xAE312B92,0x9D8E0597,0xAC64D510,0x9F13C7D0,0xAA9FBF1E,0xA0A1F24D,
0xA8E21106,0xA2386284,0xA72BF174,0xA3D6F534,0xA57D8666,0xA57D8666,0xA3D6F534,
0xA72BF174,0xA2386284,0xA8E21106,0xA0A1F24D,0xAA9FBF1E,0x9F13C7D0,0xAC64D510,
0x9D8E0597,0xAE312B92,0x9C10CD70,0xB0049AB3,0x9A9C406E,0xB1DEF9E9,0x99307EE0,
0xB3C0200C,0x97CDA855,0xB5A7E362,0x9673DB94,0xB796199B,0x9523369C,0xB98A97D8,
0x93DBD6A0,0xBB8532B0,0x929DD806,0xBD85BE30,0x91695663,0xBF8C0DE3,0x903E6C7B,
0xC197F4D4,0x8F1D343A,0xC3A94590,0x8E05C6B7,0xC5BFD22E,0x8CF83C30,0xC7DB6C50,
0x8BF4AC05,0xC9FBE527,0x8AFB2CBB,0xCC210D79,0x8A0BD3F5,0xCE4AB5A2,0x8926B677,
0xD078AD9E,0x884BE821,0xD2AAC504,0x877B7BEC,0xD4E0CB15,0x86B583EE,0xD71A8EB5,
0x85FA1153,0xD957DE7A,0x8549345C,0xDB9888A8,0x84A2FC62,0xDDDC5B3B,0x840777D0,
0xE02323E5,0x8376B422,0xE26CB01B,0x82F0BDE8,0xE4B8CD11,0x8275A0C0,0xE70747C4,
0x82056758,0xE957ECFB,0x81A01B6D,0xEBAA894F,0x8145C5C7,0xEDFEE92B,0x80F66E3C,
0xF054D8D5,0x80B21BAF,0xF2AC246E,0x8078D40D,0xF50497FB,0x804A9C4D,0xF75DFF66,
0x80277872,0xF9B82684,0x800F6B88,0xFC12D91A,0x800277A6,0xFE6DE2E0,0x80009DEA,
0x00C90F88,0x8009DE7E,0x03242ABF,0x801E3895,0x057F0035,0x803DAA6A,0x07D95B9E,
0x80683143,0x0A3308BD,0x809DC971,0x0C8BD35E,0x80DE6E4C,0x0EE38766,0x812A1A3A,
0x1139F0CF,0x8180C6A9,0x138EDBB1,0x81E26C16,0x15E21445,0x824F0208,0x183366E9,
0x82C67F14,0x1A82A026,0x8348D8DC,0x1CCF8CB3,0x83D60412,0x1F19F97B,0x846DF477,
0x2161B3A0,0x85109CDD,0x23A6887F,0x85BDEF28,0x25E845B6,0x8675DC4F,0x2826B928,
0x8738545E,0x2A61B101,0x88054677,0x2C98FBBA,0x88DCA0D3,0x2ECC681E,0x89BE50C3,
0x30FBC54D,0x8AAA42B4,0x3326E2C3,0x8BA0622F,0x354D9057,0x8CA099DA,0x376F9E46,
0x8DAAD37B,0x398CDD32,0x8EBEF7FB,0x3BA51E29,0x8FDCEF66,0x3DB832A6,0x9104A0EE,
0x3FC5EC98,0x9235F2EC,0x41CE1E65,0x9370CAE4,0x43D09AED,0x94B50D87,0x45CD358F,
0x96029EB6,0x47C3C22F,0x9759617F,0x49B41533,0x98B93828,0x4B9E0390,0x9A22042D,
0x4D8162C4,0x9B93A641,0x4F5E08E3,0x9D0DFE54,0x5133CC94,0x9E90EB94,0x53028518,
0xA01C4C73,0x54CA0A4B,0xA1AFFEA3,0x568A34A9,0xA34BDF20,0x5842DD54,0xA4EFCA31,
0x59F3DE12,0xA69B9B68,0x5B9D1154,0xA84F2DAA,0x5D3E5237,0xAA0A5B2E,0x5ED77C8A,
0xABCCFD83,0x60686CCF,0xAD96ED92,0x61F1003F,0xAF6803A2,0x637114CC,0xB140175B,
0x64E88926,0xB31EFFCC,0x66573CBB,0xB5049368,0x67BD0FBD,0xB6F0A812,0x6919E320,
0xB8E31319,0x6A6D98A4,0xBADBA943,0x6BB812D1,0xBCDA3ECB,0x6CF934FC,0xBEDEA765,
0x6E30E34A,0xC0E8B648,0x6F5F02B2,0xC2F83E2A,0x708378FF,0xC50D1149,0x719E2CD2,
0xC727016D,0x72AF05A7,0xC945DFEC,0x73B5EBD1,0xCB697DB0,0x74B2C884,0xCD91AB39,
0x75A585CF,0xCFBE389F,0x768E0EA6,0xD1EEF59E,0x776C4EDB,0xD423B191,0x78403329,
0xD65C3B7B,0x7909A92D,0xD898620C,0x79C89F6E,0xDAD7F3A2,0x7A7D055B,0xDD1ABE51,
0x7B26CB4F,0xDF608FE4,0x7BC5E290,0xE1A935E2,0x7C5A3D50,0xE3F47D96,0x7CE3CEB2,
0xE642340D,0x7D628AC6,0xE8922622,0x7DD6668F,0xEAE4207A,0x7E3F57FF,0xED37EF91,
0x7E9D55FC,0xEF8D5FB8,0x7EF05860,0xF1E43D1C,0x7F3857F6,0xF43C53CB,0x7F754E80,
0xF6956FB7,0x7FA736B4,0xF8EF5CBB,0x7FCE0C3E,0xFB49E6A3,0x7FE9CBC0,0xFDA4D929,
0x7FFA72D1,0x7FFFFFFF,0x00000000,0x7FA736B4,0xF6956FB7,0x7E9D55FC,0xED37EF91,
0x7CE3CEB2,0xE3F47D96,0x7A7D055B,0xDAD7F3A2,0x776C4EDB,0xD1EEF59E,0x73B5EBD1,
0xC945DFEC,0x6F5F02B2,0xC0E8B648,0x6A6D98A4,0xB8E31319,0x64E88926,0xB140175B,
0x5ED77C8A,0xAA0A5B2E,0x5842DD54,0xA34BDF20,0x5133CC94,0x9D0DFE54,0x49B41533,
0x9759617F,0x41CE1E65,0x9235F2EC,0x398CDD32,0x8DAAD37B,0x30FBC54D,0x89BE50C3,
0x2826B928,0x8675DC4F,0x1F19F97B,0x83D60412,0x15E21445,0x81E26C16,0x0C8BD35E,
0x809DC971,0x03242ABF,0x8009DE7E,0xF9B82684,0x80277872,0xF054D8D5,0x80F66E3C,
0xE70747C4,0x8275A0C0,0xDDDC5B3B,0x84A2FC62,0xD4E0CB15,0x877B7BEC,0xCC210D79,
0x8AFB2CBB,0xC3A94590,0x8F1D343A,0xBB8532B0,0x93DBD6A0,0xB3C0200C,0x99307EE0,
0xAC64D510,0x9F13C7D0,0xA57D8666,0xA57D8666,0x9F13C7D0,0xAC64D510,0x99307EE0,
0xB3C0200C,0x93DBD6A0,0xBB8532B0,0x8F1D343A,0xC3A94590,0x8AFB2CBB,0xCC210D79,
0x877B7BEC,0xD4E0CB15,0x84A2FC62,0xDDDC5B3B,0x8275A0C0,0xE70747C4,0x80F66E3C,
0xF054D8D5,0x80277872,0xF9B82684,0x8009DE7E,0x03242ABF,0x809DC971,0x0C8BD35E,
0x81E26C16,0x15E21445,0x83D60412,0x1F19F97B,0x8675DC4F,0x2826B928,0x89BE50C3,
0x30FBC54D,0x8DAAD37B,0x398CDD32,0x9235F2EC,0x41CE1E65,0x9759617F,0x49B41533,
0x9D0DFE54,0x5133CC94,0xA34BDF20,0x5842DD54,0xAA0A5B2E,0x5ED77C8A,0xB140175B,
0x64E88926,0xB8E31319,0x6A6D98A4,0xC0E8B648,0x6F5F02B2,0xC945DFEC,0x73B5EBD1,
0xD1EEF59E,0x776C4EDB,0xDAD7F3A2,0x7A7D055B,0xE3F47D96,0x7CE3CEB2,0xED37EF91,
0x7E9D55FC,0xF6956FB7,0x7FA736B4,0x7FFFFFFF,0x00000000,0x7A7D055B,0xDAD7F3A2,
0x6A6D98A4,0xB8E31319,0x5133CC94,0x9D0DFE54,0x30FBC54D,0x89BE50C3,0x0C8BD35E,
0x809DC971,0xE70747C4,0x8275A0C0,0xC3A94590,0x8F1D343A,0xA57D8666,0xA57D8666,
0x8F1D343A,0xC3A94590,0x8275A0C0,0xE70747C4,0x809DC971,0x0C8BD35E,0x89BE50C3,
0x30FBC54D,0x9D0DFE54,0x5133CC94,0xB8E31319,0x6A6D98A4,0xDAD7F3A2,0x7A7D055B,
0x7FFFFFFF,0x00000000,0x30FBC54D,0x89BE50C3,0xA57D8666,0xA57D8666,0x89BE50C3,
0x30FBC54D,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q31_4096) || defined(ARM_TABLE_TWIDDLECOEF_Q31_8192)

uint32_t rearranged_twiddle_tab_stride1_arr_4096_q31[6]={
0,2048,2560,2688,2720,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_4096_q31[6]={
0,2048,2560,2688,2720,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_4096_q31[6]={
0,2048,2560,2688,2720,0,};

q31_t rearranged_twiddle_stride1_4096_q31[2728]={
0x7FFFFFFF,0x00000000,0x7FFFF621,0xFFCDBC0B,0x7FFFD886,0xFF9B781D,0x7FFFA72C,
0xFF69343F,0x7FFF6216,0xFF36F078,0x7FFF0943,0xFF04ACD0,0x7FFE9CB2,0xFED2694F,
0x7FFE1C65,0xFEA025FD,0x7FFD885A,0xFE6DE2E0,0x7FFCE093,0xFE3BA002,0x7FFC250F,
0xFE095D69,0x7FFB55CE,0xFDD71B1E,0x7FFA72D1,0xFDA4D929,0x7FF97C18,0xFD729790,
0x7FF871A2,0xFD40565C,0x7FF75370,0xFD0E1594,0x7FF62182,0xFCDBD541,0x7FF4DBD9,
0xFCA9956A,0x7FF38274,0xFC775616,0x7FF21553,0xFC45174E,0x7FF09478,0xFC12D91A,
0x7FEEFFE1,0xFBE09B80,0x7FED5791,0xFBAE5E89,0x7FEB9B85,0xFB7C223D,0x7FE9CBC0,
0xFB49E6A3,0x7FE7E841,0xFB17ABC2,0x7FE5F108,0xFAE571A4,0x7FE3E616,0xFAB3384F,
0x7FE1C76B,0xFA80FFCB,0x7FDF9508,0xFA4EC821,0x7FDD4EEC,0xFA1C9157,0x7FDAF519,
0xF9EA5B75,0x7FD8878E,0xF9B82684,0x7FD6064C,0xF985F28A,0x7FD37153,0xF953BF91,
0x7FD0C8A3,0xF9218D9E,0x7FCE0C3E,0xF8EF5CBB,0x7FCB3C23,0xF8BD2CEF,0x7FC85854,
0xF88AFE42,0x7FC560CF,0xF858D0BB,0x7FC25596,0xF826A462,0x7FBF36AA,0xF7F4793E,
0x7FBC040A,0xF7C24F59,0x7FB8BDB8,0xF79026B9,0x7FB563B3,0xF75DFF66,0x7FB1F5FC,
0xF72BD967,0x7FAE7495,0xF6F9B4C6,0x7FAADF7C,0xF6C79188,0x7FA736B4,0xF6956FB7,
0x7FA37A3C,0xF6634F59,0x7F9FAA15,0xF6313077,0x7F9BC640,0xF5FF1318,0x7F97CEBD,
0xF5CCF743,0x7F93C38C,0xF59ADD02,0x7F8FA4B0,0xF568C45B,0x7F8B7227,0xF536AD56,
0x7F872BF3,0xF50497FB,0x7F82D214,0xF4D28451,0x7F7E648C,0xF4A07261,0x7F79E35A,
0xF46E6231,0x7F754E80,0xF43C53CB,0x7F70A5FE,0xF40A4735,0x7F6BE9D4,0xF3D83C77,
0x7F671A05,0xF3A63398,0x7F62368F,0xF3742CA2,0x7F5D3F75,0xF342279B,0x7F5834B7,
0xF310248A,0x7F531655,0xF2DE2379,0x7F4DE451,0xF2AC246E,0x7F489EAA,0xF27A2771,
0x7F434563,0xF2482C8A,0x7F3DD87C,0xF21633C0,0x7F3857F6,0xF1E43D1C,0x7F32C3D1,
0xF1B248A5,0x7F2D1C0E,0xF1805662,0x7F2760AF,0xF14E665C,0x7F2191B4,0xF11C789A,
0x7F1BAF1E,0xF0EA8D24,0x7F15B8EE,0xF0B8A401,0x7F0FAF25,0xF086BD39,0x7F0991C4,
0xF054D8D5,0x7F0360CB,0xF022F6DA,0x7EFD1C3C,0xEFF11753,0x7EF6C418,0xEFBF3A45,
0x7EF05860,0xEF8D5FB8,0x7EE9D914,0xEF5B87B5,0x7EE34636,0xEF29B243,0x7EDC9FC6,
0xEEF7DF6A,0x7ED5E5C6,0xEEC60F31,0x7ECF1837,0xEE9441A0,0x7EC8371A,0xEE6276BF,
0x7EC14270,0xEE30AE96,0x7EBA3A39,0xEDFEE92B,0x7EB31E78,0xEDCD2687,0x7EABEF2C,
0xED9B66B2,0x7EA4AC58,0xED69A9B3,0x7E9D55FC,0xED37EF91,0x7E95EC1A,0xED063856,
0x7E8E6EB2,0xECD48407,0x7E86DDC6,0xECA2D2AD,0x7E7F3957,0xEC71244F,0x7E778166,
0xEC3F78F6,0x7E6FB5F4,0xEC0DD0A8,0x7E67D703,0xEBDC2B6E,0x7E5FE493,0xEBAA894F,
0x7E57DEA7,0xEB78EA52,0x7E4FC53E,0xEB474E81,0x7E47985B,0xEB15B5E1,0x7E3F57FF,
0xEAE4207A,0x7E37042A,0xEAB28E56,0x7E2E9CDF,0xEA80FF7A,0x7E26221F,0xEA4F73EE,
0x7E1D93EA,0xEA1DEBBB,0x7E14F242,0xE9EC66E8,0x7E0C3D29,0xE9BAE57D,0x7E0374A0,
0xE9896781,0x7DFA98A8,0xE957ECFB,0x7DF1A942,0xE92675F4,0x7DE8A670,0xE8F50273,
0x7DDF9034,0xE8C39280,0x7DD6668F,0xE8922622,0x7DCD2981,0xE860BD61,0x7DC3D90D,
0xE82F5844,0x7DBA7534,0xE7FDF6D4,0x7DB0FDF8,0xE7CC9917,0x7DA77359,0xE79B3F16,
0x7D9DD55A,0xE769E8D8,0x7D9423FC,0xE7389665,0x7D8A5F40,0xE70747C4,0x7D808728,
0xE6D5FCFC,0x7D769BB5,0xE6A4B616,0x7D6C9CE9,0xE6737319,0x7D628AC6,0xE642340D,
0x7D58654D,0xE610F8F9,0x7D4E2C7F,0xE5DFC1E5,0x7D43E05E,0xE5AE8ED8,0x7D3980EC,
0xE57D5FDA,0x7D2F0E2B,0xE54C34F3,0x7D24881B,0xE51B0E2A,0x7D19EEBF,0xE4E9EB87,
0x7D0F4218,0xE4B8CD11,0x7D048228,0xE487B2D0,0x7CF9AEF0,0xE4569CCB,0x7CEEC873,
0xE4258B0A,0x7CE3CEB2,0xE3F47D96,0x7CD8C1AE,0xE3C37474,0x7CCDA169,0xE3926FAD,
0x7CC26DE5,0xE3616F48,0x7CB72724,0xE330734D,0x7CABCD28,0xE2FF7BC3,0x7CA05FF1,
0xE2CE88B3,0x7C94DF83,0xE29D9A23,0x7C894BDE,0xE26CB01B,0x7C7DA505,0xE23BCAA2,
0x7C71EAF9,0xE20AE9C1,0x7C661DBC,0xE1DA0D7E,0x7C5A3D50,0xE1A935E2,0x7C4E49B7,
0xE17862F3,0x7C4242F2,0xE14794BA,0x7C362904,0xE116CB3D,0x7C29FBEE,0xE0E60685,
0x7C1DBBB3,0xE0B54698,0x7C116853,0xE0848B7F,0x7C0501D2,0xE053D541,0x7BF88830,
0xE02323E5,0x7BEBFB70,0xDFF27773,0x7BDF5B94,0xDFC1CFF3,0x7BD2A89E,0xDF912D6B,
0x7BC5E290,0xDF608FE4,0x7BB9096B,0xDF2FF764,0x7BAC1D31,0xDEFF63F4,0x7B9F1DE6,
0xDECED59B,0x7B920B89,0xDE9E4C60,0x7B84E61F,0xDE6DC84B,0x7B77ADA8,0xDE3D4964,
0x7B6A6227,0xDE0CCFB1,0x7B5D039E,0xDDDC5B3B,0x7B4F920E,0xDDABEC08,0x7B420D7A,
0xDD7B8220,0x7B3475E5,0xDD4B1D8C,0x7B26CB4F,0xDD1ABE51,0x7B190DBC,0xDCEA6478,
0x7B0B3D2C,0xDCBA1008,0x7AFD59A4,0xDC89C109,0x7AEF6323,0xDC597781,0x7AE159AE,
0xDC293379,0x7AD33D45,0xDBF8F4F8,0x7AC50DEC,0xDBC8BC06,0x7AB6CBA4,0xDB9888A8,
0x7AA8766F,0xDB685AE9,0x7A9A0E50,0xDB3832CD,0x7A8B9348,0xDB08105E,0x7A7D055B,
0xDAD7F3A2,0x7A6E648A,0xDAA7DCA1,0x7A5FB0D8,0xDA77CB63,0x7A50EA47,0xDA47BFEE,
0x7A4210D8,0xDA17BA4A,0x7A332490,0xD9E7BA7F,0x7A24256F,0xD9B7C094,0x7A151378,
0xD987CC90,0x7A05EEAD,0xD957DE7A,0x79F6B711,0xD927F65B,0x79E76CA7,0xD8F81439,
0x79D80F6F,0xD8C8381D,0x79C89F6E,0xD898620C,0x79B91CA4,0xD868920F,0x79A98715,
0xD838C82D,0x7999DEC4,0xD809046E,0x798A23B1,0xD7D946D8,0x797A55E0,0xD7A98F73,
0x796A7554,0xD779DE47,0x795A820E,0xD74A335B,0x794A7C12,0xD71A8EB5,0x793A6361,
0xD6EAF05F,0x792A37FE,0xD6BB585E,0x7919F9EC,0xD68BC6BA,0x7909A92D,0xD65C3B7B,
0x78F945C3,0xD62CB6A8,0x78E8CFB2,0xD5FD3848,0x78D846FB,0xD5CDC062,0x78C7ABA2,
0xD59E4EFF,0x78B6FDA8,0xD56EE424,0x78A63D11,0xD53F7FDA,0x789569DF,0xD5102228,
0x78848414,0xD4E0CB15,0x78738BB3,0xD4B17AA8,0x786280BF,0xD48230E9,0x7851633B,
0xD452EDDF,0x78403329,0xD423B191,0x782EF08B,0xD3F47C06,0x781D9B65,0xD3C54D47,
0x780C33B8,0xD396255A,0x77FAB989,0xD3670446,0x77E92CD9,0xD337EA12,0x77D78DAA,
0xD308D6C7,0x77C5DC01,0xD2D9CA6A,0x77B417DF,0xD2AAC504,0x77A24148,0xD27BC69C,
0x7790583E,0xD24CCF39,0x777E5CC3,0xD21DDEE2,0x776C4EDB,0xD1EEF59E,0x775A2E89,
0xD1C01375,0x7747FBCE,0xD191386E,0x7735B6AF,0xD1626490,0x77235F2D,0xD13397E2,
0x7710F54C,0xD104D26B,0x76FE790E,0xD0D61434,0x76EBEA77,0xD0A75D42,0x76D94989,
0xD078AD9E,0x76C69647,0xD04A054E,0x76B3D0B4,0xD01B6459,0x76A0F8D2,0xCFECCAC7,
0x768E0EA6,0xCFBE389F,0x767B1231,0xCF8FADE9,0x76680376,0xCF612AAA,0x7654E279,
0xCF32AEEB,0x7641AF3D,0xCF043AB3,0x762E69C4,0xCED5CE08,0x761B1211,0xCEA768F2,
0x7607A828,0xCE790B79,0x75F42C0B,0xCE4AB5A2,0x75E09DBD,0xCE1C6777,0x75CCFD42,
0xCDEE20FC,0x75B94A9C,0xCDBFE23A,0x75A585CF,0xCD91AB39,0x7591AEDD,0xCD637BFE,
0x757DC5CA,0xCD355491,0x7569CA99,0xCD0734F9,0x7555BD4C,0xCCD91D3D,0x75419DE7,
0xCCAB0D65,0x752D6C6C,0xCC7D0578,0x751928E0,0xCC4F057C,0x7504D345,0xCC210D79,
0x74F06B9E,0xCBF31D75,0x74DBF1EF,0xCBC53579,0x74C7663A,0xCB97558A,0x74B2C884,
0xCB697DB0,0x749E18CD,0xCB3BADF3,0x7489571C,0xCB0DE658,0x74748371,0xCAE026E8,
0x745F9DD1,0xCAB26FA9,0x744AA63F,0xCA84C0A3,0x74359CBD,0xCA5719DB,0x74208150,
0xCA297B5A,0x740B53FB,0xC9FBE527,0x73F614C0,0xC9CE5748,0x73E0C3A3,0xC9A0D1C5,
0x73CB60A8,0xC97354A4,0x73B5EBD1,0xC945DFEC,0x73A06522,0xC91873A5,0x738ACC9E,
0xC8EB0FD6,0x73752249,0xC8BDB485,0x735F6626,0xC89061BA,0x73499838,0xC863177B,
0x7333B883,0xC835D5D0,0x731DC70A,0xC8089CBF,0x7307C3D0,0xC7DB6C50,0x72F1AED9,
0xC7AE4489,0x72DB8828,0xC7812572,0x72C54FC1,0xC7540F11,0x72AF05A7,0xC727016D,
0x7298A9DD,0xC6F9FC8D,0x72823C67,0xC6CD0079,0x726BBD48,0xC6A00D37,0x72552C85,
0xC67322CE,0x723E8A20,0xC6464144,0x7227D61C,0xC61968A2,0x7211107E,0xC5EC98EE,
0x71FA3949,0xC5BFD22E,0x71E35080,0xC593146A,0x71CC5626,0xC5665FA9,0x71B54A41,
0xC539B3F1,0x719E2CD2,0xC50D1149,0x7186FDDE,0xC4E077B8,0x716FBD68,0xC4B3E746,
0x71586B74,0xC4875FF9,0x71410805,0xC45AE1D7,0x7129931F,0xC42E6CE8,0x71120CC5,
0xC4020133,0x70FA74FC,0xC3D59EBE,0x70E2CBC6,0xC3A94590,0x70CB1128,0xC37CF5B0,
0x70B34525,0xC350AF26,0x709B67C0,0xC32471F7,0x708378FF,0xC2F83E2A,0x706B78E3,
0xC2CC13C7,0x70536771,0xC29FF2D4,0x703B44AD,0xC273DB58,0x7023109A,0xC247CD5A,
0x700ACB3C,0xC21BC8E1,0x6FF27497,0xC1EFCDF3,0x6FDA0CAE,0xC1C3DC97,0x6FC19385,
0xC197F4D4,0x6FA90921,0xC16C16B0,0x6F906D84,0xC1404233,0x6F77C0B3,0xC1147764,
0x6F5F02B2,0xC0E8B648,0x6F463383,0xC0BCFEE7,0x6F2D532C,0xC0915148,0x6F1461B0,
0xC065AD70,0x6EFB5F12,0xC03A1368,0x6EE24B57,0xC00E8336,0x6EC92683,0xBFE2FCDF,
0x6EAFF099,0xBFB7806C,0x6E96A99D,0xBF8C0DE3,0x6E7D5193,0xBF60A54A,0x6E63E87F,
0xBF3546A8,0x6E4A6E66,0xBF09F205,0x6E30E34A,0xBEDEA765,0x6E174730,0xBEB366D1,
0x6DFD9A1C,0xBE88304F,0x6DE3DC11,0xBE5D03E6,0x6DCA0D14,0xBE31E19B,0x6DB02D29,
0xBE06C977,0x6D963C54,0xBDDBBB7F,0x6D7C3A98,0xBDB0B7BB,0x6D6227FA,0xBD85BE30,
0x6D48047E,0xBD5ACEE5,0x6D2DD027,0xBD2FE9E2,0x6D138AFB,0xBD050F2C,0x6CF934FC,
0xBCDA3ECB,0x6CDECE2F,0xBCAF78C4,0x6CC45698,0xBC84BD1F,0x6CA9CE3B,0xBC5A0BE2,
0x6C8F351C,0xBC2F6513,0x6C748B3F,0xBC04C8BA,0x6C59D0A9,0xBBDA36DD,0x6C3F055D,
0xBBAFAF82,0x6C242960,0xBB8532B0,0x6C093CB6,0xBB5AC06D,0x6BEE3F62,0xBB3058C0,
0x6BD3316A,0xBB05FBB0,0x6BB812D1,0xBADBA943,0x6B9CE39B,0xBAB16180,0x6B81A3CD,
0xBA87246D,0x6B66536B,0xBA5CF210,0x6B4AF279,0xBA32CA71,0x6B2F80FB,0xBA08AD95,
0x6B13FEF5,0xB9DE9B83,0x6AF86C6C,0xB9B49442,0x6ADCC964,0xB98A97D8,0x6AC115E2,
0xB960A64C,0x6AA551E9,0xB936BFA4,0x6A897D7D,0xB90CE3E6,0x6A6D98A4,0xB8E31319,
0x6A51A361,0xB8B94D44,0x6A359DB9,0xB88F926D,0x6A1987B0,0xB865E299,0x69FD614A,
0xB83C3DD1,0x69E12A8C,0xB812A41A,0x69C4E37A,0xB7E9157A,0x69A88C19,0xB7BF91F8,
0x698C246C,0xB796199B,0x696FAC78,0xB76CAC69,0x69532442,0xB7434A67,0x69368BCE,
0xB719F39E,0x6919E320,0xB6F0A812,0x68FD2A3D,0xB6C767CA,0x68E06129,0xB69E32CD,
0x68C387E9,0xB6750921,0x68A69E81,0xB64BEACD,0x6889A4F6,0xB622D7D6,0x686C9B4B,
0xB5F9D043,0x684F8186,0xB5D0D41A,0x683257AB,0xB5A7E362,0x68151DBE,0xB57EFE22,
0x67F7D3C5,0xB556245E,0x67DA79C3,0xB52D561E,0x67BD0FBD,0xB5049368,0x679F95B7,
0xB4DBDC42,0x67820BB7,0xB4B330B3,0x676471C0,0xB48A90C0,0x6746C7D8,0xB461FC70,
0x67290E02,0xB43973CA,0x670B4444,0xB410F6D3,0x66ED6AA1,0xB3E88592,0x66CF8120,
0xB3C0200C,0x66B187C3,0xB397C649,0x66937E91,0xB36F784F,0x6675658C,0xB3473623,
0x66573CBB,0xB31EFFCC,0x66390422,0xB2F6D550,0x661ABBC5,0xB2CEB6B5,0x65FC63A9,
0xB2A6A402,0x65DDFBD3,0xB27E9D3C,0x65BF8447,0xB256A26A,0x65A0FD0B,0xB22EB392,
0x65826622,0xB206D0BA,0x6563BF92,0xB1DEF9E9,0x6545095F,0xB1B72F23,0x6526438F,
0xB18F7071,0x65076E25,0xB167BDD7,0x64E88926,0xB140175B,0x64C99498,0xB1187D05,
0x64AA907F,0xB0F0EEDA,0x648B7CE0,0xB0C96CE0,0x646C59BF,0xB0A1F71D,0x644D2722,
0xB07A8D97,0x642DE50D,0xB0533055,0x640E9386,0xB02BDF5C,0x63EF3290,0xB0049AB3,
0x63CFC231,0xAFDD625F,0x63B0426D,0xAFB63667,0x6390B34A,0xAF8F16D1,0x637114CC,
0xAF6803A2,0x635166F9,0xAF40FCE1,0x6331A9D4,0xAF1A0293,0x6311DD64,0xAEF314C0,
0x62F201AC,0xAECC336C,0x62D216B3,0xAEA55E9E,0x62B21C7B,0xAE7E965B,0x6292130C,
0xAE57DAAB,0x6271FA69,0xAE312B92,0x6251D298,0xAE0A8916,0x62319B9D,0xADE3F33E,
0x6211557E,0xADBD6A10,0x61F1003F,0xAD96ED92,0x61D09BE5,0xAD707DC8,0x61B02876,
0xAD4A1ABA,0x618FA5F7,0xAD23C46E,0x616F146C,0xACFD7AE8,0x614E73DA,0xACD73E30,
0x612DC447,0xACB10E4B,0x610D05B7,0xAC8AEB3E,0x60EC3830,0xAC64D510,0x60CB5BB7,
0xAC3ECBC7,0x60AA7050,0xAC18CF69,0x60897601,0xABF2DFFB,0x60686CCF,0xABCCFD83,
0x604754BF,0xABA72807,0x60262DD6,0xAB815F8D,0x6004F819,0xAB5BA41A,0x5FE3B38D,
0xAB35F5B5,0x5FC26038,0xAB105464,0x5FA0FE1F,0xAAEAC02C,0x5F7F8D46,0xAAC53912,
0x5F5E0DB3,0xAA9FBF1E,0x5F3C7F6B,0xAA7A5253,0x5F1AE274,0xAA54F2BA,0x5EF936D1,
0xAA2FA056,0x5ED77C8A,0xAA0A5B2E,0x5EB5B3A2,0xA9E52347,0x5E93DC1F,0xA9BFF8A8,
0x5E71F606,0xA99ADB56,0x5E50015D,0xA975CB57,0x5E2DFE29,0xA950C8B0,0x5E0BEC6E,
0xA92BD367,0x5DE9CC33,0xA906EB82,0x5DC79D7C,0xA8E21106,0x5DA5604F,0xA8BD43FA,
0x5D8314B1,0xA8988463,0x5D60BAA7,0xA873D246,0x5D3E5237,0xA84F2DAA,0x5D1BDB65,
0xA82A9693,0x5CF95638,0xA8060D08,0x5CD6C2B5,0xA7E1910F,0x5CB420E0,0xA7BD22AC,
0x5C9170BF,0xA798C1E5,0x5C6EB258,0xA7746EC0,0x5C4BE5B0,0xA7502943,0x5C290ACC,
0xA72BF174,0x5C0621B2,0xA707C757,0x5BE32A67,0xA6E3AAF2,0x5BC024F0,0xA6BF9C4B,
0x5B9D1154,0xA69B9B68,0x5B79EF96,0xA677A84E,0x5B56BFBD,0xA653C303,0x5B3381CE,
0xA62FEB8B,0x5B1035CF,0xA60C21EE,0x5AECDBC5,0xA5E8662F,0x5AC973B5,0xA5C4B855,
0x5AA5FDA5,0xA5A11866,0x5A82799A,0xA57D8666,0x5A5EE79A,0xA55A025B,0x5A3B47AB,
0xA5368C4B,0x5A1799D1,0xA513243B,0x59F3DE12,0xA4EFCA31,0x59D01475,0xA4CC7E32,
0x59AC3CFD,0xA4A94043,0x598857B2,0xA486106A,0x59646498,0xA462EEAC,0x594063B5,
0xA43FDB10,0x591C550E,0xA41CD599,0x58F838A9,0xA3F9DE4E,0x58D40E8C,0xA3D6F534,
0x58AFD6BD,0xA3B41A50,0x588B9140,0xA3914DA8,0x58673E1B,0xA36E8F41,0x5842DD54,
0xA34BDF20,0x581E6EF1,0xA3293D4B,0x57F9F2F8,0xA306A9C8,0x57D5696D,0xA2E4249B,
0x57B0D256,0xA2C1ADC9,0x578C2DBA,0xA29F4559,0x57677B9D,0xA27CEB4F,0x5742BC06,
0xA25A9FB1,0x571DEEFA,0xA2386284,0x56F9147E,0xA21633CD,0x56D42C99,0xA1F41392,
0x56AF3750,0xA1D201D7,0x568A34A9,0xA1AFFEA3,0x566524AA,0xA18E09FA,0x56400758,
0xA16C23E1,0x561ADCB9,0xA14A4C5E,0x55F5A4D2,0xA1288376,0x55D05FAA,0xA106C92F,
0x55AB0D46,0xA0E51D8C,0x5585ADAD,0xA0C38095,0x556040E2,0xA0A1F24D,0x553AC6EE,
0xA08072BA,0x55153FD4,0xA05F01E1,0x54EFAB9C,0xA03D9FC8,0x54CA0A4B,0xA01C4C73,
0x54A45BE6,0x9FFB07E7,0x547EA073,0x9FD9D22A,0x5458D7F9,0x9FB8AB41,0x5433027D,
0x9F979331,0x540D2005,0x9F7689FF,0x53E73097,0x9F558FB0,0x53C13439,0x9F34A449,
0x539B2AF0,0x9F13C7D0,0x537514C2,0x9EF2FA49,0x534EF1B5,0x9ED23BB9,0x5328C1D0,
0x9EB18C26,0x53028518,0x9E90EB94,0x52DC3B92,0x9E705A09,0x52B5E546,0x9E4FD78A,
0x528F8238,0x9E2F641B,0x5269126E,0x9E0EFFC1,0x524295F0,0x9DEEAA82,0x521C0CC2,
0x9DCE6463,0x51F576EA,0x9DAE2D68,0x51CED46E,0x9D8E0597,0x51A82555,0x9D6DECF4,
0x518169A5,0x9D4DE385,0x515AA162,0x9D2DE94D,0x5133CC94,0x9D0DFE54,0x510CEB40,
0x9CEE229C,0x50E5FD6D,0x9CCE562C,0x50BF031F,0x9CAE9907,0x5097FC5E,0x9C8EEB34,
0x5070E92F,0x9C6F4CB6,0x5049C999,0x9C4FBD93,0x50229DA1,0x9C303DCF,0x4FFB654D,
0x9C10CD70,0x4FD420A4,0x9BF16C7A,0x4FACCFAB,0x9BD21AF3,0x4F857269,0x9BB2D8DE,
0x4F5E08E3,0x9B93A641,0x4F369320,0x9B748320,0x4F0F1126,0x9B556F81,0x4EE782FB,
0x9B366B68,0x4EBFE8A5,0x9B1776DA,0x4E984229,0x9AF891DB,0x4E708F8F,0x9AD9BC71,
0x4E48D0DD,0x9ABAF6A1,0x4E210617,0x9A9C406E,0x4DF92F46,0x9A7D99DE,0x4DD14C6E,
0x9A5F02F5,0x4DA95D96,0x9A407BB9,0x4D8162C4,0x9A22042D,0x4D595BFE,0x9A039C57,
0x4D31494B,0x99E5443B,0x4D092AB0,0x99C6FBDE,0x4CE10034,0x99A8C345,0x4CB8C9DD,
0x998A9A74,0x4C9087B1,0x996C816F,0x4C6839B7,0x994E783D,0x4C3FDFF4,0x99307EE0,
0x4C177A6E,0x9912955F,0x4BEF092D,0x98F4BBBC,0x4BC68C36,0x98D6F1FE,0x4B9E0390,
0x98B93828,0x4B756F40,0x989B8E40,0x4B4CCF4D,0x987DF449,0x4B2423BE,0x98606A49,
0x4AFB6C98,0x9842F043,0x4AD2A9E2,0x9825863D,0x4AA9DBA2,0x98082C3B,0x4A8101DE,
0x97EAE242,0x4A581C9E,0x97CDA855,0x4A2F2BE6,0x97B07E7A,0x4A062FBD,0x979364B5,
0x49DD282A,0x97765B0A,0x49B41533,0x9759617F,0x498AF6DF,0x973C7817,0x4961CD33,
0x971F9ED7,0x49389836,0x9702D5C3,0x490F57EE,0x96E61CE0,0x48E60C62,0x96C97432,
0x48BCB599,0x96ACDBBE,0x48935397,0x96905388,0x4869E665,0x9673DB94,0x48406E08,
0x965773E7,0x4816EA86,0x963B1C86,0x47ED5BE6,0x961ED574,0x47C3C22F,0x96029EB6,
0x479A1D67,0x95E67850,0x47706D93,0x95CA6247,0x4746B2BC,0x95AE5C9F,0x471CECE7,
0x9592675C,0x46F31C1A,0x95768283,0x46C9405C,0x955AAE17,0x469F59B4,0x953EEA1E,
0x46756828,0x9523369C,0x464B6BBE,0x95079394,0x4621647D,0x94EC010B,0x45F7526B,
0x94D07F05,0x45CD358F,0x94B50D87,0x45A30DF0,0x9499AC95,0x4578DB93,0x947E5C33,
0x454E9E80,0x94631C65,0x452456BD,0x9447ED2F,0x44FA0450,0x942CCE96,0x44CFA740,
0x9411C09E,0x44A53F93,0x93F6C34A,0x447ACD50,0x93DBD6A0,0x4450507E,0x93C0FAA3,
0x4425C923,0x93A62F57,0x43FB3746,0x938B74C1,0x43D09AED,0x9370CAE4,0x43A5F41E,
0x935631C5,0x437B42E1,0x933BA968,0x4350873C,0x932131D1,0x4325C135,0x9306CB04,
0x42FAF0D4,0x92EC7505,0x42D0161E,0x92D22FD9,0x42A5311B,0x92B7FB82,0x427A41D0,
0x929DD806,0x424F4845,0x9283C568,0x42244481,0x9269C3AC,0x41F93689,0x924FD2D7,
0x41CE1E65,0x9235F2EC,0x41A2FC1A,0x921C23EF,0x4177CFB1,0x920265E4,0x414C992F,
0x91E8B8D0,0x4121589B,0x91CF1CB6,0x40F60DFB,0x91B5919A,0x40CAB958,0x919C1781,
0x409F5AB6,0x9182AE6D,0x4073F21D,0x91695663,0x40487F94,0x91500F67,0x401D0321,
0x9136D97D,0x3FF17CCA,0x911DB4A9,0x3FC5EC98,0x9104A0EE,0x3F9A5290,0x90EB9E50,
0x3F6EAEB8,0x90D2ACD4,0x3F430119,0x90B9CC7D,0x3F1749B8,0x90A0FD4E,0x3EEB889C,
0x90883F4D,0x3EBFBDCD,0x906F927C,0x3E93E950,0x9056F6DF,0x3E680B2C,0x903E6C7B,
0x3E3C2369,0x9025F352,0x3E10320D,0x900D8B69,0x3DE4371F,0x8FF534C4,0x3DB832A6,
0x8FDCEF66,0x3D8C24A8,0x8FC4BB53,0x3D600D2C,0x8FAC988F,0x3D33EC39,0x8F94871D,
0x3D07C1D6,0x8F7C8701,0x3CDB8E09,0x8F649840,0x3CAF50DA,0x8F4CBADB,0x3C830A50,
0x8F34EED8,0x3C56BA70,0x8F1D343A,0x3C2A6142,0x8F058B04,0x3BFDFECD,0x8EEDF33B,
0x3BD19318,0x8ED66CE1,0x3BA51E29,0x8EBEF7FB,0x3B78A007,0x8EA7948C,0x3B4C18BA,
0x8E904298,0x3B1F8848,0x8E790222,0x3AF2EEB7,0x8E61D32E,0x3AC64C0F,0x8E4AB5BF,
0x3A99A057,0x8E33A9DA,0x3A6CEB96,0x8E1CAF80,0x3A402DD2,0x8E05C6B7,0x3A136712,
0x8DEEEF82,0x39E6975E,0x8DD829E4,0x39B9BEBC,0x8DC175E0,0x398CDD32,0x8DAAD37B,
0x395FF2C9,0x8D9442B8,0x3932FF87,0x8D7DC399,0x39060373,0x8D675623,0x38D8FE93,
0x8D50FA59,0x38ABF0EF,0x8D3AB03F,0x387EDA8E,0x8D2477D8,0x3851BB77,0x8D0E5127,
0x382493B0,0x8CF83C30,0x37F76341,0x8CE238F6,0x37CA2A30,0x8CCC477D,0x379CE885,
0x8CB667C8,0x376F9E46,0x8CA099DA,0x37424B7B,0x8C8ADDB7,0x3714F02A,0x8C753362,
0x36E78C5B,0x8C5F9ADE,0x36BA2014,0x8C4A142F,0x368CAB5C,0x8C349F58,0x365F2E3B,
0x8C1F3C5D,0x3631A8B8,0x8C09EB40,0x36041AD9,0x8BF4AC05,0x35D684A6,0x8BDF7EB0,
0x35A8E625,0x8BCA6343,0x357B3F5D,0x8BB559C1,0x354D9057,0x8BA0622F,0x351FD918,
0x8B8B7C8F,0x34F219A8,0x8B76A8E4,0x34C4520D,0x8B61E733,0x34968250,0x8B4D377C,
0x3468AA76,0x8B3899C6,0x343ACA87,0x8B240E11,0x340CE28B,0x8B0F9462,0x33DEF287,
0x8AFB2CBB,0x33B0FA84,0x8AE6D720,0x3382FA88,0x8AD29394,0x3354F29B,0x8ABE6219,
0x3326E2C3,0x8AAA42B4,0x32F8CB07,0x8A963567,0x32CAAB6F,0x8A823A36,0x329C8402,
0x8A6E5123,0x326E54C7,0x8A5A7A31,0x32401DC6,0x8A46B564,0x3211DF04,0x8A3302BE,
0x31E39889,0x8A1F6243,0x31B54A5E,0x8A0BD3F5,0x3186F487,0x89F857D8,0x3158970E,
0x89E4EDEF,0x312A31F8,0x89D1963C,0x30FBC54D,0x89BE50C3,0x30CD5115,0x89AB1D87,
0x309ED556,0x8997FC8A,0x30705217,0x8984EDCF,0x3041C761,0x8971F15A,0x30133539,
0x895F072E,0x2FE49BA7,0x894C2F4C,0x2FB5FAB2,0x893969B9,0x2F875262,0x8926B677,
0x2F58A2BE,0x89141589,0x2F29EBCC,0x890186F2,0x2EFB2D95,0x88EF0AB4,0x2ECC681E,
0x88DCA0D3,0x2E9D9B70,0x88CA4951,0x2E6EC792,0x88B80432,0x2E3FEC8B,0x88A5D177,
0x2E110A62,0x8893B125,0x2DE2211E,0x8881A33D,0x2DB330C7,0x886FA7C2,0x2D843964,
0x885DBEB8,0x2D553AFC,0x884BE821,0x2D263596,0x883A23FF,0x2CF72939,0x88287256,
0x2CC815EE,0x8816D327,0x2C98FBBA,0x88054677,0x2C69DAA6,0x87F3CC48,0x2C3AB2B9,
0x87E2649B,0x2C0B83FA,0x87D10F75,0x2BDC4E6F,0x87BFCCD7,0x2BAD1221,0x87AE9CC5,
0x2B7DCF17,0x879D7F41,0x2B4E8558,0x878C744D,0x2B1F34EB,0x877B7BEC,0x2AEFDDD8,
0x876A9621,0x2AC08026,0x8759C2EF,0x2A911BDC,0x87490258,0x2A61B101,0x8738545E,
0x2A323F9E,0x8727B905,0x2A02C7B8,0x8717304E,0x29D34958,0x8706BA3D,0x29A3C485,
0x86F656D3,0x29743946,0x86E60614,0x2944A7A2,0x86D5C802,0x29150FA1,0x86C59C9F,
0x28E5714B,0x86B583EE,0x28B5CCA5,0x86A57DF2,0x288621B9,0x86958AAC,0x2856708D,
0x8685AA20,0x2826B928,0x8675DC4F,0x27F6FB92,0x8666213C,0x27C737D3,0x865678EB,
0x27976DF1,0x8646E35C,0x27679DF4,0x86376092,0x2737C7E3,0x8627F091,0x2707EBC7,
0x86189359,0x26D809A5,0x860948EF,0x26A82186,0x85FA1153,0x26783370,0x85EAEC88,
0x26483F6C,0x85DBDA91,0x26184581,0x85CCDB70,0x25E845B6,0x85BDEF28,0x25B84012,
0x85AF15B9,0x2588349D,0x85A04F28,0x2558235F,0x85919B76,0x25280C5E,0x8582FAA5,
0x24F7EFA2,0x85746CB8,0x24C7CD33,0x8565F1B0,0x2497A517,0x85578991,0x24677758,
0x8549345C,0x243743FA,0x853AF214,0x24070B08,0x852CC2BB,0x23D6CC87,0x851EA652,
0x23A6887F,0x85109CDD,0x23763EF7,0x8502A65C,0x2345EFF8,0x84F4C2D4,0x23159B88,
0x84E6F244,0x22E541AF,0x84D934B1,0x22B4E274,0x84CB8A1B,0x22847DE0,0x84BDF286,
0x225413F8,0x84B06DF2,0x2223A4C5,0x84A2FC62,0x21F3304F,0x84959DD9,0x21C2B69C,
0x84885258,0x219237B5,0x847B19E1,0x2161B3A0,0x846DF477,0x21312A65,0x8460E21A,
0x21009C0C,0x8453E2CF,0x20D0089C,0x8446F695,0x209F701C,0x843A1D70,0x206ED295,
0x842D5762,0x203E300D,0x8420A46C,0x200D888D,0x84140490,0x1FDCDC1B,0x840777D0,
0x1FAC2ABF,0x83FAFE2E,0x1F7B7481,0x83EE97AD,0x1F4AB968,0x83E2444D,0x1F19F97B,
0x83D60412,0x1EE934C3,0x83C9D6FC,0x1EB86B46,0x83BDBD0E,0x1E879D0D,0x83B1B649,
0x1E56CA1E,0x83A5C2B0,0x1E25F282,0x8399E244,0x1DF5163F,0x838E1507,0x1DC4355E,
0x83825AFB,0x1D934FE5,0x8376B422,0x1D6265DD,0x836B207D,0x1D31774D,0x835FA00F,
0x1D00843D,0x835432D8,0x1CCF8CB3,0x8348D8DC,0x1C9E90B8,0x833D921B,0x1C6D9053,
0x83325E97,0x1C3C8B8C,0x83273E52,0x1C0B826A,0x831C314E,0x1BDA74F6,0x8311378D,
0x1BA96335,0x83065110,0x1B784D30,0x82FB7DD8,0x1B4732EF,0x82F0BDE8,0x1B161479,
0x82E61141,0x1AE4F1D6,0x82DB77E5,0x1AB3CB0D,0x82D0F1D5,0x1A82A026,0x82C67F14,
0x1A517128,0x82BC1FA2,0x1A203E1B,0x82B1D381,0x19EF0707,0x82A79AB3,0x19BDCBF3,
0x829D753A,0x198C8CE7,0x82936317,0x195B49EA,0x8289644B,0x192A0304,0x827F78D8,
0x18F8B83C,0x8275A0C0,0x18C7699B,0x826BDC04,0x18961728,0x82622AA6,0x1864C0EA,
0x82588CA7,0x183366E9,0x824F0208,0x1802092C,0x82458ACC,0x17D0A7BC,0x823C26F3,
0x179F429F,0x8232D67F,0x176DD9DE,0x82299971,0x173C6D80,0x82206FCC,0x170AFD8D,
0x82175990,0x16D98A0C,0x820E56BE,0x16A81305,0x82056758,0x1676987F,0x81FC8B60,
0x16451A83,0x81F3C2D7,0x16139918,0x81EB0DBE,0x15E21445,0x81E26C16,0x15B08C12,
0x81D9DDE1,0x157F0086,0x81D16321,0x154D71AA,0x81C8FBD6,0x151BDF86,0x81C0A801,
0x14EA4A1F,0x81B867A5,0x14B8B17F,0x81B03AC2,0x148715AE,0x81A82159,0x145576B1,
0x81A01B6D,0x1423D492,0x819828FD,0x13F22F58,0x81904A0C,0x13C0870A,0x81887E9A,
0x138EDBB1,0x8180C6A9,0x135D2D53,0x8179223A,0x132B7BF9,0x8171914E,0x12F9C7AA,
0x816A13E6,0x12C8106F,0x8162AA04,0x1296564D,0x815B53A8,0x1264994E,0x815410D4,
0x1232D979,0x814CE188,0x120116D5,0x8145C5C7,0x11CF516A,0x813EBD90,0x119D8941,
0x8137C8E6,0x116BBE60,0x8130E7C9,0x1139F0CF,0x812A1A3A,0x11082096,0x8123603A,
0x10D64DBD,0x811CB9CA,0x10A4784B,0x811626EC,0x1072A048,0x810FA7A0,0x1040C5BB,
0x81093BE8,0x100EE8AD,0x8102E3C4,0x0FDD0926,0x80FC9F35,0x0FAB272B,0x80F66E3C,
0x0F7942C7,0x80F050DB,0x0F475BFF,0x80EA4712,0x0F1572DC,0x80E450E2,0x0EE38766,
0x80DE6E4C,0x0EB199A4,0x80D89F51,0x0E7FA99E,0x80D2E3F2,0x0E4DB75B,0x80CD3C2F,
0x0E1BC2E4,0x80C7A80A,0x0DE9CC40,0x80C22784,0x0DB7D376,0x80BCBA9D,0x0D85D88F,
0x80B76156,0x0D53DB92,0x80B21BAF,0x0D21DC87,0x80ACE9AB,0x0CEFDB76,0x80A7CB49,
0x0CBDD865,0x80A2C08B,0x0C8BD35E,0x809DC971,0x0C59CC68,0x8098E5FB,0x0C27C389,
0x8094162C,0x0BF5B8CB,0x808F5A02,0x0BC3AC35,0x808AB180,0x0B919DCF,0x80861CA6,
0x0B5F8D9F,0x80819B74,0x0B2D7BAF,0x807D2DEC,0x0AFB6805,0x8078D40D,0x0AC952AA,
0x80748DD9,0x0A973BA5,0x80705B50,0x0A6522FE,0x806C3C74,0x0A3308BD,0x80683143,
0x0A00ECE8,0x806439C0,0x09CECF89,0x806055EB,0x099CB0A7,0x805C85C4,0x096A9049,
0x8058C94C,0x09386E78,0x80552084,0x09064B3A,0x80518B6B,0x08D42699,0x804E0A04,
0x08A2009A,0x804A9C4D,0x086FD947,0x80474248,0x083DB0A7,0x8043FBF6,0x080B86C2,
0x8040C956,0x07D95B9E,0x803DAA6A,0x07A72F45,0x803A9F31,0x077501BE,0x8037A7AC,
0x0742D311,0x8034C3DD,0x0710A345,0x8031F3C2,0x06DE7262,0x802F375D,0x06AC406F,
0x802C8EAD,0x067A0D76,0x8029F9B4,0x0647D97C,0x80277872,0x0615A48B,0x80250AE7,
0x05E36EA9,0x8022B114,0x05B137DF,0x80206AF8,0x057F0035,0x801E3895,0x054CC7B1,
0x801C19EA,0x051A8E5C,0x801A0EF8,0x04E8543E,0x801817BF,0x04B6195D,0x80163440,
0x0483DDC3,0x8014647B,0x0451A177,0x8012A86F,0x041F6480,0x8011001F,0x03ED26E6,
0x800F6B88,0x03BAE8B2,0x800DEAAD,0x0388A9EA,0x800C7D8C,0x03566A96,0x800B2427,
0x03242ABF,0x8009DE7E,0x02F1EA6C,0x8008AC90,0x02BFA9A4,0x80078E5E,0x028D6870,
0x800683E8,0x025B26D7,0x80058D2F,0x0228E4E2,0x8004AA32,0x01F6A297,0x8003DAF1,
0x01C45FFE,0x80031F6D,0x01921D20,0x800277A6,0x015FDA03,0x8001E39B,0x012D96B1,
0x8001634E,0x00FB5330,0x8000F6BD,0x00C90F88,0x80009DEA,0x0096CBC1,0x800058D4,
0x006487E3,0x8000277A,0x003243F5,0x800009DF,0x7FFFFFFF,0x00000000,0x7FFF6216,
0xFF36F078,0x7FFD885A,0xFE6DE2E0,0x7FFA72D1,0xFDA4D929,0x7FF62182,0xFCDBD541,
0x7FF09478,0xFC12D91A,0x7FE9CBC0,0xFB49E6A3,0x7FE1C76B,0xFA80FFCB,0x7FD8878E,
0xF9B82684,0x7FCE0C3E,0xF8EF5CBB,0x7FC25596,0xF826A462,0x7FB563B3,0xF75DFF66,
0x7FA736B4,0xF6956FB7,0x7F97CEBD,0xF5CCF743,0x7F872BF3,0xF50497FB,0x7F754E80,
0xF43C53CB,0x7F62368F,0xF3742CA2,0x7F4DE451,0xF2AC246E,0x7F3857F6,0xF1E43D1C,
0x7F2191B4,0xF11C789A,0x7F0991C4,0xF054D8D5,0x7EF05860,0xEF8D5FB8,0x7ED5E5C6,
0xEEC60F31,0x7EBA3A39,0xEDFEE92B,0x7E9D55FC,0xED37EF91,0x7E7F3957,0xEC71244F,
0x7E5FE493,0xEBAA894F,0x7E3F57FF,0xEAE4207A,0x7E1D93EA,0xEA1DEBBB,0x7DFA98A8,
0xE957ECFB,0x7DD6668F,0xE8922622,0x7DB0FDF8,0xE7CC9917,0x7D8A5F40,0xE70747C4,
0x7D628AC6,0xE642340D,0x7D3980EC,0xE57D5FDA,0x7D0F4218,0xE4B8CD11,0x7CE3CEB2,
0xE3F47D96,0x7CB72724,0xE330734D,0x7C894BDE,0xE26CB01B,0x7C5A3D50,0xE1A935E2,
0x7C29FBEE,0xE0E60685,0x7BF88830,0xE02323E5,0x7BC5E290,0xDF608FE4,0x7B920B89,
0xDE9E4C60,0x7B5D039E,0xDDDC5B3B,0x7B26CB4F,0xDD1ABE51,0x7AEF6323,0xDC597781,
0x7AB6CBA4,0xDB9888A8,0x7A7D055B,0xDAD7F3A2,0x7A4210D8,0xDA17BA4A,0x7A05EEAD,
0xD957DE7A,0x79C89F6E,0xD898620C,0x798A23B1,0xD7D946D8,0x794A7C12,0xD71A8EB5,
0x7909A92D,0xD65C3B7B,0x78C7ABA2,0xD59E4EFF,0x78848414,0xD4E0CB15,0x78403329,
0xD423B191,0x77FAB989,0xD3670446,0x77B417DF,0xD2AAC504,0x776C4EDB,0xD1EEF59E,
0x77235F2D,0xD13397E2,0x76D94989,0xD078AD9E,0x768E0EA6,0xCFBE389F,0x7641AF3D,
0xCF043AB3,0x75F42C0B,0xCE4AB5A2,0x75A585CF,0xCD91AB39,0x7555BD4C,0xCCD91D3D,
0x7504D345,0xCC210D79,0x74B2C884,0xCB697DB0,0x745F9DD1,0xCAB26FA9,0x740B53FB,
0xC9FBE527,0x73B5EBD1,0xC945DFEC,0x735F6626,0xC89061BA,0x7307C3D0,0xC7DB6C50,
0x72AF05A7,0xC727016D,0x72552C85,0xC67322CE,0x71FA3949,0xC5BFD22E,0x719E2CD2,
0xC50D1149,0x71410805,0xC45AE1D7,0x70E2CBC6,0xC3A94590,0x708378FF,0xC2F83E2A,
0x7023109A,0xC247CD5A,0x6FC19385,0xC197F4D4,0x6F5F02B2,0xC0E8B648,0x6EFB5F12,
0xC03A1368,0x6E96A99D,0xBF8C0DE3,0x6E30E34A,0xBEDEA765,0x6DCA0D14,0xBE31E19B,
0x6D6227FA,0xBD85BE30,0x6CF934FC,0xBCDA3ECB,0x6C8F351C,0xBC2F6513,0x6C242960,
0xBB8532B0,0x6BB812D1,0xBADBA943,0x6B4AF279,0xBA32CA71,0x6ADCC964,0xB98A97D8,
0x6A6D98A4,0xB8E31319,0x69FD614A,0xB83C3DD1,0x698C246C,0xB796199B,0x6919E320,
0xB6F0A812,0x68A69E81,0xB64BEACD,0x683257AB,0xB5A7E362,0x67BD0FBD,0xB5049368,
0x6746C7D8,0xB461FC70,0x66CF8120,0xB3C0200C,0x66573CBB,0xB31EFFCC,0x65DDFBD3,
0xB27E9D3C,0x6563BF92,0xB1DEF9E9,0x64E88926,0xB140175B,0x646C59BF,0xB0A1F71D,
0x63EF3290,0xB0049AB3,0x637114CC,0xAF6803A2,0x62F201AC,0xAECC336C,0x6271FA69,
0xAE312B92,0x61F1003F,0xAD96ED92,0x616F146C,0xACFD7AE8,0x60EC3830,0xAC64D510,
0x60686CCF,0xABCCFD83,0x5FE3B38D,0xAB35F5B5,0x5F5E0DB3,0xAA9FBF1E,0x5ED77C8A,
0xAA0A5B2E,0x5E50015D,0xA975CB57,0x5DC79D7C,0xA8E21106,0x5D3E5237,0xA84F2DAA,
0x5CB420E0,0xA7BD22AC,0x5C290ACC,0xA72BF174,0x5B9D1154,0xA69B9B68,0x5B1035CF,
0xA60C21EE,0x5A82799A,0xA57D8666,0x59F3DE12,0xA4EFCA31,0x59646498,0xA462EEAC,
0x58D40E8C,0xA3D6F534,0x5842DD54,0xA34BDF20,0x57B0D256,0xA2C1ADC9,0x571DEEFA,
0xA2386284,0x568A34A9,0xA1AFFEA3,0x55F5A4D2,0xA1288376,0x556040E2,0xA0A1F24D,
0x54CA0A4B,0xA01C4C73,0x5433027D,0x9F979331,0x539B2AF0,0x9F13C7D0,0x53028518,
0x9E90EB94,0x5269126E,0x9E0EFFC1,0x51CED46E,0x9D8E0597,0x5133CC94,0x9D0DFE54,
0x5097FC5E,0x9C8EEB34,0x4FFB654D,0x9C10CD70,0x4F5E08E3,0x9B93A641,0x4EBFE8A5,
0x9B1776DA,0x4E210617,0x9A9C406E,0x4D8162C4,0x9A22042D,0x4CE10034,0x99A8C345,
0x4C3FDFF4,0x99307EE0,0x4B9E0390,0x98B93828,0x4AFB6C98,0x9842F043,0x4A581C9E,
0x97CDA855,0x49B41533,0x9759617F,0x490F57EE,0x96E61CE0,0x4869E665,0x9673DB94,
0x47C3C22F,0x96029EB6,0x471CECE7,0x9592675C,0x46756828,0x9523369C,0x45CD358F,
0x94B50D87,0x452456BD,0x9447ED2F,0x447ACD50,0x93DBD6A0,0x43D09AED,0x9370CAE4,
0x4325C135,0x9306CB04,0x427A41D0,0x929DD806,0x41CE1E65,0x9235F2EC,0x4121589B,
0x91CF1CB6,0x4073F21D,0x91695663,0x3FC5EC98,0x9104A0EE,0x3F1749B8,0x90A0FD4E,
0x3E680B2C,0x903E6C7B,0x3DB832A6,0x8FDCEF66,0x3D07C1D6,0x8F7C8701,0x3C56BA70,
0x8F1D343A,0x3BA51E29,0x8EBEF7FB,0x3AF2EEB7,0x8E61D32E,0x3A402DD2,0x8E05C6B7,
0x398CDD32,0x8DAAD37B,0x38D8FE93,0x8D50FA59,0x382493B0,0x8CF83C30,0x376F9E46,
0x8CA099DA,0x36BA2014,0x8C4A142F,0x36041AD9,0x8BF4AC05,0x354D9057,0x8BA0622F,
0x34968250,0x8B4D377C,0x33DEF287,0x8AFB2CBB,0x3326E2C3,0x8AAA42B4,0x326E54C7,
0x8A5A7A31,0x31B54A5E,0x8A0BD3F5,0x30FBC54D,0x89BE50C3,0x3041C761,0x8971F15A,
0x2F875262,0x8926B677,0x2ECC681E,0x88DCA0D3,0x2E110A62,0x8893B125,0x2D553AFC,
0x884BE821,0x2C98FBBA,0x88054677,0x2BDC4E6F,0x87BFCCD7,0x2B1F34EB,0x877B7BEC,
0x2A61B101,0x8738545E,0x29A3C485,0x86F656D3,0x28E5714B,0x86B583EE,0x2826B928,
0x8675DC4F,0x27679DF4,0x86376092,0x26A82186,0x85FA1153,0x25E845B6,0x85BDEF28,
0x25280C5E,0x8582FAA5,0x24677758,0x8549345C,0x23A6887F,0x85109CDD,0x22E541AF,
0x84D934B1,0x2223A4C5,0x84A2FC62,0x2161B3A0,0x846DF477,0x209F701C,0x843A1D70,
0x1FDCDC1B,0x840777D0,0x1F19F97B,0x83D60412,0x1E56CA1E,0x83A5C2B0,0x1D934FE5,
0x8376B422,0x1CCF8CB3,0x8348D8DC,0x1C0B826A,0x831C314E,0x1B4732EF,0x82F0BDE8,
0x1A82A026,0x82C67F14,0x19BDCBF3,0x829D753A,0x18F8B83C,0x8275A0C0,0x183366E9,
0x824F0208,0x176DD9DE,0x82299971,0x16A81305,0x82056758,0x15E21445,0x81E26C16,
0x151BDF86,0x81C0A801,0x145576B1,0x81A01B6D,0x138EDBB1,0x8180C6A9,0x12C8106F,
0x8162AA04,0x120116D5,0x8145C5C7,0x1139F0CF,0x812A1A3A,0x1072A048,0x810FA7A0,
0x0FAB272B,0x80F66E3C,0x0EE38766,0x80DE6E4C,0x0E1BC2E4,0x80C7A80A,0x0D53DB92,
0x80B21BAF,0x0C8BD35E,0x809DC971,0x0BC3AC35,0x808AB180,0x0AFB6805,0x8078D40D,
0x0A3308BD,0x80683143,0x096A9049,0x8058C94C,0x08A2009A,0x804A9C4D,0x07D95B9E,
0x803DAA6A,0x0710A345,0x8031F3C2,0x0647D97C,0x80277872,0x057F0035,0x801E3895,
0x04B6195D,0x80163440,0x03ED26E6,0x800F6B88,0x03242ABF,0x8009DE7E,0x025B26D7,
0x80058D2F,0x01921D20,0x800277A6,0x00C90F88,0x80009DEA,0x7FFFFFFF,0x00000000,
0x7FF62182,0xFCDBD541,0x7FD8878E,0xF9B82684,0x7FA736B4,0xF6956FB7,0x7F62368F,
0xF3742CA2,0x7F0991C4,0xF054D8D5,0x7E9D55FC,0xED37EF91,0x7E1D93EA,0xEA1DEBBB,
0x7D8A5F40,0xE70747C4,0x7CE3CEB2,0xE3F47D96,0x7C29FBEE,0xE0E60685,0x7B5D039E,
0xDDDC5B3B,0x7A7D055B,0xDAD7F3A2,0x798A23B1,0xD7D946D8,0x78848414,0xD4E0CB15,
0x776C4EDB,0xD1EEF59E,0x7641AF3D,0xCF043AB3,0x7504D345,0xCC210D79,0x73B5EBD1,
0xC945DFEC,0x72552C85,0xC67322CE,0x70E2CBC6,0xC3A94590,0x6F5F02B2,0xC0E8B648,
0x6DCA0D14,0xBE31E19B,0x6C242960,0xBB8532B0,0x6A6D98A4,0xB8E31319,0x68A69E81,
0xB64BEACD,0x66CF8120,0xB3C0200C,0x64E88926,0xB140175B,0x62F201AC,0xAECC336C,
0x60EC3830,0xAC64D510,0x5ED77C8A,0xAA0A5B2E,0x5CB420E0,0xA7BD22AC,0x5A82799A,
0xA57D8666,0x5842DD54,0xA34BDF20,0x55F5A4D2,0xA1288376,0x539B2AF0,0x9F13C7D0,
0x5133CC94,0x9D0DFE54,0x4EBFE8A5,0x9B1776DA,0x4C3FDFF4,0x99307EE0,0x49B41533,
0x9759617F,0x471CECE7,0x9592675C,0x447ACD50,0x93DBD6A0,0x41CE1E65,0x9235F2EC,
0x3F1749B8,0x90A0FD4E,0x3C56BA70,0x8F1D343A,0x398CDD32,0x8DAAD37B,0x36BA2014,
0x8C4A142F,0x33DEF287,0x8AFB2CBB,0x30FBC54D,0x89BE50C3,0x2E110A62,0x8893B125,
0x2B1F34EB,0x877B7BEC,0x2826B928,0x8675DC4F,0x25280C5E,0x8582FAA5,0x2223A4C5,
0x84A2FC62,0x1F19F97B,0x83D60412,0x1C0B826A,0x831C314E,0x18F8B83C,0x8275A0C0,
0x15E21445,0x81E26C16,0x12C8106F,0x8162AA04,0x0FAB272B,0x80F66E3C,0x0C8BD35E,
0x809DC971,0x096A9049,0x8058C94C,0x0647D97C,0x80277872,0x03242ABF,0x8009DE7E,
0x7FFFFFFF,0x00000000,0x7F62368F,0xF3742CA2,0x7D8A5F40,0xE70747C4,0x7A7D055B,
0xDAD7F3A2,0x7641AF3D,0xCF043AB3,0x70E2CBC6,0xC3A94590,0x6A6D98A4,0xB8E31319,
0x62F201AC,0xAECC336C,0x5A82799A,0xA57D8666,0x5133CC94,0x9D0DFE54,0x471CECE7,
0x9592675C,0x3C56BA70,0x8F1D343A,0x30FBC54D,0x89BE50C3,0x25280C5E,0x8582FAA5,
0x18F8B83C,0x8275A0C0,0x0C8BD35E,0x809DC971,0x7FFFFFFF,0x00000000,0x7641AF3D,
0xCF043AB3,0x5A82799A,0xA57D8666,0x30FBC54D,0x89BE50C3,};

q31_t rearranged_twiddle_stride2_4096_q31[2728]={
0x7FFFFFFF,0x00000000,0x7FFFD886,0xFF9B781D,0x7FFF6216,0xFF36F078,0x7FFE9CB2,
0xFED2694F,0x7FFD885A,0xFE6DE2E0,0x7FFC250F,0xFE095D69,0x7FFA72D1,0xFDA4D929,
0x7FF871A2,0xFD40565C,0x7FF62182,0xFCDBD541,0x7FF38274,0xFC775616,0x7FF09478,
0xFC12D91A,0x7FED5791,0xFBAE5E89,0x7FE9CBC0,0xFB49E6A3,0x7FE5F108,0xFAE571A4,
0x7FE1C76B,0xFA80FFCB,0x7FDD4EEC,0xFA1C9157,0x7FD8878E,0xF9B82684,0x7FD37153,
0xF953BF91,0x7FCE0C3E,0xF8EF5CBB,0x7FC85854,0xF88AFE42,0x7FC25596,0xF826A462,
0x7FBC040A,0xF7C24F59,0x7FB563B3,0xF75DFF66,0x7FAE7495,0xF6F9B4C6,0x7FA736B4,
0xF6956FB7,0x7F9FAA15,0xF6313077,0x7F97CEBD,0xF5CCF743,0x7F8FA4B0,0xF568C45B,
0x7F872BF3,0xF50497FB,0x7F7E648C,0xF4A07261,0x7F754E80,0xF43C53CB,0x7F6BE9D4,
0xF3D83C77,0x7F62368F,0xF3742CA2,0x7F5834B7,0xF310248A,0x7F4DE451,0xF2AC246E,
0x7F434563,0xF2482C8A,0x7F3857F6,0xF1E43D1C,0x7F2D1C0E,0xF1805662,0x7F2191B4,
0xF11C789A,0x7F15B8EE,0xF0B8A401,0x7F0991C4,0xF054D8D5,0x7EFD1C3C,0xEFF11753,
0x7EF05860,0xEF8D5FB8,0x7EE34636,0xEF29B243,0x7ED5E5C6,0xEEC60F31,0x7EC8371A,
0xEE6276BF,0x7EBA3A39,0xEDFEE92B,0x7EABEF2C,0xED9B66B2,0x7E9D55FC,0xED37EF91,
0x7E8E6EB2,0xECD48407,0x7E7F3957,0xEC71244F,0x7E6FB5F4,0xEC0DD0A8,0x7E5FE493,
0xEBAA894F,0x7E4FC53E,0xEB474E81,0x7E3F57FF,0xEAE4207A,0x7E2E9CDF,0xEA80FF7A,
0x7E1D93EA,0xEA1DEBBB,0x7E0C3D29,0xE9BAE57D,0x7DFA98A8,0xE957ECFB,0x7DE8A670,
0xE8F50273,0x7DD6668F,0xE8922622,0x7DC3D90D,0xE82F5844,0x7DB0FDF8,0xE7CC9917,
0x7D9DD55A,0xE769E8D8,0x7D8A5F40,0xE70747C4,0x7D769BB5,0xE6A4B616,0x7D628AC6,
0xE642340D,0x7D4E2C7F,0xE5DFC1E5,0x7D3980EC,0xE57D5FDA,0x7D24881B,0xE51B0E2A,
0x7D0F4218,0xE4B8CD11,0x7CF9AEF0,0xE4569CCB,0x7CE3CEB2,0xE3F47D96,0x7CCDA169,
0xE3926FAD,0x7CB72724,0xE330734D,0x7CA05FF1,0xE2CE88B3,0x7C894BDE,0xE26CB01B,
0x7C71EAF9,0xE20AE9C1,0x7C5A3D50,0xE1A935E2,0x7C4242F2,0xE14794BA,0x7C29FBEE,
0xE0E60685,0x7C116853,0xE0848B7F,0x7BF88830,0xE02323E5,0x7BDF5B94,0xDFC1CFF3,
0x7BC5E290,0xDF608FE4,0x7BAC1D31,0xDEFF63F4,0x7B920B89,0xDE9E4C60,0x7B77ADA8,
0xDE3D4964,0x7B5D039E,0xDDDC5B3B,0x7B420D7A,0xDD7B8220,0x7B26CB4F,0xDD1ABE51,
0x7B0B3D2C,0xDCBA1008,0x7AEF6323,0xDC597781,0x7AD33D45,0xDBF8F4F8,0x7AB6CBA4,
0xDB9888A8,0x7A9A0E50,0xDB3832CD,0x7A7D055B,0xDAD7F3A2,0x7A5FB0D8,0xDA77CB63,
0x7A4210D8,0xDA17BA4A,0x7A24256F,0xD9B7C094,0x7A05EEAD,0xD957DE7A,0x79E76CA7,
0xD8F81439,0x79C89F6E,0xD898620C,0x79A98715,0xD838C82D,0x798A23B1,0xD7D946D8,
0x796A7554,0xD779DE47,0x794A7C12,0xD71A8EB5,0x792A37FE,0xD6BB585E,0x7909A92D,
0xD65C3B7B,0x78E8CFB2,0xD5FD3848,0x78C7ABA2,0xD59E4EFF,0x78A63D11,0xD53F7FDA,
0x78848414,0xD4E0CB15,0x786280BF,0xD48230E9,0x78403329,0xD423B191,0x781D9B65,
0xD3C54D47,0x77FAB989,0xD3670446,0x77D78DAA,0xD308D6C7,0x77B417DF,0xD2AAC504,
0x7790583E,0xD24CCF39,0x776C4EDB,0xD1EEF59E,0x7747FBCE,0xD191386E,0x77235F2D,
0xD13397E2,0x76FE790E,0xD0D61434,0x76D94989,0xD078AD9E,0x76B3D0B4,0xD01B6459,
0x768E0EA6,0xCFBE389F,0x76680376,0xCF612AAA,0x7641AF3D,0xCF043AB3,0x761B1211,
0xCEA768F2,0x75F42C0B,0xCE4AB5A2,0x75CCFD42,0xCDEE20FC,0x75A585CF,0xCD91AB39,
0x757DC5CA,0xCD355491,0x7555BD4C,0xCCD91D3D,0x752D6C6C,0xCC7D0578,0x7504D345,
0xCC210D79,0x74DBF1EF,0xCBC53579,0x74B2C884,0xCB697DB0,0x7489571C,0xCB0DE658,
0x745F9DD1,0xCAB26FA9,0x74359CBD,0xCA5719DB,0x740B53FB,0xC9FBE527,0x73E0C3A3,
0xC9A0D1C5,0x73B5EBD1,0xC945DFEC,0x738ACC9E,0xC8EB0FD6,0x735F6626,0xC89061BA,
0x7333B883,0xC835D5D0,0x7307C3D0,0xC7DB6C50,0x72DB8828,0xC7812572,0x72AF05A7,
0xC727016D,0x72823C67,0xC6CD0079,0x72552C85,0xC67322CE,0x7227D61C,0xC61968A2,
0x71FA3949,0xC5BFD22E,0x71CC5626,0xC5665FA9,0x719E2CD2,0xC50D1149,0x716FBD68,
0xC4B3E746,0x71410805,0xC45AE1D7,0x71120CC5,0xC4020133,0x70E2CBC6,0xC3A94590,
0x70B34525,0xC350AF26,0x708378FF,0xC2F83E2A,0x70536771,0xC29FF2D4,0x7023109A,
0xC247CD5A,0x6FF27497,0xC1EFCDF3,0x6FC19385,0xC197F4D4,0x6F906D84,0xC1404233,
0x6F5F02B2,0xC0E8B648,0x6F2D532C,0xC0915148,0x6EFB5F12,0xC03A1368,0x6EC92683,
0xBFE2FCDF,0x6E96A99D,0xBF8C0DE3,0x6E63E87F,0xBF3546A8,0x6E30E34A,0xBEDEA765,
0x6DFD9A1C,0xBE88304F,0x6DCA0D14,0xBE31E19B,0x6D963C54,0xBDDBBB7F,0x6D6227FA,
0xBD85BE30,0x6D2DD027,0xBD2FE9E2,0x6CF934FC,0xBCDA3ECB,0x6CC45698,0xBC84BD1F,
0x6C8F351C,0xBC2F6513,0x6C59D0A9,0xBBDA36DD,0x6C242960,0xBB8532B0,0x6BEE3F62,
0xBB3058C0,0x6BB812D1,0xBADBA943,0x6B81A3CD,0xBA87246D,0x6B4AF279,0xBA32CA71,
0x6B13FEF5,0xB9DE9B83,0x6ADCC964,0xB98A97D8,0x6AA551E9,0xB936BFA4,0x6A6D98A4,
0xB8E31319,0x6A359DB9,0xB88F926D,0x69FD614A,0xB83C3DD1,0x69C4E37A,0xB7E9157A,
0x698C246C,0xB796199B,0x69532442,0xB7434A67,0x6919E320,0xB6F0A812,0x68E06129,
0xB69E32CD,0x68A69E81,0xB64BEACD,0x686C9B4B,0xB5F9D043,0x683257AB,0xB5A7E362,
0x67F7D3C5,0xB556245E,0x67BD0FBD,0xB5049368,0x67820BB7,0xB4B330B3,0x6746C7D8,
0xB461FC70,0x670B4444,0xB410F6D3,0x66CF8120,0xB3C0200C,0x66937E91,0xB36F784F,
0x66573CBB,0xB31EFFCC,0x661ABBC5,0xB2CEB6B5,0x65DDFBD3,0xB27E9D3C,0x65A0FD0B,
0xB22EB392,0x6563BF92,0xB1DEF9E9,0x6526438F,0xB18F7071,0x64E88926,0xB140175B,
0x64AA907F,0xB0F0EEDA,0x646C59BF,0xB0A1F71D,0x642DE50D,0xB0533055,0x63EF3290,
0xB0049AB3,0x63B0426D,0xAFB63667,0x637114CC,0xAF6803A2,0x6331A9D4,0xAF1A0293,
0x62F201AC,0xAECC336C,0x62B21C7B,0xAE7E965B,0x6271FA69,0xAE312B92,0x62319B9D,
0xADE3F33E,0x61F1003F,0xAD96ED92,0x61B02876,0xAD4A1ABA,0x616F146C,0xACFD7AE8,
0x612DC447,0xACB10E4B,0x60EC3830,0xAC64D510,0x60AA7050,0xAC18CF69,0x60686CCF,
0xABCCFD83,0x60262DD6,0xAB815F8D,0x5FE3B38D,0xAB35F5B5,0x5FA0FE1F,0xAAEAC02C,
0x5F5E0DB3,0xAA9FBF1E,0x5F1AE274,0xAA54F2BA,0x5ED77C8A,0xAA0A5B2E,0x5E93DC1F,
0xA9BFF8A8,0x5E50015D,0xA975CB57,0x5E0BEC6E,0xA92BD367,0x5DC79D7C,0xA8E21106,
0x5D8314B1,0xA8988463,0x5D3E5237,0xA84F2DAA,0x5CF95638,0xA8060D08,0x5CB420E0,
0xA7BD22AC,0x5C6EB258,0xA7746EC0,0x5C290ACC,0xA72BF174,0x5BE32A67,0xA6E3AAF2,
0x5B9D1154,0xA69B9B68,0x5B56BFBD,0xA653C303,0x5B1035CF,0xA60C21EE,0x5AC973B5,
0xA5C4B855,0x5A82799A,0xA57D8666,0x5A3B47AB,0xA5368C4B,0x59F3DE12,0xA4EFCA31,
0x59AC3CFD,0xA4A94043,0x59646498,0xA462EEAC,0x591C550E,0xA41CD599,0x58D40E8C,
0xA3D6F534,0x588B9140,0xA3914DA8,0x5842DD54,0xA34BDF20,0x57F9F2F8,0xA306A9C8,
0x57B0D256,0xA2C1ADC9,0x57677B9D,0xA27CEB4F,0x571DEEFA,0xA2386284,0x56D42C99,
0xA1F41392,0x568A34A9,0xA1AFFEA3,0x56400758,0xA16C23E1,0x55F5A4D2,0xA1288376,
0x55AB0D46,0xA0E51D8C,0x556040E2,0xA0A1F24D,0x55153FD4,0xA05F01E1,0x54CA0A4B,
0xA01C4C73,0x547EA073,0x9FD9D22A,0x5433027D,0x9F979331,0x53E73097,0x9F558FB0,
0x539B2AF0,0x9F13C7D0,0x534EF1B5,0x9ED23BB9,0x53028518,0x9E90EB94,0x52B5E546,
0x9E4FD78A,0x5269126E,0x9E0EFFC1,0x521C0CC2,0x9DCE6463,0x51CED46E,0x9D8E0597,
0x518169A5,0x9D4DE385,0x5133CC94,0x9D0DFE54,0x50E5FD6D,0x9CCE562C,0x5097FC5E,
0x9C8EEB34,0x5049C999,0x9C4FBD93,0x4FFB654D,0x9C10CD70,0x4FACCFAB,0x9BD21AF3,
0x4F5E08E3,0x9B93A641,0x4F0F1126,0x9B556F81,0x4EBFE8A5,0x9B1776DA,0x4E708F8F,
0x9AD9BC71,0x4E210617,0x9A9C406E,0x4DD14C6E,0x9A5F02F5,0x4D8162C4,0x9A22042D,
0x4D31494B,0x99E5443B,0x4CE10034,0x99A8C345,0x4C9087B1,0x996C816F,0x4C3FDFF4,
0x99307EE0,0x4BEF092D,0x98F4BBBC,0x4B9E0390,0x98B93828,0x4B4CCF4D,0x987DF449,
0x4AFB6C98,0x9842F043,0x4AA9DBA2,0x98082C3B,0x4A581C9E,0x97CDA855,0x4A062FBD,
0x979364B5,0x49B41533,0x9759617F,0x4961CD33,0x971F9ED7,0x490F57EE,0x96E61CE0,
0x48BCB599,0x96ACDBBE,0x4869E665,0x9673DB94,0x4816EA86,0x963B1C86,0x47C3C22F,
0x96029EB6,0x47706D93,0x95CA6247,0x471CECE7,0x9592675C,0x46C9405C,0x955AAE17,
0x46756828,0x9523369C,0x4621647D,0x94EC010B,0x45CD358F,0x94B50D87,0x4578DB93,
0x947E5C33,0x452456BD,0x9447ED2F,0x44CFA740,0x9411C09E,0x447ACD50,0x93DBD6A0,
0x4425C923,0x93A62F57,0x43D09AED,0x9370CAE4,0x437B42E1,0x933BA968,0x4325C135,
0x9306CB04,0x42D0161E,0x92D22FD9,0x427A41D0,0x929DD806,0x42244481,0x9269C3AC,
0x41CE1E65,0x9235F2EC,0x4177CFB1,0x920265E4,0x4121589B,0x91CF1CB6,0x40CAB958,
0x919C1781,0x4073F21D,0x91695663,0x401D0321,0x9136D97D,0x3FC5EC98,0x9104A0EE,
0x3F6EAEB8,0x90D2ACD4,0x3F1749B8,0x90A0FD4E,0x3EBFBDCD,0x906F927C,0x3E680B2C,
0x903E6C7B,0x3E10320D,0x900D8B69,0x3DB832A6,0x8FDCEF66,0x3D600D2C,0x8FAC988F,
0x3D07C1D6,0x8F7C8701,0x3CAF50DA,0x8F4CBADB,0x3C56BA70,0x8F1D343A,0x3BFDFECD,
0x8EEDF33B,0x3BA51E29,0x8EBEF7FB,0x3B4C18BA,0x8E904298,0x3AF2EEB7,0x8E61D32E,
0x3A99A057,0x8E33A9DA,0x3A402DD2,0x8E05C6B7,0x39E6975E,0x8DD829E4,0x398CDD32,
0x8DAAD37B,0x3932FF87,0x8D7DC399,0x38D8FE93,0x8D50FA59,0x387EDA8E,0x8D2477D8,
0x382493B0,0x8CF83C30,0x37CA2A30,0x8CCC477D,0x376F9E46,0x8CA099DA,0x3714F02A,
0x8C753362,0x36BA2014,0x8C4A142F,0x365F2E3B,0x8C1F3C5D,0x36041AD9,0x8BF4AC05,
0x35A8E625,0x8BCA6343,0x354D9057,0x8BA0622F,0x34F219A8,0x8B76A8E4,0x34968250,
0x8B4D377C,0x343ACA87,0x8B240E11,0x33DEF287,0x8AFB2CBB,0x3382FA88,0x8AD29394,
0x3326E2C3,0x8AAA42B4,0x32CAAB6F,0x8A823A36,0x326E54C7,0x8A5A7A31,0x3211DF04,
0x8A3302BE,0x31B54A5E,0x8A0BD3F5,0x3158970E,0x89E4EDEF,0x30FBC54D,0x89BE50C3,
0x309ED556,0x8997FC8A,0x3041C761,0x8971F15A,0x2FE49BA7,0x894C2F4C,0x2F875262,
0x8926B677,0x2F29EBCC,0x890186F2,0x2ECC681E,0x88DCA0D3,0x2E6EC792,0x88B80432,
0x2E110A62,0x8893B125,0x2DB330C7,0x886FA7C2,0x2D553AFC,0x884BE821,0x2CF72939,
0x88287256,0x2C98FBBA,0x88054677,0x2C3AB2B9,0x87E2649B,0x2BDC4E6F,0x87BFCCD7,
0x2B7DCF17,0x879D7F41,0x2B1F34EB,0x877B7BEC,0x2AC08026,0x8759C2EF,0x2A61B101,
0x8738545E,0x2A02C7B8,0x8717304E,0x29A3C485,0x86F656D3,0x2944A7A2,0x86D5C802,
0x28E5714B,0x86B583EE,0x288621B9,0x86958AAC,0x2826B928,0x8675DC4F,0x27C737D3,
0x865678EB,0x27679DF4,0x86376092,0x2707EBC7,0x86189359,0x26A82186,0x85FA1153,
0x26483F6C,0x85DBDA91,0x25E845B6,0x85BDEF28,0x2588349D,0x85A04F28,0x25280C5E,
0x8582FAA5,0x24C7CD33,0x8565F1B0,0x24677758,0x8549345C,0x24070B08,0x852CC2BB,
0x23A6887F,0x85109CDD,0x2345EFF8,0x84F4C2D4,0x22E541AF,0x84D934B1,0x22847DE0,
0x84BDF286,0x2223A4C5,0x84A2FC62,0x21C2B69C,0x84885258,0x2161B3A0,0x846DF477,
0x21009C0C,0x8453E2CF,0x209F701C,0x843A1D70,0x203E300D,0x8420A46C,0x1FDCDC1B,
0x840777D0,0x1F7B7481,0x83EE97AD,0x1F19F97B,0x83D60412,0x1EB86B46,0x83BDBD0E,
0x1E56CA1E,0x83A5C2B0,0x1DF5163F,0x838E1507,0x1D934FE5,0x8376B422,0x1D31774D,
0x835FA00F,0x1CCF8CB3,0x8348D8DC,0x1C6D9053,0x83325E97,0x1C0B826A,0x831C314E,
0x1BA96335,0x83065110,0x1B4732EF,0x82F0BDE8,0x1AE4F1D6,0x82DB77E5,0x1A82A026,
0x82C67F14,0x1A203E1B,0x82B1D381,0x19BDCBF3,0x829D753A,0x195B49EA,0x8289644B,
0x18F8B83C,0x8275A0C0,0x18961728,0x82622AA6,0x183366E9,0x824F0208,0x17D0A7BC,
0x823C26F3,0x176DD9DE,0x82299971,0x170AFD8D,0x82175990,0x16A81305,0x82056758,
0x16451A83,0x81F3C2D7,0x15E21445,0x81E26C16,0x157F0086,0x81D16321,0x151BDF86,
0x81C0A801,0x14B8B17F,0x81B03AC2,0x145576B1,0x81A01B6D,0x13F22F58,0x81904A0C,
0x138EDBB1,0x8180C6A9,0x132B7BF9,0x8171914E,0x12C8106F,0x8162AA04,0x1264994E,
0x815410D4,0x120116D5,0x8145C5C7,0x119D8941,0x8137C8E6,0x1139F0CF,0x812A1A3A,
0x10D64DBD,0x811CB9CA,0x1072A048,0x810FA7A0,0x100EE8AD,0x8102E3C4,0x0FAB272B,
0x80F66E3C,0x0F475BFF,0x80EA4712,0x0EE38766,0x80DE6E4C,0x0E7FA99E,0x80D2E3F2,
0x0E1BC2E4,0x80C7A80A,0x0DB7D376,0x80BCBA9D,0x0D53DB92,0x80B21BAF,0x0CEFDB76,
0x80A7CB49,0x0C8BD35E,0x809DC971,0x0C27C389,0x8094162C,0x0BC3AC35,0x808AB180,
0x0B5F8D9F,0x80819B74,0x0AFB6805,0x8078D40D,0x0A973BA5,0x80705B50,0x0A3308BD,
0x80683143,0x09CECF89,0x806055EB,0x096A9049,0x8058C94C,0x09064B3A,0x80518B6B,
0x08A2009A,0x804A9C4D,0x083DB0A7,0x8043FBF6,0x07D95B9E,0x803DAA6A,0x077501BE,
0x8037A7AC,0x0710A345,0x8031F3C2,0x06AC406F,0x802C8EAD,0x0647D97C,0x80277872,
0x05E36EA9,0x8022B114,0x057F0035,0x801E3895,0x051A8E5C,0x801A0EF8,0x04B6195D,
0x80163440,0x0451A177,0x8012A86F,0x03ED26E6,0x800F6B88,0x0388A9EA,0x800C7D8C,
0x03242ABF,0x8009DE7E,0x02BFA9A4,0x80078E5E,0x025B26D7,0x80058D2F,0x01F6A297,
0x8003DAF1,0x01921D20,0x800277A6,0x012D96B1,0x8001634E,0x00C90F88,0x80009DEA,
0x006487E3,0x8000277A,0x00000000,0x80000000,0xFF9B781D,0x8000277A,0xFF36F078,
0x80009DEA,0xFED2694F,0x8001634E,0xFE6DE2E0,0x800277A6,0xFE095D69,0x8003DAF1,
0xFDA4D929,0x80058D2F,0xFD40565C,0x80078E5E,0xFCDBD541,0x8009DE7E,0xFC775616,
0x800C7D8C,0xFC12D91A,0x800F6B88,0xFBAE5E89,0x8012A86F,0xFB49E6A3,0x80163440,
0xFAE571A4,0x801A0EF8,0xFA80FFCB,0x801E3895,0xFA1C9157,0x8022B114,0xF9B82684,
0x80277872,0xF953BF91,0x802C8EAD,0xF8EF5CBB,0x8031F3C2,0xF88AFE42,0x8037A7AC,
0xF826A462,0x803DAA6A,0xF7C24F59,0x8043FBF6,0xF75DFF66,0x804A9C4D,0xF6F9B4C6,
0x80518B6B,0xF6956FB7,0x8058C94C,0xF6313077,0x806055EB,0xF5CCF743,0x80683143,
0xF568C45B,0x80705B50,0xF50497FB,0x8078D40D,0xF4A07261,0x80819B74,0xF43C53CB,
0x808AB180,0xF3D83C77,0x8094162C,0xF3742CA2,0x809DC971,0xF310248A,0x80A7CB49,
0xF2AC246E,0x80B21BAF,0xF2482C8A,0x80BCBA9D,0xF1E43D1C,0x80C7A80A,0xF1805662,
0x80D2E3F2,0xF11C789A,0x80DE6E4C,0xF0B8A401,0x80EA4712,0xF054D8D5,0x80F66E3C,
0xEFF11753,0x8102E3C4,0xEF8D5FB8,0x810FA7A0,0xEF29B243,0x811CB9CA,0xEEC60F31,
0x812A1A3A,0xEE6276BF,0x8137C8E6,0xEDFEE92B,0x8145C5C7,0xED9B66B2,0x815410D4,
0xED37EF91,0x8162AA04,0xECD48407,0x8171914E,0xEC71244F,0x8180C6A9,0xEC0DD0A8,
0x81904A0C,0xEBAA894F,0x81A01B6D,0xEB474E81,0x81B03AC2,0xEAE4207A,0x81C0A801,
0xEA80FF7A,0x81D16321,0xEA1DEBBB,0x81E26C16,0xE9BAE57D,0x81F3C2D7,0xE957ECFB,
0x82056758,0xE8F50273,0x82175990,0xE8922622,0x82299971,0xE82F5844,0x823C26F3,
0xE7CC9917,0x824F0208,0xE769E8D8,0x82622AA6,0xE70747C4,0x8275A0C0,0xE6A4B616,
0x8289644B,0xE642340D,0x829D753A,0xE5DFC1E5,0x82B1D381,0xE57D5FDA,0x82C67F14,
0xE51B0E2A,0x82DB77E5,0xE4B8CD11,0x82F0BDE8,0xE4569CCB,0x83065110,0xE3F47D96,
0x831C314E,0xE3926FAD,0x83325E97,0xE330734D,0x8348D8DC,0xE2CE88B3,0x835FA00F,
0xE26CB01B,0x8376B422,0xE20AE9C1,0x838E1507,0xE1A935E2,0x83A5C2B0,0xE14794BA,
0x83BDBD0E,0xE0E60685,0x83D60412,0xE0848B7F,0x83EE97AD,0xE02323E5,0x840777D0,
0xDFC1CFF3,0x8420A46C,0xDF608FE4,0x843A1D70,0xDEFF63F4,0x8453E2CF,0xDE9E4C60,
0x846DF477,0xDE3D4964,0x84885258,0xDDDC5B3B,0x84A2FC62,0xDD7B8220,0x84BDF286,
0xDD1ABE51,0x84D934B1,0xDCBA1008,0x84F4C2D4,0xDC597781,0x85109CDD,0xDBF8F4F8,
0x852CC2BB,0xDB9888A8,0x8549345C,0xDB3832CD,0x8565F1B0,0xDAD7F3A2,0x8582FAA5,
0xDA77CB63,0x85A04F28,0xDA17BA4A,0x85BDEF28,0xD9B7C094,0x85DBDA91,0xD957DE7A,
0x85FA1153,0xD8F81439,0x86189359,0xD898620C,0x86376092,0xD838C82D,0x865678EB,
0xD7D946D8,0x8675DC4F,0xD779DE47,0x86958AAC,0xD71A8EB5,0x86B583EE,0xD6BB585E,
0x86D5C802,0xD65C3B7B,0x86F656D3,0xD5FD3848,0x8717304E,0xD59E4EFF,0x8738545E,
0xD53F7FDA,0x8759C2EF,0xD4E0CB15,0x877B7BEC,0xD48230E9,0x879D7F41,0xD423B191,
0x87BFCCD7,0xD3C54D47,0x87E2649B,0xD3670446,0x88054677,0xD308D6C7,0x88287256,
0xD2AAC504,0x884BE821,0xD24CCF39,0x886FA7C2,0xD1EEF59E,0x8893B125,0xD191386E,
0x88B80432,0xD13397E2,0x88DCA0D3,0xD0D61434,0x890186F2,0xD078AD9E,0x8926B677,
0xD01B6459,0x894C2F4C,0xCFBE389F,0x8971F15A,0xCF612AAA,0x8997FC8A,0xCF043AB3,
0x89BE50C3,0xCEA768F2,0x89E4EDEF,0xCE4AB5A2,0x8A0BD3F5,0xCDEE20FC,0x8A3302BE,
0xCD91AB39,0x8A5A7A31,0xCD355491,0x8A823A36,0xCCD91D3D,0x8AAA42B4,0xCC7D0578,
0x8AD29394,0xCC210D79,0x8AFB2CBB,0xCBC53579,0x8B240E11,0xCB697DB0,0x8B4D377C,
0xCB0DE658,0x8B76A8E4,0xCAB26FA9,0x8BA0622F,0xCA5719DB,0x8BCA6343,0xC9FBE527,
0x8BF4AC05,0xC9A0D1C5,0x8C1F3C5D,0xC945DFEC,0x8C4A142F,0xC8EB0FD6,0x8C753362,
0xC89061BA,0x8CA099DA,0xC835D5D0,0x8CCC477D,0xC7DB6C50,0x8CF83C30,0xC7812572,
0x8D2477D8,0xC727016D,0x8D50FA59,0xC6CD0079,0x8D7DC399,0xC67322CE,0x8DAAD37B,
0xC61968A2,0x8DD829E4,0xC5BFD22E,0x8E05C6B7,0xC5665FA9,0x8E33A9DA,0xC50D1149,
0x8E61D32E,0xC4B3E746,0x8E904298,0xC45AE1D7,0x8EBEF7FB,0xC4020133,0x8EEDF33B,
0xC3A94590,0x8F1D343A,0xC350AF26,0x8F4CBADB,0xC2F83E2A,0x8F7C8701,0xC29FF2D4,
0x8FAC988F,0xC247CD5A,0x8FDCEF66,0xC1EFCDF3,0x900D8B69,0xC197F4D4,0x903E6C7B,
0xC1404233,0x906F927C,0xC0E8B648,0x90A0FD4E,0xC0915148,0x90D2ACD4,0xC03A1368,
0x9104A0EE,0xBFE2FCDF,0x9136D97D,0xBF8C0DE3,0x91695663,0xBF3546A8,0x919C1781,
0xBEDEA765,0x91CF1CB6,0xBE88304F,0x920265E4,0xBE31E19B,0x9235F2EC,0xBDDBBB7F,
0x9269C3AC,0xBD85BE30,0x929DD806,0xBD2FE9E2,0x92D22FD9,0xBCDA3ECB,0x9306CB04,
0xBC84BD1F,0x933BA968,0xBC2F6513,0x9370CAE4,0xBBDA36DD,0x93A62F57,0xBB8532B0,
0x93DBD6A0,0xBB3058C0,0x9411C09E,0xBADBA943,0x9447ED2F,0xBA87246D,0x947E5C33,
0xBA32CA71,0x94B50D87,0xB9DE9B83,0x94EC010B,0xB98A97D8,0x9523369C,0xB936BFA4,
0x955AAE17,0xB8E31319,0x9592675C,0xB88F926D,0x95CA6247,0xB83C3DD1,0x96029EB6,
0xB7E9157A,0x963B1C86,0xB796199B,0x9673DB94,0xB7434A67,0x96ACDBBE,0xB6F0A812,
0x96E61CE0,0xB69E32CD,0x971F9ED7,0xB64BEACD,0x9759617F,0xB5F9D043,0x979364B5,
0xB5A7E362,0x97CDA855,0xB556245E,0x98082C3B,0xB5049368,0x9842F043,0xB4B330B3,
0x987DF449,0xB461FC70,0x98B93828,0xB410F6D3,0x98F4BBBC,0xB3C0200C,0x99307EE0,
0xB36F784F,0x996C816F,0xB31EFFCC,0x99A8C345,0xB2CEB6B5,0x99E5443B,0xB27E9D3C,
0x9A22042D,0xB22EB392,0x9A5F02F5,0xB1DEF9E9,0x9A9C406E,0xB18F7071,0x9AD9BC71,
0xB140175B,0x9B1776DA,0xB0F0EEDA,0x9B556F81,0xB0A1F71D,0x9B93A641,0xB0533055,
0x9BD21AF3,0xB0049AB3,0x9C10CD70,0xAFB63667,0x9C4FBD93,0xAF6803A2,0x9C8EEB34,
0xAF1A0293,0x9CCE562C,0xAECC336C,0x9D0DFE54,0xAE7E965B,0x9D4DE385,0xAE312B92,
0x9D8E0597,0xADE3F33E,0x9DCE6463,0xAD96ED92,0x9E0EFFC1,0xAD4A1ABA,0x9E4FD78A,
0xACFD7AE8,0x9E90EB94,0xACB10E4B,0x9ED23BB9,0xAC64D510,0x9F13C7D0,0xAC18CF69,
0x9F558FB0,0xABCCFD83,0x9F979331,0xAB815F8D,0x9FD9D22A,0xAB35F5B5,0xA01C4C73,
0xAAEAC02C,0xA05F01E1,0xAA9FBF1E,0xA0A1F24D,0xAA54F2BA,0xA0E51D8C,0xAA0A5B2E,
0xA1288376,0xA9BFF8A8,0xA16C23E1,0xA975CB57,0xA1AFFEA3,0xA92BD367,0xA1F41392,
0xA8E21106,0xA2386284,0xA8988463,0xA27CEB4F,0xA84F2DAA,0xA2C1ADC9,0xA8060D08,
0xA306A9C8,0xA7BD22AC,0xA34BDF20,0xA7746EC0,0xA3914DA8,0xA72BF174,0xA3D6F534,
0xA6E3AAF2,0xA41CD599,0xA69B9B68,0xA462EEAC,0xA653C303,0xA4A94043,0xA60C21EE,
0xA4EFCA31,0xA5C4B855,0xA5368C4B,0xA57D8666,0xA57D8666,0xA5368C4B,0xA5C4B855,
0xA4EFCA31,0xA60C21EE,0xA4A94043,0xA653C303,0xA462EEAC,0xA69B9B68,0xA41CD599,
0xA6E3AAF2,0xA3D6F534,0xA72BF174,0xA3914DA8,0xA7746EC0,0xA34BDF20,0xA7BD22AC,
0xA306A9C8,0xA8060D08,0xA2C1ADC9,0xA84F2DAA,0xA27CEB4F,0xA8988463,0xA2386284,
0xA8E21106,0xA1F41392,0xA92BD367,0xA1AFFEA3,0xA975CB57,0xA16C23E1,0xA9BFF8A8,
0xA1288376,0xAA0A5B2E,0xA0E51D8C,0xAA54F2BA,0xA0A1F24D,0xAA9FBF1E,0xA05F01E1,
0xAAEAC02C,0xA01C4C73,0xAB35F5B5,0x9FD9D22A,0xAB815F8D,0x9F979331,0xABCCFD83,
0x9F558FB0,0xAC18CF69,0x9F13C7D0,0xAC64D510,0x9ED23BB9,0xACB10E4B,0x9E90EB94,
0xACFD7AE8,0x9E4FD78A,0xAD4A1ABA,0x9E0EFFC1,0xAD96ED92,0x9DCE6463,0xADE3F33E,
0x9D8E0597,0xAE312B92,0x9D4DE385,0xAE7E965B,0x9D0DFE54,0xAECC336C,0x9CCE562C,
0xAF1A0293,0x9C8EEB34,0xAF6803A2,0x9C4FBD93,0xAFB63667,0x9C10CD70,0xB0049AB3,
0x9BD21AF3,0xB0533055,0x9B93A641,0xB0A1F71D,0x9B556F81,0xB0F0EEDA,0x9B1776DA,
0xB140175B,0x9AD9BC71,0xB18F7071,0x9A9C406E,0xB1DEF9E9,0x9A5F02F5,0xB22EB392,
0x9A22042D,0xB27E9D3C,0x99E5443B,0xB2CEB6B5,0x99A8C345,0xB31EFFCC,0x996C816F,
0xB36F784F,0x99307EE0,0xB3C0200C,0x98F4BBBC,0xB410F6D3,0x98B93828,0xB461FC70,
0x987DF449,0xB4B330B3,0x9842F043,0xB5049368,0x98082C3B,0xB556245E,0x97CDA855,
0xB5A7E362,0x979364B5,0xB5F9D043,0x9759617F,0xB64BEACD,0x971F9ED7,0xB69E32CD,
0x96E61CE0,0xB6F0A812,0x96ACDBBE,0xB7434A67,0x9673DB94,0xB796199B,0x963B1C86,
0xB7E9157A,0x96029EB6,0xB83C3DD1,0x95CA6247,0xB88F926D,0x9592675C,0xB8E31319,
0x955AAE17,0xB936BFA4,0x9523369C,0xB98A97D8,0x94EC010B,0xB9DE9B83,0x94B50D87,
0xBA32CA71,0x947E5C33,0xBA87246D,0x9447ED2F,0xBADBA943,0x9411C09E,0xBB3058C0,
0x93DBD6A0,0xBB8532B0,0x93A62F57,0xBBDA36DD,0x9370CAE4,0xBC2F6513,0x933BA968,
0xBC84BD1F,0x9306CB04,0xBCDA3ECB,0x92D22FD9,0xBD2FE9E2,0x929DD806,0xBD85BE30,
0x9269C3AC,0xBDDBBB7F,0x9235F2EC,0xBE31E19B,0x920265E4,0xBE88304F,0x91CF1CB6,
0xBEDEA765,0x919C1781,0xBF3546A8,0x91695663,0xBF8C0DE3,0x9136D97D,0xBFE2FCDF,
0x9104A0EE,0xC03A1368,0x90D2ACD4,0xC0915148,0x90A0FD4E,0xC0E8B648,0x906F927C,
0xC1404233,0x903E6C7B,0xC197F4D4,0x900D8B69,0xC1EFCDF3,0x8FDCEF66,0xC247CD5A,
0x8FAC988F,0xC29FF2D4,0x8F7C8701,0xC2F83E2A,0x8F4CBADB,0xC350AF26,0x8F1D343A,
0xC3A94590,0x8EEDF33B,0xC4020133,0x8EBEF7FB,0xC45AE1D7,0x8E904298,0xC4B3E746,
0x8E61D32E,0xC50D1149,0x8E33A9DA,0xC5665FA9,0x8E05C6B7,0xC5BFD22E,0x8DD829E4,
0xC61968A2,0x8DAAD37B,0xC67322CE,0x8D7DC399,0xC6CD0079,0x8D50FA59,0xC727016D,
0x8D2477D8,0xC7812572,0x8CF83C30,0xC7DB6C50,0x8CCC477D,0xC835D5D0,0x8CA099DA,
0xC89061BA,0x8C753362,0xC8EB0FD6,0x8C4A142F,0xC945DFEC,0x8C1F3C5D,0xC9A0D1C5,
0x8BF4AC05,0xC9FBE527,0x8BCA6343,0xCA5719DB,0x8BA0622F,0xCAB26FA9,0x8B76A8E4,
0xCB0DE658,0x8B4D377C,0xCB697DB0,0x8B240E11,0xCBC53579,0x8AFB2CBB,0xCC210D79,
0x8AD29394,0xCC7D0578,0x8AAA42B4,0xCCD91D3D,0x8A823A36,0xCD355491,0x8A5A7A31,
0xCD91AB39,0x8A3302BE,0xCDEE20FC,0x8A0BD3F5,0xCE4AB5A2,0x89E4EDEF,0xCEA768F2,
0x89BE50C3,0xCF043AB3,0x8997FC8A,0xCF612AAA,0x8971F15A,0xCFBE389F,0x894C2F4C,
0xD01B6459,0x8926B677,0xD078AD9E,0x890186F2,0xD0D61434,0x88DCA0D3,0xD13397E2,
0x88B80432,0xD191386E,0x8893B125,0xD1EEF59E,0x886FA7C2,0xD24CCF39,0x884BE821,
0xD2AAC504,0x88287256,0xD308D6C7,0x88054677,0xD3670446,0x87E2649B,0xD3C54D47,
0x87BFCCD7,0xD423B191,0x879D7F41,0xD48230E9,0x877B7BEC,0xD4E0CB15,0x8759C2EF,
0xD53F7FDA,0x8738545E,0xD59E4EFF,0x8717304E,0xD5FD3848,0x86F656D3,0xD65C3B7B,
0x86D5C802,0xD6BB585E,0x86B583EE,0xD71A8EB5,0x86958AAC,0xD779DE47,0x8675DC4F,
0xD7D946D8,0x865678EB,0xD838C82D,0x86376092,0xD898620C,0x86189359,0xD8F81439,
0x85FA1153,0xD957DE7A,0x85DBDA91,0xD9B7C094,0x85BDEF28,0xDA17BA4A,0x85A04F28,
0xDA77CB63,0x8582FAA5,0xDAD7F3A2,0x8565F1B0,0xDB3832CD,0x8549345C,0xDB9888A8,
0x852CC2BB,0xDBF8F4F8,0x85109CDD,0xDC597781,0x84F4C2D4,0xDCBA1008,0x84D934B1,
0xDD1ABE51,0x84BDF286,0xDD7B8220,0x84A2FC62,0xDDDC5B3B,0x84885258,0xDE3D4964,
0x846DF477,0xDE9E4C60,0x8453E2CF,0xDEFF63F4,0x843A1D70,0xDF608FE4,0x8420A46C,
0xDFC1CFF3,0x840777D0,0xE02323E5,0x83EE97AD,0xE0848B7F,0x83D60412,0xE0E60685,
0x83BDBD0E,0xE14794BA,0x83A5C2B0,0xE1A935E2,0x838E1507,0xE20AE9C1,0x8376B422,
0xE26CB01B,0x835FA00F,0xE2CE88B3,0x8348D8DC,0xE330734D,0x83325E97,0xE3926FAD,
0x831C314E,0xE3F47D96,0x83065110,0xE4569CCB,0x82F0BDE8,0xE4B8CD11,0x82DB77E5,
0xE51B0E2A,0x82C67F14,0xE57D5FDA,0x82B1D381,0xE5DFC1E5,0x829D753A,0xE642340D,
0x8289644B,0xE6A4B616,0x8275A0C0,0xE70747C4,0x82622AA6,0xE769E8D8,0x824F0208,
0xE7CC9917,0x823C26F3,0xE82F5844,0x82299971,0xE8922622,0x82175990,0xE8F50273,
0x82056758,0xE957ECFB,0x81F3C2D7,0xE9BAE57D,0x81E26C16,0xEA1DEBBB,0x81D16321,
0xEA80FF7A,0x81C0A801,0xEAE4207A,0x81B03AC2,0xEB474E81,0x81A01B6D,0xEBAA894F,
0x81904A0C,0xEC0DD0A8,0x8180C6A9,0xEC71244F,0x8171914E,0xECD48407,0x8162AA04,
0xED37EF91,0x815410D4,0xED9B66B2,0x8145C5C7,0xEDFEE92B,0x8137C8E6,0xEE6276BF,
0x812A1A3A,0xEEC60F31,0x811CB9CA,0xEF29B243,0x810FA7A0,0xEF8D5FB8,0x8102E3C4,
0xEFF11753,0x80F66E3C,0xF054D8D5,0x80EA4712,0xF0B8A401,0x80DE6E4C,0xF11C789A,
0x80D2E3F2,0xF1805662,0x80C7A80A,0xF1E43D1C,0x80BCBA9D,0xF2482C8A,0x80B21BAF,
0xF2AC246E,0x80A7CB49,0xF310248A,0x809DC971,0xF3742CA2,0x8094162C,0xF3D83C77,
0x808AB180,0xF43C53CB,0x80819B74,0xF4A07261,0x8078D40D,0xF50497FB,0x80705B50,
0xF568C45B,0x80683143,0xF5CCF743,0x806055EB,0xF6313077,0x8058C94C,0xF6956FB7,
0x80518B6B,0xF6F9B4C6,0x804A9C4D,0xF75DFF66,0x8043FBF6,0xF7C24F59,0x803DAA6A,
0xF826A462,0x8037A7AC,0xF88AFE42,0x8031F3C2,0xF8EF5CBB,0x802C8EAD,0xF953BF91,
0x80277872,0xF9B82684,0x8022B114,0xFA1C9157,0x801E3895,0xFA80FFCB,0x801A0EF8,
0xFAE571A4,0x80163440,0xFB49E6A3,0x8012A86F,0xFBAE5E89,0x800F6B88,0xFC12D91A,
0x800C7D8C,0xFC775616,0x8009DE7E,0xFCDBD541,0x80078E5E,0xFD40565C,0x80058D2F,
0xFDA4D929,0x8003DAF1,0xFE095D69,0x800277A6,0xFE6DE2E0,0x8001634E,0xFED2694F,
0x80009DEA,0xFF36F078,0x8000277A,0xFF9B781D,0x7FFFFFFF,0x00000000,0x7FFD885A,
0xFE6DE2E0,0x7FF62182,0xFCDBD541,0x7FE9CBC0,0xFB49E6A3,0x7FD8878E,0xF9B82684,
0x7FC25596,0xF826A462,0x7FA736B4,0xF6956FB7,0x7F872BF3,0xF50497FB,0x7F62368F,
0xF3742CA2,0x7F3857F6,0xF1E43D1C,0x7F0991C4,0xF054D8D5,0x7ED5E5C6,0xEEC60F31,
0x7E9D55FC,0xED37EF91,0x7E5FE493,0xEBAA894F,0x7E1D93EA,0xEA1DEBBB,0x7DD6668F,
0xE8922622,0x7D8A5F40,0xE70747C4,0x7D3980EC,0xE57D5FDA,0x7CE3CEB2,0xE3F47D96,
0x7C894BDE,0xE26CB01B,0x7C29FBEE,0xE0E60685,0x7BC5E290,0xDF608FE4,0x7B5D039E,
0xDDDC5B3B,0x7AEF6323,0xDC597781,0x7A7D055B,0xDAD7F3A2,0x7A05EEAD,0xD957DE7A,
0x798A23B1,0xD7D946D8,0x7909A92D,0xD65C3B7B,0x78848414,0xD4E0CB15,0x77FAB989,
0xD3670446,0x776C4EDB,0xD1EEF59E,0x76D94989,0xD078AD9E,0x7641AF3D,0xCF043AB3,
0x75A585CF,0xCD91AB39,0x7504D345,0xCC210D79,0x745F9DD1,0xCAB26FA9,0x73B5EBD1,
0xC945DFEC,0x7307C3D0,0xC7DB6C50,0x72552C85,0xC67322CE,0x719E2CD2,0xC50D1149,
0x70E2CBC6,0xC3A94590,0x7023109A,0xC247CD5A,0x6F5F02B2,0xC0E8B648,0x6E96A99D,
0xBF8C0DE3,0x6DCA0D14,0xBE31E19B,0x6CF934FC,0xBCDA3ECB,0x6C242960,0xBB8532B0,
0x6B4AF279,0xBA32CA71,0x6A6D98A4,0xB8E31319,0x698C246C,0xB796199B,0x68A69E81,
0xB64BEACD,0x67BD0FBD,0xB5049368,0x66CF8120,0xB3C0200C,0x65DDFBD3,0xB27E9D3C,
0x64E88926,0xB140175B,0x63EF3290,0xB0049AB3,0x62F201AC,0xAECC336C,0x61F1003F,
0xAD96ED92,0x60EC3830,0xAC64D510,0x5FE3B38D,0xAB35F5B5,0x5ED77C8A,0xAA0A5B2E,
0x5DC79D7C,0xA8E21106,0x5CB420E0,0xA7BD22AC,0x5B9D1154,0xA69B9B68,0x5A82799A,
0xA57D8666,0x59646498,0xA462EEAC,0x5842DD54,0xA34BDF20,0x571DEEFA,0xA2386284,
0x55F5A4D2,0xA1288376,0x54CA0A4B,0xA01C4C73,0x539B2AF0,0x9F13C7D0,0x5269126E,
0x9E0EFFC1,0x5133CC94,0x9D0DFE54,0x4FFB654D,0x9C10CD70,0x4EBFE8A5,0x9B1776DA,
0x4D8162C4,0x9A22042D,0x4C3FDFF4,0x99307EE0,0x4AFB6C98,0x9842F043,0x49B41533,
0x9759617F,0x4869E665,0x9673DB94,0x471CECE7,0x9592675C,0x45CD358F,0x94B50D87,
0x447ACD50,0x93DBD6A0,0x4325C135,0x9306CB04,0x41CE1E65,0x9235F2EC,0x4073F21D,
0x91695663,0x3F1749B8,0x90A0FD4E,0x3DB832A6,0x8FDCEF66,0x3C56BA70,0x8F1D343A,
0x3AF2EEB7,0x8E61D32E,0x398CDD32,0x8DAAD37B,0x382493B0,0x8CF83C30,0x36BA2014,
0x8C4A142F,0x354D9057,0x8BA0622F,0x33DEF287,0x8AFB2CBB,0x326E54C7,0x8A5A7A31,
0x30FBC54D,0x89BE50C3,0x2F875262,0x8926B677,0x2E110A62,0x8893B125,0x2C98FBBA,
0x88054677,0x2B1F34EB,0x877B7BEC,0x29A3C485,0x86F656D3,0x2826B928,0x8675DC4F,
0x26A82186,0x85FA1153,0x25280C5E,0x8582FAA5,0x23A6887F,0x85109CDD,0x2223A4C5,
0x84A2FC62,0x209F701C,0x843A1D70,0x1F19F97B,0x83D60412,0x1D934FE5,0x8376B422,
0x1C0B826A,0x831C314E,0x1A82A026,0x82C67F14,0x18F8B83C,0x8275A0C0,0x176DD9DE,
0x82299971,0x15E21445,0x81E26C16,0x145576B1,0x81A01B6D,0x12C8106F,0x8162AA04,
0x1139F0CF,0x812A1A3A,0x0FAB272B,0x80F66E3C,0x0E1BC2E4,0x80C7A80A,0x0C8BD35E,
0x809DC971,0x0AFB6805,0x8078D40D,0x096A9049,0x8058C94C,0x07D95B9E,0x803DAA6A,
0x0647D97C,0x80277872,0x04B6195D,0x80163440,0x03242ABF,0x8009DE7E,0x01921D20,
0x800277A6,0x00000000,0x80000000,0xFE6DE2E0,0x800277A6,0xFCDBD541,0x8009DE7E,
0xFB49E6A3,0x80163440,0xF9B82684,0x80277872,0xF826A462,0x803DAA6A,0xF6956FB7,
0x8058C94C,0xF50497FB,0x8078D40D,0xF3742CA2,0x809DC971,0xF1E43D1C,0x80C7A80A,
0xF054D8D5,0x80F66E3C,0xEEC60F31,0x812A1A3A,0xED37EF91,0x8162AA04,0xEBAA894F,
0x81A01B6D,0xEA1DEBBB,0x81E26C16,0xE8922622,0x82299971,0xE70747C4,0x8275A0C0,
0xE57D5FDA,0x82C67F14,0xE3F47D96,0x831C314E,0xE26CB01B,0x8376B422,0xE0E60685,
0x83D60412,0xDF608FE4,0x843A1D70,0xDDDC5B3B,0x84A2FC62,0xDC597781,0x85109CDD,
0xDAD7F3A2,0x8582FAA5,0xD957DE7A,0x85FA1153,0xD7D946D8,0x8675DC4F,0xD65C3B7B,
0x86F656D3,0xD4E0CB15,0x877B7BEC,0xD3670446,0x88054677,0xD1EEF59E,0x8893B125,
0xD078AD9E,0x8926B677,0xCF043AB3,0x89BE50C3,0xCD91AB39,0x8A5A7A31,0xCC210D79,
0x8AFB2CBB,0xCAB26FA9,0x8BA0622F,0xC945DFEC,0x8C4A142F,0xC7DB6C50,0x8CF83C30,
0xC67322CE,0x8DAAD37B,0xC50D1149,0x8E61D32E,0xC3A94590,0x8F1D343A,0xC247CD5A,
0x8FDCEF66,0xC0E8B648,0x90A0FD4E,0xBF8C0DE3,0x91695663,0xBE31E19B,0x9235F2EC,
0xBCDA3ECB,0x9306CB04,0xBB8532B0,0x93DBD6A0,0xBA32CA71,0x94B50D87,0xB8E31319,
0x9592675C,0xB796199B,0x9673DB94,0xB64BEACD,0x9759617F,0xB5049368,0x9842F043,
0xB3C0200C,0x99307EE0,0xB27E9D3C,0x9A22042D,0xB140175B,0x9B1776DA,0xB0049AB3,
0x9C10CD70,0xAECC336C,0x9D0DFE54,0xAD96ED92,0x9E0EFFC1,0xAC64D510,0x9F13C7D0,
0xAB35F5B5,0xA01C4C73,0xAA0A5B2E,0xA1288376,0xA8E21106,0xA2386284,0xA7BD22AC,
0xA34BDF20,0xA69B9B68,0xA462EEAC,0xA57D8666,0xA57D8666,0xA462EEAC,0xA69B9B68,
0xA34BDF20,0xA7BD22AC,0xA2386284,0xA8E21106,0xA1288376,0xAA0A5B2E,0xA01C4C73,
0xAB35F5B5,0x9F13C7D0,0xAC64D510,0x9E0EFFC1,0xAD96ED92,0x9D0DFE54,0xAECC336C,
0x9C10CD70,0xB0049AB3,0x9B1776DA,0xB140175B,0x9A22042D,0xB27E9D3C,0x99307EE0,
0xB3C0200C,0x9842F043,0xB5049368,0x9759617F,0xB64BEACD,0x9673DB94,0xB796199B,
0x9592675C,0xB8E31319,0x94B50D87,0xBA32CA71,0x93DBD6A0,0xBB8532B0,0x9306CB04,
0xBCDA3ECB,0x9235F2EC,0xBE31E19B,0x91695663,0xBF8C0DE3,0x90A0FD4E,0xC0E8B648,
0x8FDCEF66,0xC247CD5A,0x8F1D343A,0xC3A94590,0x8E61D32E,0xC50D1149,0x8DAAD37B,
0xC67322CE,0x8CF83C30,0xC7DB6C50,0x8C4A142F,0xC945DFEC,0x8BA0622F,0xCAB26FA9,
0x8AFB2CBB,0xCC210D79,0x8A5A7A31,0xCD91AB39,0x89BE50C3,0xCF043AB3,0x8926B677,
0xD078AD9E,0x8893B125,0xD1EEF59E,0x88054677,0xD3670446,0x877B7BEC,0xD4E0CB15,
0x86F656D3,0xD65C3B7B,0x8675DC4F,0xD7D946D8,0x85FA1153,0xD957DE7A,0x8582FAA5,
0xDAD7F3A2,0x85109CDD,0xDC597781,0x84A2FC62,0xDDDC5B3B,0x843A1D70,0xDF608FE4,
0x83D60412,0xE0E60685,0x8376B422,0xE26CB01B,0x831C314E,0xE3F47D96,0x82C67F14,
0xE57D5FDA,0x8275A0C0,0xE70747C4,0x82299971,0xE8922622,0x81E26C16,0xEA1DEBBB,
0x81A01B6D,0xEBAA894F,0x8162AA04,0xED37EF91,0x812A1A3A,0xEEC60F31,0x80F66E3C,
0xF054D8D5,0x80C7A80A,0xF1E43D1C,0x809DC971,0xF3742CA2,0x8078D40D,0xF50497FB,
0x8058C94C,0xF6956FB7,0x803DAA6A,0xF826A462,0x80277872,0xF9B82684,0x80163440,
0xFB49E6A3,0x8009DE7E,0xFCDBD541,0x800277A6,0xFE6DE2E0,0x7FFFFFFF,0x00000000,
0x7FD8878E,0xF9B82684,0x7F62368F,0xF3742CA2,0x7E9D55FC,0xED37EF91,0x7D8A5F40,
0xE70747C4,0x7C29FBEE,0xE0E60685,0x7A7D055B,0xDAD7F3A2,0x78848414,0xD4E0CB15,
0x7641AF3D,0xCF043AB3,0x73B5EBD1,0xC945DFEC,0x70E2CBC6,0xC3A94590,0x6DCA0D14,
0xBE31E19B,0x6A6D98A4,0xB8E31319,0x66CF8120,0xB3C0200C,0x62F201AC,0xAECC336C,
0x5ED77C8A,0xAA0A5B2E,0x5A82799A,0xA57D8666,0x55F5A4D2,0xA1288376,0x5133CC94,
0x9D0DFE54,0x4C3FDFF4,0x99307EE0,0x471CECE7,0x9592675C,0x41CE1E65,0x9235F2EC,
0x3C56BA70,0x8F1D343A,0x36BA2014,0x8C4A142F,0x30FBC54D,0x89BE50C3,0x2B1F34EB,
0x877B7BEC,0x25280C5E,0x8582FAA5,0x1F19F97B,0x83D60412,0x18F8B83C,0x8275A0C0,
0x12C8106F,0x8162AA04,0x0C8BD35E,0x809DC971,0x0647D97C,0x80277872,0x00000000,
0x80000000,0xF9B82684,0x80277872,0xF3742CA2,0x809DC971,0xED37EF91,0x8162AA04,
0xE70747C4,0x8275A0C0,0xE0E60685,0x83D60412,0xDAD7F3A2,0x8582FAA5,0xD4E0CB15,
0x877B7BEC,0xCF043AB3,0x89BE50C3,0xC945DFEC,0x8C4A142F,0xC3A94590,0x8F1D343A,
0xBE31E19B,0x9235F2EC,0xB8E31319,0x9592675C,0xB3C0200C,0x99307EE0,0xAECC336C,
0x9D0DFE54,0xAA0A5B2E,0xA1288376,0xA57D8666,0xA57D8666,0xA1288376,0xAA0A5B2E,
0x9D0DFE54,0xAECC336C,0x99307EE0,0xB3C0200C,0x9592675C,0xB8E31319,0x9235F2EC,
0xBE31E19B,0x8F1D343A,0xC3A94590,0x8C4A142F,0xC945DFEC,0x89BE50C3,0xCF043AB3,
0x877B7BEC,0xD4E0CB15,0x8582FAA5,0xDAD7F3A2,0x83D60412,0xE0E60685,0x8275A0C0,
0xE70747C4,0x8162AA04,0xED37EF91,0x809DC971,0xF3742CA2,0x80277872,0xF9B82684,
0x7FFFFFFF,0x00000000,0x7D8A5F40,0xE70747C4,0x7641AF3D,0xCF043AB3,0x6A6D98A4,
0xB8E31319,0x5A82799A,0xA57D8666,0x471CECE7,0x9592675C,0x30FBC54D,0x89BE50C3,
0x18F8B83C,0x8275A0C0,0x00000000,0x80000000,0xE70747C4,0x8275A0C0,0xCF043AB3,
0x89BE50C3,0xB8E31319,0x9592675C,0xA57D8666,0xA57D8666,0x9592675C,0xB8E31319,
0x89BE50C3,0xCF043AB3,0x8275A0C0,0xE70747C4,0x7FFFFFFF,0x00000000,0x5A82799A,
0xA57D8666,0x00000000,0x80000000,0xA57D8666,0xA57D8666,};

q31_t rearranged_twiddle_stride3_4096_q31[2728]={
0x7FFFFFFF,0x00000000,0x7FFFA72C,0xFF69343F,0x7FFE9CB2,0xFED2694F,0x7FFCE093,
0xFE3BA002,0x7FFA72D1,0xFDA4D929,0x7FF75370,0xFD0E1594,0x7FF38274,0xFC775616,
0x7FEEFFE1,0xFBE09B80,0x7FE9CBC0,0xFB49E6A3,0x7FE3E616,0xFAB3384F,0x7FDD4EEC,
0xFA1C9157,0x7FD6064C,0xF985F28A,0x7FCE0C3E,0xF8EF5CBB,0x7FC560CF,0xF858D0BB,
0x7FBC040A,0xF7C24F59,0x7FB1F5FC,0xF72BD967,0x7FA736B4,0xF6956FB7,0x7F9BC640,
0xF5FF1318,0x7F8FA4B0,0xF568C45B,0x7F82D214,0xF4D28451,0x7F754E80,0xF43C53CB,
0x7F671A05,0xF3A63398,0x7F5834B7,0xF310248A,0x7F489EAA,0xF27A2771,0x7F3857F6,
0xF1E43D1C,0x7F2760AF,0xF14E665C,0x7F15B8EE,0xF0B8A401,0x7F0360CB,0xF022F6DA,
0x7EF05860,0xEF8D5FB8,0x7EDC9FC6,0xEEF7DF6A,0x7EC8371A,0xEE6276BF,0x7EB31E78,
0xEDCD2687,0x7E9D55FC,0xED37EF91,0x7E86DDC6,0xECA2D2AD,0x7E6FB5F4,0xEC0DD0A8,
0x7E57DEA7,0xEB78EA52,0x7E3F57FF,0xEAE4207A,0x7E26221F,0xEA4F73EE,0x7E0C3D29,
0xE9BAE57D,0x7DF1A942,0xE92675F4,0x7DD6668F,0xE8922622,0x7DBA7534,0xE7FDF6D4,
0x7D9DD55A,0xE769E8D8,0x7D808728,0xE6D5FCFC,0x7D628AC6,0xE642340D,0x7D43E05E,
0xE5AE8ED8,0x7D24881B,0xE51B0E2A,0x7D048228,0xE487B2D0,0x7CE3CEB2,0xE3F47D96,
0x7CC26DE5,0xE3616F48,0x7CA05FF1,0xE2CE88B3,0x7C7DA505,0xE23BCAA2,0x7C5A3D50,
0xE1A935E2,0x7C362904,0xE116CB3D,0x7C116853,0xE0848B7F,0x7BEBFB70,0xDFF27773,
0x7BC5E290,0xDF608FE4,0x7B9F1DE6,0xDECED59B,0x7B77ADA8,0xDE3D4964,0x7B4F920E,
0xDDABEC08,0x7B26CB4F,0xDD1ABE51,0x7AFD59A4,0xDC89C109,0x7AD33D45,0xDBF8F4F8,
0x7AA8766F,0xDB685AE9,0x7A7D055B,0xDAD7F3A2,0x7A50EA47,0xDA47BFEE,0x7A24256F,
0xD9B7C094,0x79F6B711,0xD927F65B,0x79C89F6E,0xD898620C,0x7999DEC4,0xD809046E,
0x796A7554,0xD779DE47,0x793A6361,0xD6EAF05F,0x7909A92D,0xD65C3B7B,0x78D846FB,
0xD5CDC062,0x78A63D11,0xD53F7FDA,0x78738BB3,0xD4B17AA8,0x78403329,0xD423B191,
0x780C33B8,0xD396255A,0x77D78DAA,0xD308D6C7,0x77A24148,0xD27BC69C,0x776C4EDB,
0xD1EEF59E,0x7735B6AF,0xD1626490,0x76FE790E,0xD0D61434,0x76C69647,0xD04A054E,
0x768E0EA6,0xCFBE389F,0x7654E279,0xCF32AEEB,0x761B1211,0xCEA768F2,0x75E09DBD,
0xCE1C6777,0x75A585CF,0xCD91AB39,0x7569CA99,0xCD0734F9,0x752D6C6C,0xCC7D0578,
0x74F06B9E,0xCBF31D75,0x74B2C884,0xCB697DB0,0x74748371,0xCAE026E8,0x74359CBD,
0xCA5719DB,0x73F614C0,0xC9CE5748,0x73B5EBD1,0xC945DFEC,0x73752249,0xC8BDB485,
0x7333B883,0xC835D5D0,0x72F1AED9,0xC7AE4489,0x72AF05A7,0xC727016D,0x726BBD48,
0xC6A00D37,0x7227D61C,0xC61968A2,0x71E35080,0xC593146A,0x719E2CD2,0xC50D1149,
0x71586B74,0xC4875FF9,0x71120CC5,0xC4020133,0x70CB1128,0xC37CF5B0,0x708378FF,
0xC2F83E2A,0x703B44AD,0xC273DB58,0x6FF27497,0xC1EFCDF3,0x6FA90921,0xC16C16B0,
0x6F5F02B2,0xC0E8B648,0x6F1461B0,0xC065AD70,0x6EC92683,0xBFE2FCDF,0x6E7D5193,
0xBF60A54A,0x6E30E34A,0xBEDEA765,0x6DE3DC11,0xBE5D03E6,0x6D963C54,0xBDDBBB7F,
0x6D48047E,0xBD5ACEE5,0x6CF934FC,0xBCDA3ECB,0x6CA9CE3B,0xBC5A0BE2,0x6C59D0A9,
0xBBDA36DD,0x6C093CB6,0xBB5AC06D,0x6BB812D1,0xBADBA943,0x6B66536B,0xBA5CF210,
0x6B13FEF5,0xB9DE9B83,0x6AC115E2,0xB960A64C,0x6A6D98A4,0xB8E31319,0x6A1987B0,
0xB865E299,0x69C4E37A,0xB7E9157A,0x696FAC78,0xB76CAC69,0x6919E320,0xB6F0A812,
0x68C387E9,0xB6750921,0x686C9B4B,0xB5F9D043,0x68151DBE,0xB57EFE22,0x67BD0FBD,
0xB5049368,0x676471C0,0xB48A90C0,0x670B4444,0xB410F6D3,0x66B187C3,0xB397C649,
0x66573CBB,0xB31EFFCC,0x65FC63A9,0xB2A6A402,0x65A0FD0B,0xB22EB392,0x6545095F,
0xB1B72F23,0x64E88926,0xB140175B,0x648B7CE0,0xB0C96CE0,0x642DE50D,0xB0533055,
0x63CFC231,0xAFDD625F,0x637114CC,0xAF6803A2,0x6311DD64,0xAEF314C0,0x62B21C7B,
0xAE7E965B,0x6251D298,0xAE0A8916,0x61F1003F,0xAD96ED92,0x618FA5F7,0xAD23C46E,
0x612DC447,0xACB10E4B,0x60CB5BB7,0xAC3ECBC7,0x60686CCF,0xABCCFD83,0x6004F819,
0xAB5BA41A,0x5FA0FE1F,0xAAEAC02C,0x5F3C7F6B,0xAA7A5253,0x5ED77C8A,0xAA0A5B2E,
0x5E71F606,0xA99ADB56,0x5E0BEC6E,0xA92BD367,0x5DA5604F,0xA8BD43FA,0x5D3E5237,
0xA84F2DAA,0x5CD6C2B5,0xA7E1910F,0x5C6EB258,0xA7746EC0,0x5C0621B2,0xA707C757,
0x5B9D1154,0xA69B9B68,0x5B3381CE,0xA62FEB8B,0x5AC973B5,0xA5C4B855,0x5A5EE79A,
0xA55A025B,0x59F3DE12,0xA4EFCA31,0x598857B2,0xA486106A,0x591C550E,0xA41CD599,
0x58AFD6BD,0xA3B41A50,0x5842DD54,0xA34BDF20,0x57D5696D,0xA2E4249B,0x57677B9D,
0xA27CEB4F,0x56F9147E,0xA21633CD,0x568A34A9,0xA1AFFEA3,0x561ADCB9,0xA14A4C5E,
0x55AB0D46,0xA0E51D8C,0x553AC6EE,0xA08072BA,0x54CA0A4B,0xA01C4C73,0x5458D7F9,
0x9FB8AB41,0x53E73097,0x9F558FB0,0x537514C2,0x9EF2FA49,0x53028518,0x9E90EB94,
0x528F8238,0x9E2F641B,0x521C0CC2,0x9DCE6463,0x51A82555,0x9D6DECF4,0x5133CC94,
0x9D0DFE54,0x50BF031F,0x9CAE9907,0x5049C999,0x9C4FBD93,0x4FD420A4,0x9BF16C7A,
0x4F5E08E3,0x9B93A641,0x4EE782FB,0x9B366B68,0x4E708F8F,0x9AD9BC71,0x4DF92F46,
0x9A7D99DE,0x4D8162C4,0x9A22042D,0x4D092AB0,0x99C6FBDE,0x4C9087B1,0x996C816F,
0x4C177A6E,0x9912955F,0x4B9E0390,0x98B93828,0x4B2423BE,0x98606A49,0x4AA9DBA2,
0x98082C3B,0x4A2F2BE6,0x97B07E7A,0x49B41533,0x9759617F,0x49389836,0x9702D5C3,
0x48BCB599,0x96ACDBBE,0x48406E08,0x965773E7,0x47C3C22F,0x96029EB6,0x4746B2BC,
0x95AE5C9F,0x46C9405C,0x955AAE17,0x464B6BBE,0x95079394,0x45CD358F,0x94B50D87,
0x454E9E80,0x94631C65,0x44CFA740,0x9411C09E,0x4450507E,0x93C0FAA3,0x43D09AED,
0x9370CAE4,0x4350873C,0x932131D1,0x42D0161E,0x92D22FD9,0x424F4845,0x9283C568,
0x41CE1E65,0x9235F2EC,0x414C992F,0x91E8B8D0,0x40CAB958,0x919C1781,0x40487F94,
0x91500F67,0x3FC5EC98,0x9104A0EE,0x3F430119,0x90B9CC7D,0x3EBFBDCD,0x906F927C,
0x3E3C2369,0x9025F352,0x3DB832A6,0x8FDCEF66,0x3D33EC39,0x8F94871D,0x3CAF50DA,
0x8F4CBADB,0x3C2A6142,0x8F058B04,0x3BA51E29,0x8EBEF7FB,0x3B1F8848,0x8E790222,
0x3A99A057,0x8E33A9DA,0x3A136712,0x8DEEEF82,0x398CDD32,0x8DAAD37B,0x39060373,
0x8D675623,0x387EDA8E,0x8D2477D8,0x37F76341,0x8CE238F6,0x376F9E46,0x8CA099DA,
0x36E78C5B,0x8C5F9ADE,0x365F2E3B,0x8C1F3C5D,0x35D684A6,0x8BDF7EB0,0x354D9057,
0x8BA0622F,0x34C4520D,0x8B61E733,0x343ACA87,0x8B240E11,0x33B0FA84,0x8AE6D720,
0x3326E2C3,0x8AAA42B4,0x329C8402,0x8A6E5123,0x3211DF04,0x8A3302BE,0x3186F487,
0x89F857D8,0x30FBC54D,0x89BE50C3,0x30705217,0x8984EDCF,0x2FE49BA7,0x894C2F4C,
0x2F58A2BE,0x89141589,0x2ECC681E,0x88DCA0D3,0x2E3FEC8B,0x88A5D177,0x2DB330C7,
0x886FA7C2,0x2D263596,0x883A23FF,0x2C98FBBA,0x88054677,0x2C0B83FA,0x87D10F75,
0x2B7DCF17,0x879D7F41,0x2AEFDDD8,0x876A9621,0x2A61B101,0x8738545E,0x29D34958,
0x8706BA3D,0x2944A7A2,0x86D5C802,0x28B5CCA5,0x86A57DF2,0x2826B928,0x8675DC4F,
0x27976DF1,0x8646E35C,0x2707EBC7,0x86189359,0x26783370,0x85EAEC88,0x25E845B6,
0x85BDEF28,0x2558235F,0x85919B76,0x24C7CD33,0x8565F1B0,0x243743FA,0x853AF214,
0x23A6887F,0x85109CDD,0x23159B88,0x84E6F244,0x22847DE0,0x84BDF286,0x21F3304F,
0x84959DD9,0x2161B3A0,0x846DF477,0x20D0089C,0x8446F695,0x203E300D,0x8420A46C,
0x1FAC2ABF,0x83FAFE2E,0x1F19F97B,0x83D60412,0x1E879D0D,0x83B1B649,0x1DF5163F,
0x838E1507,0x1D6265DD,0x836B207D,0x1CCF8CB3,0x8348D8DC,0x1C3C8B8C,0x83273E52,
0x1BA96335,0x83065110,0x1B161479,0x82E61141,0x1A82A026,0x82C67F14,0x19EF0707,
0x82A79AB3,0x195B49EA,0x8289644B,0x18C7699B,0x826BDC04,0x183366E9,0x824F0208,
0x179F429F,0x8232D67F,0x170AFD8D,0x82175990,0x1676987F,0x81FC8B60,0x15E21445,
0x81E26C16,0x154D71AA,0x81C8FBD6,0x14B8B17F,0x81B03AC2,0x1423D492,0x819828FD,
0x138EDBB1,0x8180C6A9,0x12F9C7AA,0x816A13E6,0x1264994E,0x815410D4,0x11CF516A,
0x813EBD90,0x1139F0CF,0x812A1A3A,0x10A4784B,0x811626EC,0x100EE8AD,0x8102E3C4,
0x0F7942C7,0x80F050DB,0x0EE38766,0x80DE6E4C,0x0E4DB75B,0x80CD3C2F,0x0DB7D376,
0x80BCBA9D,0x0D21DC87,0x80ACE9AB,0x0C8BD35E,0x809DC971,0x0BF5B8CB,0x808F5A02,
0x0B5F8D9F,0x80819B74,0x0AC952AA,0x80748DD9,0x0A3308BD,0x80683143,0x099CB0A7,
0x805C85C4,0x09064B3A,0x80518B6B,0x086FD947,0x80474248,0x07D95B9E,0x803DAA6A,
0x0742D311,0x8034C3DD,0x06AC406F,0x802C8EAD,0x0615A48B,0x80250AE7,0x057F0035,
0x801E3895,0x04E8543E,0x801817BF,0x0451A177,0x8012A86F,0x03BAE8B2,0x800DEAAD,
0x03242ABF,0x8009DE7E,0x028D6870,0x800683E8,0x01F6A297,0x8003DAF1,0x015FDA03,
0x8001E39B,0x00C90F88,0x80009DEA,0x003243F5,0x800009DF,0xFF9B781D,0x8000277A,
0xFF04ACD0,0x8000F6BD,0xFE6DE2E0,0x800277A6,0xFDD71B1E,0x8004AA32,0xFD40565C,
0x80078E5E,0xFCA9956A,0x800B2427,0xFC12D91A,0x800F6B88,0xFB7C223D,0x8014647B,
0xFAE571A4,0x801A0EF8,0xFA4EC821,0x80206AF8,0xF9B82684,0x80277872,0xF9218D9E,
0x802F375D,0xF88AFE42,0x8037A7AC,0xF7F4793E,0x8040C956,0xF75DFF66,0x804A9C4D,
0xF6C79188,0x80552084,0xF6313077,0x806055EB,0xF59ADD02,0x806C3C74,0xF50497FB,
0x8078D40D,0xF46E6231,0x80861CA6,0xF3D83C77,0x8094162C,0xF342279B,0x80A2C08B,
0xF2AC246E,0x80B21BAF,0xF21633C0,0x80C22784,0xF1805662,0x80D2E3F2,0xF0EA8D24,
0x80E450E2,0xF054D8D5,0x80F66E3C,0xEFBF3A45,0x81093BE8,0xEF29B243,0x811CB9CA,
0xEE9441A0,0x8130E7C9,0xEDFEE92B,0x8145C5C7,0xED69A9B3,0x815B53A8,0xECD48407,
0x8171914E,0xEC3F78F6,0x81887E9A,0xEBAA894F,0x81A01B6D,0xEB15B5E1,0x81B867A5,
0xEA80FF7A,0x81D16321,0xE9EC66E8,0x81EB0DBE,0xE957ECFB,0x82056758,0xE8C39280,
0x82206FCC,0xE82F5844,0x823C26F3,0xE79B3F16,0x82588CA7,0xE70747C4,0x8275A0C0,
0xE6737319,0x82936317,0xE5DFC1E5,0x82B1D381,0xE54C34F3,0x82D0F1D5,0xE4B8CD11,
0x82F0BDE8,0xE4258B0A,0x8311378D,0xE3926FAD,0x83325E97,0xE2FF7BC3,0x835432D8,
0xE26CB01B,0x8376B422,0xE1DA0D7E,0x8399E244,0xE14794BA,0x83BDBD0E,0xE0B54698,
0x83E2444D,0xE02323E5,0x840777D0,0xDF912D6B,0x842D5762,0xDEFF63F4,0x8453E2CF,
0xDE6DC84B,0x847B19E1,0xDDDC5B3B,0x84A2FC62,0xDD4B1D8C,0x84CB8A1B,0xDCBA1008,
0x84F4C2D4,0xDC293379,0x851EA652,0xDB9888A8,0x8549345C,0xDB08105E,0x85746CB8,
0xDA77CB63,0x85A04F28,0xD9E7BA7F,0x85CCDB70,0xD957DE7A,0x85FA1153,0xD8C8381D,
0x8627F091,0xD838C82D,0x865678EB,0xD7A98F73,0x8685AA20,0xD71A8EB5,0x86B583EE,
0xD68BC6BA,0x86E60614,0xD5FD3848,0x8717304E,0xD56EE424,0x87490258,0xD4E0CB15,
0x877B7BEC,0xD452EDDF,0x87AE9CC5,0xD3C54D47,0x87E2649B,0xD337EA12,0x8816D327,
0xD2AAC504,0x884BE821,0xD21DDEE2,0x8881A33D,0xD191386E,0x88B80432,0xD104D26B,
0x88EF0AB4,0xD078AD9E,0x8926B677,0xCFECCAC7,0x895F072E,0xCF612AAA,0x8997FC8A,
0xCED5CE08,0x89D1963C,0xCE4AB5A2,0x8A0BD3F5,0xCDBFE23A,0x8A46B564,0xCD355491,
0x8A823A36,0xCCAB0D65,0x8ABE6219,0xCC210D79,0x8AFB2CBB,0xCB97558A,0x8B3899C6,
0xCB0DE658,0x8B76A8E4,0xCA84C0A3,0x8BB559C1,0xC9FBE527,0x8BF4AC05,0xC97354A4,
0x8C349F58,0xC8EB0FD6,0x8C753362,0xC863177B,0x8CB667C8,0xC7DB6C50,0x8CF83C30,
0xC7540F11,0x8D3AB03F,0xC6CD0079,0x8D7DC399,0xC6464144,0x8DC175E0,0xC5BFD22E,
0x8E05C6B7,0xC539B3F1,0x8E4AB5BF,0xC4B3E746,0x8E904298,0xC42E6CE8,0x8ED66CE1,
0xC3A94590,0x8F1D343A,0xC32471F7,0x8F649840,0xC29FF2D4,0x8FAC988F,0xC21BC8E1,
0x8FF534C4,0xC197F4D4,0x903E6C7B,0xC1147764,0x90883F4D,0xC0915148,0x90D2ACD4,
0xC00E8336,0x911DB4A9,0xBF8C0DE3,0x91695663,0xBF09F205,0x91B5919A,0xBE88304F,
0x920265E4,0xBE06C977,0x924FD2D7,0xBD85BE30,0x929DD806,0xBD050F2C,0x92EC7505,
0xBC84BD1F,0x933BA968,0xBC04C8BA,0x938B74C1,0xBB8532B0,0x93DBD6A0,0xBB05FBB0,
0x942CCE96,0xBA87246D,0x947E5C33,0xBA08AD95,0x94D07F05,0xB98A97D8,0x9523369C,
0xB90CE3E6,0x95768283,0xB88F926D,0x95CA6247,0xB812A41A,0x961ED574,0xB796199B,
0x9673DB94,0xB719F39E,0x96C97432,0xB69E32CD,0x971F9ED7,0xB622D7D6,0x97765B0A,
0xB5A7E362,0x97CDA855,0xB52D561E,0x9825863D,0xB4B330B3,0x987DF449,0xB43973CA,
0x98D6F1FE,0xB3C0200C,0x99307EE0,0xB3473623,0x998A9A74,0xB2CEB6B5,0x99E5443B,
0xB256A26A,0x9A407BB9,0xB1DEF9E9,0x9A9C406E,0xB167BDD7,0x9AF891DB,0xB0F0EEDA,
0x9B556F81,0xB07A8D97,0x9BB2D8DE,0xB0049AB3,0x9C10CD70,0xAF8F16D1,0x9C6F4CB6,
0xAF1A0293,0x9CCE562C,0xAEA55E9E,0x9D2DE94D,0xAE312B92,0x9D8E0597,0xADBD6A10,
0x9DEEAA82,0xAD4A1ABA,0x9E4FD78A,0xACD73E30,0x9EB18C26,0xAC64D510,0x9F13C7D0,
0xABF2DFFB,0x9F7689FF,0xAB815F8D,0x9FD9D22A,0xAB105464,0xA03D9FC8,0xAA9FBF1E,
0xA0A1F24D,0xAA2FA056,0xA106C92F,0xA9BFF8A8,0xA16C23E1,0xA950C8B0,0xA1D201D7,
0xA8E21106,0xA2386284,0xA873D246,0xA29F4559,0xA8060D08,0xA306A9C8,0xA798C1E5,
0xA36E8F41,0xA72BF174,0xA3D6F534,0xA6BF9C4B,0xA43FDB10,0xA653C303,0xA4A94043,
0xA5E8662F,0xA513243B,0xA57D8666,0xA57D8666,0xA513243B,0xA5E8662F,0xA4A94043,
0xA653C303,0xA43FDB10,0xA6BF9C4B,0xA3D6F534,0xA72BF174,0xA36E8F41,0xA798C1E5,
0xA306A9C8,0xA8060D08,0xA29F4559,0xA873D246,0xA2386284,0xA8E21106,0xA1D201D7,
0xA950C8B0,0xA16C23E1,0xA9BFF8A8,0xA106C92F,0xAA2FA056,0xA0A1F24D,0xAA9FBF1E,
0xA03D9FC8,0xAB105464,0x9FD9D22A,0xAB815F8D,0x9F7689FF,0xABF2DFFB,0x9F13C7D0,
0xAC64D510,0x9EB18C26,0xACD73E30,0x9E4FD78A,0xAD4A1ABA,0x9DEEAA82,0xADBD6A10,
0x9D8E0597,0xAE312B92,0x9D2DE94D,0xAEA55E9E,0x9CCE562C,0xAF1A0293,0x9C6F4CB6,
0xAF8F16D1,0x9C10CD70,0xB0049AB3,0x9BB2D8DE,0xB07A8D97,0x9B556F81,0xB0F0EEDA,
0x9AF891DB,0xB167BDD7,0x9A9C406E,0xB1DEF9E9,0x9A407BB9,0xB256A26A,0x99E5443B,
0xB2CEB6B5,0x998A9A74,0xB3473623,0x99307EE0,0xB3C0200C,0x98D6F1FE,0xB43973CA,
0x987DF449,0xB4B330B3,0x9825863D,0xB52D561E,0x97CDA855,0xB5A7E362,0x97765B0A,
0xB622D7D6,0x971F9ED7,0xB69E32CD,0x96C97432,0xB719F39E,0x9673DB94,0xB796199B,
0x961ED574,0xB812A41A,0x95CA6247,0xB88F926D,0x95768283,0xB90CE3E6,0x9523369C,
0xB98A97D8,0x94D07F05,0xBA08AD95,0x947E5C33,0xBA87246D,0x942CCE96,0xBB05FBB0,
0x93DBD6A0,0xBB8532B0,0x938B74C1,0xBC04C8BA,0x933BA968,0xBC84BD1F,0x92EC7505,
0xBD050F2C,0x929DD806,0xBD85BE30,0x924FD2D7,0xBE06C977,0x920265E4,0xBE88304F,
0x91B5919A,0xBF09F205,0x91695663,0xBF8C0DE3,0x911DB4A9,0xC00E8336,0x90D2ACD4,
0xC0915148,0x90883F4D,0xC1147764,0x903E6C7B,0xC197F4D4,0x8FF534C4,0xC21BC8E1,
0x8FAC988F,0xC29FF2D4,0x8F649840,0xC32471F7,0x8F1D343A,0xC3A94590,0x8ED66CE1,
0xC42E6CE8,0x8E904298,0xC4B3E746,0x8E4AB5BF,0xC539B3F1,0x8E05C6B7,0xC5BFD22E,
0x8DC175E0,0xC6464144,0x8D7DC399,0xC6CD0079,0x8D3AB03F,0xC7540F11,0x8CF83C30,
0xC7DB6C50,0x8CB667C8,0xC863177B,0x8C753362,0xC8EB0FD6,0x8C349F58,0xC97354A4,
0x8BF4AC05,0xC9FBE527,0x8BB559C1,0xCA84C0A3,0x8B76A8E4,0xCB0DE658,0x8B3899C6,
0xCB97558A,0x8AFB2CBB,0xCC210D79,0x8ABE6219,0xCCAB0D65,0x8A823A36,0xCD355491,
0x8A46B564,0xCDBFE23A,0x8A0BD3F5,0xCE4AB5A2,0x89D1963C,0xCED5CE08,0x8997FC8A,
0xCF612AAA,0x895F072E,0xCFECCAC7,0x8926B677,0xD078AD9E,0x88EF0AB4,0xD104D26B,
0x88B80432,0xD191386E,0x8881A33D,0xD21DDEE2,0x884BE821,0xD2AAC504,0x8816D327,
0xD337EA12,0x87E2649B,0xD3C54D47,0x87AE9CC5,0xD452EDDF,0x877B7BEC,0xD4E0CB15,
0x87490258,0xD56EE424,0x8717304E,0xD5FD3848,0x86E60614,0xD68BC6BA,0x86B583EE,
0xD71A8EB5,0x8685AA20,0xD7A98F73,0x865678EB,0xD838C82D,0x8627F091,0xD8C8381D,
0x85FA1153,0xD957DE7A,0x85CCDB70,0xD9E7BA7F,0x85A04F28,0xDA77CB63,0x85746CB8,
0xDB08105E,0x8549345C,0xDB9888A8,0x851EA652,0xDC293379,0x84F4C2D4,0xDCBA1008,
0x84CB8A1B,0xDD4B1D8C,0x84A2FC62,0xDDDC5B3B,0x847B19E1,0xDE6DC84B,0x8453E2CF,
0xDEFF63F4,0x842D5762,0xDF912D6B,0x840777D0,0xE02323E5,0x83E2444D,0xE0B54698,
0x83BDBD0E,0xE14794BA,0x8399E244,0xE1DA0D7E,0x8376B422,0xE26CB01B,0x835432D8,
0xE2FF7BC3,0x83325E97,0xE3926FAD,0x8311378D,0xE4258B0A,0x82F0BDE8,0xE4B8CD11,
0x82D0F1D5,0xE54C34F3,0x82B1D381,0xE5DFC1E5,0x82936317,0xE6737319,0x8275A0C0,
0xE70747C4,0x82588CA7,0xE79B3F16,0x823C26F3,0xE82F5844,0x82206FCC,0xE8C39280,
0x82056758,0xE957ECFB,0x81EB0DBE,0xE9EC66E8,0x81D16321,0xEA80FF7A,0x81B867A5,
0xEB15B5E1,0x81A01B6D,0xEBAA894F,0x81887E9A,0xEC3F78F6,0x8171914E,0xECD48407,
0x815B53A8,0xED69A9B3,0x8145C5C7,0xEDFEE92B,0x8130E7C9,0xEE9441A0,0x811CB9CA,
0xEF29B243,0x81093BE8,0xEFBF3A45,0x80F66E3C,0xF054D8D5,0x80E450E2,0xF0EA8D24,
0x80D2E3F2,0xF1805662,0x80C22784,0xF21633C0,0x80B21BAF,0xF2AC246E,0x80A2C08B,
0xF342279B,0x8094162C,0xF3D83C77,0x80861CA6,0xF46E6231,0x8078D40D,0xF50497FB,
0x806C3C74,0xF59ADD02,0x806055EB,0xF6313077,0x80552084,0xF6C79188,0x804A9C4D,
0xF75DFF66,0x8040C956,0xF7F4793E,0x8037A7AC,0xF88AFE42,0x802F375D,0xF9218D9E,
0x80277872,0xF9B82684,0x80206AF8,0xFA4EC821,0x801A0EF8,0xFAE571A4,0x8014647B,
0xFB7C223D,0x800F6B88,0xFC12D91A,0x800B2427,0xFCA9956A,0x80078E5E,0xFD40565C,
0x8004AA32,0xFDD71B1E,0x800277A6,0xFE6DE2E0,0x8000F6BD,0xFF04ACD0,0x8000277A,
0xFF9B781D,0x800009DF,0x003243F5,0x80009DEA,0x00C90F88,0x8001E39B,0x015FDA03,
0x8003DAF1,0x01F6A297,0x800683E8,0x028D6870,0x8009DE7E,0x03242ABF,0x800DEAAD,
0x03BAE8B2,0x8012A86F,0x0451A177,0x801817BF,0x04E8543E,0x801E3895,0x057F0035,
0x80250AE7,0x0615A48B,0x802C8EAD,0x06AC406F,0x8034C3DD,0x0742D311,0x803DAA6A,
0x07D95B9E,0x80474248,0x086FD947,0x80518B6B,0x09064B3A,0x805C85C4,0x099CB0A7,
0x80683143,0x0A3308BD,0x80748DD9,0x0AC952AA,0x80819B74,0x0B5F8D9F,0x808F5A02,
0x0BF5B8CB,0x809DC971,0x0C8BD35E,0x80ACE9AB,0x0D21DC87,0x80BCBA9D,0x0DB7D376,
0x80CD3C2F,0x0E4DB75B,0x80DE6E4C,0x0EE38766,0x80F050DB,0x0F7942C7,0x8102E3C4,
0x100EE8AD,0x811626EC,0x10A4784B,0x812A1A3A,0x1139F0CF,0x813EBD90,0x11CF516A,
0x815410D4,0x1264994E,0x816A13E6,0x12F9C7AA,0x8180C6A9,0x138EDBB1,0x819828FD,
0x1423D492,0x81B03AC2,0x14B8B17F,0x81C8FBD6,0x154D71AA,0x81E26C16,0x15E21445,
0x81FC8B60,0x1676987F,0x82175990,0x170AFD8D,0x8232D67F,0x179F429F,0x824F0208,
0x183366E9,0x826BDC04,0x18C7699B,0x8289644B,0x195B49EA,0x82A79AB3,0x19EF0707,
0x82C67F14,0x1A82A026,0x82E61141,0x1B161479,0x83065110,0x1BA96335,0x83273E52,
0x1C3C8B8C,0x8348D8DC,0x1CCF8CB3,0x836B207D,0x1D6265DD,0x838E1507,0x1DF5163F,
0x83B1B649,0x1E879D0D,0x83D60412,0x1F19F97B,0x83FAFE2E,0x1FAC2ABF,0x8420A46C,
0x203E300D,0x8446F695,0x20D0089C,0x846DF477,0x2161B3A0,0x84959DD9,0x21F3304F,
0x84BDF286,0x22847DE0,0x84E6F244,0x23159B88,0x85109CDD,0x23A6887F,0x853AF214,
0x243743FA,0x8565F1B0,0x24C7CD33,0x85919B76,0x2558235F,0x85BDEF28,0x25E845B6,
0x85EAEC88,0x26783370,0x86189359,0x2707EBC7,0x8646E35C,0x27976DF1,0x8675DC4F,
0x2826B928,0x86A57DF2,0x28B5CCA5,0x86D5C802,0x2944A7A2,0x8706BA3D,0x29D34958,
0x8738545E,0x2A61B101,0x876A9621,0x2AEFDDD8,0x879D7F41,0x2B7DCF17,0x87D10F75,
0x2C0B83FA,0x88054677,0x2C98FBBA,0x883A23FF,0x2D263596,0x886FA7C2,0x2DB330C7,
0x88A5D177,0x2E3FEC8B,0x88DCA0D3,0x2ECC681E,0x89141589,0x2F58A2BE,0x894C2F4C,
0x2FE49BA7,0x8984EDCF,0x30705217,0x89BE50C3,0x30FBC54D,0x89F857D8,0x3186F487,
0x8A3302BE,0x3211DF04,0x8A6E5123,0x329C8402,0x8AAA42B4,0x3326E2C3,0x8AE6D720,
0x33B0FA84,0x8B240E11,0x343ACA87,0x8B61E733,0x34C4520D,0x8BA0622F,0x354D9057,
0x8BDF7EB0,0x35D684A6,0x8C1F3C5D,0x365F2E3B,0x8C5F9ADE,0x36E78C5B,0x8CA099DA,
0x376F9E46,0x8CE238F6,0x37F76341,0x8D2477D8,0x387EDA8E,0x8D675623,0x39060373,
0x8DAAD37B,0x398CDD32,0x8DEEEF82,0x3A136712,0x8E33A9DA,0x3A99A057,0x8E790222,
0x3B1F8848,0x8EBEF7FB,0x3BA51E29,0x8F058B04,0x3C2A6142,0x8F4CBADB,0x3CAF50DA,
0x8F94871D,0x3D33EC39,0x8FDCEF66,0x3DB832A6,0x9025F352,0x3E3C2369,0x906F927C,
0x3EBFBDCD,0x90B9CC7D,0x3F430119,0x9104A0EE,0x3FC5EC98,0x91500F67,0x40487F94,
0x919C1781,0x40CAB958,0x91E8B8D0,0x414C992F,0x9235F2EC,0x41CE1E65,0x9283C568,
0x424F4845,0x92D22FD9,0x42D0161E,0x932131D1,0x4350873C,0x9370CAE4,0x43D09AED,
0x93C0FAA3,0x4450507E,0x9411C09E,0x44CFA740,0x94631C65,0x454E9E80,0x94B50D87,
0x45CD358F,0x95079394,0x464B6BBE,0x955AAE17,0x46C9405C,0x95AE5C9F,0x4746B2BC,
0x96029EB6,0x47C3C22F,0x965773E7,0x48406E08,0x96ACDBBE,0x48BCB599,0x9702D5C3,
0x49389836,0x9759617F,0x49B41533,0x97B07E7A,0x4A2F2BE6,0x98082C3B,0x4AA9DBA2,
0x98606A49,0x4B2423BE,0x98B93828,0x4B9E0390,0x9912955F,0x4C177A6E,0x996C816F,
0x4C9087B1,0x99C6FBDE,0x4D092AB0,0x9A22042D,0x4D8162C4,0x9A7D99DE,0x4DF92F46,
0x9AD9BC71,0x4E708F8F,0x9B366B68,0x4EE782FB,0x9B93A641,0x4F5E08E3,0x9BF16C7A,
0x4FD420A4,0x9C4FBD93,0x5049C999,0x9CAE9907,0x50BF031F,0x9D0DFE54,0x5133CC94,
0x9D6DECF4,0x51A82555,0x9DCE6463,0x521C0CC2,0x9E2F641B,0x528F8238,0x9E90EB94,
0x53028518,0x9EF2FA49,0x537514C2,0x9F558FB0,0x53E73097,0x9FB8AB41,0x5458D7F9,
0xA01C4C73,0x54CA0A4B,0xA08072BA,0x553AC6EE,0xA0E51D8C,0x55AB0D46,0xA14A4C5E,
0x561ADCB9,0xA1AFFEA3,0x568A34A9,0xA21633CD,0x56F9147E,0xA27CEB4F,0x57677B9D,
0xA2E4249B,0x57D5696D,0xA34BDF20,0x5842DD54,0xA3B41A50,0x58AFD6BD,0xA41CD599,
0x591C550E,0xA486106A,0x598857B2,0xA4EFCA31,0x59F3DE12,0xA55A025B,0x5A5EE79A,
0xA5C4B855,0x5AC973B5,0xA62FEB8B,0x5B3381CE,0xA69B9B68,0x5B9D1154,0xA707C757,
0x5C0621B2,0xA7746EC0,0x5C6EB258,0xA7E1910F,0x5CD6C2B5,0xA84F2DAA,0x5D3E5237,
0xA8BD43FA,0x5DA5604F,0xA92BD367,0x5E0BEC6E,0xA99ADB56,0x5E71F606,0xAA0A5B2E,
0x5ED77C8A,0xAA7A5253,0x5F3C7F6B,0xAAEAC02C,0x5FA0FE1F,0xAB5BA41A,0x6004F819,
0xABCCFD83,0x60686CCF,0xAC3ECBC7,0x60CB5BB7,0xACB10E4B,0x612DC447,0xAD23C46E,
0x618FA5F7,0xAD96ED92,0x61F1003F,0xAE0A8916,0x6251D298,0xAE7E965B,0x62B21C7B,
0xAEF314C0,0x6311DD64,0xAF6803A2,0x637114CC,0xAFDD625F,0x63CFC231,0xB0533055,
0x642DE50D,0xB0C96CE0,0x648B7CE0,0xB140175B,0x64E88926,0xB1B72F23,0x6545095F,
0xB22EB392,0x65A0FD0B,0xB2A6A402,0x65FC63A9,0xB31EFFCC,0x66573CBB,0xB397C649,
0x66B187C3,0xB410F6D3,0x670B4444,0xB48A90C0,0x676471C0,0xB5049368,0x67BD0FBD,
0xB57EFE22,0x68151DBE,0xB5F9D043,0x686C9B4B,0xB6750921,0x68C387E9,0xB6F0A812,
0x6919E320,0xB76CAC69,0x696FAC78,0xB7E9157A,0x69C4E37A,0xB865E299,0x6A1987B0,
0xB8E31319,0x6A6D98A4,0xB960A64C,0x6AC115E2,0xB9DE9B83,0x6B13FEF5,0xBA5CF210,
0x6B66536B,0xBADBA943,0x6BB812D1,0xBB5AC06D,0x6C093CB6,0xBBDA36DD,0x6C59D0A9,
0xBC5A0BE2,0x6CA9CE3B,0xBCDA3ECB,0x6CF934FC,0xBD5ACEE5,0x6D48047E,0xBDDBBB7F,
0x6D963C54,0xBE5D03E6,0x6DE3DC11,0xBEDEA765,0x6E30E34A,0xBF60A54A,0x6E7D5193,
0xBFE2FCDF,0x6EC92683,0xC065AD70,0x6F1461B0,0xC0E8B648,0x6F5F02B2,0xC16C16B0,
0x6FA90921,0xC1EFCDF3,0x6FF27497,0xC273DB58,0x703B44AD,0xC2F83E2A,0x708378FF,
0xC37CF5B0,0x70CB1128,0xC4020133,0x71120CC5,0xC4875FF9,0x71586B74,0xC50D1149,
0x719E2CD2,0xC593146A,0x71E35080,0xC61968A2,0x7227D61C,0xC6A00D37,0x726BBD48,
0xC727016D,0x72AF05A7,0xC7AE4489,0x72F1AED9,0xC835D5D0,0x7333B883,0xC8BDB485,
0x73752249,0xC945DFEC,0x73B5EBD1,0xC9CE5748,0x73F614C0,0xCA5719DB,0x74359CBD,
0xCAE026E8,0x74748371,0xCB697DB0,0x74B2C884,0xCBF31D75,0x74F06B9E,0xCC7D0578,
0x752D6C6C,0xCD0734F9,0x7569CA99,0xCD91AB39,0x75A585CF,0xCE1C6777,0x75E09DBD,
0xCEA768F2,0x761B1211,0xCF32AEEB,0x7654E279,0xCFBE389F,0x768E0EA6,0xD04A054E,
0x76C69647,0xD0D61434,0x76FE790E,0xD1626490,0x7735B6AF,0xD1EEF59E,0x776C4EDB,
0xD27BC69C,0x77A24148,0xD308D6C7,0x77D78DAA,0xD396255A,0x780C33B8,0xD423B191,
0x78403329,0xD4B17AA8,0x78738BB3,0xD53F7FDA,0x78A63D11,0xD5CDC062,0x78D846FB,
0xD65C3B7B,0x7909A92D,0xD6EAF05F,0x793A6361,0xD779DE47,0x796A7554,0xD809046E,
0x7999DEC4,0xD898620C,0x79C89F6E,0xD927F65B,0x79F6B711,0xD9B7C094,0x7A24256F,
0xDA47BFEE,0x7A50EA47,0xDAD7F3A2,0x7A7D055B,0xDB685AE9,0x7AA8766F,0xDBF8F4F8,
0x7AD33D45,0xDC89C109,0x7AFD59A4,0xDD1ABE51,0x7B26CB4F,0xDDABEC08,0x7B4F920E,
0xDE3D4964,0x7B77ADA8,0xDECED59B,0x7B9F1DE6,0xDF608FE4,0x7BC5E290,0xDFF27773,
0x7BEBFB70,0xE0848B7F,0x7C116853,0xE116CB3D,0x7C362904,0xE1A935E2,0x7C5A3D50,
0xE23BCAA2,0x7C7DA505,0xE2CE88B3,0x7CA05FF1,0xE3616F48,0x7CC26DE5,0xE3F47D96,
0x7CE3CEB2,0xE487B2D0,0x7D048228,0xE51B0E2A,0x7D24881B,0xE5AE8ED8,0x7D43E05E,
0xE642340D,0x7D628AC6,0xE6D5FCFC,0x7D808728,0xE769E8D8,0x7D9DD55A,0xE7FDF6D4,
0x7DBA7534,0xE8922622,0x7DD6668F,0xE92675F4,0x7DF1A942,0xE9BAE57D,0x7E0C3D29,
0xEA4F73EE,0x7E26221F,0xEAE4207A,0x7E3F57FF,0xEB78EA52,0x7E57DEA7,0xEC0DD0A8,
0x7E6FB5F4,0xECA2D2AD,0x7E86DDC6,0xED37EF91,0x7E9D55FC,0xEDCD2687,0x7EB31E78,
0xEE6276BF,0x7EC8371A,0xEEF7DF6A,0x7EDC9FC6,0xEF8D5FB8,0x7EF05860,0xF022F6DA,
0x7F0360CB,0xF0B8A401,0x7F15B8EE,0xF14E665C,0x7F2760AF,0xF1E43D1C,0x7F3857F6,
0xF27A2771,0x7F489EAA,0xF310248A,0x7F5834B7,0xF3A63398,0x7F671A05,0xF43C53CB,
0x7F754E80,0xF4D28451,0x7F82D214,0xF568C45B,0x7F8FA4B0,0xF5FF1318,0x7F9BC640,
0xF6956FB7,0x7FA736B4,0xF72BD967,0x7FB1F5FC,0xF7C24F59,0x7FBC040A,0xF858D0BB,
0x7FC560CF,0xF8EF5CBB,0x7FCE0C3E,0xF985F28A,0x7FD6064C,0xFA1C9157,0x7FDD4EEC,
0xFAB3384F,0x7FE3E616,0xFB49E6A3,0x7FE9CBC0,0xFBE09B80,0x7FEEFFE1,0xFC775616,
0x7FF38274,0xFD0E1594,0x7FF75370,0xFDA4D929,0x7FFA72D1,0xFE3BA002,0x7FFCE093,
0xFED2694F,0x7FFE9CB2,0xFF69343F,0x7FFFA72C,0x7FFFFFFF,0x00000000,0x7FFA72D1,
0xFDA4D929,0x7FE9CBC0,0xFB49E6A3,0x7FCE0C3E,0xF8EF5CBB,0x7FA736B4,0xF6956FB7,
0x7F754E80,0xF43C53CB,0x7F3857F6,0xF1E43D1C,0x7EF05860,0xEF8D5FB8,0x7E9D55FC,
0xED37EF91,0x7E3F57FF,0xEAE4207A,0x7DD6668F,0xE8922622,0x7D628AC6,0xE642340D,
0x7CE3CEB2,0xE3F47D96,0x7C5A3D50,0xE1A935E2,0x7BC5E290,0xDF608FE4,0x7B26CB4F,
0xDD1ABE51,0x7A7D055B,0xDAD7F3A2,0x79C89F6E,0xD898620C,0x7909A92D,0xD65C3B7B,
0x78403329,0xD423B191,0x776C4EDB,0xD1EEF59E,0x768E0EA6,0xCFBE389F,0x75A585CF,
0xCD91AB39,0x74B2C884,0xCB697DB0,0x73B5EBD1,0xC945DFEC,0x72AF05A7,0xC727016D,
0x719E2CD2,0xC50D1149,0x708378FF,0xC2F83E2A,0x6F5F02B2,0xC0E8B648,0x6E30E34A,
0xBEDEA765,0x6CF934FC,0xBCDA3ECB,0x6BB812D1,0xBADBA943,0x6A6D98A4,0xB8E31319,
0x6919E320,0xB6F0A812,0x67BD0FBD,0xB5049368,0x66573CBB,0xB31EFFCC,0x64E88926,
0xB140175B,0x637114CC,0xAF6803A2,0x61F1003F,0xAD96ED92,0x60686CCF,0xABCCFD83,
0x5ED77C8A,0xAA0A5B2E,0x5D3E5237,0xA84F2DAA,0x5B9D1154,0xA69B9B68,0x59F3DE12,
0xA4EFCA31,0x5842DD54,0xA34BDF20,0x568A34A9,0xA1AFFEA3,0x54CA0A4B,0xA01C4C73,
0x53028518,0x9E90EB94,0x5133CC94,0x9D0DFE54,0x4F5E08E3,0x9B93A641,0x4D8162C4,
0x9A22042D,0x4B9E0390,0x98B93828,0x49B41533,0x9759617F,0x47C3C22F,0x96029EB6,
0x45CD358F,0x94B50D87,0x43D09AED,0x9370CAE4,0x41CE1E65,0x9235F2EC,0x3FC5EC98,
0x9104A0EE,0x3DB832A6,0x8FDCEF66,0x3BA51E29,0x8EBEF7FB,0x398CDD32,0x8DAAD37B,
0x376F9E46,0x8CA099DA,0x354D9057,0x8BA0622F,0x3326E2C3,0x8AAA42B4,0x30FBC54D,
0x89BE50C3,0x2ECC681E,0x88DCA0D3,0x2C98FBBA,0x88054677,0x2A61B101,0x8738545E,
0x2826B928,0x8675DC4F,0x25E845B6,0x85BDEF28,0x23A6887F,0x85109CDD,0x2161B3A0,
0x846DF477,0x1F19F97B,0x83D60412,0x1CCF8CB3,0x8348D8DC,0x1A82A026,0x82C67F14,
0x183366E9,0x824F0208,0x15E21445,0x81E26C16,0x138EDBB1,0x8180C6A9,0x1139F0CF,
0x812A1A3A,0x0EE38766,0x80DE6E4C,0x0C8BD35E,0x809DC971,0x0A3308BD,0x80683143,
0x07D95B9E,0x803DAA6A,0x057F0035,0x801E3895,0x03242ABF,0x8009DE7E,0x00C90F88,
0x80009DEA,0xFE6DE2E0,0x800277A6,0xFC12D91A,0x800F6B88,0xF9B82684,0x80277872,
0xF75DFF66,0x804A9C4D,0xF50497FB,0x8078D40D,0xF2AC246E,0x80B21BAF,0xF054D8D5,
0x80F66E3C,0xEDFEE92B,0x8145C5C7,0xEBAA894F,0x81A01B6D,0xE957ECFB,0x82056758,
0xE70747C4,0x8275A0C0,0xE4B8CD11,0x82F0BDE8,0xE26CB01B,0x8376B422,0xE02323E5,
0x840777D0,0xDDDC5B3B,0x84A2FC62,0xDB9888A8,0x8549345C,0xD957DE7A,0x85FA1153,
0xD71A8EB5,0x86B583EE,0xD4E0CB15,0x877B7BEC,0xD2AAC504,0x884BE821,0xD078AD9E,
0x8926B677,0xCE4AB5A2,0x8A0BD3F5,0xCC210D79,0x8AFB2CBB,0xC9FBE527,0x8BF4AC05,
0xC7DB6C50,0x8CF83C30,0xC5BFD22E,0x8E05C6B7,0xC3A94590,0x8F1D343A,0xC197F4D4,
0x903E6C7B,0xBF8C0DE3,0x91695663,0xBD85BE30,0x929DD806,0xBB8532B0,0x93DBD6A0,
0xB98A97D8,0x9523369C,0xB796199B,0x9673DB94,0xB5A7E362,0x97CDA855,0xB3C0200C,
0x99307EE0,0xB1DEF9E9,0x9A9C406E,0xB0049AB3,0x9C10CD70,0xAE312B92,0x9D8E0597,
0xAC64D510,0x9F13C7D0,0xAA9FBF1E,0xA0A1F24D,0xA8E21106,0xA2386284,0xA72BF174,
0xA3D6F534,0xA57D8666,0xA57D8666,0xA3D6F534,0xA72BF174,0xA2386284,0xA8E21106,
0xA0A1F24D,0xAA9FBF1E,0x9F13C7D0,0xAC64D510,0x9D8E0597,0xAE312B92,0x9C10CD70,
0xB0049AB3,0x9A9C406E,0xB1DEF9E9,0x99307EE0,0xB3C0200C,0x97CDA855,0xB5A7E362,
0x9673DB94,0xB796199B,0x9523369C,0xB98A97D8,0x93DBD6A0,0xBB8532B0,0x929DD806,
0xBD85BE30,0x91695663,0xBF8C0DE3,0x903E6C7B,0xC197F4D4,0x8F1D343A,0xC3A94590,
0x8E05C6B7,0xC5BFD22E,0x8CF83C30,0xC7DB6C50,0x8BF4AC05,0xC9FBE527,0x8AFB2CBB,
0xCC210D79,0x8A0BD3F5,0xCE4AB5A2,0x8926B677,0xD078AD9E,0x884BE821,0xD2AAC504,
0x877B7BEC,0xD4E0CB15,0x86B583EE,0xD71A8EB5,0x85FA1153,0xD957DE7A,0x8549345C,
0xDB9888A8,0x84A2FC62,0xDDDC5B3B,0x840777D0,0xE02323E5,0x8376B422,0xE26CB01B,
0x82F0BDE8,0xE4B8CD11,0x8275A0C0,0xE70747C4,0x82056758,0xE957ECFB,0x81A01B6D,
0xEBAA894F,0x8145C5C7,0xEDFEE92B,0x80F66E3C,0xF054D8D5,0x80B21BAF,0xF2AC246E,
0x8078D40D,0xF50497FB,0x804A9C4D,0xF75DFF66,0x80277872,0xF9B82684,0x800F6B88,
0xFC12D91A,0x800277A6,0xFE6DE2E0,0x80009DEA,0x00C90F88,0x8009DE7E,0x03242ABF,
0x801E3895,0x057F0035,0x803DAA6A,0x07D95B9E,0x80683143,0x0A3308BD,0x809DC971,
0x0C8BD35E,0x80DE6E4C,0x0EE38766,0x812A1A3A,0x1139F0CF,0x8180C6A9,0x138EDBB1,
0x81E26C16,0x15E21445,0x824F0208,0x183366E9,0x82C67F14,0x1A82A026,0x8348D8DC,
0x1CCF8CB3,0x83D60412,0x1F19F97B,0x846DF477,0x2161B3A0,0x85109CDD,0x23A6887F,
0x85BDEF28,0x25E845B6,0x8675DC4F,0x2826B928,0x8738545E,0x2A61B101,0x88054677,
0x2C98FBBA,0x88DCA0D3,0x2ECC681E,0x89BE50C3,0x30FBC54D,0x8AAA42B4,0x3326E2C3,
0x8BA0622F,0x354D9057,0x8CA099DA,0x376F9E46,0x8DAAD37B,0x398CDD32,0x8EBEF7FB,
0x3BA51E29,0x8FDCEF66,0x3DB832A6,0x9104A0EE,0x3FC5EC98,0x9235F2EC,0x41CE1E65,
0x9370CAE4,0x43D09AED,0x94B50D87,0x45CD358F,0x96029EB6,0x47C3C22F,0x9759617F,
0x49B41533,0x98B93828,0x4B9E0390,0x9A22042D,0x4D8162C4,0x9B93A641,0x4F5E08E3,
0x9D0DFE54,0x5133CC94,0x9E90EB94,0x53028518,0xA01C4C73,0x54CA0A4B,0xA1AFFEA3,
0x568A34A9,0xA34BDF20,0x5842DD54,0xA4EFCA31,0x59F3DE12,0xA69B9B68,0x5B9D1154,
0xA84F2DAA,0x5D3E5237,0xAA0A5B2E,0x5ED77C8A,0xABCCFD83,0x60686CCF,0xAD96ED92,
0x61F1003F,0xAF6803A2,0x637114CC,0xB140175B,0x64E88926,0xB31EFFCC,0x66573CBB,
0xB5049368,0x67BD0FBD,0xB6F0A812,0x6919E320,0xB8E31319,0x6A6D98A4,0xBADBA943,
0x6BB812D1,0xBCDA3ECB,0x6CF934FC,0xBEDEA765,0x6E30E34A,0xC0E8B648,0x6F5F02B2,
0xC2F83E2A,0x708378FF,0xC50D1149,0x719E2CD2,0xC727016D,0x72AF05A7,0xC945DFEC,
0x73B5EBD1,0xCB697DB0,0x74B2C884,0xCD91AB39,0x75A585CF,0xCFBE389F,0x768E0EA6,
0xD1EEF59E,0x776C4EDB,0xD423B191,0x78403329,0xD65C3B7B,0x7909A92D,0xD898620C,
0x79C89F6E,0xDAD7F3A2,0x7A7D055B,0xDD1ABE51,0x7B26CB4F,0xDF608FE4,0x7BC5E290,
0xE1A935E2,0x7C5A3D50,0xE3F47D96,0x7CE3CEB2,0xE642340D,0x7D628AC6,0xE8922622,
0x7DD6668F,0xEAE4207A,0x7E3F57FF,0xED37EF91,0x7E9D55FC,0xEF8D5FB8,0x7EF05860,
0xF1E43D1C,0x7F3857F6,0xF43C53CB,0x7F754E80,0xF6956FB7,0x7FA736B4,0xF8EF5CBB,
0x7FCE0C3E,0xFB49E6A3,0x7FE9CBC0,0xFDA4D929,0x7FFA72D1,0x7FFFFFFF,0x00000000,
0x7FA736B4,0xF6956FB7,0x7E9D55FC,0xED37EF91,0x7CE3CEB2,0xE3F47D96,0x7A7D055B,
0xDAD7F3A2,0x776C4EDB,0xD1EEF59E,0x73B5EBD1,0xC945DFEC,0x6F5F02B2,0xC0E8B648,
0x6A6D98A4,0xB8E31319,0x64E88926,0xB140175B,0x5ED77C8A,0xAA0A5B2E,0x5842DD54,
0xA34BDF20,0x5133CC94,0x9D0DFE54,0x49B41533,0x9759617F,0x41CE1E65,0x9235F2EC,
0x398CDD32,0x8DAAD37B,0x30FBC54D,0x89BE50C3,0x2826B928,0x8675DC4F,0x1F19F97B,
0x83D60412,0x15E21445,0x81E26C16,0x0C8BD35E,0x809DC971,0x03242ABF,0x8009DE7E,
0xF9B82684,0x80277872,0xF054D8D5,0x80F66E3C,0xE70747C4,0x8275A0C0,0xDDDC5B3B,
0x84A2FC62,0xD4E0CB15,0x877B7BEC,0xCC210D79,0x8AFB2CBB,0xC3A94590,0x8F1D343A,
0xBB8532B0,0x93DBD6A0,0xB3C0200C,0x99307EE0,0xAC64D510,0x9F13C7D0,0xA57D8666,
0xA57D8666,0x9F13C7D0,0xAC64D510,0x99307EE0,0xB3C0200C,0x93DBD6A0,0xBB8532B0,
0x8F1D343A,0xC3A94590,0x8AFB2CBB,0xCC210D79,0x877B7BEC,0xD4E0CB15,0x84A2FC62,
0xDDDC5B3B,0x8275A0C0,0xE70747C4,0x80F66E3C,0xF054D8D5,0x80277872,0xF9B82684,
0x8009DE7E,0x03242ABF,0x809DC971,0x0C8BD35E,0x81E26C16,0x15E21445,0x83D60412,
0x1F19F97B,0x8675DC4F,0x2826B928,0x89BE50C3,0x30FBC54D,0x8DAAD37B,0x398CDD32,
0x9235F2EC,0x41CE1E65,0x9759617F,0x49B41533,0x9D0DFE54,0x5133CC94,0xA34BDF20,
0x5842DD54,0xAA0A5B2E,0x5ED77C8A,0xB140175B,0x64E88926,0xB8E31319,0x6A6D98A4,
0xC0E8B648,0x6F5F02B2,0xC945DFEC,0x73B5EBD1,0xD1EEF59E,0x776C4EDB,0xDAD7F3A2,
0x7A7D055B,0xE3F47D96,0x7CE3CEB2,0xED37EF91,0x7E9D55FC,0xF6956FB7,0x7FA736B4,
0x7FFFFFFF,0x00000000,0x7A7D055B,0xDAD7F3A2,0x6A6D98A4,0xB8E31319,0x5133CC94,
0x9D0DFE54,0x30FBC54D,0x89BE50C3,0x0C8BD35E,0x809DC971,0xE70747C4,0x8275A0C0,
0xC3A94590,0x8F1D343A,0xA57D8666,0xA57D8666,0x8F1D343A,0xC3A94590,0x8275A0C0,
0xE70747C4,0x809DC971,0x0C8BD35E,0x89BE50C3,0x30FBC54D,0x9D0DFE54,0x5133CC94,
0xB8E31319,0x6A6D98A4,0xDAD7F3A2,0x7A7D055B,0x7FFFFFFF,0x00000000,0x30FBC54D,
0x89BE50C3,0xA57D8666,0xA57D8666,0x89BE50C3,0x30FBC54D,};

#endif



#endif /* !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES) */
#endif /* defined(ARM_MATH_MVEI)  */

#include "arm_math.h"

#if defined(ARM_MATH_MVEI)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q15_16) || defined(ARM_TABLE_TWIDDLECOEF_Q15_32)

uint32_t rearranged_twiddle_tab_stride1_arr_16_q15[2]={
0,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_16_q15[2]={
0,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_16_q15[2]={
0,0,};

q15_t rearranged_twiddle_stride1_16_q15[8]={
0x7FFF,0x0000,0x7642,0xCF04,0x5A82,0xA57E,0x30FC,0x89BE,};

q15_t rearranged_twiddle_stride2_16_q15[8]={
0x7FFF,0x0000,0x5A82,0xA57E,0x0000,0x8000,0xA57E,0xA57E,};

q15_t rearranged_twiddle_stride3_16_q15[8]={
0x7FFF,0x0000,0x30FC,0x89BE,0xA57E,0xA57E,0x89BE,0x30FC,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q15_64) || defined(ARM_TABLE_TWIDDLECOEF_Q15_128)

uint32_t rearranged_twiddle_tab_stride1_arr_64_q15[3]={
0,32,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_64_q15[3]={
0,32,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_64_q15[3]={
0,32,0,};

q15_t rearranged_twiddle_stride1_64_q15[40]={
0x7FFF,0x0000,0x7F62,0xF374,0x7D8A,0xE707,0x7A7D,0xDAD8,0x7642,0xCF04,0x70E3,
0xC3A9,0x6A6E,0xB8E3,0x62F2,0xAECC,0x5A82,0xA57E,0x5134,0x9D0E,0x471D,0x9592,
0x3C57,0x8F1D,0x30FC,0x89BE,0x2528,0x8583,0x18F9,0x8276,0x0C8C,0x809E,0x7FFF,
0x0000,0x7642,0xCF04,0x5A82,0xA57E,0x30FC,0x89BE,};

q15_t rearranged_twiddle_stride2_64_q15[40]={
0x7FFF,0x0000,0x7D8A,0xE707,0x7642,0xCF04,0x6A6E,0xB8E3,0x5A82,0xA57E,0x471D,
0x9592,0x30FC,0x89BE,0x18F9,0x8276,0x0000,0x8000,0xE707,0x8276,0xCF04,0x89BE,
0xB8E3,0x9592,0xA57E,0xA57E,0x9592,0xB8E3,0x89BE,0xCF04,0x8276,0xE707,0x7FFF,
0x0000,0x5A82,0xA57E,0x0000,0x8000,0xA57E,0xA57E,};

q15_t rearranged_twiddle_stride3_64_q15[40]={
0x7FFF,0x0000,0x7A7D,0xDAD8,0x6A6E,0xB8E3,0x5134,0x9D0E,0x30FC,0x89BE,0x0C8C,
0x809E,0xE707,0x8276,0xC3A9,0x8F1D,0xA57E,0xA57E,0x8F1D,0xC3A9,0x8276,0xE707,
0x809E,0x0C8C,0x89BE,0x30FC,0x9D0E,0x5134,0xB8E3,0x6A6E,0xDAD8,0x7A7D,0x7FFF,
0x0000,0x30FC,0x89BE,0xA57E,0xA57E,0x89BE,0x30FC,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q15_256) || defined(ARM_TABLE_TWIDDLECOEF_Q15_512)

uint32_t rearranged_twiddle_tab_stride1_arr_256_q15[4]={
0,128,160,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_256_q15[4]={
0,128,160,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_256_q15[4]={
0,128,160,0,};

q15_t rearranged_twiddle_stride1_256_q15[168]={
0x7FFF,0x0000,0x7FF6,0xFCDC,0x7FD9,0xF9B8,0x7FA7,0xF695,0x7F62,0xF374,0x7F0A,
0xF055,0x7E9D,0xED38,0x7E1E,0xEA1E,0x7D8A,0xE707,0x7CE4,0xE3F4,0x7C2A,0xE0E6,
0x7B5D,0xDDDC,0x7A7D,0xDAD8,0x798A,0xD7D9,0x7885,0xD4E1,0x776C,0xD1EF,0x7642,
0xCF04,0x7505,0xCC21,0x73B6,0xC946,0x7255,0xC673,0x70E3,0xC3A9,0x6F5F,0xC0E9,
0x6DCA,0xBE32,0x6C24,0xBB85,0x6A6E,0xB8E3,0x68A7,0xB64C,0x66D0,0xB3C0,0x64E9,
0xB140,0x62F2,0xAECC,0x60EC,0xAC65,0x5ED7,0xAA0A,0x5CB4,0xA7BD,0x5A82,0xA57E,
0x5843,0xA34C,0x55F6,0xA129,0x539B,0x9F14,0x5134,0x9D0E,0x4EC0,0x9B17,0x4C40,
0x9930,0x49B4,0x9759,0x471D,0x9592,0x447B,0x93DC,0x41CE,0x9236,0x3F17,0x90A1,
0x3C57,0x8F1D,0x398D,0x8DAB,0x36BA,0x8C4A,0x33DF,0x8AFB,0x30FC,0x89BE,0x2E11,
0x8894,0x2B1F,0x877B,0x2827,0x8676,0x2528,0x8583,0x2224,0x84A3,0x1F1A,0x83D6,
0x1C0C,0x831C,0x18F9,0x8276,0x15E2,0x81E2,0x12C8,0x8163,0x0FAB,0x80F6,0x0C8C,
0x809E,0x096B,0x8059,0x0648,0x8027,0x0324,0x800A,0x7FFF,0x0000,0x7F62,0xF374,
0x7D8A,0xE707,0x7A7D,0xDAD8,0x7642,0xCF04,0x70E3,0xC3A9,0x6A6E,0xB8E3,0x62F2,
0xAECC,0x5A82,0xA57E,0x5134,0x9D0E,0x471D,0x9592,0x3C57,0x8F1D,0x30FC,0x89BE,
0x2528,0x8583,0x18F9,0x8276,0x0C8C,0x809E,0x7FFF,0x0000,0x7642,0xCF04,0x5A82,
0xA57E,0x30FC,0x89BE,};

q15_t rearranged_twiddle_stride2_256_q15[168]={
0x7FFF,0x0000,0x7FD9,0xF9B8,0x7F62,0xF374,0x7E9D,0xED38,0x7D8A,0xE707,0x7C2A,
0xE0E6,0x7A7D,0xDAD8,0x7885,0xD4E1,0x7642,0xCF04,0x73B6,0xC946,0x70E3,0xC3A9,
0x6DCA,0xBE32,0x6A6E,0xB8E3,0x66D0,0xB3C0,0x62F2,0xAECC,0x5ED7,0xAA0A,0x5A82,
0xA57E,0x55F6,0xA129,0x5134,0x9D0E,0x4C40,0x9930,0x471D,0x9592,0x41CE,0x9236,
0x3C57,0x8F1D,0x36BA,0x8C4A,0x30FC,0x89BE,0x2B1F,0x877B,0x2528,0x8583,0x1F1A,
0x83D6,0x18F9,0x8276,0x12C8,0x8163,0x0C8C,0x809E,0x0648,0x8027,0x0000,0x8000,
0xF9B8,0x8027,0xF374,0x809E,0xED38,0x8163,0xE707,0x8276,0xE0E6,0x83D6,0xDAD8,
0x8583,0xD4E1,0x877B,0xCF04,0x89BE,0xC946,0x8C4A,0xC3A9,0x8F1D,0xBE32,0x9236,
0xB8E3,0x9592,0xB3C0,0x9930,0xAECC,0x9D0E,0xAA0A,0xA129,0xA57E,0xA57E,0xA129,
0xAA0A,0x9D0E,0xAECC,0x9930,0xB3C0,0x9592,0xB8E3,0x9236,0xBE32,0x8F1D,0xC3A9,
0x8C4A,0xC946,0x89BE,0xCF04,0x877B,0xD4E1,0x8583,0xDAD8,0x83D6,0xE0E6,0x8276,
0xE707,0x8163,0xED38,0x809E,0xF374,0x8027,0xF9B8,0x7FFF,0x0000,0x7D8A,0xE707,
0x7642,0xCF04,0x6A6E,0xB8E3,0x5A82,0xA57E,0x471D,0x9592,0x30FC,0x89BE,0x18F9,
0x8276,0x0000,0x8000,0xE707,0x8276,0xCF04,0x89BE,0xB8E3,0x9592,0xA57E,0xA57E,
0x9592,0xB8E3,0x89BE,0xCF04,0x8276,0xE707,0x7FFF,0x0000,0x5A82,0xA57E,0x0000,
0x8000,0xA57E,0xA57E,};

q15_t rearranged_twiddle_stride3_256_q15[168]={
0x7FFF,0x0000,0x7FA7,0xF695,0x7E9D,0xED38,0x7CE4,0xE3F4,0x7A7D,0xDAD8,0x776C,
0xD1EF,0x73B6,0xC946,0x6F5F,0xC0E9,0x6A6E,0xB8E3,0x64E9,0xB140,0x5ED7,0xAA0A,
0x5843,0xA34C,0x5134,0x9D0E,0x49B4,0x9759,0x41CE,0x9236,0x398D,0x8DAB,0x30FC,
0x89BE,0x2827,0x8676,0x1F1A,0x83D6,0x15E2,0x81E2,0x0C8C,0x809E,0x0324,0x800A,
0xF9B8,0x8027,0xF055,0x80F6,0xE707,0x8276,0xDDDC,0x84A3,0xD4E1,0x877B,0xCC21,
0x8AFB,0xC3A9,0x8F1D,0xBB85,0x93DC,0xB3C0,0x9930,0xAC65,0x9F14,0xA57E,0xA57E,
0x9F14,0xAC65,0x9930,0xB3C0,0x93DC,0xBB85,0x8F1D,0xC3A9,0x8AFB,0xCC21,0x877B,
0xD4E1,0x84A3,0xDDDC,0x8276,0xE707,0x80F6,0xF055,0x8027,0xF9B8,0x800A,0x0324,
0x809E,0x0C8C,0x81E2,0x15E2,0x83D6,0x1F1A,0x8676,0x2827,0x89BE,0x30FC,0x8DAB,
0x398D,0x9236,0x41CE,0x9759,0x49B4,0x9D0E,0x5134,0xA34C,0x5843,0xAA0A,0x5ED7,
0xB140,0x64E9,0xB8E3,0x6A6E,0xC0E9,0x6F5F,0xC946,0x73B6,0xD1EF,0x776C,0xDAD8,
0x7A7D,0xE3F4,0x7CE4,0xED38,0x7E9D,0xF695,0x7FA7,0x7FFF,0x0000,0x7A7D,0xDAD8,
0x6A6E,0xB8E3,0x5134,0x9D0E,0x30FC,0x89BE,0x0C8C,0x809E,0xE707,0x8276,0xC3A9,
0x8F1D,0xA57E,0xA57E,0x8F1D,0xC3A9,0x8276,0xE707,0x809E,0x0C8C,0x89BE,0x30FC,
0x9D0E,0x5134,0xB8E3,0x6A6E,0xDAD8,0x7A7D,0x7FFF,0x0000,0x30FC,0x89BE,0xA57E,
0xA57E,0x89BE,0x30FC,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q15_1024) || defined(ARM_TABLE_TWIDDLECOEF_Q15_2048)

uint32_t rearranged_twiddle_tab_stride1_arr_1024_q15[5]={
0,512,640,672,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_1024_q15[5]={
0,512,640,672,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_1024_q15[5]={
0,512,640,672,0,};

q15_t rearranged_twiddle_stride1_1024_q15[680]={
0x7FFF,0x0000,0x7FFF,0xFF37,0x7FFE,0xFE6E,0x7FFA,0xFDA5,0x7FF6,0xFCDC,0x7FF1,
0xFC13,0x7FEA,0xFB4A,0x7FE2,0xFA81,0x7FD9,0xF9B8,0x7FCE,0xF8EF,0x7FC2,0xF827,
0x7FB5,0xF75E,0x7FA7,0xF695,0x7F98,0xF5CD,0x7F87,0xF505,0x7F75,0xF43C,0x7F62,
0xF374,0x7F4E,0xF2AC,0x7F38,0xF1E4,0x7F22,0xF11C,0x7F0A,0xF055,0x7EF0,0xEF8D,
0x7ED6,0xEEC6,0x7EBA,0xEDFF,0x7E9D,0xED38,0x7E7F,0xEC71,0x7E60,0xEBAB,0x7E3F,
0xEAE4,0x7E1E,0xEA1E,0x7DFB,0xE958,0x7DD6,0xE892,0x7DB1,0xE7CD,0x7D8A,0xE707,
0x7D63,0xE642,0x7D3A,0xE57D,0x7D0F,0xE4B9,0x7CE4,0xE3F4,0x7CB7,0xE330,0x7C89,
0xE26D,0x7C5A,0xE1A9,0x7C2A,0xE0E6,0x7BF9,0xE023,0x7BC6,0xDF61,0x7B92,0xDE9E,
0x7B5D,0xDDDC,0x7B27,0xDD1B,0x7AEF,0xDC59,0x7AB7,0xDB99,0x7A7D,0xDAD8,0x7A42,
0xDA18,0x7A06,0xD958,0x79C9,0xD898,0x798A,0xD7D9,0x794A,0xD71B,0x790A,0xD65C,
0x78C8,0xD59E,0x7885,0xD4E1,0x7840,0xD424,0x77FB,0xD367,0x77B4,0xD2AB,0x776C,
0xD1EF,0x7723,0xD134,0x76D9,0xD079,0x768E,0xCFBE,0x7642,0xCF04,0x75F4,0xCE4B,
0x75A6,0xCD92,0x7556,0xCCD9,0x7505,0xCC21,0x74B3,0xCB69,0x7460,0xCAB2,0x740B,
0xC9FC,0x73B6,0xC946,0x735F,0xC890,0x7308,0xC7DB,0x72AF,0xC727,0x7255,0xC673,
0x71FA,0xC5C0,0x719E,0xC50D,0x7141,0xC45B,0x70E3,0xC3A9,0x7083,0xC2F8,0x7023,
0xC248,0x6FC2,0xC198,0x6F5F,0xC0E9,0x6EFB,0xC03A,0x6E97,0xBF8C,0x6E31,0xBEDF,
0x6DCA,0xBE32,0x6D62,0xBD86,0x6CF9,0xBCDA,0x6C8F,0xBC2F,0x6C24,0xBB85,0x6BB8,
0xBADC,0x6B4B,0xBA33,0x6ADD,0xB98B,0x6A6E,0xB8E3,0x69FD,0xB83C,0x698C,0xB796,
0x691A,0xB6F1,0x68A7,0xB64C,0x6832,0xB5A8,0x67BD,0xB505,0x6747,0xB462,0x66D0,
0xB3C0,0x6657,0xB31F,0x65DE,0xB27F,0x6564,0xB1DF,0x64E9,0xB140,0x646C,0xB0A2,
0x63EF,0xB005,0x6371,0xAF68,0x62F2,0xAECC,0x6272,0xAE31,0x61F1,0xAD97,0x616F,
0xACFD,0x60EC,0xAC65,0x6068,0xABCD,0x5FE4,0xAB36,0x5F5E,0xAAA0,0x5ED7,0xAA0A,
0x5E50,0xA976,0x5DC8,0xA8E2,0x5D3E,0xA84F,0x5CB4,0xA7BD,0x5C29,0xA72C,0x5B9D,
0xA69C,0x5B10,0xA60C,0x5A82,0xA57E,0x59F4,0xA4F0,0x5964,0xA463,0x58D4,0xA3D7,
0x5843,0xA34C,0x57B1,0xA2C2,0x571E,0xA238,0x568A,0xA1B0,0x55F6,0xA129,0x5560,
0xA0A2,0x54CA,0xA01C,0x5433,0x9F98,0x539B,0x9F14,0x5303,0x9E91,0x5269,0x9E0F,
0x51CF,0x9D8E,0x5134,0x9D0E,0x5098,0x9C8F,0x4FFB,0x9C11,0x4F5E,0x9B94,0x4EC0,
0x9B17,0x4E21,0x9A9C,0x4D81,0x9A22,0x4CE1,0x99A9,0x4C40,0x9930,0x4B9E,0x98B9,
0x4AFB,0x9843,0x4A58,0x97CE,0x49B4,0x9759,0x490F,0x96E6,0x486A,0x9674,0x47C4,
0x9603,0x471D,0x9592,0x4675,0x9523,0x45CD,0x94B5,0x4524,0x9448,0x447B,0x93DC,
0x43D1,0x9371,0x4326,0x9307,0x427A,0x929E,0x41CE,0x9236,0x4121,0x91CF,0x4074,
0x9169,0x3FC6,0x9105,0x3F17,0x90A1,0x3E68,0x903E,0x3DB8,0x8FDD,0x3D08,0x8F7D,
0x3C57,0x8F1D,0x3BA5,0x8EBF,0x3AF3,0x8E62,0x3A40,0x8E06,0x398D,0x8DAB,0x38D9,
0x8D51,0x3825,0x8CF8,0x3770,0x8CA1,0x36BA,0x8C4A,0x3604,0x8BF5,0x354E,0x8BA0,
0x3497,0x8B4D,0x33DF,0x8AFB,0x3327,0x8AAA,0x326E,0x8A5A,0x31B5,0x8A0C,0x30FC,
0x89BE,0x3042,0x8972,0x2F87,0x8927,0x2ECC,0x88DD,0x2E11,0x8894,0x2D55,0x884C,
0x2C99,0x8805,0x2BDC,0x87C0,0x2B1F,0x877B,0x2A62,0x8738,0x29A4,0x86F6,0x28E5,
0x86B6,0x2827,0x8676,0x2768,0x8637,0x26A8,0x85FA,0x25E8,0x85BE,0x2528,0x8583,
0x2467,0x8549,0x23A7,0x8511,0x22E5,0x84D9,0x2224,0x84A3,0x2162,0x846E,0x209F,
0x843A,0x1FDD,0x8407,0x1F1A,0x83D6,0x1E57,0x83A6,0x1D93,0x8377,0x1CD0,0x8349,
0x1C0C,0x831C,0x1B47,0x82F1,0x1A83,0x82C6,0x19BE,0x829D,0x18F9,0x8276,0x1833,
0x824F,0x176E,0x822A,0x16A8,0x8205,0x15E2,0x81E2,0x151C,0x81C1,0x1455,0x81A0,
0x138F,0x8181,0x12C8,0x8163,0x1201,0x8146,0x113A,0x812A,0x1073,0x8110,0x0FAB,
0x80F6,0x0EE4,0x80DE,0x0E1C,0x80C8,0x0D54,0x80B2,0x0C8C,0x809E,0x0BC4,0x808B,
0x0AFB,0x8079,0x0A33,0x8068,0x096B,0x8059,0x08A2,0x804B,0x07D9,0x803E,0x0711,
0x8032,0x0648,0x8027,0x057F,0x801E,0x04B6,0x8016,0x03ED,0x800F,0x0324,0x800A,
0x025B,0x8006,0x0192,0x8002,0x00C9,0x8001,0x7FFF,0x0000,0x7FF6,0xFCDC,0x7FD9,
0xF9B8,0x7FA7,0xF695,0x7F62,0xF374,0x7F0A,0xF055,0x7E9D,0xED38,0x7E1E,0xEA1E,
0x7D8A,0xE707,0x7CE4,0xE3F4,0x7C2A,0xE0E6,0x7B5D,0xDDDC,0x7A7D,0xDAD8,0x798A,
0xD7D9,0x7885,0xD4E1,0x776C,0xD1EF,0x7642,0xCF04,0x7505,0xCC21,0x73B6,0xC946,
0x7255,0xC673,0x70E3,0xC3A9,0x6F5F,0xC0E9,0x6DCA,0xBE32,0x6C24,0xBB85,0x6A6E,
0xB8E3,0x68A7,0xB64C,0x66D0,0xB3C0,0x64E9,0xB140,0x62F2,0xAECC,0x60EC,0xAC65,
0x5ED7,0xAA0A,0x5CB4,0xA7BD,0x5A82,0xA57E,0x5843,0xA34C,0x55F6,0xA129,0x539B,
0x9F14,0x5134,0x9D0E,0x4EC0,0x9B17,0x4C40,0x9930,0x49B4,0x9759,0x471D,0x9592,
0x447B,0x93DC,0x41CE,0x9236,0x3F17,0x90A1,0x3C57,0x8F1D,0x398D,0x8DAB,0x36BA,
0x8C4A,0x33DF,0x8AFB,0x30FC,0x89BE,0x2E11,0x8894,0x2B1F,0x877B,0x2827,0x8676,
0x2528,0x8583,0x2224,0x84A3,0x1F1A,0x83D6,0x1C0C,0x831C,0x18F9,0x8276,0x15E2,
0x81E2,0x12C8,0x8163,0x0FAB,0x80F6,0x0C8C,0x809E,0x096B,0x8059,0x0648,0x8027,
0x0324,0x800A,0x7FFF,0x0000,0x7F62,0xF374,0x7D8A,0xE707,0x7A7D,0xDAD8,0x7642,
0xCF04,0x70E3,0xC3A9,0x6A6E,0xB8E3,0x62F2,0xAECC,0x5A82,0xA57E,0x5134,0x9D0E,
0x471D,0x9592,0x3C57,0x8F1D,0x30FC,0x89BE,0x2528,0x8583,0x18F9,0x8276,0x0C8C,
0x809E,0x7FFF,0x0000,0x7642,0xCF04,0x5A82,0xA57E,0x30FC,0x89BE,};

q15_t rearranged_twiddle_stride2_1024_q15[680]={
0x7FFF,0x0000,0x7FFE,0xFE6E,0x7FF6,0xFCDC,0x7FEA,0xFB4A,0x7FD9,0xF9B8,0x7FC2,
0xF827,0x7FA7,0xF695,0x7F87,0xF505,0x7F62,0xF374,0x7F38,0xF1E4,0x7F0A,0xF055,
0x7ED6,0xEEC6,0x7E9D,0xED38,0x7E60,0xEBAB,0x7E1E,0xEA1E,0x7DD6,0xE892,0x7D8A,
0xE707,0x7D3A,0xE57D,0x7CE4,0xE3F4,0x7C89,0xE26D,0x7C2A,0xE0E6,0x7BC6,0xDF61,
0x7B5D,0xDDDC,0x7AEF,0xDC59,0x7A7D,0xDAD8,0x7A06,0xD958,0x798A,0xD7D9,0x790A,
0xD65C,0x7885,0xD4E1,0x77FB,0xD367,0x776C,0xD1EF,0x76D9,0xD079,0x7642,0xCF04,
0x75A6,0xCD92,0x7505,0xCC21,0x7460,0xCAB2,0x73B6,0xC946,0x7308,0xC7DB,0x7255,
0xC673,0x719E,0xC50D,0x70E3,0xC3A9,0x7023,0xC248,0x6F5F,0xC0E9,0x6E97,0xBF8C,
0x6DCA,0xBE32,0x6CF9,0xBCDA,0x6C24,0xBB85,0x6B4B,0xBA33,0x6A6E,0xB8E3,0x698C,
0xB796,0x68A7,0xB64C,0x67BD,0xB505,0x66D0,0xB3C0,0x65DE,0xB27F,0x64E9,0xB140,
0x63EF,0xB005,0x62F2,0xAECC,0x61F1,0xAD97,0x60EC,0xAC65,0x5FE4,0xAB36,0x5ED7,
0xAA0A,0x5DC8,0xA8E2,0x5CB4,0xA7BD,0x5B9D,0xA69C,0x5A82,0xA57E,0x5964,0xA463,
0x5843,0xA34C,0x571E,0xA238,0x55F6,0xA129,0x54CA,0xA01C,0x539B,0x9F14,0x5269,
0x9E0F,0x5134,0x9D0E,0x4FFB,0x9C11,0x4EC0,0x9B17,0x4D81,0x9A22,0x4C40,0x9930,
0x4AFB,0x9843,0x49B4,0x9759,0x486A,0x9674,0x471D,0x9592,0x45CD,0x94B5,0x447B,
0x93DC,0x4326,0x9307,0x41CE,0x9236,0x4074,0x9169,0x3F17,0x90A1,0x3DB8,0x8FDD,
0x3C57,0x8F1D,0x3AF3,0x8E62,0x398D,0x8DAB,0x3825,0x8CF8,0x36BA,0x8C4A,0x354E,
0x8BA0,0x33DF,0x8AFB,0x326E,0x8A5A,0x30FC,0x89BE,0x2F87,0x8927,0x2E11,0x8894,
0x2C99,0x8805,0x2B1F,0x877B,0x29A4,0x86F6,0x2827,0x8676,0x26A8,0x85FA,0x2528,
0x8583,0x23A7,0x8511,0x2224,0x84A3,0x209F,0x843A,0x1F1A,0x83D6,0x1D93,0x8377,
0x1C0C,0x831C,0x1A83,0x82C6,0x18F9,0x8276,0x176E,0x822A,0x15E2,0x81E2,0x1455,
0x81A0,0x12C8,0x8163,0x113A,0x812A,0x0FAB,0x80F6,0x0E1C,0x80C8,0x0C8C,0x809E,
0x0AFB,0x8079,0x096B,0x8059,0x07D9,0x803E,0x0648,0x8027,0x04B6,0x8016,0x0324,
0x800A,0x0192,0x8002,0x0000,0x8000,0xFE6E,0x8002,0xFCDC,0x800A,0xFB4A,0x8016,
0xF9B8,0x8027,0xF827,0x803E,0xF695,0x8059,0xF505,0x8079,0xF374,0x809E,0xF1E4,
0x80C8,0xF055,0x80F6,0xEEC6,0x812A,0xED38,0x8163,0xEBAB,0x81A0,0xEA1E,0x81E2,
0xE892,0x822A,0xE707,0x8276,0xE57D,0x82C6,0xE3F4,0x831C,0xE26D,0x8377,0xE0E6,
0x83D6,0xDF61,0x843A,0xDDDC,0x84A3,0xDC59,0x8511,0xDAD8,0x8583,0xD958,0x85FA,
0xD7D9,0x8676,0xD65C,0x86F6,0xD4E1,0x877B,0xD367,0x8805,0xD1EF,0x8894,0xD079,
0x8927,0xCF04,0x89BE,0xCD92,0x8A5A,0xCC21,0x8AFB,0xCAB2,0x8BA0,0xC946,0x8C4A,
0xC7DB,0x8CF8,0xC673,0x8DAB,0xC50D,0x8E62,0xC3A9,0x8F1D,0xC248,0x8FDD,0xC0E9,
0x90A1,0xBF8C,0x9169,0xBE32,0x9236,0xBCDA,0x9307,0xBB85,0x93DC,0xBA33,0x94B5,
0xB8E3,0x9592,0xB796,0x9674,0xB64C,0x9759,0xB505,0x9843,0xB3C0,0x9930,0xB27F,
0x9A22,0xB140,0x9B17,0xB005,0x9C11,0xAECC,0x9D0E,0xAD97,0x9E0F,0xAC65,0x9F14,
0xAB36,0xA01C,0xAA0A,0xA129,0xA8E2,0xA238,0xA7BD,0xA34C,0xA69C,0xA463,0xA57E,
0xA57E,0xA463,0xA69C,0xA34C,0xA7BD,0xA238,0xA8E2,0xA129,0xAA0A,0xA01C,0xAB36,
0x9F14,0xAC65,0x9E0F,0xAD97,0x9D0E,0xAECC,0x9C11,0xB005,0x9B17,0xB140,0x9A22,
0xB27F,0x9930,0xB3C0,0x9843,0xB505,0x9759,0xB64C,0x9674,0xB796,0x9592,0xB8E3,
0x94B5,0xBA33,0x93DC,0xBB85,0x9307,0xBCDA,0x9236,0xBE32,0x9169,0xBF8C,0x90A1,
0xC0E9,0x8FDD,0xC248,0x8F1D,0xC3A9,0x8E62,0xC50D,0x8DAB,0xC673,0x8CF8,0xC7DB,
0x8C4A,0xC946,0x8BA0,0xCAB2,0x8AFB,0xCC21,0x8A5A,0xCD92,0x89BE,0xCF04,0x8927,
0xD079,0x8894,0xD1EF,0x8805,0xD367,0x877B,0xD4E1,0x86F6,0xD65C,0x8676,0xD7D9,
0x85FA,0xD958,0x8583,0xDAD8,0x8511,0xDC59,0x84A3,0xDDDC,0x843A,0xDF61,0x83D6,
0xE0E6,0x8377,0xE26D,0x831C,0xE3F4,0x82C6,0xE57D,0x8276,0xE707,0x822A,0xE892,
0x81E2,0xEA1E,0x81A0,0xEBAB,0x8163,0xED38,0x812A,0xEEC6,0x80F6,0xF055,0x80C8,
0xF1E4,0x809E,0xF374,0x8079,0xF505,0x8059,0xF695,0x803E,0xF827,0x8027,0xF9B8,
0x8016,0xFB4A,0x800A,0xFCDC,0x8002,0xFE6E,0x7FFF,0x0000,0x7FD9,0xF9B8,0x7F62,
0xF374,0x7E9D,0xED38,0x7D8A,0xE707,0x7C2A,0xE0E6,0x7A7D,0xDAD8,0x7885,0xD4E1,
0x7642,0xCF04,0x73B6,0xC946,0x70E3,0xC3A9,0x6DCA,0xBE32,0x6A6E,0xB8E3,0x66D0,
0xB3C0,0x62F2,0xAECC,0x5ED7,0xAA0A,0x5A82,0xA57E,0x55F6,0xA129,0x5134,0x9D0E,
0x4C40,0x9930,0x471D,0x9592,0x41CE,0x9236,0x3C57,0x8F1D,0x36BA,0x8C4A,0x30FC,
0x89BE,0x2B1F,0x877B,0x2528,0x8583,0x1F1A,0x83D6,0x18F9,0x8276,0x12C8,0x8163,
0x0C8C,0x809E,0x0648,0x8027,0x0000,0x8000,0xF9B8,0x8027,0xF374,0x809E,0xED38,
0x8163,0xE707,0x8276,0xE0E6,0x83D6,0xDAD8,0x8583,0xD4E1,0x877B,0xCF04,0x89BE,
0xC946,0x8C4A,0xC3A9,0x8F1D,0xBE32,0x9236,0xB8E3,0x9592,0xB3C0,0x9930,0xAECC,
0x9D0E,0xAA0A,0xA129,0xA57E,0xA57E,0xA129,0xAA0A,0x9D0E,0xAECC,0x9930,0xB3C0,
0x9592,0xB8E3,0x9236,0xBE32,0x8F1D,0xC3A9,0x8C4A,0xC946,0x89BE,0xCF04,0x877B,
0xD4E1,0x8583,0xDAD8,0x83D6,0xE0E6,0x8276,0xE707,0x8163,0xED38,0x809E,0xF374,
0x8027,0xF9B8,0x7FFF,0x0000,0x7D8A,0xE707,0x7642,0xCF04,0x6A6E,0xB8E3,0x5A82,
0xA57E,0x471D,0x9592,0x30FC,0x89BE,0x18F9,0x8276,0x0000,0x8000,0xE707,0x8276,
0xCF04,0x89BE,0xB8E3,0x9592,0xA57E,0xA57E,0x9592,0xB8E3,0x89BE,0xCF04,0x8276,
0xE707,0x7FFF,0x0000,0x5A82,0xA57E,0x0000,0x8000,0xA57E,0xA57E,};

q15_t rearranged_twiddle_stride3_1024_q15[680]={
0x7FFF,0x0000,0x7FFA,0xFDA5,0x7FEA,0xFB4A,0x7FCE,0xF8EF,0x7FA7,0xF695,0x7F75,
0xF43C,0x7F38,0xF1E4,0x7EF0,0xEF8D,0x7E9D,0xED38,0x7E3F,0xEAE4,0x7DD6,0xE892,
0x7D63,0xE642,0x7CE4,0xE3F4,0x7C5A,0xE1A9,0x7BC6,0xDF61,0x7B27,0xDD1B,0x7A7D,
0xDAD8,0x79C9,0xD898,0x790A,0xD65C,0x7840,0xD424,0x776C,0xD1EF,0x768E,0xCFBE,
0x75A6,0xCD92,0x74B3,0xCB69,0x73B6,0xC946,0x72AF,0xC727,0x719E,0xC50D,0x7083,
0xC2F8,0x6F5F,0xC0E9,0x6E31,0xBEDF,0x6CF9,0xBCDA,0x6BB8,0xBADC,0x6A6E,0xB8E3,
0x691A,0xB6F1,0x67BD,0xB505,0x6657,0xB31F,0x64E9,0xB140,0x6371,0xAF68,0x61F1,
0xAD97,0x6068,0xABCD,0x5ED7,0xAA0A,0x5D3E,0xA84F,0x5B9D,0xA69C,0x59F4,0xA4F0,
0x5843,0xA34C,0x568A,0xA1B0,0x54CA,0xA01C,0x5303,0x9E91,0x5134,0x9D0E,0x4F5E,
0x9B94,0x4D81,0x9A22,0x4B9E,0x98B9,0x49B4,0x9759,0x47C4,0x9603,0x45CD,0x94B5,
0x43D1,0x9371,0x41CE,0x9236,0x3FC6,0x9105,0x3DB8,0x8FDD,0x3BA5,0x8EBF,0x398D,
0x8DAB,0x3770,0x8CA1,0x354E,0x8BA0,0x3327,0x8AAA,0x30FC,0x89BE,0x2ECC,0x88DD,
0x2C99,0x8805,0x2A62,0x8738,0x2827,0x8676,0x25E8,0x85BE,0x23A7,0x8511,0x2162,
0x846E,0x1F1A,0x83D6,0x1CD0,0x8349,0x1A83,0x82C6,0x1833,0x824F,0x15E2,0x81E2,
0x138F,0x8181,0x113A,0x812A,0x0EE4,0x80DE,0x0C8C,0x809E,0x0A33,0x8068,0x07D9,
0x803E,0x057F,0x801E,0x0324,0x800A,0x00C9,0x8001,0xFE6E,0x8002,0xFC13,0x800F,
0xF9B8,0x8027,0xF75E,0x804B,0xF505,0x8079,0xF2AC,0x80B2,0xF055,0x80F6,0xEDFF,
0x8146,0xEBAB,0x81A0,0xE958,0x8205,0xE707,0x8276,0xE4B9,0x82F1,0xE26D,0x8377,
0xE023,0x8407,0xDDDC,0x84A3,0xDB99,0x8549,0xD958,0x85FA,0xD71B,0x86B6,0xD4E1,
0x877B,0xD2AB,0x884C,0xD079,0x8927,0xCE4B,0x8A0C,0xCC21,0x8AFB,0xC9FC,0x8BF5,
0xC7DB,0x8CF8,0xC5C0,0x8E06,0xC3A9,0x8F1D,0xC198,0x903E,0xBF8C,0x9169,0xBD86,
0x929E,0xBB85,0x93DC,0xB98B,0x9523,0xB796,0x9674,0xB5A8,0x97CE,0xB3C0,0x9930,
0xB1DF,0x9A9C,0xB005,0x9C11,0xAE31,0x9D8E,0xAC65,0x9F14,0xAAA0,0xA0A2,0xA8E2,
0xA238,0xA72C,0xA3D7,0xA57E,0xA57E,0xA3D7,0xA72C,0xA238,0xA8E2,0xA0A2,0xAAA0,
0x9F14,0xAC65,0x9D8E,0xAE31,0x9C11,0xB005,0x9A9C,0xB1DF,0x9930,0xB3C0,0x97CE,
0xB5A8,0x9674,0xB796,0x9523,0xB98B,0x93DC,0xBB85,0x929E,0xBD86,0x9169,0xBF8C,
0x903E,0xC198,0x8F1D,0xC3A9,0x8E06,0xC5C0,0x8CF8,0xC7DB,0x8BF5,0xC9FC,0x8AFB,
0xCC21,0x8A0C,0xCE4B,0x8927,0xD079,0x884C,0xD2AB,0x877B,0xD4E1,0x86B6,0xD71B,
0x85FA,0xD958,0x8549,0xDB99,0x84A3,0xDDDC,0x8407,0xE023,0x8377,0xE26D,0x82F1,
0xE4B9,0x8276,0xE707,0x8205,0xE958,0x81A0,0xEBAB,0x8146,0xEDFF,0x80F6,0xF055,
0x80B2,0xF2AC,0x8079,0xF505,0x804B,0xF75E,0x8027,0xF9B8,0x800F,0xFC13,0x8002,
0xFE6E,0x8001,0x00C9,0x800A,0x0324,0x801E,0x057F,0x803E,0x07D9,0x8068,0x0A33,
0x809E,0x0C8C,0x80DE,0x0EE4,0x812A,0x113A,0x8181,0x138F,0x81E2,0x15E2,0x824F,
0x1833,0x82C6,0x1A83,0x8349,0x1CD0,0x83D6,0x1F1A,0x846E,0x2162,0x8511,0x23A7,
0x85BE,0x25E8,0x8676,0x2827,0x8738,0x2A62,0x8805,0x2C99,0x88DD,0x2ECC,0x89BE,
0x30FC,0x8AAA,0x3327,0x8BA0,0x354E,0x8CA1,0x3770,0x8DAB,0x398D,0x8EBF,0x3BA5,
0x8FDD,0x3DB8,0x9105,0x3FC6,0x9236,0x41CE,0x9371,0x43D1,0x94B5,0x45CD,0x9603,
0x47C4,0x9759,0x49B4,0x98B9,0x4B9E,0x9A22,0x4D81,0x9B94,0x4F5E,0x9D0E,0x5134,
0x9E91,0x5303,0xA01C,0x54CA,0xA1B0,0x568A,0xA34C,0x5843,0xA4F0,0x59F4,0xA69C,
0x5B9D,0xA84F,0x5D3E,0xAA0A,0x5ED7,0xABCD,0x6068,0xAD97,0x61F1,0xAF68,0x6371,
0xB140,0x64E9,0xB31F,0x6657,0xB505,0x67BD,0xB6F1,0x691A,0xB8E3,0x6A6E,0xBADC,
0x6BB8,0xBCDA,0x6CF9,0xBEDF,0x6E31,0xC0E9,0x6F5F,0xC2F8,0x7083,0xC50D,0x719E,
0xC727,0x72AF,0xC946,0x73B6,0xCB69,0x74B3,0xCD92,0x75A6,0xCFBE,0x768E,0xD1EF,
0x776C,0xD424,0x7840,0xD65C,0x790A,0xD898,0x79C9,0xDAD8,0x7A7D,0xDD1B,0x7B27,
0xDF61,0x7BC6,0xE1A9,0x7C5A,0xE3F4,0x7CE4,0xE642,0x7D63,0xE892,0x7DD6,0xEAE4,
0x7E3F,0xED38,0x7E9D,0xEF8D,0x7EF0,0xF1E4,0x7F38,0xF43C,0x7F75,0xF695,0x7FA7,
0xF8EF,0x7FCE,0xFB4A,0x7FEA,0xFDA5,0x7FFA,0x7FFF,0x0000,0x7FA7,0xF695,0x7E9D,
0xED38,0x7CE4,0xE3F4,0x7A7D,0xDAD8,0x776C,0xD1EF,0x73B6,0xC946,0x6F5F,0xC0E9,
0x6A6E,0xB8E3,0x64E9,0xB140,0x5ED7,0xAA0A,0x5843,0xA34C,0x5134,0x9D0E,0x49B4,
0x9759,0x41CE,0x9236,0x398D,0x8DAB,0x30FC,0x89BE,0x2827,0x8676,0x1F1A,0x83D6,
0x15E2,0x81E2,0x0C8C,0x809E,0x0324,0x800A,0xF9B8,0x8027,0xF055,0x80F6,0xE707,
0x8276,0xDDDC,0x84A3,0xD4E1,0x877B,0xCC21,0x8AFB,0xC3A9,0x8F1D,0xBB85,0x93DC,
0xB3C0,0x9930,0xAC65,0x9F14,0xA57E,0xA57E,0x9F14,0xAC65,0x9930,0xB3C0,0x93DC,
0xBB85,0x8F1D,0xC3A9,0x8AFB,0xCC21,0x877B,0xD4E1,0x84A3,0xDDDC,0x8276,0xE707,
0x80F6,0xF055,0x8027,0xF9B8,0x800A,0x0324,0x809E,0x0C8C,0x81E2,0x15E2,0x83D6,
0x1F1A,0x8676,0x2827,0x89BE,0x30FC,0x8DAB,0x398D,0x9236,0x41CE,0x9759,0x49B4,
0x9D0E,0x5134,0xA34C,0x5843,0xAA0A,0x5ED7,0xB140,0x64E9,0xB8E3,0x6A6E,0xC0E9,
0x6F5F,0xC946,0x73B6,0xD1EF,0x776C,0xDAD8,0x7A7D,0xE3F4,0x7CE4,0xED38,0x7E9D,
0xF695,0x7FA7,0x7FFF,0x0000,0x7A7D,0xDAD8,0x6A6E,0xB8E3,0x5134,0x9D0E,0x30FC,
0x89BE,0x0C8C,0x809E,0xE707,0x8276,0xC3A9,0x8F1D,0xA57E,0xA57E,0x8F1D,0xC3A9,
0x8276,0xE707,0x809E,0x0C8C,0x89BE,0x30FC,0x9D0E,0x5134,0xB8E3,0x6A6E,0xDAD8,
0x7A7D,0x7FFF,0x0000,0x30FC,0x89BE,0xA57E,0xA57E,0x89BE,0x30FC,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_Q15_4096) || defined(ARM_TABLE_TWIDDLECOEF_Q15_8192)

uint32_t rearranged_twiddle_tab_stride1_arr_4096_q15[6]={
0,2048,2560,2688,2720,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_4096_q15[6]={
0,2048,2560,2688,2720,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_4096_q15[6]={
0,2048,2560,2688,2720,0,};

q15_t rearranged_twiddle_stride1_4096_q15[2728]={
0x7FFF,0x0000,0x7FFF,0xFFCE,0x7FFF,0xFF9B,0x7FFF,0xFF69,0x7FFF,0xFF37,0x7FFF,
0xFF05,0x7FFF,0xFED2,0x7FFE,0xFEA0,0x7FFE,0xFE6E,0x7FFD,0xFE3C,0x7FFC,0xFE09,
0x7FFB,0xFDD7,0x7FFA,0xFDA5,0x7FF9,0xFD73,0x7FF8,0xFD40,0x7FF7,0xFD0E,0x7FF6,
0xFCDC,0x7FF5,0xFCAA,0x7FF4,0xFC77,0x7FF2,0xFC45,0x7FF1,0xFC13,0x7FEF,0xFBE1,
0x7FED,0xFBAE,0x7FEC,0xFB7C,0x7FEA,0xFB4A,0x7FE8,0xFB18,0x7FE6,0xFAE5,0x7FE4,
0xFAB3,0x7FE2,0xFA81,0x7FE0,0xFA4F,0x7FDD,0xFA1D,0x7FDB,0xF9EA,0x7FD9,0xF9B8,
0x7FD6,0xF986,0x7FD3,0xF954,0x7FD1,0xF922,0x7FCE,0xF8EF,0x7FCB,0xF8BD,0x7FC8,
0xF88B,0x7FC5,0xF859,0x7FC2,0xF827,0x7FBF,0xF7F4,0x7FBC,0xF7C2,0x7FB9,0xF790,
0x7FB5,0xF75E,0x7FB2,0xF72C,0x7FAE,0xF6FA,0x7FAB,0xF6C8,0x7FA7,0xF695,0x7FA3,
0xF663,0x7FA0,0xF631,0x7F9C,0xF5FF,0x7F98,0xF5CD,0x7F94,0xF59B,0x7F90,0xF569,
0x7F8B,0xF537,0x7F87,0xF505,0x7F83,0xF4D3,0x7F7E,0xF4A0,0x7F7A,0xF46E,0x7F75,
0xF43C,0x7F71,0xF40A,0x7F6C,0xF3D8,0x7F67,0xF3A6,0x7F62,0xF374,0x7F5D,0xF342,
0x7F58,0xF310,0x7F53,0xF2DE,0x7F4E,0xF2AC,0x7F49,0xF27A,0x7F43,0xF248,0x7F3E,
0xF216,0x7F38,0xF1E4,0x7F33,0xF1B2,0x7F2D,0xF180,0x7F27,0xF14E,0x7F22,0xF11C,
0x7F1C,0xF0EB,0x7F16,0xF0B9,0x7F10,0xF087,0x7F0A,0xF055,0x7F03,0xF023,0x7EFD,
0xEFF1,0x7EF7,0xEFBF,0x7EF0,0xEF8D,0x7EEA,0xEF5C,0x7EE3,0xEF2A,0x7EDD,0xEEF8,
0x7ED6,0xEEC6,0x7ECF,0xEE94,0x7EC8,0xEE62,0x7EC1,0xEE31,0x7EBA,0xEDFF,0x7EB3,
0xEDCD,0x7EAC,0xED9B,0x7EA5,0xED6A,0x7E9D,0xED38,0x7E96,0xED06,0x7E8E,0xECD5,
0x7E87,0xECA3,0x7E7F,0xEC71,0x7E78,0xEC3F,0x7E70,0xEC0E,0x7E68,0xEBDC,0x7E60,
0xEBAB,0x7E58,0xEB79,0x7E50,0xEB47,0x7E48,0xEB16,0x7E3F,0xEAE4,0x7E37,0xEAB3,
0x7E2F,0xEA81,0x7E26,0xEA4F,0x7E1E,0xEA1E,0x7E15,0xE9EC,0x7E0C,0xE9BB,0x7E03,
0xE989,0x7DFB,0xE958,0x7DF2,0xE926,0x7DE9,0xE8F5,0x7DE0,0xE8C4,0x7DD6,0xE892,
0x7DCD,0xE861,0x7DC4,0xE82F,0x7DBA,0xE7FE,0x7DB1,0xE7CD,0x7DA7,0xE79B,0x7D9E,
0xE76A,0x7D94,0xE739,0x7D8A,0xE707,0x7D81,0xE6D6,0x7D77,0xE6A5,0x7D6D,0xE673,
0x7D63,0xE642,0x7D58,0xE611,0x7D4E,0xE5E0,0x7D44,0xE5AF,0x7D3A,0xE57D,0x7D2F,
0xE54C,0x7D25,0xE51B,0x7D1A,0xE4EA,0x7D0F,0xE4B9,0x7D05,0xE488,0x7CFA,0xE457,
0x7CEF,0xE426,0x7CE4,0xE3F4,0x7CD9,0xE3C3,0x7CCE,0xE392,0x7CC2,0xE361,0x7CB7,
0xE330,0x7CAC,0xE2FF,0x7CA0,0xE2CF,0x7C95,0xE29E,0x7C89,0xE26D,0x7C7E,0xE23C,
0x7C72,0xE20B,0x7C66,0xE1DA,0x7C5A,0xE1A9,0x7C4E,0xE178,0x7C42,0xE148,0x7C36,
0xE117,0x7C2A,0xE0E6,0x7C1E,0xE0B5,0x7C11,0xE085,0x7C05,0xE054,0x7BF9,0xE023,
0x7BEC,0xDFF2,0x7BDF,0xDFC2,0x7BD3,0xDF91,0x7BC6,0xDF61,0x7BB9,0xDF30,0x7BAC,
0xDEFF,0x7B9F,0xDECF,0x7B92,0xDE9E,0x7B85,0xDE6E,0x7B78,0xDE3D,0x7B6A,0xDE0D,
0x7B5D,0xDDDC,0x7B50,0xDDAC,0x7B42,0xDD7C,0x7B34,0xDD4B,0x7B27,0xDD1B,0x7B19,
0xDCEA,0x7B0B,0xDCBA,0x7AFD,0xDC8A,0x7AEF,0xDC59,0x7AE1,0xDC29,0x7AD3,0xDBF9,
0x7AC5,0xDBC9,0x7AB7,0xDB99,0x7AA8,0xDB68,0x7A9A,0xDB38,0x7A8C,0xDB08,0x7A7D,
0xDAD8,0x7A6E,0xDAA8,0x7A60,0xDA78,0x7A51,0xDA48,0x7A42,0xDA18,0x7A33,0xD9E8,
0x7A24,0xD9B8,0x7A15,0xD988,0x7A06,0xD958,0x79F7,0xD928,0x79E7,0xD8F8,0x79D8,
0xD8C8,0x79C9,0xD898,0x79B9,0xD869,0x79AA,0xD839,0x799A,0xD809,0x798A,0xD7D9,
0x797A,0xD7AA,0x796A,0xD77A,0x795B,0xD74A,0x794A,0xD71B,0x793A,0xD6EB,0x792A,
0xD6BB,0x791A,0xD68C,0x790A,0xD65C,0x78F9,0xD62D,0x78E9,0xD5FD,0x78D8,0xD5CE,
0x78C8,0xD59E,0x78B7,0xD56F,0x78A6,0xD53F,0x7895,0xD510,0x7885,0xD4E1,0x7874,
0xD4B1,0x7863,0xD482,0x7851,0xD453,0x7840,0xD424,0x782F,0xD3F4,0x781E,0xD3C5,
0x780C,0xD396,0x77FB,0xD367,0x77E9,0xD338,0x77D8,0xD309,0x77C6,0xD2DA,0x77B4,
0xD2AB,0x77A2,0xD27C,0x7790,0xD24D,0x777E,0xD21E,0x776C,0xD1EF,0x775A,0xD1C0,
0x7748,0xD191,0x7736,0xD162,0x7723,0xD134,0x7711,0xD105,0x76FE,0xD0D6,0x76EC,
0xD0A7,0x76D9,0xD079,0x76C7,0xD04A,0x76B4,0xD01B,0x76A1,0xCFED,0x768E,0xCFBE,
0x767B,0xCF90,0x7668,0xCF61,0x7655,0xCF33,0x7642,0xCF04,0x762E,0xCED6,0x761B,
0xCEA7,0x7608,0xCE79,0x75F4,0xCE4B,0x75E1,0xCE1C,0x75CD,0xCDEE,0x75B9,0xCDC0,
0x75A6,0xCD92,0x7592,0xCD63,0x757E,0xCD35,0x756A,0xCD07,0x7556,0xCCD9,0x7542,
0xCCAB,0x752D,0xCC7D,0x7519,0xCC4F,0x7505,0xCC21,0x74F0,0xCBF3,0x74DC,0xCBC5,
0x74C7,0xCB97,0x74B3,0xCB69,0x749E,0xCB3C,0x7489,0xCB0E,0x7475,0xCAE0,0x7460,
0xCAB2,0x744B,0xCA85,0x7436,0xCA57,0x7421,0xCA29,0x740B,0xC9FC,0x73F6,0xC9CE,
0x73E1,0xC9A1,0x73CB,0xC973,0x73B6,0xC946,0x73A0,0xC918,0x738B,0xC8EB,0x7375,
0xC8BE,0x735F,0xC890,0x734A,0xC863,0x7334,0xC836,0x731E,0xC809,0x7308,0xC7DB,
0x72F2,0xC7AE,0x72DC,0xC781,0x72C5,0xC754,0x72AF,0xC727,0x7299,0xC6FA,0x7282,
0xC6CD,0x726C,0xC6A0,0x7255,0xC673,0x723F,0xC646,0x7228,0xC619,0x7211,0xC5ED,
0x71FA,0xC5C0,0x71E3,0xC593,0x71CC,0xC566,0x71B5,0xC53A,0x719E,0xC50D,0x7187,
0xC4E0,0x7170,0xC4B4,0x7158,0xC487,0x7141,0xC45B,0x712A,0xC42E,0x7112,0xC402,
0x70FA,0xC3D6,0x70E3,0xC3A9,0x70CB,0xC37D,0x70B3,0xC351,0x709B,0xC324,0x7083,
0xC2F8,0x706B,0xC2CC,0x7053,0xC2A0,0x703B,0xC274,0x7023,0xC248,0x700B,0xC21C,
0x6FF2,0xC1F0,0x6FDA,0xC1C4,0x6FC2,0xC198,0x6FA9,0xC16C,0x6F90,0xC140,0x6F78,
0xC114,0x6F5F,0xC0E9,0x6F46,0xC0BD,0x6F2D,0xC091,0x6F14,0xC066,0x6EFB,0xC03A,
0x6EE2,0xC00F,0x6EC9,0xBFE3,0x6EB0,0xBFB8,0x6E97,0xBF8C,0x6E7D,0xBF61,0x6E64,
0xBF35,0x6E4A,0xBF0A,0x6E31,0xBEDF,0x6E17,0xBEB3,0x6DFE,0xBE88,0x6DE4,0xBE5D,
0x6DCA,0xBE32,0x6DB0,0xBE07,0x6D96,0xBDDC,0x6D7C,0xBDB1,0x6D62,0xBD86,0x6D48,
0xBD5B,0x6D2E,0xBD30,0x6D14,0xBD05,0x6CF9,0xBCDA,0x6CDF,0xBCAF,0x6CC4,0xBC85,
0x6CAA,0xBC5A,0x6C8F,0xBC2F,0x6C75,0xBC05,0x6C5A,0xBBDA,0x6C3F,0xBBB0,0x6C24,
0xBB85,0x6C09,0xBB5B,0x6BEE,0xBB30,0x6BD3,0xBB06,0x6BB8,0xBADC,0x6B9D,0xBAB1,
0x6B82,0xBA87,0x6B66,0xBA5D,0x6B4B,0xBA33,0x6B30,0xBA09,0x6B14,0xB9DF,0x6AF8,
0xB9B5,0x6ADD,0xB98B,0x6AC1,0xB961,0x6AA5,0xB937,0x6A89,0xB90D,0x6A6E,0xB8E3,
0x6A52,0xB8B9,0x6A36,0xB890,0x6A1A,0xB866,0x69FD,0xB83C,0x69E1,0xB813,0x69C5,
0xB7E9,0x69A9,0xB7C0,0x698C,0xB796,0x6970,0xB76D,0x6953,0xB743,0x6937,0xB71A,
0x691A,0xB6F1,0x68FD,0xB6C7,0x68E0,0xB69E,0x68C4,0xB675,0x68A7,0xB64C,0x688A,
0xB623,0x686D,0xB5FA,0x6850,0xB5D1,0x6832,0xB5A8,0x6815,0xB57F,0x67F8,0xB556,
0x67DA,0xB52D,0x67BD,0xB505,0x67A0,0xB4DC,0x6782,0xB4B3,0x6764,0xB48B,0x6747,
0xB462,0x6729,0xB439,0x670B,0xB411,0x66ED,0xB3E9,0x66D0,0xB3C0,0x66B2,0xB398,
0x6693,0xB36F,0x6675,0xB347,0x6657,0xB31F,0x6639,0xB2F7,0x661B,0xB2CF,0x65FC,
0xB2A7,0x65DE,0xB27F,0x65C0,0xB257,0x65A1,0xB22F,0x6582,0xB207,0x6564,0xB1DF,
0x6545,0xB1B7,0x6526,0xB18F,0x6507,0xB168,0x64E9,0xB140,0x64CA,0xB118,0x64AB,
0xB0F1,0x648B,0xB0C9,0x646C,0xB0A2,0x644D,0xB07B,0x642E,0xB053,0x640F,0xB02C,
0x63EF,0xB005,0x63D0,0xAFDD,0x63B0,0xAFB6,0x6391,0xAF8F,0x6371,0xAF68,0x6351,
0xAF41,0x6332,0xAF1A,0x6312,0xAEF3,0x62F2,0xAECC,0x62D2,0xAEA5,0x62B2,0xAE7F,
0x6292,0xAE58,0x6272,0xAE31,0x6252,0xAE0B,0x6232,0xADE4,0x6211,0xADBD,0x61F1,
0xAD97,0x61D1,0xAD70,0x61B0,0xAD4A,0x6190,0xAD24,0x616F,0xACFD,0x614E,0xACD7,
0x612E,0xACB1,0x610D,0xAC8B,0x60EC,0xAC65,0x60CB,0xAC3F,0x60AA,0xAC19,0x6089,
0xABF3,0x6068,0xABCD,0x6047,0xABA7,0x6026,0xAB81,0x6005,0xAB5C,0x5FE4,0xAB36,
0x5FC2,0xAB10,0x5FA1,0xAAEB,0x5F80,0xAAC5,0x5F5E,0xAAA0,0x5F3C,0xAA7A,0x5F1B,
0xAA55,0x5EF9,0xAA30,0x5ED7,0xAA0A,0x5EB6,0xA9E5,0x5E94,0xA9C0,0x5E72,0xA99B,
0x5E50,0xA976,0x5E2E,0xA951,0x5E0C,0xA92C,0x5DEA,0xA907,0x5DC8,0xA8E2,0x5DA5,
0xA8BD,0x5D83,0xA899,0x5D61,0xA874,0x5D3E,0xA84F,0x5D1C,0xA82B,0x5CF9,0xA806,
0x5CD7,0xA7E2,0x5CB4,0xA7BD,0x5C91,0xA799,0x5C6F,0xA774,0x5C4C,0xA750,0x5C29,
0xA72C,0x5C06,0xA708,0x5BE3,0xA6E4,0x5BC0,0xA6C0,0x5B9D,0xA69C,0x5B7A,0xA678,
0x5B57,0xA654,0x5B34,0xA630,0x5B10,0xA60C,0x5AED,0xA5E8,0x5AC9,0xA5C5,0x5AA6,
0xA5A1,0x5A82,0xA57E,0x5A5F,0xA55A,0x5A3B,0xA537,0x5A18,0xA513,0x59F4,0xA4F0,
0x59D0,0xA4CC,0x59AC,0xA4A9,0x5988,0xA486,0x5964,0xA463,0x5940,0xA440,0x591C,
0xA41D,0x58F8,0xA3FA,0x58D4,0xA3D7,0x58B0,0xA3B4,0x588C,0xA391,0x5867,0xA36F,
0x5843,0xA34C,0x581E,0xA329,0x57FA,0xA307,0x57D5,0xA2E4,0x57B1,0xA2C2,0x578C,
0xA29F,0x5767,0xA27D,0x5743,0xA25B,0x571E,0xA238,0x56F9,0xA216,0x56D4,0xA1F4,
0x56AF,0xA1D2,0x568A,0xA1B0,0x5665,0xA18E,0x5640,0xA16C,0x561B,0xA14A,0x55F6,
0xA129,0x55D0,0xA107,0x55AB,0xA0E5,0x5586,0xA0C4,0x5560,0xA0A2,0x553B,0xA080,
0x5515,0xA05F,0x54F0,0xA03E,0x54CA,0xA01C,0x54A4,0x9FFB,0x547F,0x9FDA,0x5459,
0x9FB9,0x5433,0x9F98,0x540D,0x9F77,0x53E7,0x9F56,0x53C1,0x9F35,0x539B,0x9F14,
0x5375,0x9EF3,0x534F,0x9ED2,0x5329,0x9EB2,0x5303,0x9E91,0x52DC,0x9E70,0x52B6,
0x9E50,0x5290,0x9E2F,0x5269,0x9E0F,0x5243,0x9DEF,0x521C,0x9DCE,0x51F5,0x9DAE,
0x51CF,0x9D8E,0x51A8,0x9D6E,0x5181,0x9D4E,0x515B,0x9D2E,0x5134,0x9D0E,0x510D,
0x9CEE,0x50E6,0x9CCE,0x50BF,0x9CAF,0x5098,0x9C8F,0x5071,0x9C6F,0x504A,0x9C50,
0x5023,0x9C30,0x4FFB,0x9C11,0x4FD4,0x9BF1,0x4FAD,0x9BD2,0x4F85,0x9BB3,0x4F5E,
0x9B94,0x4F37,0x9B75,0x4F0F,0x9B55,0x4EE8,0x9B36,0x4EC0,0x9B17,0x4E98,0x9AF9,
0x4E71,0x9ADA,0x4E49,0x9ABB,0x4E21,0x9A9C,0x4DF9,0x9A7E,0x4DD1,0x9A5F,0x4DA9,
0x9A40,0x4D81,0x9A22,0x4D59,0x9A04,0x4D31,0x99E5,0x4D09,0x99C7,0x4CE1,0x99A9,
0x4CB9,0x998B,0x4C91,0x996D,0x4C68,0x994E,0x4C40,0x9930,0x4C17,0x9913,0x4BEF,
0x98F5,0x4BC7,0x98D7,0x4B9E,0x98B9,0x4B75,0x989C,0x4B4D,0x987E,0x4B24,0x9860,
0x4AFB,0x9843,0x4AD3,0x9826,0x4AAA,0x9808,0x4A81,0x97EB,0x4A58,0x97CE,0x4A2F,
0x97B0,0x4A06,0x9793,0x49DD,0x9776,0x49B4,0x9759,0x498B,0x973C,0x4962,0x9720,
0x4939,0x9703,0x490F,0x96E6,0x48E6,0x96C9,0x48BD,0x96AD,0x4893,0x9690,0x486A,
0x9674,0x4840,0x9657,0x4817,0x963B,0x47ED,0x961F,0x47C4,0x9603,0x479A,0x95E6,
0x4770,0x95CA,0x4747,0x95AE,0x471D,0x9592,0x46F3,0x9577,0x46C9,0x955B,0x469F,
0x953F,0x4675,0x9523,0x464B,0x9508,0x4621,0x94EC,0x45F7,0x94D0,0x45CD,0x94B5,
0x45A3,0x949A,0x4579,0x947E,0x454F,0x9463,0x4524,0x9448,0x44FA,0x942D,0x44D0,
0x9412,0x44A5,0x93F7,0x447B,0x93DC,0x4450,0x93C1,0x4426,0x93A6,0x43FB,0x938B,
0x43D1,0x9371,0x43A6,0x9356,0x437B,0x933C,0x4351,0x9321,0x4326,0x9307,0x42FB,
0x92EC,0x42D0,0x92D2,0x42A5,0x92B8,0x427A,0x929E,0x424F,0x9284,0x4224,0x926A,
0x41F9,0x9250,0x41CE,0x9236,0x41A3,0x921C,0x4178,0x9202,0x414D,0x91E9,0x4121,
0x91CF,0x40F6,0x91B6,0x40CB,0x919C,0x409F,0x9183,0x4074,0x9169,0x4048,0x9150,
0x401D,0x9137,0x3FF1,0x911E,0x3FC6,0x9105,0x3F9A,0x90EC,0x3F6F,0x90D3,0x3F43,
0x90BA,0x3F17,0x90A1,0x3EEC,0x9088,0x3EC0,0x9070,0x3E94,0x9057,0x3E68,0x903E,
0x3E3C,0x9026,0x3E10,0x900E,0x3DE4,0x8FF5,0x3DB8,0x8FDD,0x3D8C,0x8FC5,0x3D60,
0x8FAD,0x3D34,0x8F95,0x3D08,0x8F7D,0x3CDC,0x8F65,0x3CAF,0x8F4D,0x3C83,0x8F35,
0x3C57,0x8F1D,0x3C2A,0x8F06,0x3BFE,0x8EEE,0x3BD2,0x8ED6,0x3BA5,0x8EBF,0x3B79,
0x8EA8,0x3B4C,0x8E90,0x3B20,0x8E79,0x3AF3,0x8E62,0x3AC6,0x8E4B,0x3A9A,0x8E34,
0x3A6D,0x8E1D,0x3A40,0x8E06,0x3A13,0x8DEF,0x39E7,0x8DD8,0x39BA,0x8DC1,0x398D,
0x8DAB,0x3960,0x8D94,0x3933,0x8D7E,0x3906,0x8D67,0x38D9,0x8D51,0x38AC,0x8D3B,
0x387F,0x8D24,0x3852,0x8D0E,0x3825,0x8CF8,0x37F7,0x8CE2,0x37CA,0x8CCC,0x379D,
0x8CB6,0x3770,0x8CA1,0x3742,0x8C8B,0x3715,0x8C75,0x36E8,0x8C60,0x36BA,0x8C4A,
0x368D,0x8C35,0x365F,0x8C1F,0x3632,0x8C0A,0x3604,0x8BF5,0x35D7,0x8BDF,0x35A9,
0x8BCA,0x357B,0x8BB5,0x354E,0x8BA0,0x3520,0x8B8B,0x34F2,0x8B77,0x34C4,0x8B62,
0x3497,0x8B4D,0x3469,0x8B39,0x343B,0x8B24,0x340D,0x8B10,0x33DF,0x8AFB,0x33B1,
0x8AE7,0x3383,0x8AD3,0x3355,0x8ABE,0x3327,0x8AAA,0x32F9,0x8A96,0x32CB,0x8A82,
0x329D,0x8A6E,0x326E,0x8A5A,0x3240,0x8A47,0x3212,0x8A33,0x31E4,0x8A1F,0x31B5,
0x8A0C,0x3187,0x89F8,0x3159,0x89E5,0x312A,0x89D2,0x30FC,0x89BE,0x30CD,0x89AB,
0x309F,0x8998,0x3070,0x8985,0x3042,0x8972,0x3013,0x895F,0x2FE5,0x894C,0x2FB6,
0x8939,0x2F87,0x8927,0x2F59,0x8914,0x2F2A,0x8902,0x2EFB,0x88EF,0x2ECC,0x88DD,
0x2E9E,0x88CA,0x2E6F,0x88B8,0x2E40,0x88A6,0x2E11,0x8894,0x2DE2,0x8882,0x2DB3,
0x8870,0x2D84,0x885E,0x2D55,0x884C,0x2D26,0x883A,0x2CF7,0x8828,0x2CC8,0x8817,
0x2C99,0x8805,0x2C6A,0x87F4,0x2C3B,0x87E2,0x2C0C,0x87D1,0x2BDC,0x87C0,0x2BAD,
0x87AF,0x2B7E,0x879D,0x2B4F,0x878C,0x2B1F,0x877B,0x2AF0,0x876B,0x2AC1,0x875A,
0x2A91,0x8749,0x2A62,0x8738,0x2A32,0x8728,0x2A03,0x8717,0x29D3,0x8707,0x29A4,
0x86F6,0x2974,0x86E6,0x2945,0x86D6,0x2915,0x86C6,0x28E5,0x86B6,0x28B6,0x86A5,
0x2886,0x8696,0x2856,0x8686,0x2827,0x8676,0x27F7,0x8666,0x27C7,0x8656,0x2797,
0x8647,0x2768,0x8637,0x2738,0x8628,0x2708,0x8619,0x26D8,0x8609,0x26A8,0x85FA,
0x2678,0x85EB,0x2648,0x85DC,0x2618,0x85CD,0x25E8,0x85BE,0x25B8,0x85AF,0x2588,
0x85A0,0x2558,0x8592,0x2528,0x8583,0x24F8,0x8574,0x24C8,0x8566,0x2498,0x8558,
0x2467,0x8549,0x2437,0x853B,0x2407,0x852D,0x23D7,0x851F,0x23A7,0x8511,0x2376,
0x8503,0x2346,0x84F5,0x2316,0x84E7,0x22E5,0x84D9,0x22B5,0x84CC,0x2284,0x84BE,
0x2254,0x84B0,0x2224,0x84A3,0x21F3,0x8496,0x21C3,0x8488,0x2192,0x847B,0x2162,
0x846E,0x2131,0x8461,0x2101,0x8454,0x20D0,0x8447,0x209F,0x843A,0x206F,0x842D,
0x203E,0x8421,0x200E,0x8414,0x1FDD,0x8407,0x1FAC,0x83FB,0x1F7B,0x83EF,0x1F4B,
0x83E2,0x1F1A,0x83D6,0x1EE9,0x83CA,0x1EB8,0x83BE,0x1E88,0x83B2,0x1E57,0x83A6,
0x1E26,0x839A,0x1DF5,0x838E,0x1DC4,0x8382,0x1D93,0x8377,0x1D62,0x836B,0x1D31,
0x8360,0x1D01,0x8354,0x1CD0,0x8349,0x1C9F,0x833E,0x1C6E,0x8332,0x1C3D,0x8327,
0x1C0C,0x831C,0x1BDA,0x8311,0x1BA9,0x8306,0x1B78,0x82FB,0x1B47,0x82F1,0x1B16,
0x82E6,0x1AE5,0x82DB,0x1AB4,0x82D1,0x1A83,0x82C6,0x1A51,0x82BC,0x1A20,0x82B2,
0x19EF,0x82A8,0x19BE,0x829D,0x198D,0x8293,0x195B,0x8289,0x192A,0x827F,0x18F9,
0x8276,0x18C7,0x826C,0x1896,0x8262,0x1865,0x8259,0x1833,0x824F,0x1802,0x8246,
0x17D1,0x823C,0x179F,0x8233,0x176E,0x822A,0x173C,0x8220,0x170B,0x8217,0x16DA,
0x820E,0x16A8,0x8205,0x1677,0x81FD,0x1645,0x81F4,0x1614,0x81EB,0x15E2,0x81E2,
0x15B1,0x81DA,0x157F,0x81D1,0x154D,0x81C9,0x151C,0x81C1,0x14EA,0x81B8,0x14B9,
0x81B0,0x1487,0x81A8,0x1455,0x81A0,0x1424,0x8198,0x13F2,0x8190,0x13C1,0x8188,
0x138F,0x8181,0x135D,0x8179,0x132B,0x8172,0x12FA,0x816A,0x12C8,0x8163,0x1296,
0x815B,0x1265,0x8154,0x1233,0x814D,0x1201,0x8146,0x11CF,0x813F,0x119E,0x8138,
0x116C,0x8131,0x113A,0x812A,0x1108,0x8123,0x10D6,0x811D,0x10A4,0x8116,0x1073,
0x8110,0x1041,0x8109,0x100F,0x8103,0x0FDD,0x80FD,0x0FAB,0x80F6,0x0F79,0x80F0,
0x0F47,0x80EA,0x0F15,0x80E4,0x0EE4,0x80DE,0x0EB2,0x80D9,0x0E80,0x80D3,0x0E4E,
0x80CD,0x0E1C,0x80C8,0x0DEA,0x80C2,0x0DB8,0x80BD,0x0D86,0x80B7,0x0D54,0x80B2,
0x0D22,0x80AD,0x0CF0,0x80A8,0x0CBE,0x80A3,0x0C8C,0x809E,0x0C5A,0x8099,0x0C28,
0x8094,0x0BF6,0x808F,0x0BC4,0x808B,0x0B92,0x8086,0x0B60,0x8082,0x0B2D,0x807D,
0x0AFB,0x8079,0x0AC9,0x8075,0x0A97,0x8070,0x0A65,0x806C,0x0A33,0x8068,0x0A01,
0x8064,0x09CF,0x8060,0x099D,0x805D,0x096B,0x8059,0x0938,0x8055,0x0906,0x8052,
0x08D4,0x804E,0x08A2,0x804B,0x0870,0x8047,0x083E,0x8044,0x080C,0x8041,0x07D9,
0x803E,0x07A7,0x803B,0x0775,0x8038,0x0743,0x8035,0x0711,0x8032,0x06DE,0x802F,
0x06AC,0x802D,0x067A,0x802A,0x0648,0x8027,0x0616,0x8025,0x05E3,0x8023,0x05B1,
0x8020,0x057F,0x801E,0x054D,0x801C,0x051B,0x801A,0x04E8,0x8018,0x04B6,0x8016,
0x0484,0x8014,0x0452,0x8013,0x041F,0x8011,0x03ED,0x800F,0x03BB,0x800E,0x0389,
0x800C,0x0356,0x800B,0x0324,0x800A,0x02F2,0x8009,0x02C0,0x8008,0x028D,0x8007,
0x025B,0x8006,0x0229,0x8005,0x01F7,0x8004,0x01C4,0x8003,0x0192,0x8002,0x0160,
0x8002,0x012E,0x8001,0x00FB,0x8001,0x00C9,0x8001,0x0097,0x8000,0x0065,0x8000,
0x0032,0x8000,0x7FFF,0x0000,0x7FFF,0xFF37,0x7FFE,0xFE6E,0x7FFA,0xFDA5,0x7FF6,
0xFCDC,0x7FF1,0xFC13,0x7FEA,0xFB4A,0x7FE2,0xFA81,0x7FD9,0xF9B8,0x7FCE,0xF8EF,
0x7FC2,0xF827,0x7FB5,0xF75E,0x7FA7,0xF695,0x7F98,0xF5CD,0x7F87,0xF505,0x7F75,
0xF43C,0x7F62,0xF374,0x7F4E,0xF2AC,0x7F38,0xF1E4,0x7F22,0xF11C,0x7F0A,0xF055,
0x7EF0,0xEF8D,0x7ED6,0xEEC6,0x7EBA,0xEDFF,0x7E9D,0xED38,0x7E7F,0xEC71,0x7E60,
0xEBAB,0x7E3F,0xEAE4,0x7E1E,0xEA1E,0x7DFB,0xE958,0x7DD6,0xE892,0x7DB1,0xE7CD,
0x7D8A,0xE707,0x7D63,0xE642,0x7D3A,0xE57D,0x7D0F,0xE4B9,0x7CE4,0xE3F4,0x7CB7,
0xE330,0x7C89,0xE26D,0x7C5A,0xE1A9,0x7C2A,0xE0E6,0x7BF9,0xE023,0x7BC6,0xDF61,
0x7B92,0xDE9E,0x7B5D,0xDDDC,0x7B27,0xDD1B,0x7AEF,0xDC59,0x7AB7,0xDB99,0x7A7D,
0xDAD8,0x7A42,0xDA18,0x7A06,0xD958,0x79C9,0xD898,0x798A,0xD7D9,0x794A,0xD71B,
0x790A,0xD65C,0x78C8,0xD59E,0x7885,0xD4E1,0x7840,0xD424,0x77FB,0xD367,0x77B4,
0xD2AB,0x776C,0xD1EF,0x7723,0xD134,0x76D9,0xD079,0x768E,0xCFBE,0x7642,0xCF04,
0x75F4,0xCE4B,0x75A6,0xCD92,0x7556,0xCCD9,0x7505,0xCC21,0x74B3,0xCB69,0x7460,
0xCAB2,0x740B,0xC9FC,0x73B6,0xC946,0x735F,0xC890,0x7308,0xC7DB,0x72AF,0xC727,
0x7255,0xC673,0x71FA,0xC5C0,0x719E,0xC50D,0x7141,0xC45B,0x70E3,0xC3A9,0x7083,
0xC2F8,0x7023,0xC248,0x6FC2,0xC198,0x6F5F,0xC0E9,0x6EFB,0xC03A,0x6E97,0xBF8C,
0x6E31,0xBEDF,0x6DCA,0xBE32,0x6D62,0xBD86,0x6CF9,0xBCDA,0x6C8F,0xBC2F,0x6C24,
0xBB85,0x6BB8,0xBADC,0x6B4B,0xBA33,0x6ADD,0xB98B,0x6A6E,0xB8E3,0x69FD,0xB83C,
0x698C,0xB796,0x691A,0xB6F1,0x68A7,0xB64C,0x6832,0xB5A8,0x67BD,0xB505,0x6747,
0xB462,0x66D0,0xB3C0,0x6657,0xB31F,0x65DE,0xB27F,0x6564,0xB1DF,0x64E9,0xB140,
0x646C,0xB0A2,0x63EF,0xB005,0x6371,0xAF68,0x62F2,0xAECC,0x6272,0xAE31,0x61F1,
0xAD97,0x616F,0xACFD,0x60EC,0xAC65,0x6068,0xABCD,0x5FE4,0xAB36,0x5F5E,0xAAA0,
0x5ED7,0xAA0A,0x5E50,0xA976,0x5DC8,0xA8E2,0x5D3E,0xA84F,0x5CB4,0xA7BD,0x5C29,
0xA72C,0x5B9D,0xA69C,0x5B10,0xA60C,0x5A82,0xA57E,0x59F4,0xA4F0,0x5964,0xA463,
0x58D4,0xA3D7,0x5843,0xA34C,0x57B1,0xA2C2,0x571E,0xA238,0x568A,0xA1B0,0x55F6,
0xA129,0x5560,0xA0A2,0x54CA,0xA01C,0x5433,0x9F98,0x539B,0x9F14,0x5303,0x9E91,
0x5269,0x9E0F,0x51CF,0x9D8E,0x5134,0x9D0E,0x5098,0x9C8F,0x4FFB,0x9C11,0x4F5E,
0x9B94,0x4EC0,0x9B17,0x4E21,0x9A9C,0x4D81,0x9A22,0x4CE1,0x99A9,0x4C40,0x9930,
0x4B9E,0x98B9,0x4AFB,0x9843,0x4A58,0x97CE,0x49B4,0x9759,0x490F,0x96E6,0x486A,
0x9674,0x47C4,0x9603,0x471D,0x9592,0x4675,0x9523,0x45CD,0x94B5,0x4524,0x9448,
0x447B,0x93DC,0x43D1,0x9371,0x4326,0x9307,0x427A,0x929E,0x41CE,0x9236,0x4121,
0x91CF,0x4074,0x9169,0x3FC6,0x9105,0x3F17,0x90A1,0x3E68,0x903E,0x3DB8,0x8FDD,
0x3D08,0x8F7D,0x3C57,0x8F1D,0x3BA5,0x8EBF,0x3AF3,0x8E62,0x3A40,0x8E06,0x398D,
0x8DAB,0x38D9,0x8D51,0x3825,0x8CF8,0x3770,0x8CA1,0x36BA,0x8C4A,0x3604,0x8BF5,
0x354E,0x8BA0,0x3497,0x8B4D,0x33DF,0x8AFB,0x3327,0x8AAA,0x326E,0x8A5A,0x31B5,
0x8A0C,0x30FC,0x89BE,0x3042,0x8972,0x2F87,0x8927,0x2ECC,0x88DD,0x2E11,0x8894,
0x2D55,0x884C,0x2C99,0x8805,0x2BDC,0x87C0,0x2B1F,0x877B,0x2A62,0x8738,0x29A4,
0x86F6,0x28E5,0x86B6,0x2827,0x8676,0x2768,0x8637,0x26A8,0x85FA,0x25E8,0x85BE,
0x2528,0x8583,0x2467,0x8549,0x23A7,0x8511,0x22E5,0x84D9,0x2224,0x84A3,0x2162,
0x846E,0x209F,0x843A,0x1FDD,0x8407,0x1F1A,0x83D6,0x1E57,0x83A6,0x1D93,0x8377,
0x1CD0,0x8349,0x1C0C,0x831C,0x1B47,0x82F1,0x1A83,0x82C6,0x19BE,0x829D,0x18F9,
0x8276,0x1833,0x824F,0x176E,0x822A,0x16A8,0x8205,0x15E2,0x81E2,0x151C,0x81C1,
0x1455,0x81A0,0x138F,0x8181,0x12C8,0x8163,0x1201,0x8146,0x113A,0x812A,0x1073,
0x8110,0x0FAB,0x80F6,0x0EE4,0x80DE,0x0E1C,0x80C8,0x0D54,0x80B2,0x0C8C,0x809E,
0x0BC4,0x808B,0x0AFB,0x8079,0x0A33,0x8068,0x096B,0x8059,0x08A2,0x804B,0x07D9,
0x803E,0x0711,0x8032,0x0648,0x8027,0x057F,0x801E,0x04B6,0x8016,0x03ED,0x800F,
0x0324,0x800A,0x025B,0x8006,0x0192,0x8002,0x00C9,0x8001,0x7FFF,0x0000,0x7FF6,
0xFCDC,0x7FD9,0xF9B8,0x7FA7,0xF695,0x7F62,0xF374,0x7F0A,0xF055,0x7E9D,0xED38,
0x7E1E,0xEA1E,0x7D8A,0xE707,0x7CE4,0xE3F4,0x7C2A,0xE0E6,0x7B5D,0xDDDC,0x7A7D,
0xDAD8,0x798A,0xD7D9,0x7885,0xD4E1,0x776C,0xD1EF,0x7642,0xCF04,0x7505,0xCC21,
0x73B6,0xC946,0x7255,0xC673,0x70E3,0xC3A9,0x6F5F,0xC0E9,0x6DCA,0xBE32,0x6C24,
0xBB85,0x6A6E,0xB8E3,0x68A7,0xB64C,0x66D0,0xB3C0,0x64E9,0xB140,0x62F2,0xAECC,
0x60EC,0xAC65,0x5ED7,0xAA0A,0x5CB4,0xA7BD,0x5A82,0xA57E,0x5843,0xA34C,0x55F6,
0xA129,0x539B,0x9F14,0x5134,0x9D0E,0x4EC0,0x9B17,0x4C40,0x9930,0x49B4,0x9759,
0x471D,0x9592,0x447B,0x93DC,0x41CE,0x9236,0x3F17,0x90A1,0x3C57,0x8F1D,0x398D,
0x8DAB,0x36BA,0x8C4A,0x33DF,0x8AFB,0x30FC,0x89BE,0x2E11,0x8894,0x2B1F,0x877B,
0x2827,0x8676,0x2528,0x8583,0x2224,0x84A3,0x1F1A,0x83D6,0x1C0C,0x831C,0x18F9,
0x8276,0x15E2,0x81E2,0x12C8,0x8163,0x0FAB,0x80F6,0x0C8C,0x809E,0x096B,0x8059,
0x0648,0x8027,0x0324,0x800A,0x7FFF,0x0000,0x7F62,0xF374,0x7D8A,0xE707,0x7A7D,
0xDAD8,0x7642,0xCF04,0x70E3,0xC3A9,0x6A6E,0xB8E3,0x62F2,0xAECC,0x5A82,0xA57E,
0x5134,0x9D0E,0x471D,0x9592,0x3C57,0x8F1D,0x30FC,0x89BE,0x2528,0x8583,0x18F9,
0x8276,0x0C8C,0x809E,0x7FFF,0x0000,0x7642,0xCF04,0x5A82,0xA57E,0x30FC,0x89BE,};

q15_t rearranged_twiddle_stride2_4096_q15[2728]={
0x7FFF,0x0000,0x7FFF,0xFF9B,0x7FFF,0xFF37,0x7FFF,0xFED2,0x7FFE,0xFE6E,0x7FFC,
0xFE09,0x7FFA,0xFDA5,0x7FF8,0xFD40,0x7FF6,0xFCDC,0x7FF4,0xFC77,0x7FF1,0xFC13,
0x7FED,0xFBAE,0x7FEA,0xFB4A,0x7FE6,0xFAE5,0x7FE2,0xFA81,0x7FDD,0xFA1D,0x7FD9,
0xF9B8,0x7FD3,0xF954,0x7FCE,0xF8EF,0x7FC8,0xF88B,0x7FC2,0xF827,0x7FBC,0xF7C2,
0x7FB5,0xF75E,0x7FAE,0xF6FA,0x7FA7,0xF695,0x7FA0,0xF631,0x7F98,0xF5CD,0x7F90,
0xF569,0x7F87,0xF505,0x7F7E,0xF4A0,0x7F75,0xF43C,0x7F6C,0xF3D8,0x7F62,0xF374,
0x7F58,0xF310,0x7F4E,0xF2AC,0x7F43,0xF248,0x7F38,0xF1E4,0x7F2D,0xF180,0x7F22,
0xF11C,0x7F16,0xF0B9,0x7F0A,0xF055,0x7EFD,0xEFF1,0x7EF0,0xEF8D,0x7EE3,0xEF2A,
0x7ED6,0xEEC6,0x7EC8,0xEE62,0x7EBA,0xEDFF,0x7EAC,0xED9B,0x7E9D,0xED38,0x7E8E,
0xECD5,0x7E7F,0xEC71,0x7E70,0xEC0E,0x7E60,0xEBAB,0x7E50,0xEB47,0x7E3F,0xEAE4,
0x7E2F,0xEA81,0x7E1E,0xEA1E,0x7E0C,0xE9BB,0x7DFB,0xE958,0x7DE9,0xE8F5,0x7DD6,
0xE892,0x7DC4,0xE82F,0x7DB1,0xE7CD,0x7D9E,0xE76A,0x7D8A,0xE707,0x7D77,0xE6A5,
0x7D63,0xE642,0x7D4E,0xE5E0,0x7D3A,0xE57D,0x7D25,0xE51B,0x7D0F,0xE4B9,0x7CFA,
0xE457,0x7CE4,0xE3F4,0x7CCE,0xE392,0x7CB7,0xE330,0x7CA0,0xE2CF,0x7C89,0xE26D,
0x7C72,0xE20B,0x7C5A,0xE1A9,0x7C42,0xE148,0x7C2A,0xE0E6,0x7C11,0xE085,0x7BF9,
0xE023,0x7BDF,0xDFC2,0x7BC6,0xDF61,0x7BAC,0xDEFF,0x7B92,0xDE9E,0x7B78,0xDE3D,
0x7B5D,0xDDDC,0x7B42,0xDD7C,0x7B27,0xDD1B,0x7B0B,0xDCBA,0x7AEF,0xDC59,0x7AD3,
0xDBF9,0x7AB7,0xDB99,0x7A9A,0xDB38,0x7A7D,0xDAD8,0x7A60,0xDA78,0x7A42,0xDA18,
0x7A24,0xD9B8,0x7A06,0xD958,0x79E7,0xD8F8,0x79C9,0xD898,0x79AA,0xD839,0x798A,
0xD7D9,0x796A,0xD77A,0x794A,0xD71B,0x792A,0xD6BB,0x790A,0xD65C,0x78E9,0xD5FD,
0x78C8,0xD59E,0x78A6,0xD53F,0x7885,0xD4E1,0x7863,0xD482,0x7840,0xD424,0x781E,
0xD3C5,0x77FB,0xD367,0x77D8,0xD309,0x77B4,0xD2AB,0x7790,0xD24D,0x776C,0xD1EF,
0x7748,0xD191,0x7723,0xD134,0x76FE,0xD0D6,0x76D9,0xD079,0x76B4,0xD01B,0x768E,
0xCFBE,0x7668,0xCF61,0x7642,0xCF04,0x761B,0xCEA7,0x75F4,0xCE4B,0x75CD,0xCDEE,
0x75A6,0xCD92,0x757E,0xCD35,0x7556,0xCCD9,0x752D,0xCC7D,0x7505,0xCC21,0x74DC,
0xCBC5,0x74B3,0xCB69,0x7489,0xCB0E,0x7460,0xCAB2,0x7436,0xCA57,0x740B,0xC9FC,
0x73E1,0xC9A1,0x73B6,0xC946,0x738B,0xC8EB,0x735F,0xC890,0x7334,0xC836,0x7308,
0xC7DB,0x72DC,0xC781,0x72AF,0xC727,0x7282,0xC6CD,0x7255,0xC673,0x7228,0xC619,
0x71FA,0xC5C0,0x71CC,0xC566,0x719E,0xC50D,0x7170,0xC4B4,0x7141,0xC45B,0x7112,
0xC402,0x70E3,0xC3A9,0x70B3,0xC351,0x7083,0xC2F8,0x7053,0xC2A0,0x7023,0xC248,
0x6FF2,0xC1F0,0x6FC2,0xC198,0x6F90,0xC140,0x6F5F,0xC0E9,0x6F2D,0xC091,0x6EFB,
0xC03A,0x6EC9,0xBFE3,0x6E97,0xBF8C,0x6E64,0xBF35,0x6E31,0xBEDF,0x6DFE,0xBE88,
0x6DCA,0xBE32,0x6D96,0xBDDC,0x6D62,0xBD86,0x6D2E,0xBD30,0x6CF9,0xBCDA,0x6CC4,
0xBC85,0x6C8F,0xBC2F,0x6C5A,0xBBDA,0x6C24,0xBB85,0x6BEE,0xBB30,0x6BB8,0xBADC,
0x6B82,0xBA87,0x6B4B,0xBA33,0x6B14,0xB9DF,0x6ADD,0xB98B,0x6AA5,0xB937,0x6A6E,
0xB8E3,0x6A36,0xB890,0x69FD,0xB83C,0x69C5,0xB7E9,0x698C,0xB796,0x6953,0xB743,
0x691A,0xB6F1,0x68E0,0xB69E,0x68A7,0xB64C,0x686D,0xB5FA,0x6832,0xB5A8,0x67F8,
0xB556,0x67BD,0xB505,0x6782,0xB4B3,0x6747,0xB462,0x670B,0xB411,0x66D0,0xB3C0,
0x6693,0xB36F,0x6657,0xB31F,0x661B,0xB2CF,0x65DE,0xB27F,0x65A1,0xB22F,0x6564,
0xB1DF,0x6526,0xB18F,0x64E9,0xB140,0x64AB,0xB0F1,0x646C,0xB0A2,0x642E,0xB053,
0x63EF,0xB005,0x63B0,0xAFB6,0x6371,0xAF68,0x6332,0xAF1A,0x62F2,0xAECC,0x62B2,
0xAE7F,0x6272,0xAE31,0x6232,0xADE4,0x61F1,0xAD97,0x61B0,0xAD4A,0x616F,0xACFD,
0x612E,0xACB1,0x60EC,0xAC65,0x60AA,0xAC19,0x6068,0xABCD,0x6026,0xAB81,0x5FE4,
0xAB36,0x5FA1,0xAAEB,0x5F5E,0xAAA0,0x5F1B,0xAA55,0x5ED7,0xAA0A,0x5E94,0xA9C0,
0x5E50,0xA976,0x5E0C,0xA92C,0x5DC8,0xA8E2,0x5D83,0xA899,0x5D3E,0xA84F,0x5CF9,
0xA806,0x5CB4,0xA7BD,0x5C6F,0xA774,0x5C29,0xA72C,0x5BE3,0xA6E4,0x5B9D,0xA69C,
0x5B57,0xA654,0x5B10,0xA60C,0x5AC9,0xA5C5,0x5A82,0xA57E,0x5A3B,0xA537,0x59F4,
0xA4F0,0x59AC,0xA4A9,0x5964,0xA463,0x591C,0xA41D,0x58D4,0xA3D7,0x588C,0xA391,
0x5843,0xA34C,0x57FA,0xA307,0x57B1,0xA2C2,0x5767,0xA27D,0x571E,0xA238,0x56D4,
0xA1F4,0x568A,0xA1B0,0x5640,0xA16C,0x55F6,0xA129,0x55AB,0xA0E5,0x5560,0xA0A2,
0x5515,0xA05F,0x54CA,0xA01C,0x547F,0x9FDA,0x5433,0x9F98,0x53E7,0x9F56,0x539B,
0x9F14,0x534F,0x9ED2,0x5303,0x9E91,0x52B6,0x9E50,0x5269,0x9E0F,0x521C,0x9DCE,
0x51CF,0x9D8E,0x5181,0x9D4E,0x5134,0x9D0E,0x50E6,0x9CCE,0x5098,0x9C8F,0x504A,
0x9C50,0x4FFB,0x9C11,0x4FAD,0x9BD2,0x4F5E,0x9B94,0x4F0F,0x9B55,0x4EC0,0x9B17,
0x4E71,0x9ADA,0x4E21,0x9A9C,0x4DD1,0x9A5F,0x4D81,0x9A22,0x4D31,0x99E5,0x4CE1,
0x99A9,0x4C91,0x996D,0x4C40,0x9930,0x4BEF,0x98F5,0x4B9E,0x98B9,0x4B4D,0x987E,
0x4AFB,0x9843,0x4AAA,0x9808,0x4A58,0x97CE,0x4A06,0x9793,0x49B4,0x9759,0x4962,
0x9720,0x490F,0x96E6,0x48BD,0x96AD,0x486A,0x9674,0x4817,0x963B,0x47C4,0x9603,
0x4770,0x95CA,0x471D,0x9592,0x46C9,0x955B,0x4675,0x9523,0x4621,0x94EC,0x45CD,
0x94B5,0x4579,0x947E,0x4524,0x9448,0x44D0,0x9412,0x447B,0x93DC,0x4426,0x93A6,
0x43D1,0x9371,0x437B,0x933C,0x4326,0x9307,0x42D0,0x92D2,0x427A,0x929E,0x4224,
0x926A,0x41CE,0x9236,0x4178,0x9202,0x4121,0x91CF,0x40CB,0x919C,0x4074,0x9169,
0x401D,0x9137,0x3FC6,0x9105,0x3F6F,0x90D3,0x3F17,0x90A1,0x3EC0,0x9070,0x3E68,
0x903E,0x3E10,0x900E,0x3DB8,0x8FDD,0x3D60,0x8FAD,0x3D08,0x8F7D,0x3CAF,0x8F4D,
0x3C57,0x8F1D,0x3BFE,0x8EEE,0x3BA5,0x8EBF,0x3B4C,0x8E90,0x3AF3,0x8E62,0x3A9A,
0x8E34,0x3A40,0x8E06,0x39E7,0x8DD8,0x398D,0x8DAB,0x3933,0x8D7E,0x38D9,0x8D51,
0x387F,0x8D24,0x3825,0x8CF8,0x37CA,0x8CCC,0x3770,0x8CA1,0x3715,0x8C75,0x36BA,
0x8C4A,0x365F,0x8C1F,0x3604,0x8BF5,0x35A9,0x8BCA,0x354E,0x8BA0,0x34F2,0x8B77,
0x3497,0x8B4D,0x343B,0x8B24,0x33DF,0x8AFB,0x3383,0x8AD3,0x3327,0x8AAA,0x32CB,
0x8A82,0x326E,0x8A5A,0x3212,0x8A33,0x31B5,0x8A0C,0x3159,0x89E5,0x30FC,0x89BE,
0x309F,0x8998,0x3042,0x8972,0x2FE5,0x894C,0x2F87,0x8927,0x2F2A,0x8902,0x2ECC,
0x88DD,0x2E6F,0x88B8,0x2E11,0x8894,0x2DB3,0x8870,0x2D55,0x884C,0x2CF7,0x8828,
0x2C99,0x8805,0x2C3B,0x87E2,0x2BDC,0x87C0,0x2B7E,0x879D,0x2B1F,0x877B,0x2AC1,
0x875A,0x2A62,0x8738,0x2A03,0x8717,0x29A4,0x86F6,0x2945,0x86D6,0x28E5,0x86B6,
0x2886,0x8696,0x2827,0x8676,0x27C7,0x8656,0x2768,0x8637,0x2708,0x8619,0x26A8,
0x85FA,0x2648,0x85DC,0x25E8,0x85BE,0x2588,0x85A0,0x2528,0x8583,0x24C8,0x8566,
0x2467,0x8549,0x2407,0x852D,0x23A7,0x8511,0x2346,0x84F5,0x22E5,0x84D9,0x2284,
0x84BE,0x2224,0x84A3,0x21C3,0x8488,0x2162,0x846E,0x2101,0x8454,0x209F,0x843A,
0x203E,0x8421,0x1FDD,0x8407,0x1F7B,0x83EF,0x1F1A,0x83D6,0x1EB8,0x83BE,0x1E57,
0x83A6,0x1DF5,0x838E,0x1D93,0x8377,0x1D31,0x8360,0x1CD0,0x8349,0x1C6E,0x8332,
0x1C0C,0x831C,0x1BA9,0x8306,0x1B47,0x82F1,0x1AE5,0x82DB,0x1A83,0x82C6,0x1A20,
0x82B2,0x19BE,0x829D,0x195B,0x8289,0x18F9,0x8276,0x1896,0x8262,0x1833,0x824F,
0x17D1,0x823C,0x176E,0x822A,0x170B,0x8217,0x16A8,0x8205,0x1645,0x81F4,0x15E2,
0x81E2,0x157F,0x81D1,0x151C,0x81C1,0x14B9,0x81B0,0x1455,0x81A0,0x13F2,0x8190,
0x138F,0x8181,0x132B,0x8172,0x12C8,0x8163,0x1265,0x8154,0x1201,0x8146,0x119E,
0x8138,0x113A,0x812A,0x10D6,0x811D,0x1073,0x8110,0x100F,0x8103,0x0FAB,0x80F6,
0x0F47,0x80EA,0x0EE4,0x80DE,0x0E80,0x80D3,0x0E1C,0x80C8,0x0DB8,0x80BD,0x0D54,
0x80B2,0x0CF0,0x80A8,0x0C8C,0x809E,0x0C28,0x8094,0x0BC4,0x808B,0x0B60,0x8082,
0x0AFB,0x8079,0x0A97,0x8070,0x0A33,0x8068,0x09CF,0x8060,0x096B,0x8059,0x0906,
0x8052,0x08A2,0x804B,0x083E,0x8044,0x07D9,0x803E,0x0775,0x8038,0x0711,0x8032,
0x06AC,0x802D,0x0648,0x8027,0x05E3,0x8023,0x057F,0x801E,0x051B,0x801A,0x04B6,
0x8016,0x0452,0x8013,0x03ED,0x800F,0x0389,0x800C,0x0324,0x800A,0x02C0,0x8008,
0x025B,0x8006,0x01F7,0x8004,0x0192,0x8002,0x012E,0x8001,0x00C9,0x8001,0x0065,
0x8000,0x0000,0x8000,0xFF9B,0x8000,0xFF37,0x8001,0xFED2,0x8001,0xFE6E,0x8002,
0xFE09,0x8004,0xFDA5,0x8006,0xFD40,0x8008,0xFCDC,0x800A,0xFC77,0x800C,0xFC13,
0x800F,0xFBAE,0x8013,0xFB4A,0x8016,0xFAE5,0x801A,0xFA81,0x801E,0xFA1D,0x8023,
0xF9B8,0x8027,0xF954,0x802D,0xF8EF,0x8032,0xF88B,0x8038,0xF827,0x803E,0xF7C2,
0x8044,0xF75E,0x804B,0xF6FA,0x8052,0xF695,0x8059,0xF631,0x8060,0xF5CD,0x8068,
0xF569,0x8070,0xF505,0x8079,0xF4A0,0x8082,0xF43C,0x808B,0xF3D8,0x8094,0xF374,
0x809E,0xF310,0x80A8,0xF2AC,0x80B2,0xF248,0x80BD,0xF1E4,0x80C8,0xF180,0x80D3,
0xF11C,0x80DE,0xF0B9,0x80EA,0xF055,0x80F6,0xEFF1,0x8103,0xEF8D,0x8110,0xEF2A,
0x811D,0xEEC6,0x812A,0xEE62,0x8138,0xEDFF,0x8146,0xED9B,0x8154,0xED38,0x8163,
0xECD5,0x8172,0xEC71,0x8181,0xEC0E,0x8190,0xEBAB,0x81A0,0xEB47,0x81B0,0xEAE4,
0x81C1,0xEA81,0x81D1,0xEA1E,0x81E2,0xE9BB,0x81F4,0xE958,0x8205,0xE8F5,0x8217,
0xE892,0x822A,0xE82F,0x823C,0xE7CD,0x824F,0xE76A,0x8262,0xE707,0x8276,0xE6A5,
0x8289,0xE642,0x829D,0xE5E0,0x82B2,0xE57D,0x82C6,0xE51B,0x82DB,0xE4B9,0x82F1,
0xE457,0x8306,0xE3F4,0x831C,0xE392,0x8332,0xE330,0x8349,0xE2CF,0x8360,0xE26D,
0x8377,0xE20B,0x838E,0xE1A9,0x83A6,0xE148,0x83BE,0xE0E6,0x83D6,0xE085,0x83EF,
0xE023,0x8407,0xDFC2,0x8421,0xDF61,0x843A,0xDEFF,0x8454,0xDE9E,0x846E,0xDE3D,
0x8488,0xDDDC,0x84A3,0xDD7C,0x84BE,0xDD1B,0x84D9,0xDCBA,0x84F5,0xDC59,0x8511,
0xDBF9,0x852D,0xDB99,0x8549,0xDB38,0x8566,0xDAD8,0x8583,0xDA78,0x85A0,0xDA18,
0x85BE,0xD9B8,0x85DC,0xD958,0x85FA,0xD8F8,0x8619,0xD898,0x8637,0xD839,0x8656,
0xD7D9,0x8676,0xD77A,0x8696,0xD71B,0x86B6,0xD6BB,0x86D6,0xD65C,0x86F6,0xD5FD,
0x8717,0xD59E,0x8738,0xD53F,0x875A,0xD4E1,0x877B,0xD482,0x879D,0xD424,0x87C0,
0xD3C5,0x87E2,0xD367,0x8805,0xD309,0x8828,0xD2AB,0x884C,0xD24D,0x8870,0xD1EF,
0x8894,0xD191,0x88B8,0xD134,0x88DD,0xD0D6,0x8902,0xD079,0x8927,0xD01B,0x894C,
0xCFBE,0x8972,0xCF61,0x8998,0xCF04,0x89BE,0xCEA7,0x89E5,0xCE4B,0x8A0C,0xCDEE,
0x8A33,0xCD92,0x8A5A,0xCD35,0x8A82,0xCCD9,0x8AAA,0xCC7D,0x8AD3,0xCC21,0x8AFB,
0xCBC5,0x8B24,0xCB69,0x8B4D,0xCB0E,0x8B77,0xCAB2,0x8BA0,0xCA57,0x8BCA,0xC9FC,
0x8BF5,0xC9A1,0x8C1F,0xC946,0x8C4A,0xC8EB,0x8C75,0xC890,0x8CA1,0xC836,0x8CCC,
0xC7DB,0x8CF8,0xC781,0x8D24,0xC727,0x8D51,0xC6CD,0x8D7E,0xC673,0x8DAB,0xC619,
0x8DD8,0xC5C0,0x8E06,0xC566,0x8E34,0xC50D,0x8E62,0xC4B4,0x8E90,0xC45B,0x8EBF,
0xC402,0x8EEE,0xC3A9,0x8F1D,0xC351,0x8F4D,0xC2F8,0x8F7D,0xC2A0,0x8FAD,0xC248,
0x8FDD,0xC1F0,0x900E,0xC198,0x903E,0xC140,0x9070,0xC0E9,0x90A1,0xC091,0x90D3,
0xC03A,0x9105,0xBFE3,0x9137,0xBF8C,0x9169,0xBF35,0x919C,0xBEDF,0x91CF,0xBE88,
0x9202,0xBE32,0x9236,0xBDDC,0x926A,0xBD86,0x929E,0xBD30,0x92D2,0xBCDA,0x9307,
0xBC85,0x933C,0xBC2F,0x9371,0xBBDA,0x93A6,0xBB85,0x93DC,0xBB30,0x9412,0xBADC,
0x9448,0xBA87,0x947E,0xBA33,0x94B5,0xB9DF,0x94EC,0xB98B,0x9523,0xB937,0x955B,
0xB8E3,0x9592,0xB890,0x95CA,0xB83C,0x9603,0xB7E9,0x963B,0xB796,0x9674,0xB743,
0x96AD,0xB6F1,0x96E6,0xB69E,0x9720,0xB64C,0x9759,0xB5FA,0x9793,0xB5A8,0x97CE,
0xB556,0x9808,0xB505,0x9843,0xB4B3,0x987E,0xB462,0x98B9,0xB411,0x98F5,0xB3C0,
0x9930,0xB36F,0x996D,0xB31F,0x99A9,0xB2CF,0x99E5,0xB27F,0x9A22,0xB22F,0x9A5F,
0xB1DF,0x9A9C,0xB18F,0x9ADA,0xB140,0x9B17,0xB0F1,0x9B55,0xB0A2,0x9B94,0xB053,
0x9BD2,0xB005,0x9C11,0xAFB6,0x9C50,0xAF68,0x9C8F,0xAF1A,0x9CCE,0xAECC,0x9D0E,
0xAE7F,0x9D4E,0xAE31,0x9D8E,0xADE4,0x9DCE,0xAD97,0x9E0F,0xAD4A,0x9E50,0xACFD,
0x9E91,0xACB1,0x9ED2,0xAC65,0x9F14,0xAC19,0x9F56,0xABCD,0x9F98,0xAB81,0x9FDA,
0xAB36,0xA01C,0xAAEB,0xA05F,0xAAA0,0xA0A2,0xAA55,0xA0E5,0xAA0A,0xA129,0xA9C0,
0xA16C,0xA976,0xA1B0,0xA92C,0xA1F4,0xA8E2,0xA238,0xA899,0xA27D,0xA84F,0xA2C2,
0xA806,0xA307,0xA7BD,0xA34C,0xA774,0xA391,0xA72C,0xA3D7,0xA6E4,0xA41D,0xA69C,
0xA463,0xA654,0xA4A9,0xA60C,0xA4F0,0xA5C5,0xA537,0xA57E,0xA57E,0xA537,0xA5C5,
0xA4F0,0xA60C,0xA4A9,0xA654,0xA463,0xA69C,0xA41D,0xA6E4,0xA3D7,0xA72C,0xA391,
0xA774,0xA34C,0xA7BD,0xA307,0xA806,0xA2C2,0xA84F,0xA27D,0xA899,0xA238,0xA8E2,
0xA1F4,0xA92C,0xA1B0,0xA976,0xA16C,0xA9C0,0xA129,0xAA0A,0xA0E5,0xAA55,0xA0A2,
0xAAA0,0xA05F,0xAAEB,0xA01C,0xAB36,0x9FDA,0xAB81,0x9F98,0xABCD,0x9F56,0xAC19,
0x9F14,0xAC65,0x9ED2,0xACB1,0x9E91,0xACFD,0x9E50,0xAD4A,0x9E0F,0xAD97,0x9DCE,
0xADE4,0x9D8E,0xAE31,0x9D4E,0xAE7F,0x9D0E,0xAECC,0x9CCE,0xAF1A,0x9C8F,0xAF68,
0x9C50,0xAFB6,0x9C11,0xB005,0x9BD2,0xB053,0x9B94,0xB0A2,0x9B55,0xB0F1,0x9B17,
0xB140,0x9ADA,0xB18F,0x9A9C,0xB1DF,0x9A5F,0xB22F,0x9A22,0xB27F,0x99E5,0xB2CF,
0x99A9,0xB31F,0x996D,0xB36F,0x9930,0xB3C0,0x98F5,0xB411,0x98B9,0xB462,0x987E,
0xB4B3,0x9843,0xB505,0x9808,0xB556,0x97CE,0xB5A8,0x9793,0xB5FA,0x9759,0xB64C,
0x9720,0xB69E,0x96E6,0xB6F1,0x96AD,0xB743,0x9674,0xB796,0x963B,0xB7E9,0x9603,
0xB83C,0x95CA,0xB890,0x9592,0xB8E3,0x955B,0xB937,0x9523,0xB98B,0x94EC,0xB9DF,
0x94B5,0xBA33,0x947E,0xBA87,0x9448,0xBADC,0x9412,0xBB30,0x93DC,0xBB85,0x93A6,
0xBBDA,0x9371,0xBC2F,0x933C,0xBC85,0x9307,0xBCDA,0x92D2,0xBD30,0x929E,0xBD86,
0x926A,0xBDDC,0x9236,0xBE32,0x9202,0xBE88,0x91CF,0xBEDF,0x919C,0xBF35,0x9169,
0xBF8C,0x9137,0xBFE3,0x9105,0xC03A,0x90D3,0xC091,0x90A1,0xC0E9,0x9070,0xC140,
0x903E,0xC198,0x900E,0xC1F0,0x8FDD,0xC248,0x8FAD,0xC2A0,0x8F7D,0xC2F8,0x8F4D,
0xC351,0x8F1D,0xC3A9,0x8EEE,0xC402,0x8EBF,0xC45B,0x8E90,0xC4B4,0x8E62,0xC50D,
0x8E34,0xC566,0x8E06,0xC5C0,0x8DD8,0xC619,0x8DAB,0xC673,0x8D7E,0xC6CD,0x8D51,
0xC727,0x8D24,0xC781,0x8CF8,0xC7DB,0x8CCC,0xC836,0x8CA1,0xC890,0x8C75,0xC8EB,
0x8C4A,0xC946,0x8C1F,0xC9A1,0x8BF5,0xC9FC,0x8BCA,0xCA57,0x8BA0,0xCAB2,0x8B77,
0xCB0E,0x8B4D,0xCB69,0x8B24,0xCBC5,0x8AFB,0xCC21,0x8AD3,0xCC7D,0x8AAA,0xCCD9,
0x8A82,0xCD35,0x8A5A,0xCD92,0x8A33,0xCDEE,0x8A0C,0xCE4B,0x89E5,0xCEA7,0x89BE,
0xCF04,0x8998,0xCF61,0x8972,0xCFBE,0x894C,0xD01B,0x8927,0xD079,0x8902,0xD0D6,
0x88DD,0xD134,0x88B8,0xD191,0x8894,0xD1EF,0x8870,0xD24D,0x884C,0xD2AB,0x8828,
0xD309,0x8805,0xD367,0x87E2,0xD3C5,0x87C0,0xD424,0x879D,0xD482,0x877B,0xD4E1,
0x875A,0xD53F,0x8738,0xD59E,0x8717,0xD5FD,0x86F6,0xD65C,0x86D6,0xD6BB,0x86B6,
0xD71B,0x8696,0xD77A,0x8676,0xD7D9,0x8656,0xD839,0x8637,0xD898,0x8619,0xD8F8,
0x85FA,0xD958,0x85DC,0xD9B8,0x85BE,0xDA18,0x85A0,0xDA78,0x8583,0xDAD8,0x8566,
0xDB38,0x8549,0xDB99,0x852D,0xDBF9,0x8511,0xDC59,0x84F5,0xDCBA,0x84D9,0xDD1B,
0x84BE,0xDD7C,0x84A3,0xDDDC,0x8488,0xDE3D,0x846E,0xDE9E,0x8454,0xDEFF,0x843A,
0xDF61,0x8421,0xDFC2,0x8407,0xE023,0x83EF,0xE085,0x83D6,0xE0E6,0x83BE,0xE148,
0x83A6,0xE1A9,0x838E,0xE20B,0x8377,0xE26D,0x8360,0xE2CF,0x8349,0xE330,0x8332,
0xE392,0x831C,0xE3F4,0x8306,0xE457,0x82F1,0xE4B9,0x82DB,0xE51B,0x82C6,0xE57D,
0x82B2,0xE5E0,0x829D,0xE642,0x8289,0xE6A5,0x8276,0xE707,0x8262,0xE76A,0x824F,
0xE7CD,0x823C,0xE82F,0x822A,0xE892,0x8217,0xE8F5,0x8205,0xE958,0x81F4,0xE9BB,
0x81E2,0xEA1E,0x81D1,0xEA81,0x81C1,0xEAE4,0x81B0,0xEB47,0x81A0,0xEBAB,0x8190,
0xEC0E,0x8181,0xEC71,0x8172,0xECD5,0x8163,0xED38,0x8154,0xED9B,0x8146,0xEDFF,
0x8138,0xEE62,0x812A,0xEEC6,0x811D,0xEF2A,0x8110,0xEF8D,0x8103,0xEFF1,0x80F6,
0xF055,0x80EA,0xF0B9,0x80DE,0xF11C,0x80D3,0xF180,0x80C8,0xF1E4,0x80BD,0xF248,
0x80B2,0xF2AC,0x80A8,0xF310,0x809E,0xF374,0x8094,0xF3D8,0x808B,0xF43C,0x8082,
0xF4A0,0x8079,0xF505,0x8070,0xF569,0x8068,0xF5CD,0x8060,0xF631,0x8059,0xF695,
0x8052,0xF6FA,0x804B,0xF75E,0x8044,0xF7C2,0x803E,0xF827,0x8038,0xF88B,0x8032,
0xF8EF,0x802D,0xF954,0x8027,0xF9B8,0x8023,0xFA1D,0x801E,0xFA81,0x801A,0xFAE5,
0x8016,0xFB4A,0x8013,0xFBAE,0x800F,0xFC13,0x800C,0xFC77,0x800A,0xFCDC,0x8008,
0xFD40,0x8006,0xFDA5,0x8004,0xFE09,0x8002,0xFE6E,0x8001,0xFED2,0x8001,0xFF37,
0x8000,0xFF9B,0x7FFF,0x0000,0x7FFE,0xFE6E,0x7FF6,0xFCDC,0x7FEA,0xFB4A,0x7FD9,
0xF9B8,0x7FC2,0xF827,0x7FA7,0xF695,0x7F87,0xF505,0x7F62,0xF374,0x7F38,0xF1E4,
0x7F0A,0xF055,0x7ED6,0xEEC6,0x7E9D,0xED38,0x7E60,0xEBAB,0x7E1E,0xEA1E,0x7DD6,
0xE892,0x7D8A,0xE707,0x7D3A,0xE57D,0x7CE4,0xE3F4,0x7C89,0xE26D,0x7C2A,0xE0E6,
0x7BC6,0xDF61,0x7B5D,0xDDDC,0x7AEF,0xDC59,0x7A7D,0xDAD8,0x7A06,0xD958,0x798A,
0xD7D9,0x790A,0xD65C,0x7885,0xD4E1,0x77FB,0xD367,0x776C,0xD1EF,0x76D9,0xD079,
0x7642,0xCF04,0x75A6,0xCD92,0x7505,0xCC21,0x7460,0xCAB2,0x73B6,0xC946,0x7308,
0xC7DB,0x7255,0xC673,0x719E,0xC50D,0x70E3,0xC3A9,0x7023,0xC248,0x6F5F,0xC0E9,
0x6E97,0xBF8C,0x6DCA,0xBE32,0x6CF9,0xBCDA,0x6C24,0xBB85,0x6B4B,0xBA33,0x6A6E,
0xB8E3,0x698C,0xB796,0x68A7,0xB64C,0x67BD,0xB505,0x66D0,0xB3C0,0x65DE,0xB27F,
0x64E9,0xB140,0x63EF,0xB005,0x62F2,0xAECC,0x61F1,0xAD97,0x60EC,0xAC65,0x5FE4,
0xAB36,0x5ED7,0xAA0A,0x5DC8,0xA8E2,0x5CB4,0xA7BD,0x5B9D,0xA69C,0x5A82,0xA57E,
0x5964,0xA463,0x5843,0xA34C,0x571E,0xA238,0x55F6,0xA129,0x54CA,0xA01C,0x539B,
0x9F14,0x5269,0x9E0F,0x5134,0x9D0E,0x4FFB,0x9C11,0x4EC0,0x9B17,0x4D81,0x9A22,
0x4C40,0x9930,0x4AFB,0x9843,0x49B4,0x9759,0x486A,0x9674,0x471D,0x9592,0x45CD,
0x94B5,0x447B,0x93DC,0x4326,0x9307,0x41CE,0x9236,0x4074,0x9169,0x3F17,0x90A1,
0x3DB8,0x8FDD,0x3C57,0x8F1D,0x3AF3,0x8E62,0x398D,0x8DAB,0x3825,0x8CF8,0x36BA,
0x8C4A,0x354E,0x8BA0,0x33DF,0x8AFB,0x326E,0x8A5A,0x30FC,0x89BE,0x2F87,0x8927,
0x2E11,0x8894,0x2C99,0x8805,0x2B1F,0x877B,0x29A4,0x86F6,0x2827,0x8676,0x26A8,
0x85FA,0x2528,0x8583,0x23A7,0x8511,0x2224,0x84A3,0x209F,0x843A,0x1F1A,0x83D6,
0x1D93,0x8377,0x1C0C,0x831C,0x1A83,0x82C6,0x18F9,0x8276,0x176E,0x822A,0x15E2,
0x81E2,0x1455,0x81A0,0x12C8,0x8163,0x113A,0x812A,0x0FAB,0x80F6,0x0E1C,0x80C8,
0x0C8C,0x809E,0x0AFB,0x8079,0x096B,0x8059,0x07D9,0x803E,0x0648,0x8027,0x04B6,
0x8016,0x0324,0x800A,0x0192,0x8002,0x0000,0x8000,0xFE6E,0x8002,0xFCDC,0x800A,
0xFB4A,0x8016,0xF9B8,0x8027,0xF827,0x803E,0xF695,0x8059,0xF505,0x8079,0xF374,
0x809E,0xF1E4,0x80C8,0xF055,0x80F6,0xEEC6,0x812A,0xED38,0x8163,0xEBAB,0x81A0,
0xEA1E,0x81E2,0xE892,0x822A,0xE707,0x8276,0xE57D,0x82C6,0xE3F4,0x831C,0xE26D,
0x8377,0xE0E6,0x83D6,0xDF61,0x843A,0xDDDC,0x84A3,0xDC59,0x8511,0xDAD8,0x8583,
0xD958,0x85FA,0xD7D9,0x8676,0xD65C,0x86F6,0xD4E1,0x877B,0xD367,0x8805,0xD1EF,
0x8894,0xD079,0x8927,0xCF04,0x89BE,0xCD92,0x8A5A,0xCC21,0x8AFB,0xCAB2,0x8BA0,
0xC946,0x8C4A,0xC7DB,0x8CF8,0xC673,0x8DAB,0xC50D,0x8E62,0xC3A9,0x8F1D,0xC248,
0x8FDD,0xC0E9,0x90A1,0xBF8C,0x9169,0xBE32,0x9236,0xBCDA,0x9307,0xBB85,0x93DC,
0xBA33,0x94B5,0xB8E3,0x9592,0xB796,0x9674,0xB64C,0x9759,0xB505,0x9843,0xB3C0,
0x9930,0xB27F,0x9A22,0xB140,0x9B17,0xB005,0x9C11,0xAECC,0x9D0E,0xAD97,0x9E0F,
0xAC65,0x9F14,0xAB36,0xA01C,0xAA0A,0xA129,0xA8E2,0xA238,0xA7BD,0xA34C,0xA69C,
0xA463,0xA57E,0xA57E,0xA463,0xA69C,0xA34C,0xA7BD,0xA238,0xA8E2,0xA129,0xAA0A,
0xA01C,0xAB36,0x9F14,0xAC65,0x9E0F,0xAD97,0x9D0E,0xAECC,0x9C11,0xB005,0x9B17,
0xB140,0x9A22,0xB27F,0x9930,0xB3C0,0x9843,0xB505,0x9759,0xB64C,0x9674,0xB796,
0x9592,0xB8E3,0x94B5,0xBA33,0x93DC,0xBB85,0x9307,0xBCDA,0x9236,0xBE32,0x9169,
0xBF8C,0x90A1,0xC0E9,0x8FDD,0xC248,0x8F1D,0xC3A9,0x8E62,0xC50D,0x8DAB,0xC673,
0x8CF8,0xC7DB,0x8C4A,0xC946,0x8BA0,0xCAB2,0x8AFB,0xCC21,0x8A5A,0xCD92,0x89BE,
0xCF04,0x8927,0xD079,0x8894,0xD1EF,0x8805,0xD367,0x877B,0xD4E1,0x86F6,0xD65C,
0x8676,0xD7D9,0x85FA,0xD958,0x8583,0xDAD8,0x8511,0xDC59,0x84A3,0xDDDC,0x843A,
0xDF61,0x83D6,0xE0E6,0x8377,0xE26D,0x831C,0xE3F4,0x82C6,0xE57D,0x8276,0xE707,
0x822A,0xE892,0x81E2,0xEA1E,0x81A0,0xEBAB,0x8163,0xED38,0x812A,0xEEC6,0x80F6,
0xF055,0x80C8,0xF1E4,0x809E,0xF374,0x8079,0xF505,0x8059,0xF695,0x803E,0xF827,
0x8027,0xF9B8,0x8016,0xFB4A,0x800A,0xFCDC,0x8002,0xFE6E,0x7FFF,0x0000,0x7FD9,
0xF9B8,0x7F62,0xF374,0x7E9D,0xED38,0x7D8A,0xE707,0x7C2A,0xE0E6,0x7A7D,0xDAD8,
0x7885,0xD4E1,0x7642,0xCF04,0x73B6,0xC946,0x70E3,0xC3A9,0x6DCA,0xBE32,0x6A6E,
0xB8E3,0x66D0,0xB3C0,0x62F2,0xAECC,0x5ED7,0xAA0A,0x5A82,0xA57E,0x55F6,0xA129,
0x5134,0x9D0E,0x4C40,0x9930,0x471D,0x9592,0x41CE,0x9236,0x3C57,0x8F1D,0x36BA,
0x8C4A,0x30FC,0x89BE,0x2B1F,0x877B,0x2528,0x8583,0x1F1A,0x83D6,0x18F9,0x8276,
0x12C8,0x8163,0x0C8C,0x809E,0x0648,0x8027,0x0000,0x8000,0xF9B8,0x8027,0xF374,
0x809E,0xED38,0x8163,0xE707,0x8276,0xE0E6,0x83D6,0xDAD8,0x8583,0xD4E1,0x877B,
0xCF04,0x89BE,0xC946,0x8C4A,0xC3A9,0x8F1D,0xBE32,0x9236,0xB8E3,0x9592,0xB3C0,
0x9930,0xAECC,0x9D0E,0xAA0A,0xA129,0xA57E,0xA57E,0xA129,0xAA0A,0x9D0E,0xAECC,
0x9930,0xB3C0,0x9592,0xB8E3,0x9236,0xBE32,0x8F1D,0xC3A9,0x8C4A,0xC946,0x89BE,
0xCF04,0x877B,0xD4E1,0x8583,0xDAD8,0x83D6,0xE0E6,0x8276,0xE707,0x8163,0xED38,
0x809E,0xF374,0x8027,0xF9B8,0x7FFF,0x0000,0x7D8A,0xE707,0x7642,0xCF04,0x6A6E,
0xB8E3,0x5A82,0xA57E,0x471D,0x9592,0x30FC,0x89BE,0x18F9,0x8276,0x0000,0x8000,
0xE707,0x8276,0xCF04,0x89BE,0xB8E3,0x9592,0xA57E,0xA57E,0x9592,0xB8E3,0x89BE,
0xCF04,0x8276,0xE707,0x7FFF,0x0000,0x5A82,0xA57E,0x0000,0x8000,0xA57E,0xA57E,};

q15_t rearranged_twiddle_stride3_4096_q15[2728]={
0x7FFF,0x0000,0x7FFF,0xFF69,0x7FFF,0xFED2,0x7FFD,0xFE3C,0x7FFA,0xFDA5,0x7FF7,
0xFD0E,0x7FF4,0xFC77,0x7FEF,0xFBE1,0x7FEA,0xFB4A,0x7FE4,0xFAB3,0x7FDD,0xFA1D,
0x7FD6,0xF986,0x7FCE,0xF8EF,0x7FC5,0xF859,0x7FBC,0xF7C2,0x7FB2,0xF72C,0x7FA7,
0xF695,0x7F9C,0xF5FF,0x7F90,0xF569,0x7F83,0xF4D3,0x7F75,0xF43C,0x7F67,0xF3A6,
0x7F58,0xF310,0x7F49,0xF27A,0x7F38,0xF1E4,0x7F27,0xF14E,0x7F16,0xF0B9,0x7F03,
0xF023,0x7EF0,0xEF8D,0x7EDD,0xEEF8,0x7EC8,0xEE62,0x7EB3,0xEDCD,0x7E9D,0xED38,
0x7E87,0xECA3,0x7E70,0xEC0E,0x7E58,0xEB79,0x7E3F,0xEAE4,0x7E26,0xEA4F,0x7E0C,
0xE9BB,0x7DF2,0xE926,0x7DD6,0xE892,0x7DBA,0xE7FE,0x7D9E,0xE76A,0x7D81,0xE6D6,
0x7D63,0xE642,0x7D44,0xE5AF,0x7D25,0xE51B,0x7D05,0xE488,0x7CE4,0xE3F4,0x7CC2,
0xE361,0x7CA0,0xE2CF,0x7C7E,0xE23C,0x7C5A,0xE1A9,0x7C36,0xE117,0x7C11,0xE085,
0x7BEC,0xDFF2,0x7BC6,0xDF61,0x7B9F,0xDECF,0x7B78,0xDE3D,0x7B50,0xDDAC,0x7B27,
0xDD1B,0x7AFD,0xDC8A,0x7AD3,0xDBF9,0x7AA8,0xDB68,0x7A7D,0xDAD8,0x7A51,0xDA48,
0x7A24,0xD9B8,0x79F7,0xD928,0x79C9,0xD898,0x799A,0xD809,0x796A,0xD77A,0x793A,
0xD6EB,0x790A,0xD65C,0x78D8,0xD5CE,0x78A6,0xD53F,0x7874,0xD4B1,0x7840,0xD424,
0x780C,0xD396,0x77D8,0xD309,0x77A2,0xD27C,0x776C,0xD1EF,0x7736,0xD162,0x76FE,
0xD0D6,0x76C7,0xD04A,0x768E,0xCFBE,0x7655,0xCF33,0x761B,0xCEA7,0x75E1,0xCE1C,
0x75A6,0xCD92,0x756A,0xCD07,0x752D,0xCC7D,0x74F0,0xCBF3,0x74B3,0xCB69,0x7475,
0xCAE0,0x7436,0xCA57,0x73F6,0xC9CE,0x73B6,0xC946,0x7375,0xC8BE,0x7334,0xC836,
0x72F2,0xC7AE,0x72AF,0xC727,0x726C,0xC6A0,0x7228,0xC619,0x71E3,0xC593,0x719E,
0xC50D,0x7158,0xC487,0x7112,0xC402,0x70CB,0xC37D,0x7083,0xC2F8,0x703B,0xC274,
0x6FF2,0xC1F0,0x6FA9,0xC16C,0x6F5F,0xC0E9,0x6F14,0xC066,0x6EC9,0xBFE3,0x6E7D,
0xBF61,0x6E31,0xBEDF,0x6DE4,0xBE5D,0x6D96,0xBDDC,0x6D48,0xBD5B,0x6CF9,0xBCDA,
0x6CAA,0xBC5A,0x6C5A,0xBBDA,0x6C09,0xBB5B,0x6BB8,0xBADC,0x6B66,0xBA5D,0x6B14,
0xB9DF,0x6AC1,0xB961,0x6A6E,0xB8E3,0x6A1A,0xB866,0x69C5,0xB7E9,0x6970,0xB76D,
0x691A,0xB6F1,0x68C4,0xB675,0x686D,0xB5FA,0x6815,0xB57F,0x67BD,0xB505,0x6764,
0xB48B,0x670B,0xB411,0x66B2,0xB398,0x6657,0xB31F,0x65FC,0xB2A7,0x65A1,0xB22F,
0x6545,0xB1B7,0x64E9,0xB140,0x648B,0xB0C9,0x642E,0xB053,0x63D0,0xAFDD,0x6371,
0xAF68,0x6312,0xAEF3,0x62B2,0xAE7F,0x6252,0xAE0B,0x61F1,0xAD97,0x6190,0xAD24,
0x612E,0xACB1,0x60CB,0xAC3F,0x6068,0xABCD,0x6005,0xAB5C,0x5FA1,0xAAEB,0x5F3C,
0xAA7A,0x5ED7,0xAA0A,0x5E72,0xA99B,0x5E0C,0xA92C,0x5DA5,0xA8BD,0x5D3E,0xA84F,
0x5CD7,0xA7E2,0x5C6F,0xA774,0x5C06,0xA708,0x5B9D,0xA69C,0x5B34,0xA630,0x5AC9,
0xA5C5,0x5A5F,0xA55A,0x59F4,0xA4F0,0x5988,0xA486,0x591C,0xA41D,0x58B0,0xA3B4,
0x5843,0xA34C,0x57D5,0xA2E4,0x5767,0xA27D,0x56F9,0xA216,0x568A,0xA1B0,0x561B,
0xA14A,0x55AB,0xA0E5,0x553B,0xA080,0x54CA,0xA01C,0x5459,0x9FB9,0x53E7,0x9F56,
0x5375,0x9EF3,0x5303,0x9E91,0x5290,0x9E2F,0x521C,0x9DCE,0x51A8,0x9D6E,0x5134,
0x9D0E,0x50BF,0x9CAF,0x504A,0x9C50,0x4FD4,0x9BF1,0x4F5E,0x9B94,0x4EE8,0x9B36,
0x4E71,0x9ADA,0x4DF9,0x9A7E,0x4D81,0x9A22,0x4D09,0x99C7,0x4C91,0x996D,0x4C17,
0x9913,0x4B9E,0x98B9,0x4B24,0x9860,0x4AAA,0x9808,0x4A2F,0x97B0,0x49B4,0x9759,
0x4939,0x9703,0x48BD,0x96AD,0x4840,0x9657,0x47C4,0x9603,0x4747,0x95AE,0x46C9,
0x955B,0x464B,0x9508,0x45CD,0x94B5,0x454F,0x9463,0x44D0,0x9412,0x4450,0x93C1,
0x43D1,0x9371,0x4351,0x9321,0x42D0,0x92D2,0x424F,0x9284,0x41CE,0x9236,0x414D,
0x91E9,0x40CB,0x919C,0x4048,0x9150,0x3FC6,0x9105,0x3F43,0x90BA,0x3EC0,0x9070,
0x3E3C,0x9026,0x3DB8,0x8FDD,0x3D34,0x8F95,0x3CAF,0x8F4D,0x3C2A,0x8F06,0x3BA5,
0x8EBF,0x3B20,0x8E79,0x3A9A,0x8E34,0x3A13,0x8DEF,0x398D,0x8DAB,0x3906,0x8D67,
0x387F,0x8D24,0x37F7,0x8CE2,0x3770,0x8CA1,0x36E8,0x8C60,0x365F,0x8C1F,0x35D7,
0x8BDF,0x354E,0x8BA0,0x34C4,0x8B62,0x343B,0x8B24,0x33B1,0x8AE7,0x3327,0x8AAA,
0x329D,0x8A6E,0x3212,0x8A33,0x3187,0x89F8,0x30FC,0x89BE,0x3070,0x8985,0x2FE5,
0x894C,0x2F59,0x8914,0x2ECC,0x88DD,0x2E40,0x88A6,0x2DB3,0x8870,0x2D26,0x883A,
0x2C99,0x8805,0x2C0C,0x87D1,0x2B7E,0x879D,0x2AF0,0x876B,0x2A62,0x8738,0x29D3,
0x8707,0x2945,0x86D6,0x28B6,0x86A5,0x2827,0x8676,0x2797,0x8647,0x2708,0x8619,
0x2678,0x85EB,0x25E8,0x85BE,0x2558,0x8592,0x24C8,0x8566,0x2437,0x853B,0x23A7,
0x8511,0x2316,0x84E7,0x2284,0x84BE,0x21F3,0x8496,0x2162,0x846E,0x20D0,0x8447,
0x203E,0x8421,0x1FAC,0x83FB,0x1F1A,0x83D6,0x1E88,0x83B2,0x1DF5,0x838E,0x1D62,
0x836B,0x1CD0,0x8349,0x1C3D,0x8327,0x1BA9,0x8306,0x1B16,0x82E6,0x1A83,0x82C6,
0x19EF,0x82A8,0x195B,0x8289,0x18C7,0x826C,0x1833,0x824F,0x179F,0x8233,0x170B,
0x8217,0x1677,0x81FD,0x15E2,0x81E2,0x154D,0x81C9,0x14B9,0x81B0,0x1424,0x8198,
0x138F,0x8181,0x12FA,0x816A,0x1265,0x8154,0x11CF,0x813F,0x113A,0x812A,0x10A4,
0x8116,0x100F,0x8103,0x0F79,0x80F0,0x0EE4,0x80DE,0x0E4E,0x80CD,0x0DB8,0x80BD,
0x0D22,0x80AD,0x0C8C,0x809E,0x0BF6,0x808F,0x0B60,0x8082,0x0AC9,0x8075,0x0A33,
0x8068,0x099D,0x805D,0x0906,0x8052,0x0870,0x8047,0x07D9,0x803E,0x0743,0x8035,
0x06AC,0x802D,0x0616,0x8025,0x057F,0x801E,0x04E8,0x8018,0x0452,0x8013,0x03BB,
0x800E,0x0324,0x800A,0x028D,0x8007,0x01F7,0x8004,0x0160,0x8002,0x00C9,0x8001,
0x0032,0x8000,0xFF9B,0x8000,0xFF05,0x8001,0xFE6E,0x8002,0xFDD7,0x8005,0xFD40,
0x8008,0xFCAA,0x800B,0xFC13,0x800F,0xFB7C,0x8014,0xFAE5,0x801A,0xFA4F,0x8020,
0xF9B8,0x8027,0xF922,0x802F,0xF88B,0x8038,0xF7F4,0x8041,0xF75E,0x804B,0xF6C8,
0x8055,0xF631,0x8060,0xF59B,0x806C,0xF505,0x8079,0xF46E,0x8086,0xF3D8,0x8094,
0xF342,0x80A3,0xF2AC,0x80B2,0xF216,0x80C2,0xF180,0x80D3,0xF0EB,0x80E4,0xF055,
0x80F6,0xEFBF,0x8109,0xEF2A,0x811D,0xEE94,0x8131,0xEDFF,0x8146,0xED6A,0x815B,
0xECD5,0x8172,0xEC3F,0x8188,0xEBAB,0x81A0,0xEB16,0x81B8,0xEA81,0x81D1,0xE9EC,
0x81EB,0xE958,0x8205,0xE8C4,0x8220,0xE82F,0x823C,0xE79B,0x8259,0xE707,0x8276,
0xE673,0x8293,0xE5E0,0x82B2,0xE54C,0x82D1,0xE4B9,0x82F1,0xE426,0x8311,0xE392,
0x8332,0xE2FF,0x8354,0xE26D,0x8377,0xE1DA,0x839A,0xE148,0x83BE,0xE0B5,0x83E2,
0xE023,0x8407,0xDF91,0x842D,0xDEFF,0x8454,0xDE6E,0x847B,0xDDDC,0x84A3,0xDD4B,
0x84CC,0xDCBA,0x84F5,0xDC29,0x851F,0xDB99,0x8549,0xDB08,0x8574,0xDA78,0x85A0,
0xD9E8,0x85CD,0xD958,0x85FA,0xD8C8,0x8628,0xD839,0x8656,0xD7AA,0x8686,0xD71B,
0x86B6,0xD68C,0x86E6,0xD5FD,0x8717,0xD56F,0x8749,0xD4E1,0x877B,0xD453,0x87AF,
0xD3C5,0x87E2,0xD338,0x8817,0xD2AB,0x884C,0xD21E,0x8882,0xD191,0x88B8,0xD105,
0x88EF,0xD079,0x8927,0xCFED,0x895F,0xCF61,0x8998,0xCED6,0x89D2,0xCE4B,0x8A0C,
0xCDC0,0x8A47,0xCD35,0x8A82,0xCCAB,0x8ABE,0xCC21,0x8AFB,0xCB97,0x8B39,0xCB0E,
0x8B77,0xCA85,0x8BB5,0xC9FC,0x8BF5,0xC973,0x8C35,0xC8EB,0x8C75,0xC863,0x8CB6,
0xC7DB,0x8CF8,0xC754,0x8D3B,0xC6CD,0x8D7E,0xC646,0x8DC1,0xC5C0,0x8E06,0xC53A,
0x8E4B,0xC4B4,0x8E90,0xC42E,0x8ED6,0xC3A9,0x8F1D,0xC324,0x8F65,0xC2A0,0x8FAD,
0xC21C,0x8FF5,0xC198,0x903E,0xC114,0x9088,0xC091,0x90D3,0xC00F,0x911E,0xBF8C,
0x9169,0xBF0A,0x91B6,0xBE88,0x9202,0xBE07,0x9250,0xBD86,0x929E,0xBD05,0x92EC,
0xBC85,0x933C,0xBC05,0x938B,0xBB85,0x93DC,0xBB06,0x942D,0xBA87,0x947E,0xBA09,
0x94D0,0xB98B,0x9523,0xB90D,0x9577,0xB890,0x95CA,0xB813,0x961F,0xB796,0x9674,
0xB71A,0x96C9,0xB69E,0x9720,0xB623,0x9776,0xB5A8,0x97CE,0xB52D,0x9826,0xB4B3,
0x987E,0xB439,0x98D7,0xB3C0,0x9930,0xB347,0x998B,0xB2CF,0x99E5,0xB257,0x9A40,
0xB1DF,0x9A9C,0xB168,0x9AF9,0xB0F1,0x9B55,0xB07B,0x9BB3,0xB005,0x9C11,0xAF8F,
0x9C6F,0xAF1A,0x9CCE,0xAEA5,0x9D2E,0xAE31,0x9D8E,0xADBD,0x9DEF,0xAD4A,0x9E50,
0xACD7,0x9EB2,0xAC65,0x9F14,0xABF3,0x9F77,0xAB81,0x9FDA,0xAB10,0xA03E,0xAAA0,
0xA0A2,0xAA30,0xA107,0xA9C0,0xA16C,0xA951,0xA1D2,0xA8E2,0xA238,0xA874,0xA29F,
0xA806,0xA307,0xA799,0xA36F,0xA72C,0xA3D7,0xA6C0,0xA440,0xA654,0xA4A9,0xA5E8,
0xA513,0xA57E,0xA57E,0xA513,0xA5E8,0xA4A9,0xA654,0xA440,0xA6C0,0xA3D7,0xA72C,
0xA36F,0xA799,0xA307,0xA806,0xA29F,0xA874,0xA238,0xA8E2,0xA1D2,0xA951,0xA16C,
0xA9C0,0xA107,0xAA30,0xA0A2,0xAAA0,0xA03E,0xAB10,0x9FDA,0xAB81,0x9F77,0xABF3,
0x9F14,0xAC65,0x9EB2,0xACD7,0x9E50,0xAD4A,0x9DEF,0xADBD,0x9D8E,0xAE31,0x9D2E,
0xAEA5,0x9CCE,0xAF1A,0x9C6F,0xAF8F,0x9C11,0xB005,0x9BB3,0xB07B,0x9B55,0xB0F1,
0x9AF9,0xB168,0x9A9C,0xB1DF,0x9A40,0xB257,0x99E5,0xB2CF,0x998B,0xB347,0x9930,
0xB3C0,0x98D7,0xB439,0x987E,0xB4B3,0x9826,0xB52D,0x97CE,0xB5A8,0x9776,0xB623,
0x9720,0xB69E,0x96C9,0xB71A,0x9674,0xB796,0x961F,0xB813,0x95CA,0xB890,0x9577,
0xB90D,0x9523,0xB98B,0x94D0,0xBA09,0x947E,0xBA87,0x942D,0xBB06,0x93DC,0xBB85,
0x938B,0xBC05,0x933C,0xBC85,0x92EC,0xBD05,0x929E,0xBD86,0x9250,0xBE07,0x9202,
0xBE88,0x91B6,0xBF0A,0x9169,0xBF8C,0x911E,0xC00F,0x90D3,0xC091,0x9088,0xC114,
0x903E,0xC198,0x8FF5,0xC21C,0x8FAD,0xC2A0,0x8F65,0xC324,0x8F1D,0xC3A9,0x8ED6,
0xC42E,0x8E90,0xC4B4,0x8E4B,0xC53A,0x8E06,0xC5C0,0x8DC1,0xC646,0x8D7E,0xC6CD,
0x8D3B,0xC754,0x8CF8,0xC7DB,0x8CB6,0xC863,0x8C75,0xC8EB,0x8C35,0xC973,0x8BF5,
0xC9FC,0x8BB5,0xCA85,0x8B77,0xCB0E,0x8B39,0xCB97,0x8AFB,0xCC21,0x8ABE,0xCCAB,
0x8A82,0xCD35,0x8A47,0xCDC0,0x8A0C,0xCE4B,0x89D2,0xCED6,0x8998,0xCF61,0x895F,
0xCFED,0x8927,0xD079,0x88EF,0xD105,0x88B8,0xD191,0x8882,0xD21E,0x884C,0xD2AB,
0x8817,0xD338,0x87E2,0xD3C5,0x87AF,0xD453,0x877B,0xD4E1,0x8749,0xD56F,0x8717,
0xD5FD,0x86E6,0xD68C,0x86B6,0xD71B,0x8686,0xD7AA,0x8656,0xD839,0x8628,0xD8C8,
0x85FA,0xD958,0x85CD,0xD9E8,0x85A0,0xDA78,0x8574,0xDB08,0x8549,0xDB99,0x851F,
0xDC29,0x84F5,0xDCBA,0x84CC,0xDD4B,0x84A3,0xDDDC,0x847B,0xDE6E,0x8454,0xDEFF,
0x842D,0xDF91,0x8407,0xE023,0x83E2,0xE0B5,0x83BE,0xE148,0x839A,0xE1DA,0x8377,
0xE26D,0x8354,0xE2FF,0x8332,0xE392,0x8311,0xE426,0x82F1,0xE4B9,0x82D1,0xE54C,
0x82B2,0xE5E0,0x8293,0xE673,0x8276,0xE707,0x8259,0xE79B,0x823C,0xE82F,0x8220,
0xE8C4,0x8205,0xE958,0x81EB,0xE9EC,0x81D1,0xEA81,0x81B8,0xEB16,0x81A0,0xEBAB,
0x8188,0xEC3F,0x8172,0xECD5,0x815B,0xED6A,0x8146,0xEDFF,0x8131,0xEE94,0x811D,
0xEF2A,0x8109,0xEFBF,0x80F6,0xF055,0x80E4,0xF0EB,0x80D3,0xF180,0x80C2,0xF216,
0x80B2,0xF2AC,0x80A3,0xF342,0x8094,0xF3D8,0x8086,0xF46E,0x8079,0xF505,0x806C,
0xF59B,0x8060,0xF631,0x8055,0xF6C8,0x804B,0xF75E,0x8041,0xF7F4,0x8038,0xF88B,
0x802F,0xF922,0x8027,0xF9B8,0x8020,0xFA4F,0x801A,0xFAE5,0x8014,0xFB7C,0x800F,
0xFC13,0x800B,0xFCAA,0x8008,0xFD40,0x8005,0xFDD7,0x8002,0xFE6E,0x8001,0xFF05,
0x8000,0xFF9B,0x8000,0x0032,0x8001,0x00C9,0x8002,0x0160,0x8004,0x01F7,0x8007,
0x028D,0x800A,0x0324,0x800E,0x03BB,0x8013,0x0452,0x8018,0x04E8,0x801E,0x057F,
0x8025,0x0616,0x802D,0x06AC,0x8035,0x0743,0x803E,0x07D9,0x8047,0x0870,0x8052,
0x0906,0x805D,0x099D,0x8068,0x0A33,0x8075,0x0AC9,0x8082,0x0B60,0x808F,0x0BF6,
0x809E,0x0C8C,0x80AD,0x0D22,0x80BD,0x0DB8,0x80CD,0x0E4E,0x80DE,0x0EE4,0x80F0,
0x0F79,0x8103,0x100F,0x8116,0x10A4,0x812A,0x113A,0x813F,0x11CF,0x8154,0x1265,
0x816A,0x12FA,0x8181,0x138F,0x8198,0x1424,0x81B0,0x14B9,0x81C9,0x154D,0x81E2,
0x15E2,0x81FD,0x1677,0x8217,0x170B,0x8233,0x179F,0x824F,0x1833,0x826C,0x18C7,
0x8289,0x195B,0x82A8,0x19EF,0x82C6,0x1A83,0x82E6,0x1B16,0x8306,0x1BA9,0x8327,
0x1C3D,0x8349,0x1CD0,0x836B,0x1D62,0x838E,0x1DF5,0x83B2,0x1E88,0x83D6,0x1F1A,
0x83FB,0x1FAC,0x8421,0x203E,0x8447,0x20D0,0x846E,0x2162,0x8496,0x21F3,0x84BE,
0x2284,0x84E7,0x2316,0x8511,0x23A7,0x853B,0x2437,0x8566,0x24C8,0x8592,0x2558,
0x85BE,0x25E8,0x85EB,0x2678,0x8619,0x2708,0x8647,0x2797,0x8676,0x2827,0x86A5,
0x28B6,0x86D6,0x2945,0x8707,0x29D3,0x8738,0x2A62,0x876B,0x2AF0,0x879D,0x2B7E,
0x87D1,0x2C0C,0x8805,0x2C99,0x883A,0x2D26,0x8870,0x2DB3,0x88A6,0x2E40,0x88DD,
0x2ECC,0x8914,0x2F59,0x894C,0x2FE5,0x8985,0x3070,0x89BE,0x30FC,0x89F8,0x3187,
0x8A33,0x3212,0x8A6E,0x329D,0x8AAA,0x3327,0x8AE7,0x33B1,0x8B24,0x343B,0x8B62,
0x34C4,0x8BA0,0x354E,0x8BDF,0x35D7,0x8C1F,0x365F,0x8C60,0x36E8,0x8CA1,0x3770,
0x8CE2,0x37F7,0x8D24,0x387F,0x8D67,0x3906,0x8DAB,0x398D,0x8DEF,0x3A13,0x8E34,
0x3A9A,0x8E79,0x3B20,0x8EBF,0x3BA5,0x8F06,0x3C2A,0x8F4D,0x3CAF,0x8F95,0x3D34,
0x8FDD,0x3DB8,0x9026,0x3E3C,0x9070,0x3EC0,0x90BA,0x3F43,0x9105,0x3FC6,0x9150,
0x4048,0x919C,0x40CB,0x91E9,0x414D,0x9236,0x41CE,0x9284,0x424F,0x92D2,0x42D0,
0x9321,0x4351,0x9371,0x43D1,0x93C1,0x4450,0x9412,0x44D0,0x9463,0x454F,0x94B5,
0x45CD,0x9508,0x464B,0x955B,0x46C9,0x95AE,0x4747,0x9603,0x47C4,0x9657,0x4840,
0x96AD,0x48BD,0x9703,0x4939,0x9759,0x49B4,0x97B0,0x4A2F,0x9808,0x4AAA,0x9860,
0x4B24,0x98B9,0x4B9E,0x9913,0x4C17,0x996D,0x4C91,0x99C7,0x4D09,0x9A22,0x4D81,
0x9A7E,0x4DF9,0x9ADA,0x4E71,0x9B36,0x4EE8,0x9B94,0x4F5E,0x9BF1,0x4FD4,0x9C50,
0x504A,0x9CAF,0x50BF,0x9D0E,0x5134,0x9D6E,0x51A8,0x9DCE,0x521C,0x9E2F,0x5290,
0x9E91,0x5303,0x9EF3,0x5375,0x9F56,0x53E7,0x9FB9,0x5459,0xA01C,0x54CA,0xA080,
0x553B,0xA0E5,0x55AB,0xA14A,0x561B,0xA1B0,0x568A,0xA216,0x56F9,0xA27D,0x5767,
0xA2E4,0x57D5,0xA34C,0x5843,0xA3B4,0x58B0,0xA41D,0x591C,0xA486,0x5988,0xA4F0,
0x59F4,0xA55A,0x5A5F,0xA5C5,0x5AC9,0xA630,0x5B34,0xA69C,0x5B9D,0xA708,0x5C06,
0xA774,0x5C6F,0xA7E2,0x5CD7,0xA84F,0x5D3E,0xA8BD,0x5DA5,0xA92C,0x5E0C,0xA99B,
0x5E72,0xAA0A,0x5ED7,0xAA7A,0x5F3C,0xAAEB,0x5FA1,0xAB5C,0x6005,0xABCD,0x6068,
0xAC3F,0x60CB,0xACB1,0x612E,0xAD24,0x6190,0xAD97,0x61F1,0xAE0B,0x6252,0xAE7F,
0x62B2,0xAEF3,0x6312,0xAF68,0x6371,0xAFDD,0x63D0,0xB053,0x642E,0xB0C9,0x648B,
0xB140,0x64E9,0xB1B7,0x6545,0xB22F,0x65A1,0xB2A7,0x65FC,0xB31F,0x6657,0xB398,
0x66B2,0xB411,0x670B,0xB48B,0x6764,0xB505,0x67BD,0xB57F,0x6815,0xB5FA,0x686D,
0xB675,0x68C4,0xB6F1,0x691A,0xB76D,0x6970,0xB7E9,0x69C5,0xB866,0x6A1A,0xB8E3,
0x6A6E,0xB961,0x6AC1,0xB9DF,0x6B14,0xBA5D,0x6B66,0xBADC,0x6BB8,0xBB5B,0x6C09,
0xBBDA,0x6C5A,0xBC5A,0x6CAA,0xBCDA,0x6CF9,0xBD5B,0x6D48,0xBDDC,0x6D96,0xBE5D,
0x6DE4,0xBEDF,0x6E31,0xBF61,0x6E7D,0xBFE3,0x6EC9,0xC066,0x6F14,0xC0E9,0x6F5F,
0xC16C,0x6FA9,0xC1F0,0x6FF2,0xC274,0x703B,0xC2F8,0x7083,0xC37D,0x70CB,0xC402,
0x7112,0xC487,0x7158,0xC50D,0x719E,0xC593,0x71E3,0xC619,0x7228,0xC6A0,0x726C,
0xC727,0x72AF,0xC7AE,0x72F2,0xC836,0x7334,0xC8BE,0x7375,0xC946,0x73B6,0xC9CE,
0x73F6,0xCA57,0x7436,0xCAE0,0x7475,0xCB69,0x74B3,0xCBF3,0x74F0,0xCC7D,0x752D,
0xCD07,0x756A,0xCD92,0x75A6,0xCE1C,0x75E1,0xCEA7,0x761B,0xCF33,0x7655,0xCFBE,
0x768E,0xD04A,0x76C7,0xD0D6,0x76FE,0xD162,0x7736,0xD1EF,0x776C,0xD27C,0x77A2,
0xD309,0x77D8,0xD396,0x780C,0xD424,0x7840,0xD4B1,0x7874,0xD53F,0x78A6,0xD5CE,
0x78D8,0xD65C,0x790A,0xD6EB,0x793A,0xD77A,0x796A,0xD809,0x799A,0xD898,0x79C9,
0xD928,0x79F7,0xD9B8,0x7A24,0xDA48,0x7A51,0xDAD8,0x7A7D,0xDB68,0x7AA8,0xDBF9,
0x7AD3,0xDC8A,0x7AFD,0xDD1B,0x7B27,0xDDAC,0x7B50,0xDE3D,0x7B78,0xDECF,0x7B9F,
0xDF61,0x7BC6,0xDFF2,0x7BEC,0xE085,0x7C11,0xE117,0x7C36,0xE1A9,0x7C5A,0xE23C,
0x7C7E,0xE2CF,0x7CA0,0xE361,0x7CC2,0xE3F4,0x7CE4,0xE488,0x7D05,0xE51B,0x7D25,
0xE5AF,0x7D44,0xE642,0x7D63,0xE6D6,0x7D81,0xE76A,0x7D9E,0xE7FE,0x7DBA,0xE892,
0x7DD6,0xE926,0x7DF2,0xE9BB,0x7E0C,0xEA4F,0x7E26,0xEAE4,0x7E3F,0xEB79,0x7E58,
0xEC0E,0x7E70,0xECA3,0x7E87,0xED38,0x7E9D,0xEDCD,0x7EB3,0xEE62,0x7EC8,0xEEF8,
0x7EDD,0xEF8D,0x7EF0,0xF023,0x7F03,0xF0B9,0x7F16,0xF14E,0x7F27,0xF1E4,0x7F38,
0xF27A,0x7F49,0xF310,0x7F58,0xF3A6,0x7F67,0xF43C,0x7F75,0xF4D3,0x7F83,0xF569,
0x7F90,0xF5FF,0x7F9C,0xF695,0x7FA7,0xF72C,0x7FB2,0xF7C2,0x7FBC,0xF859,0x7FC5,
0xF8EF,0x7FCE,0xF986,0x7FD6,0xFA1D,0x7FDD,0xFAB3,0x7FE4,0xFB4A,0x7FEA,0xFBE1,
0x7FEF,0xFC77,0x7FF4,0xFD0E,0x7FF7,0xFDA5,0x7FFA,0xFE3C,0x7FFD,0xFED2,0x7FFF,
0xFF69,0x7FFF,0x7FFF,0x0000,0x7FFA,0xFDA5,0x7FEA,0xFB4A,0x7FCE,0xF8EF,0x7FA7,
0xF695,0x7F75,0xF43C,0x7F38,0xF1E4,0x7EF0,0xEF8D,0x7E9D,0xED38,0x7E3F,0xEAE4,
0x7DD6,0xE892,0x7D63,0xE642,0x7CE4,0xE3F4,0x7C5A,0xE1A9,0x7BC6,0xDF61,0x7B27,
0xDD1B,0x7A7D,0xDAD8,0x79C9,0xD898,0x790A,0xD65C,0x7840,0xD424,0x776C,0xD1EF,
0x768E,0xCFBE,0x75A6,0xCD92,0x74B3,0xCB69,0x73B6,0xC946,0x72AF,0xC727,0x719E,
0xC50D,0x7083,0xC2F8,0x6F5F,0xC0E9,0x6E31,0xBEDF,0x6CF9,0xBCDA,0x6BB8,0xBADC,
0x6A6E,0xB8E3,0x691A,0xB6F1,0x67BD,0xB505,0x6657,0xB31F,0x64E9,0xB140,0x6371,
0xAF68,0x61F1,0xAD97,0x6068,0xABCD,0x5ED7,0xAA0A,0x5D3E,0xA84F,0x5B9D,0xA69C,
0x59F4,0xA4F0,0x5843,0xA34C,0x568A,0xA1B0,0x54CA,0xA01C,0x5303,0x9E91,0x5134,
0x9D0E,0x4F5E,0x9B94,0x4D81,0x9A22,0x4B9E,0x98B9,0x49B4,0x9759,0x47C4,0x9603,
0x45CD,0x94B5,0x43D1,0x9371,0x41CE,0x9236,0x3FC6,0x9105,0x3DB8,0x8FDD,0x3BA5,
0x8EBF,0x398D,0x8DAB,0x3770,0x8CA1,0x354E,0x8BA0,0x3327,0x8AAA,0x30FC,0x89BE,
0x2ECC,0x88DD,0x2C99,0x8805,0x2A62,0x8738,0x2827,0x8676,0x25E8,0x85BE,0x23A7,
0x8511,0x2162,0x846E,0x1F1A,0x83D6,0x1CD0,0x8349,0x1A83,0x82C6,0x1833,0x824F,
0x15E2,0x81E2,0x138F,0x8181,0x113A,0x812A,0x0EE4,0x80DE,0x0C8C,0x809E,0x0A33,
0x8068,0x07D9,0x803E,0x057F,0x801E,0x0324,0x800A,0x00C9,0x8001,0xFE6E,0x8002,
0xFC13,0x800F,0xF9B8,0x8027,0xF75E,0x804B,0xF505,0x8079,0xF2AC,0x80B2,0xF055,
0x80F6,0xEDFF,0x8146,0xEBAB,0x81A0,0xE958,0x8205,0xE707,0x8276,0xE4B9,0x82F1,
0xE26D,0x8377,0xE023,0x8407,0xDDDC,0x84A3,0xDB99,0x8549,0xD958,0x85FA,0xD71B,
0x86B6,0xD4E1,0x877B,0xD2AB,0x884C,0xD079,0x8927,0xCE4B,0x8A0C,0xCC21,0x8AFB,
0xC9FC,0x8BF5,0xC7DB,0x8CF8,0xC5C0,0x8E06,0xC3A9,0x8F1D,0xC198,0x903E,0xBF8C,
0x9169,0xBD86,0x929E,0xBB85,0x93DC,0xB98B,0x9523,0xB796,0x9674,0xB5A8,0x97CE,
0xB3C0,0x9930,0xB1DF,0x9A9C,0xB005,0x9C11,0xAE31,0x9D8E,0xAC65,0x9F14,0xAAA0,
0xA0A2,0xA8E2,0xA238,0xA72C,0xA3D7,0xA57E,0xA57E,0xA3D7,0xA72C,0xA238,0xA8E2,
0xA0A2,0xAAA0,0x9F14,0xAC65,0x9D8E,0xAE31,0x9C11,0xB005,0x9A9C,0xB1DF,0x9930,
0xB3C0,0x97CE,0xB5A8,0x9674,0xB796,0x9523,0xB98B,0x93DC,0xBB85,0x929E,0xBD86,
0x9169,0xBF8C,0x903E,0xC198,0x8F1D,0xC3A9,0x8E06,0xC5C0,0x8CF8,0xC7DB,0x8BF5,
0xC9FC,0x8AFB,0xCC21,0x8A0C,0xCE4B,0x8927,0xD079,0x884C,0xD2AB,0x877B,0xD4E1,
0x86B6,0xD71B,0x85FA,0xD958,0x8549,0xDB99,0x84A3,0xDDDC,0x8407,0xE023,0x8377,
0xE26D,0x82F1,0xE4B9,0x8276,0xE707,0x8205,0xE958,0x81A0,0xEBAB,0x8146,0xEDFF,
0x80F6,0xF055,0x80B2,0xF2AC,0x8079,0xF505,0x804B,0xF75E,0x8027,0xF9B8,0x800F,
0xFC13,0x8002,0xFE6E,0x8001,0x00C9,0x800A,0x0324,0x801E,0x057F,0x803E,0x07D9,
0x8068,0x0A33,0x809E,0x0C8C,0x80DE,0x0EE4,0x812A,0x113A,0x8181,0x138F,0x81E2,
0x15E2,0x824F,0x1833,0x82C6,0x1A83,0x8349,0x1CD0,0x83D6,0x1F1A,0x846E,0x2162,
0x8511,0x23A7,0x85BE,0x25E8,0x8676,0x2827,0x8738,0x2A62,0x8805,0x2C99,0x88DD,
0x2ECC,0x89BE,0x30FC,0x8AAA,0x3327,0x8BA0,0x354E,0x8CA1,0x3770,0x8DAB,0x398D,
0x8EBF,0x3BA5,0x8FDD,0x3DB8,0x9105,0x3FC6,0x9236,0x41CE,0x9371,0x43D1,0x94B5,
0x45CD,0x9603,0x47C4,0x9759,0x49B4,0x98B9,0x4B9E,0x9A22,0x4D81,0x9B94,0x4F5E,
0x9D0E,0x5134,0x9E91,0x5303,0xA01C,0x54CA,0xA1B0,0x568A,0xA34C,0x5843,0xA4F0,
0x59F4,0xA69C,0x5B9D,0xA84F,0x5D3E,0xAA0A,0x5ED7,0xABCD,0x6068,0xAD97,0x61F1,
0xAF68,0x6371,0xB140,0x64E9,0xB31F,0x6657,0xB505,0x67BD,0xB6F1,0x691A,0xB8E3,
0x6A6E,0xBADC,0x6BB8,0xBCDA,0x6CF9,0xBEDF,0x6E31,0xC0E9,0x6F5F,0xC2F8,0x7083,
0xC50D,0x719E,0xC727,0x72AF,0xC946,0x73B6,0xCB69,0x74B3,0xCD92,0x75A6,0xCFBE,
0x768E,0xD1EF,0x776C,0xD424,0x7840,0xD65C,0x790A,0xD898,0x79C9,0xDAD8,0x7A7D,
0xDD1B,0x7B27,0xDF61,0x7BC6,0xE1A9,0x7C5A,0xE3F4,0x7CE4,0xE642,0x7D63,0xE892,
0x7DD6,0xEAE4,0x7E3F,0xED38,0x7E9D,0xEF8D,0x7EF0,0xF1E4,0x7F38,0xF43C,0x7F75,
0xF695,0x7FA7,0xF8EF,0x7FCE,0xFB4A,0x7FEA,0xFDA5,0x7FFA,0x7FFF,0x0000,0x7FA7,
0xF695,0x7E9D,0xED38,0x7CE4,0xE3F4,0x7A7D,0xDAD8,0x776C,0xD1EF,0x73B6,0xC946,
0x6F5F,0xC0E9,0x6A6E,0xB8E3,0x64E9,0xB140,0x5ED7,0xAA0A,0x5843,0xA34C,0x5134,
0x9D0E,0x49B4,0x9759,0x41CE,0x9236,0x398D,0x8DAB,0x30FC,0x89BE,0x2827,0x8676,
0x1F1A,0x83D6,0x15E2,0x81E2,0x0C8C,0x809E,0x0324,0x800A,0xF9B8,0x8027,0xF055,
0x80F6,0xE707,0x8276,0xDDDC,0x84A3,0xD4E1,0x877B,0xCC21,0x8AFB,0xC3A9,0x8F1D,
0xBB85,0x93DC,0xB3C0,0x9930,0xAC65,0x9F14,0xA57E,0xA57E,0x9F14,0xAC65,0x9930,
0xB3C0,0x93DC,0xBB85,0x8F1D,0xC3A9,0x8AFB,0xCC21,0x877B,0xD4E1,0x84A3,0xDDDC,
0x8276,0xE707,0x80F6,0xF055,0x8027,0xF9B8,0x800A,0x0324,0x809E,0x0C8C,0x81E2,
0x15E2,0x83D6,0x1F1A,0x8676,0x2827,0x89BE,0x30FC,0x8DAB,0x398D,0x9236,0x41CE,
0x9759,0x49B4,0x9D0E,0x5134,0xA34C,0x5843,0xAA0A,0x5ED7,0xB140,0x64E9,0xB8E3,
0x6A6E,0xC0E9,0x6F5F,0xC946,0x73B6,0xD1EF,0x776C,0xDAD8,0x7A7D,0xE3F4,0x7CE4,
0xED38,0x7E9D,0xF695,0x7FA7,0x7FFF,0x0000,0x7A7D,0xDAD8,0x6A6E,0xB8E3,0x5134,
0x9D0E,0x30FC,0x89BE,0x0C8C,0x809E,0xE707,0x8276,0xC3A9,0x8F1D,0xA57E,0xA57E,
0x8F1D,0xC3A9,0x8276,0xE707,0x809E,0x0C8C,0x89BE,0x30FC,0x9D0E,0x5134,0xB8E3,
0x6A6E,0xDAD8,0x7A7D,0x7FFF,0x0000,0x30FC,0x89BE,0xA57E,0xA57E,0x89BE,0x30FC,};

#endif



#endif /* !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES) */
#endif /* defined(ARM_MATH_MVEI)  */

#include "arm_math.h"

#if defined(ARM_MATH_MVEI)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES)



#endif /* !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES) */
#endif /* defined(ARM_MATH_MVEI)  */

