# Contributing to Ato UI

## Code of Conduct

Ato UI has adopted the [Contributor Covenant](https://www.contributor-covenant.org/) as its Code of Conduct, and we expect project participants to adhere to it.

Please read [the full text](/CODE_OF_CONDUCT.md) so that you can understand what actions will and will not be tolerated.

## How to contribute

PRs are always welcomed, but before making large contributions, please discuss the changes you want to make with us either on a specific Github issue or inside our Discord channel to make sure we are all on the same page.

You can contribute to this project in multiple different ways, even without making code contributions.

- **Support:** Join us on our Discord channel and answer questions there or help us with our [open issues](https://github.com/bennymi/ato-ui/issues).
- **Report:** Create issues with bug reports or create a feature request so we can further improve Ato UI.
- **Feedback:** Let us know how we can improve or what we are doing well.

## Resources for contributing to open source

If this is your first project to contribute to you can find many great resources online on how to get started to contributing to open source.

- https://github.com/firstcontributions/first-contributions

## Getting started

1. Install [pnpm](https://pnpm.io/installation). `npm i -g pnpm`
2. Fork the repo.
3. Clone the forked repo into your machine.
4. Open the project (using VSCode) and install the dependencies with `pnpm i`.
5. Create a new branch for you to make changes on.
6. Run the server `pnpm run dev` to see your changes.