import React, { FC, MouseEventHandler } from 'react';

type StarIconProps = {
    selected: boolean;
    onMouseEnter: MouseEventHandler<SVGElement>;
    onClick: MouseEventHandler<SVGElement>;
};

export const StarIcon: FC<StarIconProps> = (props) => {
    const { selected, onMouseEnter, onClick } = props;

    return (
        <svg
            onMouseEnter={onMouseEnter}
            onClick={onClick}
            className="SvgIcon"
            width="24"
            height="24"
            viewBox="0 0 25 24"
        >
            {selected ? (
                <path
                    d="M12.0125 17.328L6.60948 20.614C6.48314 20.6909 6.33687 20.7288 6.18906 20.7228C6.04126 20.7168 5.89852 20.6672 5.77881 20.5803C5.6591 20.4935 5.56776 20.3731 5.51628 20.2344C5.46479 20.0957 5.45547 19.9449 5.48948 19.801L6.94548 13.646L2.14948 9.52297C2.03737 9.4265 1.95629 9.29904 1.91643 9.15661C1.87656 9.01418 1.8797 8.86315 1.92544 8.7225C1.97119 8.58186 2.05749 8.45787 2.17351 8.36614C2.28953 8.27441 2.43008 8.21903 2.57748 8.20697L8.88048 7.68997L11.3205 1.85497C11.3775 1.71847 11.4737 1.6019 11.5968 1.51991C11.7199 1.43791 11.8645 1.39417 12.0125 1.39417C12.1604 1.39417 12.305 1.43791 12.4282 1.51991C12.5513 1.6019 12.6474 1.71847 12.7045 1.85497L15.1445 7.68997L21.4475 8.20697C21.5948 8.21921 21.7352 8.27471 21.8511 8.36651C21.967 8.45831 22.0531 8.5823 22.0988 8.72292C22.1444 8.86353 22.1474 9.0145 22.1075 9.15684C22.0676 9.29918 21.9866 9.42656 21.8745 9.52297L17.0795 13.646L18.5355 19.801C18.5695 19.9449 18.5602 20.0957 18.5087 20.2344C18.4572 20.3731 18.3659 20.4935 18.2462 20.5803C18.1264 20.6672 17.9837 20.7168 17.8359 20.7228C17.6881 20.7288 17.5418 20.6909 17.4155 20.614L12.0125 17.328Z"
                    fill="#fc0"
                />
            ) : (
                <path
                    d="M12.2644 17.328L6.86143 20.614C6.73509 20.6909 6.58882 20.7288 6.44101 20.7228C6.29321 20.7168 6.15047 20.6672 6.03076 20.5803C5.91105 20.4935 5.81971 20.3731 5.76823 20.2344C5.71675 20.0957 5.70743 19.9449 5.74143 19.801L7.19743 13.646L2.40143 9.52297C2.28933 9.4265 2.20824 9.29904 2.16838 9.15661C2.12852 9.01418 2.13165 8.86315 2.1774 8.7225C2.22314 8.58186 2.30945 8.45787 2.42546 8.36614C2.54148 8.27441 2.68203 8.21903 2.82943 8.20697L9.13243 7.68997L11.5724 1.85497C11.6295 1.71847 11.7256 1.6019 11.8487 1.51991C11.9719 1.43791 12.1165 1.39417 12.2644 1.39417C12.4124 1.39417 12.557 1.43791 12.6801 1.51991C12.8033 1.6019 12.8994 1.71847 12.9564 1.85497L15.3964 7.68997L21.6994 8.20697C21.8468 8.21921 21.9872 8.27471 22.1031 8.36651C22.2189 8.45831 22.3051 8.5823 22.3507 8.72292C22.3963 8.86353 22.3994 9.0145 22.3595 9.15684C22.3196 9.29918 22.2385 9.42656 22.1264 9.52297L17.3314 13.646L18.7874 19.801C18.8214 19.9449 18.8121 20.0957 18.7606 20.2344C18.7092 20.3731 18.6178 20.4935 18.4981 20.5803C18.3784 20.6672 18.2357 20.7168 18.0879 20.7228C17.9401 20.7288 17.7938 20.6909 17.6674 20.614L12.2644 17.328ZM12.7844 15.303L16.1534 17.353L15.2454 13.515C15.2031 13.3365 15.2107 13.1499 15.2673 12.9755C15.3239 12.801 15.4274 12.6455 15.5664 12.526L18.5564 9.95597L14.6264 9.63297C14.444 9.61791 14.2692 9.55307 14.1211 9.44551C13.973 9.33794 13.8572 9.19179 13.7864 9.02297L12.2644 5.38297L10.7434 9.02097C10.6727 9.19012 10.5569 9.33657 10.4086 9.44433C10.2602 9.55209 10.0852 9.617 9.90243 9.63197L5.97243 9.95497L8.96243 12.525C9.10148 12.6445 9.20497 12.8 9.26158 12.9745C9.3182 13.1489 9.32576 13.3355 9.28343 13.514L8.37543 17.351L11.7454 15.302C11.902 15.2068 12.0817 15.1564 12.2649 15.1564C12.4482 15.1564 12.6279 15.2068 12.7844 15.302V15.303Z"
                    fill="#000"
                />
            )}
        </svg>
    );
};
