import React, { FC } from 'react';

import { Icon } from './Icon';

export const StorybookIcon: FC<{ className?: string }> = ({ className }) => {
    return (
        <Icon className={className}>
            <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                <mask id="mask0" mask-type="alpha" maskUnits="userSpaceOnUse" x="1" y="0" width="14" height="16">
                    <path
                        d="M1.82972 14.7435L1.33407 1.53671C1.3177 1.10055 1.65214 0.7309 2.08776 0.703673L13.321 0.00159388C13.7644 -0.0261195 14.1464 0.310872 14.1741 0.754286C14.1751 0.770992 14.1757 0.787727 14.1757 0.804465V15.1956C14.1757 15.6398 13.8155 16 13.3712 16C13.3592 16 13.3471 15.9997 13.3351 15.9992L2.5975 15.5169C2.17931 15.4981 1.84542 15.1618 1.82972 14.7435Z"
                        fill="white"
                    />
                </mask>
                <g mask="url(#mask0)">
                    <path
                        d="M1.82972 14.7435L1.33407 1.53671C1.3177 1.10055 1.65214 0.7309 2.08776 0.703673L13.321 0.00159388C13.7644 -0.0261195 14.1464 0.310872 14.1741 0.754286C14.1751 0.770992 14.1757 0.787727 14.1757 0.804465V15.1956C14.1757 15.6398 13.8155 16 13.3712 16C13.3592 16 13.3471 15.9997 13.3351 15.9992L2.5975 15.5169C2.17931 15.4981 1.84542 15.1618 1.82972 14.7435Z"
                        fill="#FF4785"
                    />
                    <path
                        d="M10.8165 1.96666L10.8932 0.121209L12.4359 0L12.5024 1.90314C12.5047 1.96938 12.4529 2.02495 12.3866 2.02726C12.3583 2.02825 12.3305 2.01916 12.3082 2.0016L11.7133 1.53295L11.0089 2.06725C10.9561 2.1073 10.8809 2.09696 10.8408 2.04416C10.8239 2.02194 10.8154 1.99453 10.8165 1.96666Z"
                        fill="white"
                    />
                    <path
                        d="M8.84346 6.03063C8.84346 6.3436 10.9516 6.1936 11.2346 5.97376C11.2346 3.84249 10.091 2.72253 7.9969 2.72253C5.90279 2.72253 4.7295 3.85991 4.7295 5.56598C4.7295 8.53737 8.73949 8.59424 8.73949 10.215C8.73949 10.67 8.51672 10.9401 8.0266 10.9401C7.38798 10.9401 7.13549 10.6139 7.1652 9.50499C7.1652 9.26442 4.7295 9.18942 4.65524 9.50499C4.46614 12.1923 6.14042 12.9675 8.05631 12.9675C9.91279 12.9675 11.3683 11.9779 11.3683 10.1866C11.3683 7.00191 7.29886 7.08722 7.29886 5.50911C7.29886 4.86933 7.77412 4.78403 8.05631 4.78403C8.35334 4.78403 8.88801 4.83638 8.84346 6.03063Z"
                        fill="white"
                    />
                </g>
            </svg>
        </Icon>
    );
};
