import React, { FC } from 'react';

import { Icon } from './Icon';

export const FigmaIcon: FC<{ className?: string }> = ({ className }) => {
    return (
        <Icon className={className}>
            <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                <path
                    d="M5.33413 15.9999C6.80612 15.9999 8.00077 14.8053 8.00077 13.3333V10.6666H5.33413C3.86214 10.6666 2.66748 11.8613 2.66748 13.3333C2.66748 14.8053 3.86214 15.9999 5.33413 15.9999Z"
                    fill="#0ACF83"
                />
                <path
                    d="M2.66748 8.00002C2.66748 6.52803 3.86214 5.33337 5.33413 5.33337H8.00077V10.6667H5.33413C3.86214 10.6667 2.66748 9.47201 2.66748 8.00002Z"
                    fill="#A259FF"
                />
                <path
                    d="M2.66748 2.66667C2.66748 1.19467 3.86214 0 5.33413 0H8.00077V5.33333H5.33413C3.86214 5.33333 2.66748 4.13867 2.66748 2.66667Z"
                    fill="#F24E1E"
                />
                <path
                    d="M8.00098 0H10.6677C12.1397 0 13.3344 1.19467 13.3344 2.66667C13.3344 4.13867 12.1397 5.33333 10.6677 5.33333H8.00098V0Z"
                    fill="#FF7262"
                />
                <path
                    d="M13.3344 8.00002C13.3344 9.47201 12.1397 10.6667 10.6677 10.6667C9.19565 10.6667 8.00098 9.47201 8.00098 8.00002C8.00098 6.52803 9.19565 5.33337 10.6677 5.33337C12.1397 5.33337 13.3344 6.52803 13.3344 8.00002Z"
                    fill="#1ABCFE"
                />
            </svg>
        </Icon>
    );
};
