# VEML6030 library for STM32 HAL
Just essentials, nothing else! :)

```bash
$ arm-none-eabi-gcc -c -mcpu=cortex-m0plus -mthumb <other options stripped> veml6030.o
$ $ size veml6030.o
   text    data     bss     dec     hex filename
    808       0       0     808     328 veml6030.o
```
That's only `808b` :)

## Quickstart
Copy / add as submodule files under `Src` directory to your STM32 HAL project, then:
1. Include header:
```cpp
/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "veml6030.h"
// ...
/* USER CODE END Includes */
```
2. Get your measurements! :)
```cpp
  // Somewhere in your main():
  #define VEML6030_I2C_ADDRESS    0x10

  // Init / power on sensor
  veml6030 veml;
  veml6030_init(&veml, &hi2c1, VEML6030_I2C_ADDRESS);
  veml6030_power_on(&veml);

  uint16_t als = veml6030_read_als(&veml);
  uint16_t white = veml6030_read_white(&veml);

  // VEML6030 constantly measuring values, so turn it off to save power
  veml6030_shutdown(&veml);
```



## API

### Initialization / Power

 * `uint32_t veml6030_init(veml6030 *veml, I2C_HandleTypeDef *i2c, uint8_t addr);`
   Initialize struct veml, search for VEML6030 sensor on the I2C bus.
   Returns `VEML6030_OK` if initialized successfully, `HAL_ERROR` otherwise

 * `uint32_t veml6030_power_on(veml6030 *veml);`
   Turn sensor ON and start continuous measurements
   Returns `VEML6030_OK` or error.

 * `uint32_t veml6030_shutdown(veml6030 *veml);`
   Shutdowns sensor by put it into low power / sleep mode
   Returns `VEML6030_OK` or error.

### Configuration
 * `uint32_t veml6030_set_als_integration_time(veml6030 *veml, uint16_t it);`
   Sets ALS integration time (please refer to datasheet for details)
   - `it` - integration time, one of:
     * `REG_ALS_CONF_IT25`  - 25ms
     * `REG_ALS_CONF_IT50`  - 50ms
     * `REG_ALS_CONF_IT100`  - 100ms
     * `REG_ALS_CONF_IT200`  - 200ms
     * `REG_ALS_CONF_IT400`  - 400ms
     * `REG_ALS_CONF_IT800`  - 800ms

 * `uint16_t veml6030_get_als_integration_time(veml6030 *veml);`
   Returns current value of integration time. Refer to `veml6030_set_als_integration_time` for details.

 * `uint32_t veml6030_set_als_gain(veml6030 *veml, uint16_t gain);`
   Sets ALS gain. Please refer to datasheet for details.
   - `gain` - gain factor. Possible values:
     * `REG_ALS_CONF_GAIN_1` - x 1
     * `REG_ALS_CONF_GAIN_2` - x 2
     * `REG_ALS_CONF_GAIN_1_8` - x 1/8
     * `REG_ALS_CONF_GAIN_1_4` - x 1/4

### Sensor values
 * `uint16_t veml6030_read_als(veml6030 *veml);`
   Returns value of last ALS measurement

 * `uint16_t veml6030_read_white(veml6030 *veml);`
   Returns value of last WHITE measurement
