# SI7021 library for STM32 HAL
Just essentials, nothing else! :)

```bash
$ arm-none-eabi-gcc -c -mcpu=cortex-m0plus -mthumb <other options stripped> si7021.o
$ size si7021.o
   text    data     bss     dec     hex filename
    450       0       0     450     1c2 si7021.o
```
That's only `450b` :)

## Quickstart
Copy / add as submodule files under `Src` directory to your STM32 HAL project, then:
1. Include header:
```cpp
/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "si7021.h"
// ...
/* USER CODE END Includes */
```
2. Get your measurements! :)
```cpp
  // Somewhere in your main():

  // Start humidity measurement
  uint32_t humidity = si7021_measure_humidity(&hi2c1);
  if (humidity == SI7021_MEASURE_FAILED) {
    // Error happened :(
  }

  // As a side effect si7021 measures temperate together with humidity
  // so you can just read it without additional measurement
  int32_t tempC = si7021_read_previous_temperature(&hi2c1);
  if (humidity == SI7021_MEASURE_FAILED) {
    // Error happened :(
  }
```

## API

### Humidity measurement

 * `uint32_t si7021_measure_humidity(I2C_HandleTypeDef *hi2c)`
   Starts humidity measurement. This blocking call takes around 20ms to complete. As a side effect temperature will be measure as well.
   Returns current humidity, e.g. `55`
   In case of error returns `SI7021_MEASURE_FAILED`

### Temperature
 * `int32_t si7021_measure_temperature(I2C_HandleTypeDef *hi2c)`
   Starts temperature measurement. This blocking call takes ~20ms to complete.
   Returns current temperature in Celsius multiplied by 100 (to avoid float integers), e.g. `+23.12C` -> `2312`
   In case of error returns `SI7021_MEASURE_FAILED`

 * `int32_t si7021_read_previous_temperature(I2C_HandleTypeDef *hi2c)`
   Reads previous temperature measurement done by prior call of `si7021_measure_humidity()`
   Returns current temperature in Celsius multiplied by 100 (to avoid float integers) e.g. `+23.12C` -> `2312`
   In case of error returns `SI7021_MEASURE_FAILED`

### Configuration
 * `uint64_t si7021_read_id(I2C_HandleTypeDef *hi2c)`
   The `si7021` chip provides a serial number individualized for each device. This function reads this number.
   Returns chip id or `0` in case of error.

 * `uint32_t si7021_set_config(I2C_HandleTypeDef *hi2c, uint8_t heater, uint8_t resolution)`
   Turns on/off build-in heater / changes measurement resolution.
   - `heater` - build in heater mode. One of `SI7021_HEATER_ON` or `SI7021_HEATER_OFF`
   - `resolution` - measurement resolution. Possible values:
     * `SI7021_RESOLUTION_RH12_TEMP14` - `12bit` humidity, `14bit` temperature.
     * `SI7021_RESOLUTION_RH8_TEMP12`
     * `SI7021_RESOLUTION_RH10_TEMP13`
     * `SI7021_RESOLUTION_RH11_TEMP11`
   Returns 0 when new configuration successfully applied, otherwise - error.

 * `uint32_t si7021_set_heater_power(I2C_HandleTypeDef *hi2c, uint8_t power)`
   Sets build in heater power current. Possible values:
   - `SI7021_HEATER_POWER_3MA`
   - `SI7021_HEATER_POWER_9MA`
   - `SI7021_HEATER_POWER_15MA`
   - `SI7021_HEATER_POWER_27MA`
   - `SI7021_HEATER_POWER_51MA`
   - `SI7021_HEATER_POWER_94MA`
