# Challenge 809 - Colored Triangles

A colored triangle is created from different rows of colors (Red, Green or Blue). Successive rows, each containing one fewer color than the last, are generated by considering the two touching colors in the previous row. If these colors are identical, the same color is used in the new row. If colors are different, the missing color is used in the new row. This process continues until a single color is generated in the final row.

Different possibilities of colors are:
```
Colors Touching:        G G        B G        R G        B R
New color:               G          R          B          G
```
With a bigger example:
```
R R G B R G B B
 R B R G B R B
  G G B R G G
   G R G B G
    B B R R
     B G R
      R B
       G
```
**Goal**

Create a function which takes first row of the triangle as an input and returns the final color which would appear at the bottom row. In above example, given input `"RRGBRGBB"` will return `"G"`.

If you are only given one color as the input, return that color.

## Examples
```python
colored_triangle("B") ➞ "B"

colored_triangle("GB") ➞ "R"

colored_triangle("RBRGBRB") ➞ "G"
```
## Join Us & Share Your Solution

We're a community of coders who believe the best way to grow is to help others learn. *
*[Join us on Discord!!!](https://discord.gg/sfHykntuGy)**

## Challenge Tests

Here are a series of tests in JSON format that you can use to test your code. Each object in the JSON array has a
key `args` that are a list of parameters your function should take. The `return` key is what your function should return
given the `args`.

If you're writing your solution in Python you can also use the `beginner.codes` Python package to automate testing your
solution. Install it with `pip install beginner.codes`, then create a file for your solution and use the following code:

```python
from __future__ import annotations
from beginnercodes.challenges import test


def colored_triangle(row: str) -> str:
    return ""  # Put your code here!!!


test(809, colored_triangle)  # Tell it which challenge to test against
```

And here's the JSON.

```json
[
    {
        "args": [
            "RBRGBRBGGRRRBGBBBGG"
        ],
        "return": "G"
    },
    {
        "args": [
            "RBRGBRB"
        ],
        "return": "G"
    },
    {
        "args": [
            "RRR"
        ],
        "return": "R"
    },
    {
        "args": [
            "B"
        ],
        "return": "B"
    },
    {
        "args": [
            "GB"
        ],
        "return": "R"
    },
    {
        "args": [
            "RGBG"
        ],
        "return": "B"
    }
]
```

## Credits

Found on Edabit: [Coloured Triangles](https://edabit.com/challenge/W73q9yML66xXbFfGY)
