# Challenge 772 - Optimal Stock Trade

Given an array of numbers representing the stock prices of a company in chronological order, write a function that calculates the maximum profit you could have made from buying and selling that stock once. You must buy before you can sell it.

## Examples
```python
find_largest_profit([8, 13, 9]) ➞ 5
# 8 is the optimal price to buy at and 13 is the best price you can
# sell at afterward

find_largest_profit([12, 15, 20, 14, 8, 15]) ➞ 9
# 12 is the optimal price to buy because you can sell at 20, 8 is 
# not optimal because you can only sell at 15

find_largest_profit([12, 10, 4]) ➞ 0
# Price only drops so there is no optimal time to buy
```
## Join Us & Share Your Solution

We're a community of coders who believe the best way to grow is to help others learn. *
*[Join us on Discord!!!](https://discord.gg/sfHykntuGy)**

## Challenge Tests

Here are a series of tests in JSON format that you can use to test your code. Each object in the JSON array has a
key `args` that are a list of parameters your function should take. The `return` key is what your function should return
given the `args`.

If you're writing your solution in Python you can also use the `beginner.codes` Python package to automate testing your
solution. Install it with `pip install beginner.codes`, then create a file for your solution and use the following code:

```python
from __future__ import annotations
from beginnercodes.challenges import test


def find_largest_profit(stock_prices: list[int]) -> int:
    return 0  # Put your code here!!!


test(772, find_largest_profit)  # Tell it which challenge to test against
```

And here's the JSON.

```json
[
    {
        "args": [
            [
                20,
                15,
                20,
                9,
                7,
                3,
                17,
                2
            ]
        ],
        "return": 14
    },
    {
        "args": [
            [
                1,
                16,
                1,
                13,
                7,
                16,
                11,
                11
            ]
        ],
        "return": 15
    },
    {
        "args": [
            [
                8,
                13,
                9
            ]
        ],
        "return": 5
    },
    {
        "args": [
            [
                19,
                10,
                13,
                11,
                2,
                18,
                19
            ]
        ],
        "return": 17
    },
    {
        "args": [
            [
                12,
                10,
                4
            ]
        ],
        "return": 0
    }
]
```

## Credits

A coding problem from [dailycodingproblem.com](https://www.dailycodingproblem.com/)

Examples and tests generated by Zech ;)
