import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Chinese (`zh`).
class FluentLocalizationsZh extends FluentLocalizations {
  FluentLocalizationsZh([String locale = 'zh']) : super(locale);

  @override
  String get backButtonTooltip => '返回';

  @override
  String get closeButtonLabel => '关闭';

  @override
  String get searchLabel => '搜索';

  @override
  String get closeNavigationTooltip => '关闭导航';

  @override
  String get openNavigationTooltip => '打开导航';

  @override
  String get clickToSearch => '点击搜索';

  @override
  String get modalBarrierDismissLabel => '取消';

  @override
  String get minimizeWindowTooltip => '最小化';

  @override
  String get restoreWindowTooltip => '恢复';

  @override
  String get closeWindowTooltip => '关闭';

  @override
  String get dialogLabel => '对话';

  @override
  String get cutActionLabel => '剪切';

  @override
  String get copyActionLabel => '复制';

  @override
  String get pasteActionLabel => '粘贴';

  @override
  String get selectAllActionLabel => '全选';

  @override
  String get newTabLabel => '添加新标签';

  @override
  String get closeTabLabelSuffix => '关闭标签';

  @override
  String get scrollTabBackwardLabel => '向后滚动标签列表';

  @override
  String get scrollTabForwardLabel => '向前滚动标签列表';

  @override
  String get noResultsFoundLabel => '没有找到结果';

  @override
  String get copyActionTooltip => '将选中的内容复制到剪贴板';

  @override
  String get cutActionTooltip => '将选中的内容剪切到剪贴板';

  @override
  String get pasteActionTooltip => '在当前位置插入剪贴板的内容';

  @override
  String get selectAllActionTooltip => '选择所有内容';

  @override
  String get hour => '时';

  @override
  String get minute => '分';

  @override
  String get am => '上午';

  @override
  String get pm => '下午';

  @override
  String get month => '月';

  @override
  String get day => '日';

  @override
  String get year => '年';

  @override
  String get redLabel => '红色';

  @override
  String get greenLabel => '绿色';

  @override
  String get blueLabel => '蓝色';

  @override
  String get opacityLabel => '不透明度';

  @override
  String get hueLabel => '色调';

  @override
  String get saturationLabel => '饱和度';

  @override
  String get valueLabel => '值';

  @override
  String get moreText => '更多';

  @override
  String get lessText => '更少';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return '值 $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '$value% 不透明度';
  }

  @override
  String get colorBlack => '黑色';

  @override
  String get colorNavy => '深蓝';

  @override
  String get colorDarkBlue => '深蓝';

  @override
  String get colorMediumBlue => '蓝色';

  @override
  String get colorBlue => '蓝色';

  @override
  String get colorDarkGreen => '深绿色';

  @override
  String get colorGreen => '深绿色';

  @override
  String get colorTeal => '深青';

  @override
  String get colorDarkCyan => '深青';

  @override
  String get colorDeepSkyBlue => '青绿';

  @override
  String get colorDarkTurquoise => '浅绿';

  @override
  String get colorMediumSpringGreen => '绿色';

  @override
  String get colorLime => '绿色';

  @override
  String get colorSpringGreen => '绿色';

  @override
  String get colorCyan => '浅绿';

  @override
  String get colorMidnightBlue => '深蓝';

  @override
  String get colorDodgerBlue => '蓝色';

  @override
  String get colorLightSeaGreen => '青色';

  @override
  String get colorForestGreen => '深绿色';

  @override
  String get colorSeaGreen => '深绿色';

  @override
  String get colorDarkSlateGray => '深青';

  @override
  String get colorLimeGreen => '绿色';

  @override
  String get colorMediumSeaGreen => '绿色';

  @override
  String get colorTurquoise => '青色';

  @override
  String get colorRoyalBlue => '蓝色';

  @override
  String get colorSteelBlue => '蓝灰色';

  @override
  String get colorDarkSlateBlue => '紫色';

  @override
  String get colorMediumTurquoise => '青色';

  @override
  String get colorIndigo => '深紫色';

  @override
  String get colorDarkOliveGreen => '深绿色';

  @override
  String get colorCadetBlue => '青色';

  @override
  String get colorCornflowerBlue => '蓝色';

  @override
  String get colorMediumAquamarine => '绿色';

  @override
  String get colorDimGray => '灰色';

  @override
  String get colorSlateBlue => '靛蓝色';

  @override
  String get colorOliveDrab => '深绿色';

  @override
  String get colorSlateGray => '蓝灰色';

  @override
  String get colorLightSlateGray => '蓝灰色';

  @override
  String get colorMediumSlateBlue => '浅蓝色';

  @override
  String get colorLawnGreen => '绿色';

  @override
  String get colorChartreuse => '绿色';

  @override
  String get colorAquamarine => '浅绿';

  @override
  String get colorMaroon => '深红色';

  @override
  String get colorPurple => '深紫色';

  @override
  String get colorOlive => '深黄色';

  @override
  String get colorGray => '灰色';

  @override
  String get colorSkyBlue => '淡青绿色';

  @override
  String get colorLightSkyBlue => '浅蓝色';

  @override
  String get colorBlueViolet => '紫色';

  @override
  String get colorDarkRed => '深红色';

  @override
  String get colorDarkMagenta => '深紫色';

  @override
  String get colorSaddleBrown => '褐色';

  @override
  String get colorDarkSeaGreen => '绿色';

  @override
  String get colorLightGreen => '浅绿';

  @override
  String get colorMediumPurple => '淡紫色';

  @override
  String get colorDarkViolet => '紫色';

  @override
  String get colorPaleGreen => '浅绿';

  @override
  String get colorDarkOrchid => '紫色';

  @override
  String get colorYellowGreen => '绿色';

  @override
  String get colorSienna => '棕褐色';

  @override
  String get colorBrown => '红色';

  @override
  String get colorDarkGray => '灰色';

  @override
  String get colorLightBlue => '天蓝';

  @override
  String get colorGreenYellow => '绿色';

  @override
  String get colorPaleTurquoise => '浅绿';

  @override
  String get colorLightSteelBlue => '冰蓝';

  @override
  String get colorPowderBlue => '天蓝';

  @override
  String get colorFirebrick => '红色';

  @override
  String get colorDarkGoldenrod => '深黄色';

  @override
  String get colorMediumOrchid => '紫色';

  @override
  String get colorRosyBrown => '珊瑚色';

  @override
  String get colorDarkKhaki => '棕褐色';

  @override
  String get colorSilver => '浅灰';

  @override
  String get colorMediumVioletRed => '粉色';

  @override
  String get colorIndianRed => '红色';

  @override
  String get colorPeru => '棕褐色';

  @override
  String get colorChocolate => '橙色';

  @override
  String get colorTan => '棕褐色';

  @override
  String get colorLightGray => '浅灰';

  @override
  String get colorThistle => '淡紫色';

  @override
  String get colorOrchid => '淡紫色';

  @override
  String get colorGoldenrod => '金色';

  @override
  String get colorPaleVioletRed => '玫瑰红';

  @override
  String get colorCrimson => '红色';

  @override
  String get colorGainsboro => '浅灰';

  @override
  String get colorPlum => '粉色';

  @override
  String get colorBurlyWood => '棕褐色';

  @override
  String get colorLightCyan => '天蓝';

  @override
  String get colorLavender => '浅蓝色';

  @override
  String get colorDarkSalmon => '玫瑰红';

  @override
  String get colorViolet => '淡紫色';

  @override
  String get colorPaleGoldenrod => '浅黄色';

  @override
  String get colorLightCoral => '玫瑰红';

  @override
  String get colorKhaki => '浅黄色';

  @override
  String get colorAliceBlue => '白色';

  @override
  String get colorHoneydew => '白色';

  @override
  String get colorAzure => '白色';

  @override
  String get colorSandyBrown => '浅橙色';

  @override
  String get colorWheat => '浅黄色';

  @override
  String get colorBeige => '浅黄色';

  @override
  String get colorWhiteSmoke => '白色';

  @override
  String get colorMintCream => '白色';

  @override
  String get colorGhostWhite => '白色';

  @override
  String get colorSalmon => '玫瑰红';

  @override
  String get colorAntiqueWhite => '浅橙色';

  @override
  String get colorLinen => '浅橙色';

  @override
  String get colorLightGoldenrodYellow => '浅黄色';

  @override
  String get colorOldLace => '白色';

  @override
  String get colorRed => '红色';

  @override
  String get colorMagenta => '紫色';

  @override
  String get colorDeepPink => '粉色';

  @override
  String get colorOrangeRed => '红色';

  @override
  String get colorTomato => '红色';

  @override
  String get colorHotPink => '粉色';

  @override
  String get colorCoral => '红色';

  @override
  String get colorDarkOrange => '橙色';

  @override
  String get colorLightSalmon => '玫瑰红';

  @override
  String get colorOrange => '金色';

  @override
  String get colorLightPink => '玫瑰红';

  @override
  String get colorPink => '玫瑰红';

  @override
  String get colorGold => '金色';

  @override
  String get colorPeachPuff => '浅橙色';

  @override
  String get colorNavajoWhite => '浅橙色';

  @override
  String get colorMoccasin => '浅橙色';

  @override
  String get colorBisque => '浅橙色';

  @override
  String get colorMistyRose => '玫瑰红';

  @override
  String get colorBlanchedAlmond => '浅橙色';

  @override
  String get colorPapayaWhip => '浅橙色';

  @override
  String get colorLavenderBlush => '白色';

  @override
  String get colorSeaShell => '白色';

  @override
  String get colorCornsilk => '浅黄色';

  @override
  String get colorLemonChiffon => '浅黄色';

  @override
  String get colorFloralWhite => '白色';

  @override
  String get colorSnow => '白色';

  @override
  String get colorYellow => '黄色';

  @override
  String get colorLightYellow => '浅黄色';

  @override
  String get colorIvory => '白色';

  @override
  String get colorWhite => '白色';
}

/// The translations for Chinese, using the Han script (`zh_Hant`).
class FluentLocalizationsZhHant extends FluentLocalizationsZh {
  FluentLocalizationsZhHant() : super('zh_Hant');

  @override
  String get backButtonTooltip => '返回';

  @override
  String get closeButtonLabel => '關閉';

  @override
  String get searchLabel => '搜尋';

  @override
  String get closeNavigationTooltip => '關閉導覽列';

  @override
  String get openNavigationTooltip => '開啟導覽列';

  @override
  String get clickToSearch => '點擊搜尋';

  @override
  String get modalBarrierDismissLabel => '取消';

  @override
  String get minimizeWindowTooltip => '縮小';

  @override
  String get restoreWindowTooltip => '還原';

  @override
  String get closeWindowTooltip => '關閉';

  @override
  String get dialogLabel => '對話';

  @override
  String get cutActionLabel => '剪下';

  @override
  String get copyActionLabel => '複製';

  @override
  String get pasteActionLabel => '貼上';

  @override
  String get selectAllActionLabel => '全選';

  @override
  String get newTabLabel => '新增標籤';

  @override
  String get closeTabLabelSuffix => '關閉標籤';

  @override
  String get scrollTabBackwardLabel => '向後滾動標籤列表';

  @override
  String get scrollTabForwardLabel => '向前滾動標籤列表';

  @override
  String get noResultsFoundLabel => '找不到相關結果';

  @override
  String get copyActionTooltip => '將選中的內容複製至剪貼簿';

  @override
  String get cutActionTooltip => '將選中的內容剪下至剪貼簿';

  @override
  String get pasteActionTooltip => '在當前位置插入剪貼簿內容';

  @override
  String get selectAllActionTooltip => '選擇所有內容';

  @override
  String get hour => '時';

  @override
  String get minute => '分';

  @override
  String get am => '上午';

  @override
  String get pm => '下午';

  @override
  String get month => '月';

  @override
  String get day => '日';

  @override
  String get year => '年';

  @override
  String get redLabel => '紅色';

  @override
  String get greenLabel => '綠色';

  @override
  String get blueLabel => '藍色';

  @override
  String get opacityLabel => '不透明度';

  @override
  String get hueLabel => '色調';

  @override
  String get saturationLabel => '彩度';

  @override
  String get valueLabel => '値';

  @override
  String get moreText => '更多';

  @override
  String get lessText => '更少';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return '値 $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '$value% 不透明度';
  }

  @override
  String get colorBlack => '黑色';

  @override
  String get colorNavy => '深藍';

  @override
  String get colorDarkBlue => '深藍';

  @override
  String get colorMediumBlue => '藍色';

  @override
  String get colorBlue => '藍色';

  @override
  String get colorDarkGreen => '深綠色';

  @override
  String get colorGreen => '深綠色';

  @override
  String get colorTeal => '深藍綠';

  @override
  String get colorDarkCyan => '深藍綠';

  @override
  String get colorDeepSkyBlue => '淺粉藍';

  @override
  String get colorDarkTurquoise => '青色';

  @override
  String get colorMediumSpringGreen => '綠色';

  @override
  String get colorLime => '綠色';

  @override
  String get colorSpringGreen => '綠色';

  @override
  String get colorCyan => '青色';

  @override
  String get colorMidnightBlue => '深藍';

  @override
  String get colorDodgerBlue => '藍色';

  @override
  String get colorLightSeaGreen => '藍綠色';

  @override
  String get colorForestGreen => '深綠色';

  @override
  String get colorSeaGreen => '深綠色';

  @override
  String get colorDarkSlateGray => '深藍綠';

  @override
  String get colorLimeGreen => '綠色';

  @override
  String get colorMediumSeaGreen => '綠色';

  @override
  String get colorTurquoise => '藍綠色';

  @override
  String get colorRoyalBlue => '藍色';

  @override
  String get colorSteelBlue => '藍灰';

  @override
  String get colorDarkSlateBlue => '紫色';

  @override
  String get colorMediumTurquoise => '藍綠色';

  @override
  String get colorIndigo => '深紫';

  @override
  String get colorDarkOliveGreen => '深綠色';

  @override
  String get colorCadetBlue => '藍綠色';

  @override
  String get colorCornflowerBlue => '藍色';

  @override
  String get colorMediumAquamarine => '綠色';

  @override
  String get colorDimGray => '灰色';

  @override
  String get colorSlateBlue => '靛藍色';

  @override
  String get colorOliveDrab => '深綠色';

  @override
  String get colorSlateGray => '藍灰';

  @override
  String get colorLightSlateGray => '藍灰';

  @override
  String get colorMediumSlateBlue => '淺藍色';

  @override
  String get colorLawnGreen => '綠色';

  @override
  String get colorChartreuse => '綠色';

  @override
  String get colorAquamarine => '淺綠';

  @override
  String get colorMaroon => '深紅';

  @override
  String get colorPurple => '深紫';

  @override
  String get colorOlive => '深黃';

  @override
  String get colorGray => '灰色';

  @override
  String get colorSkyBlue => '淺綠藍';

  @override
  String get colorLightSkyBlue => '淺藍色';

  @override
  String get colorBlueViolet => '紫色';

  @override
  String get colorDarkRed => '深紅';

  @override
  String get colorDarkMagenta => '深紫';

  @override
  String get colorSaddleBrown => '褐色';

  @override
  String get colorDarkSeaGreen => '綠色';

  @override
  String get colorLightGreen => '淺綠';

  @override
  String get colorMediumPurple => '淡紫';

  @override
  String get colorDarkViolet => '紫色';

  @override
  String get colorPaleGreen => '淺綠';

  @override
  String get colorDarkOrchid => '紫色';

  @override
  String get colorYellowGreen => '綠色';

  @override
  String get colorSienna => '深黃褐';

  @override
  String get colorBrown => '紅色';

  @override
  String get colorDarkGray => '灰色';

  @override
  String get colorLightBlue => '天藍';

  @override
  String get colorGreenYellow => '綠色';

  @override
  String get colorPaleTurquoise => '青色';

  @override
  String get colorLightSteelBlue => '冰藍';

  @override
  String get colorPowderBlue => '天藍';

  @override
  String get colorFirebrick => '紅色';

  @override
  String get colorDarkGoldenrod => '深黃';

  @override
  String get colorMediumOrchid => '紫色';

  @override
  String get colorRosyBrown => '珊瑚紅';

  @override
  String get colorDarkKhaki => '深黃褐';

  @override
  String get colorSilver => '淺灰';

  @override
  String get colorMediumVioletRed => '粉紅色';

  @override
  String get colorIndianRed => '紅色';

  @override
  String get colorPeru => '深黃褐';

  @override
  String get colorChocolate => '橙色';

  @override
  String get colorTan => '深黃褐';

  @override
  String get colorLightGray => '淺灰';

  @override
  String get colorThistle => '淡紫';

  @override
  String get colorOrchid => '淡紫';

  @override
  String get colorGoldenrod => '金色';

  @override
  String get colorPaleVioletRed => '玫瑰色';

  @override
  String get colorCrimson => '紅色';

  @override
  String get colorGainsboro => '淺灰';

  @override
  String get colorPlum => '粉紅色';

  @override
  String get colorBurlyWood => '深黃褐';

  @override
  String get colorLightCyan => '天藍';

  @override
  String get colorLavender => '淺藍色';

  @override
  String get colorDarkSalmon => '玫瑰色';

  @override
  String get colorViolet => '淡紫';

  @override
  String get colorPaleGoldenrod => '淺黃';

  @override
  String get colorLightCoral => '玫瑰色';

  @override
  String get colorKhaki => '淺黃';

  @override
  String get colorAliceBlue => '白色';

  @override
  String get colorHoneydew => '白色';

  @override
  String get colorAzure => '白色';

  @override
  String get colorSandyBrown => '淺橙';

  @override
  String get colorWheat => '淺黃';

  @override
  String get colorBeige => '淺黃';

  @override
  String get colorWhiteSmoke => '白色';

  @override
  String get colorMintCream => '白色';

  @override
  String get colorGhostWhite => '白色';

  @override
  String get colorSalmon => '玫瑰色';

  @override
  String get colorAntiqueWhite => '淺橙';

  @override
  String get colorLinen => '淺橙';

  @override
  String get colorLightGoldenrodYellow => '淺黃';

  @override
  String get colorOldLace => '白色';

  @override
  String get colorRed => '紅色';

  @override
  String get colorMagenta => '紫色';

  @override
  String get colorDeepPink => '粉紅色';

  @override
  String get colorOrangeRed => '紅色';

  @override
  String get colorTomato => '紅色';

  @override
  String get colorHotPink => '粉紅色';

  @override
  String get colorCoral => '紅色';

  @override
  String get colorDarkOrange => '橙色';

  @override
  String get colorLightSalmon => '玫瑰色';

  @override
  String get colorOrange => '金色';

  @override
  String get colorLightPink => '玫瑰色';

  @override
  String get colorPink => '玫瑰色';

  @override
  String get colorGold => '金色';

  @override
  String get colorPeachPuff => '淺橙';

  @override
  String get colorNavajoWhite => '淺橙';

  @override
  String get colorMoccasin => '淺橙';

  @override
  String get colorBisque => '淺橙';

  @override
  String get colorMistyRose => '玫瑰色';

  @override
  String get colorBlanchedAlmond => '淺橙';

  @override
  String get colorPapayaWhip => '淺橙';

  @override
  String get colorLavenderBlush => '白色';

  @override
  String get colorSeaShell => '白色';

  @override
  String get colorCornsilk => '淺黃';

  @override
  String get colorLemonChiffon => '淺黃';

  @override
  String get colorFloralWhite => '白色';

  @override
  String get colorSnow => '白色';

  @override
  String get colorYellow => '黃色';

  @override
  String get colorLightYellow => '淺黃';

  @override
  String get colorIvory => '白色';

  @override
  String get colorWhite => '白色';
}
