import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Urdu (`ur`).
class FluentLocalizationsUr extends FluentLocalizations {
  FluentLocalizationsUr([String locale = 'ur']) : super(locale);

  @override
  String get backButtonTooltip => 'آگے';

  @override
  String get closeButtonLabel => 'بند';

  @override
  String get searchLabel => 'تلاش کریں';

  @override
  String get closeNavigationTooltip => 'نیویگیشن بند کریں۔';

  @override
  String get openNavigationTooltip => 'نیویگیشن کھولیں۔';

  @override
  String get clickToSearch => 'تلاش کرنے کے لیے کلک کریں۔';

  @override
  String get modalBarrierDismissLabel => 'برطرف کریں';

  @override
  String get minimizeWindowTooltip => 'کم سے کم کریں';

  @override
  String get restoreWindowTooltip => 'بحال کریں';

  @override
  String get closeWindowTooltip => 'بند کریں';

  @override
  String get dialogLabel => 'ڈائیلاگ';

  @override
  String get cutActionLabel => 'کاپی کریں';

  @override
  String get copyActionLabel => 'کاپی کریں';

  @override
  String get pasteActionLabel => 'پیسٹ کریں';

  @override
  String get selectAllActionLabel => 'سب کچھ منتخب کریں';

  @override
  String get newTabLabel => 'نیا ٹیب کھولیں۔';

  @override
  String get closeTabLabelSuffix => 'بند کریں';

  @override
  String get scrollTabBackwardLabel =>
      'ٹیب کی فہرست کو پیچھے کی طرف اسکرول کریں۔';

  @override
  String get scrollTabForwardLabel => 'ٹیب کی فہرست کو آگے اسکرول کریں۔';

  @override
  String get noResultsFoundLabel => 'کوئی نتائج نہیں ملے۔';

  @override
  String get copyActionTooltip => 'منتخب کردہ مواد کو کلپ بورڈ میں کاپی کریں۔';

  @override
  String get cutActionTooltip =>
      'منتخب کردہ مواد کو ہٹائیں اور اسے کلپ بورڈ میں رکھیں';

  @override
  String get pasteActionTooltip =>
      'کلپ بورڈ کے مواد کو موجودہ مقام پر داخل کریں۔';

  @override
  String get selectAllActionTooltip => 'تمام مواد کو منتخب کریں۔';

  @override
  String get hour => 'گھنٹہ';

  @override
  String get minute => 'منٹ';

  @override
  String get am => 'AM';

  @override
  String get pm => 'PM';

  @override
  String get month => 'مہینہ';

  @override
  String get day => 'دِن';

  @override
  String get year => 'سال';

  @override
  String get redLabel => 'سرخ';

  @override
  String get greenLabel => 'سبز';

  @override
  String get blueLabel => 'نیلا';

  @override
  String get opacityLabel => 'شفافیت';

  @override
  String get hueLabel => 'رنگ';

  @override
  String get saturationLabel => 'سیرابی';

  @override
  String get valueLabel => 'قدر';

  @override
  String get moreText => 'مزید';

  @override
  String get lessText => 'کم';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return '($colorName) $value قدر';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '%$value دھندلاپن';
  }

  @override
  String get colorBlack => 'سیاہ';

  @override
  String get colorNavy => 'گہرا نیلا';

  @override
  String get colorDarkBlue => 'گہرا نیلا';

  @override
  String get colorMediumBlue => 'نیلا';

  @override
  String get colorBlue => 'نیلا';

  @override
  String get colorDarkGreen => 'گہرا سبز';

  @override
  String get colorGreen => 'گہرا سبز';

  @override
  String get colorTeal => 'گہرا سبزی مائل';

  @override
  String get colorDarkCyan => 'گہرا سبزی مائل';

  @override
  String get colorDeepSkyBlue => 'فیروزی';

  @override
  String get colorDarkTurquoise => 'سمندری سبز رنگ';

  @override
  String get colorMediumSpringGreen => 'سبز';

  @override
  String get colorLime => 'سبز';

  @override
  String get colorSpringGreen => 'سبز';

  @override
  String get colorCyan => 'سمندری سبز رنگ';

  @override
  String get colorMidnightBlue => 'گہرا نیلا';

  @override
  String get colorDodgerBlue => 'نیلا';

  @override
  String get colorLightSeaGreen => 'سبزى مائل';

  @override
  String get colorForestGreen => 'گہرا سبز';

  @override
  String get colorSeaGreen => 'گہرا سبز';

  @override
  String get colorDarkSlateGray => 'گہرا سبزی مائل';

  @override
  String get colorLimeGreen => 'سبز';

  @override
  String get colorMediumSeaGreen => 'سبز';

  @override
  String get colorTurquoise => 'سبزى مائل';

  @override
  String get colorRoyalBlue => 'نیلا';

  @override
  String get colorSteelBlue => 'نیلا-مٹیالا';

  @override
  String get colorDarkSlateBlue => 'جامنی';

  @override
  String get colorMediumTurquoise => 'سبزى مائل';

  @override
  String get colorIndigo => 'گہرا جامن';

  @override
  String get colorDarkOliveGreen => 'گہرا سبز';

  @override
  String get colorCadetBlue => 'سبزى مائل';

  @override
  String get colorCornflowerBlue => 'نیلا';

  @override
  String get colorMediumAquamarine => 'سبز';

  @override
  String get colorDimGray => 'مٹيالا';

  @override
  String get colorSlateBlue => 'قدرتی نیلا';

  @override
  String get colorOliveDrab => 'گہرا سبز';

  @override
  String get colorSlateGray => 'نیلا-مٹیالا';

  @override
  String get colorLightSlateGray => 'نیلا-مٹیالا';

  @override
  String get colorMediumSlateBlue => 'ہلکا نیلا';

  @override
  String get colorLawnGreen => 'سبز';

  @override
  String get colorChartreuse => 'سبز';

  @override
  String get colorAquamarine => 'ہلکا سبز';

  @override
  String get colorMaroon => 'گہرا سرخ';

  @override
  String get colorPurple => 'گہرا جامن';

  @override
  String get colorOlive => 'گہرا پیلا';

  @override
  String get colorGray => 'مٹيالا';

  @override
  String get colorSkyBlue => 'ہلکا فیروزی';

  @override
  String get colorLightSkyBlue => 'ہلکا نیلا';

  @override
  String get colorBlueViolet => 'جامنی';

  @override
  String get colorDarkRed => 'گہرا سرخ';

  @override
  String get colorDarkMagenta => 'گہرا جامن';

  @override
  String get colorSaddleBrown => 'بھورا';

  @override
  String get colorDarkSeaGreen => 'سبز';

  @override
  String get colorLightGreen => 'ہلکا سبز';

  @override
  String get colorMediumPurple => 'ہلکا ارغوانی رنگ';

  @override
  String get colorDarkViolet => 'جامنی';

  @override
  String get colorPaleGreen => 'ہلکا سبز';

  @override
  String get colorDarkOrchid => 'جامنی';

  @override
  String get colorYellowGreen => 'سبز';

  @override
  String get colorSienna => 'کتھئی رنگت';

  @override
  String get colorBrown => 'سرخ';

  @override
  String get colorDarkGray => 'مٹيالا';

  @override
  String get colorLightBlue => 'آسمانی';

  @override
  String get colorGreenYellow => 'سبز';

  @override
  String get colorPaleTurquoise => 'سمندری سبز رنگ';

  @override
  String get colorLightSteelBlue => 'برفانی نیلا';

  @override
  String get colorPowderBlue => 'آسمانی';

  @override
  String get colorFirebrick => 'سرخ';

  @override
  String get colorDarkGoldenrod => 'گہرا پیلا';

  @override
  String get colorMediumOrchid => 'جامنی';

  @override
  String get colorRosyBrown => 'مرجانی';

  @override
  String get colorDarkKhaki => 'کتھئی رنگت';

  @override
  String get colorSilver => 'ہلکا مٹيالا';

  @override
  String get colorMediumVioletRed => 'گلابى';

  @override
  String get colorIndianRed => 'سرخ';

  @override
  String get colorPeru => 'کتھئی رنگت';

  @override
  String get colorChocolate => 'نارنجى';

  @override
  String get colorTan => 'کتھئی رنگت';

  @override
  String get colorLightGray => 'ہلکا مٹيالا';

  @override
  String get colorThistle => 'ہلکا ارغوانی رنگ';

  @override
  String get colorOrchid => 'ہلکا ارغوانی رنگ';

  @override
  String get colorGoldenrod => 'سونا';

  @override
  String get colorPaleVioletRed => 'گلاب';

  @override
  String get colorCrimson => 'سرخ';

  @override
  String get colorGainsboro => 'ہلکا مٹيالا';

  @override
  String get colorPlum => 'گلابى';

  @override
  String get colorBurlyWood => 'کتھئی رنگت';

  @override
  String get colorLightCyan => 'آسمانی';

  @override
  String get colorLavender => 'ہلکا نیلا';

  @override
  String get colorDarkSalmon => 'گلاب';

  @override
  String get colorViolet => 'ہلکا ارغوانی رنگ';

  @override
  String get colorPaleGoldenrod => 'ہلکا پیلا';

  @override
  String get colorLightCoral => 'گلاب';

  @override
  String get colorKhaki => 'ہلکا پیلا';

  @override
  String get colorAliceBlue => 'سفيد';

  @override
  String get colorHoneydew => 'سفيد';

  @override
  String get colorAzure => 'سفيد';

  @override
  String get colorSandyBrown => 'ہلکا نارنجی';

  @override
  String get colorWheat => 'ہلکا پیلا';

  @override
  String get colorBeige => 'ہلکا پیلا';

  @override
  String get colorWhiteSmoke => 'سفيد';

  @override
  String get colorMintCream => 'سفيد';

  @override
  String get colorGhostWhite => 'سفيد';

  @override
  String get colorSalmon => 'گلاب';

  @override
  String get colorAntiqueWhite => 'ہلکا نارنجی';

  @override
  String get colorLinen => 'ہلکا نارنجی';

  @override
  String get colorLightGoldenrodYellow => 'ہلکا پیلا';

  @override
  String get colorOldLace => 'سفيد';

  @override
  String get colorRed => 'سرخ';

  @override
  String get colorMagenta => 'جامنی';

  @override
  String get colorDeepPink => 'گلابى';

  @override
  String get colorOrangeRed => 'سرخ';

  @override
  String get colorTomato => 'سرخ';

  @override
  String get colorHotPink => 'گلابى';

  @override
  String get colorCoral => 'سرخ';

  @override
  String get colorDarkOrange => 'نارنجى';

  @override
  String get colorLightSalmon => 'گلاب';

  @override
  String get colorOrange => 'سونا';

  @override
  String get colorLightPink => 'گلاب';

  @override
  String get colorPink => 'گلاب';

  @override
  String get colorGold => 'سونا';

  @override
  String get colorPeachPuff => 'ہلکا نارنجی';

  @override
  String get colorNavajoWhite => 'ہلکا نارنجی';

  @override
  String get colorMoccasin => 'ہلکا نارنجی';

  @override
  String get colorBisque => 'ہلکا نارنجی';

  @override
  String get colorMistyRose => 'گلاب';

  @override
  String get colorBlanchedAlmond => 'ہلکا نارنجی';

  @override
  String get colorPapayaWhip => 'ہلکا نارنجی';

  @override
  String get colorLavenderBlush => 'سفيد';

  @override
  String get colorSeaShell => 'سفيد';

  @override
  String get colorCornsilk => 'ہلکا پیلا';

  @override
  String get colorLemonChiffon => 'ہلکا پیلا';

  @override
  String get colorFloralWhite => 'سفيد';

  @override
  String get colorSnow => 'سفيد';

  @override
  String get colorYellow => 'پيلا';

  @override
  String get colorLightYellow => 'ہلکا پیلا';

  @override
  String get colorIvory => 'سفيد';

  @override
  String get colorWhite => 'سفيد';
}
