import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Ukrainian (`uk`).
class FluentLocalizationsUk extends FluentLocalizations {
  FluentLocalizationsUk([String locale = 'uk']) : super(locale);

  @override
  String get backButtonTooltip => 'Назад';

  @override
  String get closeButtonLabel => 'Зачинити';

  @override
  String get searchLabel => 'Пошук';

  @override
  String get closeNavigationTooltip => 'Зачинити панель навігації';

  @override
  String get openNavigationTooltip => 'Відкрити панель навігації';

  @override
  String get clickToSearch => 'Натисніть для пошуку';

  @override
  String get modalBarrierDismissLabel => 'Відміна';

  @override
  String get minimizeWindowTooltip => 'Звернути';

  @override
  String get restoreWindowTooltip => 'Відновити';

  @override
  String get closeWindowTooltip => 'Зачинити';

  @override
  String get dialogLabel => 'Діалог';

  @override
  String get cutActionLabel => 'Вирізати';

  @override
  String get copyActionLabel => 'Копіювати';

  @override
  String get pasteActionLabel => 'Вставити';

  @override
  String get selectAllActionLabel => 'Обрати все';

  @override
  String get newTabLabel => 'Нова вкладка';

  @override
  String get closeTabLabelSuffix => 'Зачинити вкладку';

  @override
  String get scrollTabBackwardLabel => 'Прокрутити назад';

  @override
  String get scrollTabForwardLabel => 'Прокрутити вперед';

  @override
  String get noResultsFoundLabel => 'Результати не знайдені';

  @override
  String get copyActionTooltip => 'Скопіювати у буфер обміну';

  @override
  String get cutActionTooltip => 'Вирізати та помістити у буфер обміну';

  @override
  String get pasteActionTooltip => 'Вставити вміст буферу обміну';

  @override
  String get selectAllActionTooltip => 'Обрати все';

  @override
  String get hour => 'годин';

  @override
  String get minute => 'хвилин';

  @override
  String get am => 'AM';

  @override
  String get pm => 'PM';

  @override
  String get month => 'місяць';

  @override
  String get day => 'день';

  @override
  String get year => 'рік';

  @override
  String get redLabel => 'Червоний';

  @override
  String get greenLabel => 'Зелений';

  @override
  String get blueLabel => 'Синій';

  @override
  String get opacityLabel => 'Прозорість';

  @override
  String get hueLabel => 'Відтінок';

  @override
  String get saturationLabel => 'Насиченість';

  @override
  String get valueLabel => 'Значення';

  @override
  String get moreText => 'Більше';

  @override
  String get lessText => 'Менше';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return 'Значення $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '$value% Непрозорість';
  }

  @override
  String get colorBlack => 'Чорний';

  @override
  String get colorNavy => 'Темно-синій';

  @override
  String get colorDarkBlue => 'Темно-синій';

  @override
  String get colorMediumBlue => 'Синій';

  @override
  String get colorBlue => 'Синій';

  @override
  String get colorDarkGreen => 'Темно-зелений';

  @override
  String get colorGreen => 'Темно-зелений';

  @override
  String get colorTeal => 'Темно-сизий';

  @override
  String get colorDarkCyan => 'Темно-сизий';

  @override
  String get colorDeepSkyBlue => 'Бірюзовий';

  @override
  String get colorDarkTurquoise => 'Блакитний';

  @override
  String get colorMediumSpringGreen => 'Зелений';

  @override
  String get colorLime => 'Зелений';

  @override
  String get colorSpringGreen => 'Зелений';

  @override
  String get colorCyan => 'Блакитний';

  @override
  String get colorMidnightBlue => 'Темно-синій';

  @override
  String get colorDodgerBlue => 'Синій';

  @override
  String get colorLightSeaGreen => 'Бірюзовий';

  @override
  String get colorForestGreen => 'Темно-зелений';

  @override
  String get colorSeaGreen => 'Темно-зелений';

  @override
  String get colorDarkSlateGray => 'Темно-сизий';

  @override
  String get colorLimeGreen => 'Зелений';

  @override
  String get colorMediumSeaGreen => 'Зелений';

  @override
  String get colorTurquoise => 'Бірюзовий';

  @override
  String get colorRoyalBlue => 'Синій';

  @override
  String get colorSteelBlue => 'Сизий';

  @override
  String get colorDarkSlateBlue => 'Бузковий';

  @override
  String get colorMediumTurquoise => 'Бірюзовий';

  @override
  String get colorIndigo => 'Темно-фіолетовий';

  @override
  String get colorDarkOliveGreen => 'Темно-зелений';

  @override
  String get colorCadetBlue => 'Бірюзовий';

  @override
  String get colorCornflowerBlue => 'Синій';

  @override
  String get colorMediumAquamarine => 'Зелений';

  @override
  String get colorDimGray => 'Сірий';

  @override
  String get colorSlateBlue => 'Індиго';

  @override
  String get colorOliveDrab => 'Темно-зелений';

  @override
  String get colorSlateGray => 'Сизий';

  @override
  String get colorLightSlateGray => 'Сизий';

  @override
  String get colorMediumSlateBlue => 'Світло-синій';

  @override
  String get colorLawnGreen => 'Зелений';

  @override
  String get colorChartreuse => 'Зелений';

  @override
  String get colorAquamarine => 'Світло-зелений';

  @override
  String get colorMaroon => 'Темно-червоний';

  @override
  String get colorPurple => 'Темно-фіолетовий';

  @override
  String get colorOlive => 'Темно-жовтий';

  @override
  String get colorGray => 'Сірий';

  @override
  String get colorSkyBlue => 'Світло-бірюзовий';

  @override
  String get colorLightSkyBlue => 'Світло-синій';

  @override
  String get colorBlueViolet => 'Бузковий';

  @override
  String get colorDarkRed => 'Темно-червоний';

  @override
  String get colorDarkMagenta => 'Темно-фіолетовий';

  @override
  String get colorSaddleBrown => 'Коричневий';

  @override
  String get colorDarkSeaGreen => 'Зелений';

  @override
  String get colorLightGreen => 'Світло-зелений';

  @override
  String get colorMediumPurple => 'Ліловий';

  @override
  String get colorDarkViolet => 'Бузковий';

  @override
  String get colorPaleGreen => 'Світло-зелений';

  @override
  String get colorDarkOrchid => 'Бузковий';

  @override
  String get colorYellowGreen => 'Зелений';

  @override
  String get colorSienna => 'Жовто-коричневий';

  @override
  String get colorBrown => 'Червоний';

  @override
  String get colorDarkGray => 'Сірий';

  @override
  String get colorLightBlue => 'Блакитний';

  @override
  String get colorGreenYellow => 'Зелений';

  @override
  String get colorPaleTurquoise => 'Блакитний';

  @override
  String get colorLightSteelBlue => 'Пастельно-блакитний';

  @override
  String get colorPowderBlue => 'Блакитний';

  @override
  String get colorFirebrick => 'Червоний';

  @override
  String get colorDarkGoldenrod => 'Темно-жовтий';

  @override
  String get colorMediumOrchid => 'Бузковий';

  @override
  String get colorRosyBrown => 'Кораловий';

  @override
  String get colorDarkKhaki => 'Жовто-коричневий';

  @override
  String get colorSilver => 'Світло-сірий';

  @override
  String get colorMediumVioletRed => 'Рожевий';

  @override
  String get colorIndianRed => 'Червоний';

  @override
  String get colorPeru => 'Жовто-коричневий';

  @override
  String get colorChocolate => 'Помаранчевий';

  @override
  String get colorTan => 'Жовто-коричневий';

  @override
  String get colorLightGray => 'Світло-сірий';

  @override
  String get colorThistle => 'Ліловий';

  @override
  String get colorOrchid => 'Ліловий';

  @override
  String get colorGoldenrod => 'Золотистий';

  @override
  String get colorPaleVioletRed => 'Рожевий';

  @override
  String get colorCrimson => 'Червоний';

  @override
  String get colorGainsboro => 'Світло-сірий';

  @override
  String get colorPlum => 'Рожевий';

  @override
  String get colorBurlyWood => 'Жовто-коричневий';

  @override
  String get colorLightCyan => 'Блакитний';

  @override
  String get colorLavender => 'Світло-синій';

  @override
  String get colorDarkSalmon => 'Рожевий';

  @override
  String get colorViolet => 'Ліловий';

  @override
  String get colorPaleGoldenrod => 'Світло-жовтий';

  @override
  String get colorLightCoral => 'Рожевий';

  @override
  String get colorKhaki => 'Світло-жовтий';

  @override
  String get colorAliceBlue => 'Білий';

  @override
  String get colorHoneydew => 'Білий';

  @override
  String get colorAzure => 'Білий';

  @override
  String get colorSandyBrown => 'Світло-оранжевий';

  @override
  String get colorWheat => 'Світло-жовтий';

  @override
  String get colorBeige => 'Світло-жовтий';

  @override
  String get colorWhiteSmoke => 'Білий';

  @override
  String get colorMintCream => 'Білий';

  @override
  String get colorGhostWhite => 'Білий';

  @override
  String get colorSalmon => 'Рожевий';

  @override
  String get colorAntiqueWhite => 'Світло-оранжевий';

  @override
  String get colorLinen => 'Світло-оранжевий';

  @override
  String get colorLightGoldenrodYellow => 'Світло-жовтий';

  @override
  String get colorOldLace => 'Білий';

  @override
  String get colorRed => 'Червоний';

  @override
  String get colorMagenta => 'Бузковий';

  @override
  String get colorDeepPink => 'Рожевий';

  @override
  String get colorOrangeRed => 'Червоний';

  @override
  String get colorTomato => 'Червоний';

  @override
  String get colorHotPink => 'Рожевий';

  @override
  String get colorCoral => 'Червоний';

  @override
  String get colorDarkOrange => 'Помаранчевий';

  @override
  String get colorLightSalmon => 'Рожевий';

  @override
  String get colorOrange => 'Золотистий';

  @override
  String get colorLightPink => 'Рожевий';

  @override
  String get colorPink => 'Рожевий';

  @override
  String get colorGold => 'Золотистий';

  @override
  String get colorPeachPuff => 'Світло-оранжевий';

  @override
  String get colorNavajoWhite => 'Світло-оранжевий';

  @override
  String get colorMoccasin => 'Світло-оранжевий';

  @override
  String get colorBisque => 'Світло-оранжевий';

  @override
  String get colorMistyRose => 'Рожевий';

  @override
  String get colorBlanchedAlmond => 'Світло-оранжевий';

  @override
  String get colorPapayaWhip => 'Світло-оранжевий';

  @override
  String get colorLavenderBlush => 'Білий';

  @override
  String get colorSeaShell => 'Білий';

  @override
  String get colorCornsilk => 'Світло-жовтий';

  @override
  String get colorLemonChiffon => 'Світло-жовтий';

  @override
  String get colorFloralWhite => 'Білий';

  @override
  String get colorSnow => 'Білий';

  @override
  String get colorYellow => 'Жовтий';

  @override
  String get colorLightYellow => 'Світло-жовтий';

  @override
  String get colorIvory => 'Білий';

  @override
  String get colorWhite => 'Білий';
}
