import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Thai (`th`).
class FluentLocalizationsTh extends FluentLocalizations {
  FluentLocalizationsTh([String locale = 'th']) : super(locale);

  @override
  String get backButtonTooltip => 'กลับ';

  @override
  String get closeButtonLabel => 'ปิด';

  @override
  String get searchLabel => 'ค้นหา';

  @override
  String get closeNavigationTooltip => 'ปิดหน้าเมนู';

  @override
  String get openNavigationTooltip => 'เปิดหน้าเมนู';

  @override
  String get clickToSearch => 'คลิกเพื่อค้นหา';

  @override
  String get modalBarrierDismissLabel => 'ปิด';

  @override
  String get minimizeWindowTooltip => 'ย่อ';

  @override
  String get restoreWindowTooltip => 'คืนค่า';

  @override
  String get closeWindowTooltip => 'ปิด';

  @override
  String get dialogLabel => 'ไดอะล็อก';

  @override
  String get cutActionLabel => 'ตัด';

  @override
  String get copyActionLabel => 'คัดลอก';

  @override
  String get pasteActionLabel => 'วาง';

  @override
  String get selectAllActionLabel => 'เลือกทั้งหมด';

  @override
  String get newTabLabel => 'เพิ่มแท็บใหม่';

  @override
  String get closeTabLabelSuffix => 'ปิดแท็บ';

  @override
  String get scrollTabBackwardLabel => 'เลื่อนรายการย้อนกลับ';

  @override
  String get scrollTabForwardLabel => 'เลื่อนรายการไปข้างหน้า';

  @override
  String get noResultsFoundLabel => 'ไม่มีผลลัพท์';

  @override
  String get copyActionTooltip => 'คัดลอกข้อความที่เลือกไปยังคลิปบอร์ด';

  @override
  String get cutActionTooltip => 'ลบข้อความที่เลือกแล้วนำไปยังคลิปบอร์ด';

  @override
  String get pasteActionTooltip => 'ใส่เนื้อหาจากคลิปบอร์ดที่ตำแหน่งปัจจุบัน';

  @override
  String get selectAllActionTooltip => 'เลือกเนื้อหาทั้งหมด';

  @override
  String get hour => 'ชั่วโมง';

  @override
  String get minute => 'นาที';

  @override
  String get am => 'AM';

  @override
  String get pm => 'PM';

  @override
  String get month => 'เดือน';

  @override
  String get day => 'วัน';

  @override
  String get year => 'ปี';

  @override
  String get redLabel => 'แดง';

  @override
  String get greenLabel => 'เขียว';

  @override
  String get blueLabel => 'น้ำเงิน';

  @override
  String get opacityLabel => 'ความโปร่งใส';

  @override
  String get hueLabel => 'สี';

  @override
  String get saturationLabel => 'ความอิ่มตัว';

  @override
  String get valueLabel => 'ค่า';

  @override
  String get moreText => 'เพิ่มเติม';

  @override
  String get lessText => 'น้อยลง';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return 'ค่า $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '$value% ความทึบ';
  }

  @override
  String get colorBlack => 'ดำ';

  @override
  String get colorNavy => 'น้ำเงินเข้ม';

  @override
  String get colorDarkBlue => 'น้ำเงินเข้ม';

  @override
  String get colorMediumBlue => 'น้ำเงิน';

  @override
  String get colorBlue => 'น้ำเงิน';

  @override
  String get colorDarkGreen => 'เขียวเข้ม';

  @override
  String get colorGreen => 'เขียวเข้ม';

  @override
  String get colorTeal => 'เขียวหัวเป็ดเข้ม';

  @override
  String get colorDarkCyan => 'เขียวหัวเป็ดเข้ม';

  @override
  String get colorDeepSkyBlue => 'ฟ้าเทอร์คอยส์';

  @override
  String get colorDarkTurquoise => 'ฟ้าแกมเขียว';

  @override
  String get colorMediumSpringGreen => 'เขียว';

  @override
  String get colorLime => 'เขียว';

  @override
  String get colorSpringGreen => 'เขียว';

  @override
  String get colorCyan => 'ฟ้าแกมเขียว';

  @override
  String get colorMidnightBlue => 'น้ำเงินเข้ม';

  @override
  String get colorDodgerBlue => 'น้ำเงิน';

  @override
  String get colorLightSeaGreen => 'น้ำเงินอมเขียว';

  @override
  String get colorForestGreen => 'เขียวเข้ม';

  @override
  String get colorSeaGreen => 'เขียวเข้ม';

  @override
  String get colorDarkSlateGray => 'เขียวหัวเป็ดเข้ม';

  @override
  String get colorLimeGreen => 'เขียว';

  @override
  String get colorMediumSeaGreen => 'เขียว';

  @override
  String get colorTurquoise => 'น้ำเงินอมเขียว';

  @override
  String get colorRoyalBlue => 'น้ำเงิน';

  @override
  String get colorSteelBlue => 'น้ำเงิน-เทา';

  @override
  String get colorDarkSlateBlue => 'ม่วง';

  @override
  String get colorMediumTurquoise => 'น้ำเงินอมเขียว';

  @override
  String get colorIndigo => 'ม่วงเข้ม';

  @override
  String get colorDarkOliveGreen => 'เขียวเข้ม';

  @override
  String get colorCadetBlue => 'น้ำเงินอมเขียว';

  @override
  String get colorCornflowerBlue => 'น้ำเงิน';

  @override
  String get colorMediumAquamarine => 'เขียว';

  @override
  String get colorDimGray => 'เทา';

  @override
  String get colorSlateBlue => 'คราม';

  @override
  String get colorOliveDrab => 'เขียวเข้ม';

  @override
  String get colorSlateGray => 'น้ำเงิน-เทา';

  @override
  String get colorLightSlateGray => 'น้ำเงิน-เทา';

  @override
  String get colorMediumSlateBlue => 'น้ำเงินอ่อน';

  @override
  String get colorLawnGreen => 'เขียว';

  @override
  String get colorChartreuse => 'เขียว';

  @override
  String get colorAquamarine => 'เขียวอ่อน';

  @override
  String get colorMaroon => 'แดงเข้ม';

  @override
  String get colorPurple => 'ม่วงเข้ม';

  @override
  String get colorOlive => 'เหลืองเข้ม';

  @override
  String get colorGray => 'เทา';

  @override
  String get colorSkyBlue => 'ฟ้าเทอร์คอยส์อ่อน';

  @override
  String get colorLightSkyBlue => 'น้ำเงินอ่อน';

  @override
  String get colorBlueViolet => 'ม่วง';

  @override
  String get colorDarkRed => 'แดงเข้ม';

  @override
  String get colorDarkMagenta => 'ม่วงเข้ม';

  @override
  String get colorSaddleBrown => 'น้ำตาล';

  @override
  String get colorDarkSeaGreen => 'เขียว';

  @override
  String get colorLightGreen => 'เขียวอ่อน';

  @override
  String get colorMediumPurple => 'ม่วงลาเวนเดอร์';

  @override
  String get colorDarkViolet => 'ม่วง';

  @override
  String get colorPaleGreen => 'เขียวอ่อน';

  @override
  String get colorDarkOrchid => 'ม่วง';

  @override
  String get colorYellowGreen => 'เขียว';

  @override
  String get colorSienna => 'แทน';

  @override
  String get colorBrown => 'แดง';

  @override
  String get colorDarkGray => 'เทา';

  @override
  String get colorLightBlue => 'ฟ้าคราม';

  @override
  String get colorGreenYellow => 'เขียว';

  @override
  String get colorPaleTurquoise => 'ฟ้าแกมเขียว';

  @override
  String get colorLightSteelBlue => 'ฟ้าใส';

  @override
  String get colorPowderBlue => 'ฟ้าคราม';

  @override
  String get colorFirebrick => 'แดง';

  @override
  String get colorDarkGoldenrod => 'เหลืองเข้ม';

  @override
  String get colorMediumOrchid => 'ม่วง';

  @override
  String get colorRosyBrown => 'ส้มปะการัง';

  @override
  String get colorDarkKhaki => 'แทน';

  @override
  String get colorSilver => 'เทาอ่อน';

  @override
  String get colorMediumVioletRed => 'ชมพู';

  @override
  String get colorIndianRed => 'แดง';

  @override
  String get colorPeru => 'แทน';

  @override
  String get colorChocolate => 'ส้ม';

  @override
  String get colorTan => 'แทน';

  @override
  String get colorLightGray => 'เทาอ่อน';

  @override
  String get colorThistle => 'ม่วงลาเวนเดอร์';

  @override
  String get colorOrchid => 'ม่วงลาเวนเดอร์';

  @override
  String get colorGoldenrod => 'ทอง';

  @override
  String get colorPaleVioletRed => 'ชมพูกุหลาบ';

  @override
  String get colorCrimson => 'แดง';

  @override
  String get colorGainsboro => 'เทาอ่อน';

  @override
  String get colorPlum => 'ชมพู';

  @override
  String get colorBurlyWood => 'แทน';

  @override
  String get colorLightCyan => 'ฟ้าคราม';

  @override
  String get colorLavender => 'น้ำเงินอ่อน';

  @override
  String get colorDarkSalmon => 'ชมพูกุหลาบ';

  @override
  String get colorViolet => 'ม่วงลาเวนเดอร์';

  @override
  String get colorPaleGoldenrod => 'เหลืองอ่อน';

  @override
  String get colorLightCoral => 'ชมพูกุหลาบ';

  @override
  String get colorKhaki => 'เหลืองอ่อน';

  @override
  String get colorAliceBlue => 'ขาว';

  @override
  String get colorHoneydew => 'ขาว';

  @override
  String get colorAzure => 'ขาว';

  @override
  String get colorSandyBrown => 'ส้มอ่อน';

  @override
  String get colorWheat => 'เหลืองอ่อน';

  @override
  String get colorBeige => 'เหลืองอ่อน';

  @override
  String get colorWhiteSmoke => 'ขาว';

  @override
  String get colorMintCream => 'ขาว';

  @override
  String get colorGhostWhite => 'ขาว';

  @override
  String get colorSalmon => 'ชมพูกุหลาบ';

  @override
  String get colorAntiqueWhite => 'ส้มอ่อน';

  @override
  String get colorLinen => 'ส้มอ่อน';

  @override
  String get colorLightGoldenrodYellow => 'เหลืองอ่อน';

  @override
  String get colorOldLace => 'ขาว';

  @override
  String get colorRed => 'แดง';

  @override
  String get colorMagenta => 'ม่วง';

  @override
  String get colorDeepPink => 'ชมพู';

  @override
  String get colorOrangeRed => 'แดง';

  @override
  String get colorTomato => 'แดง';

  @override
  String get colorHotPink => 'ชมพู';

  @override
  String get colorCoral => 'แดง';

  @override
  String get colorDarkOrange => 'ส้ม';

  @override
  String get colorLightSalmon => 'ชมพูกุหลาบ';

  @override
  String get colorOrange => 'ทอง';

  @override
  String get colorLightPink => 'ชมพูกุหลาบ';

  @override
  String get colorPink => 'ชมพูกุหลาบ';

  @override
  String get colorGold => 'ทอง';

  @override
  String get colorPeachPuff => 'ส้มอ่อน';

  @override
  String get colorNavajoWhite => 'ส้มอ่อน';

  @override
  String get colorMoccasin => 'ส้มอ่อน';

  @override
  String get colorBisque => 'ส้มอ่อน';

  @override
  String get colorMistyRose => 'ชมพูกุหลาบ';

  @override
  String get colorBlanchedAlmond => 'ส้มอ่อน';

  @override
  String get colorPapayaWhip => 'ส้มอ่อน';

  @override
  String get colorLavenderBlush => 'ขาว';

  @override
  String get colorSeaShell => 'ขาว';

  @override
  String get colorCornsilk => 'เหลืองอ่อน';

  @override
  String get colorLemonChiffon => 'เหลืองอ่อน';

  @override
  String get colorFloralWhite => 'ขาว';

  @override
  String get colorSnow => 'ขาว';

  @override
  String get colorYellow => 'เหลือง';

  @override
  String get colorLightYellow => 'เหลืองอ่อน';

  @override
  String get colorIvory => 'ขาว';

  @override
  String get colorWhite => 'ขาว';
}
