import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Tamil (`ta`).
class FluentLocalizationsTa extends FluentLocalizations {
  FluentLocalizationsTa([String locale = 'ta']) : super(locale);

  @override
  String get backButtonTooltip => 'பின்';

  @override
  String get closeButtonLabel => 'மூடு';

  @override
  String get searchLabel => 'தேடு';

  @override
  String get closeNavigationTooltip => 'வழிசெலுத்தலை மூடு';

  @override
  String get openNavigationTooltip => 'வழிசெலுத்தலை திற';

  @override
  String get clickToSearch => 'தேடுவதற்கு தட்டவும்';

  @override
  String get modalBarrierDismissLabel => 'அகற்று';

  @override
  String get minimizeWindowTooltip => 'சிறிதாக்கு';

  @override
  String get restoreWindowTooltip => 'மீட்டமை';

  @override
  String get closeWindowTooltip => 'மூடு';

  @override
  String get dialogLabel => 'உரையாடல்';

  @override
  String get cutActionLabel => 'வெட்டு';

  @override
  String get copyActionLabel => 'நகல்';

  @override
  String get pasteActionLabel => 'ஒட்டு';

  @override
  String get selectAllActionLabel => 'அனைத்தையும் தெரிவுசெய்';

  @override
  String get newTabLabel => 'புதிய தாவலைச் சேர்';

  @override
  String get closeTabLabelSuffix => 'தாவலை மூடு';

  @override
  String get scrollTabBackwardLabel => 'தாவல் பட்டியலை பின்னோக்கி உருட்டவும்';

  @override
  String get scrollTabForwardLabel => 'தாவல் பட்டியலை முன்னோக்கி உருட்டவும்';

  @override
  String get noResultsFoundLabel => 'முடிவுகள் எதுவும் இல்லை';

  @override
  String get copyActionTooltip =>
      'தேர்ந்தெடுத்த உள்ளடக்கத்தை கிளிப்போர்டில் நகலெடுக்கவும்';

  @override
  String get cutActionTooltip =>
      'தேர்ந்தெடுத்த உள்ளடக்கத்தை அகற்றி கிளிப்போர்டில் வைக்கவும்';

  @override
  String get pasteActionTooltip =>
      'கிளிப்போர்டின் உள்ளடக்கங்களை தற்போதைய இடத்தில் செருகும்';

  @override
  String get selectAllActionTooltip =>
      'அனைத்து உள்ளடக்கத்தையும் தேர்ந்தெடுக்கவும்';

  @override
  String get hour => 'மணி';

  @override
  String get minute => 'நிமிடம்';

  @override
  String get am => 'AM';

  @override
  String get pm => 'PM';

  @override
  String get month => 'மாதம்';

  @override
  String get day => 'நாள்';

  @override
  String get year => 'ஆண்டு';

  @override
  String get redLabel => 'சிவப்பு';

  @override
  String get greenLabel => 'பச்சை';

  @override
  String get blueLabel => 'நீலம்';

  @override
  String get opacityLabel => 'ஒளிபுகாத்தன்மை';

  @override
  String get hueLabel => 'நிறம்';

  @override
  String get saturationLabel => 'செறிவு';

  @override
  String get valueLabel => 'மதிப்பு';

  @override
  String get moreText => 'மேலும்';

  @override
  String get lessText => 'குறைவாக';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return 'மதிப்பு $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '$value% ஒளிபுகாத்தன்மை';
  }

  @override
  String get colorBlack => 'கருப்பு';

  @override
  String get colorNavy => 'அடர் நீலம்';

  @override
  String get colorDarkBlue => 'அடர் நீலம்';

  @override
  String get colorMediumBlue => 'நீலம்';

  @override
  String get colorBlue => 'நீலம்';

  @override
  String get colorDarkGreen => 'அடர் பச்சை';

  @override
  String get colorGreen => 'அடர் பச்சை';

  @override
  String get colorTeal => 'அடர் பசும்நீலம்';

  @override
  String get colorDarkCyan => 'அடர் பசும்நீலம்';

  @override
  String get colorDeepSkyBlue => 'டர்க்கோய்ஸ்';

  @override
  String get colorDarkTurquoise => 'நீர் வண்ணம்';

  @override
  String get colorMediumSpringGreen => 'பச்சை';

  @override
  String get colorLime => 'பச்சை';

  @override
  String get colorSpringGreen => 'பச்சை';

  @override
  String get colorCyan => 'நீர் வண்ணம்';

  @override
  String get colorMidnightBlue => 'அடர் நீலம்';

  @override
  String get colorDodgerBlue => 'நீலம்';

  @override
  String get colorLightSeaGreen => 'பசும்நீலம்';

  @override
  String get colorForestGreen => 'அடர் பச்சை';

  @override
  String get colorSeaGreen => 'அடர் பச்சை';

  @override
  String get colorDarkSlateGray => 'அடர் பசும்நீலம்';

  @override
  String get colorLimeGreen => 'பச்சை';

  @override
  String get colorMediumSeaGreen => 'பச்சை';

  @override
  String get colorTurquoise => 'பசும்நீலம்';

  @override
  String get colorRoyalBlue => 'நீலம்';

  @override
  String get colorSteelBlue => 'நீலம்-சாம்பல்';

  @override
  String get colorDarkSlateBlue => 'கருஞ்சிவப்பு';

  @override
  String get colorMediumTurquoise => 'பசும்நீலம்';

  @override
  String get colorIndigo => 'அடர் கருஞ்சிவப்பு';

  @override
  String get colorDarkOliveGreen => 'அடர் பச்சை';

  @override
  String get colorCadetBlue => 'பசும்நீலம்';

  @override
  String get colorCornflowerBlue => 'நீலம்';

  @override
  String get colorMediumAquamarine => 'பச்சை';

  @override
  String get colorDimGray => 'சாம்பல்';

  @override
  String get colorSlateBlue => 'கருநீலம்';

  @override
  String get colorOliveDrab => 'அடர் பச்சை';

  @override
  String get colorSlateGray => 'நீலம்-சாம்பல்';

  @override
  String get colorLightSlateGray => 'நீலம்-சாம்பல்';

  @override
  String get colorMediumSlateBlue => 'இளம் நீலம்';

  @override
  String get colorLawnGreen => 'பச்சை';

  @override
  String get colorChartreuse => 'பச்சை';

  @override
  String get colorAquamarine => 'வெளிர் பச்சை';

  @override
  String get colorMaroon => 'அடர் சிவப்பு';

  @override
  String get colorPurple => 'அடர் கருஞ்சிவப்பு';

  @override
  String get colorOlive => 'அடர் மஞ்சள்';

  @override
  String get colorGray => 'சாம்பல்';

  @override
  String get colorSkyBlue => 'வெளிர் டர்க்கோய்ஸ்';

  @override
  String get colorLightSkyBlue => 'இளம் நீலம்';

  @override
  String get colorBlueViolet => 'கருஞ்சிவப்பு';

  @override
  String get colorDarkRed => 'அடர் சிவப்பு';

  @override
  String get colorDarkMagenta => 'அடர் கருஞ்சிவப்பு';

  @override
  String get colorSaddleBrown => 'பழுப்பு';

  @override
  String get colorDarkSeaGreen => 'பச்சை';

  @override
  String get colorLightGreen => 'வெளிர் பச்சை';

  @override
  String get colorMediumPurple => 'தாழம்பூ';

  @override
  String get colorDarkViolet => 'கருஞ்சிவப்பு';

  @override
  String get colorPaleGreen => 'வெளிர் பச்சை';

  @override
  String get colorDarkOrchid => 'கருஞ்சிவப்பு';

  @override
  String get colorYellowGreen => 'பச்சை';

  @override
  String get colorSienna => 'வெளிறிய மேனி நிறம்';

  @override
  String get colorBrown => 'சிவப்பு';

  @override
  String get colorDarkGray => 'சாம்பல்';

  @override
  String get colorLightBlue => 'மேக நீலம்';

  @override
  String get colorGreenYellow => 'பச்சை';

  @override
  String get colorPaleTurquoise => 'நீர் வண்ணம்';

  @override
  String get colorLightSteelBlue => 'ஐஸ் நீலம்';

  @override
  String get colorPowderBlue => 'மேக நீலம்';

  @override
  String get colorFirebrick => 'சிவப்பு';

  @override
  String get colorDarkGoldenrod => 'அடர் மஞ்சள்';

  @override
  String get colorMediumOrchid => 'கருஞ்சிவப்பு';

  @override
  String get colorRosyBrown => 'பவளம்';

  @override
  String get colorDarkKhaki => 'வெளிறிய மேனி நிறம்';

  @override
  String get colorSilver => 'வெளிர் சாம்பல்';

  @override
  String get colorMediumVioletRed => 'இளஞ்சிவப்பு';

  @override
  String get colorIndianRed => 'சிவப்பு';

  @override
  String get colorPeru => 'வெளிறிய மேனி நிறம்';

  @override
  String get colorChocolate => 'ஆரஞ்சு';

  @override
  String get colorTan => 'வெளிறிய மேனி நிறம்';

  @override
  String get colorLightGray => 'வெளிர் சாம்பல்';

  @override
  String get colorThistle => 'தாழம்பூ';

  @override
  String get colorOrchid => 'தாழம்பூ';

  @override
  String get colorGoldenrod => 'தங்கம்';

  @override
  String get colorPaleVioletRed => 'ரோஸ்';

  @override
  String get colorCrimson => 'சிவப்பு';

  @override
  String get colorGainsboro => 'வெளிர் சாம்பல்';

  @override
  String get colorPlum => 'இளஞ்சிவப்பு';

  @override
  String get colorBurlyWood => 'வெளிறிய மேனி நிறம்';

  @override
  String get colorLightCyan => 'மேக நீலம்';

  @override
  String get colorLavender => 'இளம் நீலம்';

  @override
  String get colorDarkSalmon => 'ரோஸ்';

  @override
  String get colorViolet => 'தாழம்பூ';

  @override
  String get colorPaleGoldenrod => 'வெளிர் மஞ்சள்';

  @override
  String get colorLightCoral => 'ரோஸ்';

  @override
  String get colorKhaki => 'வெளிர் மஞ்சள்';

  @override
  String get colorAliceBlue => 'வெள்ளை';

  @override
  String get colorHoneydew => 'வெள்ளை';

  @override
  String get colorAzure => 'வெள்ளை';

  @override
  String get colorSandyBrown => 'வெளிர் ஆரஞ்சு';

  @override
  String get colorWheat => 'வெளிர் மஞ்சள்';

  @override
  String get colorBeige => 'வெளிர் மஞ்சள்';

  @override
  String get colorWhiteSmoke => 'வெள்ளை';

  @override
  String get colorMintCream => 'வெள்ளை';

  @override
  String get colorGhostWhite => 'வெள்ளை';

  @override
  String get colorSalmon => 'ரோஸ்';

  @override
  String get colorAntiqueWhite => 'வெளிர் ஆரஞ்சு';

  @override
  String get colorLinen => 'வெளிர் ஆரஞ்சு';

  @override
  String get colorLightGoldenrodYellow => 'வெளிர் மஞ்சள்';

  @override
  String get colorOldLace => 'வெள்ளை';

  @override
  String get colorRed => 'சிவப்பு';

  @override
  String get colorMagenta => 'கருஞ்சிவப்பு';

  @override
  String get colorDeepPink => 'இளஞ்சிவப்பு';

  @override
  String get colorOrangeRed => 'சிவப்பு';

  @override
  String get colorTomato => 'சிவப்பு';

  @override
  String get colorHotPink => 'இளஞ்சிவப்பு';

  @override
  String get colorCoral => 'சிவப்பு';

  @override
  String get colorDarkOrange => 'ஆரஞ்சு';

  @override
  String get colorLightSalmon => 'ரோஸ்';

  @override
  String get colorOrange => 'தங்கம்';

  @override
  String get colorLightPink => 'ரோஸ்';

  @override
  String get colorPink => 'ரோஸ்';

  @override
  String get colorGold => 'தங்கம்';

  @override
  String get colorPeachPuff => 'வெளிர் ஆரஞ்சு';

  @override
  String get colorNavajoWhite => 'வெளிர் ஆரஞ்சு';

  @override
  String get colorMoccasin => 'வெளிர் ஆரஞ்சு';

  @override
  String get colorBisque => 'வெளிர் ஆரஞ்சு';

  @override
  String get colorMistyRose => 'ரோஸ்';

  @override
  String get colorBlanchedAlmond => 'வெளிர் ஆரஞ்சு';

  @override
  String get colorPapayaWhip => 'வெளிர் ஆரஞ்சு';

  @override
  String get colorLavenderBlush => 'வெள்ளை';

  @override
  String get colorSeaShell => 'வெள்ளை';

  @override
  String get colorCornsilk => 'வெளிர் மஞ்சள்';

  @override
  String get colorLemonChiffon => 'வெளிர் மஞ்சள்';

  @override
  String get colorFloralWhite => 'வெள்ளை';

  @override
  String get colorSnow => 'வெள்ளை';

  @override
  String get colorYellow => 'மஞ்சள்';

  @override
  String get colorLightYellow => 'வெளிர் மஞ்சள்';

  @override
  String get colorIvory => 'வெள்ளை';

  @override
  String get colorWhite => 'வெள்ளை';
}
