import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Russian (`ru`).
class FluentLocalizationsRu extends FluentLocalizations {
  FluentLocalizationsRu([String locale = 'ru']) : super(locale);

  @override
  String get backButtonTooltip => 'Назад';

  @override
  String get closeButtonLabel => 'Закрыть';

  @override
  String get searchLabel => 'Поиск';

  @override
  String get closeNavigationTooltip => 'Закрыть панель навигации';

  @override
  String get openNavigationTooltip => 'Открыть панель навигации';

  @override
  String get clickToSearch => 'Нажмите для поиска';

  @override
  String get modalBarrierDismissLabel => 'Отмена';

  @override
  String get minimizeWindowTooltip => 'Свернуть';

  @override
  String get restoreWindowTooltip => 'Восстановить';

  @override
  String get closeWindowTooltip => 'Закрыть';

  @override
  String get dialogLabel => 'Диалог';

  @override
  String get cutActionLabel => 'Вырезать';

  @override
  String get copyActionLabel => 'Копировать';

  @override
  String get pasteActionLabel => 'Вставить';

  @override
  String get selectAllActionLabel => 'Выбрать все';

  @override
  String get newTabLabel => 'Новая вкладка';

  @override
  String get closeTabLabelSuffix => 'Закрыть вкладку';

  @override
  String get scrollTabBackwardLabel => 'Прокрутить назад';

  @override
  String get scrollTabForwardLabel => 'Прокрутить вперед';

  @override
  String get noResultsFoundLabel => 'Результаты не найдены';

  @override
  String get copyActionTooltip => 'Скопировать в буфер обмена';

  @override
  String get cutActionTooltip => 'Вырезать и поместить в буфер обмена';

  @override
  String get pasteActionTooltip => 'Вставить содержимое буфера обмена';

  @override
  String get selectAllActionTooltip => 'Выбрать все';

  @override
  String get hour => 'hour';

  @override
  String get minute => 'minute';

  @override
  String get am => 'AM';

  @override
  String get pm => 'PM';

  @override
  String get month => 'month';

  @override
  String get day => 'day';

  @override
  String get year => 'year';

  @override
  String get redLabel => 'Красный';

  @override
  String get greenLabel => 'Зеленый';

  @override
  String get blueLabel => 'Синий';

  @override
  String get opacityLabel => 'Прозрачность';

  @override
  String get hueLabel => 'Оттенок';

  @override
  String get saturationLabel => 'Насыщенность';

  @override
  String get valueLabel => 'Значение';

  @override
  String get moreText => 'Больше';

  @override
  String get lessText => 'Меньше';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return 'Значение $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '$value% Непрозрачность';
  }

  @override
  String get colorBlack => 'Черный';

  @override
  String get colorNavy => 'Темно-синий';

  @override
  String get colorDarkBlue => 'Темно-синий';

  @override
  String get colorMediumBlue => 'Синий';

  @override
  String get colorBlue => 'Синий';

  @override
  String get colorDarkGreen => 'Темно-зеленый';

  @override
  String get colorGreen => 'Темно-зеленый';

  @override
  String get colorTeal => 'Темный сине-зеленый';

  @override
  String get colorDarkCyan => 'Темный сине-зеленый';

  @override
  String get colorDeepSkyBlue => 'Бирюзовый';

  @override
  String get colorDarkTurquoise => 'Зеленовато-голубой';

  @override
  String get colorMediumSpringGreen => 'Зеленый';

  @override
  String get colorLime => 'Зеленый';

  @override
  String get colorSpringGreen => 'Зеленый';

  @override
  String get colorCyan => 'Зеленовато-голубой';

  @override
  String get colorMidnightBlue => 'Темно-синий';

  @override
  String get colorDodgerBlue => 'Синий';

  @override
  String get colorLightSeaGreen => 'Сине-зеленый';

  @override
  String get colorForestGreen => 'Темно-зеленый';

  @override
  String get colorSeaGreen => 'Темно-зеленый';

  @override
  String get colorDarkSlateGray => 'Темный сине-зеленый';

  @override
  String get colorLimeGreen => 'Зеленый';

  @override
  String get colorMediumSeaGreen => 'Зеленый';

  @override
  String get colorTurquoise => 'Сине-зеленый';

  @override
  String get colorRoyalBlue => 'Синий';

  @override
  String get colorSteelBlue => 'Сизый';

  @override
  String get colorDarkSlateBlue => 'Сиреневый';

  @override
  String get colorMediumTurquoise => 'Сине-зеленый';

  @override
  String get colorIndigo => 'Темно-фиолетовый';

  @override
  String get colorDarkOliveGreen => 'Темно-зеленый';

  @override
  String get colorCadetBlue => 'Сине-зеленый';

  @override
  String get colorCornflowerBlue => 'Синий';

  @override
  String get colorMediumAquamarine => 'Зеленый';

  @override
  String get colorDimGray => 'Серый';

  @override
  String get colorSlateBlue => 'Индиго';

  @override
  String get colorOliveDrab => 'Темно-зеленый';

  @override
  String get colorSlateGray => 'Сизый';

  @override
  String get colorLightSlateGray => 'Сизый';

  @override
  String get colorMediumSlateBlue => 'Голубой';

  @override
  String get colorLawnGreen => 'Зеленый';

  @override
  String get colorChartreuse => 'Зеленый';

  @override
  String get colorAquamarine => 'Бледно-зеленый';

  @override
  String get colorMaroon => 'Темно-красный';

  @override
  String get colorPurple => 'Темно-фиолетовый';

  @override
  String get colorOlive => 'Темно-желтый';

  @override
  String get colorGray => 'Серый';

  @override
  String get colorSkyBlue => 'Светло-бирюзовый';

  @override
  String get colorLightSkyBlue => 'Голубой';

  @override
  String get colorBlueViolet => 'Сиреневый';

  @override
  String get colorDarkRed => 'Темно-красный';

  @override
  String get colorDarkMagenta => 'Темно-фиолетовый';

  @override
  String get colorSaddleBrown => 'Коричневый';

  @override
  String get colorDarkSeaGreen => 'Зеленый';

  @override
  String get colorLightGreen => 'Бледно-зеленый';

  @override
  String get colorMediumPurple => 'Бледный розовато-лиловый';

  @override
  String get colorDarkViolet => 'Сиреневый';

  @override
  String get colorPaleGreen => 'Бледно-зеленый';

  @override
  String get colorDarkOrchid => 'Сиреневый';

  @override
  String get colorYellowGreen => 'Зеленый';

  @override
  String get colorSienna => 'Желто-коричневый';

  @override
  String get colorBrown => 'Красный';

  @override
  String get colorDarkGray => 'Серый';

  @override
  String get colorLightBlue => 'Небесно-синий';

  @override
  String get colorGreenYellow => 'Зеленый';

  @override
  String get colorPaleTurquoise => 'Зеленовато-голубой';

  @override
  String get colorLightSteelBlue => 'Пастельный голубой';

  @override
  String get colorPowderBlue => 'Небесно-синий';

  @override
  String get colorFirebrick => 'Красный';

  @override
  String get colorDarkGoldenrod => 'Темно-желтый';

  @override
  String get colorMediumOrchid => 'Сиреневый';

  @override
  String get colorRosyBrown => 'Коралловый';

  @override
  String get colorDarkKhaki => 'Желто-коричневый';

  @override
  String get colorSilver => 'Светло-серый';

  @override
  String get colorMediumVioletRed => 'Розовый';

  @override
  String get colorIndianRed => 'Красный';

  @override
  String get colorPeru => 'Желто-коричневый';

  @override
  String get colorChocolate => 'Оранжевый';

  @override
  String get colorTan => 'Желто-коричневый';

  @override
  String get colorLightGray => 'Светло-серый';

  @override
  String get colorThistle => 'Бледный розовато-лиловый';

  @override
  String get colorOrchid => 'Бледный розовато-лиловый';

  @override
  String get colorGoldenrod => 'Золотистый';

  @override
  String get colorPaleVioletRed => 'Розовый';

  @override
  String get colorCrimson => 'Красный';

  @override
  String get colorGainsboro => 'Светло-серый';

  @override
  String get colorPlum => 'Розовый';

  @override
  String get colorBurlyWood => 'Желто-коричневый';

  @override
  String get colorLightCyan => 'Небесно-синий';

  @override
  String get colorLavender => 'Голубой';

  @override
  String get colorDarkSalmon => 'Розовый';

  @override
  String get colorViolet => 'Бледный розовато-лиловый';

  @override
  String get colorPaleGoldenrod => 'Светло-желтый';

  @override
  String get colorLightCoral => 'Розовый';

  @override
  String get colorKhaki => 'Светло-желтый';

  @override
  String get colorAliceBlue => 'Белый';

  @override
  String get colorHoneydew => 'Белый';

  @override
  String get colorAzure => 'Белый';

  @override
  String get colorSandyBrown => 'Светло-оранжевый';

  @override
  String get colorWheat => 'Светло-желтый';

  @override
  String get colorBeige => 'Светло-желтый';

  @override
  String get colorWhiteSmoke => 'Белый';

  @override
  String get colorMintCream => 'Белый';

  @override
  String get colorGhostWhite => 'Белый';

  @override
  String get colorSalmon => 'Розовый';

  @override
  String get colorAntiqueWhite => 'Светло-оранжевый';

  @override
  String get colorLinen => 'Светло-оранжевый';

  @override
  String get colorLightGoldenrodYellow => 'Светло-желтый';

  @override
  String get colorOldLace => 'Белый';

  @override
  String get colorRed => 'Красный';

  @override
  String get colorMagenta => 'Сиреневый';

  @override
  String get colorDeepPink => 'Розовый';

  @override
  String get colorOrangeRed => 'Красный';

  @override
  String get colorTomato => 'Красный';

  @override
  String get colorHotPink => 'Розовый';

  @override
  String get colorCoral => 'Красный';

  @override
  String get colorDarkOrange => 'Оранжевый';

  @override
  String get colorLightSalmon => 'Розовый';

  @override
  String get colorOrange => 'Золотистый';

  @override
  String get colorLightPink => 'Розовый';

  @override
  String get colorPink => 'Розовый';

  @override
  String get colorGold => 'Золотистый';

  @override
  String get colorPeachPuff => 'Светло-оранжевый';

  @override
  String get colorNavajoWhite => 'Светло-оранжевый';

  @override
  String get colorMoccasin => 'Светло-оранжевый';

  @override
  String get colorBisque => 'Светло-оранжевый';

  @override
  String get colorMistyRose => 'Розовый';

  @override
  String get colorBlanchedAlmond => 'Светло-оранжевый';

  @override
  String get colorPapayaWhip => 'Светло-оранжевый';

  @override
  String get colorLavenderBlush => 'Белый';

  @override
  String get colorSeaShell => 'Белый';

  @override
  String get colorCornsilk => 'Светло-желтый';

  @override
  String get colorLemonChiffon => 'Светло-желтый';

  @override
  String get colorFloralWhite => 'Белый';

  @override
  String get colorSnow => 'Белый';

  @override
  String get colorYellow => 'Желтый';

  @override
  String get colorLightYellow => 'Светло-желтый';

  @override
  String get colorIvory => 'Белый';

  @override
  String get colorWhite => 'Белый';
}
