import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Portuguese (`pt`).
class FluentLocalizationsPt extends FluentLocalizations {
  FluentLocalizationsPt([String locale = 'pt']) : super(locale);

  @override
  String get backButtonTooltip => 'Voltar';

  @override
  String get closeButtonLabel => 'Fechar';

  @override
  String get searchLabel => 'Pesquisar';

  @override
  String get closeNavigationTooltip => 'Fechar navegação';

  @override
  String get openNavigationTooltip => 'Abrir navegação';

  @override
  String get clickToSearch => 'Clique para pesquisar';

  @override
  String get modalBarrierDismissLabel => 'Cancelar';

  @override
  String get minimizeWindowTooltip => 'Minimizar';

  @override
  String get restoreWindowTooltip => 'Restaurar';

  @override
  String get closeWindowTooltip => 'Fechar';

  @override
  String get dialogLabel => 'Caixa de diálogo';

  @override
  String get cutActionLabel => 'Cortar';

  @override
  String get copyActionLabel => 'Copiar';

  @override
  String get pasteActionLabel => 'Colar';

  @override
  String get selectAllActionLabel => 'Selecionar tudo';

  @override
  String get newTabLabel => 'Adicionar nova guia';

  @override
  String get closeTabLabelSuffix => 'Fechar guia';

  @override
  String get scrollTabBackwardLabel => 'Rolar para trás';

  @override
  String get scrollTabForwardLabel => 'Rolar para frente';

  @override
  String get noResultsFoundLabel => 'Nenhum resultado encontrado';

  @override
  String get copyActionTooltip =>
      'Copiar conteúdo selecionado para a área de transferência';

  @override
  String get cutActionTooltip =>
      'Recortar o conteúdo selecionado e colocá-lo na área de transferência';

  @override
  String get pasteActionTooltip =>
      'Colar o conteúdo da área de transferência na posição atual';

  @override
  String get selectAllActionTooltip => 'Selecionar tudo';

  @override
  String get hour => 'hora';

  @override
  String get minute => 'minuto';

  @override
  String get am => 'AM';

  @override
  String get pm => 'PM';

  @override
  String get month => 'mês';

  @override
  String get day => 'dia';

  @override
  String get year => 'ano';

  @override
  String get redLabel => 'Vermelho';

  @override
  String get greenLabel => 'Verde';

  @override
  String get blueLabel => 'Azul';

  @override
  String get opacityLabel => 'Opacidade';

  @override
  String get hueLabel => 'Matiz';

  @override
  String get saturationLabel => 'Saturação';

  @override
  String get valueLabel => 'Valor';

  @override
  String get moreText => 'Mais';

  @override
  String get lessText => 'Menos';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return 'Valor $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '$value% Opacidade';
  }

  @override
  String get colorBlack => 'Preto';

  @override
  String get colorNavy => 'Azul escuro';

  @override
  String get colorDarkBlue => 'Azul escuro';

  @override
  String get colorMediumBlue => 'Azul';

  @override
  String get colorBlue => 'Azul';

  @override
  String get colorDarkGreen => 'Verde escuro';

  @override
  String get colorGreen => 'Verde escuro';

  @override
  String get colorTeal => 'Verde cinza escuro';

  @override
  String get colorDarkCyan => 'Verde cinza escuro';

  @override
  String get colorDeepSkyBlue => 'Azul turquesa';

  @override
  String get colorDarkTurquoise => 'Azul marinho';

  @override
  String get colorMediumSpringGreen => 'Verde';

  @override
  String get colorLime => 'Verde';

  @override
  String get colorSpringGreen => 'Verde';

  @override
  String get colorCyan => 'Azul marinho';

  @override
  String get colorMidnightBlue => 'Azul escuro';

  @override
  String get colorDodgerBlue => 'Azul';

  @override
  String get colorLightSeaGreen => 'Verde cinza';

  @override
  String get colorForestGreen => 'Verde escuro';

  @override
  String get colorSeaGreen => 'Verde escuro';

  @override
  String get colorDarkSlateGray => 'Verde cinza escuro';

  @override
  String get colorLimeGreen => 'Verde';

  @override
  String get colorMediumSeaGreen => 'Verde';

  @override
  String get colorTurquoise => 'Verde cinza';

  @override
  String get colorRoyalBlue => 'Azul';

  @override
  String get colorSteelBlue => 'Azul acinzentado';

  @override
  String get colorDarkSlateBlue => 'Roxo';

  @override
  String get colorMediumTurquoise => 'Verde cinza';

  @override
  String get colorIndigo => 'Roxo escuro';

  @override
  String get colorDarkOliveGreen => 'Verde escuro';

  @override
  String get colorCadetBlue => 'Verde cinza';

  @override
  String get colorCornflowerBlue => 'Azul';

  @override
  String get colorMediumAquamarine => 'Verde';

  @override
  String get colorDimGray => 'Cinzento';

  @override
  String get colorSlateBlue => 'Índigo';

  @override
  String get colorOliveDrab => 'Verde escuro';

  @override
  String get colorSlateGray => 'Azul acinzentado';

  @override
  String get colorLightSlateGray => 'Azul acinzentado';

  @override
  String get colorMediumSlateBlue => 'Azul claro';

  @override
  String get colorLawnGreen => 'Verde';

  @override
  String get colorChartreuse => 'Verde';

  @override
  String get colorAquamarine => 'Verde claro';

  @override
  String get colorMaroon => 'Vermelho escuro';

  @override
  String get colorPurple => 'Roxo escuro';

  @override
  String get colorOlive => 'Amarelo escuro';

  @override
  String get colorGray => 'Cinzento';

  @override
  String get colorSkyBlue => 'Azul turquesa claro';

  @override
  String get colorLightSkyBlue => 'Azul claro';

  @override
  String get colorBlueViolet => 'Roxo';

  @override
  String get colorDarkRed => 'Vermelho escuro';

  @override
  String get colorDarkMagenta => 'Roxo escuro';

  @override
  String get colorSaddleBrown => 'Castanho';

  @override
  String get colorDarkSeaGreen => 'Verde';

  @override
  String get colorLightGreen => 'Verde claro';

  @override
  String get colorMediumPurple => 'Lilás';

  @override
  String get colorDarkViolet => 'Roxo';

  @override
  String get colorPaleGreen => 'Verde claro';

  @override
  String get colorDarkOrchid => 'Roxo';

  @override
  String get colorYellowGreen => 'Verde';

  @override
  String get colorSienna => 'Bege';

  @override
  String get colorBrown => 'Vermelho';

  @override
  String get colorDarkGray => 'Cinzento';

  @override
  String get colorLightBlue => 'Azul celeste';

  @override
  String get colorGreenYellow => 'Verde';

  @override
  String get colorPaleTurquoise => 'Azul marinho';

  @override
  String get colorLightSteelBlue => 'Azul gelo';

  @override
  String get colorPowderBlue => 'Azul celeste';

  @override
  String get colorFirebrick => 'Vermelho';

  @override
  String get colorDarkGoldenrod => 'Amarelo escuro';

  @override
  String get colorMediumOrchid => 'Roxo';

  @override
  String get colorRosyBrown => 'Coral';

  @override
  String get colorDarkKhaki => 'Bege';

  @override
  String get colorSilver => 'Cinzento claro';

  @override
  String get colorMediumVioletRed => 'Cor-de-rosa';

  @override
  String get colorIndianRed => 'Vermelho';

  @override
  String get colorPeru => 'Bege';

  @override
  String get colorChocolate => 'Cor de laranja';

  @override
  String get colorTan => 'Bege';

  @override
  String get colorLightGray => 'Cinzento claro';

  @override
  String get colorThistle => 'Lilás';

  @override
  String get colorOrchid => 'Lilás';

  @override
  String get colorGoldenrod => 'Dourado';

  @override
  String get colorPaleVioletRed => 'Cor-de-rosa escuro';

  @override
  String get colorCrimson => 'Vermelho';

  @override
  String get colorGainsboro => 'Cinzento claro';

  @override
  String get colorPlum => 'Cor-de-rosa';

  @override
  String get colorBurlyWood => 'Bege';

  @override
  String get colorLightCyan => 'Azul celeste';

  @override
  String get colorLavender => 'Azul claro';

  @override
  String get colorDarkSalmon => 'Cor-de-rosa escuro';

  @override
  String get colorViolet => 'Lilás';

  @override
  String get colorPaleGoldenrod => 'Amarelo claro';

  @override
  String get colorLightCoral => 'Cor-de-rosa escuro';

  @override
  String get colorKhaki => 'Amarelo claro';

  @override
  String get colorAliceBlue => 'Branco';

  @override
  String get colorHoneydew => 'Branco';

  @override
  String get colorAzure => 'Branco';

  @override
  String get colorSandyBrown => 'Cor de laranja claro';

  @override
  String get colorWheat => 'Amarelo claro';

  @override
  String get colorBeige => 'Amarelo claro';

  @override
  String get colorWhiteSmoke => 'Branco';

  @override
  String get colorMintCream => 'Branco';

  @override
  String get colorGhostWhite => 'Branco';

  @override
  String get colorSalmon => 'Cor-de-rosa escuro';

  @override
  String get colorAntiqueWhite => 'Cor de laranja claro';

  @override
  String get colorLinen => 'Cor de laranja claro';

  @override
  String get colorLightGoldenrodYellow => 'Amarelo claro';

  @override
  String get colorOldLace => 'Branco';

  @override
  String get colorRed => 'Vermelho';

  @override
  String get colorMagenta => 'Roxo';

  @override
  String get colorDeepPink => 'Cor-de-rosa';

  @override
  String get colorOrangeRed => 'Vermelho';

  @override
  String get colorTomato => 'Vermelho';

  @override
  String get colorHotPink => 'Cor-de-rosa';

  @override
  String get colorCoral => 'Vermelho';

  @override
  String get colorDarkOrange => 'Cor de laranja';

  @override
  String get colorLightSalmon => 'Cor-de-rosa escuro';

  @override
  String get colorOrange => 'Dourado';

  @override
  String get colorLightPink => 'Cor-de-rosa escuro';

  @override
  String get colorPink => 'Cor-de-rosa escuro';

  @override
  String get colorGold => 'Dourado';

  @override
  String get colorPeachPuff => 'Cor de laranja claro';

  @override
  String get colorNavajoWhite => 'Cor de laranja claro';

  @override
  String get colorMoccasin => 'Cor de laranja claro';

  @override
  String get colorBisque => 'Cor de laranja claro';

  @override
  String get colorMistyRose => 'Cor-de-rosa escuro';

  @override
  String get colorBlanchedAlmond => 'Cor de laranja claro';

  @override
  String get colorPapayaWhip => 'Cor de laranja claro';

  @override
  String get colorLavenderBlush => 'Branco';

  @override
  String get colorSeaShell => 'Branco';

  @override
  String get colorCornsilk => 'Amarelo claro';

  @override
  String get colorLemonChiffon => 'Amarelo claro';

  @override
  String get colorFloralWhite => 'Branco';

  @override
  String get colorSnow => 'Branco';

  @override
  String get colorYellow => 'Amarelo';

  @override
  String get colorLightYellow => 'Amarelo claro';

  @override
  String get colorIvory => 'Branco';

  @override
  String get colorWhite => 'Branco';
}
