import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Dutch Flemish (`nl`).
class FluentLocalizationsNl extends FluentLocalizations {
  FluentLocalizationsNl([String locale = 'nl']) : super(locale);

  @override
  String get backButtonTooltip => 'Terug';

  @override
  String get closeButtonLabel => 'Sluit';

  @override
  String get searchLabel => 'Zoeken';

  @override
  String get closeNavigationTooltip => 'Sluit navigatie';

  @override
  String get openNavigationTooltip => 'Open navigatie';

  @override
  String get clickToSearch => 'Klik om te zoeken';

  @override
  String get modalBarrierDismissLabel => 'Sluit';

  @override
  String get minimizeWindowTooltip => 'Minimaliseer';

  @override
  String get restoreWindowTooltip => 'Herstel';

  @override
  String get closeWindowTooltip => 'Sluit';

  @override
  String get dialogLabel => 'Dialoog';

  @override
  String get cutActionLabel => 'Knip';

  @override
  String get copyActionLabel => 'Kopieer';

  @override
  String get pasteActionLabel => 'Plak';

  @override
  String get selectAllActionLabel => 'Selecteer alles';

  @override
  String get newTabLabel => 'Open nieuw tabblad';

  @override
  String get closeTabLabelSuffix => 'Sluit tabblad';

  @override
  String get scrollTabBackwardLabel => 'Scrol tabbladlijst terug';

  @override
  String get scrollTabForwardLabel => 'Scrol tabbladlijst verder';

  @override
  String get noResultsFoundLabel => 'Geen resultaten gevonden';

  @override
  String get copyActionTooltip => 'Kopieer de selectie naar het klembord';

  @override
  String get cutActionTooltip =>
      'Wis de selectie en plaats deze op het klembord';

  @override
  String get pasteActionTooltip =>
      'Plaats de inhoud van het klembord op de huidige plek';

  @override
  String get selectAllActionTooltip => 'Selecteer alle inhoud';

  @override
  String get hour => 'uur';

  @override
  String get minute => 'minuut';

  @override
  String get am => 'AM';

  @override
  String get pm => 'PM';

  @override
  String get month => 'maand';

  @override
  String get day => 'dag';

  @override
  String get year => 'jaar';

  @override
  String get redLabel => 'Rood';

  @override
  String get greenLabel => 'Groen';

  @override
  String get blueLabel => 'Blauw';

  @override
  String get opacityLabel => 'Transparantie';

  @override
  String get hueLabel => 'Tint';

  @override
  String get saturationLabel => 'Verzadiging';

  @override
  String get valueLabel => 'Waarde';

  @override
  String get moreText => 'Meer';

  @override
  String get lessText => 'Minder';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return 'Waarde $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '$value% Ondoorzichtigheid';
  }

  @override
  String get colorBlack => 'Zwart';

  @override
  String get colorNavy => 'Donkerblauw';

  @override
  String get colorDarkBlue => 'Donkerblauw';

  @override
  String get colorMediumBlue => 'Blauw';

  @override
  String get colorBlue => 'Blauw';

  @override
  String get colorDarkGreen => 'Donkergroen';

  @override
  String get colorGreen => 'Donkergroen';

  @override
  String get colorTeal => 'Smaragdgroen';

  @override
  String get colorDarkCyan => 'Smaragdgroen';

  @override
  String get colorDeepSkyBlue => 'Turkoois';

  @override
  String get colorDarkTurquoise => 'Zeeblauw';

  @override
  String get colorMediumSpringGreen => 'Groen';

  @override
  String get colorLime => 'Groen';

  @override
  String get colorSpringGreen => 'Groen';

  @override
  String get colorCyan => 'Zeeblauw';

  @override
  String get colorMidnightBlue => 'Donkerblauw';

  @override
  String get colorDodgerBlue => 'Blauw';

  @override
  String get colorLightSeaGreen => 'Groenblauw';

  @override
  String get colorForestGreen => 'Donkergroen';

  @override
  String get colorSeaGreen => 'Donkergroen';

  @override
  String get colorDarkSlateGray => 'Smaragdgroen';

  @override
  String get colorLimeGreen => 'Groen';

  @override
  String get colorMediumSeaGreen => 'Groen';

  @override
  String get colorTurquoise => 'Groenblauw';

  @override
  String get colorRoyalBlue => 'Blauw';

  @override
  String get colorSteelBlue => 'Blauwgrijs';

  @override
  String get colorDarkSlateBlue => 'Paars';

  @override
  String get colorMediumTurquoise => 'Groenblauw';

  @override
  String get colorIndigo => 'Donkerpaars';

  @override
  String get colorDarkOliveGreen => 'Donkergroen';

  @override
  String get colorCadetBlue => 'Groenblauw';

  @override
  String get colorCornflowerBlue => 'Blauw';

  @override
  String get colorMediumAquamarine => 'Groen';

  @override
  String get colorDimGray => 'Grijs';

  @override
  String get colorSlateBlue => 'Indigo';

  @override
  String get colorOliveDrab => 'Donkergroen';

  @override
  String get colorSlateGray => 'Blauwgrijs';

  @override
  String get colorLightSlateGray => 'Blauwgrijs';

  @override
  String get colorMediumSlateBlue => 'Lichtblauw';

  @override
  String get colorLawnGreen => 'Groen';

  @override
  String get colorChartreuse => 'Groen';

  @override
  String get colorAquamarine => 'Lichtgroen';

  @override
  String get colorMaroon => 'Donkerrood';

  @override
  String get colorPurple => 'Donkerpaars';

  @override
  String get colorOlive => 'Donkergeel';

  @override
  String get colorGray => 'Grijs';

  @override
  String get colorSkyBlue => 'Lichtturkoois';

  @override
  String get colorLightSkyBlue => 'Lichtblauw';

  @override
  String get colorBlueViolet => 'Paars';

  @override
  String get colorDarkRed => 'Donkerrood';

  @override
  String get colorDarkMagenta => 'Donkerpaars';

  @override
  String get colorSaddleBrown => 'Bruin';

  @override
  String get colorDarkSeaGreen => 'Groen';

  @override
  String get colorLightGreen => 'Lichtgroen';

  @override
  String get colorMediumPurple => 'Lavendel';

  @override
  String get colorDarkViolet => 'Paars';

  @override
  String get colorPaleGreen => 'Lichtgroen';

  @override
  String get colorDarkOrchid => 'Paars';

  @override
  String get colorYellowGreen => 'Groen';

  @override
  String get colorSienna => 'Gebruind roze';

  @override
  String get colorBrown => 'Rood';

  @override
  String get colorDarkGray => 'Grijs';

  @override
  String get colorLightBlue => 'Hemelsblauw';

  @override
  String get colorGreenYellow => 'Groen';

  @override
  String get colorPaleTurquoise => 'Zeeblauw';

  @override
  String get colorLightSteelBlue => 'IJsblauw';

  @override
  String get colorPowderBlue => 'Hemelsblauw';

  @override
  String get colorFirebrick => 'Rood';

  @override
  String get colorDarkGoldenrod => 'Donkergeel';

  @override
  String get colorMediumOrchid => 'Paars';

  @override
  String get colorRosyBrown => 'Koraalrood';

  @override
  String get colorDarkKhaki => 'Gebruind roze';

  @override
  String get colorSilver => 'Lichtgrijs';

  @override
  String get colorMediumVioletRed => 'Roze';

  @override
  String get colorIndianRed => 'Rood';

  @override
  String get colorPeru => 'Gebruind roze';

  @override
  String get colorChocolate => 'Oranje';

  @override
  String get colorTan => 'Gebruind roze';

  @override
  String get colorLightGray => 'Lichtgrijs';

  @override
  String get colorThistle => 'Lavendel';

  @override
  String get colorOrchid => 'Lavendel';

  @override
  String get colorGoldenrod => 'Goud';

  @override
  String get colorPaleVioletRed => 'Roze';

  @override
  String get colorCrimson => 'Rood';

  @override
  String get colorGainsboro => 'Lichtgrijs';

  @override
  String get colorPlum => 'Roze';

  @override
  String get colorBurlyWood => 'Gebruind roze';

  @override
  String get colorLightCyan => 'Hemelsblauw';

  @override
  String get colorLavender => 'Lichtblauw';

  @override
  String get colorDarkSalmon => 'Roze';

  @override
  String get colorViolet => 'Lavendel';

  @override
  String get colorPaleGoldenrod => 'Lichtgeel';

  @override
  String get colorLightCoral => 'Roze';

  @override
  String get colorKhaki => 'Lichtgeel';

  @override
  String get colorAliceBlue => 'Wit';

  @override
  String get colorHoneydew => 'Wit';

  @override
  String get colorAzure => 'Wit';

  @override
  String get colorSandyBrown => 'Lichtoranje';

  @override
  String get colorWheat => 'Lichtgeel';

  @override
  String get colorBeige => 'Lichtgeel';

  @override
  String get colorWhiteSmoke => 'Wit';

  @override
  String get colorMintCream => 'Wit';

  @override
  String get colorGhostWhite => 'Wit';

  @override
  String get colorSalmon => 'Roze';

  @override
  String get colorAntiqueWhite => 'Lichtoranje';

  @override
  String get colorLinen => 'Lichtoranje';

  @override
  String get colorLightGoldenrodYellow => 'Lichtgeel';

  @override
  String get colorOldLace => 'Wit';

  @override
  String get colorRed => 'Rood';

  @override
  String get colorMagenta => 'Paars';

  @override
  String get colorDeepPink => 'Roze';

  @override
  String get colorOrangeRed => 'Rood';

  @override
  String get colorTomato => 'Rood';

  @override
  String get colorHotPink => 'Roze';

  @override
  String get colorCoral => 'Rood';

  @override
  String get colorDarkOrange => 'Oranje';

  @override
  String get colorLightSalmon => 'Roze';

  @override
  String get colorOrange => 'Goud';

  @override
  String get colorLightPink => 'Roze';

  @override
  String get colorPink => 'Roze';

  @override
  String get colorGold => 'Goud';

  @override
  String get colorPeachPuff => 'Lichtoranje';

  @override
  String get colorNavajoWhite => 'Lichtoranje';

  @override
  String get colorMoccasin => 'Lichtoranje';

  @override
  String get colorBisque => 'Lichtoranje';

  @override
  String get colorMistyRose => 'Roze';

  @override
  String get colorBlanchedAlmond => 'Lichtoranje';

  @override
  String get colorPapayaWhip => 'Lichtoranje';

  @override
  String get colorLavenderBlush => 'Wit';

  @override
  String get colorSeaShell => 'Wit';

  @override
  String get colorCornsilk => 'Lichtgeel';

  @override
  String get colorLemonChiffon => 'Lichtgeel';

  @override
  String get colorFloralWhite => 'Wit';

  @override
  String get colorSnow => 'Wit';

  @override
  String get colorYellow => 'Geel';

  @override
  String get colorLightYellow => 'Lichtgeel';

  @override
  String get colorIvory => 'Wit';

  @override
  String get colorWhite => 'Wit';
}
