import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Korean (`ko`).
class FluentLocalizationsKo extends FluentLocalizations {
  FluentLocalizationsKo([String locale = 'ko']) : super(locale);

  @override
  String get backButtonTooltip => '뒤로';

  @override
  String get closeButtonLabel => '닫기';

  @override
  String get searchLabel => '검색';

  @override
  String get closeNavigationTooltip => '네비게이션 닫기';

  @override
  String get openNavigationTooltip => '네비게이션 열기';

  @override
  String get clickToSearch => '검색';

  @override
  String get modalBarrierDismissLabel => '취소';

  @override
  String get minimizeWindowTooltip => '최소화';

  @override
  String get restoreWindowTooltip => '이전크기';

  @override
  String get closeWindowTooltip => '창닫기';

  @override
  String get dialogLabel => '대화상자';

  @override
  String get cutActionLabel => '잘라내기';

  @override
  String get copyActionLabel => '복사';

  @override
  String get pasteActionLabel => '붙여넣기';

  @override
  String get selectAllActionLabel => '전체선택';

  @override
  String get newTabLabel => '새탭';

  @override
  String get closeTabLabelSuffix => '탭닫기';

  @override
  String get scrollTabBackwardLabel => '이전탭';

  @override
  String get scrollTabForwardLabel => '다음탭';

  @override
  String get noResultsFoundLabel => '결과없음';

  @override
  String get copyActionTooltip => '클립보드로 복사';

  @override
  String get cutActionTooltip => '클립보드로 잘라내기';

  @override
  String get pasteActionTooltip => '클립보드로 붙여넣기';

  @override
  String get selectAllActionTooltip => '전체선택';

  @override
  String get hour => '시';

  @override
  String get minute => '분';

  @override
  String get am => '오전';

  @override
  String get pm => '오후';

  @override
  String get month => '월';

  @override
  String get day => '일';

  @override
  String get year => '년';

  @override
  String get redLabel => '빨강';

  @override
  String get greenLabel => '녹색';

  @override
  String get blueLabel => '파랑';

  @override
  String get opacityLabel => '불투명도';

  @override
  String get hueLabel => '색상';

  @override
  String get saturationLabel => '채도';

  @override
  String get valueLabel => '값';

  @override
  String get moreText => '자세히';

  @override
  String get lessText => '간단히';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return '값 $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '$value% 불투명도';
  }

  @override
  String get colorBlack => '검정';

  @override
  String get colorNavy => '진한 파랑';

  @override
  String get colorDarkBlue => '진한 파랑';

  @override
  String get colorMediumBlue => '파랑';

  @override
  String get colorBlue => '파랑';

  @override
  String get colorDarkGreen => '진한 녹색';

  @override
  String get colorGreen => '진한 녹색';

  @override
  String get colorTeal => '진한 청록';

  @override
  String get colorDarkCyan => '진한 청록';

  @override
  String get colorDeepSkyBlue => '옥색';

  @override
  String get colorDarkTurquoise => '바다색';

  @override
  String get colorMediumSpringGreen => '녹색';

  @override
  String get colorLime => '녹색';

  @override
  String get colorSpringGreen => '녹색';

  @override
  String get colorCyan => '바다색';

  @override
  String get colorMidnightBlue => '진한 파랑';

  @override
  String get colorDodgerBlue => '파랑';

  @override
  String get colorLightSeaGreen => '청록';

  @override
  String get colorForestGreen => '진한 녹색';

  @override
  String get colorSeaGreen => '진한 녹색';

  @override
  String get colorDarkSlateGray => '진한 청록';

  @override
  String get colorLimeGreen => '녹색';

  @override
  String get colorMediumSeaGreen => '녹색';

  @override
  String get colorTurquoise => '청록';

  @override
  String get colorRoyalBlue => '파랑';

  @override
  String get colorSteelBlue => '청회색';

  @override
  String get colorDarkSlateBlue => '자주';

  @override
  String get colorMediumTurquoise => '청록';

  @override
  String get colorIndigo => '진한 자주';

  @override
  String get colorDarkOliveGreen => '진한 녹색';

  @override
  String get colorCadetBlue => '청록';

  @override
  String get colorCornflowerBlue => '파랑';

  @override
  String get colorMediumAquamarine => '녹색';

  @override
  String get colorDimGray => '회색';

  @override
  String get colorSlateBlue => '남색';

  @override
  String get colorOliveDrab => '진한 녹색';

  @override
  String get colorSlateGray => '청회색';

  @override
  String get colorLightSlateGray => '청회색';

  @override
  String get colorMediumSlateBlue => '연한 파랑';

  @override
  String get colorLawnGreen => '녹색';

  @override
  String get colorChartreuse => '녹색';

  @override
  String get colorAquamarine => '연한 녹색';

  @override
  String get colorMaroon => '진한 빨강';

  @override
  String get colorPurple => '진한 자주';

  @override
  String get colorOlive => '진한 노랑';

  @override
  String get colorGray => '회색';

  @override
  String get colorSkyBlue => '연한 옥색';

  @override
  String get colorLightSkyBlue => '연한 파랑';

  @override
  String get colorBlueViolet => '자주';

  @override
  String get colorDarkRed => '진한 빨강';

  @override
  String get colorDarkMagenta => '진한 자주';

  @override
  String get colorSaddleBrown => '밤색';

  @override
  String get colorDarkSeaGreen => '녹색';

  @override
  String get colorLightGreen => '연한 녹색';

  @override
  String get colorMediumPurple => '연한 보라';

  @override
  String get colorDarkViolet => '자주';

  @override
  String get colorPaleGreen => '연한 녹색';

  @override
  String get colorDarkOrchid => '자주';

  @override
  String get colorYellowGreen => '녹색';

  @override
  String get colorSienna => '황갈색';

  @override
  String get colorBrown => '빨강';

  @override
  String get colorDarkGray => '회색';

  @override
  String get colorLightBlue => '하늘색';

  @override
  String get colorGreenYellow => '녹색';

  @override
  String get colorPaleTurquoise => '바다색';

  @override
  String get colorLightSteelBlue => '담청색';

  @override
  String get colorPowderBlue => '하늘색';

  @override
  String get colorFirebrick => '빨강';

  @override
  String get colorDarkGoldenrod => '진한 노랑';

  @override
  String get colorMediumOrchid => '자주';

  @override
  String get colorRosyBrown => '산호색';

  @override
  String get colorDarkKhaki => '황갈색';

  @override
  String get colorSilver => '연한 회색';

  @override
  String get colorMediumVioletRed => '분홍';

  @override
  String get colorIndianRed => '빨강';

  @override
  String get colorPeru => '황갈색';

  @override
  String get colorChocolate => '주황';

  @override
  String get colorTan => '황갈색';

  @override
  String get colorLightGray => '연한 회색';

  @override
  String get colorThistle => '연한 보라';

  @override
  String get colorOrchid => '연한 보라';

  @override
  String get colorGoldenrod => '황금색';

  @override
  String get colorPaleVioletRed => '다홍';

  @override
  String get colorCrimson => '빨강';

  @override
  String get colorGainsboro => '연한 회색';

  @override
  String get colorPlum => '분홍';

  @override
  String get colorBurlyWood => '황갈색';

  @override
  String get colorLightCyan => '하늘색';

  @override
  String get colorLavender => '연한 파랑';

  @override
  String get colorDarkSalmon => '다홍';

  @override
  String get colorViolet => '연한 보라';

  @override
  String get colorPaleGoldenrod => '연한 노랑';

  @override
  String get colorLightCoral => '다홍';

  @override
  String get colorKhaki => '연한 노랑';

  @override
  String get colorAliceBlue => '흰색';

  @override
  String get colorHoneydew => '흰색';

  @override
  String get colorAzure => '흰색';

  @override
  String get colorSandyBrown => '연한 주황';

  @override
  String get colorWheat => '연한 노랑';

  @override
  String get colorBeige => '연한 노랑';

  @override
  String get colorWhiteSmoke => '흰색';

  @override
  String get colorMintCream => '흰색';

  @override
  String get colorGhostWhite => '흰색';

  @override
  String get colorSalmon => '다홍';

  @override
  String get colorAntiqueWhite => '연한 주황';

  @override
  String get colorLinen => '연한 주황';

  @override
  String get colorLightGoldenrodYellow => '연한 노랑';

  @override
  String get colorOldLace => '흰색';

  @override
  String get colorRed => '빨강';

  @override
  String get colorMagenta => '자주';

  @override
  String get colorDeepPink => '분홍';

  @override
  String get colorOrangeRed => '빨강';

  @override
  String get colorTomato => '빨강';

  @override
  String get colorHotPink => '분홍';

  @override
  String get colorCoral => '빨강';

  @override
  String get colorDarkOrange => '주황';

  @override
  String get colorLightSalmon => '다홍';

  @override
  String get colorOrange => '황금색';

  @override
  String get colorLightPink => '다홍';

  @override
  String get colorPink => '다홍';

  @override
  String get colorGold => '황금색';

  @override
  String get colorPeachPuff => '연한 주황';

  @override
  String get colorNavajoWhite => '연한 주황';

  @override
  String get colorMoccasin => '연한 주황';

  @override
  String get colorBisque => '연한 주황';

  @override
  String get colorMistyRose => '다홍';

  @override
  String get colorBlanchedAlmond => '연한 주황';

  @override
  String get colorPapayaWhip => '연한 주황';

  @override
  String get colorLavenderBlush => '흰색';

  @override
  String get colorSeaShell => '흰색';

  @override
  String get colorCornsilk => '연한 노랑';

  @override
  String get colorLemonChiffon => '연한 노랑';

  @override
  String get colorFloralWhite => '흰색';

  @override
  String get colorSnow => '흰색';

  @override
  String get colorYellow => '노랑';

  @override
  String get colorLightYellow => '연한 노랑';

  @override
  String get colorIvory => '흰색';

  @override
  String get colorWhite => '흰색';
}
