import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Japanese (`ja`).
class FluentLocalizationsJa extends FluentLocalizations {
  FluentLocalizationsJa([String locale = 'ja']) : super(locale);

  @override
  String get backButtonTooltip => '戻る';

  @override
  String get closeButtonLabel => '閉じる';

  @override
  String get searchLabel => '検索';

  @override
  String get closeNavigationTooltip => 'メニューを閉じる';

  @override
  String get openNavigationTooltip => 'メニューを開く';

  @override
  String get clickToSearch => 'クリックして検索';

  @override
  String get modalBarrierDismissLabel => '閉じる';

  @override
  String get minimizeWindowTooltip => '最小化';

  @override
  String get restoreWindowTooltip => '元に戻す';

  @override
  String get closeWindowTooltip => '閉じる';

  @override
  String get dialogLabel => 'ダイアログ';

  @override
  String get cutActionLabel => '切り取り';

  @override
  String get copyActionLabel => 'コピー';

  @override
  String get pasteActionLabel => '貼り付け';

  @override
  String get selectAllActionLabel => '全て選択';

  @override
  String get newTabLabel => '新しいタブを追加';

  @override
  String get closeTabLabelSuffix => 'タブを閉じる';

  @override
  String get scrollTabBackwardLabel => '前のタブへ';

  @override
  String get scrollTabForwardLabel => '次のタブへ';

  @override
  String get noResultsFoundLabel => '検索結果はありません';

  @override
  String get copyActionTooltip => '選択した内容をクリップボードにコピー';

  @override
  String get cutActionTooltip => '選択した内容を切り取ってクリップボードに追加';

  @override
  String get pasteActionTooltip => 'クリップボードの内容をここに貼り付け';

  @override
  String get selectAllActionTooltip => '全て選択';

  @override
  String get hour => '時';

  @override
  String get minute => '分';

  @override
  String get am => '午前';

  @override
  String get pm => '午後';

  @override
  String get month => '月';

  @override
  String get day => '日';

  @override
  String get year => '年';

  @override
  String get redLabel => '赤';

  @override
  String get greenLabel => '緑';

  @override
  String get blueLabel => '青';

  @override
  String get opacityLabel => '不透明度';

  @override
  String get hueLabel => '色合い';

  @override
  String get saturationLabel => '彩度';

  @override
  String get valueLabel => '値';

  @override
  String get moreText => 'さらに表示';

  @override
  String get lessText => '表示を減らす';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return '値 $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '$value% 不透明度';
  }

  @override
  String get colorBlack => '黒';

  @override
  String get colorNavy => '濃い青';

  @override
  String get colorDarkBlue => '濃い青';

  @override
  String get colorMediumBlue => '青';

  @override
  String get colorBlue => '青';

  @override
  String get colorDarkGreen => '濃い緑';

  @override
  String get colorGreen => '濃い緑';

  @override
  String get colorTeal => '濃い青緑';

  @override
  String get colorDarkCyan => '濃い青緑';

  @override
  String get colorDeepSkyBlue => 'ターコイズ';

  @override
  String get colorDarkTurquoise => '水色';

  @override
  String get colorMediumSpringGreen => '緑';

  @override
  String get colorLime => '緑';

  @override
  String get colorSpringGreen => '緑';

  @override
  String get colorCyan => '水色';

  @override
  String get colorMidnightBlue => '濃い青';

  @override
  String get colorDodgerBlue => '青';

  @override
  String get colorLightSeaGreen => '青緑';

  @override
  String get colorForestGreen => '濃い緑';

  @override
  String get colorSeaGreen => '濃い緑';

  @override
  String get colorDarkSlateGray => '濃い青緑';

  @override
  String get colorLimeGreen => '緑';

  @override
  String get colorMediumSeaGreen => '緑';

  @override
  String get colorTurquoise => '青緑';

  @override
  String get colorRoyalBlue => '青';

  @override
  String get colorSteelBlue => 'ブルーグレー';

  @override
  String get colorDarkSlateBlue => '紫';

  @override
  String get colorMediumTurquoise => '青緑';

  @override
  String get colorIndigo => '濃い紫';

  @override
  String get colorDarkOliveGreen => '濃い緑';

  @override
  String get colorCadetBlue => '青緑';

  @override
  String get colorCornflowerBlue => '青';

  @override
  String get colorMediumAquamarine => '緑';

  @override
  String get colorDimGray => '灰色';

  @override
  String get colorSlateBlue => 'インディゴ';

  @override
  String get colorOliveDrab => '濃い緑';

  @override
  String get colorSlateGray => 'ブルーグレー';

  @override
  String get colorLightSlateGray => 'ブルーグレー';

  @override
  String get colorMediumSlateBlue => '薄い青';

  @override
  String get colorLawnGreen => '緑';

  @override
  String get colorChartreuse => '緑';

  @override
  String get colorAquamarine => '薄い緑';

  @override
  String get colorMaroon => '濃い赤';

  @override
  String get colorPurple => '濃い紫';

  @override
  String get colorOlive => '濃い黄色';

  @override
  String get colorGray => '灰色';

  @override
  String get colorSkyBlue => '薄いターコイズ';

  @override
  String get colorLightSkyBlue => '薄い青';

  @override
  String get colorBlueViolet => '紫';

  @override
  String get colorDarkRed => '濃い赤';

  @override
  String get colorDarkMagenta => '濃い紫';

  @override
  String get colorSaddleBrown => '茶';

  @override
  String get colorDarkSeaGreen => '緑';

  @override
  String get colorLightGreen => '薄い緑';

  @override
  String get colorMediumPurple => 'ラベンダー';

  @override
  String get colorDarkViolet => '紫';

  @override
  String get colorPaleGreen => '薄い緑';

  @override
  String get colorDarkOrchid => '紫';

  @override
  String get colorYellowGreen => '緑';

  @override
  String get colorSienna => 'タン';

  @override
  String get colorBrown => '赤';

  @override
  String get colorDarkGray => '灰色';

  @override
  String get colorLightBlue => 'スカイブルー';

  @override
  String get colorGreenYellow => '緑';

  @override
  String get colorPaleTurquoise => '水色';

  @override
  String get colorLightSteelBlue => 'アイスブルー';

  @override
  String get colorPowderBlue => 'スカイブルー';

  @override
  String get colorFirebrick => '赤';

  @override
  String get colorDarkGoldenrod => '濃い黄色';

  @override
  String get colorMediumOrchid => '紫';

  @override
  String get colorRosyBrown => 'さんご';

  @override
  String get colorDarkKhaki => 'タン';

  @override
  String get colorSilver => '淡い灰色';

  @override
  String get colorMediumVioletRed => 'ピンク';

  @override
  String get colorIndianRed => '赤';

  @override
  String get colorPeru => 'タン';

  @override
  String get colorChocolate => 'オレンジ';

  @override
  String get colorTan => 'タン';

  @override
  String get colorLightGray => '淡い灰色';

  @override
  String get colorThistle => 'ラベンダー';

  @override
  String get colorOrchid => 'ラベンダー';

  @override
  String get colorGoldenrod => '金色';

  @override
  String get colorPaleVioletRed => 'ローズ';

  @override
  String get colorCrimson => '赤';

  @override
  String get colorGainsboro => '淡い灰色';

  @override
  String get colorPlum => 'ピンク';

  @override
  String get colorBurlyWood => 'タン';

  @override
  String get colorLightCyan => 'スカイブルー';

  @override
  String get colorLavender => '薄い青';

  @override
  String get colorDarkSalmon => 'ローズ';

  @override
  String get colorViolet => 'ラベンダー';

  @override
  String get colorPaleGoldenrod => '薄い黄';

  @override
  String get colorLightCoral => 'ローズ';

  @override
  String get colorKhaki => '薄い黄';

  @override
  String get colorAliceBlue => '白';

  @override
  String get colorHoneydew => '白';

  @override
  String get colorAzure => '白';

  @override
  String get colorSandyBrown => '薄いオレンジ';

  @override
  String get colorWheat => '薄い黄';

  @override
  String get colorBeige => '薄い黄';

  @override
  String get colorWhiteSmoke => '白';

  @override
  String get colorMintCream => '白';

  @override
  String get colorGhostWhite => '白';

  @override
  String get colorSalmon => 'ローズ';

  @override
  String get colorAntiqueWhite => '薄いオレンジ';

  @override
  String get colorLinen => '薄いオレンジ';

  @override
  String get colorLightGoldenrodYellow => '薄い黄';

  @override
  String get colorOldLace => '白';

  @override
  String get colorRed => '赤';

  @override
  String get colorMagenta => '紫';

  @override
  String get colorDeepPink => 'ピンク';

  @override
  String get colorOrangeRed => '赤';

  @override
  String get colorTomato => '赤';

  @override
  String get colorHotPink => 'ピンク';

  @override
  String get colorCoral => '赤';

  @override
  String get colorDarkOrange => 'オレンジ';

  @override
  String get colorLightSalmon => 'ローズ';

  @override
  String get colorOrange => '金色';

  @override
  String get colorLightPink => 'ローズ';

  @override
  String get colorPink => 'ローズ';

  @override
  String get colorGold => '金色';

  @override
  String get colorPeachPuff => '薄いオレンジ';

  @override
  String get colorNavajoWhite => '薄いオレンジ';

  @override
  String get colorMoccasin => '薄いオレンジ';

  @override
  String get colorBisque => '薄いオレンジ';

  @override
  String get colorMistyRose => 'ローズ';

  @override
  String get colorBlanchedAlmond => '薄いオレンジ';

  @override
  String get colorPapayaWhip => '薄いオレンジ';

  @override
  String get colorLavenderBlush => '白';

  @override
  String get colorSeaShell => '白';

  @override
  String get colorCornsilk => '薄い黄';

  @override
  String get colorLemonChiffon => '薄い黄';

  @override
  String get colorFloralWhite => '白';

  @override
  String get colorSnow => '白';

  @override
  String get colorYellow => '黄';

  @override
  String get colorLightYellow => '薄い黄';

  @override
  String get colorIvory => '白';

  @override
  String get colorWhite => '白';
}
