import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Hungarian (`hu`).
class FluentLocalizationsHu extends FluentLocalizations {
  FluentLocalizationsHu([String locale = 'hu']) : super(locale);

  @override
  String get backButtonTooltip => 'Vissza';

  @override
  String get closeButtonLabel => 'Bezárás';

  @override
  String get searchLabel => 'Keresés';

  @override
  String get closeNavigationTooltip => 'Menü bezárása';

  @override
  String get openNavigationTooltip => 'Menü kinyitása';

  @override
  String get clickToSearch => 'Kattints a kereséshez';

  @override
  String get modalBarrierDismissLabel => 'Ablak elvetése';

  @override
  String get minimizeWindowTooltip => 'Tálcára';

  @override
  String get restoreWindowTooltip => 'Teljes képernyő';

  @override
  String get closeWindowTooltip => 'Bezárás';

  @override
  String get dialogLabel => 'Ablak';

  @override
  String get cutActionLabel => 'Kivágás';

  @override
  String get copyActionLabel => 'Másolás';

  @override
  String get pasteActionLabel => 'Beillesztés';

  @override
  String get selectAllActionLabel => 'Mind kijelölése';

  @override
  String get newTabLabel => 'Lap hozzáadása';

  @override
  String get closeTabLabelSuffix => 'Lap bezárása';

  @override
  String get scrollTabBackwardLabel => 'Görgetés vissza';

  @override
  String get scrollTabForwardLabel => 'Görgetés előre';

  @override
  String get noResultsFoundLabel => 'Nincs találat';

  @override
  String get copyActionTooltip => 'Kijelölt tartalom másolása a vágólapra';

  @override
  String get cutActionTooltip =>
      'Kijelölt tartalom kivágása és vágólapra helyezése';

  @override
  String get pasteActionTooltip => 'Vágólap tartalmának beillesztése ide';

  @override
  String get selectAllActionTooltip => 'Teljes tartalom kijelölése';

  @override
  String get hour => 'óra';

  @override
  String get minute => 'perc';

  @override
  String get am => 'de.';

  @override
  String get pm => 'du.';

  @override
  String get month => 'hónap';

  @override
  String get day => 'nap';

  @override
  String get year => 'év';

  @override
  String get redLabel => 'Vörös';

  @override
  String get greenLabel => 'Zöld';

  @override
  String get blueLabel => 'Kék';

  @override
  String get opacityLabel => 'Átlátszóság';

  @override
  String get hueLabel => 'Árnyalat';

  @override
  String get saturationLabel => 'Telítettség';

  @override
  String get valueLabel => 'Érték';

  @override
  String get moreText => 'Több';

  @override
  String get lessText => 'Kevesebb';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return 'Érték $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '$value% Átlátszatlanság';
  }

  @override
  String get colorBlack => 'Fekete';

  @override
  String get colorNavy => 'Sötétkék';

  @override
  String get colorDarkBlue => 'Sötétkék';

  @override
  String get colorMediumBlue => 'Kék';

  @override
  String get colorBlue => 'Kék';

  @override
  String get colorDarkGreen => 'Sötétzöld';

  @override
  String get colorGreen => 'Sötétzöld';

  @override
  String get colorTeal => 'Sötét pávakék';

  @override
  String get colorDarkCyan => 'Sötét pávakék';

  @override
  String get colorDeepSkyBlue => 'Türkizkék';

  @override
  String get colorDarkTurquoise => 'Tengerkék';

  @override
  String get colorMediumSpringGreen => 'Zöld';

  @override
  String get colorLime => 'Zöld';

  @override
  String get colorSpringGreen => 'Zöld';

  @override
  String get colorCyan => 'Tengerkék';

  @override
  String get colorMidnightBlue => 'Sötétkék';

  @override
  String get colorDodgerBlue => 'Kék';

  @override
  String get colorLightSeaGreen => 'Kékeszöld';

  @override
  String get colorForestGreen => 'Sötétzöld';

  @override
  String get colorSeaGreen => 'Sötétzöld';

  @override
  String get colorDarkSlateGray => 'Sötét pávakék';

  @override
  String get colorLimeGreen => 'Zöld';

  @override
  String get colorMediumSeaGreen => 'Zöld';

  @override
  String get colorTurquoise => 'Kékeszöld';

  @override
  String get colorRoyalBlue => 'Kék';

  @override
  String get colorSteelBlue => 'Kékesszürke';

  @override
  String get colorDarkSlateBlue => 'Mélybíbor';

  @override
  String get colorMediumTurquoise => 'Kékeszöld';

  @override
  String get colorIndigo => 'Sötétlila';

  @override
  String get colorDarkOliveGreen => 'Sötétzöld';

  @override
  String get colorCadetBlue => 'Kékeszöld';

  @override
  String get colorCornflowerBlue => 'Kék';

  @override
  String get colorMediumAquamarine => 'Zöld';

  @override
  String get colorDimGray => 'Szürke';

  @override
  String get colorSlateBlue => 'Indigókék';

  @override
  String get colorOliveDrab => 'Sötétzöld';

  @override
  String get colorSlateGray => 'Kékesszürke';

  @override
  String get colorLightSlateGray => 'Kékesszürke';

  @override
  String get colorMediumSlateBlue => 'Világoskék';

  @override
  String get colorLawnGreen => 'Zöld';

  @override
  String get colorChartreuse => 'Zöld';

  @override
  String get colorAquamarine => 'Világoszöld';

  @override
  String get colorMaroon => 'Sötétvörös';

  @override
  String get colorPurple => 'Sötétlila';

  @override
  String get colorOlive => 'Sötétsárga';

  @override
  String get colorGray => 'Szürke';

  @override
  String get colorSkyBlue => 'Világostürkiz';

  @override
  String get colorLightSkyBlue => 'Világoskék';

  @override
  String get colorBlueViolet => 'Mélybíbor';

  @override
  String get colorDarkRed => 'Sötétvörös';

  @override
  String get colorDarkMagenta => 'Sötétlila';

  @override
  String get colorSaddleBrown => 'Barna';

  @override
  String get colorDarkSeaGreen => 'Zöld';

  @override
  String get colorLightGreen => 'Világoszöld';

  @override
  String get colorMediumPurple => 'Levendula';

  @override
  String get colorDarkViolet => 'Mélybíbor';

  @override
  String get colorPaleGreen => 'Világoszöld';

  @override
  String get colorDarkOrchid => 'Mélybíbor';

  @override
  String get colorYellowGreen => 'Zöld';

  @override
  String get colorSienna => 'Sárgásbarna';

  @override
  String get colorBrown => 'Piros';

  @override
  String get colorDarkGray => 'Szürke';

  @override
  String get colorLightBlue => 'Égkék';

  @override
  String get colorGreenYellow => 'Zöld';

  @override
  String get colorPaleTurquoise => 'Tengerkék';

  @override
  String get colorLightSteelBlue => 'Jégkék';

  @override
  String get colorPowderBlue => 'Égkék';

  @override
  String get colorFirebrick => 'Piros';

  @override
  String get colorDarkGoldenrod => 'Sötétsárga';

  @override
  String get colorMediumOrchid => 'Mélybíbor';

  @override
  String get colorRosyBrown => 'Korall';

  @override
  String get colorDarkKhaki => 'Sárgásbarna';

  @override
  String get colorSilver => 'Világosszürke';

  @override
  String get colorMediumVioletRed => 'Rózsaszín';

  @override
  String get colorIndianRed => 'Piros';

  @override
  String get colorPeru => 'Sárgásbarna';

  @override
  String get colorChocolate => 'Narancssárga';

  @override
  String get colorTan => 'Sárgásbarna';

  @override
  String get colorLightGray => 'Világosszürke';

  @override
  String get colorThistle => 'Levendula';

  @override
  String get colorOrchid => 'Levendula';

  @override
  String get colorGoldenrod => 'Arany';

  @override
  String get colorPaleVioletRed => 'Rózsa';

  @override
  String get colorCrimson => 'Piros';

  @override
  String get colorGainsboro => 'Világosszürke';

  @override
  String get colorPlum => 'Rózsaszín';

  @override
  String get colorBurlyWood => 'Sárgásbarna';

  @override
  String get colorLightCyan => 'Égkék';

  @override
  String get colorLavender => 'Világoskék';

  @override
  String get colorDarkSalmon => 'Rózsa';

  @override
  String get colorViolet => 'Levendula';

  @override
  String get colorPaleGoldenrod => 'Világossárga';

  @override
  String get colorLightCoral => 'Rózsa';

  @override
  String get colorKhaki => 'Világossárga';

  @override
  String get colorAliceBlue => 'Fehér';

  @override
  String get colorHoneydew => 'Fehér';

  @override
  String get colorAzure => 'Fehér';

  @override
  String get colorSandyBrown => 'Világosnarancs';

  @override
  String get colorWheat => 'Világossárga';

  @override
  String get colorBeige => 'Világossárga';

  @override
  String get colorWhiteSmoke => 'Fehér';

  @override
  String get colorMintCream => 'Fehér';

  @override
  String get colorGhostWhite => 'Fehér';

  @override
  String get colorSalmon => 'Rózsa';

  @override
  String get colorAntiqueWhite => 'Világosnarancs';

  @override
  String get colorLinen => 'Világosnarancs';

  @override
  String get colorLightGoldenrodYellow => 'Világossárga';

  @override
  String get colorOldLace => 'Fehér';

  @override
  String get colorRed => 'Piros';

  @override
  String get colorMagenta => 'Mélybíbor';

  @override
  String get colorDeepPink => 'Rózsaszín';

  @override
  String get colorOrangeRed => 'Piros';

  @override
  String get colorTomato => 'Piros';

  @override
  String get colorHotPink => 'Rózsaszín';

  @override
  String get colorCoral => 'Piros';

  @override
  String get colorDarkOrange => 'Narancssárga';

  @override
  String get colorLightSalmon => 'Rózsa';

  @override
  String get colorOrange => 'Arany';

  @override
  String get colorLightPink => 'Rózsa';

  @override
  String get colorPink => 'Rózsa';

  @override
  String get colorGold => 'Arany';

  @override
  String get colorPeachPuff => 'Világosnarancs';

  @override
  String get colorNavajoWhite => 'Világosnarancs';

  @override
  String get colorMoccasin => 'Világosnarancs';

  @override
  String get colorBisque => 'Világosnarancs';

  @override
  String get colorMistyRose => 'Rózsa';

  @override
  String get colorBlanchedAlmond => 'Világosnarancs';

  @override
  String get colorPapayaWhip => 'Világosnarancs';

  @override
  String get colorLavenderBlush => 'Fehér';

  @override
  String get colorSeaShell => 'Fehér';

  @override
  String get colorCornsilk => 'Világossárga';

  @override
  String get colorLemonChiffon => 'Világossárga';

  @override
  String get colorFloralWhite => 'Fehér';

  @override
  String get colorSnow => 'Fehér';

  @override
  String get colorYellow => 'Sárga';

  @override
  String get colorLightYellow => 'Világossárga';

  @override
  String get colorIvory => 'Fehér';

  @override
  String get colorWhite => 'Fehér';
}
