import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Hindi (`hi`).
class FluentLocalizationsHi extends FluentLocalizations {
  FluentLocalizationsHi([String locale = 'hi']) : super(locale);

  @override
  String get backButtonTooltip => 'वापस';

  @override
  String get closeButtonLabel => 'बंद करें';

  @override
  String get searchLabel => 'खोजें';

  @override
  String get closeNavigationTooltip => 'नेविगेशन बंद करें';

  @override
  String get openNavigationTooltip => 'नेविगेशन खोलें';

  @override
  String get clickToSearch => 'खोजने के लिए क्लिक करें';

  @override
  String get modalBarrierDismissLabel => 'हटाएँ';

  @override
  String get minimizeWindowTooltip => 'मिनीमाइज करें';

  @override
  String get restoreWindowTooltip => 'वापिस लाएं';

  @override
  String get closeWindowTooltip => 'बंद करें';

  @override
  String get dialogLabel => 'डायलॉग';

  @override
  String get cutActionLabel => 'कट';

  @override
  String get copyActionLabel => 'कॉपी';

  @override
  String get pasteActionLabel => 'पेस्ट';

  @override
  String get selectAllActionLabel => 'सब-कुछ सेलेक्ट करें';

  @override
  String get newTabLabel => 'नया टैब ऐड करें';

  @override
  String get closeTabLabelSuffix => 'टैब बंद करें';

  @override
  String get scrollTabBackwardLabel => 'टैब लिस्ट पीछे स्क्रॉल करें';

  @override
  String get scrollTabForwardLabel => 'टैब लिस्ट आगे स्क्रॉल करें';

  @override
  String get noResultsFoundLabel => 'कोई रिजल्ट नहीं मिला';

  @override
  String get copyActionTooltip => 'सेलेक्टेड कंटेंट क्लिपबोर्ड पर कॉपी करें';

  @override
  String get cutActionTooltip =>
      'सिलेक्टेड कंटेंट यहाँ से हटा कर क्लिपबोर्ड पर कॉपी करें';

  @override
  String get pasteActionTooltip =>
      'क्लिपबोर्ड का कंटेंट इस लोकेशन पर पेस्ट करें';

  @override
  String get selectAllActionTooltip => 'सारा कंटेंट सेलेक्ट करें';

  @override
  String get hour => 'घंटा';

  @override
  String get minute => 'मिनट';

  @override
  String get am => 'AM';

  @override
  String get pm => 'PM';

  @override
  String get month => 'महीना';

  @override
  String get day => 'दिन';

  @override
  String get year => 'साल';

  @override
  String get redLabel => 'लाल';

  @override
  String get greenLabel => 'हरा';

  @override
  String get blueLabel => 'नीला';

  @override
  String get opacityLabel => 'पारदर्शिता';

  @override
  String get hueLabel => 'रंग';

  @override
  String get saturationLabel => 'संतृप्ति';

  @override
  String get valueLabel => 'मान';

  @override
  String get moreText => 'अधिक';

  @override
  String get lessText => 'कम';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return 'मान $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '$value% अपारदर्शिता';
  }

  @override
  String get colorBlack => 'काला';

  @override
  String get colorNavy => 'गहरा नीला';

  @override
  String get colorDarkBlue => 'गहरा नीला';

  @override
  String get colorMediumBlue => 'नीला';

  @override
  String get colorBlue => 'नीला';

  @override
  String get colorDarkGreen => 'गहरा हरा';

  @override
  String get colorGreen => 'गहरा हरा';

  @override
  String get colorTeal => 'गहरा हरा-नीला';

  @override
  String get colorDarkCyan => 'गहरा हरा-नीला';

  @override
  String get colorDeepSkyBlue => 'फ़िरोज़ी';

  @override
  String get colorDarkTurquoise => 'पनीला';

  @override
  String get colorMediumSpringGreen => 'हरा';

  @override
  String get colorLime => 'हरा';

  @override
  String get colorSpringGreen => 'हरा';

  @override
  String get colorCyan => 'पनीला';

  @override
  String get colorMidnightBlue => 'गहरा नीला';

  @override
  String get colorDodgerBlue => 'नीला';

  @override
  String get colorLightSeaGreen => 'हरा-नीला';

  @override
  String get colorForestGreen => 'गहरा हरा';

  @override
  String get colorSeaGreen => 'गहरा हरा';

  @override
  String get colorDarkSlateGray => 'गहरा हरा-नीला';

  @override
  String get colorLimeGreen => 'हरा';

  @override
  String get colorMediumSeaGreen => 'हरा';

  @override
  String get colorTurquoise => 'हरा-नीला';

  @override
  String get colorRoyalBlue => 'नीला';

  @override
  String get colorSteelBlue => 'नीला-सलेटी';

  @override
  String get colorDarkSlateBlue => 'बैंगनी';

  @override
  String get colorMediumTurquoise => 'हरा-नीला';

  @override
  String get colorIndigo => 'गहरा बैंगनी';

  @override
  String get colorDarkOliveGreen => 'गहरा हरा';

  @override
  String get colorCadetBlue => 'हरा-नीला';

  @override
  String get colorCornflowerBlue => 'नीला';

  @override
  String get colorMediumAquamarine => 'हरा';

  @override
  String get colorDimGray => 'सलेटी';

  @override
  String get colorSlateBlue => 'जामुनी';

  @override
  String get colorOliveDrab => 'गहरा हरा';

  @override
  String get colorSlateGray => 'नीला-सलेटी';

  @override
  String get colorLightSlateGray => 'नीला-सलेटी';

  @override
  String get colorMediumSlateBlue => 'हल्का नीला';

  @override
  String get colorLawnGreen => 'हरा';

  @override
  String get colorChartreuse => 'हरा';

  @override
  String get colorAquamarine => 'हल्का हरा';

  @override
  String get colorMaroon => 'गहरा लाल';

  @override
  String get colorPurple => 'गहरा बैंगनी';

  @override
  String get colorOlive => 'गहरा पीला';

  @override
  String get colorGray => 'सलेटी';

  @override
  String get colorSkyBlue => 'हल्का फ़िरोज़ी';

  @override
  String get colorLightSkyBlue => 'हल्का नीला';

  @override
  String get colorBlueViolet => 'बैंगनी';

  @override
  String get colorDarkRed => 'गहरा लाल';

  @override
  String get colorDarkMagenta => 'गहरा बैंगनी';

  @override
  String get colorSaddleBrown => 'भूरा';

  @override
  String get colorDarkSeaGreen => 'हरा';

  @override
  String get colorLightGreen => 'हल्का हरा';

  @override
  String get colorMediumPurple => 'लैवेंडर';

  @override
  String get colorDarkViolet => 'बैंगनी';

  @override
  String get colorPaleGreen => 'हल्का हरा';

  @override
  String get colorDarkOrchid => 'बैंगनी';

  @override
  String get colorYellowGreen => 'हरा';

  @override
  String get colorSienna => 'टैन';

  @override
  String get colorBrown => 'लाल';

  @override
  String get colorDarkGray => 'सलेटी';

  @override
  String get colorLightBlue => 'आसमानी';

  @override
  String get colorGreenYellow => 'हरा';

  @override
  String get colorPaleTurquoise => 'पनीला';

  @override
  String get colorLightSteelBlue => 'बर्फ़ानी नीला';

  @override
  String get colorPowderBlue => 'आसमानी';

  @override
  String get colorFirebrick => 'लाल';

  @override
  String get colorDarkGoldenrod => 'गहरा पीला';

  @override
  String get colorMediumOrchid => 'बैंगनी';

  @override
  String get colorRosyBrown => 'कोरल';

  @override
  String get colorDarkKhaki => 'टैन';

  @override
  String get colorSilver => 'हल्का सलेटी';

  @override
  String get colorMediumVioletRed => 'गुलाबी';

  @override
  String get colorIndianRed => 'लाल';

  @override
  String get colorPeru => 'टैन';

  @override
  String get colorChocolate => 'नारंगी';

  @override
  String get colorTan => 'टैन';

  @override
  String get colorLightGray => 'हल्का सलेटी';

  @override
  String get colorThistle => 'लैवेंडर';

  @override
  String get colorOrchid => 'लैवेंडर';

  @override
  String get colorGoldenrod => 'सुनहरा';

  @override
  String get colorPaleVioletRed => 'गुलाब का रंग';

  @override
  String get colorCrimson => 'लाल';

  @override
  String get colorGainsboro => 'हल्का सलेटी';

  @override
  String get colorPlum => 'गुलाबी';

  @override
  String get colorBurlyWood => 'टैन';

  @override
  String get colorLightCyan => 'आसमानी';

  @override
  String get colorLavender => 'हल्का नीला';

  @override
  String get colorDarkSalmon => 'गुलाब का रंग';

  @override
  String get colorViolet => 'लैवेंडर';

  @override
  String get colorPaleGoldenrod => 'हल्का पीला';

  @override
  String get colorLightCoral => 'गुलाब का रंग';

  @override
  String get colorKhaki => 'हल्का पीला';

  @override
  String get colorAliceBlue => 'सफ़ेद';

  @override
  String get colorHoneydew => 'सफ़ेद';

  @override
  String get colorAzure => 'सफ़ेद';

  @override
  String get colorSandyBrown => 'हल्का नारंगी';

  @override
  String get colorWheat => 'हल्का पीला';

  @override
  String get colorBeige => 'हल्का पीला';

  @override
  String get colorWhiteSmoke => 'सफ़ेद';

  @override
  String get colorMintCream => 'सफ़ेद';

  @override
  String get colorGhostWhite => 'सफ़ेद';

  @override
  String get colorSalmon => 'गुलाब का रंग';

  @override
  String get colorAntiqueWhite => 'हल्का नारंगी';

  @override
  String get colorLinen => 'हल्का नारंगी';

  @override
  String get colorLightGoldenrodYellow => 'हल्का पीला';

  @override
  String get colorOldLace => 'सफ़ेद';

  @override
  String get colorRed => 'लाल';

  @override
  String get colorMagenta => 'बैंगनी';

  @override
  String get colorDeepPink => 'गुलाबी';

  @override
  String get colorOrangeRed => 'लाल';

  @override
  String get colorTomato => 'लाल';

  @override
  String get colorHotPink => 'गुलाबी';

  @override
  String get colorCoral => 'लाल';

  @override
  String get colorDarkOrange => 'नारंगी';

  @override
  String get colorLightSalmon => 'गुलाब का रंग';

  @override
  String get colorOrange => 'सुनहरा';

  @override
  String get colorLightPink => 'गुलाब का रंग';

  @override
  String get colorPink => 'गुलाब का रंग';

  @override
  String get colorGold => 'सुनहरा';

  @override
  String get colorPeachPuff => 'हल्का नारंगी';

  @override
  String get colorNavajoWhite => 'हल्का नारंगी';

  @override
  String get colorMoccasin => 'हल्का नारंगी';

  @override
  String get colorBisque => 'हल्का नारंगी';

  @override
  String get colorMistyRose => 'गुलाब का रंग';

  @override
  String get colorBlanchedAlmond => 'हल्का नारंगी';

  @override
  String get colorPapayaWhip => 'हल्का नारंगी';

  @override
  String get colorLavenderBlush => 'सफ़ेद';

  @override
  String get colorSeaShell => 'सफ़ेद';

  @override
  String get colorCornsilk => 'हल्का पीला';

  @override
  String get colorLemonChiffon => 'हल्का पीला';

  @override
  String get colorFloralWhite => 'सफ़ेद';

  @override
  String get colorSnow => 'सफ़ेद';

  @override
  String get colorYellow => 'पीला';

  @override
  String get colorLightYellow => 'हल्का पीला';

  @override
  String get colorIvory => 'सफ़ेद';

  @override
  String get colorWhite => 'सफ़ेद';
}
