import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Hebrew (`he`).
class FluentLocalizationsHe extends FluentLocalizations {
  FluentLocalizationsHe([String locale = 'he']) : super(locale);

  @override
  String get backButtonTooltip => 'הקודם';

  @override
  String get closeButtonLabel => 'סגור';

  @override
  String get searchLabel => 'חיפוש';

  @override
  String get closeNavigationTooltip => 'סגור ניווט';

  @override
  String get openNavigationTooltip => 'פתח ניווט';

  @override
  String get clickToSearch => 'חיפוש';

  @override
  String get modalBarrierDismissLabel => 'הסתר';

  @override
  String get minimizeWindowTooltip => 'מזער';

  @override
  String get restoreWindowTooltip => 'שחזור';

  @override
  String get closeWindowTooltip => 'סגור';

  @override
  String get dialogLabel => 'דיאלוג';

  @override
  String get cutActionLabel => 'גזור';

  @override
  String get copyActionLabel => 'העתק';

  @override
  String get pasteActionLabel => 'הדבק';

  @override
  String get selectAllActionLabel => 'בחר הכל';

  @override
  String get newTabLabel => 'כרטיסייה חדשה';

  @override
  String get closeTabLabelSuffix => 'סגור כרטיסייה';

  @override
  String get scrollTabBackwardLabel => 'גלול רשימת כרטיסיות אחורה';

  @override
  String get scrollTabForwardLabel => 'גלול רשימת כרטיסיות קדימה';

  @override
  String get noResultsFoundLabel => 'לא נמצאו תוצאות';

  @override
  String get copyActionTooltip => 'העתק את התוכן שנבחר';

  @override
  String get cutActionTooltip => 'גזור את התוכן שנבחר';

  @override
  String get pasteActionTooltip => 'הדבק את התוכן שנבחר למיקום הנוכחי';

  @override
  String get selectAllActionTooltip => 'בחר הכל';

  @override
  String get hour => 'שעה';

  @override
  String get minute => 'דקה';

  @override
  String get am => 'AM';

  @override
  String get pm => 'PM';

  @override
  String get month => 'חודש';

  @override
  String get day => 'יום';

  @override
  String get year => 'שנה';

  @override
  String get redLabel => 'אדום';

  @override
  String get greenLabel => 'ירוק';

  @override
  String get blueLabel => 'כחול';

  @override
  String get opacityLabel => 'שקיפות';

  @override
  String get hueLabel => 'גוון';

  @override
  String get saturationLabel => 'רוויה';

  @override
  String get valueLabel => 'ערך';

  @override
  String get moreText => 'עוד';

  @override
  String get lessText => 'פחות';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return '($colorName) $value ערך';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '%$value אטימות';
  }

  @override
  String get colorBlack => 'שחור';

  @override
  String get colorNavy => 'כחול כהה';

  @override
  String get colorDarkBlue => 'כחול כהה';

  @override
  String get colorMediumBlue => 'כחול';

  @override
  String get colorBlue => 'כחול';

  @override
  String get colorDarkGreen => 'ירוק כהה';

  @override
  String get colorGreen => 'ירוק כהה';

  @override
  String get colorTeal => 'כחול-ירקרק כהה';

  @override
  String get colorDarkCyan => 'כחול-ירקרק כהה';

  @override
  String get colorDeepSkyBlue => 'טורקיז';

  @override
  String get colorDarkTurquoise => 'תכלת';

  @override
  String get colorMediumSpringGreen => 'ירוק';

  @override
  String get colorLime => 'ירוק';

  @override
  String get colorSpringGreen => 'ירוק';

  @override
  String get colorCyan => 'תכלת';

  @override
  String get colorMidnightBlue => 'כחול כהה';

  @override
  String get colorDodgerBlue => 'כחול';

  @override
  String get colorLightSeaGreen => 'כחול-ירקרק';

  @override
  String get colorForestGreen => 'ירוק כהה';

  @override
  String get colorSeaGreen => 'ירוק כהה';

  @override
  String get colorDarkSlateGray => 'כחול-ירקרק כהה';

  @override
  String get colorLimeGreen => 'ירוק';

  @override
  String get colorMediumSeaGreen => 'ירוק';

  @override
  String get colorTurquoise => 'כחול-ירקרק';

  @override
  String get colorRoyalBlue => 'כחול';

  @override
  String get colorSteelBlue => 'כחול-אפור';

  @override
  String get colorDarkSlateBlue => 'סגול';

  @override
  String get colorMediumTurquoise => 'כחול-ירקרק';

  @override
  String get colorIndigo => 'סגול כהה';

  @override
  String get colorDarkOliveGreen => 'ירוק כהה';

  @override
  String get colorCadetBlue => 'כחול-ירקרק';

  @override
  String get colorCornflowerBlue => 'כחול';

  @override
  String get colorMediumAquamarine => 'ירוק';

  @override
  String get colorDimGray => 'אפור';

  @override
  String get colorSlateBlue => 'סגול-אינדיגו';

  @override
  String get colorOliveDrab => 'ירוק כהה';

  @override
  String get colorSlateGray => 'כחול-אפור';

  @override
  String get colorLightSlateGray => 'כחול-אפור';

  @override
  String get colorMediumSlateBlue => 'כחול בהיר';

  @override
  String get colorLawnGreen => 'ירוק';

  @override
  String get colorChartreuse => 'ירוק';

  @override
  String get colorAquamarine => 'ירוק בהיר';

  @override
  String get colorMaroon => 'אדום כהה';

  @override
  String get colorPurple => 'סגול כהה';

  @override
  String get colorOlive => 'צהוב כהה';

  @override
  String get colorGray => 'אפור';

  @override
  String get colorSkyBlue => 'טורקיז בהיר';

  @override
  String get colorLightSkyBlue => 'כחול בהיר';

  @override
  String get colorBlueViolet => 'סגול';

  @override
  String get colorDarkRed => 'אדום כהה';

  @override
  String get colorDarkMagenta => 'סגול כהה';

  @override
  String get colorSaddleBrown => 'חום';

  @override
  String get colorDarkSeaGreen => 'ירוק';

  @override
  String get colorLightGreen => 'ירוק בהיר';

  @override
  String get colorMediumPurple => 'סגול-לבנדר';

  @override
  String get colorDarkViolet => 'סגול';

  @override
  String get colorPaleGreen => 'ירוק בהיר';

  @override
  String get colorDarkOrchid => 'סגול';

  @override
  String get colorYellowGreen => 'ירוק';

  @override
  String get colorSienna => 'חום-צהבהב';

  @override
  String get colorBrown => 'אדום';

  @override
  String get colorDarkGray => 'אפור';

  @override
  String get colorLightBlue => 'כחול-שמים';

  @override
  String get colorGreenYellow => 'ירוק';

  @override
  String get colorPaleTurquoise => 'תכלת';

  @override
  String get colorLightSteelBlue => 'כחול-קרח';

  @override
  String get colorPowderBlue => 'כחול-שמים';

  @override
  String get colorFirebrick => 'אדום';

  @override
  String get colorDarkGoldenrod => 'צהוב כהה';

  @override
  String get colorMediumOrchid => 'סגול';

  @override
  String get colorRosyBrown => 'אלמוג';

  @override
  String get colorDarkKhaki => 'חום-צהבהב';

  @override
  String get colorSilver => 'אפור בהיר';

  @override
  String get colorMediumVioletRed => 'ורוד';

  @override
  String get colorIndianRed => 'אדום';

  @override
  String get colorPeru => 'חום-צהבהב';

  @override
  String get colorChocolate => 'כתום';

  @override
  String get colorTan => 'חום-צהבהב';

  @override
  String get colorLightGray => 'אפור בהיר';

  @override
  String get colorThistle => 'סגול-לבנדר';

  @override
  String get colorOrchid => 'סגול-לבנדר';

  @override
  String get colorGoldenrod => 'זהב';

  @override
  String get colorPaleVioletRed => 'שושנה';

  @override
  String get colorCrimson => 'אדום';

  @override
  String get colorGainsboro => 'אפור בהיר';

  @override
  String get colorPlum => 'ורוד';

  @override
  String get colorBurlyWood => 'חום-צהבהב';

  @override
  String get colorLightCyan => 'כחול-שמים';

  @override
  String get colorLavender => 'כחול בהיר';

  @override
  String get colorDarkSalmon => 'שושנה';

  @override
  String get colorViolet => 'סגול-לבנדר';

  @override
  String get colorPaleGoldenrod => 'צהוב בהיר';

  @override
  String get colorLightCoral => 'שושנה';

  @override
  String get colorKhaki => 'צהוב בהיר';

  @override
  String get colorAliceBlue => 'לבן';

  @override
  String get colorHoneydew => 'לבן';

  @override
  String get colorAzure => 'לבן';

  @override
  String get colorSandyBrown => 'כתום בהיר';

  @override
  String get colorWheat => 'צהוב בהיר';

  @override
  String get colorBeige => 'צהוב בהיר';

  @override
  String get colorWhiteSmoke => 'לבן';

  @override
  String get colorMintCream => 'לבן';

  @override
  String get colorGhostWhite => 'לבן';

  @override
  String get colorSalmon => 'שושנה';

  @override
  String get colorAntiqueWhite => 'כתום בהיר';

  @override
  String get colorLinen => 'כתום בהיר';

  @override
  String get colorLightGoldenrodYellow => 'צהוב בהיר';

  @override
  String get colorOldLace => 'לבן';

  @override
  String get colorRed => 'אדום';

  @override
  String get colorMagenta => 'סגול';

  @override
  String get colorDeepPink => 'ורוד';

  @override
  String get colorOrangeRed => 'אדום';

  @override
  String get colorTomato => 'אדום';

  @override
  String get colorHotPink => 'ורוד';

  @override
  String get colorCoral => 'אדום';

  @override
  String get colorDarkOrange => 'כתום';

  @override
  String get colorLightSalmon => 'שושנה';

  @override
  String get colorOrange => 'זהב';

  @override
  String get colorLightPink => 'שושנה';

  @override
  String get colorPink => 'שושנה';

  @override
  String get colorGold => 'זהב';

  @override
  String get colorPeachPuff => 'כתום בהיר';

  @override
  String get colorNavajoWhite => 'כתום בהיר';

  @override
  String get colorMoccasin => 'כתום בהיר';

  @override
  String get colorBisque => 'כתום בהיר';

  @override
  String get colorMistyRose => 'שושנה';

  @override
  String get colorBlanchedAlmond => 'כתום בהיר';

  @override
  String get colorPapayaWhip => 'כתום בהיר';

  @override
  String get colorLavenderBlush => 'לבן';

  @override
  String get colorSeaShell => 'לבן';

  @override
  String get colorCornsilk => 'צהוב בהיר';

  @override
  String get colorLemonChiffon => 'צהוב בהיר';

  @override
  String get colorFloralWhite => 'לבן';

  @override
  String get colorSnow => 'לבן';

  @override
  String get colorYellow => 'צהוב';

  @override
  String get colorLightYellow => 'צהוב בהיר';

  @override
  String get colorIvory => 'לבן';

  @override
  String get colorWhite => 'לבן';
}
