import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for French (`fr`).
class FluentLocalizationsFr extends FluentLocalizations {
  FluentLocalizationsFr([String locale = 'fr']) : super(locale);

  @override
  String get backButtonTooltip => 'Retour';

  @override
  String get closeButtonLabel => 'Fermer';

  @override
  String get searchLabel => 'Rechercher';

  @override
  String get closeNavigationTooltip => 'Fermer le navigateur';

  @override
  String get openNavigationTooltip => 'Ouvrir le navigateur';

  @override
  String get clickToSearch => 'Cliquez pour rechercher';

  @override
  String get modalBarrierDismissLabel => 'Annuler';

  @override
  String get minimizeWindowTooltip => 'Réduire';

  @override
  String get restoreWindowTooltip => 'Restaurer';

  @override
  String get closeWindowTooltip => 'Fermer';

  @override
  String get dialogLabel => 'Dialogue';

  @override
  String get cutActionLabel => 'Couper';

  @override
  String get copyActionLabel => 'Copier';

  @override
  String get pasteActionLabel => 'Coller';

  @override
  String get selectAllActionLabel => 'Tout sélectionner';

  @override
  String get newTabLabel => 'Ajouter un nouvel onglet';

  @override
  String get closeTabLabelSuffix => 'Fermer l\'onglet';

  @override
  String get scrollTabBackwardLabel => 'Défiler vers l\'arrière';

  @override
  String get scrollTabForwardLabel => 'Défiler vers l\'avant';

  @override
  String get noResultsFoundLabel => 'Aucun résultat trouvé';

  @override
  String get copyActionTooltip =>
      'Copier le contenu sélectionné dans le presse-papier';

  @override
  String get cutActionTooltip =>
      'Couper le contenu sélectionné et le mettre dans le presse-papier';

  @override
  String get pasteActionTooltip =>
      'Coller le contenu du presse-papier à la position actuelle';

  @override
  String get selectAllActionTooltip => 'Sélectionner tout le contenu';

  @override
  String get hour => 'heure';

  @override
  String get minute => 'minute';

  @override
  String get am => 'AM';

  @override
  String get pm => 'PM';

  @override
  String get month => 'mois';

  @override
  String get day => 'jour';

  @override
  String get year => 'année';

  @override
  String get redLabel => 'Rouge';

  @override
  String get greenLabel => 'Vert';

  @override
  String get blueLabel => 'Bleu';

  @override
  String get opacityLabel => 'Opacité';

  @override
  String get hueLabel => 'Teinte';

  @override
  String get saturationLabel => 'Saturation';

  @override
  String get valueLabel => 'Valeur';

  @override
  String get moreText => 'Plus';

  @override
  String get lessText => 'Moins';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return 'Valeur $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '$value% opacité';
  }

  @override
  String get colorBlack => 'Noir';

  @override
  String get colorNavy => 'Bleu foncé';

  @override
  String get colorDarkBlue => 'Bleu foncé';

  @override
  String get colorMediumBlue => 'Bleu';

  @override
  String get colorBlue => 'Bleu';

  @override
  String get colorDarkGreen => 'Vert foncé';

  @override
  String get colorGreen => 'Vert foncé';

  @override
  String get colorTeal => 'Bleu-vert foncé';

  @override
  String get colorDarkCyan => 'Bleu-vert foncé';

  @override
  String get colorDeepSkyBlue => 'Turquoise';

  @override
  String get colorDarkTurquoise => 'Vert d’eau';

  @override
  String get colorMediumSpringGreen => 'Vert';

  @override
  String get colorLime => 'Vert';

  @override
  String get colorSpringGreen => 'Vert';

  @override
  String get colorCyan => 'Vert d’eau';

  @override
  String get colorMidnightBlue => 'Bleu foncé';

  @override
  String get colorDodgerBlue => 'Bleu';

  @override
  String get colorLightSeaGreen => 'Bleu-vert';

  @override
  String get colorForestGreen => 'Vert foncé';

  @override
  String get colorSeaGreen => 'Vert foncé';

  @override
  String get colorDarkSlateGray => 'Bleu-vert foncé';

  @override
  String get colorLimeGreen => 'Vert';

  @override
  String get colorMediumSeaGreen => 'Vert';

  @override
  String get colorTurquoise => 'Bleu-vert';

  @override
  String get colorRoyalBlue => 'Bleu';

  @override
  String get colorSteelBlue => 'Bleu gris';

  @override
  String get colorDarkSlateBlue => 'Violet';

  @override
  String get colorMediumTurquoise => 'Bleu-vert';

  @override
  String get colorIndigo => 'Violet foncé';

  @override
  String get colorDarkOliveGreen => 'Vert foncé';

  @override
  String get colorCadetBlue => 'Bleu-vert';

  @override
  String get colorCornflowerBlue => 'Bleu';

  @override
  String get colorMediumAquamarine => 'Vert';

  @override
  String get colorDimGray => 'Gris';

  @override
  String get colorSlateBlue => 'Bleu indigo';

  @override
  String get colorOliveDrab => 'Vert foncé';

  @override
  String get colorSlateGray => 'Bleu gris';

  @override
  String get colorLightSlateGray => 'Bleu gris';

  @override
  String get colorMediumSlateBlue => 'Bleu clair';

  @override
  String get colorLawnGreen => 'Vert';

  @override
  String get colorChartreuse => 'Vert';

  @override
  String get colorAquamarine => 'Vert clair';

  @override
  String get colorMaroon => 'Rouge foncé';

  @override
  String get colorPurple => 'Violet foncé';

  @override
  String get colorOlive => 'Jaune foncé';

  @override
  String get colorGray => 'Gris';

  @override
  String get colorSkyBlue => 'Turquoise clair';

  @override
  String get colorLightSkyBlue => 'Bleu clair';

  @override
  String get colorBlueViolet => 'Violet';

  @override
  String get colorDarkRed => 'Rouge foncé';

  @override
  String get colorDarkMagenta => 'Violet foncé';

  @override
  String get colorSaddleBrown => 'Brun';

  @override
  String get colorDarkSeaGreen => 'Vert';

  @override
  String get colorLightGreen => 'Vert clair';

  @override
  String get colorMediumPurple => 'Lavande';

  @override
  String get colorDarkViolet => 'Violet';

  @override
  String get colorPaleGreen => 'Vert clair';

  @override
  String get colorDarkOrchid => 'Violet';

  @override
  String get colorYellowGreen => 'Vert';

  @override
  String get colorSienna => 'Brun';

  @override
  String get colorBrown => 'Rouge';

  @override
  String get colorDarkGray => 'Gris';

  @override
  String get colorLightBlue => 'Bleu ciel';

  @override
  String get colorGreenYellow => 'Vert';

  @override
  String get colorPaleTurquoise => 'Vert d’eau';

  @override
  String get colorLightSteelBlue => 'Bleu glacier';

  @override
  String get colorPowderBlue => 'Bleu ciel';

  @override
  String get colorFirebrick => 'Rouge';

  @override
  String get colorDarkGoldenrod => 'Jaune foncé';

  @override
  String get colorMediumOrchid => 'Violet';

  @override
  String get colorRosyBrown => 'Corail';

  @override
  String get colorDarkKhaki => 'Brun';

  @override
  String get colorSilver => 'Gris clair';

  @override
  String get colorMediumVioletRed => 'Rose';

  @override
  String get colorIndianRed => 'Rouge';

  @override
  String get colorPeru => 'Brun';

  @override
  String get colorChocolate => 'Orange';

  @override
  String get colorTan => 'Brun';

  @override
  String get colorLightGray => 'Gris clair';

  @override
  String get colorThistle => 'Lavande';

  @override
  String get colorOrchid => 'Lavande';

  @override
  String get colorGoldenrod => 'Or';

  @override
  String get colorPaleVioletRed => 'Rose saumon';

  @override
  String get colorCrimson => 'Rouge';

  @override
  String get colorGainsboro => 'Gris clair';

  @override
  String get colorPlum => 'Rose';

  @override
  String get colorBurlyWood => 'Brun';

  @override
  String get colorLightCyan => 'Bleu ciel';

  @override
  String get colorLavender => 'Bleu clair';

  @override
  String get colorDarkSalmon => 'Rose saumon';

  @override
  String get colorViolet => 'Lavande';

  @override
  String get colorPaleGoldenrod => 'Jaune clair';

  @override
  String get colorLightCoral => 'Rose saumon';

  @override
  String get colorKhaki => 'Jaune clair';

  @override
  String get colorAliceBlue => 'Blanc';

  @override
  String get colorHoneydew => 'Blanc';

  @override
  String get colorAzure => 'Blanc';

  @override
  String get colorSandyBrown => 'Orange clair';

  @override
  String get colorWheat => 'Jaune clair';

  @override
  String get colorBeige => 'Jaune clair';

  @override
  String get colorWhiteSmoke => 'Blanc';

  @override
  String get colorMintCream => 'Blanc';

  @override
  String get colorGhostWhite => 'Blanc';

  @override
  String get colorSalmon => 'Rose saumon';

  @override
  String get colorAntiqueWhite => 'Orange clair';

  @override
  String get colorLinen => 'Orange clair';

  @override
  String get colorLightGoldenrodYellow => 'Jaune clair';

  @override
  String get colorOldLace => 'Blanc';

  @override
  String get colorRed => 'Rouge';

  @override
  String get colorMagenta => 'Violet';

  @override
  String get colorDeepPink => 'Rose';

  @override
  String get colorOrangeRed => 'Rouge';

  @override
  String get colorTomato => 'Rouge';

  @override
  String get colorHotPink => 'Rose';

  @override
  String get colorCoral => 'Rouge';

  @override
  String get colorDarkOrange => 'Orange';

  @override
  String get colorLightSalmon => 'Rose saumon';

  @override
  String get colorOrange => 'Or';

  @override
  String get colorLightPink => 'Rose saumon';

  @override
  String get colorPink => 'Rose saumon';

  @override
  String get colorGold => 'Or';

  @override
  String get colorPeachPuff => 'Orange clair';

  @override
  String get colorNavajoWhite => 'Orange clair';

  @override
  String get colorMoccasin => 'Orange clair';

  @override
  String get colorBisque => 'Orange clair';

  @override
  String get colorMistyRose => 'Rose saumon';

  @override
  String get colorBlanchedAlmond => 'Orange clair';

  @override
  String get colorPapayaWhip => 'Orange clair';

  @override
  String get colorLavenderBlush => 'Blanc';

  @override
  String get colorSeaShell => 'Blanc';

  @override
  String get colorCornsilk => 'Jaune clair';

  @override
  String get colorLemonChiffon => 'Jaune clair';

  @override
  String get colorFloralWhite => 'Blanc';

  @override
  String get colorSnow => 'Blanc';

  @override
  String get colorYellow => 'Jaune';

  @override
  String get colorLightYellow => 'Jaune clair';

  @override
  String get colorIvory => 'Blanc';

  @override
  String get colorWhite => 'Blanc';
}
