import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Spanish Castilian (`es`).
class FluentLocalizationsEs extends FluentLocalizations {
  FluentLocalizationsEs([String locale = 'es']) : super(locale);

  @override
  String get backButtonTooltip => 'Volver';

  @override
  String get closeButtonLabel => 'Cerrar';

  @override
  String get searchLabel => 'Buscar';

  @override
  String get closeNavigationTooltip => 'Cerrar Navegador';

  @override
  String get openNavigationTooltip => 'Abrir Navegador';

  @override
  String get clickToSearch => 'Haz clic para buscar';

  @override
  String get modalBarrierDismissLabel => 'Cancelar';

  @override
  String get minimizeWindowTooltip => 'Minimizar';

  @override
  String get restoreWindowTooltip => 'Restaurar';

  @override
  String get closeWindowTooltip => 'Cerrar';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get cutActionLabel => 'Cortar';

  @override
  String get copyActionLabel => 'Copiar';

  @override
  String get pasteActionLabel => 'Pegar';

  @override
  String get selectAllActionLabel => 'Seleccionar todo';

  @override
  String get newTabLabel => 'Añadir nueva pestaña';

  @override
  String get closeTabLabelSuffix => 'Cerrar pestaña';

  @override
  String get scrollTabBackwardLabel => 'Hacer scroll hacia atrás';

  @override
  String get scrollTabForwardLabel => 'Hacer scroll hacia delante';

  @override
  String get noResultsFoundLabel => 'No se encontraron resultados';

  @override
  String get copyActionTooltip =>
      'Copiar el contenido seleccionado al portapapeles';

  @override
  String get cutActionTooltip =>
      'Cortar el contenido seleccionado y ponerlo en el portapapeles';

  @override
  String get pasteActionTooltip =>
      'Insertar el contenido del portapapeles en la posición actual';

  @override
  String get selectAllActionTooltip => 'Seleccionar todo el contenido';

  @override
  String get hour => 'hora';

  @override
  String get minute => 'minuto';

  @override
  String get am => 'AM';

  @override
  String get pm => 'PM';

  @override
  String get month => 'mes';

  @override
  String get day => 'día';

  @override
  String get year => 'año';

  @override
  String get redLabel => 'Rojo';

  @override
  String get greenLabel => 'Verde';

  @override
  String get blueLabel => 'Azul';

  @override
  String get opacityLabel => 'Opacidad';

  @override
  String get hueLabel => 'Matiz';

  @override
  String get saturationLabel => 'Saturación';

  @override
  String get valueLabel => 'Valor';

  @override
  String get moreText => 'Más';

  @override
  String get lessText => 'Menos';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return 'Valor $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '$value% Opacidad';
  }

  @override
  String get colorBlack => 'Negro';

  @override
  String get colorNavy => 'Azul marino';

  @override
  String get colorDarkBlue => 'Azul marino';

  @override
  String get colorMediumBlue => 'Azul';

  @override
  String get colorBlue => 'Azul';

  @override
  String get colorDarkGreen => 'Verde oscuro';

  @override
  String get colorGreen => 'Verde oscuro';

  @override
  String get colorTeal => 'Verde azulado oscuro';

  @override
  String get colorDarkCyan => 'Verde azulado oscuro';

  @override
  String get colorDeepSkyBlue => 'Turquesa';

  @override
  String get colorDarkTurquoise => 'Agua';

  @override
  String get colorMediumSpringGreen => 'Verde';

  @override
  String get colorLime => 'Verde';

  @override
  String get colorSpringGreen => 'Verde';

  @override
  String get colorCyan => 'Agua';

  @override
  String get colorMidnightBlue => 'Azul marino';

  @override
  String get colorDodgerBlue => 'Azul';

  @override
  String get colorLightSeaGreen => 'Verde azulado';

  @override
  String get colorForestGreen => 'Verde oscuro';

  @override
  String get colorSeaGreen => 'Verde oscuro';

  @override
  String get colorDarkSlateGray => 'Verde azulado oscuro';

  @override
  String get colorLimeGreen => 'Verde';

  @override
  String get colorMediumSeaGreen => 'Verde';

  @override
  String get colorTurquoise => 'Verde azulado';

  @override
  String get colorRoyalBlue => 'Azul';

  @override
  String get colorSteelBlue => 'Azul grisáceo';

  @override
  String get colorDarkSlateBlue => 'Púrpura';

  @override
  String get colorMediumTurquoise => 'Verde azulado';

  @override
  String get colorIndigo => 'Morado oscuro';

  @override
  String get colorDarkOliveGreen => 'Verde oscuro';

  @override
  String get colorCadetBlue => 'Verde azulado';

  @override
  String get colorCornflowerBlue => 'Azul';

  @override
  String get colorMediumAquamarine => 'Verde';

  @override
  String get colorDimGray => 'Gris';

  @override
  String get colorSlateBlue => 'Añil';

  @override
  String get colorOliveDrab => 'Verde oscuro';

  @override
  String get colorSlateGray => 'Azul grisáceo';

  @override
  String get colorLightSlateGray => 'Azul grisáceo';

  @override
  String get colorMediumSlateBlue => 'Azul claro';

  @override
  String get colorLawnGreen => 'Verde';

  @override
  String get colorChartreuse => 'Verde';

  @override
  String get colorAquamarine => 'Verde claro';

  @override
  String get colorMaroon => 'Rojo oscuro';

  @override
  String get colorPurple => 'Morado oscuro';

  @override
  String get colorOlive => 'Amarillo oscuro';

  @override
  String get colorGray => 'Gris';

  @override
  String get colorSkyBlue => 'Turquesa claro';

  @override
  String get colorLightSkyBlue => 'Azul claro';

  @override
  String get colorBlueViolet => 'Púrpura';

  @override
  String get colorDarkRed => 'Rojo oscuro';

  @override
  String get colorDarkMagenta => 'Morado oscuro';

  @override
  String get colorSaddleBrown => 'Marrón';

  @override
  String get colorDarkSeaGreen => 'Verde';

  @override
  String get colorLightGreen => 'Verde claro';

  @override
  String get colorMediumPurple => 'Lavanda';

  @override
  String get colorDarkViolet => 'Púrpura';

  @override
  String get colorPaleGreen => 'Verde claro';

  @override
  String get colorDarkOrchid => 'Púrpura';

  @override
  String get colorYellowGreen => 'Verde';

  @override
  String get colorSienna => 'Canela';

  @override
  String get colorBrown => 'Rojo';

  @override
  String get colorDarkGray => 'Gris';

  @override
  String get colorLightBlue => 'Azul cielo';

  @override
  String get colorGreenYellow => 'Verde';

  @override
  String get colorPaleTurquoise => 'Agua';

  @override
  String get colorLightSteelBlue => 'Azul hielo';

  @override
  String get colorPowderBlue => 'Azul cielo';

  @override
  String get colorFirebrick => 'Rojo';

  @override
  String get colorDarkGoldenrod => 'Amarillo oscuro';

  @override
  String get colorMediumOrchid => 'Púrpura';

  @override
  String get colorRosyBrown => 'Coral';

  @override
  String get colorDarkKhaki => 'Canela';

  @override
  String get colorSilver => 'Gris claro';

  @override
  String get colorMediumVioletRed => 'Rosa';

  @override
  String get colorIndianRed => 'Rojo';

  @override
  String get colorPeru => 'Canela';

  @override
  String get colorChocolate => 'Naranja';

  @override
  String get colorTan => 'Canela';

  @override
  String get colorLightGray => 'Gris claro';

  @override
  String get colorThistle => 'Lavanda';

  @override
  String get colorOrchid => 'Lavanda';

  @override
  String get colorGoldenrod => 'Dorado';

  @override
  String get colorPaleVioletRed => 'Rosado';

  @override
  String get colorCrimson => 'Rojo';

  @override
  String get colorGainsboro => 'Gris claro';

  @override
  String get colorPlum => 'Rosa';

  @override
  String get colorBurlyWood => 'Canela';

  @override
  String get colorLightCyan => 'Azul cielo';

  @override
  String get colorLavender => 'Azul claro';

  @override
  String get colorDarkSalmon => 'Rosado';

  @override
  String get colorViolet => 'Lavanda';

  @override
  String get colorPaleGoldenrod => 'Amarillo claro';

  @override
  String get colorLightCoral => 'Rosado';

  @override
  String get colorKhaki => 'Amarillo claro';

  @override
  String get colorAliceBlue => 'Blanco';

  @override
  String get colorHoneydew => 'Blanco';

  @override
  String get colorAzure => 'Blanco';

  @override
  String get colorSandyBrown => 'Naranja claro';

  @override
  String get colorWheat => 'Amarillo claro';

  @override
  String get colorBeige => 'Amarillo claro';

  @override
  String get colorWhiteSmoke => 'Blanco';

  @override
  String get colorMintCream => 'Blanco';

  @override
  String get colorGhostWhite => 'Blanco';

  @override
  String get colorSalmon => 'Rosado';

  @override
  String get colorAntiqueWhite => 'Naranja claro';

  @override
  String get colorLinen => 'Naranja claro';

  @override
  String get colorLightGoldenrodYellow => 'Amarillo claro';

  @override
  String get colorOldLace => 'Blanco';

  @override
  String get colorRed => 'Rojo';

  @override
  String get colorMagenta => 'Púrpura';

  @override
  String get colorDeepPink => 'Rosa';

  @override
  String get colorOrangeRed => 'Rojo';

  @override
  String get colorTomato => 'Rojo';

  @override
  String get colorHotPink => 'Rosa';

  @override
  String get colorCoral => 'Rojo';

  @override
  String get colorDarkOrange => 'Naranja';

  @override
  String get colorLightSalmon => 'Rosado';

  @override
  String get colorOrange => 'Dorado';

  @override
  String get colorLightPink => 'Rosado';

  @override
  String get colorPink => 'Rosado';

  @override
  String get colorGold => 'Dorado';

  @override
  String get colorPeachPuff => 'Naranja claro';

  @override
  String get colorNavajoWhite => 'Naranja claro';

  @override
  String get colorMoccasin => 'Naranja claro';

  @override
  String get colorBisque => 'Naranja claro';

  @override
  String get colorMistyRose => 'Rosado';

  @override
  String get colorBlanchedAlmond => 'Naranja claro';

  @override
  String get colorPapayaWhip => 'Naranja claro';

  @override
  String get colorLavenderBlush => 'Blanco';

  @override
  String get colorSeaShell => 'Blanco';

  @override
  String get colorCornsilk => 'Amarillo claro';

  @override
  String get colorLemonChiffon => 'Amarillo claro';

  @override
  String get colorFloralWhite => 'Blanco';

  @override
  String get colorSnow => 'Blanco';

  @override
  String get colorYellow => 'Amarillo';

  @override
  String get colorLightYellow => 'Amarillo claro';

  @override
  String get colorIvory => 'Blanco';

  @override
  String get colorWhite => 'Blanco';
}
