import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for English (`en`).
class FluentLocalizationsEn extends FluentLocalizations {
  FluentLocalizationsEn([String locale = 'en']) : super(locale);

  @override
  String get backButtonTooltip => 'Back';

  @override
  String get closeButtonLabel => 'Close';

  @override
  String get searchLabel => 'Search';

  @override
  String get closeNavigationTooltip => 'Close Navigation';

  @override
  String get openNavigationTooltip => 'Open Navigation';

  @override
  String get clickToSearch => 'Click to search';

  @override
  String get modalBarrierDismissLabel => 'Dismiss';

  @override
  String get minimizeWindowTooltip => 'Minimize';

  @override
  String get restoreWindowTooltip => 'Restore';

  @override
  String get closeWindowTooltip => 'Close';

  @override
  String get dialogLabel => 'Dialog';

  @override
  String get cutActionLabel => 'Cut';

  @override
  String get copyActionLabel => 'Copy';

  @override
  String get pasteActionLabel => 'Paste';

  @override
  String get selectAllActionLabel => 'Select all';

  @override
  String get newTabLabel => 'Add new tab';

  @override
  String get closeTabLabelSuffix => 'Close tab';

  @override
  String get scrollTabBackwardLabel => 'Scroll tab list backward';

  @override
  String get scrollTabForwardLabel => 'Scroll tab list forward';

  @override
  String get noResultsFoundLabel => 'No results found';

  @override
  String get copyActionTooltip => 'Copy the selected content to the clipboard';

  @override
  String get cutActionTooltip =>
      'Remove the selected content and put it in the clipboard';

  @override
  String get pasteActionTooltip =>
      'Inserts the contents of the clipboard at the current location';

  @override
  String get selectAllActionTooltip => 'Select all content';

  @override
  String get hour => 'hour';

  @override
  String get minute => 'minute';

  @override
  String get am => 'AM';

  @override
  String get pm => 'PM';

  @override
  String get month => 'month';

  @override
  String get day => 'day';

  @override
  String get year => 'year';

  @override
  String get redLabel => 'Red';

  @override
  String get greenLabel => 'Green';

  @override
  String get blueLabel => 'Blue';

  @override
  String get opacityLabel => 'Opacity';

  @override
  String get hueLabel => 'Hue';

  @override
  String get saturationLabel => 'Saturation';

  @override
  String get valueLabel => 'Value';

  @override
  String get moreText => 'More';

  @override
  String get lessText => 'Less';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return 'Value $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '$value% opacity';
  }

  @override
  String get colorBlack => 'Black';

  @override
  String get colorNavy => 'Dark blue';

  @override
  String get colorDarkBlue => 'Dark blue';

  @override
  String get colorMediumBlue => 'Blue';

  @override
  String get colorBlue => 'Blue';

  @override
  String get colorDarkGreen => 'Dark green';

  @override
  String get colorGreen => 'Dark green';

  @override
  String get colorTeal => 'Dark teal';

  @override
  String get colorDarkCyan => 'Dark teal';

  @override
  String get colorDeepSkyBlue => 'Turquoise';

  @override
  String get colorDarkTurquoise => 'Aqua';

  @override
  String get colorMediumSpringGreen => 'Green';

  @override
  String get colorLime => 'Green';

  @override
  String get colorSpringGreen => 'Green';

  @override
  String get colorCyan => 'Aqua';

  @override
  String get colorMidnightBlue => 'Dark blue';

  @override
  String get colorDodgerBlue => 'Blue';

  @override
  String get colorLightSeaGreen => 'Teal';

  @override
  String get colorForestGreen => 'Dark green';

  @override
  String get colorSeaGreen => 'Dark green';

  @override
  String get colorDarkSlateGray => 'Dark teal';

  @override
  String get colorLimeGreen => 'Green';

  @override
  String get colorMediumSeaGreen => 'Green';

  @override
  String get colorTurquoise => 'Teal';

  @override
  String get colorRoyalBlue => 'Blue';

  @override
  String get colorSteelBlue => 'Blue-gray';

  @override
  String get colorDarkSlateBlue => 'Purple';

  @override
  String get colorMediumTurquoise => 'Teal';

  @override
  String get colorIndigo => 'Dark purple';

  @override
  String get colorDarkOliveGreen => 'Dark green';

  @override
  String get colorCadetBlue => 'Teal';

  @override
  String get colorCornflowerBlue => 'Blue';

  @override
  String get colorMediumAquamarine => 'Green';

  @override
  String get colorDimGray => 'Gray';

  @override
  String get colorSlateBlue => 'Indigo';

  @override
  String get colorOliveDrab => 'Dark green';

  @override
  String get colorSlateGray => 'Blue-gray';

  @override
  String get colorLightSlateGray => 'Blue-gray';

  @override
  String get colorMediumSlateBlue => 'Light blue';

  @override
  String get colorLawnGreen => 'Green';

  @override
  String get colorChartreuse => 'Green';

  @override
  String get colorAquamarine => 'Light green';

  @override
  String get colorMaroon => 'Dark red';

  @override
  String get colorPurple => 'Dark purple';

  @override
  String get colorOlive => 'Dark yellow';

  @override
  String get colorGray => 'Gray';

  @override
  String get colorSkyBlue => 'Light turquoise';

  @override
  String get colorLightSkyBlue => 'Light blue';

  @override
  String get colorBlueViolet => 'Purple';

  @override
  String get colorDarkRed => 'Dark red';

  @override
  String get colorDarkMagenta => 'Dark purple';

  @override
  String get colorSaddleBrown => 'Brown';

  @override
  String get colorDarkSeaGreen => 'Green';

  @override
  String get colorLightGreen => 'Light green';

  @override
  String get colorMediumPurple => 'Lavender';

  @override
  String get colorDarkViolet => 'Purple';

  @override
  String get colorPaleGreen => 'Light green';

  @override
  String get colorDarkOrchid => 'Purple';

  @override
  String get colorYellowGreen => 'Green';

  @override
  String get colorSienna => 'Tan';

  @override
  String get colorBrown => 'Red';

  @override
  String get colorDarkGray => 'Gray';

  @override
  String get colorLightBlue => 'Sky blue';

  @override
  String get colorGreenYellow => 'Green';

  @override
  String get colorPaleTurquoise => 'Aqua';

  @override
  String get colorLightSteelBlue => 'Ice blue';

  @override
  String get colorPowderBlue => 'Sky blue';

  @override
  String get colorFirebrick => 'Red';

  @override
  String get colorDarkGoldenrod => 'Dark yellow';

  @override
  String get colorMediumOrchid => 'Purple';

  @override
  String get colorRosyBrown => 'Coral';

  @override
  String get colorDarkKhaki => 'Tan';

  @override
  String get colorSilver => 'Light gray';

  @override
  String get colorMediumVioletRed => 'Pink';

  @override
  String get colorIndianRed => 'Red';

  @override
  String get colorPeru => 'Tan';

  @override
  String get colorChocolate => 'Orange';

  @override
  String get colorTan => 'Tan';

  @override
  String get colorLightGray => 'Light gray';

  @override
  String get colorThistle => 'Lavender';

  @override
  String get colorOrchid => 'Lavender';

  @override
  String get colorGoldenrod => 'Gold';

  @override
  String get colorPaleVioletRed => 'Rose';

  @override
  String get colorCrimson => 'Red';

  @override
  String get colorGainsboro => 'Light gray';

  @override
  String get colorPlum => 'Pink';

  @override
  String get colorBurlyWood => 'Tan';

  @override
  String get colorLightCyan => 'Sky blue';

  @override
  String get colorLavender => 'Light blue';

  @override
  String get colorDarkSalmon => 'Rose';

  @override
  String get colorViolet => 'Lavender';

  @override
  String get colorPaleGoldenrod => 'Light yellow';

  @override
  String get colorLightCoral => 'Rose';

  @override
  String get colorKhaki => 'Light yellow';

  @override
  String get colorAliceBlue => 'White';

  @override
  String get colorHoneydew => 'White';

  @override
  String get colorAzure => 'White';

  @override
  String get colorSandyBrown => 'Light orange';

  @override
  String get colorWheat => 'Light yellow';

  @override
  String get colorBeige => 'Light yellow';

  @override
  String get colorWhiteSmoke => 'White';

  @override
  String get colorMintCream => 'White';

  @override
  String get colorGhostWhite => 'White';

  @override
  String get colorSalmon => 'Rose';

  @override
  String get colorAntiqueWhite => 'Light orange';

  @override
  String get colorLinen => 'Light orange';

  @override
  String get colorLightGoldenrodYellow => 'Light yellow';

  @override
  String get colorOldLace => 'White';

  @override
  String get colorRed => 'Red';

  @override
  String get colorMagenta => 'Purple';

  @override
  String get colorDeepPink => 'Pink';

  @override
  String get colorOrangeRed => 'Red';

  @override
  String get colorTomato => 'Red';

  @override
  String get colorHotPink => 'Pink';

  @override
  String get colorCoral => 'Red';

  @override
  String get colorDarkOrange => 'Orange';

  @override
  String get colorLightSalmon => 'Rose';

  @override
  String get colorOrange => 'Gold';

  @override
  String get colorLightPink => 'Rose';

  @override
  String get colorPink => 'Rose';

  @override
  String get colorGold => 'Gold';

  @override
  String get colorPeachPuff => 'Light orange';

  @override
  String get colorNavajoWhite => 'Light orange';

  @override
  String get colorMoccasin => 'Light orange';

  @override
  String get colorBisque => 'Light orange';

  @override
  String get colorMistyRose => 'Rose';

  @override
  String get colorBlanchedAlmond => 'Light orange';

  @override
  String get colorPapayaWhip => 'Light orange';

  @override
  String get colorLavenderBlush => 'White';

  @override
  String get colorSeaShell => 'White';

  @override
  String get colorCornsilk => 'Light yellow';

  @override
  String get colorLemonChiffon => 'Light yellow';

  @override
  String get colorFloralWhite => 'White';

  @override
  String get colorSnow => 'White';

  @override
  String get colorYellow => 'Yellow';

  @override
  String get colorLightYellow => 'Light yellow';

  @override
  String get colorIvory => 'White';

  @override
  String get colorWhite => 'White';
}
