import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for German (`de`).
class FluentLocalizationsDe extends FluentLocalizations {
  FluentLocalizationsDe([String locale = 'de']) : super(locale);

  @override
  String get backButtonTooltip => 'Zurück';

  @override
  String get closeButtonLabel => 'Schließen';

  @override
  String get searchLabel => 'Suchen';

  @override
  String get closeNavigationTooltip => 'Navigation schließen';

  @override
  String get openNavigationTooltip => 'Navigation öffnen';

  @override
  String get clickToSearch => 'Zum Suchen klicken';

  @override
  String get modalBarrierDismissLabel => 'Schließen';

  @override
  String get minimizeWindowTooltip => 'Minimieren';

  @override
  String get restoreWindowTooltip => 'Wiederherstellen';

  @override
  String get closeWindowTooltip => 'Schließen';

  @override
  String get dialogLabel => 'Dialog';

  @override
  String get cutActionLabel => 'Ausschneiden';

  @override
  String get copyActionLabel => 'Kopieren';

  @override
  String get pasteActionLabel => 'Einfügen';

  @override
  String get selectAllActionLabel => 'Alles auswählen';

  @override
  String get newTabLabel => 'Neuen Tab hinzufügen';

  @override
  String get closeTabLabelSuffix => 'Tab schließen';

  @override
  String get scrollTabBackwardLabel => 'Tab-Liste rückwärts scrollen';

  @override
  String get scrollTabForwardLabel => 'Tabliste vorwärts scrollen';

  @override
  String get noResultsFoundLabel => 'Keine Ergebnisse gefunden';

  @override
  String get copyActionTooltip =>
      'Ausgewählten Inhalt in die Zwischenablage kopieren';

  @override
  String get cutActionTooltip =>
      'Ausgewählten Inhalt entfernen und in die Zwischenablage legen';

  @override
  String get pasteActionTooltip =>
      'Fügt den Inhalt der Zwischenablage an der aktuellen Stelle ein';

  @override
  String get selectAllActionTooltip => 'Alle Inhalte auswählen';

  @override
  String get hour => 'Stunde';

  @override
  String get minute => 'Minute';

  @override
  String get am => 'AM';

  @override
  String get pm => 'PM';

  @override
  String get month => 'Monat';

  @override
  String get day => 'Tag';

  @override
  String get year => 'Jahr';

  @override
  String get redLabel => 'Rot';

  @override
  String get greenLabel => 'Grün';

  @override
  String get blueLabel => 'Blau';

  @override
  String get opacityLabel => 'Deckkraft';

  @override
  String get hueLabel => 'Farbton';

  @override
  String get saturationLabel => 'Sättigung';

  @override
  String get valueLabel => 'Wert';

  @override
  String get moreText => 'Mehr';

  @override
  String get lessText => 'Weniger';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return 'Wert $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return 'Deckkraft: $value%';
  }

  @override
  String get colorBlack => 'Schwarz';

  @override
  String get colorNavy => 'Dunkelblau';

  @override
  String get colorDarkBlue => 'Dunkelblau';

  @override
  String get colorMediumBlue => 'Blau';

  @override
  String get colorBlue => 'Blau';

  @override
  String get colorDarkGreen => 'Dunkelgrün';

  @override
  String get colorGreen => 'Dunkelgrün';

  @override
  String get colorTeal => 'Dunkelblaugrün';

  @override
  String get colorDarkCyan => 'Dunkelblaugrün';

  @override
  String get colorDeepSkyBlue => 'Türkis';

  @override
  String get colorDarkTurquoise => 'Wasserblau';

  @override
  String get colorMediumSpringGreen => 'Grün';

  @override
  String get colorLime => 'Grün';

  @override
  String get colorSpringGreen => 'Grün';

  @override
  String get colorCyan => 'Wasserblau';

  @override
  String get colorMidnightBlue => 'Dunkelblau';

  @override
  String get colorDodgerBlue => 'Blau';

  @override
  String get colorLightSeaGreen => 'Blaugrün';

  @override
  String get colorForestGreen => 'Dunkelgrün';

  @override
  String get colorSeaGreen => 'Dunkelgrün';

  @override
  String get colorDarkSlateGray => 'Dunkelblaugrün';

  @override
  String get colorLimeGreen => 'Grün';

  @override
  String get colorMediumSeaGreen => 'Grün';

  @override
  String get colorTurquoise => 'Blaugrün';

  @override
  String get colorRoyalBlue => 'Blau';

  @override
  String get colorSteelBlue => 'Blaugrau';

  @override
  String get colorDarkSlateBlue => 'Lila';

  @override
  String get colorMediumTurquoise => 'Blaugrün';

  @override
  String get colorIndigo => 'Dunkellila';

  @override
  String get colorDarkOliveGreen => 'Dunkelgrün';

  @override
  String get colorCadetBlue => 'Blaugrün';

  @override
  String get colorCornflowerBlue => 'Blau';

  @override
  String get colorMediumAquamarine => 'Grün';

  @override
  String get colorDimGray => 'Grau';

  @override
  String get colorSlateBlue => 'Indigoblau';

  @override
  String get colorOliveDrab => 'Dunkelgrün';

  @override
  String get colorSlateGray => 'Blaugrau';

  @override
  String get colorLightSlateGray => 'Blaugrau';

  @override
  String get colorMediumSlateBlue => 'Hellblau';

  @override
  String get colorLawnGreen => 'Grün';

  @override
  String get colorChartreuse => 'Grün';

  @override
  String get colorAquamarine => 'Hellgrün';

  @override
  String get colorMaroon => 'Dunkelrot';

  @override
  String get colorPurple => 'Dunkellila';

  @override
  String get colorOlive => 'Dunkelgelb';

  @override
  String get colorGray => 'Grau';

  @override
  String get colorSkyBlue => 'Helltürkis';

  @override
  String get colorLightSkyBlue => 'Hellblau';

  @override
  String get colorBlueViolet => 'Lila';

  @override
  String get colorDarkRed => 'Dunkelrot';

  @override
  String get colorDarkMagenta => 'Dunkellila';

  @override
  String get colorSaddleBrown => 'Braun';

  @override
  String get colorDarkSeaGreen => 'Grün';

  @override
  String get colorLightGreen => 'Hellgrün';

  @override
  String get colorMediumPurple => 'Flieder';

  @override
  String get colorDarkViolet => 'Lila';

  @override
  String get colorPaleGreen => 'Hellgrün';

  @override
  String get colorDarkOrchid => 'Lila';

  @override
  String get colorYellowGreen => 'Grün';

  @override
  String get colorSienna => 'Hellbraun';

  @override
  String get colorBrown => 'Rot';

  @override
  String get colorDarkGray => 'Grau';

  @override
  String get colorLightBlue => 'Himmelblau';

  @override
  String get colorGreenYellow => 'Grün';

  @override
  String get colorPaleTurquoise => 'Wasserblau';

  @override
  String get colorLightSteelBlue => 'Eisblau';

  @override
  String get colorPowderBlue => 'Himmelblau';

  @override
  String get colorFirebrick => 'Rot';

  @override
  String get colorDarkGoldenrod => 'Dunkelgelb';

  @override
  String get colorMediumOrchid => 'Lila';

  @override
  String get colorRosyBrown => 'Korallenrot';

  @override
  String get colorDarkKhaki => 'Hellbraun';

  @override
  String get colorSilver => 'Hellgrau';

  @override
  String get colorMediumVioletRed => 'Rosa';

  @override
  String get colorIndianRed => 'Rot';

  @override
  String get colorPeru => 'Hellbraun';

  @override
  String get colorChocolate => 'Orange';

  @override
  String get colorTan => 'Hellbraun';

  @override
  String get colorLightGray => 'Hellgrau';

  @override
  String get colorThistle => 'Flieder';

  @override
  String get colorOrchid => 'Flieder';

  @override
  String get colorGoldenrod => 'Gold';

  @override
  String get colorPaleVioletRed => 'Rosa';

  @override
  String get colorCrimson => 'Rot';

  @override
  String get colorGainsboro => 'Hellgrau';

  @override
  String get colorPlum => 'Rosa';

  @override
  String get colorBurlyWood => 'Hellbraun';

  @override
  String get colorLightCyan => 'Himmelblau';

  @override
  String get colorLavender => 'Hellblau';

  @override
  String get colorDarkSalmon => 'Rosa';

  @override
  String get colorViolet => 'Flieder';

  @override
  String get colorPaleGoldenrod => 'Hellgelb';

  @override
  String get colorLightCoral => 'Rosa';

  @override
  String get colorKhaki => 'Hellgelb';

  @override
  String get colorAliceBlue => 'Weiß';

  @override
  String get colorHoneydew => 'Weiß';

  @override
  String get colorAzure => 'Weiß';

  @override
  String get colorSandyBrown => 'Hellorange';

  @override
  String get colorWheat => 'Hellgelb';

  @override
  String get colorBeige => 'Hellgelb';

  @override
  String get colorWhiteSmoke => 'Weiß';

  @override
  String get colorMintCream => 'Weiß';

  @override
  String get colorGhostWhite => 'Weiß';

  @override
  String get colorSalmon => 'Rosa';

  @override
  String get colorAntiqueWhite => 'Hellorange';

  @override
  String get colorLinen => 'Hellorange';

  @override
  String get colorLightGoldenrodYellow => 'Hellgelb';

  @override
  String get colorOldLace => 'Weiß';

  @override
  String get colorRed => 'Rot';

  @override
  String get colorMagenta => 'Lila';

  @override
  String get colorDeepPink => 'Rosa';

  @override
  String get colorOrangeRed => 'Rot';

  @override
  String get colorTomato => 'Rot';

  @override
  String get colorHotPink => 'Rosa';

  @override
  String get colorCoral => 'Rot';

  @override
  String get colorDarkOrange => 'Orange';

  @override
  String get colorLightSalmon => 'Rosa';

  @override
  String get colorOrange => 'Gold';

  @override
  String get colorLightPink => 'Rosa';

  @override
  String get colorPink => 'Rosa';

  @override
  String get colorGold => 'Gold';

  @override
  String get colorPeachPuff => 'Hellorange';

  @override
  String get colorNavajoWhite => 'Hellorange';

  @override
  String get colorMoccasin => 'Hellorange';

  @override
  String get colorBisque => 'Hellorange';

  @override
  String get colorMistyRose => 'Rosa';

  @override
  String get colorBlanchedAlmond => 'Hellorange';

  @override
  String get colorPapayaWhip => 'Hellorange';

  @override
  String get colorLavenderBlush => 'Weiß';

  @override
  String get colorSeaShell => 'Weiß';

  @override
  String get colorCornsilk => 'Hellgelb';

  @override
  String get colorLemonChiffon => 'Hellgelb';

  @override
  String get colorFloralWhite => 'Weiß';

  @override
  String get colorSnow => 'Weiß';

  @override
  String get colorYellow => 'Gelb';

  @override
  String get colorLightYellow => 'Hellgelb';

  @override
  String get colorIvory => 'Weiß';

  @override
  String get colorWhite => 'Weiß';
}
