import 'fluent_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Catalan Valencian (`ca`).
class FluentLocalizationsCa extends FluentLocalizations {
  FluentLocalizationsCa([String locale = 'ca']) : super(locale);

  @override
  String get backButtonTooltip => 'Tornar';

  @override
  String get closeButtonLabel => 'Tancar';

  @override
  String get searchLabel => 'Cerca';

  @override
  String get closeNavigationTooltip => 'Tancar Navegador';

  @override
  String get openNavigationTooltip => 'Obrir Navegador';

  @override
  String get clickToSearch => 'Fes clic per cercar';

  @override
  String get modalBarrierDismissLabel => 'Cancel·la';

  @override
  String get minimizeWindowTooltip => 'Minimitzar';

  @override
  String get restoreWindowTooltip => 'Restaurar';

  @override
  String get closeWindowTooltip => 'Tancar';

  @override
  String get dialogLabel => 'Diàleg';

  @override
  String get cutActionLabel => 'Tallar';

  @override
  String get copyActionLabel => 'Copiar';

  @override
  String get pasteActionLabel => 'Enganxar';

  @override
  String get selectAllActionLabel => 'Selecciona-ho tot';

  @override
  String get newTabLabel => 'Afegeix nova pestanya';

  @override
  String get closeTabLabelSuffix => 'Tancar pestanya';

  @override
  String get scrollTabBackwardLabel => 'Fer scroll cap enrere';

  @override
  String get scrollTabForwardLabel => 'Fer scroll cap endavant';

  @override
  String get noResultsFoundLabel => 'No s\'han trobat resultats';

  @override
  String get copyActionTooltip =>
      'Copiar el contingut seleccionat al porta-retalls';

  @override
  String get cutActionTooltip =>
      'Tallar el contingut seleccionat i posar-lo al porta-retalls';

  @override
  String get pasteActionTooltip =>
      'Inserir el contingut del porta-retalls a la posició actual';

  @override
  String get selectAllActionTooltip => 'Seleccionar tot el contingut';

  @override
  String get hour => 'hora';

  @override
  String get minute => 'minut';

  @override
  String get am => 'AM';

  @override
  String get pm => 'PM';

  @override
  String get month => 'mes';

  @override
  String get day => 'dia';

  @override
  String get year => 'any';

  @override
  String get redLabel => 'Vermell';

  @override
  String get greenLabel => 'Verd';

  @override
  String get blueLabel => 'Blau';

  @override
  String get opacityLabel => 'Opacitat';

  @override
  String get hueLabel => 'Tonalitat';

  @override
  String get saturationLabel => 'Saturació';

  @override
  String get valueLabel => 'Valor';

  @override
  String get moreText => 'Més';

  @override
  String get lessText => 'Menys';

  @override
  String valueSliderTooltip(int value, String colorName) {
    return 'Valor $value ($colorName)';
  }

  @override
  String alphaSliderTooltip(int value) {
    return '$value% Opacitat';
  }

  @override
  String get colorBlack => 'Negre';

  @override
  String get colorNavy => 'Blau fosc';

  @override
  String get colorDarkBlue => 'Blau fosc';

  @override
  String get colorMediumBlue => 'Blau';

  @override
  String get colorBlue => 'Blau';

  @override
  String get colorDarkGreen => 'Verd fosc';

  @override
  String get colorGreen => 'Verd fosc';

  @override
  String get colorTeal => 'Verd blavós fosc';

  @override
  String get colorDarkCyan => 'Verd blavós fosc';

  @override
  String get colorDeepSkyBlue => 'Turquesa';

  @override
  String get colorDarkTurquoise => 'Aigua';

  @override
  String get colorMediumSpringGreen => 'Verd';

  @override
  String get colorLime => 'Verd';

  @override
  String get colorSpringGreen => 'Verd';

  @override
  String get colorCyan => 'Aigua';

  @override
  String get colorMidnightBlue => 'Blau fosc';

  @override
  String get colorDodgerBlue => 'Blau';

  @override
  String get colorLightSeaGreen => 'Verd blavós';

  @override
  String get colorForestGreen => 'Verd fosc';

  @override
  String get colorSeaGreen => 'Verd fosc';

  @override
  String get colorDarkSlateGray => 'Verd blavós fosc';

  @override
  String get colorLimeGreen => 'Verd';

  @override
  String get colorMediumSeaGreen => 'Verd';

  @override
  String get colorTurquoise => 'Verd blavós';

  @override
  String get colorRoyalBlue => 'Blau';

  @override
  String get colorSteelBlue => 'Gris blavós';

  @override
  String get colorDarkSlateBlue => 'Porpra';

  @override
  String get colorMediumTurquoise => 'Verd blavós';

  @override
  String get colorIndigo => 'Porpra fosc';

  @override
  String get colorDarkOliveGreen => 'Verd fosc';

  @override
  String get colorCadetBlue => 'Verd blavós';

  @override
  String get colorCornflowerBlue => 'Blau';

  @override
  String get colorMediumAquamarine => 'Verd';

  @override
  String get colorDimGray => 'Gris';

  @override
  String get colorSlateBlue => 'Anyil';

  @override
  String get colorOliveDrab => 'Verd fosc';

  @override
  String get colorSlateGray => 'Gris blavós';

  @override
  String get colorLightSlateGray => 'Gris blavós';

  @override
  String get colorMediumSlateBlue => 'Blau clar';

  @override
  String get colorLawnGreen => 'Verd';

  @override
  String get colorChartreuse => 'Verd';

  @override
  String get colorAquamarine => 'Verd clar';

  @override
  String get colorMaroon => 'Vermell fosc';

  @override
  String get colorPurple => 'Porpra fosc';

  @override
  String get colorOlive => 'Groc fosc';

  @override
  String get colorGray => 'Gris';

  @override
  String get colorSkyBlue => 'Turquesa clar';

  @override
  String get colorLightSkyBlue => 'Blau clar';

  @override
  String get colorBlueViolet => 'Porpra';

  @override
  String get colorDarkRed => 'Vermell fosc';

  @override
  String get colorDarkMagenta => 'Porpra fosc';

  @override
  String get colorSaddleBrown => 'Marró';

  @override
  String get colorDarkSeaGreen => 'Verd';

  @override
  String get colorLightGreen => 'Verd clar';

  @override
  String get colorMediumPurple => 'Lavanda';

  @override
  String get colorDarkViolet => 'Porpra';

  @override
  String get colorPaleGreen => 'Verd clar';

  @override
  String get colorDarkOrchid => 'Porpra';

  @override
  String get colorYellowGreen => 'Verd';

  @override
  String get colorSienna => 'Canyella';

  @override
  String get colorBrown => 'Vermell';

  @override
  String get colorDarkGray => 'Gris';

  @override
  String get colorLightBlue => 'Blau cel';

  @override
  String get colorGreenYellow => 'Verd';

  @override
  String get colorPaleTurquoise => 'Aigua';

  @override
  String get colorLightSteelBlue => 'Blau gel';

  @override
  String get colorPowderBlue => 'Blau cel';

  @override
  String get colorFirebrick => 'Vermell';

  @override
  String get colorDarkGoldenrod => 'Groc fosc';

  @override
  String get colorMediumOrchid => 'Porpra';

  @override
  String get colorRosyBrown => 'Coral';

  @override
  String get colorDarkKhaki => 'Canyella';

  @override
  String get colorSilver => 'Gris clar';

  @override
  String get colorMediumVioletRed => 'Rosa';

  @override
  String get colorIndianRed => 'Vermell';

  @override
  String get colorPeru => 'Canyella';

  @override
  String get colorChocolate => 'Taronja';

  @override
  String get colorTan => 'Canyella';

  @override
  String get colorLightGray => 'Gris clar';

  @override
  String get colorThistle => 'Lavanda';

  @override
  String get colorOrchid => 'Lavanda';

  @override
  String get colorGoldenrod => 'Or';

  @override
  String get colorPaleVioletRed => 'Rosa clar';

  @override
  String get colorCrimson => 'Vermell';

  @override
  String get colorGainsboro => 'Gris clar';

  @override
  String get colorPlum => 'Rosa';

  @override
  String get colorBurlyWood => 'Canyella';

  @override
  String get colorLightCyan => 'Blau cel';

  @override
  String get colorLavender => 'Blau clar';

  @override
  String get colorDarkSalmon => 'Rosa clar';

  @override
  String get colorViolet => 'Lavanda';

  @override
  String get colorPaleGoldenrod => 'Groc clar';

  @override
  String get colorLightCoral => 'Rosa clar';

  @override
  String get colorKhaki => 'Groc clar';

  @override
  String get colorAliceBlue => 'Blanc';

  @override
  String get colorHoneydew => 'Blanc';

  @override
  String get colorAzure => 'Blanc';

  @override
  String get colorSandyBrown => 'Taronja clar';

  @override
  String get colorWheat => 'Groc clar';

  @override
  String get colorBeige => 'Groc clar';

  @override
  String get colorWhiteSmoke => 'Blanc';

  @override
  String get colorMintCream => 'Blanc';

  @override
  String get colorGhostWhite => 'Blanc';

  @override
  String get colorSalmon => 'Rosa clar';

  @override
  String get colorAntiqueWhite => 'Taronja clar';

  @override
  String get colorLinen => 'Taronja clar';

  @override
  String get colorLightGoldenrodYellow => 'Groc clar';

  @override
  String get colorOldLace => 'Blanc';

  @override
  String get colorRed => 'Vermell';

  @override
  String get colorMagenta => 'Porpra';

  @override
  String get colorDeepPink => 'Rosa';

  @override
  String get colorOrangeRed => 'Vermell';

  @override
  String get colorTomato => 'Vermell';

  @override
  String get colorHotPink => 'Rosa';

  @override
  String get colorCoral => 'Vermell';

  @override
  String get colorDarkOrange => 'Taronja';

  @override
  String get colorLightSalmon => 'Rosa clar';

  @override
  String get colorOrange => 'Or';

  @override
  String get colorLightPink => 'Rosa clar';

  @override
  String get colorPink => 'Rosa clar';

  @override
  String get colorGold => 'Or';

  @override
  String get colorPeachPuff => 'Taronja clar';

  @override
  String get colorNavajoWhite => 'Taronja clar';

  @override
  String get colorMoccasin => 'Taronja clar';

  @override
  String get colorBisque => 'Taronja clar';

  @override
  String get colorMistyRose => 'Rosa clar';

  @override
  String get colorBlanchedAlmond => 'Taronja clar';

  @override
  String get colorPapayaWhip => 'Taronja clar';

  @override
  String get colorLavenderBlush => 'Blanc';

  @override
  String get colorSeaShell => 'Blanc';

  @override
  String get colorCornsilk => 'Groc clar';

  @override
  String get colorLemonChiffon => 'Groc clar';

  @override
  String get colorFloralWhite => 'Blanc';

  @override
  String get colorSnow => 'Blanc';

  @override
  String get colorYellow => 'Groc';

  @override
  String get colorLightYellow => 'Groc clar';

  @override
  String get colorIvory => 'Blanc';

  @override
  String get colorWhite => 'Blanc';
}
